"use strict";(self.webpackChunkbaf=self.webpackChunkbaf||[]).push([[4191],{6259:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>d,contentTitle:()=>s,default:()=>m,frontMatter:()=>r,metadata:()=>l,toc:()=>c});var i=n(7896),a=(n(2784),n(876)),o=n(3002);const r={id:"baf_web_component",title:"Web component",sidebar_label:"Web component"},s=void 0,l={unversionedId:"user_guide/baf_web_component",id:"user_guide/baf_web_component",title:"Web component",description:"A web component is a user interface used to collect data about a user and their device, perform biometric checks, and send data to a server. It is integrated into the existing system on the front-end side and serves as an additional layer of user biometric verification.",source:"@site/docs/user_guide/baf_web_component.mdx",sourceDirName:"user_guide",slug:"/user_guide/baf_web_component",permalink:"/user_guide/baf_web_component",draft:!1,tags:[],version:"current",frontMatter:{id:"baf_web_component",title:"Web component",sidebar_label:"Web component"},sidebar:"docs",previous:{title:"Report control",permalink:"/user_guide/api_baf_reports"},next:{title:"Verification requests",permalink:"/user_guide/dashboard_verification_requests"}},d={},c=[{value:"How it works",id:"how-it-works",level:3},{value:"Installing web components",id:"installing-web-components",level:3},{value:"Importing and using a web component",id:"importing-and-using-a-web-component",level:3},{value:"Interaction of a web component with an external system",id:"interaction-of-a-web-component-with-an-external-system",level:3},{value:"Localization",id:"localization",level:3},{value:"Stylization",id:"stylization",level:3},{value:"Server version compatibility table and web components:",id:"server-version-compatibility-table-and-web-components",level:3}],h={toc:c},p="wrapper";function m(e){let{components:t,...n}=e;return(0,a.kt)(p,(0,i.Z)({},h,n,{components:t,mdxType:"MDXLayout"}),(0,a.kt)("p",null,"A web component is a user interface used to collect data about a user and their device, perform biometric checks, and send data to a server. It is integrated into the existing system on the front-end side and serves as an additional layer of user biometric verification."),(0,a.kt)("h3",{id:"how-it-works"},"How it works"),(0,a.kt)("p",null,"The behavior of the web component is determined by its configuration settings and can change accordingly. The complete algorithm looks like this:"),(0,a.kt)("ol",null,(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"The web component is being initialized"),(0,a.kt)("p",{parentName:"li"},"The web component receives configuration from the front-end of the project, in which it is embedded and from the BAF server via its API. Once the configuration is received from the server, the configurations are combined into one. "),(0,a.kt)("blockquote",{parentName:"li"},(0,a.kt)("p",{parentName:"blockquote"},"If the same parameter is defined in both the client and server configurations, the value from the client configuration takes precedence.")),(0,a.kt)("p",{parentName:"li"},"After merging the configurations, the web component initializes the necessary services for operation, including the face detector, video recording modules, and other required components.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"The web component determines if the user exists in the BAF system and checks their current status"),(0,a.kt)("p",{parentName:"li"},"The user is identified using a unique user ID, which can either be transmitted from an external system or defined directly within the web component via a form where the user enters their information. Once identified, the user\u2019s status is checked in the BAF system. If the status is valid, the user is allowed to proceed; otherwise, the web component displays an error message indicating the invalid status and blocks further access."),(0,a.kt)("p",{parentName:"li"},"If the unique user ID is provided through the configuration, the form will be skipped, and the status check will be performed immediately.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"The web component gets access to the webcam of the user's device"),(0,a.kt)("p",{parentName:"li"},"The web component requests access to the user\u2019s webcam. If a device is found and access is granted, it displays the video stream; otherwise, it shows an error message. If multiple devices are available, the user is given the option to select which one to use.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},'"Motion Control" biometric check'),(0,a.kt)("p",{parentName:"li"},"The web component generates a series of commands for the user to perform in front of the camera. These commands include: turning the head to the left, turning the head to the right, raising the head, moving closer to the camera, and moving away from the camera."),(0,a.kt)("p",{parentName:"li"},"During this check, frames containing the user\u2019s face are captured. These frames are then used for additional server-side checks, such as facial liveness detection, image quality assessment, and others.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"Biometric verification of the user's face"),(0,a.kt)("p",{parentName:"li"},'This is an auxiliary stage that is activated when the "Motion Control" biometric check is enabled.'),(0,a.kt)("p",{parentName:"li"},"The web component captures the user\u2019s head position and extracts frames containing the user\u2019s face, which are then used for additional server-side checks, such as facial liveness, image quality, and others.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"Validation of the collected data and the results of biometric checks"),(0,a.kt)("p",{parentName:"li"},"The web component generates a fingerprint of the user's device, sends all the collected data to the server and receives the user's path verification in response."))),(0,a.kt)("h3",{id:"installing-web-components"},"Installing web components"),(0,a.kt)("p",null,"The component is supplied as a TGZ ",(0,a.kt)("strong",{parentName:"p"},"tdvc-face-onboarding")," archive. It also requires the ",(0,a.kt)("inlineCode",{parentName:"p"},"tdvc")," library, which is supplied separately as an archive."),(0,a.kt)("ol",null,(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"Move the archives to the root folder of your project and add the following lines to your ",(0,a.kt)("strong",{parentName:"p"},"package.json")," in the dependencies section:"),(0,a.kt)("pre",{parentName:"li"},(0,a.kt)("code",{parentName:"pre",className:"language-javascript"},'"@tdvc/face-onboarding": "file:tdvc-face-onboarding-{version}.tgz"\n')),(0,a.kt)("p",{parentName:"li"},"The archive version may vary. An example of the final ",(0,a.kt)("strong",{parentName:"p"},"package file.json"),":"),(0,a.kt)("pre",{parentName:"li"},(0,a.kt)("code",{parentName:"pre",className:"language-javascript"},'"dependencies": {\n    "@tdvc/face-onboarding": "file:tdvc-face-onboarding-1.0.0.tgz"\n}\n'))),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"Call the `npm install' command, which will install the library in your project.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},"For the web component to work correctly, you need to add a number of files to the directory where your project's static resources are stored, usually the ",(0,a.kt)("strong",{parentName:"p"},"public")," directory. After installing the package, move the ",(0,a.kt)("strong",{parentName:"p"},"networks")," folder from ",(0,a.kt)("strong",{parentName:"p"},"/node_modules/@tdvc/face-onboarding/")," and ",(0,a.kt)("strong",{parentName:"p"},"frame_handler_worker.js")," from ",(0,a.kt)("strong",{parentName:"p"},"/node_modules/@tdvc/face-onboarding/dist")," to the ",(0,a.kt)("strong",{parentName:"p"},"public")," directory."))),(0,a.kt)("h3",{id:"importing-and-using-a-web-component"},"Importing and using a web component"),(0,a.kt)("ol",null,(0,a.kt)("li",{parentName:"ol"},"Import the library and the styles for it."),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("a",{parentName:"li",href:"/user_guide/dashboard_web_components#create-a-web-component"},"Create the integration of the web components on the server.")),(0,a.kt)("li",{parentName:"ol"},"Define the configuration of the web component."),(0,a.kt)("li",{parentName:"ol"},"Launch the project.")),(0,a.kt)("p",null,"Example of initializing a component in TypeScript:"),(0,a.kt)("pre",null,(0,a.kt)("code",{parentName:"pre",className:"language-javascript"},"import tdvc from '@tdvc/face-onboarding';\nimport {\n    TDVAthorizationOnboarding,\n    TDVRegistrationOnboarding,\n} from '@tdvc/face-onboarding/dist/class';\nimport { ComponentSettingsFromClient } from '@tdvc/face-onboarding/dist/class/configuration';\nimport '@tdvc/face-onboarding/dist/css/style.css';\n\nlet lib: TDVRegistrationOnboarding | TDVAthorizationOnboarding;\n\nconst config: ComponentSettingsFromClient = {\n    mountElement: 'app',\n    baseUrl: '/',\n    integrationId: '225c74bb-4eb1-4c81-9199-832dff3806eb',\n};\n\nfunction run() {\n    if (window.location.pathname === '/registration') {\n        lib = new tdvc.Register(config);\n    } else {\n        lib = new tdvc.Authorization(config);\n    }\n}\n\nwindow.onload = async () => {\n    run();\n};\n\nwindow.onbeforeunload = () => {\n    lib?.destroy();\n};\n")),(0,a.kt)("h3",{id:"interaction-of-a-web-component-with-an-external-system"},"Interaction of a web component with an external system"),(0,a.kt)("p",null,"Interactions between the web component and external systems are handled using callback functions (callbacks). The system determines its event-processing logic based on the data provided by these functions or on the fact that the callback was triggered. Several such functions are defined in the component\u2019s configuration:"),(0,a.kt)("ol",null,(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onMounted: (() => void)")," \u2014 a function that is called when the web component is fully initialized.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onError: ((message: string, code: string) => void)")," \u2014 a function that is called if an error occurred while traversing the user path.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onUpdate: (() => void)")," \u2014 a function that is called if, after an error occurs, the user wants to try again to traverse the user's path.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onIdentifyApplicantStatus: (applicant: {applicantId: string, status: number}) => void")," \u2014 a function that is called after receiving the applicant status from the server.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onBack: (() => void)"),' \u2014 a function that is called if the user clicks on the "Back" button while selecting the camera, and thereby stops going through the user\'s path.')),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onMotion: ((type: 'left' | 'right' | 'up' | 'closer' | 'farther' | 'return', result: boolean | undefined) => void)"),' \u2014 the function that is called during the biometric check "Motion Control". If the result value is undefined, then the verification has just begun, if true - successfully passed, if false - failed.')),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onGetReferenceImages: (referenceImages: string[]) => void"),"; \u2014 a function that is called when the best face frames are collected. referenceImages are images in the base64 string format.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onStartValidation: (() => void)")," \u2014 the function that is called before the validation of the results begins.")),(0,a.kt)("li",{parentName:"ol"},(0,a.kt)("p",{parentName:"li"},(0,a.kt)("inlineCode",{parentName:"p"},"onValidate: ((data: any) => void)")," \u2014 the function that is called after receiving the result of data validation from the server."))),(0,a.kt)("h3",{id:"localization"},"Localization"),(0,a.kt)("p",null,"By default, the web component supports two localizations: Russian and English, and the default interface language is English. The localization of the component can be changed via configuration at the time of initialization of the web component. To do this, specify the ",(0,a.kt)("inlineCode",{parentName:"p"},"language")," and ",(0,a.kt)("inlineCode",{parentName:"p"},"locale")," fields in the config."),(0,a.kt)("p",null,"An example of changing the English localization to TypeScript:"),(0,a.kt)("pre",null,(0,a.kt)("code",{parentName:"pre",className:"language-javascript"},"import tdvc from '@tdvc/face-onboarding';\nimport { ComponentSettingsFromClient } from '@tdvc/face-onboarding/dist/class/configuration'\n\nconst config: ComponentSettingsFromClient = {\n    mountElement: 'app',\n    baseUrl: '/',\n    integrationId: '225c74bb-4eb1-4c81-9199-832dff3806eb',\n    locales: {\n        // If you want to leave the Russian localization by default\n        ...tdvc.DefaultLocales.ru,\n        // Editing the English localization\n        en: {\n            // We leave the others of this localization by default\n            ...tdvc.DefaultLocales.en,\n            Login: {\n                // Leaving other locales of this block by default\n                ...tdvc.DefaultLocales.en.Login,\n                // Editing the desired message\n                IsRequired: 'New locale message',\n            },\n        },\n    },\n};\n")),(0,a.kt)("p",null,"To add a new localization, prepare a Java Script object that will contain all the same fields as the object with the English localization and define the text in the required language for each message identifier. The localization object that can be used as an example can be found in the README.md file in the delivery archive. "),(0,a.kt)("p",null,"An example of adding a new localization to TypeScript:"),(0,a.kt)("pre",null,(0,a.kt)("code",{parentName:"pre",className:"language-javascript"},"import tdvc from '@tdvc/face-onboarding';\nimport { ComponentSettingsFromClient } from '@tdvc/face-onboarding/dist/class/configuration'\n\nconst config: ComponentSettingsFromClient = {\n    mountElement: 'app',\n    baseUrl: '/',\n    integrationId: '225c74bb-4eb1-4c81-9199-832dff3806eb',\n    language: 'fr',\n    locales: {\n        // If you want to leave the Russian and English localization by default\n        ...tdvc.DefaultLocales,\n        // The key of the object must match the value in the language field\n        fr: {\n            Login: {\n                IsRequired: 'Nouveau message de param\xe8tres r\xe9gionaux',\n                ...\n            },\n            ...\n        },\n    },\n};\n")),(0,a.kt)("h3",{id:"stylization"},"Stylization"),(0,a.kt)("p",null,"The styling of the web component is done through CSS. Interface elements contain identifiers and CSS classes through which you can customize their appearance."),(0,a.kt)("p",null,"The identifiers and CSS classes used for customization can be found in the ",(0,a.kt)("strong",{parentName:"p"},"@tdvc/face-onboarding/dist/css/style.css file.")),(0,a.kt)("h3",{id:"server-version-compatibility-table-and-web-components"},"Server version compatibility table and web components:"),(0,a.kt)("table",null,(0,a.kt)("tbody",null,(0,a.kt)("tr",null,(0,a.kt)("td",{class:"center-aligned",width:"400"},(0,a.kt)("b",null,(0,a.kt)(o.$Y,{mdxType:"ShortProductName"}))),(0,a.kt)("td",{class:"center-aligned",width:"400"},(0,a.kt)("b",null,"@tdvc/face-onboarding")),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{class:"center-aligned",width:"400"},(0,a.kt)("b",null,"@tdvc/document-onboarding")))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.14.*"),(0,a.kt)("td",{width:"400"},"1.14.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.13.*"),(0,a.kt)("td",{width:"400"},"1.13.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.12.*"),(0,a.kt)("td",{width:"400"},"1.12.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.10.*"),(0,a.kt)("td",{width:"400"},"1.10.*-1.11.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.9.*"),(0,a.kt)("td",{width:"400"},"1.9.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.8.*"),(0,a.kt)("td",{width:"400"},"1.8.*"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.7.0"),(0,a.kt)("td",{width:"400"},"1.7.0"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.5.0-1.7.0"),(0,a.kt)("td",{width:"400"},"1.6.0-1.6.3"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.5.0"),(0,a.kt)("td",{width:"400"},"1.5.0"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.3.0-1.4.0"),(0,a.kt)("td",{width:"400"},"1.4.0-1.4.1"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.3.0-1.3.1"),(0,a.kt)("td",{width:"400"},"1.3.1"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.3.0-1.3.1"),(0,a.kt)("td",{width:"400"},"1.3.1"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.2.0"),(0,a.kt)("td",{width:"400"},"1.2.0-1.3.0"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.1.0"),(0,a.kt)("td",{width:"400"},"1.0.0-1.1.2"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))),(0,a.kt)("tr",null,(0,a.kt)("td",{width:"400"},"1.0.0"),(0,a.kt)("td",{width:"400"},"1.0.0"),(0,a.kt)(o.GP,{mdxType:"OnlyWithDocs"},(0,a.kt)("td",{width:"400"},"1.0.0"))))))}m.isMDXComponent=!0}}]);