"use strict";(self.webpackChunkbaf=self.webpackChunkbaf||[]).push([[3703],{3770:(e,t,a)=>{a.r(t),a.d(t,{assets:()=>s,contentTitle:()=>d,default:()=>m,frontMatter:()=>r,metadata:()=>l,toc:()=>c});var n=a(7896),i=(a(2784),a(876)),o=a(3002);const r={id:"retention_config",title:"Scheduled data cleanup configuration",sidebar_label:"Scheduled data cleanup configuration"},d=void 0,l={unversionedId:"administrator_guide/retention_config",id:"administrator_guide/retention_config",title:"Scheduled data cleanup configuration",description:"This section describes the principles of the planned cleanup system and its proper configuration at the service level.",source:"@site/docs/administrator_guide/retention_config.mdx",sourceDirName:"administrator_guide",slug:"/administrator_guide/retention_config",permalink:"/administrator_guide/retention_config",draft:!1,tags:[],version:"current",frontMatter:{id:"retention_config",title:"Scheduled data cleanup configuration",sidebar_label:"Scheduled data cleanup configuration"},sidebar:"docs",previous:{title:"How to tune system performance",permalink:"/administrator_guide/tuning_system_performance"},next:{title:"Use cases",permalink:"/baf_use_cases"}},s={},c=[{value:"platform-backend",id:"platform-backend",level:2},{value:"Cleanup schedule and parameters",id:"cleanup-schedule-and-parameters",level:4},{value:"Backward compatibility mode",id:"backward-compatibility-mode",level:4},{value:"Planned cleanup mode",id:"planned-cleanup-mode",level:4},{value:"video-recorder",id:"video-recorder",level:2},{value:"Cleanup schedule and parameters",id:"cleanup-schedule-and-parameters-1",level:4},{value:"Working with MinIO features",id:"working-with-minio-features",level:4},{value:"Backward compatibility mode",id:"backward-compatibility-mode-1",level:4},{value:"Planned cleanup mode",id:"planned-cleanup-mode-1",level:4}],p={toc:c},u="wrapper";function m(e){let{components:t,...a}=e;return(0,i.kt)(u,(0,n.Z)({},p,a,{components:t,mdxType:"MDXLayout"}),(0,i.kt)("p",null,"This section describes the principles of the planned cleanup system and its proper configuration at the service level."),(0,i.kt)("p",null,"The cleanup system is responsible for deleting outdated data and allows you to configure the cleanup schedule using cron expressions."),(0,i.kt)("p",null,"The management point is the ",(0,i.kt)("strong",{parentName:"p"},"baf-dashboard")," service, while the actual data deletion is performed by the ",(0,i.kt)("strong",{parentName:"p"},"platform-backend")," and ",(0,i.kt)("strong",{parentName:"p"},"video-recorder")," services."),(0,i.kt)("h2",{id:"platform-backend"},"platform-backend"),(0,i.kt)("p",null,"The service is responsible for deleting outdated authorization attempt photos. Registration attempt photos are only deleted when the applicant is deleted."),(0,i.kt)("p",null,"All cleanup configuration parameters are located in the ",(0,i.kt)("em",{parentName:"p"},"platform.values.yaml")," file."),(0,i.kt)("h4",{id:"cleanup-schedule-and-parameters"},"Cleanup schedule and parameters"),(0,i.kt)("p",null,"The cleanup procedure runs on a schedule configured via the following variables:"),(0,i.kt)("ul",null,(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"backend.planned_retention_policy_day_of_week")," - day of the week (cron)"),(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"backend.planned_retention_policy_hour")," - hour (cron)"),(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"backend.planned_retention_policy_minute")," - minute (cron)")),(0,i.kt)("p",null,"In standard settings, the period is set to the 59th minute of every hour, meaning cleanup runs hourly."),(0,i.kt)("p",null,"Data deletion is performed in batches to distribute the load:"),(0,i.kt)("ul",null,(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"backend.delete_sample_batch_size")," - number of frames deleted per operation"),(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"backend.delete_sample_batch_sleep")," - pause in seconds between deletion operations")),(0,i.kt)("p",null,"The number of parallel cleanup processes is configured via ",(0,i.kt)("inlineCode",{parentName:"p"},"backend.retention_process_count"),". Increasing the number of processes allows parallel cleanup of data from different accounts, while data from one account is always processed by a single process."),(0,i.kt)("admonition",{type:"note"},(0,i.kt)("p",{parentName:"admonition"},"Do not set ",(0,i.kt)("inlineCode",{parentName:"p"},"delete_sample_batch_sleep")," to more than 5 seconds - this directly affects transaction duration in the system. To reduce load, it's better to decrease the batch size.")),(0,i.kt)("h4",{id:"backward-compatibility-mode"},"Backward compatibility mode"),(0,i.kt)("p",null,"When starting the service on a clean database or on ",(0,i.kt)(o.$Y,{mdxType:"ShortProductName"})," version 1.14.0 and higher, the procedure operates in backward compatibility mode.\nIn this mode, photos from attempts created earlier than ",(0,i.kt)("inlineCode",{parentName:"p"},"backend.sample_ttl")," from the procedure's start time are deleted."),(0,i.kt)("p",null,"The procedure transitions to the new operation mode after someone visits the cleanup settings page in the dashboard."),(0,i.kt)("admonition",{type:"note"},(0,i.kt)("p",{parentName:"admonition"},"The mode operates individually for each account - transitioning to the new mode in one account does not affect other accounts.")),(0,i.kt)("h4",{id:"planned-cleanup-mode"},"Planned cleanup mode"),(0,i.kt)("p",null,"After transitioning to planned cleanup mode, the procedure checks whether cleanup should be performed at the current moment. If the scheduled time has not arrived or cleanup is disabled, the procedure completes without taking action. If the conditions are met, data cleanup is launched from the planned date, calculated from the cleanup settings."),(0,i.kt)("p",null,"In standard settings, the physical start time for data deletion may be shifted by up to 1 hour, as the procedure runs hourly."),(0,i.kt)("h2",{id:"video-recorder"},"video-recorder"),(0,i.kt)("p",null,"The service is responsible for deleting outdated video data from attempts."),(0,i.kt)("p",null,"All cleanup configuration parameters are located in the ",(0,i.kt)("em",{parentName:"p"},"video-recorder.values.yaml")," file."),(0,i.kt)("h4",{id:"cleanup-schedule-and-parameters-1"},"Cleanup schedule and parameters"),(0,i.kt)("p",null,"The procedure runs similarly to the ",(0,i.kt)("strong",{parentName:"p"},"platform-backend")," service, but the check frequency is configured via the variable:"),(0,i.kt)("ul",null,(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"video_recorder.retention_check_frequency")," - frequency of cleanup check procedure execution in seconds (maximum period - 1 hour)")),(0,i.kt)("p",null,"In standard settings, the frequency is set to 1200 seconds, meaning cleanup runs every 20 minutes."),(0,i.kt)("p",null,"Data deletion is performed in batches to distribute the load:"),(0,i.kt)("ul",null,(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"video_recorder.retention_batch_size")," - number of records deleted per operation"),(0,i.kt)("li",{parentName:"ul"},(0,i.kt)("inlineCode",{parentName:"li"},"video_recorder.retention_batch_pause")," - pause in seconds between deletion operations")),(0,i.kt)("p",null,"The number of parallel cleanup processes is configured via ",(0,i.kt)("inlineCode",{parentName:"p"},"video_recorder.retention_process_count"),".\nIncreasing the number of processes speeds up data cleanup for different accounts, while data from one account is always processed by a single process."),(0,i.kt)("admonition",{type:"note"},(0,i.kt)("p",{parentName:"admonition"},"Do not set ",(0,i.kt)("inlineCode",{parentName:"p"},"video_recorder.retention_batch_pause")," to more than 5 seconds - this directly affects transaction duration in the system. To reduce load, it's better to decrease the batch size.")),(0,i.kt)("h4",{id:"working-with-minio-features"},"Working with MinIO features"),(0,i.kt)("p",null,"S3 storage does not delete data immediately, but moves it to the ",(0,i.kt)("inlineCode",{parentName:"p"},".trash")," folder, which is cleaned up every ",(0,i.kt)("inlineCode",{parentName:"p"},"minio.delete_cleanup_interval")," seconds."),(0,i.kt)("p",null,"It's important that the volume of data deleted by ",(0,i.kt)("strong",{parentName:"p"},"video-recorder")," during this period does not cause an I/O storm. When changing the batch size or pause duration, it's necessary to adjust ",(0,i.kt)("inlineCode",{parentName:"p"},"minio.delete_cleanup_interval")," accordingly."),(0,i.kt)("h4",{id:"backward-compatibility-mode-1"},"Backward compatibility mode"),(0,i.kt)("p",null,"The service does not have a backward compatibility mode. When upgrading ",(0,i.kt)(o.$Y,{mdxType:"ShortProductName"})," from version 1.14.0 and higher, data cleanup via MinIO is disabled. Until planned cleanup is enabled, data is stored indefinitely."),(0,i.kt)("admonition",{type:"note"},(0,i.kt)("p",{parentName:"admonition"},"Erroneous content is still deleted via MinIO - data older than ",(0,i.kt)("inlineCode",{parentName:"p"},"minio.error_data_retention_days")," is automatically deleted.")),(0,i.kt)("h4",{id:"planned-cleanup-mode-1"},"Planned cleanup mode"),(0,i.kt)("p",null,"The logic of planned cleanup operation is similar to the ",(0,i.kt)("strong",{parentName:"p"},"platform-backend")," service. After transitioning to this mode, the procedure checks whether cleanup should be performed. If the scheduled time has not arrived or cleanup is disabled, the procedure completes without taking action. If the conditions are met, data cleanup is launched from the calculated planned date."),(0,i.kt)("p",null,"In standard settings, the physical start time for data deletion may be shifted by up to 20 minutes, as the procedure runs every 20 minutes."))}m.isMDXComponent=!0}}]);