import { TWebGLInfo } from './types';
export declare const successWebglInfo: TWebGLInfo;
export declare const browserSuccessWebglInfo: {
    webGL: {
        result: {
            gpuHash: string;
            gpu: string;
            gpuBrand: string;
            debugRendererInfo: {
                UNMASKED_VENDOR_WEBGL: string;
                UNMASKED_RENDERER_WEBGL: string;
            };
            fragmentShader: {
                MAX_FRAGMENT_UNIFORM_VECTORS: number;
                MAX_TEXTURE_IMAGE_UNITS: number;
                FRAGMENT_SHADER_BEST_FLOAT_PRECISION: number[];
            };
            frameBuffer: {
                RGBA_BITS: number[];
                DEPTH_STENCIL_BITS: number[];
                MAX_RENDERBUFFER_SIZE: number;
                MAX_VIEWPORT_DIMS: number[];
            };
            rasterizer: {
                ALIASED_LINE_WIDTH_RANGE: number[];
                ALIASED_POINT_SIZE_RANGE: number[];
            };
            textures: {
                MAX_TEXTURE_SIZE: number;
                MAX_CUBE_MAP_TEXTURE_SIZE: number;
                MAX_COMBINED_TEXTURE_IMAGE_UNITS: number;
                MAX_TEXTURE_MAX_ANISOTROPY_EXT: number;
            };
            vertexShader: {
                MAX_VARYING_VECTORS: number;
                MAX_VERTEX_ATTRIBS: number;
                MAX_VERTEX_TEXTURE_IMAGE_UNITS: number;
                MAX_VERTEX_UNIFORM_VECTORS: number;
                VERTEX_SHADER_BEST_FLOAT_PRECISION: number[];
            };
            webGLContextInfo: {
                CONTEXT: string;
                ANTIALIAS: boolean;
                DIRECT_3D: boolean;
                RENDERER: string;
                SHADING_LANGUAGE_VERSION: string;
                VERSION: string;
            };
            webGLExtensions: string[];
        };
        errors: never[];
    };
    webGL2: {
        result: {
            gpuHash: string;
            gpu: string;
            gpuBrand: string;
            uniformBuffers: {
                MAX_UNIFORM_BUFFER_BINDINGS: number;
                MAX_UNIFORM_BLOCK_SIZE: number;
                UNIFORM_BUFFER_OFFSET_ALIGNMENT: number;
                MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: number;
                MAX_COMBINED_UNIFORM_BLOCKS: number;
                MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: number;
            };
            debugRendererInfo: {
                UNMASKED_VENDOR_WEBGL: string;
                UNMASKED_RENDERER_WEBGL: string;
            };
            fragmentShader: {
                MAX_FRAGMENT_UNIFORM_VECTORS: number;
                MAX_TEXTURE_IMAGE_UNITS: number;
                MAX_FRAGMENT_INPUT_COMPONENTS: number;
                MAX_FRAGMENT_UNIFORM_COMPONENTS: number;
                MAX_FRAGMENT_UNIFORM_BLOCKS: number;
                FRAGMENT_SHADER_BEST_FLOAT_PRECISION: number[];
                MIN_PROGRAM_TEXEL_OFFSET: number;
                MAX_PROGRAM_TEXEL_OFFSET: number;
            };
            frameBuffer: {
                MAX_DRAW_BUFFERS: number;
                MAX_COLOR_ATTACHMENTS: number;
                MAX_SAMPLES: number;
                RGBA_BITS: number[];
                DEPTH_STENCIL_BITS: number[];
                MAX_RENDERBUFFER_SIZE: number;
                MAX_VIEWPORT_DIMS: number[];
            };
            rasterizer: {
                ALIASED_LINE_WIDTH_RANGE: number[];
                ALIASED_POINT_SIZE_RANGE: number[];
            };
            textures: {
                MAX_TEXTURE_SIZE: number;
                MAX_CUBE_MAP_TEXTURE_SIZE: number;
                MAX_COMBINED_TEXTURE_IMAGE_UNITS: number;
                MAX_TEXTURE_MAX_ANISOTROPY_EXT: number;
                MAX_3D_TEXTURE_SIZE: number;
                MAX_ARRAY_TEXTURE_LAYERS: number;
                MAX_TEXTURE_LOD_BIAS: number;
            };
            transformFeedback: {
                MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: number;
                MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: number;
                MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: number;
            };
            vertexShader: {
                MAX_VARYING_VECTORS: number;
                MAX_VERTEX_ATTRIBS: number;
                MAX_VERTEX_TEXTURE_IMAGE_UNITS: number;
                MAX_VERTEX_UNIFORM_VECTORS: number;
                MAX_VERTEX_UNIFORM_COMPONENTS: number;
                MAX_VERTEX_UNIFORM_BLOCKS: number;
                MAX_VERTEX_OUTPUT_COMPONENTS: number;
                MAX_VARYING_COMPONENTS: number;
                VERTEX_SHADER_BEST_FLOAT_PRECISION: number[];
            };
            webGLContextInfo: {
                CONTEXT: string;
                ANTIALIAS: boolean;
                DIRECT_3D: boolean;
                RENDERER: string;
                SHADING_LANGUAGE_VERSION: string;
                VERSION: string;
            };
            webGLExtensions: string[];
        };
        errors: never[];
    };
};
