export type RecursivePartial<T> = {
    [P in keyof T]?: T[P] extends object ? RecursivePartial<T[P]> : T[P];
};
export type Resolution = {
    width: number;
    height: number;
};
export type RGBAColor = {
    r: number;
    g: number;
    b: number;
    alpha: number;
};
export type Point = {
    x: number;
    y: number;
};
export type EnabledModule = {
    enabled: boolean;
    order: number;
    description: StageDescriptionSettings;
};
export type StageDescriptionSettings = {
    enabled: boolean;
    autoSubmit: AutoSubmitSettings;
};
export type AutoSubmitSettings = {
    enabled: boolean;
    timer: number;
};
