import { HTMLContainer, View } from '../../view';
import './button.style.css';
export declare class Button extends View {
    private _element;
    private _textContent?;
    private _loadingSpinner;
    constructor({ id, cssClass, htmlContainer, textContent, handleClick, type, }: HTMLContainer & {
        id?: string;
        cssClass?: string;
        type?: 'submit' | 'reset' | 'button';
        textContent?: string;
        handleClick?: () => void | Promise<unknown>;
    });
    setId(id?: string): void;
    setCssClases(cssClass?: string): void;
    setTextContent(text?: string): void;
    setLoadingState(): void;
    removeLoadingState(): void;
    setDisabledState(): void;
    removeDisabledState(): void;
    setHandleClick(fn: (() => void | Promise<unknown>) | undefined): void;
    click(): void;
    render(): void;
    stopRender(): void;
    destroy(): void;
}
