import { BaseModule, ErrorModule, LoginModule, SuccessModule } from '../modules';
import { Applicant } from './applicant';
import { ComponentSettingsFromClient, Configuration } from './configuration';
import { ErrorHandler } from './error_handler';
export declare abstract class BaseClass {
    protected abstract targetAction: 'Registration' | 'Authorization';
    protected abstract localePageName: 'Register' | 'Login';
    protected mountElement: HTMLElement;
    protected targetActionHasBeenCompleted: boolean;
    protected applicant?: Applicant;
    protected _configuration: Configuration;
    protected errorHandler?: ErrorHandler;
    protected loginModule: LoginModule;
    protected baseModule: BaseModule;
    protected successModule: SuccessModule;
    protected errorModule: ErrorModule;
    protected abstract targetActionFn(data: [string, FormDataEntryValue][], primaryField: string): Promise<void>;
    protected abstract drawPageByApplicantStatus(): void;
    constructor(config: ComponentSettingsFromClient);
    private _initLoger;
    private _initLocalizator;
    private _generateDeviceIdIfNotExistInLocaleStorage;
    private _logDeviceUUID;
    private _logDeviceUserAgent;
    private _logComponentVersion;
    private _tryInsertBaseHtml;
    private _validateHtmlContainerId;
    private _throwErrorIfHtmlContainerIdIsUndefined;
    private _throwErrorIfHtmlContainerIdIsEmptyString;
    private _throwErrorIfHtmlContainerByIdNotExistInDom;
    private _insertBaseHtml;
    private initComponent;
    private _initFaceRotationAngleService;
    private _initBestshotsCollectorService;
    private _initTdvcApi;
    private _initProcessingVideoStreamService;
    private _createProcessingVideoStreamService;
    private _tryInitFaceDetectorIfModelEnabled;
    private _createFaceDetector;
    private _tryLoadFaceDetectorResources;
    private redirectToPageByApplicantStatus;
    private _handleError;
    private method;
    private checkApplicantId;
    private handleRequestError;
    private onBack;
    protected onTargetActionHasBeenCompleted(): void;
    private destroyUI;
    destroy(): Promise<void>;
    private _destroyTdvcApi;
    private _destroyFaceDetector;
    private _destroyLogger;
    private _destroyLocalizator;
    private _destroyProcessingVideoStreamService;
    private _destroyFaceRotationService;
    private _destroyFaceBestshotCollectorService;
    private _removeUIFromContainer;
}
