import { PatternSettings } from '../../modules/base_module/motion_control_stage/services';
import { Locales } from '../../shared';
import { EnabledModule, RecursivePartial } from '../_core';
import { CameraResolutions } from '../camera';
import { FaceBorderSettings } from '../face';
import { OverlaySettings } from '../face/ui/ui.types';
export type TFaceModelConfig = {
    modelEnabled: boolean;
    timeToStartRecord: number;
};
export type TBLCallback = {
    onValidate?: (data: any) => void;
    onError?: (message: string, code: string) => void;
    onBack?: () => void;
    onMotion?: (type: 'left' | 'right' | 'up' | 'closer' | 'farther' | 'return', currentAttemptNumber: number, result?: boolean) => void;
    onUpdate?: () => void;
    onMounted?: () => void;
    onStartValidation?: () => void;
    onIdentifyApplicantStatus?: (applicant?: {
        applicantId: string;
        status: number;
    }) => void;
    onGetReferenceImages?: (referenceImages: string[]) => void;
};
export type ComponentConfiguration = {
    accountId: string;
    baseUrl: string;
    integrationId: string;
    mountElement: string;
    applicantId?: string;
    callbacks?: TBLCallback;
    networksPath: string;
    videoRecorderToken: string;
    videoRecorderDecryptionKey: string;
    showMetrics: boolean;
    livenessTransport: LivenessTransport;
    obtainReferenceFrame: boolean;
    autoSubmit: boolean;
    fingerprintWaitTime: number;
    iceCandidates: IceCandidates[];
    faceModelSettings: FaceDetectorSettings;
    cameraSettings: CameraSettings;
    faceBestshotSettings: FaceBestshotSettings;
    motionControl: MotionControlSettings;
    applicantFields: ApplicantFields;
    checkIceCandidateTimeout: number;
    clientServerConnectionSettings: ClientServerConnectionSettings;
};
export type ComponentSettingsFromClient = {
    baseUrl: string;
    integrationId: string;
    mountElement: string;
    networksPath?: string;
    applicantId?: string;
    language?: string;
    locales?: Locales;
    callbacks?: TBLCallback;
    fingerprintWaitTime?: number;
    showMetrics?: boolean;
    autoSubmit?: boolean;
    obtainReferenceFrame?: boolean;
    checkIceCandidateTimeout?: number;
    cameraSettings?: RecursivePartial<CameraSettings>;
    applicantFields?: RecursivePartial<ApplicantFields>;
    livenessTransport?: RecursivePartial<LivenessTransport>;
    faceModelSettings?: RecursivePartial<FaceDetectorSettings>;
    motionControl?: RecursivePartial<Omit<MotionControlSettings, 'patternSettings'>>;
    faceBestshotSettings?: RecursivePartial<FaceBestshotSettings>;
    clientServerConnectionSettings?: RecursivePartial<ClientServerConnectionSettings>;
};
export type ComponentMetaFromServer = {
    integrationId: string;
    domain: string;
    description: string;
    active: true;
    settings: ComponentSettingsFromServer;
};
export type ComponentSettingsFromServer = {
    accountId: string;
    networksPath: string;
    videoRecorderToken: string;
    videoRecorderDecryptionKey: string;
    showMetrics: boolean;
    livenessTransport: LivenessTransport;
    obtainReferenceFrame: boolean;
    autoSubmit: boolean;
    fingerprintWaitTime: number;
    iceCandidates: IceCandidates[];
    faceModelSettings: FaceDetectorSettings;
    cameraSettings: CameraSettings;
    applicantFields: ApplicantFields;
    motionControl: MotionControlSettings;
    faceBestshotSettings: FaceBestshotSettings;
    clientServerConnectionSettings: ClientServerConnectionSettings;
};
export declare enum LivenessTransport {
    WEB_RTC = "WebRTC",
    WEB_SOCKET = "WebSocket"
}
export type IceCandidates = {
    iceCandidateType: IceCandidateType;
    iceCandidateTransport: IceCandidateTransport;
    ipAddress: string;
    port: number;
};
export declare enum IceCandidateType {
    STUN = "stun",
    TURN = "turn"
}
export declare enum IceCandidateTransport {
    TCP = "tcp",
    UDP = "udp"
}
export type ApplicantFields = {
    firstName: ApplicantFieldSettings;
    lastName: ApplicantFieldSettings;
    phone: ApplicantFieldSettings;
    email: ApplicantFieldSettings;
    referenceId: ApplicantFieldSettings;
};
export type ApplicantFieldSettings = {
    enabled: boolean;
    primary: boolean;
};
export type FaceDetectorSettings = {
    modelEnabled: boolean;
    timeToStartRecord: number;
    angleСalculation: AngleСalculationSettings;
};
export type AngleСalculationSettings = {
    focalLength: number;
    angles: {
        left: number;
        right: number;
        up: number;
    };
};
export type FaceBestshotSettings = {
    faceBorder: FaceBorderSettings;
    facePositionValidation: FacePositionValidation;
    overlay: OverlaySettings;
};
export type FacePositionValidation = {
    enabled: boolean;
    allowableAccuracyError: number;
};
export type MotionControlSettings = EnabledModule & RetryAttempts & {
    imagesHints: ImagesHints;
    faceBorder: MotionControlFaceBorderSettings;
    overlay: OverlaySettings;
    timer: MotionControlTimers;
    patternSettings: PatternSettings;
    facePositionValidation: FacePositionValidation;
};
export type ImagesHints = {
    enabled: boolean;
    resourcesPath: string;
};
export type MotionControlFaceBorderSettings = FaceBorderSettings & {
    patternCoefficients: FaceBorderMotionControlPatternCoefficients;
};
export type FaceBorderMotionControlPatternCoefficients = {
    closer: number;
    farther: number;
};
export type MotionControlTimers = {
    beforeStart: number;
    checkFacePosition: number;
    cancelCheckCommand: number;
    betweenCommand: number;
};
export type RetryAttempts = {
    attemptsCount: number;
};
export type CameraSettings = {
    showCameraSelect: boolean;
    cameraResolution: CameraResolutions;
    cameraId?: string;
    autoSubmit: boolean;
    permissionInBrowserTimeout?: number;
};
export type FaceSize = {
    width: number;
    height: number;
};
export type ClientServerConnectionSettings = {
    videoRecordingApi: VideoRecordingApi;
    videoBitrate: number;
    idealVideoKeyFrameCountPerSecond: number;
    requiredReferenceFrameCount: number;
    referenceFrameQuality: number;
    switchToMediaRecoderApiAsFallback: boolean;
    transmissionWaitTimeout: number;
};
export declare enum VideoRecordingApi {
    WEB_CODEC = "WebCodec",
    MEDIA_RECORDER = "MediaRecorder"
}
