import { HTMLContainer, View } from '../_core';
export type OnErrorCallback = (message: string, code: string) => void;
export type TryAgainButtonFunction = ((e: Event) => void) | ((e: Event) => Promise<void>);
export declare class ErrorHandler extends View {
    private _element;
    private _errorMessage;
    private _tryAgainButton;
    private _handleErrorAppear?;
    private _onErrorCallback;
    private _errorEventHandler;
    constructor({ htmlContainer, handleErrorAppear, onErrorCallback, tryAgainButtonFunction, }: HTMLContainer & {
        handleErrorAppear?: () => Promise<void> | void;
        onErrorCallback?: OnErrorCallback;
        tryAgainButtonFunction?: TryAgainButtonFunction;
    });
    setOnErrorCallback(fn: OnErrorCallback | undefined): void;
    setTryAgainButtonFunction(fn: TryAgainButtonFunction | undefined): void;
    render(): void;
    stopRender(): void;
    destroy(): void;
    private handleError;
}
