import { Resolution } from '../../../../_core';
import { TBoundingBox } from '../../tensorflow_face_detector';
import { FaceBorderAllowableAccuracyError, FacePositionCircleData } from './face_position.types';
export declare abstract class FacePosition {
    protected _cameraResolution: Resolution;
    protected _previewResolution: Resolution;
    protected _scalingCoefficient: number;
    protected _normalizationCoefficients: {
        x: number;
        y: number;
    };
    protected _result: FacePositionCircleData | undefined;
    protected _calculatingDataForLastResult: {
        cameraResolution: Resolution;
        previewResolution: Resolution;
        scalingCoefficient: number;
    } | undefined;
    abstract calculateFaceBorder(): void;
    constructor({ scalingCoefficient, cameraResolution, previewResolution, }?: {
        scalingCoefficient?: number;
        cameraResolution?: Resolution;
        previewResolution?: Resolution;
    });
    getNormalizationCoefficients(): {
        x: number;
        y: number;
    };
    getCameraResolution(): Resolution;
    getPreviewResolution(): Resolution;
    getFaceBorderData(): FacePositionCircleData;
    updateCameraResolution(cameraResolution: Resolution): void;
    updatePreviewResolution(previewResolution: Resolution): void;
    updateScalingCoefficient(scalingCoefficient: number): void;
    protected checkThatStreamResolutionExist(): void;
    protected checkThatCalculationDataIsOutOfDate(): true | undefined;
    protected calculateNormalizationCofficients(): void;
    checkThatFaceInCenterOfRegion(bbox: TBoundingBox, allowableAccuracyError: FaceBorderAllowableAccuracyError): {
        isValid: boolean;
        message: string | undefined;
    };
    checkIsFaceSizeCorrect(bbox: TBoundingBox, allowableAccuracyError: FaceBorderAllowableAccuracyError): {
        isValid: boolean;
        message: string;
        score?: undefined;
    } | {
        isValid: boolean;
        message: string | undefined;
        score: number;
    };
    destroy(): void;
}
