import { Point, Resolution } from '../../../../_core';
import { FaceWidthCoefficients } from '../face_position_calculated_by_camera_resolution';
export type FacePositionCircleData = Resolution & {
    center: Point;
};
export type FaceBorderSettings = {
    allowableAccuracyError: FaceBorderAllowableAccuracyError;
    faceWidthCoefficients: FaceWidthCoefficients;
    autodetected: FaceBorderAutodetectedModeSettings;
};
export type FaceBorderAllowableAccuracyError = {
    x: number;
    y: number;
};
export type FaceBorderAutodetectedModeSettings = {
    enabled: boolean;
    frameCheckLimit: number;
    availableDeviation: number;
    framePadding: {
        horizontal: number;
        vertical: number;
    };
    faceSize: {
        min: Resolution;
        max: Resolution;
    };
};
