import { Resolution } from '../../../../_core';
import { FacePosition } from '../_face_position';
import { FaceWidthCoefficients } from './face_position_calculated_by_camera_resolution.types';
export default class FacePositionCalculatedByCameraResolution extends FacePosition {
    private _faceWidthCoefficients;
    private _videoResoulution;
    constructor({ scalingCoefficient, cameraResolution, videoResoulution, previewResolution, faceWidthCoefficients, }?: {
        scalingCoefficient?: number;
        cameraResolution?: Resolution;
        videoResoulution?: Resolution;
        previewResolution?: Resolution;
        faceWidthCoefficients?: FaceWidthCoefficients;
    });
    updateFaceWidthCoefficients(faceWidthCoefficients?: FaceWidthCoefficients): void;
    updateVideoResolution(resolution?: Resolution): void;
    calculateFaceBorder(): void;
    private calculateFaceWidthCofficient;
    getNormalizationCoefficients(): {
        x: number;
        y: number;
    };
}
