export type TTensolflowManagerConfig = {
    networksPath: string;
    isDisable: boolean;
};
export type TFlag = 'WEBGL_VERSION' | 'WASM_HAS_SIMD_SUPPORT' | 'WASM_HAS_MULTITHREAD_SUPPORT' | 'WEBGL_CPU_FORWARD' | 'WEBGL_PACK' | 'WEBGL_FORCE_F16_TEXTURES' | 'WEBGL_RENDER_FLOAT32_CAPABLE' | 'WEBGL_FLUSH_THRESHOLD' | 'CHECK_COMPUTATION_FOR_ERRORS';
export type TFace = {
    box: TBoundingBox;
    keypoints: TKeypoint[];
};
export type TBoundingBox = {
    xMin: number;
    yMin: number;
    xMax: number;
    yMax: number;
    width: number;
    height: number;
};
export type TKeypoint = {
    x: number;
    y: number;
    z?: number;
    score?: number;
    name?: string;
};
export type TRotation = {
    currentRotation: 'up' | 'left' | 'right' | 'center';
    angles: {
        yaw: number;
        pitch: number;
    };
};
