import { HTMLContainer, Point, Resolution, View } from '../../../_core';
import './face_keypoints_mask.style.css';
export declare class FaceKeypointsMask extends View {
    private _element;
    private _keypoits;
    private _isRendering;
    private _normalizationCoefficients;
    private _handleTdvFaceDetected;
    constructor({ htmlContainer, resolution, keypoits, normalizationCoefficients, }: HTMLContainer & {
        resolution?: Resolution;
        keypoits?: Point[][];
        normalizationCoefficients?: {
            x: number;
            y: number;
        };
    });
    setKeypoints(points: Point[][]): void;
    setNormalizationCoefficients(normalizationCoefficients: {
        x: number;
        y: number;
    }): void;
    render(): void;
    stopRender(): void;
    destroy(): void;
    private drawMask;
    private renderMask;
    private _getDetectedResultFromEvent;
    private clearCanvas;
    updateCanvasResolution({ width, height }: Resolution): void;
    private checkThatCanvasExist;
    private getCanvas2DContext;
}
