import { HTMLContainer, Point, Resolution, View } from '../../../_core';
import { OverlaySettings } from '../ui.types';
import './face_position_cirlce.style.css';
export declare class FacePositionCircle extends View {
    private _element;
    private _center;
    private _radiuses;
    private _overlaySettings;
    private _enableHighlightBorder;
    private _defaultColor;
    private _successColor;
    private _lineWidth;
    constructor({ htmlContainer, resolution, center, radiuses, overlaySettings, }: HTMLContainer & {
        resolution?: Resolution;
        overlaySettings?: OverlaySettings;
        center?: Point;
        radiuses?: {
            x: number;
            y: number;
        };
    });
    setCenter(point: Point): void;
    setRadiuses({ x, y }: {
        x: number;
        y: number;
    }): void;
    setOverlaySettings(overlaySettings?: OverlaySettings): void;
    render(): void;
    stopRender(): void;
    highlightBorder(): void;
    resetHighlightBorder(): void;
    destroy(): void;
    private drawOverlay;
    private drawFacePositionCircle;
    private drawFacePositionCircleBorder;
    private getStylesFromCssVariables;
    private clearCanvas;
    setResolution({ width, height }: Resolution): void;
    private checkThatCanvasExist;
    private getCanvas2DContext;
}
