import { FacePositionValidation } from '../../../class/configuration';
import { FaceBorderSettings, FacePosition } from '../../../class/face';
import { FaceRotationInfo } from '../../../shared';
import { DetectedResult } from './types';
export type InitialFacePositionIdentificationProps = {
    configuration: InitialFacePositionIdentificationConfiguration;
    facePosition?: FacePosition;
};
export type InitialFacePositionIdentificationConfiguration = {
    faceBorderSettings: FaceBorderSettings;
    facePositionValidation?: FacePositionValidation;
};
export declare class InitialFacePositionIdentification {
    private _initialFace;
    private _initialFaceRotation;
    private _faceKeypoints;
    private _streamSettings;
    private _isHandleDetection;
    private _configuration;
    private _facePosition?;
    constructor(props: InitialFacePositionIdentificationProps);
    get initialFacePosition(): DetectedResult;
    get initialFaceRotationAngles(): FaceRotationInfo | undefined;
    destroy(): void;
    setStreamSettings(value: MediaTrackSettings): void;
    identifyFacePosition(): Promise<unknown>;
    private _handleFacePosition;
    private _getDetectedResultFromEvent;
    private _calculateProgress;
    private _setInitialFacePosition;
    private _checkKeypointsDeviationForNewDetectedFace;
    private _calculateDistanceBetweenTwoPoints;
    private _isNoDetectedFace;
    private _isDetectedFaceTooSmall;
    private _isDetectedFaceTooBig;
    private _isDetectedFaceoffscreen;
    private _isDetectedFaceOutsideFaceBorder;
    private _createCurrentProgressEvent;
}
