import { Camera } from '../../../class/camera';
import { ComponentConfiguration } from '../../../class/configuration';
import { FlowMode } from '../../../shared';
import { InspectionsTransport } from '../../../shared/logic/inspections_transport';
type HandleGoNext = () => void;
type HandleError = (error: Error) => void;
type MotionControlStageProps = {
    htmlContainer: HTMLElement;
    modeType: FlowMode;
    camera: Camera;
    configuration: ComponentConfiguration;
    goNext: HandleGoNext;
    handleError: HandleError;
    transport: InspectionsTransport;
};
export default class MotionControlStage {
    private _modeType;
    private _htmlContainer;
    private _configuration;
    private _camera;
    private _transport;
    private _goNext;
    private _handleError;
    private _motionControlFailed;
    private _initialFace;
    private _initialFaceRotation;
    private _identifyFacePosition;
    private _motionControl;
    private _facePosition;
    private _pageLayout;
    private _pageContentMarkup;
    private _cameraPreview;
    private _facePositionCircle;
    private _faceKeypointsMask;
    private _textHints;
    private _description;
    private _directionArrowHint;
    private _directionGifHint;
    private _continueButton?;
    private _videoRecoder;
    private _videoBuffer;
    private _chunkQueue?;
    private _pendingChunks;
    private _hasError;
    constructor(props: MotionControlStageProps);
    run(): Promise<void>;
    private _renderFaceBorderByResolution;
    private _createFacePositionCalculatedByCameraResolution;
    private _renderUI;
    private _setPageTitle;
    private _renderPageContent;
    private _renderCameraPreview;
    private _renderFaceKeypointMask;
    private _renderTextMessage;
    private _renderIspectionDescriptionIfEnabled;
    private _renderContinueButton;
    private _identifyInitialFacePosition;
    private _updateTexHintMessageFromEvent;
    private _renderFaceBorderCircleByDetectedFace;
    private _createFacePosition;
    private _renderArrowDirectionHint;
    private _renderImageDirectionHintIfEnabled;
    private _runMotionControl;
    private _handleMotionControlActionEvent;
    private _updateTextHintByMotionControlAction;
    private _updateFaceBorderMotionControlAction;
    private _updateDirectionArrowHintByMotionControlAction;
    private _updateImageDirectionHint;
    private _handleCurrentValidationActionScoreEvent;
    private _updateArrowProgress;
    private _handleEncodedVideoFrameEvent;
    private _openTransportConnection;
    private _startRecodingVideo;
    private _getVideoContainerAndCodec;
    private concatenateArrayBuffers;
    private stopMediaRecorder;
    private _getRecodingCodec;
    private _getSupportedVideoEncoderCodec;
    private _stopRecodingVideo;
    private _stopRecodingVideoSignal;
    private _renderSendindDataToServerHintMessage;
    private _saveMotionControlResult;
    destroy(): void;
}
export {};
