import { ComponentConfiguration } from '../../../../../class/configuration';
import { FacePosition } from '../../../../../class/face';
import { FaceRotationInfo } from '../../../../../shared';
import { MotionControlPatternResult } from './types';
type MotionControlProps = {
    configuration: ComponentConfiguration;
    initialFaceAngleRotation: FaceRotationInfo;
    facePosition: FacePosition;
    onStartCallback?: () => void;
    onFinishCallback?: () => void;
    onFailedCallback?: () => void;
};
export declare class MotionControl {
    private _configuration;
    private _onStartCallback?;
    private _onFinishCallback?;
    private _onFailedCallback?;
    private _attemptNumber;
    private _result;
    private _patternCreator;
    private _facePositionValidator;
    constructor(props: MotionControlProps);
    run(): Promise<MotionControlPatternResult>;
    private _logMotionControlPattern;
    private _callOnStartCallbackIfExist;
    private _runHandleMotionControlPattern;
    private _generateHandleMotionControlActionEvent;
    private _callOnMotionCallback;
    private _generateFailedMotionControlEvent;
    private _logFinishedMotionControl;
    private _callOnFinishCallbackIfExist;
    private _callOnFaliedCallbackIfExist;
    destroy(): void;
}
export {};
