import { ComponentConfiguration } from '../../../../../class/configuration';
import { FacePosition } from '../../../../../class/face';
import { FaceRotationInfo } from '../../../../../shared';
import { MotionControlActions } from '../motion_control_pattern_creator';
type MotionControlFacePositionValidatorProps = {
    configuration: ComponentConfiguration;
    initialFaceAngleRotation: FaceRotationInfo;
    facePosition: FacePosition;
};
export declare class MotionControlFacePositionValidator {
    private _configuration;
    private _initialFaceAngleRotation;
    private _facePosition;
    private _timeoutId;
    private _isRunning;
    private _currentFace;
    private _handleDetectedFaceEvent;
    constructor(props: MotionControlFacePositionValidatorProps);
    validateFacePositionForCommand(command: MotionControlActions | 'return', throwError?: boolean): Promise<boolean | undefined>;
    private _handleDetectedFace;
    private _getDetectedResultFromEvent;
    private _calculateVerticalNormalizationAngle;
    private _runFaceValidationForCommand;
    private _runCycleOfCheckingFacePositionForCommand;
    private _getValidatorFunctionForCommand;
    private _generateValidationEvent;
    private _checkAngleTurningHeadToLeft;
    private _checkAngleTurningHeadToRight;
    private _checkAngleTurningHeadToUp;
    private _checkThatFaceHasRequiredSizeAndNoRotated;
    private _isValidFacePosition;
    private _isValidFaceSize;
    private _hasDetectedFace;
    private _stopRunningCycleByTimeout;
    private _stopCycle;
}
export {};
