import { Camera } from '../../../class/camera';
import { CameraSettings } from '../../../class/configuration';
import { FlowMode } from '../../../shared';
type HandleGoNext = (camera: Camera) => void;
type HandleGoBack = () => void;
type HandleError = (error: Error) => void;
type SelectCameraStageProps = {
    htmlContainer: HTMLElement;
    modeType: FlowMode;
    moduleSettings: CameraSettings;
    goNext: HandleGoNext;
    goBack: HandleGoBack;
    handleError: HandleError;
};
export default class SelectCameraStage {
    private _modeType;
    private _htmlContainer;
    private _moduleSettings;
    private _goNext;
    private _goBack;
    private _handleError;
    private _camera;
    private _pageLayout;
    private _pageContentMarkup;
    private _cameraPreview?;
    private _textHints?;
    private _continueButton?;
    private _backButton?;
    private _cameraSelector?;
    constructor(props: SelectCameraStageProps);
    getSelectedCamera(): Promise<void>;
    private _getPageName;
    private _goToNextStage;
    private _isCanSkipRendergUI;
    private _renderUI;
    private _setPageTitle;
    private _renderPageContent;
    private _renderCameraSelector;
    private _handleChangeSeletedCamera;
    private _selectCameraById;
    private _renderCameraPreview;
    private _renderCheckingCameraMessage;
    private _renderContinueButton;
    private _renderBackButton;
    destroy(): void;
}
export {};
