import { Camera } from '../../../class/camera';
import { ComponentConfiguration } from '../../../class/configuration';
import { FlowMode } from '../../../shared';
type HandleGoNext = () => void;
type HandleError = (error: Error) => void;
type TakeFaceBestshotsStageProps = {
    htmlContainer: HTMLElement;
    modeType: FlowMode;
    camera: Camera;
    configuration: ComponentConfiguration;
    goNext: HandleGoNext;
    handleError: HandleError;
};
export default class TakeFaceBestshotsStage {
    private _modeType;
    private _htmlContainer;
    private _configuration;
    private _goNext;
    private _handleError;
    private _initialFace;
    private _initialFaceRotation;
    private _camera;
    private _facePosition;
    private _identifyFacePosition;
    private _pageLayout;
    private _pageContentMarkup;
    private _cameraPreview?;
    private _facePositionCircle;
    private _faceKeypointsMask;
    private _textHints?;
    private _handleIntialFacePositionProgressEvent;
    constructor(props: TakeFaceBestshotsStageProps);
    getFaceBestshots(): Promise<void>;
    private _renderUI;
    private _setPageTitle;
    private _renderPageContent;
    private _renderCameraPreview;
    private _renderFaceKeypointMask;
    private _renderTextMessage;
    private _identifyInitialFacePosition;
    private _handleProgressMessage;
    private _renderFaceBorderCircleByDetectedFace;
    private _renderFaceBorderByResolution;
    private _createFacePositionCalculatedByCameraResolution;
    private _renderTimer;
    private _collectFaceBestshots;
    private _renderSendindDataToServerHintMessage;
    destroy(): void;
}
export {};
