import { Camera } from '../../../class/camera';
import { ComponentConfiguration } from '../../../class/configuration';
import { FlowMode } from '../../../shared';
import { InspectionsTransport } from '../../../shared/logic/inspections_transport';
type HandleGoNext = () => void;
type HandleGoBack = () => void;
type HandleError = (error: Error) => void;
type ValidateFlowResultStageProps = {
    htmlContainer: HTMLElement;
    moduleSettings: ComponentConfiguration;
    modeType: FlowMode;
    camera: Camera;
    transport: InspectionsTransport;
    goNext: HandleGoNext;
    goBack: HandleGoBack;
    handleError: HandleError;
    applicantId: string;
    endeavorId: string;
};
export default class ValidateFlowResultStage {
    private _modeType;
    private _htmlContainer;
    private _moduleSettings;
    private _applicantId;
    private _endeavorId;
    private _goNext;
    private _goBack;
    private _handleError;
    private _camera;
    private _transport;
    private _pageLayout;
    private _pageContentMarkup;
    private _cameraPreview?;
    private _submitButton?;
    private _backButton?;
    constructor(props: ValidateFlowResultStageProps);
    validateFlowResult(): Promise<void>;
    private _getPageName;
    private _isCanSkipRendergUI;
    private _renderUI;
    private _setPageTitle;
    private _renderPageContent;
    private _renderCameraPreview;
    private _renderSubmitButton;
    private _handleSubmtiResult;
    private _sendBestshots;
    private _convertBestshotsImageBitmapToBase64;
    private _callOnGetReferenceImagesCallbackIfExist;
    private _waitHandleKeyframe;
    private _validate;
    private _getDataForSendingToValidation;
    private _registerApplicant;
    private _authorizeApplicant;
    private _validateResponseStatus;
    private _checkLivenessResult;
    private _findValidationErorr;
    private _checkMatchingResult;
    private _isRegistrationMode;
    private _checkQualityResult;
    private _callOnValidateCallbackIfExist;
    private _renderBackButton;
    destroy(): void;
}
export {};
