import { ApplicantField } from '../class/applicant';
import { ApplicantFields } from '../class/configuration';
export type TLoginModuleConfig = {
    baseContainer: HTMLElement;
    page: 'Authorization' | 'Registration';
    applicantFields: ApplicantFields;
};
export type TDrawLoginConfig = {
    onLogin: (data: [string, FormDataEntryValue][], primaryField: string) => Promise<void>;
};
export declare class LoginModule {
    protected config: TLoginModuleConfig;
    protected headerContainer: HTMLElement;
    protected body: HTMLElement;
    protected footer: HTMLElement;
    protected form?: HTMLFormElement;
    protected fieldType: {
        firstName: string;
        lastName: string;
        phone: string;
        email: string;
        referenceId: string;
    };
    constructor(config: TLoginModuleConfig);
    protected drawLocalesText(): void;
    protected drawInputErrors(error: string, input: HTMLInputElement, errorContainer: HTMLDivElement): boolean;
    protected setLoading(isLoading: boolean): void;
    protected createInput(name: ApplicantField): {
        div: HTMLDivElement;
        input: HTMLInputElement;
        divError: HTMLDivElement;
    };
    drawContent({ onLogin }: TDrawLoginConfig): Promise<void>;
    destroy(): void;
}
