import { ComponentConfiguration } from '../../../class/configuration';
import { TBoundingBox } from '../../../class/face';
import { FaceRotationInfo } from '../face_rotation_serivce';
export type FaceBestshots = {
    frame: ImageBitmap;
    index: number;
    blurry?: {
        verdict: boolean;
        score: number;
    };
    bbox: TBoundingBox;
    videoId: string;
    angles: {
        yaw: number;
        pitch: number;
    };
};
export declare class BestshotsCollector {
    private _configuration;
    private _initialFaceAngleRotation;
    private _keyframes;
    private _handleEvent;
    constructor(configuration: ComponentConfiguration);
    get keyframes(): FaceBestshots[];
    awaitRequiredCount(): Promise<void>;
    startCollectingWithoutDetector(): void;
    stopCollectingWithoutDetector(): void;
    startCollecting(initialFaceAngleRotation: FaceRotationInfo): void;
    stopCollecting(): void;
    private _handleRawFrame;
    private _getDataFromEvent;
    private _handleDetectedResult;
    private _getDetectedResultFromEvent;
    private _estimateBlurry;
    private _isCenterAngles;
    private _imageBitmapToMat;
    private _isFrameBlurry;
    private _calculateVerticalNormalizationAngle;
    private _sortKeyframes;
    private _getAngleDeviation;
    clear(): void;
    destroy(): void;
}
