import type { Keypoint } from '@tensorflow-models/face-landmarks-detection';
import { AngleСalculationSettings } from '../../../class/configuration';
export type Point3D = {
    x: number;
    y: number;
    z: number;
};
export type FaceKeypoints = Point3D[];
export type FaceRotationInfo = {
    currentHorizontalRotation: undefined | 'left' | 'right' | 'center';
    currentVerticalRotation: undefined | 'up' | 'down' | 'center';
    angles: {
        pitch: undefined | number;
        yaw: undefined | number;
        roll: undefined | number;
    };
};
export declare class FaceRotationService {
    private _setting;
    constructor(setting: AngleСalculationSettings);
    defineRotationAnglesBy3dKeypoints(keypoints: FaceKeypoints, width: number, height: number, verticalNormalizationAngle?: number): FaceRotationInfo;
    convertMediaPipeKeypointToFaceKeypoint(mediapipeKeypoins: Keypoint[]): FaceKeypoints;
    getCameraMatrix(width: number, height: number): any;
    getDistMatrix(): any;
}
