import { LoggerDataTypes, LoggerMetadataKeys, LogLevel, Logs } from './logger.type';
export declare abstract class Logger {
    protected _integrationId: string;
    protected _baseUrl: string;
    protected _data?: Logs;
    abstract flush(): unknown;
    constructor({ integrationId, baseUrl }: {
        integrationId: string;
        baseUrl: string;
    });
    addInfoLog(data: string): void;
    addErrorLog(data: string): void;
    addCriticalErrorLog(data: string): void;
    addMetadata(type: LoggerMetadataKeys, info: string): void;
    protected _addLog(type: LoggerDataTypes, info: string, logLevel: LogLevel): void;
    clearLogs(): void;
    destroy(): void;
}
export declare class LoggerViaHttp extends Logger {
    constructor({ integrationId, baseUrl }: {
        integrationId: string;
        baseUrl: string;
    });
    flush(): Promise<import("axios").AxiosResponse<any, any>>;
}
export declare class LoggerViaWebSocket extends Logger {
    private _retryAttemt;
    private _connection?;
    constructor({ integrationId, baseUrl }: {
        integrationId: string;
        baseUrl: string;
    });
    private _openConnection;
    private _sendIntegrationId;
    private _sendMessage;
    protected _addLog(type: LoggerDataTypes, info: string, logLevel: LogLevel): void;
    private _sendLog;
    flush(): Promise<unknown>;
    checkThatConnectionIsOpen(): void;
    private _isConnectionOpen;
    private _isConnectionClosed;
    closeConnection(): void;
    private _isRepeatedAttemptsExceeded;
    destroy(): void;
}
