export type Logs = {
    deviceId?: string;
    integrationId: string;
    applicantId?: string;
    endeavorId?: string;
    attemptId?: string;
    logs: LogRecord[];
};
export type LoggerMetadataKeys = keyof Omit<Logs, 'logs'>;
export type LoggerDataTypes = keyof Logs;
export type LogRecord = {
    date: string;
    message: string;
    level: LogLevel;
};
export type LogLevel = 'critical' | 'error' | 'warning' | 'info' | 'debug';
