/*! For license information please see onboarding.js.LICENSE.txt */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("face-onboarding",[],t):"object"==typeof exports?exports["face-onboarding"]=t():e["face-onboarding"]=t()}(Object("undefined"==typeof self?this:self),()=>(()=>{var __webpack_modules__={260:(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__)=>{"use strict";__webpack_require__.d(__webpack_exports__,{Ps:()=>FilesetResolver_1,pR:()=>FaceLandmarker_1});var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:void 0!==__webpack_require__.g?__webpack_require__.g:"undefined"!=typeof self?self:{},vision={},fileset_resolver={};let supportsSimd;Object.defineProperty(fileset_resolver,"__esModule",{value:!0}),fileset_resolver.FilesetResolver=void 0;const WASM_SIMD_CHECK=new Uint8Array([0,97,115,109,1,0,0,0,1,5,1,96,0,1,123,3,2,1,0,10,10,1,8,0,65,0,253,15,253,98,11]);async function isSimdSupported(){if(void 0===supportsSimd)try{await WebAssembly.instantiate(WASM_SIMD_CHECK),supportsSimd=!0}catch(e){supportsSimd=!1}return supportsSimd}async function createFileset(e,t=""){const r=await isSimdSupported()?"wasm_internal":"wasm_nosimd_internal";return{wasmLoaderPath:`${t}/${e}_${r}.js`,wasmBinaryPath:`${t}/${e}_${r}.wasm`}}class FilesetResolver$1{static isSimdSupported(){return isSimdSupported()}static forAudioTasks(e){return createFileset("audio",e)}static forTextTasks(e){return createFileset("text",e)}static forVisionTasks(e){return createFileset("vision",e)}}fileset_resolver.FilesetResolver=FilesetResolver$1;var drawing_utils={};Object.defineProperty(drawing_utils,"__esModule",{value:!0}),drawing_utils.DrawingUtils=void 0;const DEFAULT_OPTIONS={color:"white",lineWidth:4,radius:6};function addDefaultOptions(e){return e=e||{},Object.assign(Object.assign(Object.assign({},DEFAULT_OPTIONS),{fillColor:e.color}),e)}function resolve(e,t){return e instanceof Function?e(t):e}class DrawingUtils$1{constructor(e){this.ctx=e}static clamp(e,t,r){const o=Math.min(t,r),n=Math.max(t,r);return Math.max(o,Math.min(n,e))}static lerp(e,t,r,o,n){const i=o*(1-(e-t)/(r-t))+n*(1-(r-e)/(r-t));return DrawingUtils$1.clamp(i,o,n)}drawLandmarks(e,t){if(!e)return;const r=this.ctx,o=addDefaultOptions(t);r.save();const n=r.canvas;let i=0;for(const t of e){r.fillStyle=resolve(o.fillColor,{index:i,from:t}),r.strokeStyle=resolve(o.color,{index:i,from:t}),r.lineWidth=resolve(o.lineWidth,{index:i,from:t});const e=new Path2D;e.arc(t.x*n.width,t.y*n.height,resolve(o.radius,{index:i,from:t}),0,2*Math.PI),r.fill(e),r.stroke(e),++i}r.restore()}drawConnectors(e,t,r){if(!e||!t)return;const o=this.ctx,n=addDefaultOptions(r);o.save();const i=o.canvas;let a=0;for(const r of t){o.beginPath();const t=e[r.start],s=e[r.end];t&&s&&(o.strokeStyle=resolve(n.color,{index:a,from:t,to:s}),o.lineWidth=resolve(n.lineWidth,{index:a,from:t,to:s}),o.moveTo(t.x*i.width,t.y*i.height),o.lineTo(s.x*i.width,s.y*i.height)),++a,o.stroke()}o.restore()}drawBoundingBox(e,t){const r=this.ctx,o=addDefaultOptions(t);r.save(),r.beginPath(),r.lineWidth=resolve(o.lineWidth,{}),r.strokeStyle=resolve(o.color,{}),r.fillStyle=resolve(o.fillColor,{}),r.moveTo(e.originX,e.originY),r.lineTo(e.originX+e.width,e.originY),r.lineTo(e.originX+e.width,e.originY+e.height),r.lineTo(e.originX,e.originY+e.height),r.lineTo(e.originX,e.originY),r.stroke(),r.fill(),r.restore()}}drawing_utils.DrawingUtils=DrawingUtils$1;var image={},image_shader_context={};Object.defineProperty(image_shader_context,"__esModule",{value:!0}),image_shader_context.MPImageShaderContext=image_shader_context.assertNotNull=void 0;const VERTEX_SHADER="\n  attribute vec2 aVertex;\n  attribute vec2 aTex;\n  varying vec2 vTex;\n  void main(void) {\n    gl_Position = vec4(aVertex, 0.0, 1.0);\n    vTex = aTex;\n  }",FRAGMENT_SHADER="\n  precision mediump float;\n  varying vec2 vTex;\n  uniform sampler2D inputTexture;\n   void main() {\n     gl_FragColor = texture2D(inputTexture, vTex);\n   }\n ";function assertNotNull(e,t){if(null===e)throw new Error(`Unable to obtain required WebGL resource: ${t}`);return e}image_shader_context.assertNotNull=assertNotNull;class MPImageShaderBuffers{constructor(e,t,r,o){this.gl=e,this.vertexArrayObject=t,this.vertexBuffer=r,this.textureBuffer=o}bind(){this.gl.bindVertexArray(this.vertexArrayObject)}unbind(){this.gl.bindVertexArray(null)}close(){this.gl.deleteVertexArray(this.vertexArrayObject),this.gl.deleteBuffer(this.vertexBuffer),this.gl.deleteBuffer(this.textureBuffer)}}class MPImageShaderContext{compileShader(e,t){const r=this.gl,o=assertNotNull(r.createShader(t),"Failed to create WebGL shader");if(r.shaderSource(o,e),r.compileShader(o),!r.getShaderParameter(o,r.COMPILE_STATUS)){const e=r.getShaderInfoLog(o);throw new Error(`Could not compile WebGL shader: ${e}`)}return r.attachShader(this.program,o),o}setupShaders(){const e=this.gl;if(this.program=assertNotNull(e.createProgram(),"Failed to create WebGL program"),this.vertexShader=this.compileShader(VERTEX_SHADER,e.VERTEX_SHADER),this.fragmentShader=this.compileShader(FRAGMENT_SHADER,e.FRAGMENT_SHADER),e.linkProgram(this.program),!e.getProgramParameter(this.program,e.LINK_STATUS)){const t=e.getProgramInfoLog(this.program);throw new Error(`Error during program linking: ${t}`)}this.aVertex=e.getAttribLocation(this.program,"aVertex"),this.aTex=e.getAttribLocation(this.program,"aTex")}createBuffers(e){const t=this.gl,r=assertNotNull(t.createVertexArray(),"Failed to create vertex array");t.bindVertexArray(r);const o=assertNotNull(t.createBuffer(),"Failed to create buffer");t.bindBuffer(t.ARRAY_BUFFER,o),t.enableVertexAttribArray(this.aVertex),t.vertexAttribPointer(this.aVertex,2,t.FLOAT,!1,0,0),t.bufferData(t.ARRAY_BUFFER,new Float32Array([-1,-1,-1,1,1,1,1,-1]),t.STATIC_DRAW);const n=assertNotNull(t.createBuffer(),"Failed to create buffer");t.bindBuffer(t.ARRAY_BUFFER,n),t.enableVertexAttribArray(this.aTex),t.vertexAttribPointer(this.aTex,2,t.FLOAT,!1,0,0);const i=e?[0,1,0,0,1,0,1,1]:[0,0,0,1,1,1,1,0];return t.bufferData(t.ARRAY_BUFFER,new Float32Array(i),t.STATIC_DRAW),t.bindBuffer(t.ARRAY_BUFFER,null),t.bindVertexArray(null),new MPImageShaderBuffers(t,r,o,n)}getShaderBuffers(e){return e?(this.shaderBuffersFlipVertically||(this.shaderBuffersFlipVertically=this.createBuffers(!0)),this.shaderBuffersFlipVertically):(this.shaderBuffersPassthrough||(this.shaderBuffersPassthrough=this.createBuffers(!1)),this.shaderBuffersPassthrough)}maybeInitGL(e){if(this.gl){if(e!==this.gl)throw new Error("Cannot change GL context once initialized")}else this.gl=e}run(e,t,r){this.maybeInitGL(e),this.program||this.setupShaders();const o=this.getShaderBuffers(t);e.useProgram(this.program),o.bind();const n=r();return o.unbind(),n}bindFramebuffer(e,t){this.maybeInitGL(e),this.framebuffer||(this.framebuffer=assertNotNull(e.createFramebuffer(),"Failed to create framebuffe.")),e.bindFramebuffer(e.FRAMEBUFFER,this.framebuffer),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0)}unbindFramebuffer(){var e;null===(e=this.gl)||void 0===e||e.bindFramebuffer(this.gl.FRAMEBUFFER,null)}close(){if(this.program){const e=this.gl;e.deleteProgram(this.program),e.deleteShader(this.vertexShader),e.deleteShader(this.fragmentShader)}this.framebuffer&&this.gl.deleteFramebuffer(this.framebuffer),this.shaderBuffersPassthrough&&this.shaderBuffersPassthrough.close(),this.shaderBuffersFlipVertically&&this.shaderBuffersFlipVertically.close()}}image_shader_context.MPImageShaderContext=MPImageShaderContext,Object.defineProperty(image,"__esModule",{value:!0}),image.MPImage=void 0;const image_shader_context_1$2=image_shader_context,INSTANCE_COUNT_WARNING_THRESHOLD$1=250;var MPImageType,e;e=MPImageType||(MPImageType={}),e[e.IMAGE_DATA=0]="IMAGE_DATA",e[e.IMAGE_BITMAP=1]="IMAGE_BITMAP",e[e.WEBGL_TEXTURE=2]="WEBGL_TEXTURE";class MPImage$1{constructor(e,t,r,o,n,i,a){this.containers=e,this.ownsImageBitmap=t,this.ownsWebGLTexture=r,this.canvas=o,this.shaderContext=n,this.width=i,this.height=a,(this.ownsImageBitmap||this.ownsWebGLTexture)&&(--MPImage$1.instancesBeforeWarning,0===MPImage$1.instancesBeforeWarning&&console.error("You seem to be creating MPImage instances without invoking .close(). This leaks resources."))}hasImageData(){return!!this.getContainer(MPImageType.IMAGE_DATA)}hasImageBitmap(){return!!this.getContainer(MPImageType.IMAGE_BITMAP)}hasWebGLTexture(){return!!this.getContainer(MPImageType.WEBGL_TEXTURE)}getAsImageData(){return this.convertToImageData()}getAsImageBitmap(){return this.convertToImageBitmap()}getAsWebGLTexture(){return this.convertToWebGLTexture()}getContainer(e){switch(e){case MPImageType.IMAGE_DATA:return this.containers.find(e=>e instanceof ImageData);case MPImageType.IMAGE_BITMAP:return this.containers.find(e=>"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap);case MPImageType.WEBGL_TEXTURE:return this.containers.find(e=>"undefined"!=typeof WebGLTexture&&e instanceof WebGLTexture);default:throw new Error(`Type is not supported: ${e}`)}}clone(){const e=[];for(const t of this.containers){let r;if(t instanceof ImageData)r=new ImageData(t.data,this.width,this.height);else if(t instanceof WebGLTexture){const e=this.getGL(),t=this.getShaderContext();e.activeTexture(e.TEXTURE1),r=(0,image_shader_context_1$2.assertNotNull)(e.createTexture(),"Failed to create texture"),e.bindTexture(e.TEXTURE_2D,r),this.configureTextureParams(),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,this.width,this.height,0,e.RGBA,e.UNSIGNED_BYTE,null),e.bindTexture(e.TEXTURE_2D,null),t.bindFramebuffer(e,r),t.run(e,!1,()=>{this.bindTexture(),e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.drawArrays(e.TRIANGLE_FAN,0,4),this.unbindTexture()}),t.unbindFramebuffer(),this.unbindTexture()}else{if(!(t instanceof ImageBitmap))throw new Error(`Type is not supported: ${t}`);this.convertToWebGLTexture(),this.bindTexture(),r=this.copyTextureToBitmap(),this.unbindTexture()}e.push(r)}return new MPImage$1(e,this.hasImageBitmap(),this.hasWebGLTexture(),this.canvas,this.shaderContext,this.width,this.height)}getOffscreenCanvas(){if(!(this.canvas instanceof OffscreenCanvas))throw new Error("Conversion to ImageBitmap requires that the MediaPipe Tasks is initialized with an OffscreenCanvas");return this.canvas}getGL(){if(!this.canvas)throw new Error("Conversion to different image formats require that a canvas is passed when iniitializing the image.");return this.gl||(this.gl=(0,image_shader_context_1$2.assertNotNull)(this.canvas.getContext("webgl2"),"You cannot use a canvas that is already bound to a different type of rendering context.")),this.gl}getShaderContext(){return this.shaderContext||(this.shaderContext=new image_shader_context_1$2.MPImageShaderContext),this.shaderContext}convertToImageBitmap(){let e=this.getContainer(MPImageType.IMAGE_BITMAP);return e||(this.convertToWebGLTexture(),e=this.convertWebGLTextureToImageBitmap(),this.containers.push(e),this.ownsImageBitmap=!0),e}convertToImageData(){let e=this.getContainer(MPImageType.IMAGE_DATA);if(!e){const t=this.getGL(),r=this.getShaderContext(),o=new Uint8Array(this.width*this.height*4),n=this.convertToWebGLTexture();r.bindFramebuffer(t,n),t.readPixels(0,0,this.width,this.height,t.RGBA,t.UNSIGNED_BYTE,o),r.unbindFramebuffer(),e=new ImageData(new Uint8ClampedArray(o.buffer),this.width,this.height),this.containers.push(e)}return e}convertToWebGLTexture(){let e=this.getContainer(MPImageType.WEBGL_TEXTURE);if(!e){const t=this.getGL();e=this.bindTexture();const r=this.getContainer(MPImageType.IMAGE_BITMAP)||this.convertToImageData();t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,r),this.unbindTexture()}return e}configureTextureParams(){const e=this.getGL();e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR)}bindTexture(){const e=this.getGL();e.viewport(0,0,this.width,this.height),e.activeTexture(e.TEXTURE0);let t=this.getContainer(MPImageType.WEBGL_TEXTURE);return t?e.bindTexture(e.TEXTURE_2D,t):(t=(0,image_shader_context_1$2.assertNotNull)(e.createTexture(),"Failed to create texture"),this.containers.push(t),this.ownsWebGLTexture=!0,e.bindTexture(e.TEXTURE_2D,t),this.configureTextureParams()),t}unbindTexture(){this.gl.bindTexture(this.gl.TEXTURE_2D,null)}copyTextureToBitmap(){const e=this.getGL();return this.getShaderContext().run(e,!0,()=>this.runWithResizedCanvas(()=>(e.bindFramebuffer(e.FRAMEBUFFER,null),e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.drawArrays(e.TRIANGLE_FAN,0,4),this.getOffscreenCanvas().transferToImageBitmap())))}convertWebGLTextureToImageBitmap(){this.bindTexture();const e=this.copyTextureToBitmap();return this.unbindTexture(),e}runWithResizedCanvas(e){const t=this.canvas;if(t.width===this.width&&t.height===this.height)return e();const r=t.width,o=t.height;t.width=this.width,t.height=this.height;const n=e();return t.width=r,t.height=o,n}close(){this.ownsImageBitmap&&this.getContainer(MPImageType.IMAGE_BITMAP).close(),this.ownsWebGLTexture&&this.getGL().deleteTexture(this.getContainer(MPImageType.WEBGL_TEXTURE)),MPImage$1.instancesBeforeWarning=-1}}image.MPImage=MPImage$1,MPImage$1.instancesBeforeWarning=INSTANCE_COUNT_WARNING_THRESHOLD$1;var mask={},platform_utils={};function isWebKit(e=navigator){const t=e.userAgent;return t.includes("Safari")&&!t.includes("Chrome")}function isIOS(){return["iPad Simulator","iPhone Simulator","iPod Simulator","iPad","iPhone","iPod"].includes(navigator.platform)||navigator.userAgent.includes("Mac")&&"ontouchend"in document}Object.defineProperty(platform_utils,"__esModule",{value:!0}),platform_utils.isIOS=platform_utils.isWebKit=void 0,platform_utils.isWebKit=isWebKit,platform_utils.isIOS=isIOS,Object.defineProperty(mask,"__esModule",{value:!0}),mask.MPMask=void 0;const image_shader_context_1$1=image_shader_context,platform_utils_1$1=platform_utils,INSTANCE_COUNT_WARNING_THRESHOLD=250;var MPMaskType;!function(e){e[e.UINT8_ARRAY=0]="UINT8_ARRAY",e[e.FLOAT32_ARRAY=1]="FLOAT32_ARRAY",e[e.WEBGL_TEXTURE=2]="WEBGL_TEXTURE"}(MPMaskType||(MPMaskType={}));class MPMask$1{constructor(e,t,r,o,n,i){this.containers=e,this.ownsWebGLTexture=t,this.canvas=r,this.shaderContext=o,this.width=n,this.height=i,this.ownsWebGLTexture&&(--MPMask$1.instancesBeforeWarning,0===MPMask$1.instancesBeforeWarning&&console.error("You seem to be creating MPMask instances without invoking .close(). This leaks resources."))}hasUint8Array(){return!!this.getContainer(MPMaskType.UINT8_ARRAY)}hasFloat32Array(){return!!this.getContainer(MPMaskType.FLOAT32_ARRAY)}hasWebGLTexture(){return!!this.getContainer(MPMaskType.WEBGL_TEXTURE)}getAsUint8Array(){return this.convertToUint8Array()}getAsFloat32Array(){return this.convertToFloat32Array()}getAsWebGLTexture(){return this.convertToWebGLTexture()}getTexImage2DFormat(){const e=this.getGL();if(!MPMask$1.texImage2DFormat)if(e.getExtension("EXT_color_buffer_float")&&e.getExtension("OES_texture_float_linear")&&e.getExtension("EXT_float_blend"))MPMask$1.texImage2DFormat=e.R32F;else{if(!e.getExtension("EXT_color_buffer_half_float"))throw new Error("GPU does not fully support 4-channel float32 or float16 formats");MPMask$1.texImage2DFormat=e.R16F}return MPMask$1.texImage2DFormat}getContainer(e){switch(e){case MPMaskType.UINT8_ARRAY:return this.containers.find(e=>e instanceof Uint8Array);case MPMaskType.FLOAT32_ARRAY:return this.containers.find(e=>e instanceof Float32Array);case MPMaskType.WEBGL_TEXTURE:return this.containers.find(e=>"undefined"!=typeof WebGLTexture&&e instanceof WebGLTexture);default:throw new Error(`Type is not supported: ${e}`)}}clone(){const e=[];for(const t of this.containers){let r;if(t instanceof Uint8Array)r=new Uint8Array(t);else if(t instanceof Float32Array)r=new Float32Array(t);else{if(!(t instanceof WebGLTexture))throw new Error(`Type is not supported: ${t}`);{const e=this.getGL(),t=this.getShaderContext();e.activeTexture(e.TEXTURE1),r=(0,image_shader_context_1$1.assertNotNull)(e.createTexture(),"Failed to create texture"),e.bindTexture(e.TEXTURE_2D,r),this.configureTextureParams();const o=this.getTexImage2DFormat();e.texImage2D(e.TEXTURE_2D,0,o,this.width,this.height,0,e.RED,e.FLOAT,null),e.bindTexture(e.TEXTURE_2D,null),t.bindFramebuffer(e,r),t.run(e,!1,()=>{this.bindTexture(),e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.drawArrays(e.TRIANGLE_FAN,0,4),this.unbindTexture()}),t.unbindFramebuffer(),this.unbindTexture()}}e.push(r)}return new MPMask$1(e,this.hasWebGLTexture(),this.canvas,this.shaderContext,this.width,this.height)}getGL(){if(!this.canvas)throw new Error("Conversion to different image formats require that a canvas is passed when initializing the image.");return this.gl||(this.gl=(0,image_shader_context_1$1.assertNotNull)(this.canvas.getContext("webgl2"),"You cannot use a canvas that is already bound to a different type of rendering context.")),this.gl}getShaderContext(){return this.shaderContext||(this.shaderContext=new image_shader_context_1$1.MPImageShaderContext),this.shaderContext}convertToFloat32Array(){let e=this.getContainer(MPMaskType.FLOAT32_ARRAY);if(!e){const t=this.getContainer(MPMaskType.UINT8_ARRAY);if(t)e=new Float32Array(t).map(e=>e/255);else{e=new Float32Array(this.width*this.height);const t=this.getGL(),r=this.getShaderContext(),o=this.convertToWebGLTexture();if(r.bindFramebuffer(t,o),(0,platform_utils_1$1.isIOS)()){const r=new Float32Array(this.width*this.height*4);t.readPixels(0,0,this.width,this.height,t.RGBA,t.FLOAT,r);for(let t=0,o=0;t<e.length;++t,o+=4)e[t]=r[o]}else t.readPixels(0,0,this.width,this.height,t.RED,t.FLOAT,e)}this.containers.push(e)}return e}convertToUint8Array(){let e=this.getContainer(MPMaskType.UINT8_ARRAY);if(!e){const t=this.convertToFloat32Array();e=new Uint8Array(t.map(e=>255*e)),this.containers.push(e)}return e}convertToWebGLTexture(){let e=this.getContainer(MPMaskType.WEBGL_TEXTURE);if(!e){const t=this.getGL();e=this.bindTexture();const r=this.convertToFloat32Array(),o=this.getTexImage2DFormat();t.texImage2D(t.TEXTURE_2D,0,o,this.width,this.height,0,t.RED,t.FLOAT,r),this.unbindTexture()}return e}configureTextureParams(){const e=this.getGL();e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.NEAREST),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.NEAREST)}bindTexture(){const e=this.getGL();e.viewport(0,0,this.width,this.height),e.activeTexture(e.TEXTURE0);let t=this.getContainer(MPMaskType.WEBGL_TEXTURE);return t?e.bindTexture(e.TEXTURE_2D,t):(t=(0,image_shader_context_1$1.assertNotNull)(e.createTexture(),"Failed to create texture"),this.containers.push(t),this.ownsWebGLTexture=!0,e.bindTexture(e.TEXTURE_2D,t),this.configureTextureParams()),t}unbindTexture(){this.gl.bindTexture(this.gl.TEXTURE_2D,null)}close(){this.ownsWebGLTexture&&this.getGL().deleteTexture(this.getContainer(MPMaskType.WEBGL_TEXTURE)),MPMask$1.instancesBeforeWarning=-1}}mask.MPMask=MPMask$1,MPMask$1.instancesBeforeWarning=INSTANCE_COUNT_WARNING_THRESHOLD;var face_detector={},calculator_pb={},googleProtobuf={};(function(exports){var $jscomp=$jscomp||{};$jscomp.scope={},$jscomp.findInternal=function(e,t,r){e instanceof String&&(e=String(e));for(var o=e.length,n=0;n<o;n++){var i=e[n];if(t.call(r,i,n,e))return{i:n,v:i}}return{i:-1,v:void 0}},$jscomp.ASSUME_ES5=!1,$jscomp.ASSUME_NO_NATIVE_MAP=!1,$jscomp.ASSUME_NO_NATIVE_SET=!1,$jscomp.SIMPLE_FROUND_POLYFILL=!1,$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(e,t,r){e!=Array.prototype&&e!=Object.prototype&&(e[t]=r.value)},$jscomp.getGlobal=function(e){return"undefined"!=typeof window&&window===e?e:void 0!==commonjsGlobal&&null!=commonjsGlobal?commonjsGlobal:e},$jscomp.global=$jscomp.getGlobal(commonjsGlobal),$jscomp.polyfill=function(e,t,r,o){if(t){for(r=$jscomp.global,e=e.split("."),o=0;o<e.length-1;o++){var n=e[o];n in r||(r[n]={}),r=r[n]}(t=t(o=r[e=e[e.length-1]]))!=o&&null!=t&&$jscomp.defineProperty(r,e,{configurable:!0,writable:!0,value:t})}},$jscomp.polyfill("Array.prototype.findIndex",function(e){return e||function(e,t){return $jscomp.findInternal(this,e,t).i}},"es6","es3"),$jscomp.checkStringArgs=function(e,t,r){if(null==e)throw new TypeError("The 'this' value for String.prototype."+r+" must not be null or undefined");if(t instanceof RegExp)throw new TypeError("First argument to String.prototype."+r+" must not be a regular expression");return e+""},$jscomp.polyfill("String.prototype.endsWith",function(e){return e||function(e,t){var r=$jscomp.checkStringArgs(this,e,"endsWith");e+="",void 0===t&&(t=r.length),t=Math.max(0,Math.min(0|t,r.length));for(var o=e.length;0<o&&0<t;)if(r[--t]!=e[--o])return!1;return 0>=o}},"es6","es3"),$jscomp.polyfill("Array.prototype.find",function(e){return e||function(e,t){return $jscomp.findInternal(this,e,t).v}},"es6","es3"),$jscomp.polyfill("String.prototype.startsWith",function(e){return e||function(e,t){var r=$jscomp.checkStringArgs(this,e,"startsWith");e+="";var o=r.length,n=e.length;t=Math.max(0,Math.min(0|t,r.length));for(var i=0;i<n&&t<o;)if(r[t++]!=e[i++])return!1;return i>=n}},"es6","es3"),$jscomp.polyfill("String.prototype.repeat",function(e){return e||function(e){var t=$jscomp.checkStringArgs(this,null,"repeat");if(0>e||1342177279<e)throw new RangeError("Invalid count value");e|=0;for(var r="";e;)1&e&&(r+=t),(e>>>=1)&&(t+=t);return r}},"es6","es3");var COMPILED=!0,goog=goog||{};goog.global=commonjsGlobal||self,goog.exportPath_=function(e,t,r){e=e.split("."),r=r||goog.global,e[0]in r||void 0===r.execScript||r.execScript("var "+e[0]);for(var o;e.length&&(o=e.shift());)e.length||void 0===t?r=r[o]&&r[o]!==Object.prototype[o]?r[o]:r[o]={}:r[o]=t},goog.define=function(e,t){return t},goog.FEATURESET_YEAR=2012,goog.DEBUG=!0,goog.LOCALE="en",goog.TRUSTED_SITE=!0,goog.STRICT_MODE_COMPATIBLE=!1,goog.DISALLOW_TEST_ONLY_CODE=!goog.DEBUG,goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING=!1,goog.provide=function(e){if(goog.isInModuleLoader_())throw Error("goog.provide cannot be used within a module.");goog.constructNamespace_(e)},goog.constructNamespace_=function(e,t){goog.exportPath_(e,t)},goog.getScriptNonce=function(e){return e&&e!=goog.global?goog.getScriptNonce_(e.document):(null===goog.cspNonce_&&(goog.cspNonce_=goog.getScriptNonce_(goog.global.document)),goog.cspNonce_)},goog.NONCE_PATTERN_=/^[\w+/_-]+[=]{0,2}$/,goog.cspNonce_=null,goog.getScriptNonce_=function(e){return(e=e.querySelector&&e.querySelector("script[nonce]"))&&(e=e.nonce||e.getAttribute("nonce"))&&goog.NONCE_PATTERN_.test(e)?e:""},goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/,goog.module=function(e){if("string"!=typeof e||!e||-1==e.search(goog.VALID_MODULE_RE_))throw Error("Invalid module identifier");if(!goog.isInGoogModuleLoader_())throw Error("Module "+e+" has been loaded incorrectly. Note, modules cannot be loaded as normal scripts. They require some kind of pre-processing step. You're likely trying to load a module via a script tag or as a part of a concatenated bundle without rewriting the module. For more info see: https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");goog.moduleLoaderState_.moduleName=e},goog.module.get=function(e){return goog.module.getInternal_(e)},goog.module.getInternal_=function(e){return null},goog.ModuleType={ES6:"es6",GOOG:"goog"},goog.moduleLoaderState_=null,goog.isInModuleLoader_=function(){return goog.isInGoogModuleLoader_()||goog.isInEs6ModuleLoader_()},goog.isInGoogModuleLoader_=function(){return!!goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.GOOG},goog.isInEs6ModuleLoader_=function(){if(goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.ES6)return!0;var e=goog.global.$jscomp;return!!e&&"function"==typeof e.getCurrentModulePath&&!!e.getCurrentModulePath()},goog.module.declareLegacyNamespace=function(){goog.moduleLoaderState_.declareLegacyNamespace=!0},goog.declareModuleId=function(e){if(goog.moduleLoaderState_)goog.moduleLoaderState_.moduleName=e;else{var t=goog.global.$jscomp;if(!t||"function"!=typeof t.getCurrentModulePath)throw Error('Module with namespace "'+e+'" has been loaded incorrectly.');t=t.require(t.getCurrentModulePath()),goog.loadedModules_[e]={exports:t,type:goog.ModuleType.ES6,moduleId:e}}},goog.setTestOnly=function(e){if(goog.DISALLOW_TEST_ONLY_CODE)throw e=e||"",Error("Importing test-only code into non-debug environment"+(e?": "+e:"."))},goog.forwardDeclare=function(e){},goog.getObjectByName=function(e,t){e=e.split("."),t=t||goog.global;for(var r=0;r<e.length;r++)if(null==(t=t[e[r]]))return null;return t},goog.globalize=function(e,t){for(var r in t=t||goog.global,e)t[r]=e[r]},goog.addDependency=function(e,t,r,o){},goog.ENABLE_DEBUG_LOADER=!0,goog.logToConsole_=function(e){goog.global.console&&goog.global.console.error(e)},goog.require=function(e){},goog.requireType=function(e){return{}},goog.basePath="",goog.nullFunction=function(){},goog.abstractMethod=function(){throw Error("unimplemented abstract method")},goog.addSingletonGetter=function(e){e.instance_=void 0,e.getInstance=function(){return e.instance_?e.instance_:(goog.DEBUG&&(goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=e),e.instance_=new e)}},goog.instantiatedSingletons_=[],goog.LOAD_MODULE_USING_EVAL=!0,goog.SEAL_MODULE_EXPORTS=goog.DEBUG,goog.loadedModules_={},goog.DEPENDENCIES_ENABLED=!COMPILED,goog.TRANSPILE="detect",goog.ASSUME_ES_MODULES_TRANSPILED=!1,goog.TRANSPILE_TO_LANGUAGE="",goog.TRANSPILER="transpile.js",goog.hasBadLetScoping=null,goog.useSafari10Workaround=function(){if(null==goog.hasBadLetScoping){try{var a=!eval('"use strict";let x = 1; function f() { return typeof x; };f() == "number";')}catch(e){a=!1}goog.hasBadLetScoping=a}return goog.hasBadLetScoping},goog.workaroundSafari10EvalBug=function(e){return"(function(){"+e+"\n;})();\n"},goog.loadModule=function(e){var t=goog.moduleLoaderState_;try{if(goog.moduleLoaderState_={moduleName:"",declareLegacyNamespace:!1,type:goog.ModuleType.GOOG},goog.isFunction(e))var r=e.call(void 0,{});else{if("string"!=typeof e)throw Error("Invalid module definition");goog.useSafari10Workaround()&&(e=goog.workaroundSafari10EvalBug(e)),r=goog.loadModuleFromSource_.call(void 0,e)}var o=goog.moduleLoaderState_.moduleName;if("string"!=typeof o||!o)throw Error('Invalid module name "'+o+'"');goog.moduleLoaderState_.declareLegacyNamespace?goog.constructNamespace_(o,r):goog.SEAL_MODULE_EXPORTS&&Object.seal&&"object"==typeof r&&null!=r&&Object.seal(r),goog.loadedModules_[o]={exports:r,type:goog.ModuleType.GOOG,moduleId:goog.moduleLoaderState_.moduleName}}finally{goog.moduleLoaderState_=t}},goog.loadModuleFromSource_=function(a){return eval(a),{}},goog.normalizePath_=function(e){e=e.split("/");for(var t=0;t<e.length;)"."==e[t]?e.splice(t,1):t&&".."==e[t]&&e[t-1]&&".."!=e[t-1]?e.splice(--t,2):t++;return e.join("/")},goog.loadFileSync_=function(e){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(e);try{var t=new goog.global.XMLHttpRequest;return t.open("get",e,!1),t.send(),0==t.status||200==t.status?t.responseText:null}catch(e){return null}},goog.transpile_=function(e,t,r){var o=goog.global.$jscomp;o||(goog.global.$jscomp=o={});var n=o.transpile;if(!n){var i=goog.basePath+goog.TRANSPILER,a=goog.loadFileSync_(i);if(a){if(function(){(0,eval)(a+"\n//# sourceURL="+i)}.call(goog.global),goog.global.$gwtExport&&goog.global.$gwtExport.$jscomp&&!goog.global.$gwtExport.$jscomp.transpile)throw Error('The transpiler did not properly export the "transpile" method. $gwtExport: '+JSON.stringify(goog.global.$gwtExport));goog.global.$jscomp.transpile=goog.global.$gwtExport.$jscomp.transpile,n=(o=goog.global.$jscomp).transpile}}return n||(n=o.transpile=function(e,t){return goog.logToConsole_(t+" requires transpilation but no transpiler was found."),e}),n(e,t,r)},goog.typeOf=function(e){var t=typeof e;if("object"==t){if(!e)return"null";if(e instanceof Array)return"array";if(e instanceof Object)return t;var r=Object.prototype.toString.call(e);if("[object Window]"==r)return"object";if("[object Array]"==r||"number"==typeof e.length&&void 0!==e.splice&&void 0!==e.propertyIsEnumerable&&!e.propertyIsEnumerable("splice"))return"array";if("[object Function]"==r||void 0!==e.call&&void 0!==e.propertyIsEnumerable&&!e.propertyIsEnumerable("call"))return"function"}else if("function"==t&&void 0===e.call)return"object";return t},goog.isArray=function(e){return"array"==goog.typeOf(e)},goog.isArrayLike=function(e){var t=goog.typeOf(e);return"array"==t||"object"==t&&"number"==typeof e.length},goog.isDateLike=function(e){return goog.isObject(e)&&"function"==typeof e.getFullYear},goog.isFunction=function(e){return"function"==goog.typeOf(e)},goog.isObject=function(e){var t=typeof e;return"object"==t&&null!=e||"function"==t},goog.getUid=function(e){return Object.prototype.hasOwnProperty.call(e,goog.UID_PROPERTY_)&&e[goog.UID_PROPERTY_]||(e[goog.UID_PROPERTY_]=++goog.uidCounter_)},goog.hasUid=function(e){return!!e[goog.UID_PROPERTY_]},goog.removeUid=function(e){null!==e&&"removeAttribute"in e&&e.removeAttribute(goog.UID_PROPERTY_);try{delete e[goog.UID_PROPERTY_]}catch(e){}},goog.UID_PROPERTY_="closure_uid_"+(1e9*Math.random()>>>0),goog.uidCounter_=0,goog.getHashCode=goog.getUid,goog.removeHashCode=goog.removeUid,goog.cloneObject=function(e){var t=goog.typeOf(e);if("object"==t||"array"==t){if("function"==typeof e.clone)return e.clone();for(var r in t="array"==t?[]:{},e)t[r]=goog.cloneObject(e[r]);return t}return e},goog.bindNative_=function(e,t,r){return e.call.apply(e.bind,arguments)},goog.bindJs_=function(e,t,r){if(!e)throw Error();if(2<arguments.length){var o=Array.prototype.slice.call(arguments,2);return function(){var r=Array.prototype.slice.call(arguments);return Array.prototype.unshift.apply(r,o),e.apply(t,r)}}return function(){return e.apply(t,arguments)}},goog.bind=function(e,t,r){return Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?goog.bind=goog.bindNative_:goog.bind=goog.bindJs_,goog.bind.apply(null,arguments)},goog.partial=function(e,t){var r=Array.prototype.slice.call(arguments,1);return function(){var t=r.slice();return t.push.apply(t,arguments),e.apply(this,t)}},goog.mixin=function(e,t){for(var r in t)e[r]=t[r]},goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date},goog.globalEval=function(e){if(goog.global.execScript)goog.global.execScript(e,"JavaScript");else{if(!goog.global.eval)throw Error("goog.globalEval not available");if(null==goog.evalWorksForGlobals_){try{goog.global.eval("var _evalTest_ = 1;")}catch(e){}if(void 0!==goog.global._evalTest_){try{delete goog.global._evalTest_}catch(e){}goog.evalWorksForGlobals_=!0}else goog.evalWorksForGlobals_=!1}if(goog.evalWorksForGlobals_)goog.global.eval(e);else{var t=goog.global.document,r=t.createElement("script");r.type="text/javascript",r.defer=!1,r.appendChild(t.createTextNode(e)),t.head.appendChild(r),t.head.removeChild(r)}}},goog.evalWorksForGlobals_=null,goog.getCssName=function(e,t){if("."==String(e).charAt(0))throw Error('className passed in goog.getCssName must not start with ".". You passed: '+e);var r=function(e){return goog.cssNameMapping_[e]||e},o=function(e){e=e.split("-");for(var t=[],o=0;o<e.length;o++)t.push(r(e[o]));return t.join("-")};return o=goog.cssNameMapping_?"BY_WHOLE"==goog.cssNameMappingStyle_?r:o:function(e){return e},e=t?e+"-"+o(t):o(e),goog.global.CLOSURE_CSS_NAME_MAP_FN?goog.global.CLOSURE_CSS_NAME_MAP_FN(e):e},goog.setCssNameMapping=function(e,t){goog.cssNameMapping_=e,goog.cssNameMappingStyle_=t},goog.getMsg=function(e,t,r){return r&&r.html&&(e=e.replace(/</g,"&lt;")),t&&(e=e.replace(/\{\$([^}]+)}/g,function(e,r){return null!=t&&r in t?t[r]:e})),e},goog.getMsgWithFallback=function(e,t){return e},goog.exportSymbol=function(e,t,r){goog.exportPath_(e,t,r)},goog.exportProperty=function(e,t,r){e[t]=r},goog.inherits=function(e,t){function r(){}r.prototype=t.prototype,e.superClass_=t.prototype,e.prototype=new r,e.prototype.constructor=e,e.base=function(e,r,o){for(var n=Array(arguments.length-2),i=2;i<arguments.length;i++)n[i-2]=arguments[i];return t.prototype[r].apply(e,n)}},goog.scope=function(e){if(goog.isInModuleLoader_())throw Error("goog.scope is not supported within a module.");e.call(goog.global)},goog.defineClass=function(e,t){var r=t.constructor,o=t.statics;return r&&r!=Object.prototype.constructor||(r=function(){throw Error("cannot instantiate an interface (no constructor defined).")}),r=goog.defineClass.createSealingConstructor_(r,e),e&&goog.inherits(r,e),delete t.constructor,delete t.statics,goog.defineClass.applyProperties_(r.prototype,t),null!=o&&(o instanceof Function?o(r):goog.defineClass.applyProperties_(r,o)),r},goog.defineClass.SEAL_CLASS_INSTANCES=goog.DEBUG,goog.defineClass.createSealingConstructor_=function(e,t){if(!goog.defineClass.SEAL_CLASS_INSTANCES)return e;var r=!goog.defineClass.isUnsealable_(t),o=function(){var t=e.apply(this,arguments)||this;return t[goog.UID_PROPERTY_]=t[goog.UID_PROPERTY_],this.constructor===o&&r&&Object.seal instanceof Function&&Object.seal(t),t};return o},goog.defineClass.isUnsealable_=function(e){return e&&e.prototype&&e.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]},goog.defineClass.OBJECT_PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "),goog.defineClass.applyProperties_=function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);for(var o=0;o<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;o++)r=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[o],Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])},goog.tagUnsealableClass=function(e){},goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable",goog.TRUSTED_TYPES_POLICY_NAME="",goog.identity_=function(e){return e},goog.createTrustedTypesPolicy=function(e){var t=null,r=goog.global.trustedTypes||goog.global.TrustedTypes;if(!r||!r.createPolicy)return t;try{t=r.createPolicy(e,{createHTML:goog.identity_,createScript:goog.identity_,createScriptURL:goog.identity_,createURL:goog.identity_})}catch(e){goog.logToConsole_(e.message)}return t},goog.TRUSTED_TYPES_POLICY_=goog.TRUSTED_TYPES_POLICY_NAME?goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME+"#base"):null,goog.object={},goog.object.is=function(e,t){return e===t?0!==e||1/e==1/t:e!=e&&t!=t},goog.object.forEach=function(e,t,r){for(var o in e)t.call(r,e[o],o,e)},goog.object.filter=function(e,t,r){var o,n={};for(o in e)t.call(r,e[o],o,e)&&(n[o]=e[o]);return n},goog.object.map=function(e,t,r){var o,n={};for(o in e)n[o]=t.call(r,e[o],o,e);return n},goog.object.some=function(e,t,r){for(var o in e)if(t.call(r,e[o],o,e))return!0;return!1},goog.object.every=function(e,t,r){for(var o in e)if(!t.call(r,e[o],o,e))return!1;return!0},goog.object.getCount=function(e){var t,r=0;for(t in e)r++;return r},goog.object.getAnyKey=function(e){for(var t in e)return t},goog.object.getAnyValue=function(e){for(var t in e)return e[t]},goog.object.contains=function(e,t){return goog.object.containsValue(e,t)},goog.object.getValues=function(e){var t,r=[],o=0;for(t in e)r[o++]=e[t];return r},goog.object.getKeys=function(e){var t,r=[],o=0;for(t in e)r[o++]=t;return r},goog.object.getValueByKeys=function(e,t){var r=goog.isArrayLike(t),o=r?t:arguments;for(r=r?0:1;r<o.length;r++){if(null==e)return;e=e[o[r]]}return e},goog.object.containsKey=function(e,t){return null!==e&&t in e},goog.object.containsValue=function(e,t){for(var r in e)if(e[r]==t)return!0;return!1},goog.object.findKey=function(e,t,r){for(var o in e)if(t.call(r,e[o],o,e))return o},goog.object.findValue=function(e,t,r){return(t=goog.object.findKey(e,t,r))&&e[t]},goog.object.isEmpty=function(e){for(var t in e)return!1;return!0},goog.object.clear=function(e){for(var t in e)delete e[t]},goog.object.remove=function(e,t){var r;return(r=t in e)&&delete e[t],r},goog.object.add=function(e,t,r){if(null!==e&&t in e)throw Error('The object already contains the key "'+t+'"');goog.object.set(e,t,r)},goog.object.get=function(e,t,r){return null!==e&&t in e?e[t]:r},goog.object.set=function(e,t,r){e[t]=r},goog.object.setIfUndefined=function(e,t,r){return t in e?e[t]:e[t]=r},goog.object.setWithReturnValueIfNotSet=function(e,t,r){return t in e?e[t]:(r=r(),e[t]=r)},goog.object.equals=function(e,t){for(var r in e)if(!(r in t)||e[r]!==t[r])return!1;for(var o in t)if(!(o in e))return!1;return!0},goog.object.clone=function(e){var t,r={};for(t in e)r[t]=e[t];return r},goog.object.unsafeClone=function(e){var t=goog.typeOf(e);if("object"==t||"array"==t){if(goog.isFunction(e.clone))return e.clone();for(var r in t="array"==t?[]:{},e)t[r]=goog.object.unsafeClone(e[r]);return t}return e},goog.object.transpose=function(e){var t,r={};for(t in e)r[e[t]]=t;return r},goog.object.PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "),goog.object.extend=function(e,t){for(var r,o,n=1;n<arguments.length;n++){for(r in o=arguments[n])e[r]=o[r];for(var i=0;i<goog.object.PROTOTYPE_FIELDS_.length;i++)r=goog.object.PROTOTYPE_FIELDS_[i],Object.prototype.hasOwnProperty.call(o,r)&&(e[r]=o[r])}},goog.object.create=function(e){var t=arguments.length;if(1==t&&Array.isArray(arguments[0]))return goog.object.create.apply(null,arguments[0]);if(t%2)throw Error("Uneven number of arguments");for(var r={},o=0;o<t;o+=2)r[arguments[o]]=arguments[o+1];return r},goog.object.createSet=function(e){var t=arguments.length;if(1==t&&Array.isArray(arguments[0]))return goog.object.createSet.apply(null,arguments[0]);for(var r={},o=0;o<t;o++)r[arguments[o]]=!0;return r},goog.object.createImmutableView=function(e){var t=e;return Object.isFrozen&&!Object.isFrozen(e)&&(t=Object.create(e),Object.freeze(t)),t},goog.object.isImmutableView=function(e){return!!Object.isFrozen&&Object.isFrozen(e)},goog.object.getAllPropertyNames=function(e,t,r){if(!e)return[];if(!Object.getOwnPropertyNames||!Object.getPrototypeOf)return goog.object.getKeys(e);for(var o={};e&&(e!==Object.prototype||t)&&(e!==Function.prototype||r);){for(var n=Object.getOwnPropertyNames(e),i=0;i<n.length;i++)o[n[i]]=!0;e=Object.getPrototypeOf(e)}return goog.object.getKeys(o)},goog.object.getSuperClass=function(e){return(e=Object.getPrototypeOf(e.prototype))&&e.constructor};var jspb={asserts:{}};jspb.asserts.doAssertFailure=function(e,t,r,o){var n="Assertion failed";if(r){n+=": "+r;var i=o}else e&&(n+=": "+e,i=t);throw Error(""+n,i||[])},jspb.asserts.assert=function(e,t,r){for(var o=[],n=2;n<arguments.length;++n)o[n-2]=arguments[n];return e||jspb.asserts.doAssertFailure("",null,t,o),e},jspb.asserts.assertString=function(e,t,r){for(var o=[],n=2;n<arguments.length;++n)o[n-2]=arguments[n];return"string"!=typeof e&&jspb.asserts.doAssertFailure("Expected string but got %s: %s.",[goog.typeOf(e),e],t,o),e},jspb.asserts.assertArray=function(e,t,r){for(var o=[],n=2;n<arguments.length;++n)o[n-2]=arguments[n];return Array.isArray(e)||jspb.asserts.doAssertFailure("Expected array but got %s: %s.",[goog.typeOf(e),e],t,o),e},jspb.asserts.fail=function(e,t){for(var r=[],o=1;o<arguments.length;++o)r[o-1]=arguments[o];throw Error("Failure"+(e?": "+e:""),r)},jspb.asserts.assertInstanceof=function(e,t,r,o){for(var n=[],i=3;i<arguments.length;++i)n[i-3]=arguments[i];return e instanceof t||jspb.asserts.doAssertFailure("Expected instanceof %s but got %s.",[jspb.asserts.getType(t),jspb.asserts.getType(e)],r,n),e},jspb.asserts.getType=function(e){return e instanceof Function?e.displayName||e.name||"unknown type name":e instanceof Object?e.constructor.displayName||e.constructor.name||Object.prototype.toString.call(e):null===e?"null":typeof e},jspb.BinaryConstants={},jspb.ConstBinaryMessage=function(){},jspb.BinaryMessage=function(){},jspb.BinaryConstants.FieldType={INVALID:-1,DOUBLE:1,FLOAT:2,INT64:3,UINT64:4,INT32:5,FIXED64:6,FIXED32:7,BOOL:8,STRING:9,GROUP:10,MESSAGE:11,BYTES:12,UINT32:13,ENUM:14,SFIXED32:15,SFIXED64:16,SINT32:17,SINT64:18,FHASH64:30,VHASH64:31},jspb.BinaryConstants.WireType={INVALID:-1,VARINT:0,FIXED64:1,DELIMITED:2,START_GROUP:3,END_GROUP:4,FIXED32:5},jspb.BinaryConstants.FieldTypeToWireType=function(e){var t=jspb.BinaryConstants.FieldType,r=jspb.BinaryConstants.WireType;switch(e){case t.INT32:case t.INT64:case t.UINT32:case t.UINT64:case t.SINT32:case t.SINT64:case t.BOOL:case t.ENUM:case t.VHASH64:return r.VARINT;case t.DOUBLE:case t.FIXED64:case t.SFIXED64:case t.FHASH64:return r.FIXED64;case t.STRING:case t.MESSAGE:case t.BYTES:return r.DELIMITED;case t.FLOAT:case t.FIXED32:case t.SFIXED32:return r.FIXED32;default:return r.INVALID}},jspb.BinaryConstants.INVALID_FIELD_NUMBER=-1,jspb.BinaryConstants.FLOAT32_EPS=1401298464324817e-60,jspb.BinaryConstants.FLOAT32_MIN=11754943508222875e-54,jspb.BinaryConstants.FLOAT32_MAX=34028234663852886e22,jspb.BinaryConstants.FLOAT64_EPS=5e-324,jspb.BinaryConstants.FLOAT64_MIN=22250738585072014e-324,jspb.BinaryConstants.FLOAT64_MAX=17976931348623157e292,jspb.BinaryConstants.TWO_TO_20=1048576,jspb.BinaryConstants.TWO_TO_23=8388608,jspb.BinaryConstants.TWO_TO_31=2147483648,jspb.BinaryConstants.TWO_TO_32=4294967296,jspb.BinaryConstants.TWO_TO_52=4503599627370496,jspb.BinaryConstants.TWO_TO_63=0x8000000000000000,jspb.BinaryConstants.TWO_TO_64=0x10000000000000000,jspb.BinaryConstants.ZERO_HASH="\0\0\0\0\0\0\0\0",goog.debug={},goog.debug.Error=function(e){if(Error.captureStackTrace)Error.captureStackTrace(this,goog.debug.Error);else{var t=Error().stack;t&&(this.stack=t)}e&&(this.message=String(e)),this.reportErrorToServer=!0},goog.inherits(goog.debug.Error,Error),goog.debug.Error.prototype.name="CustomError",goog.dom={},goog.dom.NodeType={ELEMENT:1,ATTRIBUTE:2,TEXT:3,CDATA_SECTION:4,ENTITY_REFERENCE:5,ENTITY:6,PROCESSING_INSTRUCTION:7,COMMENT:8,DOCUMENT:9,DOCUMENT_TYPE:10,DOCUMENT_FRAGMENT:11,NOTATION:12},goog.asserts={},goog.asserts.ENABLE_ASSERTS=goog.DEBUG,goog.asserts.AssertionError=function(e,t){goog.debug.Error.call(this,goog.asserts.subs_(e,t)),this.messagePattern=e},goog.inherits(goog.asserts.AssertionError,goog.debug.Error),goog.asserts.AssertionError.prototype.name="AssertionError",goog.asserts.DEFAULT_ERROR_HANDLER=function(e){throw e},goog.asserts.errorHandler_=goog.asserts.DEFAULT_ERROR_HANDLER,goog.asserts.subs_=function(e,t){for(var r="",o=(e=e.split("%s")).length-1,n=0;n<o;n++)r+=e[n]+(n<t.length?t[n]:"%s");return r+e[o]},goog.asserts.doAssertFailure_=function(e,t,r,o){var n="Assertion failed";if(r){n+=": "+r;var i=o}else e&&(n+=": "+e,i=t);e=new goog.asserts.AssertionError(""+n,i||[]),goog.asserts.errorHandler_(e)},goog.asserts.setErrorHandler=function(e){goog.asserts.ENABLE_ASSERTS&&(goog.asserts.errorHandler_=e)},goog.asserts.assert=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&!e&&goog.asserts.doAssertFailure_("",null,t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertExists=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&null==e&&goog.asserts.doAssertFailure_("Expected to exist: %s.",[e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.fail=function(e,t){goog.asserts.ENABLE_ASSERTS&&goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure"+(e?": "+e:""),Array.prototype.slice.call(arguments,1)))},goog.asserts.assertNumber=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&"number"!=typeof e&&goog.asserts.doAssertFailure_("Expected number but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertString=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&"string"!=typeof e&&goog.asserts.doAssertFailure_("Expected string but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertFunction=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&!goog.isFunction(e)&&goog.asserts.doAssertFailure_("Expected function but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertObject=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&!goog.isObject(e)&&goog.asserts.doAssertFailure_("Expected object but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertArray=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&!Array.isArray(e)&&goog.asserts.doAssertFailure_("Expected array but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertBoolean=function(e,t,r){return goog.asserts.ENABLE_ASSERTS&&"boolean"!=typeof e&&goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertElement=function(e,t,r){return!goog.asserts.ENABLE_ASSERTS||goog.isObject(e)&&e.nodeType==goog.dom.NodeType.ELEMENT||goog.asserts.doAssertFailure_("Expected Element but got %s: %s.",[goog.typeOf(e),e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertInstanceof=function(e,t,r,o){return!goog.asserts.ENABLE_ASSERTS||e instanceof t||goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.",[goog.asserts.getType_(t),goog.asserts.getType_(e)],r,Array.prototype.slice.call(arguments,3)),e},goog.asserts.assertFinite=function(e,t,r){return!goog.asserts.ENABLE_ASSERTS||"number"==typeof e&&isFinite(e)||goog.asserts.doAssertFailure_("Expected %s to be a finite number but it is not.",[e],t,Array.prototype.slice.call(arguments,2)),e},goog.asserts.assertObjectPrototypeIsIntact=function(){for(var e in Object.prototype)goog.asserts.fail(e+" should not be enumerable in Object.prototype.")},goog.asserts.getType_=function(e){return e instanceof Function?e.displayName||e.name||"unknown type name":e instanceof Object?e.constructor.displayName||e.constructor.name||Object.prototype.toString.call(e):null===e?"null":typeof e},goog.array={},goog.NATIVE_ARRAY_PROTOTYPES=goog.TRUSTED_SITE,goog.array.ASSUME_NATIVE_FUNCTIONS=2012<goog.FEATURESET_YEAR,goog.array.peek=function(e){return e[e.length-1]},goog.array.last=goog.array.peek,goog.array.indexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.indexOf)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.indexOf.call(e,t,r)}:function(e,t,r){if(r=null==r?0:0>r?Math.max(0,e.length+r):r,"string"==typeof e)return"string"!=typeof t||1!=t.length?-1:e.indexOf(t,r);for(;r<e.length;r++)if(r in e&&e[r]===t)return r;return-1},goog.array.lastIndexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.lastIndexOf)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.lastIndexOf.call(e,t,null==r?e.length-1:r)}:function(e,t,r){if(0>(r=null==r?e.length-1:r)&&(r=Math.max(0,e.length+r)),"string"==typeof e)return"string"!=typeof t||1!=t.length?-1:e.lastIndexOf(t,r);for(;0<=r;r--)if(r in e&&e[r]===t)return r;return-1},goog.array.forEach=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.forEach)?function(e,t,r){goog.asserts.assert(null!=e.length),Array.prototype.forEach.call(e,t,r)}:function(e,t,r){for(var o=e.length,n="string"==typeof e?e.split(""):e,i=0;i<o;i++)i in n&&t.call(r,n[i],i,e)},goog.array.forEachRight=function(e,t,r){var o=e.length,n="string"==typeof e?e.split(""):e;for(--o;0<=o;--o)o in n&&t.call(r,n[o],o,e)},goog.array.filter=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.filter)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.filter.call(e,t,r)}:function(e,t,r){for(var o=e.length,n=[],i=0,a="string"==typeof e?e.split(""):e,s=0;s<o;s++)if(s in a){var p=a[s];t.call(r,p,s,e)&&(n[i++]=p)}return n},goog.array.map=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.map)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.map.call(e,t,r)}:function(e,t,r){for(var o=e.length,n=Array(o),i="string"==typeof e?e.split(""):e,a=0;a<o;a++)a in i&&(n[a]=t.call(r,i[a],a,e));return n},goog.array.reduce=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduce)?function(e,t,r,o){return goog.asserts.assert(null!=e.length),o&&(t=goog.bind(t,o)),Array.prototype.reduce.call(e,t,r)}:function(e,t,r,o){var n=r;return goog.array.forEach(e,function(r,i){n=t.call(o,n,r,i,e)}),n},goog.array.reduceRight=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduceRight)?function(e,t,r,o){return goog.asserts.assert(null!=e.length),goog.asserts.assert(null!=t),o&&(t=goog.bind(t,o)),Array.prototype.reduceRight.call(e,t,r)}:function(e,t,r,o){var n=r;return goog.array.forEachRight(e,function(r,i){n=t.call(o,n,r,i,e)}),n},goog.array.some=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.some)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.some.call(e,t,r)}:function(e,t,r){for(var o=e.length,n="string"==typeof e?e.split(""):e,i=0;i<o;i++)if(i in n&&t.call(r,n[i],i,e))return!0;return!1},goog.array.every=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.every)?function(e,t,r){return goog.asserts.assert(null!=e.length),Array.prototype.every.call(e,t,r)}:function(e,t,r){for(var o=e.length,n="string"==typeof e?e.split(""):e,i=0;i<o;i++)if(i in n&&!t.call(r,n[i],i,e))return!1;return!0},goog.array.count=function(e,t,r){var o=0;return goog.array.forEach(e,function(e,n,i){t.call(r,e,n,i)&&++o},r),o},goog.array.find=function(e,t,r){return 0>(t=goog.array.findIndex(e,t,r))?null:"string"==typeof e?e.charAt(t):e[t]},goog.array.findIndex=function(e,t,r){for(var o=e.length,n="string"==typeof e?e.split(""):e,i=0;i<o;i++)if(i in n&&t.call(r,n[i],i,e))return i;return-1},goog.array.findRight=function(e,t,r){return 0>(t=goog.array.findIndexRight(e,t,r))?null:"string"==typeof e?e.charAt(t):e[t]},goog.array.findIndexRight=function(e,t,r){var o=e.length,n="string"==typeof e?e.split(""):e;for(--o;0<=o;o--)if(o in n&&t.call(r,n[o],o,e))return o;return-1},goog.array.contains=function(e,t){return 0<=goog.array.indexOf(e,t)},goog.array.isEmpty=function(e){return 0==e.length},goog.array.clear=function(e){if(!Array.isArray(e))for(var t=e.length-1;0<=t;t--)delete e[t];e.length=0},goog.array.insert=function(e,t){goog.array.contains(e,t)||e.push(t)},goog.array.insertAt=function(e,t,r){goog.array.splice(e,r,0,t)},goog.array.insertArrayAt=function(e,t,r){goog.partial(goog.array.splice,e,r,0).apply(null,t)},goog.array.insertBefore=function(e,t,r){var o;2==arguments.length||0>(o=goog.array.indexOf(e,r))?e.push(t):goog.array.insertAt(e,t,o)},goog.array.remove=function(e,t){var r;return(r=0<=(t=goog.array.indexOf(e,t)))&&goog.array.removeAt(e,t),r},goog.array.removeLast=function(e,t){return 0<=(t=goog.array.lastIndexOf(e,t))&&(goog.array.removeAt(e,t),!0)},goog.array.removeAt=function(e,t){return goog.asserts.assert(null!=e.length),1==Array.prototype.splice.call(e,t,1).length},goog.array.removeIf=function(e,t,r){return 0<=(t=goog.array.findIndex(e,t,r))&&(goog.array.removeAt(e,t),!0)},goog.array.removeAllIf=function(e,t,r){var o=0;return goog.array.forEachRight(e,function(n,i){t.call(r,n,i,e)&&goog.array.removeAt(e,i)&&o++}),o},goog.array.concat=function(e){return Array.prototype.concat.apply([],arguments)},goog.array.join=function(e){return Array.prototype.concat.apply([],arguments)},goog.array.toArray=function(e){var t=e.length;if(0<t){for(var r=Array(t),o=0;o<t;o++)r[o]=e[o];return r}return[]},goog.array.clone=goog.array.toArray,goog.array.extend=function(e,t){for(var r=1;r<arguments.length;r++){var o=arguments[r];if(goog.isArrayLike(o)){var n=e.length||0,i=o.length||0;e.length=n+i;for(var a=0;a<i;a++)e[n+a]=o[a]}else e.push(o)}},goog.array.splice=function(e,t,r,o){return goog.asserts.assert(null!=e.length),Array.prototype.splice.apply(e,goog.array.slice(arguments,1))},goog.array.slice=function(e,t,r){return goog.asserts.assert(null!=e.length),2>=arguments.length?Array.prototype.slice.call(e,t):Array.prototype.slice.call(e,t,r)},goog.array.removeDuplicates=function(e,t,r){t=t||e;var o=function(e){return goog.isObject(e)?"o"+goog.getUid(e):(typeof e).charAt(0)+e};r=r||o,o={};for(var n=0,i=0;i<e.length;){var a=e[i++],s=r(a);Object.prototype.hasOwnProperty.call(o,s)||(o[s]=!0,t[n++]=a)}t.length=n},goog.array.binarySearch=function(e,t,r){return goog.array.binarySearch_(e,r||goog.array.defaultCompare,!1,t)},goog.array.binarySelect=function(e,t,r){return goog.array.binarySearch_(e,t,!0,void 0,r)},goog.array.binarySearch_=function(e,t,r,o,n){for(var i,a=0,s=e.length;a<s;){var p=a+(s-a>>>1),c=r?t.call(n,e[p],p,e):t(o,e[p]);0<c?a=p+1:(s=p,i=!c)}return i?a:-a-1},goog.array.sort=function(e,t){e.sort(t||goog.array.defaultCompare)},goog.array.stableSort=function(e,t){for(var r=Array(e.length),o=0;o<e.length;o++)r[o]={index:o,value:e[o]};var n=t||goog.array.defaultCompare;for(goog.array.sort(r,function(e,t){return n(e.value,t.value)||e.index-t.index}),o=0;o<e.length;o++)e[o]=r[o].value},goog.array.sortByKey=function(e,t,r){var o=r||goog.array.defaultCompare;goog.array.sort(e,function(e,r){return o(t(e),t(r))})},goog.array.sortObjectsByKey=function(e,t,r){goog.array.sortByKey(e,function(e){return e[t]},r)},goog.array.isSorted=function(e,t,r){t=t||goog.array.defaultCompare;for(var o=1;o<e.length;o++){var n=t(e[o-1],e[o]);if(0<n||0==n&&r)return!1}return!0},goog.array.equals=function(e,t,r){if(!goog.isArrayLike(e)||!goog.isArrayLike(t)||e.length!=t.length)return!1;var o=e.length;r=r||goog.array.defaultCompareEquality;for(var n=0;n<o;n++)if(!r(e[n],t[n]))return!1;return!0},goog.array.compare3=function(e,t,r){r=r||goog.array.defaultCompare;for(var o=Math.min(e.length,t.length),n=0;n<o;n++){var i=r(e[n],t[n]);if(0!=i)return i}return goog.array.defaultCompare(e.length,t.length)},goog.array.defaultCompare=function(e,t){return e>t?1:e<t?-1:0},goog.array.inverseDefaultCompare=function(e,t){return-goog.array.defaultCompare(e,t)},goog.array.defaultCompareEquality=function(e,t){return e===t},goog.array.binaryInsert=function(e,t,r){return 0>(r=goog.array.binarySearch(e,t,r))&&(goog.array.insertAt(e,t,-(r+1)),!0)},goog.array.binaryRemove=function(e,t,r){return 0<=(t=goog.array.binarySearch(e,t,r))&&goog.array.removeAt(e,t)},goog.array.bucket=function(e,t,r){for(var o={},n=0;n<e.length;n++){var i=e[n],a=t.call(r,i,n,e);void 0!==a&&(o[a]||(o[a]=[])).push(i)}return o},goog.array.toObject=function(e,t,r){var o={};return goog.array.forEach(e,function(n,i){o[t.call(r,n,i,e)]=n}),o},goog.array.range=function(e,t,r){var o=[],n=0,i=e;if(void 0!==t&&(n=e,i=t),0>(r=r||1)*(i-n))return[];if(0<r)for(e=n;e<i;e+=r)o.push(e);else for(e=n;e>i;e+=r)o.push(e);return o},goog.array.repeat=function(e,t){for(var r=[],o=0;o<t;o++)r[o]=e;return r},goog.array.flatten=function(e){for(var t=[],r=0;r<arguments.length;r++){var o=arguments[r];if(Array.isArray(o))for(var n=0;n<o.length;n+=8192){var i=goog.array.slice(o,n,n+8192);i=goog.array.flatten.apply(null,i);for(var a=0;a<i.length;a++)t.push(i[a])}else t.push(o)}return t},goog.array.rotate=function(e,t){return goog.asserts.assert(null!=e.length),e.length&&(0<(t%=e.length)?Array.prototype.unshift.apply(e,e.splice(-t,t)):0>t&&Array.prototype.push.apply(e,e.splice(0,-t))),e},goog.array.moveItem=function(e,t,r){goog.asserts.assert(0<=t&&t<e.length),goog.asserts.assert(0<=r&&r<e.length),t=Array.prototype.splice.call(e,t,1),Array.prototype.splice.call(e,r,0,t[0])},goog.array.zip=function(e){if(!arguments.length)return[];for(var t=[],r=arguments[0].length,o=1;o<arguments.length;o++)arguments[o].length<r&&(r=arguments[o].length);for(o=0;o<r;o++){for(var n=[],i=0;i<arguments.length;i++)n.push(arguments[i][o]);t.push(n)}return t},goog.array.shuffle=function(e,t){t=t||Math.random;for(var r=e.length-1;0<r;r--){var o=Math.floor(t()*(r+1)),n=e[r];e[r]=e[o],e[o]=n}},goog.array.copyByIndex=function(e,t){var r=[];return goog.array.forEach(t,function(t){r.push(e[t])}),r},goog.array.concatMap=function(e,t,r){return goog.array.concat.apply([],goog.array.map(e,t,r))},goog.crypt={},goog.crypt.stringToByteArray=function(e){for(var t=[],r=0,o=0;o<e.length;o++){var n=e.charCodeAt(o);255<n&&(t[r++]=255&n,n>>=8),t[r++]=n}return t},goog.crypt.byteArrayToString=function(e){if(8192>=e.length)return String.fromCharCode.apply(null,e);for(var t="",r=0;r<e.length;r+=8192){var o=goog.array.slice(e,r,r+8192);t+=String.fromCharCode.apply(null,o)}return t},goog.crypt.byteArrayToHex=function(e,t){return goog.array.map(e,function(e){return 1<(e=e.toString(16)).length?e:"0"+e}).join(t||"")},goog.crypt.hexToByteArray=function(e){goog.asserts.assert(0==e.length%2,"Key string length must be multiple of 2");for(var t=[],r=0;r<e.length;r+=2)t.push(parseInt(e.substring(r,r+2),16));return t},goog.crypt.stringToUtf8ByteArray=function(e){for(var t=[],r=0,o=0;o<e.length;o++){var n=e.charCodeAt(o);128>n?t[r++]=n:(2048>n?t[r++]=n>>6|192:(55296==(64512&n)&&o+1<e.length&&56320==(64512&e.charCodeAt(o+1))?(n=65536+((1023&n)<<10)+(1023&e.charCodeAt(++o)),t[r++]=n>>18|240,t[r++]=n>>12&63|128):t[r++]=n>>12|224,t[r++]=n>>6&63|128),t[r++]=63&n|128)}return t},goog.crypt.utf8ByteArrayToString=function(e){for(var t=[],r=0,o=0;r<e.length;){var n=e[r++];if(128>n)t[o++]=String.fromCharCode(n);else if(191<n&&224>n){var i=e[r++];t[o++]=String.fromCharCode((31&n)<<6|63&i)}else if(239<n&&365>n){i=e[r++];var a=e[r++];n=((7&n)<<18|(63&i)<<12|(63&a)<<6|63&e[r++])-65536,t[o++]=String.fromCharCode(55296+(n>>10)),t[o++]=String.fromCharCode(56320+(1023&n))}else i=e[r++],a=e[r++],t[o++]=String.fromCharCode((15&n)<<12|(63&i)<<6|63&a)}return t.join("")},goog.crypt.xorByteArray=function(e,t){goog.asserts.assert(e.length==t.length,"XOR array lengths must match");for(var r=[],o=0;o<e.length;o++)r.push(e[o]^t[o]);return r},goog.dom.asserts={},goog.dom.asserts.assertIsLocation=function(e){if(goog.asserts.ENABLE_ASSERTS){var t=goog.dom.asserts.getWindow_(e);t&&(!e||!(e instanceof t.Location)&&e instanceof t.Element)&&goog.asserts.fail("Argument is not a Location (or a non-Element mock); got: %s",goog.dom.asserts.debugStringForType_(e))}return e},goog.dom.asserts.assertIsElementType_=function(e,t){if(goog.asserts.ENABLE_ASSERTS){var r=goog.dom.asserts.getWindow_(e);r&&void 0!==r[t]&&(e&&(e instanceof r[t]||!(e instanceof r.Location||e instanceof r.Element))||goog.asserts.fail("Argument is not a %s (or a non-Element, non-Location mock); got: %s",t,goog.dom.asserts.debugStringForType_(e)))}return e},goog.dom.asserts.assertIsHTMLAnchorElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLAnchorElement")},goog.dom.asserts.assertIsHTMLButtonElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLButtonElement")},goog.dom.asserts.assertIsHTMLLinkElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLLinkElement")},goog.dom.asserts.assertIsHTMLImageElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLImageElement")},goog.dom.asserts.assertIsHTMLAudioElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLAudioElement")},goog.dom.asserts.assertIsHTMLVideoElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLVideoElement")},goog.dom.asserts.assertIsHTMLInputElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLInputElement")},goog.dom.asserts.assertIsHTMLTextAreaElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLTextAreaElement")},goog.dom.asserts.assertIsHTMLCanvasElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLCanvasElement")},goog.dom.asserts.assertIsHTMLEmbedElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLEmbedElement")},goog.dom.asserts.assertIsHTMLFormElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLFormElement")},goog.dom.asserts.assertIsHTMLFrameElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLFrameElement")},goog.dom.asserts.assertIsHTMLIFrameElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLIFrameElement")},goog.dom.asserts.assertIsHTMLObjectElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLObjectElement")},goog.dom.asserts.assertIsHTMLScriptElement=function(e){return goog.dom.asserts.assertIsElementType_(e,"HTMLScriptElement")},goog.dom.asserts.debugStringForType_=function(e){if(!goog.isObject(e))return void 0===e?"undefined":null===e?"null":typeof e;try{return e.constructor.displayName||e.constructor.name||Object.prototype.toString.call(e)}catch(e){return"<object could not be stringified>"}},goog.dom.asserts.getWindow_=function(e){try{var t=e&&e.ownerDocument,r=t&&(t.defaultView||t.parentWindow);if((r=r||goog.global).Element&&r.Location)return r}catch(e){}return null},goog.functions={},goog.functions.constant=function(e){return function(){return e}},goog.functions.FALSE=function(){return!1},goog.functions.TRUE=function(){return!0},goog.functions.NULL=function(){return null},goog.functions.identity=function(e,t){return e},goog.functions.error=function(e){return function(){throw Error(e)}},goog.functions.fail=function(e){return function(){throw e}},goog.functions.lock=function(e,t){return t=t||0,function(){return e.apply(this,Array.prototype.slice.call(arguments,0,t))}},goog.functions.nth=function(e){return function(){return arguments[e]}},goog.functions.partialRight=function(e,t){var r=Array.prototype.slice.call(arguments,1);return function(){var t=Array.prototype.slice.call(arguments);return t.push.apply(t,r),e.apply(this,t)}},goog.functions.withReturnValue=function(e,t){return goog.functions.sequence(e,goog.functions.constant(t))},goog.functions.equalTo=function(e,t){return function(r){return t?e==r:e===r}},goog.functions.compose=function(e,t){var r=arguments,o=r.length;return function(){var e;o&&(e=r[o-1].apply(this,arguments));for(var t=o-2;0<=t;t--)e=r[t].call(this,e);return e}},goog.functions.sequence=function(e){var t=arguments,r=t.length;return function(){for(var e,o=0;o<r;o++)e=t[o].apply(this,arguments);return e}},goog.functions.and=function(e){var t=arguments,r=t.length;return function(){for(var e=0;e<r;e++)if(!t[e].apply(this,arguments))return!1;return!0}},goog.functions.or=function(e){var t=arguments,r=t.length;return function(){for(var e=0;e<r;e++)if(t[e].apply(this,arguments))return!0;return!1}},goog.functions.not=function(e){return function(){return!e.apply(this,arguments)}},goog.functions.create=function(e,t){var r=function(){};return r.prototype=e.prototype,r=new r,e.apply(r,Array.prototype.slice.call(arguments,1)),r},goog.functions.CACHE_RETURN_VALUE=!0,goog.functions.cacheReturnValue=function(e){var t,r=!1;return function(){return goog.functions.CACHE_RETURN_VALUE?(r||(t=e(),r=!0),t):e()}},goog.functions.once=function(e){var t=e;return function(){if(t){var e=t;t=null,e()}}},goog.functions.debounce=function(e,t,r){var o=0;return function(n){goog.global.clearTimeout(o);var i=arguments;o=goog.global.setTimeout(function(){e.apply(r,i)},t)}},goog.functions.throttle=function(e,t,r){var o=0,n=!1,i=[],a=function(){o=0,n&&(n=!1,s())},s=function(){o=goog.global.setTimeout(a,t),e.apply(r,i)};return function(e){i=arguments,o?n=!0:s()}},goog.functions.rateLimit=function(e,t,r){var o=0,n=function(){o=0};return function(i){o||(o=goog.global.setTimeout(n,t),e.apply(r,arguments))}},goog.dom.HtmlElement=function(){},goog.dom.TagName=function(e){this.tagName_=e},goog.dom.TagName.prototype.toString=function(){return this.tagName_},goog.dom.TagName.A=new goog.dom.TagName("A"),goog.dom.TagName.ABBR=new goog.dom.TagName("ABBR"),goog.dom.TagName.ACRONYM=new goog.dom.TagName("ACRONYM"),goog.dom.TagName.ADDRESS=new goog.dom.TagName("ADDRESS"),goog.dom.TagName.APPLET=new goog.dom.TagName("APPLET"),goog.dom.TagName.AREA=new goog.dom.TagName("AREA"),goog.dom.TagName.ARTICLE=new goog.dom.TagName("ARTICLE"),goog.dom.TagName.ASIDE=new goog.dom.TagName("ASIDE"),goog.dom.TagName.AUDIO=new goog.dom.TagName("AUDIO"),goog.dom.TagName.B=new goog.dom.TagName("B"),goog.dom.TagName.BASE=new goog.dom.TagName("BASE"),goog.dom.TagName.BASEFONT=new goog.dom.TagName("BASEFONT"),goog.dom.TagName.BDI=new goog.dom.TagName("BDI"),goog.dom.TagName.BDO=new goog.dom.TagName("BDO"),goog.dom.TagName.BIG=new goog.dom.TagName("BIG"),goog.dom.TagName.BLOCKQUOTE=new goog.dom.TagName("BLOCKQUOTE"),goog.dom.TagName.BODY=new goog.dom.TagName("BODY"),goog.dom.TagName.BR=new goog.dom.TagName("BR"),goog.dom.TagName.BUTTON=new goog.dom.TagName("BUTTON"),goog.dom.TagName.CANVAS=new goog.dom.TagName("CANVAS"),goog.dom.TagName.CAPTION=new goog.dom.TagName("CAPTION"),goog.dom.TagName.CENTER=new goog.dom.TagName("CENTER"),goog.dom.TagName.CITE=new goog.dom.TagName("CITE"),goog.dom.TagName.CODE=new goog.dom.TagName("CODE"),goog.dom.TagName.COL=new goog.dom.TagName("COL"),goog.dom.TagName.COLGROUP=new goog.dom.TagName("COLGROUP"),goog.dom.TagName.COMMAND=new goog.dom.TagName("COMMAND"),goog.dom.TagName.DATA=new goog.dom.TagName("DATA"),goog.dom.TagName.DATALIST=new goog.dom.TagName("DATALIST"),goog.dom.TagName.DD=new goog.dom.TagName("DD"),goog.dom.TagName.DEL=new goog.dom.TagName("DEL"),goog.dom.TagName.DETAILS=new goog.dom.TagName("DETAILS"),goog.dom.TagName.DFN=new goog.dom.TagName("DFN"),goog.dom.TagName.DIALOG=new goog.dom.TagName("DIALOG"),goog.dom.TagName.DIR=new goog.dom.TagName("DIR"),goog.dom.TagName.DIV=new goog.dom.TagName("DIV"),goog.dom.TagName.DL=new goog.dom.TagName("DL"),goog.dom.TagName.DT=new goog.dom.TagName("DT"),goog.dom.TagName.EM=new goog.dom.TagName("EM"),goog.dom.TagName.EMBED=new goog.dom.TagName("EMBED"),goog.dom.TagName.FIELDSET=new goog.dom.TagName("FIELDSET"),goog.dom.TagName.FIGCAPTION=new goog.dom.TagName("FIGCAPTION"),goog.dom.TagName.FIGURE=new goog.dom.TagName("FIGURE"),goog.dom.TagName.FONT=new goog.dom.TagName("FONT"),goog.dom.TagName.FOOTER=new goog.dom.TagName("FOOTER"),goog.dom.TagName.FORM=new goog.dom.TagName("FORM"),goog.dom.TagName.FRAME=new goog.dom.TagName("FRAME"),goog.dom.TagName.FRAMESET=new goog.dom.TagName("FRAMESET"),goog.dom.TagName.H1=new goog.dom.TagName("H1"),goog.dom.TagName.H2=new goog.dom.TagName("H2"),goog.dom.TagName.H3=new goog.dom.TagName("H3"),goog.dom.TagName.H4=new goog.dom.TagName("H4"),goog.dom.TagName.H5=new goog.dom.TagName("H5"),goog.dom.TagName.H6=new goog.dom.TagName("H6"),goog.dom.TagName.HEAD=new goog.dom.TagName("HEAD"),goog.dom.TagName.HEADER=new goog.dom.TagName("HEADER"),goog.dom.TagName.HGROUP=new goog.dom.TagName("HGROUP"),goog.dom.TagName.HR=new goog.dom.TagName("HR"),goog.dom.TagName.HTML=new goog.dom.TagName("HTML"),goog.dom.TagName.I=new goog.dom.TagName("I"),goog.dom.TagName.IFRAME=new goog.dom.TagName("IFRAME"),goog.dom.TagName.IMG=new goog.dom.TagName("IMG"),goog.dom.TagName.INPUT=new goog.dom.TagName("INPUT"),goog.dom.TagName.INS=new goog.dom.TagName("INS"),goog.dom.TagName.ISINDEX=new goog.dom.TagName("ISINDEX"),goog.dom.TagName.KBD=new goog.dom.TagName("KBD"),goog.dom.TagName.KEYGEN=new goog.dom.TagName("KEYGEN"),goog.dom.TagName.LABEL=new goog.dom.TagName("LABEL"),goog.dom.TagName.LEGEND=new goog.dom.TagName("LEGEND"),goog.dom.TagName.LI=new goog.dom.TagName("LI"),goog.dom.TagName.LINK=new goog.dom.TagName("LINK"),goog.dom.TagName.MAIN=new goog.dom.TagName("MAIN"),goog.dom.TagName.MAP=new goog.dom.TagName("MAP"),goog.dom.TagName.MARK=new goog.dom.TagName("MARK"),goog.dom.TagName.MATH=new goog.dom.TagName("MATH"),goog.dom.TagName.MENU=new goog.dom.TagName("MENU"),goog.dom.TagName.MENUITEM=new goog.dom.TagName("MENUITEM"),goog.dom.TagName.META=new goog.dom.TagName("META"),goog.dom.TagName.METER=new goog.dom.TagName("METER"),goog.dom.TagName.NAV=new goog.dom.TagName("NAV"),goog.dom.TagName.NOFRAMES=new goog.dom.TagName("NOFRAMES"),goog.dom.TagName.NOSCRIPT=new goog.dom.TagName("NOSCRIPT"),goog.dom.TagName.OBJECT=new goog.dom.TagName("OBJECT"),goog.dom.TagName.OL=new goog.dom.TagName("OL"),goog.dom.TagName.OPTGROUP=new goog.dom.TagName("OPTGROUP"),goog.dom.TagName.OPTION=new goog.dom.TagName("OPTION"),goog.dom.TagName.OUTPUT=new goog.dom.TagName("OUTPUT"),goog.dom.TagName.P=new goog.dom.TagName("P"),goog.dom.TagName.PARAM=new goog.dom.TagName("PARAM"),goog.dom.TagName.PICTURE=new goog.dom.TagName("PICTURE"),goog.dom.TagName.PRE=new goog.dom.TagName("PRE"),goog.dom.TagName.PROGRESS=new goog.dom.TagName("PROGRESS"),goog.dom.TagName.Q=new goog.dom.TagName("Q"),goog.dom.TagName.RP=new goog.dom.TagName("RP"),goog.dom.TagName.RT=new goog.dom.TagName("RT"),goog.dom.TagName.RTC=new goog.dom.TagName("RTC"),goog.dom.TagName.RUBY=new goog.dom.TagName("RUBY"),goog.dom.TagName.S=new goog.dom.TagName("S"),goog.dom.TagName.SAMP=new goog.dom.TagName("SAMP"),goog.dom.TagName.SCRIPT=new goog.dom.TagName("SCRIPT"),goog.dom.TagName.SECTION=new goog.dom.TagName("SECTION"),goog.dom.TagName.SELECT=new goog.dom.TagName("SELECT"),goog.dom.TagName.SMALL=new goog.dom.TagName("SMALL"),goog.dom.TagName.SOURCE=new goog.dom.TagName("SOURCE"),goog.dom.TagName.SPAN=new goog.dom.TagName("SPAN"),goog.dom.TagName.STRIKE=new goog.dom.TagName("STRIKE"),goog.dom.TagName.STRONG=new goog.dom.TagName("STRONG"),goog.dom.TagName.STYLE=new goog.dom.TagName("STYLE"),goog.dom.TagName.SUB=new goog.dom.TagName("SUB"),goog.dom.TagName.SUMMARY=new goog.dom.TagName("SUMMARY"),goog.dom.TagName.SUP=new goog.dom.TagName("SUP"),goog.dom.TagName.SVG=new goog.dom.TagName("SVG"),goog.dom.TagName.TABLE=new goog.dom.TagName("TABLE"),goog.dom.TagName.TBODY=new goog.dom.TagName("TBODY"),goog.dom.TagName.TD=new goog.dom.TagName("TD"),goog.dom.TagName.TEMPLATE=new goog.dom.TagName("TEMPLATE"),goog.dom.TagName.TEXTAREA=new goog.dom.TagName("TEXTAREA"),goog.dom.TagName.TFOOT=new goog.dom.TagName("TFOOT"),goog.dom.TagName.TH=new goog.dom.TagName("TH"),goog.dom.TagName.THEAD=new goog.dom.TagName("THEAD"),goog.dom.TagName.TIME=new goog.dom.TagName("TIME"),goog.dom.TagName.TITLE=new goog.dom.TagName("TITLE"),goog.dom.TagName.TR=new goog.dom.TagName("TR"),goog.dom.TagName.TRACK=new goog.dom.TagName("TRACK"),goog.dom.TagName.TT=new goog.dom.TagName("TT"),goog.dom.TagName.U=new goog.dom.TagName("U"),goog.dom.TagName.UL=new goog.dom.TagName("UL"),goog.dom.TagName.VAR=new goog.dom.TagName("VAR"),goog.dom.TagName.VIDEO=new goog.dom.TagName("VIDEO"),goog.dom.TagName.WBR=new goog.dom.TagName("WBR"),goog.dom.tags={},goog.dom.tags.VOID_TAGS_={area:!0,base:!0,br:!0,col:!0,command:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0},goog.dom.tags.isVoidTag=function(e){return!0===goog.dom.tags.VOID_TAGS_[e]},goog.html={},goog.html.trustedtypes={},goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY=goog.TRUSTED_TYPES_POLICY_NAME?goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME+"#html"):null,goog.string={},goog.string.TypedString=function(){},goog.string.Const=function(e,t){this.stringConstValueWithSecurityContract__googStringSecurityPrivate_=e===goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_&&t||"",this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_=goog.string.Const.TYPE_MARKER_},goog.string.Const.prototype.implementsGoogStringTypedString=!0,goog.string.Const.prototype.getTypedStringValue=function(){return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_},goog.DEBUG&&(goog.string.Const.prototype.toString=function(){return"Const{"+this.stringConstValueWithSecurityContract__googStringSecurityPrivate_+"}"}),goog.string.Const.unwrap=function(e){return e instanceof goog.string.Const&&e.constructor===goog.string.Const&&e.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_===goog.string.Const.TYPE_MARKER_?e.stringConstValueWithSecurityContract__googStringSecurityPrivate_:(goog.asserts.fail("expected object of type Const, got '"+e+"'"),"type_error:Const")},goog.string.Const.from=function(e){return new goog.string.Const(goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_,e)},goog.string.Const.TYPE_MARKER_={},goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_={},goog.string.Const.EMPTY=goog.string.Const.from(""),goog.html.SafeScript=function(){this.privateDoNotAccessOrElseSafeScriptWrappedValue_="",this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_},goog.html.SafeScript.prototype.implementsGoogStringTypedString=!0,goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.SafeScript.fromConstant=function(e){return 0===(e=goog.string.Const.unwrap(e)).length?goog.html.SafeScript.EMPTY:goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeScript.fromConstantAndArgs=function(e,t){for(var r=[],o=1;o<arguments.length;o++)r.push(goog.html.SafeScript.stringify_(arguments[o]));return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse("("+goog.string.Const.unwrap(e)+")("+r.join(", ")+");")},goog.html.SafeScript.fromJson=function(e){return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(goog.html.SafeScript.stringify_(e))},goog.html.SafeScript.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseSafeScriptWrappedValue_.toString()},goog.DEBUG&&(goog.html.SafeScript.prototype.toString=function(){return"SafeScript{"+this.privateDoNotAccessOrElseSafeScriptWrappedValue_+"}"}),goog.html.SafeScript.unwrap=function(e){return goog.html.SafeScript.unwrapTrustedScript(e).toString()},goog.html.SafeScript.unwrapTrustedScript=function(e){return e instanceof goog.html.SafeScript&&e.constructor===goog.html.SafeScript&&e.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseSafeScriptWrappedValue_:(goog.asserts.fail("expected object of type SafeScript, got '"+e+"' of type "+goog.typeOf(e)),"type_error:SafeScript")},goog.html.SafeScript.stringify_=function(e){return JSON.stringify(e).replace(/</g,"\\x3c")},goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse=function(e){return(new goog.html.SafeScript).initSecurityPrivateDoNotAccessOrElse_(e)},goog.html.SafeScript.prototype.initSecurityPrivateDoNotAccessOrElse_=function(e){return this.privateDoNotAccessOrElseSafeScriptWrappedValue_=goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY?goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScript(e):e,this},goog.html.SafeScript.EMPTY=goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(""),goog.fs={},goog.fs.url={},goog.fs.url.createObjectUrl=function(e){return goog.fs.url.getUrlObject_().createObjectURL(e)},goog.fs.url.revokeObjectUrl=function(e){goog.fs.url.getUrlObject_().revokeObjectURL(e)},goog.fs.url.UrlObject_=function(){},goog.fs.url.UrlObject_.prototype.createObjectURL=function(e){},goog.fs.url.UrlObject_.prototype.revokeObjectURL=function(e){},goog.fs.url.getUrlObject_=function(){var e=goog.fs.url.findUrlObject_();if(null!=e)return e;throw Error("This browser doesn't seem to support blob URLs")},goog.fs.url.findUrlObject_=function(){return void 0!==goog.global.URL&&void 0!==goog.global.URL.createObjectURL?goog.global.URL:void 0!==goog.global.webkitURL&&void 0!==goog.global.webkitURL.createObjectURL?goog.global.webkitURL:void 0!==goog.global.createObjectURL?goog.global:null},goog.fs.url.browserSupportsObjectUrls=function(){return null!=goog.fs.url.findUrlObject_()},goog.fs.blob={},goog.fs.blob.getBlob=function(e){var t=goog.global.BlobBuilder||goog.global.WebKitBlobBuilder;if(void 0!==t){t=new t;for(var r=0;r<arguments.length;r++)t.append(arguments[r]);return t.getBlob()}return goog.fs.blob.getBlobWithProperties(goog.array.toArray(arguments))},goog.fs.blob.getBlobWithProperties=function(e,t,r){var o=goog.global.BlobBuilder||goog.global.WebKitBlobBuilder;if(void 0!==o){o=new o;for(var n=0;n<e.length;n++)o.append(e[n],r);return o.getBlob(t)}if(void 0!==goog.global.Blob)return o={},t&&(o.type=t),r&&(o.endings=r),new Blob(e,o);throw Error("This browser doesn't seem to support creating Blobs")},goog.i18n={},goog.i18n.bidi={},goog.i18n.bidi.FORCE_RTL=!1,goog.i18n.bidi.IS_RTL=goog.i18n.bidi.FORCE_RTL||("ar"==goog.LOCALE.substring(0,2).toLowerCase()||"fa"==goog.LOCALE.substring(0,2).toLowerCase()||"he"==goog.LOCALE.substring(0,2).toLowerCase()||"iw"==goog.LOCALE.substring(0,2).toLowerCase()||"ps"==goog.LOCALE.substring(0,2).toLowerCase()||"sd"==goog.LOCALE.substring(0,2).toLowerCase()||"ug"==goog.LOCALE.substring(0,2).toLowerCase()||"ur"==goog.LOCALE.substring(0,2).toLowerCase()||"yi"==goog.LOCALE.substring(0,2).toLowerCase())&&(2==goog.LOCALE.length||"-"==goog.LOCALE.substring(2,3)||"_"==goog.LOCALE.substring(2,3))||3<=goog.LOCALE.length&&"ckb"==goog.LOCALE.substring(0,3).toLowerCase()&&(3==goog.LOCALE.length||"-"==goog.LOCALE.substring(3,4)||"_"==goog.LOCALE.substring(3,4))||7<=goog.LOCALE.length&&("-"==goog.LOCALE.substring(2,3)||"_"==goog.LOCALE.substring(2,3))&&("adlm"==goog.LOCALE.substring(3,7).toLowerCase()||"arab"==goog.LOCALE.substring(3,7).toLowerCase()||"hebr"==goog.LOCALE.substring(3,7).toLowerCase()||"nkoo"==goog.LOCALE.substring(3,7).toLowerCase()||"rohg"==goog.LOCALE.substring(3,7).toLowerCase()||"thaa"==goog.LOCALE.substring(3,7).toLowerCase())||8<=goog.LOCALE.length&&("-"==goog.LOCALE.substring(3,4)||"_"==goog.LOCALE.substring(3,4))&&("adlm"==goog.LOCALE.substring(4,8).toLowerCase()||"arab"==goog.LOCALE.substring(4,8).toLowerCase()||"hebr"==goog.LOCALE.substring(4,8).toLowerCase()||"nkoo"==goog.LOCALE.substring(4,8).toLowerCase()||"rohg"==goog.LOCALE.substring(4,8).toLowerCase()||"thaa"==goog.LOCALE.substring(4,8).toLowerCase()),goog.i18n.bidi.Format={LRE:"‪",RLE:"‫",PDF:"‬",LRM:"‎",RLM:"‏"},goog.i18n.bidi.Dir={LTR:1,RTL:-1,NEUTRAL:0},goog.i18n.bidi.RIGHT="right",goog.i18n.bidi.LEFT="left",goog.i18n.bidi.I18N_RIGHT=goog.i18n.bidi.IS_RTL?goog.i18n.bidi.LEFT:goog.i18n.bidi.RIGHT,goog.i18n.bidi.I18N_LEFT=goog.i18n.bidi.IS_RTL?goog.i18n.bidi.RIGHT:goog.i18n.bidi.LEFT,goog.i18n.bidi.toDir=function(e,t){return"number"==typeof e?0<e?goog.i18n.bidi.Dir.LTR:0>e?goog.i18n.bidi.Dir.RTL:t?null:goog.i18n.bidi.Dir.NEUTRAL:null==e?null:e?goog.i18n.bidi.Dir.RTL:goog.i18n.bidi.Dir.LTR},goog.i18n.bidi.ltrChars_="A-Za-zÀ-ÖØ-öø-ʸ̀-֐ऀ-῿‎Ⰰ-\ud801\ud804-\ud839\ud83c-\udbff豈-﬜︀-﹯﻽-￿",goog.i18n.bidi.rtlChars_="֑-ۯۺ-ࣿ‏\ud802-\ud803\ud83a-\ud83bיִ-﷿ﹰ-ﻼ",goog.i18n.bidi.htmlSkipReg_=/<[^>]*>|&[^;]+;/g,goog.i18n.bidi.stripHtmlIfNeeded_=function(e,t){return t?e.replace(goog.i18n.bidi.htmlSkipReg_,""):e},goog.i18n.bidi.rtlCharReg_=new RegExp("["+goog.i18n.bidi.rtlChars_+"]"),goog.i18n.bidi.ltrCharReg_=new RegExp("["+goog.i18n.bidi.ltrChars_+"]"),goog.i18n.bidi.hasAnyRtl=function(e,t){return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.hasRtlChar=goog.i18n.bidi.hasAnyRtl,goog.i18n.bidi.hasAnyLtr=function(e,t){return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.ltrRe_=new RegExp("^["+goog.i18n.bidi.ltrChars_+"]"),goog.i18n.bidi.rtlRe_=new RegExp("^["+goog.i18n.bidi.rtlChars_+"]"),goog.i18n.bidi.isRtlChar=function(e){return goog.i18n.bidi.rtlRe_.test(e)},goog.i18n.bidi.isLtrChar=function(e){return goog.i18n.bidi.ltrRe_.test(e)},goog.i18n.bidi.isNeutralChar=function(e){return!goog.i18n.bidi.isLtrChar(e)&&!goog.i18n.bidi.isRtlChar(e)},goog.i18n.bidi.ltrDirCheckRe_=new RegExp("^[^"+goog.i18n.bidi.rtlChars_+"]*["+goog.i18n.bidi.ltrChars_+"]"),goog.i18n.bidi.rtlDirCheckRe_=new RegExp("^[^"+goog.i18n.bidi.ltrChars_+"]*["+goog.i18n.bidi.rtlChars_+"]"),goog.i18n.bidi.startsWithRtl=function(e,t){return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.isRtlText=goog.i18n.bidi.startsWithRtl,goog.i18n.bidi.startsWithLtr=function(e,t){return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.isLtrText=goog.i18n.bidi.startsWithLtr,goog.i18n.bidi.isRequiredLtrRe_=/^http:\/\/.*/,goog.i18n.bidi.isNeutralText=function(e,t){return e=goog.i18n.bidi.stripHtmlIfNeeded_(e,t),goog.i18n.bidi.isRequiredLtrRe_.test(e)||!goog.i18n.bidi.hasAnyLtr(e)&&!goog.i18n.bidi.hasAnyRtl(e)},goog.i18n.bidi.ltrExitDirCheckRe_=new RegExp("["+goog.i18n.bidi.ltrChars_+"][^"+goog.i18n.bidi.rtlChars_+"]*$"),goog.i18n.bidi.rtlExitDirCheckRe_=new RegExp("["+goog.i18n.bidi.rtlChars_+"][^"+goog.i18n.bidi.ltrChars_+"]*$"),goog.i18n.bidi.endsWithLtr=function(e,t){return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.isLtrExitText=goog.i18n.bidi.endsWithLtr,goog.i18n.bidi.endsWithRtl=function(e,t){return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e,t))},goog.i18n.bidi.isRtlExitText=goog.i18n.bidi.endsWithRtl,goog.i18n.bidi.rtlLocalesRe_=/^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Adlm|Arab|Hebr|Nkoo|Rohg|Thaa))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)/i,goog.i18n.bidi.isRtlLanguage=function(e){return goog.i18n.bidi.rtlLocalesRe_.test(e)},goog.i18n.bidi.bracketGuardTextRe_=/(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g,goog.i18n.bidi.guardBracketInText=function(e,t){return t=(void 0===t?goog.i18n.bidi.hasAnyRtl(e):t)?goog.i18n.bidi.Format.RLM:goog.i18n.bidi.Format.LRM,e.replace(goog.i18n.bidi.bracketGuardTextRe_,t+"$&"+t)},goog.i18n.bidi.enforceRtlInHtml=function(e){return"<"==e.charAt(0)?e.replace(/<\w+/,"$& dir=rtl"):"\n<span dir=rtl>"+e+"</span>"},goog.i18n.bidi.enforceRtlInText=function(e){return goog.i18n.bidi.Format.RLE+e+goog.i18n.bidi.Format.PDF},goog.i18n.bidi.enforceLtrInHtml=function(e){return"<"==e.charAt(0)?e.replace(/<\w+/,"$& dir=ltr"):"\n<span dir=ltr>"+e+"</span>"},goog.i18n.bidi.enforceLtrInText=function(e){return goog.i18n.bidi.Format.LRE+e+goog.i18n.bidi.Format.PDF},goog.i18n.bidi.dimensionsRe_=/:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g,goog.i18n.bidi.leftRe_=/left/gi,goog.i18n.bidi.rightRe_=/right/gi,goog.i18n.bidi.tempRe_=/%%%%/g,goog.i18n.bidi.mirrorCSS=function(e){return e.replace(goog.i18n.bidi.dimensionsRe_,":$1 $4 $3 $2").replace(goog.i18n.bidi.leftRe_,"%%%%").replace(goog.i18n.bidi.rightRe_,goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_,goog.i18n.bidi.RIGHT)},goog.i18n.bidi.doubleQuoteSubstituteRe_=/([\u0591-\u05f2])"/g,goog.i18n.bidi.singleQuoteSubstituteRe_=/([\u0591-\u05f2])'/g,goog.i18n.bidi.normalizeHebrewQuote=function(e){return e.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_,"$1״").replace(goog.i18n.bidi.singleQuoteSubstituteRe_,"$1׳")},goog.i18n.bidi.wordSeparatorRe_=/\s+/,goog.i18n.bidi.hasNumeralsRe_=/[\d\u06f0-\u06f9]/,goog.i18n.bidi.rtlDetectionThreshold_=.4,goog.i18n.bidi.estimateDirection=function(e,t){var r=0,o=0,n=!1;for(e=goog.i18n.bidi.stripHtmlIfNeeded_(e,t).split(goog.i18n.bidi.wordSeparatorRe_),t=0;t<e.length;t++){var i=e[t];goog.i18n.bidi.startsWithRtl(i)?(r++,o++):goog.i18n.bidi.isRequiredLtrRe_.test(i)?n=!0:goog.i18n.bidi.hasAnyLtr(i)?o++:goog.i18n.bidi.hasNumeralsRe_.test(i)&&(n=!0)}return 0==o?n?goog.i18n.bidi.Dir.LTR:goog.i18n.bidi.Dir.NEUTRAL:r/o>goog.i18n.bidi.rtlDetectionThreshold_?goog.i18n.bidi.Dir.RTL:goog.i18n.bidi.Dir.LTR},goog.i18n.bidi.detectRtlDirectionality=function(e,t){return goog.i18n.bidi.estimateDirection(e,t)==goog.i18n.bidi.Dir.RTL},goog.i18n.bidi.setElementDirAndAlign=function(e,t){e&&(t=goog.i18n.bidi.toDir(t))&&(e.style.textAlign=t==goog.i18n.bidi.Dir.RTL?goog.i18n.bidi.RIGHT:goog.i18n.bidi.LEFT,e.dir=t==goog.i18n.bidi.Dir.RTL?"rtl":"ltr")},goog.i18n.bidi.setElementDirByTextDirectionality=function(e,t){switch(goog.i18n.bidi.estimateDirection(t)){case goog.i18n.bidi.Dir.LTR:e.dir="ltr";break;case goog.i18n.bidi.Dir.RTL:e.dir="rtl";break;default:e.removeAttribute("dir")}},goog.i18n.bidi.DirectionalString=function(){},goog.html.TrustedResourceUrl=function(e,t){this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_=e===goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_&&t||"",this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_},goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString=!0,goog.html.TrustedResourceUrl.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_.toString()},goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString=!0,goog.html.TrustedResourceUrl.prototype.getDirection=function(){return goog.i18n.bidi.Dir.LTR},goog.html.TrustedResourceUrl.prototype.cloneWithParams=function(e,t){var r=goog.html.TrustedResourceUrl.unwrap(this),o=(r=goog.html.TrustedResourceUrl.URL_PARAM_PARSER_.exec(r))[3]||"";return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(r[1]+goog.html.TrustedResourceUrl.stringifyParams_("?",r[2]||"",e)+goog.html.TrustedResourceUrl.stringifyParams_("#",o,t))},goog.DEBUG&&(goog.html.TrustedResourceUrl.prototype.toString=function(){return"TrustedResourceUrl{"+this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_+"}"}),goog.html.TrustedResourceUrl.unwrap=function(e){return goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(e).toString()},goog.html.TrustedResourceUrl.unwrapTrustedScriptURL=function(e){return e instanceof goog.html.TrustedResourceUrl&&e.constructor===goog.html.TrustedResourceUrl&&e.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_:(goog.asserts.fail("expected object of type TrustedResourceUrl, got '"+e+"' of type "+goog.typeOf(e)),"type_error:TrustedResourceUrl")},goog.html.TrustedResourceUrl.format=function(e,t){var r=goog.string.Const.unwrap(e);if(!goog.html.TrustedResourceUrl.BASE_URL_.test(r))throw Error("Invalid TrustedResourceUrl format: "+r);return e=r.replace(goog.html.TrustedResourceUrl.FORMAT_MARKER_,function(e,o){if(!Object.prototype.hasOwnProperty.call(t,o))throw Error('Found marker, "'+o+'", in format string, "'+r+'", but no valid label mapping found in args: '+JSON.stringify(t));return(e=t[o])instanceof goog.string.Const?goog.string.Const.unwrap(e):encodeURIComponent(String(e))}),goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.TrustedResourceUrl.FORMAT_MARKER_=/%{(\w+)}/g,goog.html.TrustedResourceUrl.BASE_URL_=/^((https:)?\/\/[0-9a-z.:[\]-]+\/|\/[^/\\]|[^:/\\%]+\/|[^:/\\%]*[?#]|about:blank#)/i,goog.html.TrustedResourceUrl.URL_PARAM_PARSER_=/^([^?#]*)(\?[^#]*)?(#[\s\S]*)?/,goog.html.TrustedResourceUrl.formatWithParams=function(e,t,r,o){return goog.html.TrustedResourceUrl.format(e,t).cloneWithParams(r,o)},goog.html.TrustedResourceUrl.fromConstant=function(e){return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(e))},goog.html.TrustedResourceUrl.fromConstants=function(e){for(var t="",r=0;r<e.length;r++)t+=goog.string.Const.unwrap(e[r]);return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(t)},goog.html.TrustedResourceUrl.fromSafeScript=function(e){return e=goog.fs.blob.getBlobWithProperties([goog.html.SafeScript.unwrap(e)],"text/javascript"),e=goog.fs.url.createObjectUrl(e),goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse=function(e){return e=goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY?goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScriptURL(e):e,new goog.html.TrustedResourceUrl(goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_,e)},goog.html.TrustedResourceUrl.stringifyParams_=function(e,t,r){if(null==r)return t;if("string"==typeof r)return r?e+encodeURIComponent(r):"";for(var o in r){var n=r[o];n=Array.isArray(n)?n:[n];for(var i=0;i<n.length;i++){var a=n[i];null!=a&&(t||(t=e),t+=(t.length>e.length?"&":"")+encodeURIComponent(o)+"="+encodeURIComponent(String(a)))}}return t},goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_={},goog.string.internal={},goog.string.internal.startsWith=function(e,t){return 0==e.lastIndexOf(t,0)},goog.string.internal.endsWith=function(e,t){var r=e.length-t.length;return 0<=r&&e.indexOf(t,r)==r},goog.string.internal.caseInsensitiveStartsWith=function(e,t){return 0==goog.string.internal.caseInsensitiveCompare(t,e.substr(0,t.length))},goog.string.internal.caseInsensitiveEndsWith=function(e,t){return 0==goog.string.internal.caseInsensitiveCompare(t,e.substr(e.length-t.length,t.length))},goog.string.internal.caseInsensitiveEquals=function(e,t){return e.toLowerCase()==t.toLowerCase()},goog.string.internal.isEmptyOrWhitespace=function(e){return/^[\s\xa0]*$/.test(e)},goog.string.internal.trim=goog.TRUSTED_SITE&&String.prototype.trim?function(e){return e.trim()}:function(e){return/^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(e)[1]},goog.string.internal.caseInsensitiveCompare=function(e,t){return(e=String(e).toLowerCase())<(t=String(t).toLowerCase())?-1:e==t?0:1},goog.string.internal.newLineToBr=function(e,t){return e.replace(/(\r\n|\r|\n)/g,t?"<br />":"<br>")},goog.string.internal.htmlEscape=function(e,t){if(t)e=e.replace(goog.string.internal.AMP_RE_,"&amp;").replace(goog.string.internal.LT_RE_,"&lt;").replace(goog.string.internal.GT_RE_,"&gt;").replace(goog.string.internal.QUOT_RE_,"&quot;").replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;").replace(goog.string.internal.NULL_RE_,"&#0;");else{if(!goog.string.internal.ALL_RE_.test(e))return e;-1!=e.indexOf("&")&&(e=e.replace(goog.string.internal.AMP_RE_,"&amp;")),-1!=e.indexOf("<")&&(e=e.replace(goog.string.internal.LT_RE_,"&lt;")),-1!=e.indexOf(">")&&(e=e.replace(goog.string.internal.GT_RE_,"&gt;")),-1!=e.indexOf('"')&&(e=e.replace(goog.string.internal.QUOT_RE_,"&quot;")),-1!=e.indexOf("'")&&(e=e.replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;")),-1!=e.indexOf("\0")&&(e=e.replace(goog.string.internal.NULL_RE_,"&#0;"))}return e},goog.string.internal.AMP_RE_=/&/g,goog.string.internal.LT_RE_=/</g,goog.string.internal.GT_RE_=/>/g,goog.string.internal.QUOT_RE_=/"/g,goog.string.internal.SINGLE_QUOTE_RE_=/'/g,goog.string.internal.NULL_RE_=/\x00/g,goog.string.internal.ALL_RE_=/[\x00&<>"']/,goog.string.internal.whitespaceEscape=function(e,t){return goog.string.internal.newLineToBr(e.replace(/  /g," &#160;"),t)},goog.string.internal.contains=function(e,t){return-1!=e.indexOf(t)},goog.string.internal.caseInsensitiveContains=function(e,t){return goog.string.internal.contains(e.toLowerCase(),t.toLowerCase())},goog.string.internal.compareVersions=function(e,t){var r=0;e=goog.string.internal.trim(String(e)).split("."),t=goog.string.internal.trim(String(t)).split(".");for(var o=Math.max(e.length,t.length),n=0;0==r&&n<o;n++){var i=e[n]||"",a=t[n]||"";do{if(i=/(\d*)(\D*)(.*)/.exec(i)||["","","",""],a=/(\d*)(\D*)(.*)/.exec(a)||["","","",""],0==i[0].length&&0==a[0].length)break;r=0==i[1].length?0:parseInt(i[1],10);var s=0==a[1].length?0:parseInt(a[1],10);r=goog.string.internal.compareElements_(r,s)||goog.string.internal.compareElements_(0==i[2].length,0==a[2].length)||goog.string.internal.compareElements_(i[2],a[2]),i=i[3],a=a[3]}while(0==r)}return r},goog.string.internal.compareElements_=function(e,t){return e<t?-1:e>t?1:0},goog.html.SafeUrl=function(e,t){this.privateDoNotAccessOrElseSafeUrlWrappedValue_=e===goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_&&t||"",this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_},goog.html.SafeUrl.INNOCUOUS_STRING="about:invalid#zClosurez",goog.html.SafeUrl.prototype.implementsGoogStringTypedString=!0,goog.html.SafeUrl.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseSafeUrlWrappedValue_.toString()},goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString=!0,goog.html.SafeUrl.prototype.getDirection=function(){return goog.i18n.bidi.Dir.LTR},goog.DEBUG&&(goog.html.SafeUrl.prototype.toString=function(){return"SafeUrl{"+this.privateDoNotAccessOrElseSafeUrlWrappedValue_+"}"}),goog.html.SafeUrl.unwrap=function(e){return e instanceof goog.html.SafeUrl&&e.constructor===goog.html.SafeUrl&&e.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseSafeUrlWrappedValue_:(goog.asserts.fail("expected object of type SafeUrl, got '"+e+"' of type "+goog.typeOf(e)),"type_error:SafeUrl")},goog.html.SafeUrl.fromConstant=function(e){return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(e))},goog.html.SAFE_MIME_TYPE_PATTERN_=/^(?:audio\/(?:3gpp2|3gpp|aac|L16|midi|mp3|mp4|mpeg|oga|ogg|opus|x-m4a|x-matroska|x-wav|wav|webm)|image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp|x-icon)|text\/csv|video\/(?:mpeg|mp4|ogg|webm|quicktime|x-matroska))(?:;\w+=(?:\w+|"[\w;,= ]+"))*$/i,goog.html.SafeUrl.isSafeMimeType=function(e){return goog.html.SAFE_MIME_TYPE_PATTERN_.test(e)},goog.html.SafeUrl.fromBlob=function(e){return e=goog.html.SafeUrl.isSafeMimeType(e.type)?goog.fs.url.createObjectUrl(e):goog.html.SafeUrl.INNOCUOUS_STRING,goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.fromMediaSource=function(e){return goog.asserts.assert("MediaSource"in goog.global,"No support for MediaSource"),e=e instanceof MediaSource?goog.fs.url.createObjectUrl(e):goog.html.SafeUrl.INNOCUOUS_STRING,goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.DATA_URL_PATTERN_=/^data:(.*);base64,[a-z0-9+\/]+=*$/i,goog.html.SafeUrl.fromDataUrl=function(e){var t=(e=e.replace(/(%0A|%0D)/g,"")).match(goog.html.DATA_URL_PATTERN_);return t=t&&goog.html.SafeUrl.isSafeMimeType(t[1]),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t?e:goog.html.SafeUrl.INNOCUOUS_STRING)},goog.html.SafeUrl.fromTelUrl=function(e){return goog.string.internal.caseInsensitiveStartsWith(e,"tel:")||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SIP_URL_PATTERN_=/^sip[s]?:[+a-z0-9_.!$%&'*\/=^`{|}~-]+@([a-z0-9-]+\.)+[a-z0-9]{2,63}$/i,goog.html.SafeUrl.fromSipUrl=function(e){return goog.html.SIP_URL_PATTERN_.test(decodeURIComponent(e))||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.fromFacebookMessengerUrl=function(e){return goog.string.internal.caseInsensitiveStartsWith(e,"fb-messenger://share")||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.fromWhatsAppUrl=function(e){return goog.string.internal.caseInsensitiveStartsWith(e,"whatsapp://send")||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.fromSmsUrl=function(e){return goog.string.internal.caseInsensitiveStartsWith(e,"sms:")&&goog.html.SafeUrl.isSmsUrlBodyValid_(e)||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.isSmsUrlBodyValid_=function(e){var t=e.indexOf("#");if(0<t&&(e=e.substring(0,t)),!(t=e.match(/[?&]body=/gi)))return!0;if(1<t.length)return!1;if(!(e=e.match(/[?&]body=([^&]*)/)[1]))return!0;try{decodeURIComponent(e)}catch(e){return!1}return/^(?:[a-z0-9\-_.~]|%[0-9a-f]{2})+$/i.test(e)},goog.html.SafeUrl.fromSshUrl=function(e){return goog.string.internal.caseInsensitiveStartsWith(e,"ssh://")||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeUrl.sanitizeChromeExtensionUrl=function(e,t){return goog.html.SafeUrl.sanitizeExtensionUrl_(/^chrome-extension:\/\/([^\/]+)\//,e,t)},goog.html.SafeUrl.sanitizeFirefoxExtensionUrl=function(e,t){return goog.html.SafeUrl.sanitizeExtensionUrl_(/^moz-extension:\/\/([^\/]+)\//,e,t)},goog.html.SafeUrl.sanitizeEdgeExtensionUrl=function(e,t){return goog.html.SafeUrl.sanitizeExtensionUrl_(/^ms-browser-extension:\/\/([^\/]+)\//,e,t)},goog.html.SafeUrl.sanitizeExtensionUrl_=function(e,t,r){return(e=e.exec(t))?(e=e[1],-1==(r instanceof goog.string.Const?[goog.string.Const.unwrap(r)]:r.map(function(e){return goog.string.Const.unwrap(e)})).indexOf(e)&&(t=goog.html.SafeUrl.INNOCUOUS_STRING)):t=goog.html.SafeUrl.INNOCUOUS_STRING,goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t)},goog.html.SafeUrl.fromTrustedResourceUrl=function(e){return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.html.TrustedResourceUrl.unwrap(e))},goog.html.SAFE_URL_PATTERN_=/^(?:(?:https?|mailto|ftp):|[^:/?#]*(?:[/?#]|$))/i,goog.html.SafeUrl.SAFE_URL_PATTERN=goog.html.SAFE_URL_PATTERN_,goog.html.SafeUrl.sanitize=function(e){return e instanceof goog.html.SafeUrl?e:(e="object"==typeof e&&e.implementsGoogStringTypedString?e.getTypedStringValue():String(e),goog.html.SAFE_URL_PATTERN_.test(e)||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e))},goog.html.SafeUrl.sanitizeAssertUnchanged=function(e,t){return e instanceof goog.html.SafeUrl?e:(e="object"==typeof e&&e.implementsGoogStringTypedString?e.getTypedStringValue():String(e),t&&/^data:/i.test(e)&&(t=goog.html.SafeUrl.fromDataUrl(e)).getTypedStringValue()==e?t:(goog.asserts.assert(goog.html.SAFE_URL_PATTERN_.test(e),"%s does not match the safe URL pattern",e)||(e=goog.html.SafeUrl.INNOCUOUS_STRING),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)))},goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse=function(e){return new goog.html.SafeUrl(goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_,e)},goog.html.SafeUrl.ABOUT_BLANK=goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse("about:blank"),goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_={},goog.html.SafeStyle=function(){this.privateDoNotAccessOrElseSafeStyleWrappedValue_="",this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_},goog.html.SafeStyle.prototype.implementsGoogStringTypedString=!0,goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.SafeStyle.fromConstant=function(e){return 0===(e=goog.string.Const.unwrap(e)).length?goog.html.SafeStyle.EMPTY:(goog.asserts.assert(goog.string.internal.endsWith(e,";"),"Last character of style string is not ';': "+e),goog.asserts.assert(goog.string.internal.contains(e,":"),"Style string must contain at least one ':', to specify a \"name: value\" pair: "+e),goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(e))},goog.html.SafeStyle.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseSafeStyleWrappedValue_},goog.DEBUG&&(goog.html.SafeStyle.prototype.toString=function(){return"SafeStyle{"+this.privateDoNotAccessOrElseSafeStyleWrappedValue_+"}"}),goog.html.SafeStyle.unwrap=function(e){return e instanceof goog.html.SafeStyle&&e.constructor===goog.html.SafeStyle&&e.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseSafeStyleWrappedValue_:(goog.asserts.fail("expected object of type SafeStyle, got '"+e+"' of type "+goog.typeOf(e)),"type_error:SafeStyle")},goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse=function(e){return(new goog.html.SafeStyle).initSecurityPrivateDoNotAccessOrElse_(e)},goog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_=function(e){return this.privateDoNotAccessOrElseSafeStyleWrappedValue_=e,this},goog.html.SafeStyle.EMPTY=goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(""),goog.html.SafeStyle.INNOCUOUS_STRING="zClosurez",goog.html.SafeStyle.create=function(e){var t,r="";for(t in e){if(!/^[-_a-zA-Z0-9]+$/.test(t))throw Error("Name allows only [-_a-zA-Z0-9], got: "+t);var o=e[t];null!=o&&(r+=t+":"+(o=Array.isArray(o)?goog.array.map(o,goog.html.SafeStyle.sanitizePropertyValue_).join(" "):goog.html.SafeStyle.sanitizePropertyValue_(o))+";")}return r?goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(r):goog.html.SafeStyle.EMPTY},goog.html.SafeStyle.sanitizePropertyValue_=function(e){if(e instanceof goog.html.SafeUrl)return'url("'+goog.html.SafeUrl.unwrap(e).replace(/</g,"%3c").replace(/[\\"]/g,"\\$&")+'")';if(e=e instanceof goog.string.Const?goog.string.Const.unwrap(e):goog.html.SafeStyle.sanitizePropertyValueString_(String(e)),/[{;}]/.test(e))throw new goog.asserts.AssertionError("Value does not allow [{;}], got: %s.",[e]);return e},goog.html.SafeStyle.sanitizePropertyValueString_=function(e){var t=e.replace(goog.html.SafeStyle.FUNCTIONS_RE_,"$1").replace(goog.html.SafeStyle.FUNCTIONS_RE_,"$1").replace(goog.html.SafeStyle.URL_RE_,"url");return goog.html.SafeStyle.VALUE_RE_.test(t)?goog.html.SafeStyle.COMMENT_RE_.test(e)?(goog.asserts.fail("String value disallows comments, got: "+e),goog.html.SafeStyle.INNOCUOUS_STRING):goog.html.SafeStyle.hasBalancedQuotes_(e)?goog.html.SafeStyle.hasBalancedSquareBrackets_(e)?goog.html.SafeStyle.sanitizeUrl_(e):(goog.asserts.fail("String value requires balanced square brackets and one identifier per pair of brackets, got: "+e),goog.html.SafeStyle.INNOCUOUS_STRING):(goog.asserts.fail("String value requires balanced quotes, got: "+e),goog.html.SafeStyle.INNOCUOUS_STRING):(goog.asserts.fail("String value allows only "+goog.html.SafeStyle.VALUE_ALLOWED_CHARS_+" and simple functions, got: "+e),goog.html.SafeStyle.INNOCUOUS_STRING)},goog.html.SafeStyle.hasBalancedQuotes_=function(e){for(var t=!0,r=!0,o=0;o<e.length;o++){var n=e.charAt(o);"'"==n&&r?t=!t:'"'==n&&t&&(r=!r)}return t&&r},goog.html.SafeStyle.hasBalancedSquareBrackets_=function(e){for(var t=!0,r=/^[-_a-zA-Z0-9]$/,o=0;o<e.length;o++){var n=e.charAt(o);if("]"==n){if(t)return!1;t=!0}else if("["==n){if(!t)return!1;t=!1}else if(!t&&!r.test(n))return!1}return t},goog.html.SafeStyle.VALUE_ALLOWED_CHARS_="[-,.\"'%_!# a-zA-Z0-9\\[\\]]",goog.html.SafeStyle.VALUE_RE_=new RegExp("^"+goog.html.SafeStyle.VALUE_ALLOWED_CHARS_+"+$"),goog.html.SafeStyle.URL_RE_=/\b(url\([ \t\n]*)('[ -&(-\[\]-~]*'|"[ !#-\[\]-~]*"|[!#-&*-\[\]-~]*)([ \t\n]*\))/g,goog.html.SafeStyle.ALLOWED_FUNCTIONS_="calc cubic-bezier fit-content hsl hsla linear-gradient matrix minmax repeat rgb rgba (rotate|scale|translate)(X|Y|Z|3d)?".split(" "),goog.html.SafeStyle.FUNCTIONS_RE_=new RegExp("\\b("+goog.html.SafeStyle.ALLOWED_FUNCTIONS_.join("|")+")\\([-+*/0-9a-z.%\\[\\], ]+\\)","g"),goog.html.SafeStyle.COMMENT_RE_=/\/\*/,goog.html.SafeStyle.sanitizeUrl_=function(e){return e.replace(goog.html.SafeStyle.URL_RE_,function(e,t,r,o){var n="";return r=r.replace(/^(['"])(.*)\1$/,function(e,t,r){return n=t,r}),e=goog.html.SafeUrl.sanitize(r).getTypedStringValue(),t+n+e+n+o})},goog.html.SafeStyle.concat=function(e){var t="",r=function(e){Array.isArray(e)?goog.array.forEach(e,r):t+=goog.html.SafeStyle.unwrap(e)};return goog.array.forEach(arguments,r),t?goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(t):goog.html.SafeStyle.EMPTY},goog.html.SafeStyleSheet=function(){this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_="",this.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_},goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString=!0,goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.SafeStyleSheet.createRule=function(e,t){if(goog.string.internal.contains(e,"<"))throw Error("Selector does not allow '<', got: "+e);var r=e.replace(/('|")((?!\1)[^\r\n\f\\]|\\[\s\S])*\1/g,"");if(!/^[-_a-zA-Z0-9#.:* ,>+~[\]()=^$|]+$/.test(r))throw Error("Selector allows only [-_a-zA-Z0-9#.:* ,>+~[\\]()=^$|] and strings, got: "+e);if(!goog.html.SafeStyleSheet.hasBalancedBrackets_(r))throw Error("() and [] in selector must be balanced, got: "+e);return t instanceof goog.html.SafeStyle||(t=goog.html.SafeStyle.create(t)),e=e+"{"+goog.html.SafeStyle.unwrap(t).replace(/</g,"\\3C ")+"}",goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(e)},goog.html.SafeStyleSheet.hasBalancedBrackets_=function(e){for(var t={"(":")","[":"]"},r=[],o=0;o<e.length;o++){var n=e[o];if(t[n])r.push(t[n]);else if(goog.object.contains(t,n)&&r.pop()!=n)return!1}return 0==r.length},goog.html.SafeStyleSheet.concat=function(e){var t="",r=function(e){Array.isArray(e)?goog.array.forEach(e,r):t+=goog.html.SafeStyleSheet.unwrap(e)};return goog.array.forEach(arguments,r),goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(t)},goog.html.SafeStyleSheet.fromConstant=function(e){return 0===(e=goog.string.Const.unwrap(e)).length?goog.html.SafeStyleSheet.EMPTY:(goog.asserts.assert(!goog.string.internal.contains(e,"<"),"Forbidden '<' character in style sheet string: "+e),goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(e))},goog.html.SafeStyleSheet.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_},goog.DEBUG&&(goog.html.SafeStyleSheet.prototype.toString=function(){return"SafeStyleSheet{"+this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_+"}"}),goog.html.SafeStyleSheet.unwrap=function(e){return e instanceof goog.html.SafeStyleSheet&&e.constructor===goog.html.SafeStyleSheet&&e.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_:(goog.asserts.fail("expected object of type SafeStyleSheet, got '"+e+"' of type "+goog.typeOf(e)),"type_error:SafeStyleSheet")},goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse=function(e){return(new goog.html.SafeStyleSheet).initSecurityPrivateDoNotAccessOrElse_(e)},goog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_=function(e){return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_=e,this},goog.html.SafeStyleSheet.EMPTY=goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(""),goog.labs={},goog.labs.userAgent={},goog.labs.userAgent.util={},goog.labs.userAgent.util.getNativeUserAgentString_=function(){var e=goog.labs.userAgent.util.getNavigator_();return e&&(e=e.userAgent)?e:""},goog.labs.userAgent.util.getNavigator_=function(){return goog.global.navigator},goog.labs.userAgent.util.userAgent_=goog.labs.userAgent.util.getNativeUserAgentString_(),goog.labs.userAgent.util.setUserAgent=function(e){goog.labs.userAgent.util.userAgent_=e||goog.labs.userAgent.util.getNativeUserAgentString_()},goog.labs.userAgent.util.getUserAgent=function(){return goog.labs.userAgent.util.userAgent_},goog.labs.userAgent.util.matchUserAgent=function(e){var t=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.contains(t,e)},goog.labs.userAgent.util.matchUserAgentIgnoreCase=function(e){var t=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.caseInsensitiveContains(t,e)},goog.labs.userAgent.util.extractVersionTuples=function(e){for(var t,r=/(\w[\w ]+)\/([^\s]+)\s*(?:\((.*?)\))?/g,o=[];t=r.exec(e);)o.push([t[1],t[2],t[3]||void 0]);return o},goog.labs.userAgent.browser={},goog.labs.userAgent.browser.matchOpera_=function(){return goog.labs.userAgent.util.matchUserAgent("Opera")},goog.labs.userAgent.browser.matchIE_=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")},goog.labs.userAgent.browser.matchEdgeHtml_=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")},goog.labs.userAgent.browser.matchEdgeChromium_=function(){return goog.labs.userAgent.util.matchUserAgent("Edg/")},goog.labs.userAgent.browser.matchOperaChromium_=function(){return goog.labs.userAgent.util.matchUserAgent("OPR")},goog.labs.userAgent.browser.matchFirefox_=function(){return goog.labs.userAgent.util.matchUserAgent("Firefox")||goog.labs.userAgent.util.matchUserAgent("FxiOS")},goog.labs.userAgent.browser.matchSafari_=function(){return goog.labs.userAgent.util.matchUserAgent("Safari")&&!(goog.labs.userAgent.browser.matchChrome_()||goog.labs.userAgent.browser.matchCoast_()||goog.labs.userAgent.browser.matchOpera_()||goog.labs.userAgent.browser.matchEdgeHtml_()||goog.labs.userAgent.browser.matchEdgeChromium_()||goog.labs.userAgent.browser.matchOperaChromium_()||goog.labs.userAgent.browser.matchFirefox_()||goog.labs.userAgent.browser.isSilk()||goog.labs.userAgent.util.matchUserAgent("Android"))},goog.labs.userAgent.browser.matchCoast_=function(){return goog.labs.userAgent.util.matchUserAgent("Coast")},goog.labs.userAgent.browser.matchIosWebview_=function(){return(goog.labs.userAgent.util.matchUserAgent("iPad")||goog.labs.userAgent.util.matchUserAgent("iPhone"))&&!goog.labs.userAgent.browser.matchSafari_()&&!goog.labs.userAgent.browser.matchChrome_()&&!goog.labs.userAgent.browser.matchCoast_()&&!goog.labs.userAgent.browser.matchFirefox_()&&goog.labs.userAgent.util.matchUserAgent("AppleWebKit")},goog.labs.userAgent.browser.matchChrome_=function(){return(goog.labs.userAgent.util.matchUserAgent("Chrome")||goog.labs.userAgent.util.matchUserAgent("CriOS"))&&!goog.labs.userAgent.browser.matchEdgeHtml_()},goog.labs.userAgent.browser.matchAndroidBrowser_=function(){return goog.labs.userAgent.util.matchUserAgent("Android")&&!(goog.labs.userAgent.browser.isChrome()||goog.labs.userAgent.browser.isFirefox()||goog.labs.userAgent.browser.isOpera()||goog.labs.userAgent.browser.isSilk())},goog.labs.userAgent.browser.isOpera=goog.labs.userAgent.browser.matchOpera_,goog.labs.userAgent.browser.isIE=goog.labs.userAgent.browser.matchIE_,goog.labs.userAgent.browser.isEdge=goog.labs.userAgent.browser.matchEdgeHtml_,goog.labs.userAgent.browser.isEdgeChromium=goog.labs.userAgent.browser.matchEdgeChromium_,goog.labs.userAgent.browser.isOperaChromium=goog.labs.userAgent.browser.matchOperaChromium_,goog.labs.userAgent.browser.isFirefox=goog.labs.userAgent.browser.matchFirefox_,goog.labs.userAgent.browser.isSafari=goog.labs.userAgent.browser.matchSafari_,goog.labs.userAgent.browser.isCoast=goog.labs.userAgent.browser.matchCoast_,goog.labs.userAgent.browser.isIosWebview=goog.labs.userAgent.browser.matchIosWebview_,goog.labs.userAgent.browser.isChrome=goog.labs.userAgent.browser.matchChrome_,goog.labs.userAgent.browser.isAndroidBrowser=goog.labs.userAgent.browser.matchAndroidBrowser_,goog.labs.userAgent.browser.isSilk=function(){return goog.labs.userAgent.util.matchUserAgent("Silk")},goog.labs.userAgent.browser.getVersion=function(){function e(e){return e=goog.array.find(e,o),r[e]||""}var t=goog.labs.userAgent.util.getUserAgent();if(goog.labs.userAgent.browser.isIE())return goog.labs.userAgent.browser.getIEVersion_(t);t=goog.labs.userAgent.util.extractVersionTuples(t);var r={};goog.array.forEach(t,function(e){r[e[0]]=e[1]});var o=goog.partial(goog.object.containsKey,r);return goog.labs.userAgent.browser.isOpera()?e(["Version","Opera"]):goog.labs.userAgent.browser.isEdge()?e(["Edge"]):goog.labs.userAgent.browser.isEdgeChromium()?e(["Edg"]):goog.labs.userAgent.browser.isChrome()?e(["Chrome","CriOS","HeadlessChrome"]):(t=t[2])&&t[1]||""},goog.labs.userAgent.browser.isVersionOrHigher=function(e){return 0<=goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(),e)},goog.labs.userAgent.browser.getIEVersion_=function(e){var t=/rv: *([\d\.]*)/.exec(e);if(t&&t[1])return t[1];t="";var r=/MSIE +([\d\.]+)/.exec(e);if(r&&r[1])if(e=/Trident\/(\d.\d)/.exec(e),"7.0"==r[1])if(e&&e[1])switch(e[1]){case"4.0":t="8.0";break;case"5.0":t="9.0";break;case"6.0":t="10.0";break;case"7.0":t="11.0"}else t="7.0";else t=r[1];return t},goog.html.SafeHtml=function(){this.privateDoNotAccessOrElseSafeHtmlWrappedValue_="",this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_=goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_,this.dir_=null},goog.html.SafeHtml.ENABLE_ERROR_MESSAGES=goog.DEBUG,goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE=!0,goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString=!0,goog.html.SafeHtml.prototype.getDirection=function(){return this.dir_},goog.html.SafeHtml.prototype.implementsGoogStringTypedString=!0,goog.html.SafeHtml.prototype.getTypedStringValue=function(){return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_.toString()},goog.DEBUG&&(goog.html.SafeHtml.prototype.toString=function(){return"SafeHtml{"+this.privateDoNotAccessOrElseSafeHtmlWrappedValue_+"}"}),goog.html.SafeHtml.unwrap=function(e){return goog.html.SafeHtml.unwrapTrustedHTML(e).toString()},goog.html.SafeHtml.unwrapTrustedHTML=function(e){return e instanceof goog.html.SafeHtml&&e.constructor===goog.html.SafeHtml&&e.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_===goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_?e.privateDoNotAccessOrElseSafeHtmlWrappedValue_:(goog.asserts.fail("expected object of type SafeHtml, got '"+e+"' of type "+goog.typeOf(e)),"type_error:SafeHtml")},goog.html.SafeHtml.htmlEscape=function(e){if(e instanceof goog.html.SafeHtml)return e;var t="object"==typeof e,r=null;return t&&e.implementsGoogI18nBidiDirectionalString&&(r=e.getDirection()),e=t&&e.implementsGoogStringTypedString?e.getTypedStringValue():String(e),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.htmlEscape(e),r)},goog.html.SafeHtml.htmlEscapePreservingNewlines=function(e){return e instanceof goog.html.SafeHtml?e:(e=goog.html.SafeHtml.htmlEscape(e),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.newLineToBr(goog.html.SafeHtml.unwrap(e)),e.getDirection()))},goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces=function(e){return e instanceof goog.html.SafeHtml?e:(e=goog.html.SafeHtml.htmlEscape(e),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.whitespaceEscape(goog.html.SafeHtml.unwrap(e)),e.getDirection()))},goog.html.SafeHtml.from=goog.html.SafeHtml.htmlEscape,goog.html.SafeHtml.comment=function(e){return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("\x3c!--"+goog.string.internal.htmlEscape(e)+"--\x3e",null)},goog.html.SafeHtml.VALID_NAMES_IN_TAG_=/^[a-zA-Z0-9-]+$/,goog.html.SafeHtml.URL_ATTRIBUTES_={action:!0,cite:!0,data:!0,formaction:!0,href:!0,manifest:!0,poster:!0,src:!0},goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_={APPLET:!0,BASE:!0,EMBED:!0,IFRAME:!0,LINK:!0,MATH:!0,META:!0,OBJECT:!0,SCRIPT:!0,STYLE:!0,SVG:!0,TEMPLATE:!0},goog.html.SafeHtml.create=function(e,t,r){return goog.html.SafeHtml.verifyTagName(String(e)),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(String(e),t,r)},goog.html.SafeHtml.verifyTagName=function(e){if(!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(e))throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?"Invalid tag name <"+e+">.":"");if(e.toUpperCase()in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_)throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?"Tag name <"+e+"> is not allowed for SafeHtml.":"")},goog.html.SafeHtml.createIframe=function(e,t,r,o){e&&goog.html.TrustedResourceUrl.unwrap(e);var n={};return n.src=e||null,n.srcdoc=t&&goog.html.SafeHtml.unwrap(t),e=goog.html.SafeHtml.combineAttributes(n,{sandbox:""},r),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe",e,o)},goog.html.SafeHtml.createSandboxIframe=function(e,t,r,o){if(!goog.html.SafeHtml.canUseSandboxIframe())throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?"The browser does not support sandboxed iframes.":"");var n={};return n.src=e?goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(e)):null,n.srcdoc=t||null,n.sandbox="",e=goog.html.SafeHtml.combineAttributes(n,{},r),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe",e,o)},goog.html.SafeHtml.canUseSandboxIframe=function(){return goog.global.HTMLIFrameElement&&"sandbox"in goog.global.HTMLIFrameElement.prototype},goog.html.SafeHtml.createScriptSrc=function(e,t){return goog.html.TrustedResourceUrl.unwrap(e),e=goog.html.SafeHtml.combineAttributes({src:e},{},t),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script",e)},goog.html.SafeHtml.createScript=function(e,t){for(var r in t){var o=r.toLowerCase();if("language"==o||"src"==o||"text"==o||"type"==o)throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Cannot set "'+o+'" attribute':"")}for(r="",e=goog.array.concat(e),o=0;o<e.length;o++)r+=goog.html.SafeScript.unwrap(e[o]);return e=goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(r,goog.i18n.bidi.Dir.NEUTRAL),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script",t,e)},goog.html.SafeHtml.createStyle=function(e,t){t=goog.html.SafeHtml.combineAttributes({type:"text/css"},{},t);var r="";e=goog.array.concat(e);for(var o=0;o<e.length;o++)r+=goog.html.SafeStyleSheet.unwrap(e[o]);return e=goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(r,goog.i18n.bidi.Dir.NEUTRAL),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("style",t,e)},goog.html.SafeHtml.createMetaRefresh=function(e,t){return e=goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(e)),(goog.labs.userAgent.browser.isIE()||goog.labs.userAgent.browser.isEdge())&&goog.string.internal.contains(e,";")&&(e="'"+e.replace(/'/g,"%27")+"'"),goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("meta",{"http-equiv":"refresh",content:(t||0)+"; url="+e})},goog.html.SafeHtml.getAttrNameAndValue_=function(e,t,r){if(r instanceof goog.string.Const)r=goog.string.Const.unwrap(r);else if("style"==t.toLowerCase()){if(!goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE)throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Attribute "style" not supported.':"");r=goog.html.SafeHtml.getStyleValue_(r)}else{if(/^on/i.test(t))throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Attribute "'+t+'" requires goog.string.Const value, "'+r+'" given.':"");if(t.toLowerCase()in goog.html.SafeHtml.URL_ATTRIBUTES_)if(r instanceof goog.html.TrustedResourceUrl)r=goog.html.TrustedResourceUrl.unwrap(r);else if(r instanceof goog.html.SafeUrl)r=goog.html.SafeUrl.unwrap(r);else{if("string"!=typeof r)throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Attribute "'+t+'" on tag "'+e+'" requires goog.html.SafeUrl, goog.string.Const, or string, value "'+r+'" given.':"");r=goog.html.SafeUrl.sanitize(r).getTypedStringValue()}}return r.implementsGoogStringTypedString&&(r=r.getTypedStringValue()),goog.asserts.assert("string"==typeof r||"number"==typeof r,"String or number value expected, got "+typeof r+" with value: "+r),t+'="'+goog.string.internal.htmlEscape(String(r))+'"'},goog.html.SafeHtml.getStyleValue_=function(e){if(!goog.isObject(e))throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'The "style" attribute requires goog.html.SafeStyle or map of style properties, '+typeof e+" given: "+e:"");return e instanceof goog.html.SafeStyle||(e=goog.html.SafeStyle.create(e)),goog.html.SafeStyle.unwrap(e)},goog.html.SafeHtml.createWithDir=function(e,t,r,o){return(t=goog.html.SafeHtml.create(t,r,o)).dir_=e,t},goog.html.SafeHtml.join=function(e,t){var r=(e=goog.html.SafeHtml.htmlEscape(e)).getDirection(),o=[],n=function(e){Array.isArray(e)?goog.array.forEach(e,n):(e=goog.html.SafeHtml.htmlEscape(e),o.push(goog.html.SafeHtml.unwrap(e)),e=e.getDirection(),r==goog.i18n.bidi.Dir.NEUTRAL?r=e:e!=goog.i18n.bidi.Dir.NEUTRAL&&r!=e&&(r=null))};return goog.array.forEach(t,n),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(o.join(goog.html.SafeHtml.unwrap(e)),r)},goog.html.SafeHtml.concat=function(e){return goog.html.SafeHtml.join(goog.html.SafeHtml.EMPTY,Array.prototype.slice.call(arguments))},goog.html.SafeHtml.concatWithDir=function(e,t){var r=goog.html.SafeHtml.concat(goog.array.slice(arguments,1));return r.dir_=e,r},goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_={},goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse=function(e,t){return(new goog.html.SafeHtml).initSecurityPrivateDoNotAccessOrElse_(e,t)},goog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_=function(e,t){return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_=goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY?goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createHTML(e):e,this.dir_=t,this},goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse=function(e,t,r){var o=null,n="<"+e+goog.html.SafeHtml.stringifyAttributes(e,t);return null==r?r=[]:Array.isArray(r)||(r=[r]),goog.dom.tags.isVoidTag(e.toLowerCase())?(goog.asserts.assert(!r.length,"Void tag <"+e+"> does not allow content."),n+=">"):(o=goog.html.SafeHtml.concat(r),n+=">"+goog.html.SafeHtml.unwrap(o)+"</"+e+">",o=o.getDirection()),(e=t&&t.dir)&&(o=/^(ltr|rtl|auto)$/i.test(e)?goog.i18n.bidi.Dir.NEUTRAL:null),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(n,o)},goog.html.SafeHtml.stringifyAttributes=function(e,t){var r="";if(t)for(var o in t){if(!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(o))throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Invalid attribute name "'+o+'".':"");var n=t[o];null!=n&&(r+=" "+goog.html.SafeHtml.getAttrNameAndValue_(e,o,n))}return r},goog.html.SafeHtml.combineAttributes=function(e,t,r){var o,n={};for(o in e)goog.asserts.assert(o.toLowerCase()==o,"Must be lower case"),n[o]=e[o];for(o in t)goog.asserts.assert(o.toLowerCase()==o,"Must be lower case"),n[o]=t[o];if(r)for(o in r){var i=o.toLowerCase();if(i in e)throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES?'Cannot override "'+i+'" attribute, got "'+o+'" with value "'+r[o]+'"':"");i in t&&delete n[i],n[o]=r[o]}return n},goog.html.SafeHtml.DOCTYPE_HTML=goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<!DOCTYPE html>",goog.i18n.bidi.Dir.NEUTRAL),goog.html.SafeHtml.EMPTY=goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("",goog.i18n.bidi.Dir.NEUTRAL),goog.html.SafeHtml.BR=goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<br>",goog.i18n.bidi.Dir.NEUTRAL),goog.html.uncheckedconversions={},goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract=function(e,t,r){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(t,r||null)},goog.html.uncheckedconversions.safeScriptFromStringKnownToSatisfyTypeContract=function(e,t){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(t)},goog.html.uncheckedconversions.safeStyleFromStringKnownToSatisfyTypeContract=function(e,t){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(t)},goog.html.uncheckedconversions.safeStyleSheetFromStringKnownToSatisfyTypeContract=function(e,t){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(t)},goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract=function(e,t){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t)},goog.html.uncheckedconversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract=function(e,t){return goog.asserts.assertString(goog.string.Const.unwrap(e),"must provide justification"),goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)),"must provide non-empty justification"),goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(t)},goog.dom.safe={},goog.dom.safe.InsertAdjacentHtmlPosition={AFTERBEGIN:"afterbegin",AFTEREND:"afterend",BEFOREBEGIN:"beforebegin",BEFOREEND:"beforeend"},goog.dom.safe.insertAdjacentHtml=function(e,t,r){e.insertAdjacentHTML(t,goog.html.SafeHtml.unwrapTrustedHTML(r))},goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_={MATH:!0,SCRIPT:!0,STYLE:!0,SVG:!0,TEMPLATE:!0},goog.dom.safe.isInnerHtmlCleanupRecursive_=goog.functions.cacheReturnValue(function(){if(goog.DEBUG&&"undefined"==typeof document)return!1;var e=document.createElement("div"),t=document.createElement("div");return t.appendChild(document.createElement("div")),e.appendChild(t),!(goog.DEBUG&&!e.firstChild||(t=e.firstChild.firstChild,e.innerHTML=goog.html.SafeHtml.unwrapTrustedHTML(goog.html.SafeHtml.EMPTY),t.parentElement))}),goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse=function(e,t){if(goog.dom.safe.isInnerHtmlCleanupRecursive_())for(;e.lastChild;)e.removeChild(e.lastChild);e.innerHTML=goog.html.SafeHtml.unwrapTrustedHTML(t)},goog.dom.safe.setInnerHtml=function(e,t){if(goog.asserts.ENABLE_ASSERTS){var r=e.tagName.toUpperCase();if(goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_[r])throw Error("goog.dom.safe.setInnerHtml cannot be used to set content of "+e.tagName+".")}goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse(e,t)},goog.dom.safe.setOuterHtml=function(e,t){e.outerHTML=goog.html.SafeHtml.unwrapTrustedHTML(t)},goog.dom.safe.setFormElementAction=function(e,t){t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),goog.dom.asserts.assertIsHTMLFormElement(e).action=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setButtonFormAction=function(e,t){t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),goog.dom.asserts.assertIsHTMLButtonElement(e).formAction=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setInputFormAction=function(e,t){t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),goog.dom.asserts.assertIsHTMLInputElement(e).formAction=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setStyle=function(e,t){e.style.cssText=goog.html.SafeStyle.unwrap(t)},goog.dom.safe.documentWrite=function(e,t){e.write(goog.html.SafeHtml.unwrapTrustedHTML(t))},goog.dom.safe.setAnchorHref=function(e,t){goog.dom.asserts.assertIsHTMLAnchorElement(e),t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),e.href=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setImageSrc=function(e,t){if(goog.dom.asserts.assertIsHTMLImageElement(e),!(t instanceof goog.html.SafeUrl)){var r=/^data:image\//i.test(t);t=goog.html.SafeUrl.sanitizeAssertUnchanged(t,r)}e.src=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setAudioSrc=function(e,t){if(goog.dom.asserts.assertIsHTMLAudioElement(e),!(t instanceof goog.html.SafeUrl)){var r=/^data:audio\//i.test(t);t=goog.html.SafeUrl.sanitizeAssertUnchanged(t,r)}e.src=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setVideoSrc=function(e,t){if(goog.dom.asserts.assertIsHTMLVideoElement(e),!(t instanceof goog.html.SafeUrl)){var r=/^data:video\//i.test(t);t=goog.html.SafeUrl.sanitizeAssertUnchanged(t,r)}e.src=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.setEmbedSrc=function(e,t){goog.dom.asserts.assertIsHTMLEmbedElement(e),e.src=goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t)},goog.dom.safe.setFrameSrc=function(e,t){goog.dom.asserts.assertIsHTMLFrameElement(e),e.src=goog.html.TrustedResourceUrl.unwrap(t)},goog.dom.safe.setIframeSrc=function(e,t){goog.dom.asserts.assertIsHTMLIFrameElement(e),e.src=goog.html.TrustedResourceUrl.unwrap(t)},goog.dom.safe.setIframeSrcdoc=function(e,t){goog.dom.asserts.assertIsHTMLIFrameElement(e),e.srcdoc=goog.html.SafeHtml.unwrapTrustedHTML(t)},goog.dom.safe.setLinkHrefAndRel=function(e,t,r){goog.dom.asserts.assertIsHTMLLinkElement(e),e.rel=r,goog.string.internal.caseInsensitiveContains(r,"stylesheet")?(goog.asserts.assert(t instanceof goog.html.TrustedResourceUrl,'URL must be TrustedResourceUrl because "rel" contains "stylesheet"'),e.href=goog.html.TrustedResourceUrl.unwrap(t)):e.href=t instanceof goog.html.TrustedResourceUrl?goog.html.TrustedResourceUrl.unwrap(t):t instanceof goog.html.SafeUrl?goog.html.SafeUrl.unwrap(t):goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitizeAssertUnchanged(t))},goog.dom.safe.setObjectData=function(e,t){goog.dom.asserts.assertIsHTMLObjectElement(e),e.data=goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t)},goog.dom.safe.setScriptSrc=function(e,t){goog.dom.asserts.assertIsHTMLScriptElement(e),e.src=goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t),(t=goog.getScriptNonce())&&e.setAttribute("nonce",t)},goog.dom.safe.setScriptContent=function(e,t){goog.dom.asserts.assertIsHTMLScriptElement(e),e.text=goog.html.SafeScript.unwrapTrustedScript(t),(t=goog.getScriptNonce())&&e.setAttribute("nonce",t)},goog.dom.safe.setLocationHref=function(e,t){goog.dom.asserts.assertIsLocation(e),t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),e.href=goog.html.SafeUrl.unwrap(t)},goog.dom.safe.assignLocation=function(e,t){goog.dom.asserts.assertIsLocation(e),t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),e.assign(goog.html.SafeUrl.unwrap(t))},goog.dom.safe.replaceLocation=function(e,t){t=t instanceof goog.html.SafeUrl?t:goog.html.SafeUrl.sanitizeAssertUnchanged(t),e.replace(goog.html.SafeUrl.unwrap(t))},goog.dom.safe.openInWindow=function(e,t,r,o,n){return e=e instanceof goog.html.SafeUrl?e:goog.html.SafeUrl.sanitizeAssertUnchanged(e),t=t||goog.global,r=r instanceof goog.string.Const?goog.string.Const.unwrap(r):r||"",t.open(goog.html.SafeUrl.unwrap(e),r,o,n)},goog.dom.safe.parseFromStringHtml=function(e,t){return goog.dom.safe.parseFromString(e,t,"text/html")},goog.dom.safe.parseFromString=function(e,t,r){return e.parseFromString(goog.html.SafeHtml.unwrapTrustedHTML(t),r)},goog.dom.safe.createImageFromBlob=function(e){if(!/^image\/.*/g.test(e.type))throw Error("goog.dom.safe.createImageFromBlob only accepts MIME type image/.*.");var t=goog.global.URL.createObjectURL(e);return(e=new goog.global.Image).onload=function(){goog.global.URL.revokeObjectURL(t)},goog.dom.safe.setImageSrc(e,goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Image blob URL."),t)),e},goog.string.DETECT_DOUBLE_ESCAPING=!1,goog.string.FORCE_NON_DOM_HTML_UNESCAPING=!1,goog.string.Unicode={NBSP:" "},goog.string.startsWith=goog.string.internal.startsWith,goog.string.endsWith=goog.string.internal.endsWith,goog.string.caseInsensitiveStartsWith=goog.string.internal.caseInsensitiveStartsWith,goog.string.caseInsensitiveEndsWith=goog.string.internal.caseInsensitiveEndsWith,goog.string.caseInsensitiveEquals=goog.string.internal.caseInsensitiveEquals,goog.string.subs=function(e,t){for(var r=e.split("%s"),o="",n=Array.prototype.slice.call(arguments,1);n.length&&1<r.length;)o+=r.shift()+n.shift();return o+r.join("%s")},goog.string.collapseWhitespace=function(e){return e.replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")},goog.string.isEmptyOrWhitespace=goog.string.internal.isEmptyOrWhitespace,goog.string.isEmptyString=function(e){return 0==e.length},goog.string.isEmpty=goog.string.isEmptyOrWhitespace,goog.string.isEmptyOrWhitespaceSafe=function(e){return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(e))},goog.string.isEmptySafe=goog.string.isEmptyOrWhitespaceSafe,goog.string.isBreakingWhitespace=function(e){return!/[^\t\n\r ]/.test(e)},goog.string.isAlpha=function(e){return!/[^a-zA-Z]/.test(e)},goog.string.isNumeric=function(e){return!/[^0-9]/.test(e)},goog.string.isAlphaNumeric=function(e){return!/[^a-zA-Z0-9]/.test(e)},goog.string.isSpace=function(e){return" "==e},goog.string.isUnicodeChar=function(e){return 1==e.length&&" "<=e&&"~">=e||""<=e&&"�">=e},goog.string.stripNewlines=function(e){return e.replace(/(\r\n|\r|\n)+/g," ")},goog.string.canonicalizeNewlines=function(e){return e.replace(/(\r\n|\r|\n)/g,"\n")},goog.string.normalizeWhitespace=function(e){return e.replace(/\xa0|\s/g," ")},goog.string.normalizeSpaces=function(e){return e.replace(/\xa0|[ \t]+/g," ")},goog.string.collapseBreakingSpaces=function(e){return e.replace(/[\t\r\n ]+/g," ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g,"")},goog.string.trim=goog.string.internal.trim,goog.string.trimLeft=function(e){return e.replace(/^[\s\xa0]+/,"")},goog.string.trimRight=function(e){return e.replace(/[\s\xa0]+$/,"")},goog.string.caseInsensitiveCompare=goog.string.internal.caseInsensitiveCompare,goog.string.numberAwareCompare_=function(e,t,r){if(e==t)return 0;if(!e)return-1;if(!t)return 1;for(var o=e.toLowerCase().match(r),n=t.toLowerCase().match(r),i=Math.min(o.length,n.length),a=0;a<i;a++){r=o[a];var s=n[a];if(r!=s)return e=parseInt(r,10),!isNaN(e)&&(t=parseInt(s,10),!isNaN(t)&&e-t)?e-t:r<s?-1:1}return o.length!=n.length?o.length-n.length:e<t?-1:1},goog.string.intAwareCompare=function(e,t){return goog.string.numberAwareCompare_(e,t,/\d+|\D+/g)},goog.string.floatAwareCompare=function(e,t){return goog.string.numberAwareCompare_(e,t,/\d+|\.\d+|\D+/g)},goog.string.numerateCompare=goog.string.floatAwareCompare,goog.string.urlEncode=function(e){return encodeURIComponent(String(e))},goog.string.urlDecode=function(e){return decodeURIComponent(e.replace(/\+/g," "))},goog.string.newLineToBr=goog.string.internal.newLineToBr,goog.string.htmlEscape=function(e,t){return e=goog.string.internal.htmlEscape(e,t),goog.string.DETECT_DOUBLE_ESCAPING&&(e=e.replace(goog.string.E_RE_,"&#101;")),e},goog.string.E_RE_=/e/g,goog.string.unescapeEntities=function(e){return goog.string.contains(e,"&")?!goog.string.FORCE_NON_DOM_HTML_UNESCAPING&&"document"in goog.global?goog.string.unescapeEntitiesUsingDom_(e):goog.string.unescapePureXmlEntities_(e):e},goog.string.unescapeEntitiesWithDocument=function(e,t){return goog.string.contains(e,"&")?goog.string.unescapeEntitiesUsingDom_(e,t):e},goog.string.unescapeEntitiesUsingDom_=function(e,t){var r={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"'},o=t?t.createElement("div"):goog.global.document.createElement("div");return e.replace(goog.string.HTML_ENTITY_PATTERN_,function(e,t){var n=r[e];return n||("#"==t.charAt(0)&&(t=Number("0"+t.substr(1)),isNaN(t)||(n=String.fromCharCode(t))),n||(goog.dom.safe.setInnerHtml(o,goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Single HTML entity."),e+" ")),n=o.firstChild.nodeValue.slice(0,-1)),r[e]=n)})},goog.string.unescapePureXmlEntities_=function(e){return e.replace(/&([^;]+);/g,function(e,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';default:return"#"!=t.charAt(0)||(t=Number("0"+t.substr(1)),isNaN(t))?e:String.fromCharCode(t)}})},goog.string.HTML_ENTITY_PATTERN_=/&([^;\s<&]+);?/g,goog.string.whitespaceEscape=function(e,t){return goog.string.newLineToBr(e.replace(/  /g," &#160;"),t)},goog.string.preserveSpaces=function(e){return e.replace(/(^|[\n ]) /g,"$1"+goog.string.Unicode.NBSP)},goog.string.stripQuotes=function(e,t){for(var r=t.length,o=0;o<r;o++){var n=1==r?t:t.charAt(o);if(e.charAt(0)==n&&e.charAt(e.length-1)==n)return e.substring(1,e.length-1)}return e},goog.string.truncate=function(e,t,r){return r&&(e=goog.string.unescapeEntities(e)),e.length>t&&(e=e.substring(0,t-3)+"..."),r&&(e=goog.string.htmlEscape(e)),e},goog.string.truncateMiddle=function(e,t,r,o){if(r&&(e=goog.string.unescapeEntities(e)),o&&e.length>t){o>t&&(o=t);var n=e.length-o;e=e.substring(0,t-o)+"..."+e.substring(n)}else e.length>t&&(o=Math.floor(t/2),n=e.length-o,e=e.substring(0,o+t%2)+"..."+e.substring(n));return r&&(e=goog.string.htmlEscape(e)),e},goog.string.specialEscapeChars_={"\0":"\\0","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\v":"\\x0B",'"':'\\"',"\\":"\\\\","<":"\\u003C"},goog.string.jsEscapeCache_={"'":"\\'"},goog.string.quote=function(e){e=String(e);for(var t=['"'],r=0;r<e.length;r++){var o=e.charAt(r),n=o.charCodeAt(0);t[r+1]=goog.string.specialEscapeChars_[o]||(31<n&&127>n?o:goog.string.escapeChar(o))}return t.push('"'),t.join("")},goog.string.escapeString=function(e){for(var t=[],r=0;r<e.length;r++)t[r]=goog.string.escapeChar(e.charAt(r));return t.join("")},goog.string.escapeChar=function(e){if(e in goog.string.jsEscapeCache_)return goog.string.jsEscapeCache_[e];if(e in goog.string.specialEscapeChars_)return goog.string.jsEscapeCache_[e]=goog.string.specialEscapeChars_[e];var t=e.charCodeAt(0);if(31<t&&127>t)var r=e;else 256>t?(r="\\x",(16>t||256<t)&&(r+="0")):(r="\\u",4096>t&&(r+="0")),r+=t.toString(16).toUpperCase();return goog.string.jsEscapeCache_[e]=r},goog.string.contains=goog.string.internal.contains,goog.string.caseInsensitiveContains=goog.string.internal.caseInsensitiveContains,goog.string.countOf=function(e,t){return e&&t?e.split(t).length-1:0},goog.string.removeAt=function(e,t,r){var o=e;return 0<=t&&t<e.length&&0<r&&(o=e.substr(0,t)+e.substr(t+r,e.length-t-r)),o},goog.string.remove=function(e,t){return e.replace(t,"")},goog.string.removeAll=function(e,t){return t=new RegExp(goog.string.regExpEscape(t),"g"),e.replace(t,"")},goog.string.replaceAll=function(e,t,r){return t=new RegExp(goog.string.regExpEscape(t),"g"),e.replace(t,r.replace(/\$/g,"$$$$"))},goog.string.regExpEscape=function(e){return String(e).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")},goog.string.repeat=String.prototype.repeat?function(e,t){return e.repeat(t)}:function(e,t){return Array(t+1).join(e)},goog.string.padNumber=function(e,t,r){return-1==(r=(e=void 0!==r?e.toFixed(r):String(e)).indexOf("."))&&(r=e.length),goog.string.repeat("0",Math.max(0,t-r))+e},goog.string.makeSafe=function(e){return null==e?"":String(e)},goog.string.buildString=function(e){return Array.prototype.join.call(arguments,"")},goog.string.getRandomString=function(){return Math.floor(2147483648*Math.random()).toString(36)+Math.abs(Math.floor(2147483648*Math.random())^goog.now()).toString(36)},goog.string.compareVersions=goog.string.internal.compareVersions,goog.string.hashCode=function(e){for(var t=0,r=0;r<e.length;++r)t=31*t+e.charCodeAt(r)>>>0;return t},goog.string.uniqueStringCounter_=2147483648*Math.random()|0,goog.string.createUniqueString=function(){return"goog_"+goog.string.uniqueStringCounter_++},goog.string.toNumber=function(e){var t=Number(e);return 0==t&&goog.string.isEmptyOrWhitespace(e)?NaN:t},goog.string.isLowerCamelCase=function(e){return/^[a-z]+([A-Z][a-z]*)*$/.test(e)},goog.string.isUpperCamelCase=function(e){return/^([A-Z][a-z]*)+$/.test(e)},goog.string.toCamelCase=function(e){return String(e).replace(/\-([a-z])/g,function(e,t){return t.toUpperCase()})},goog.string.toSelectorCase=function(e){return String(e).replace(/([A-Z])/g,"-$1").toLowerCase()},goog.string.toTitleCase=function(e,t){return t="string"==typeof t?goog.string.regExpEscape(t):"\\s",e.replace(new RegExp("(^"+(t?"|["+t+"]+":"")+")([a-z])","g"),function(e,t,r){return t+r.toUpperCase()})},goog.string.capitalize=function(e){return String(e.charAt(0)).toUpperCase()+String(e.substr(1)).toLowerCase()},goog.string.parseInt=function(e){return isFinite(e)&&(e=String(e)),"string"==typeof e?/^\s*-?0x/i.test(e)?parseInt(e,16):parseInt(e,10):NaN},goog.string.splitLimit=function(e,t,r){e=e.split(t);for(var o=[];0<r&&e.length;)o.push(e.shift()),r--;return e.length&&o.push(e.join(t)),o},goog.string.lastComponent=function(e,t){if(!t)return e;"string"==typeof t&&(t=[t]);for(var r=-1,o=0;o<t.length;o++)if(""!=t[o]){var n=e.lastIndexOf(t[o]);n>r&&(r=n)}return-1==r?e:e.slice(r+1)},goog.string.editDistance=function(e,t){var r=[],o=[];if(e==t)return 0;if(!e.length||!t.length)return Math.max(e.length,t.length);for(var n=0;n<t.length+1;n++)r[n]=n;for(n=0;n<e.length;n++){o[0]=n+1;for(var i=0;i<t.length;i++)o[i+1]=Math.min(o[i]+1,r[i+1]+1,r[i]+Number(e[n]!=t[i]));for(i=0;i<r.length;i++)r[i]=o[i]}return o[t.length]},goog.labs.userAgent.engine={},goog.labs.userAgent.engine.isPresto=function(){return goog.labs.userAgent.util.matchUserAgent("Presto")},goog.labs.userAgent.engine.isTrident=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")},goog.labs.userAgent.engine.isEdge=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")},goog.labs.userAgent.engine.isWebKit=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit")&&!goog.labs.userAgent.engine.isEdge()},goog.labs.userAgent.engine.isGecko=function(){return goog.labs.userAgent.util.matchUserAgent("Gecko")&&!goog.labs.userAgent.engine.isWebKit()&&!goog.labs.userAgent.engine.isTrident()&&!goog.labs.userAgent.engine.isEdge()},goog.labs.userAgent.engine.getVersion=function(){var e=goog.labs.userAgent.util.getUserAgent();if(e){e=goog.labs.userAgent.util.extractVersionTuples(e);var t,r=goog.labs.userAgent.engine.getEngineTuple_(e);if(r)return"Gecko"==r[0]?goog.labs.userAgent.engine.getVersionForKey_(e,"Firefox"):r[1];if((e=e[0])&&(t=e[2])&&(t=/Trident\/([^\s;]+)/.exec(t)))return t[1]}return""},goog.labs.userAgent.engine.getEngineTuple_=function(e){if(!goog.labs.userAgent.engine.isEdge())return e[1];for(var t=0;t<e.length;t++){var r=e[t];if("Edge"==r[0])return r}},goog.labs.userAgent.engine.isVersionOrHigher=function(e){return 0<=goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(),e)},goog.labs.userAgent.engine.getVersionForKey_=function(e,t){return(e=goog.array.find(e,function(e){return t==e[0]}))&&e[1]||""},goog.labs.userAgent.platform={},goog.labs.userAgent.platform.isAndroid=function(){return goog.labs.userAgent.util.matchUserAgent("Android")},goog.labs.userAgent.platform.isIpod=function(){return goog.labs.userAgent.util.matchUserAgent("iPod")},goog.labs.userAgent.platform.isIphone=function(){return goog.labs.userAgent.util.matchUserAgent("iPhone")&&!goog.labs.userAgent.util.matchUserAgent("iPod")&&!goog.labs.userAgent.util.matchUserAgent("iPad")},goog.labs.userAgent.platform.isIpad=function(){return goog.labs.userAgent.util.matchUserAgent("iPad")},goog.labs.userAgent.platform.isIos=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpad()||goog.labs.userAgent.platform.isIpod()},goog.labs.userAgent.platform.isMacintosh=function(){return goog.labs.userAgent.util.matchUserAgent("Macintosh")},goog.labs.userAgent.platform.isLinux=function(){return goog.labs.userAgent.util.matchUserAgent("Linux")},goog.labs.userAgent.platform.isWindows=function(){return goog.labs.userAgent.util.matchUserAgent("Windows")},goog.labs.userAgent.platform.isChromeOS=function(){return goog.labs.userAgent.util.matchUserAgent("CrOS")},goog.labs.userAgent.platform.isChromecast=function(){return goog.labs.userAgent.util.matchUserAgent("CrKey")},goog.labs.userAgent.platform.isKaiOS=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("KaiOS")},goog.labs.userAgent.platform.getVersion=function(){var e=goog.labs.userAgent.util.getUserAgent(),t="";return goog.labs.userAgent.platform.isWindows()?t=(e=(t=/Windows (?:NT|Phone) ([0-9.]+)/).exec(e))?e[1]:"0.0":goog.labs.userAgent.platform.isIos()?t=(e=(t=/(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/).exec(e))&&e[1].replace(/_/g,"."):goog.labs.userAgent.platform.isMacintosh()?t=(e=(t=/Mac OS X ([0-9_.]+)/).exec(e))?e[1].replace(/_/g,"."):"10":goog.labs.userAgent.platform.isKaiOS()?t=(e=(t=/(?:KaiOS)\/(\S+)/i).exec(e))&&e[1]:goog.labs.userAgent.platform.isAndroid()?t=(e=(t=/Android\s+([^\);]+)(\)|;)/).exec(e))&&e[1]:goog.labs.userAgent.platform.isChromeOS()&&(t=(e=(t=/(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/).exec(e))&&e[1]),t||""},goog.labs.userAgent.platform.isVersionOrHigher=function(e){return 0<=goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(),e)},goog.reflect={},goog.reflect.object=function(e,t){return t},goog.reflect.objectProperty=function(e,t){return e},goog.reflect.sinkValue=function(e){return goog.reflect.sinkValue[" "](e),e},goog.reflect.sinkValue[" "]=goog.nullFunction,goog.reflect.canAccessProperty=function(e,t){try{return goog.reflect.sinkValue(e[t]),!0}catch(e){}return!1},goog.reflect.cache=function(e,t,r,o){return o=o?o(t):t,Object.prototype.hasOwnProperty.call(e,o)?e[o]:e[o]=r(t)},goog.userAgent={},goog.userAgent.ASSUME_IE=!1,goog.userAgent.ASSUME_EDGE=!1,goog.userAgent.ASSUME_GECKO=!1,goog.userAgent.ASSUME_WEBKIT=!1,goog.userAgent.ASSUME_MOBILE_WEBKIT=!1,goog.userAgent.ASSUME_OPERA=!1,goog.userAgent.ASSUME_ANY_VERSION=!1,goog.userAgent.BROWSER_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_GECKO||goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_OPERA,goog.userAgent.getUserAgentString=function(){return goog.labs.userAgent.util.getUserAgent()},goog.userAgent.getNavigatorTyped=function(){return goog.global.navigator||null},goog.userAgent.getNavigator=function(){return goog.userAgent.getNavigatorTyped()},goog.userAgent.OPERA=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_OPERA:goog.labs.userAgent.browser.isOpera(),goog.userAgent.IE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_IE:goog.labs.userAgent.browser.isIE(),goog.userAgent.EDGE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_EDGE:goog.labs.userAgent.engine.isEdge(),goog.userAgent.EDGE_OR_IE=goog.userAgent.EDGE||goog.userAgent.IE,goog.userAgent.GECKO=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_GECKO:goog.labs.userAgent.engine.isGecko(),goog.userAgent.WEBKIT=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_MOBILE_WEBKIT:goog.labs.userAgent.engine.isWebKit(),goog.userAgent.isMobile_=function(){return goog.userAgent.WEBKIT&&goog.labs.userAgent.util.matchUserAgent("Mobile")},goog.userAgent.MOBILE=goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.isMobile_(),goog.userAgent.SAFARI=goog.userAgent.WEBKIT,goog.userAgent.determinePlatform_=function(){var e=goog.userAgent.getNavigatorTyped();return e&&e.platform||""},goog.userAgent.PLATFORM=goog.userAgent.determinePlatform_(),goog.userAgent.ASSUME_MAC=!1,goog.userAgent.ASSUME_WINDOWS=!1,goog.userAgent.ASSUME_LINUX=!1,goog.userAgent.ASSUME_X11=!1,goog.userAgent.ASSUME_ANDROID=!1,goog.userAgent.ASSUME_IPHONE=!1,goog.userAgent.ASSUME_IPAD=!1,goog.userAgent.ASSUME_IPOD=!1,goog.userAgent.ASSUME_KAIOS=!1,goog.userAgent.PLATFORM_KNOWN_=goog.userAgent.ASSUME_MAC||goog.userAgent.ASSUME_WINDOWS||goog.userAgent.ASSUME_LINUX||goog.userAgent.ASSUME_X11||goog.userAgent.ASSUME_ANDROID||goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD,goog.userAgent.MAC=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_MAC:goog.labs.userAgent.platform.isMacintosh();goog.userAgent.WINDOWS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_WINDOWS:goog.labs.userAgent.platform.isWindows(),goog.userAgent.isLegacyLinux_=function(){return goog.labs.userAgent.platform.isLinux()||goog.labs.userAgent.platform.isChromeOS()},goog.userAgent.LINUX=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_LINUX:goog.userAgent.isLegacyLinux_(),goog.userAgent.isX11_=function(){var e=goog.userAgent.getNavigatorTyped();return!!e&&goog.string.contains(e.appVersion||"","X11")},goog.userAgent.X11=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_X11:goog.userAgent.isX11_(),goog.userAgent.ANDROID=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_ANDROID:goog.labs.userAgent.platform.isAndroid(),goog.userAgent.IPHONE=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE:goog.labs.userAgent.platform.isIphone(),goog.userAgent.IPAD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad(),goog.userAgent.IPOD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIpod(),goog.userAgent.IOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIos(),goog.userAgent.KAIOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_KAIOS:goog.labs.userAgent.platform.isKaiOS(),goog.userAgent.determineVersion_=function(){var e="",t=goog.userAgent.getVersionRegexResult_();return t&&(e=t?t[1]:""),goog.userAgent.IE&&null!=(t=goog.userAgent.getDocumentMode_())&&t>parseFloat(e)?String(t):e},goog.userAgent.getVersionRegexResult_=function(){var e=goog.userAgent.getUserAgentString();return goog.userAgent.GECKO?/rv:([^\);]+)(\)|;)/.exec(e):goog.userAgent.EDGE?/Edge\/([\d\.]+)/.exec(e):goog.userAgent.IE?/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(e):goog.userAgent.WEBKIT?/WebKit\/(\S+)/.exec(e):goog.userAgent.OPERA?/(?:Version)[ \/]?(\S+)/.exec(e):void 0},goog.userAgent.getDocumentMode_=function(){var e=goog.global.document;return e?e.documentMode:void 0},goog.userAgent.VERSION=goog.userAgent.determineVersion_(),goog.userAgent.compare=function(e,t){return goog.string.compareVersions(e,t)},goog.userAgent.isVersionOrHigherCache_={},goog.userAgent.isVersionOrHigher=function(e){return goog.userAgent.ASSUME_ANY_VERSION||goog.reflect.cache(goog.userAgent.isVersionOrHigherCache_,e,function(){return 0<=goog.string.compareVersions(goog.userAgent.VERSION,e)})},goog.userAgent.isVersion=goog.userAgent.isVersionOrHigher,goog.userAgent.isDocumentModeOrHigher=function(e){return Number(goog.userAgent.DOCUMENT_MODE)>=e},goog.userAgent.isDocumentMode=goog.userAgent.isDocumentModeOrHigher,goog.userAgent.DOCUMENT_MODE=function(){if(goog.global.document&&goog.userAgent.IE)return goog.userAgent.getDocumentMode_()||parseInt(goog.userAgent.VERSION,10)||void 0}(),goog.userAgent.product={},goog.userAgent.product.ASSUME_FIREFOX=!1,goog.userAgent.product.ASSUME_IPHONE=!1,goog.userAgent.product.ASSUME_IPAD=!1,goog.userAgent.product.ASSUME_ANDROID=!1,goog.userAgent.product.ASSUME_CHROME=!1,goog.userAgent.product.ASSUME_SAFARI=!1,goog.userAgent.product.PRODUCT_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_OPERA||goog.userAgent.product.ASSUME_FIREFOX||goog.userAgent.product.ASSUME_IPHONE||goog.userAgent.product.ASSUME_IPAD||goog.userAgent.product.ASSUME_ANDROID||goog.userAgent.product.ASSUME_CHROME||goog.userAgent.product.ASSUME_SAFARI,goog.userAgent.product.OPERA=goog.userAgent.OPERA,goog.userAgent.product.IE=goog.userAgent.IE,goog.userAgent.product.EDGE=goog.userAgent.EDGE,goog.userAgent.product.FIREFOX=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_FIREFOX:goog.labs.userAgent.browser.isFirefox(),goog.userAgent.product.isIphoneOrIpod_=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpod()},goog.userAgent.product.IPHONE=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPHONE:goog.userAgent.product.isIphoneOrIpod_(),goog.userAgent.product.IPAD=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad(),goog.userAgent.product.ANDROID=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_ANDROID:goog.labs.userAgent.browser.isAndroidBrowser(),goog.userAgent.product.CHROME=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_CHROME:goog.labs.userAgent.browser.isChrome(),goog.userAgent.product.isSafariDesktop_=function(){return goog.labs.userAgent.browser.isSafari()&&!goog.labs.userAgent.platform.isIos()},goog.userAgent.product.SAFARI=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_SAFARI:goog.userAgent.product.isSafariDesktop_(),goog.crypt.base64={},goog.crypt.base64.DEFAULT_ALPHABET_COMMON_="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",goog.crypt.base64.ENCODED_VALS=goog.crypt.base64.DEFAULT_ALPHABET_COMMON_+"+/=",goog.crypt.base64.ENCODED_VALS_WEBSAFE=goog.crypt.base64.DEFAULT_ALPHABET_COMMON_+"-_.",goog.crypt.base64.Alphabet={DEFAULT:0,NO_PADDING:1,WEBSAFE:2,WEBSAFE_DOT_PADDING:3,WEBSAFE_NO_PADDING:4},goog.crypt.base64.paddingChars_="=.",goog.crypt.base64.isPadding_=function(e){return goog.string.contains(goog.crypt.base64.paddingChars_,e)},goog.crypt.base64.byteToCharMaps_={},goog.crypt.base64.charToByteMap_=null,goog.crypt.base64.ASSUME_NATIVE_SUPPORT_=goog.userAgent.GECKO||goog.userAgent.WEBKIT&&!goog.userAgent.product.SAFARI||goog.userAgent.OPERA,goog.crypt.base64.HAS_NATIVE_ENCODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||"function"==typeof goog.global.btoa,goog.crypt.base64.HAS_NATIVE_DECODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||!goog.userAgent.product.SAFARI&&!goog.userAgent.IE&&"function"==typeof goog.global.atob,goog.crypt.base64.encodeByteArray=function(e,t){goog.asserts.assert(goog.isArrayLike(e),"encodeByteArray takes an array as a parameter"),void 0===t&&(t=goog.crypt.base64.Alphabet.DEFAULT),goog.crypt.base64.init_(),t=goog.crypt.base64.byteToCharMaps_[t];for(var r=[],o=0;o<e.length;o+=3){var n=e[o],i=o+1<e.length,a=i?e[o+1]:0,s=o+2<e.length,p=s?e[o+2]:0,c=n>>2;n=(3&n)<<4|a>>4,a=(15&a)<<2|p>>6,p&=63,s||(p=64,i||(a=64)),r.push(t[c],t[n],t[a]||"",t[p]||"")}return r.join("")},goog.crypt.base64.encodeString=function(e,t){return goog.crypt.base64.HAS_NATIVE_ENCODE_&&!t?goog.global.btoa(e):goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(e),t)},goog.crypt.base64.decodeString=function(e,t){if(goog.crypt.base64.HAS_NATIVE_DECODE_&&!t)return goog.global.atob(e);var r="";return goog.crypt.base64.decodeStringInternal_(e,function(e){r+=String.fromCharCode(e)}),r},goog.crypt.base64.decodeStringToByteArray=function(e,t){var r=[];return goog.crypt.base64.decodeStringInternal_(e,function(e){r.push(e)}),r},goog.crypt.base64.decodeStringToUint8Array=function(e){goog.asserts.assert(!goog.userAgent.IE||goog.userAgent.isVersionOrHigher("10"),"Browser does not support typed arrays");var t=e.length,r=3*t/4;r%3?r=Math.floor(r):goog.crypt.base64.isPadding_(e[t-1])&&(r=goog.crypt.base64.isPadding_(e[t-2])?r-2:r-1);var o=new Uint8Array(r),n=0;return goog.crypt.base64.decodeStringInternal_(e,function(e){o[n++]=e}),o.subarray(0,n)},goog.crypt.base64.decodeStringInternal_=function(e,t){function r(t){for(;o<e.length;){var r=e.charAt(o++),n=goog.crypt.base64.charToByteMap_[r];if(null!=n)return n;if(!goog.string.isEmptyOrWhitespace(r))throw Error("Unknown base64 encoding at char: "+r)}return t}goog.crypt.base64.init_();for(var o=0;;){var n=r(-1),i=r(0),a=r(64),s=r(64);if(64===s&&-1===n)break;t(n<<2|i>>4),64!=a&&(t(i<<4&240|a>>2),64!=s&&t(a<<6&192|s))}},goog.crypt.base64.init_=function(){if(!goog.crypt.base64.charToByteMap_){goog.crypt.base64.charToByteMap_={};for(var e=goog.crypt.base64.DEFAULT_ALPHABET_COMMON_.split(""),t=["+/=","+/","-_=","-_.","-_"],r=0;5>r;r++){var o=e.concat(t[r].split(""));goog.crypt.base64.byteToCharMaps_[r]=o;for(var n=0;n<o.length;n++){var i=o[n],a=goog.crypt.base64.charToByteMap_[i];void 0===a?goog.crypt.base64.charToByteMap_[i]=n:goog.asserts.assert(a===n)}}}},jspb.utils={},jspb.utils.split64Low=0,jspb.utils.split64High=0,jspb.utils.splitUint64=function(e){var t=e>>>0;e=Math.floor((e-t)/jspb.BinaryConstants.TWO_TO_32)>>>0,jspb.utils.split64Low=t,jspb.utils.split64High=e},jspb.utils.splitInt64=function(e){var t=0>e,r=(e=Math.abs(e))>>>0;e=Math.floor((e-r)/jspb.BinaryConstants.TWO_TO_32),e>>>=0,t&&(e=~e>>>0,4294967295<(r=1+(~r>>>0))&&(r=0,4294967295<++e&&(e=0))),jspb.utils.split64Low=r,jspb.utils.split64High=e},jspb.utils.splitZigzag64=function(e){var t=0>e;e=2*Math.abs(e),jspb.utils.splitUint64(e),e=jspb.utils.split64Low;var r=jspb.utils.split64High;t&&(0==e?0==r?r=e=4294967295:(r--,e=4294967295):e--),jspb.utils.split64Low=e,jspb.utils.split64High=r},jspb.utils.splitFloat32=function(e){var t=0>e?1:0;if(0===(e=t?-e:e))0<1/e?(jspb.utils.split64High=0,jspb.utils.split64Low=0):(jspb.utils.split64High=0,jspb.utils.split64Low=2147483648);else if(isNaN(e))jspb.utils.split64High=0,jspb.utils.split64Low=2147483647;else if(e>jspb.BinaryConstants.FLOAT32_MAX)jspb.utils.split64High=0,jspb.utils.split64Low=(t<<31|2139095040)>>>0;else if(e<jspb.BinaryConstants.FLOAT32_MIN)e=Math.round(e/Math.pow(2,-149)),jspb.utils.split64High=0,jspb.utils.split64Low=(t<<31|e)>>>0;else{var r=Math.floor(Math.log(e)/Math.LN2);e*=Math.pow(2,-r),16777216<=(e=Math.round(e*jspb.BinaryConstants.TWO_TO_23))&&++r,jspb.utils.split64High=0,jspb.utils.split64Low=(t<<31|r+127<<23|8388607&e)>>>0}},jspb.utils.splitFloat64=function(e){var t=0>e?1:0;if(0===(e=t?-e:e))jspb.utils.split64High=0<1/e?0:2147483648,jspb.utils.split64Low=0;else if(isNaN(e))jspb.utils.split64High=2147483647,jspb.utils.split64Low=4294967295;else if(e>jspb.BinaryConstants.FLOAT64_MAX)jspb.utils.split64High=(t<<31|2146435072)>>>0,jspb.utils.split64Low=0;else if(e<jspb.BinaryConstants.FLOAT64_MIN){var r=e/Math.pow(2,-1074);e=r/jspb.BinaryConstants.TWO_TO_32,jspb.utils.split64High=(t<<31|e)>>>0,jspb.utils.split64Low=r>>>0}else{var o=0;if(2<=(r=e))for(;2<=r&&1023>o;)o++,r/=2;else for(;1>r&&-1022<o;)r*=2,o--;e=(r=e*Math.pow(2,-o))*jspb.BinaryConstants.TWO_TO_20&1048575,r=r*jspb.BinaryConstants.TWO_TO_52>>>0,jspb.utils.split64High=(t<<31|o+1023<<20|e)>>>0,jspb.utils.split64Low=r}},jspb.utils.splitHash64=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),o=e.charCodeAt(2),n=e.charCodeAt(3),i=e.charCodeAt(4),a=e.charCodeAt(5),s=e.charCodeAt(6);e=e.charCodeAt(7),jspb.utils.split64Low=t+(r<<8)+(o<<16)+(n<<24)>>>0,jspb.utils.split64High=i+(a<<8)+(s<<16)+(e<<24)>>>0},jspb.utils.joinUint64=function(e,t){return t*jspb.BinaryConstants.TWO_TO_32+(e>>>0)},jspb.utils.joinInt64=function(e,t){var r=2147483648&t;return r&&(t=~t>>>0,0==(e=1+~e>>>0)&&(t=t+1>>>0)),e=jspb.utils.joinUint64(e,t),r?-e:e},jspb.utils.toZigzag64=function(e,t,r){var o=t>>31;return r(e<<1^o,(t<<1|e>>>31)^o)},jspb.utils.joinZigzag64=function(e,t){return jspb.utils.fromZigzag64(e,t,jspb.utils.joinInt64)},jspb.utils.fromZigzag64=function(e,t,r){var o=-(1&e);return r((e>>>1|t<<31)^o,t>>>1^o)},jspb.utils.joinFloat32=function(e,t){t=2*(e>>31)+1;var r=e>>>23&255;return e&=8388607,255==r?e?NaN:1/0*t:0==r?t*Math.pow(2,-149)*e:t*Math.pow(2,r-150)*(e+Math.pow(2,23))},jspb.utils.joinFloat64=function(e,t){var r=2*(t>>31)+1,o=t>>>20&2047;return e=jspb.BinaryConstants.TWO_TO_32*(1048575&t)+e,2047==o?e?NaN:1/0*r:0==o?r*Math.pow(2,-1074)*e:r*Math.pow(2,o-1075)*(e+jspb.BinaryConstants.TWO_TO_52)},jspb.utils.joinHash64=function(e,t){return String.fromCharCode(e>>>0&255,e>>>8&255,e>>>16&255,e>>>24&255,t>>>0&255,t>>>8&255,t>>>16&255,t>>>24&255)},jspb.utils.DIGITS="0123456789abcdef".split(""),jspb.utils.ZERO_CHAR_CODE_=48,jspb.utils.A_CHAR_CODE_=97,jspb.utils.joinUnsignedDecimalString=function(e,t){function r(e,t){return e=e?String(e):"",t?"0000000".slice(e.length)+e:e}if(2097151>=t)return""+jspb.utils.joinUint64(e,t);var o=(e>>>24|t<<8)>>>0&16777215;return e=(16777215&e)+6777216*o+6710656*(t=t>>16&65535),o+=8147497*t,t*=2,1e7<=e&&(o+=Math.floor(e/1e7),e%=1e7),1e7<=o&&(t+=Math.floor(o/1e7),o%=1e7),r(t,0)+r(o,t)+r(e,1)},jspb.utils.joinSignedDecimalString=function(e,t){var r=2147483648&t;return r&&(t=~t+(0==(e=1+~e>>>0)?1:0)>>>0),e=jspb.utils.joinUnsignedDecimalString(e,t),r?"-"+e:e},jspb.utils.hash64ToDecimalString=function(e,t){jspb.utils.splitHash64(e),e=jspb.utils.split64Low;var r=jspb.utils.split64High;return t?jspb.utils.joinSignedDecimalString(e,r):jspb.utils.joinUnsignedDecimalString(e,r)},jspb.utils.hash64ArrayToDecimalStrings=function(e,t){for(var r=Array(e.length),o=0;o<e.length;o++)r[o]=jspb.utils.hash64ToDecimalString(e[o],t);return r},jspb.utils.decimalStringToHash64=function(e){function t(e,t){for(var r=0;8>r&&(1!==e||0<t);r++)t=e*o[r]+t,o[r]=255&t,t>>>=8}jspb.asserts.assert(0<e.length);var r=!1;"-"===e[0]&&(r=!0,e=e.slice(1));for(var o=[0,0,0,0,0,0,0,0],n=0;n<e.length;n++)t(10,e.charCodeAt(n)-jspb.utils.ZERO_CHAR_CODE_);return r&&(function(){for(var e=0;8>e;e++)o[e]=255&~o[e]}(),t(1,1)),goog.crypt.byteArrayToString(o)},jspb.utils.splitDecimalString=function(e){jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e))},jspb.utils.toHexDigit_=function(e){return String.fromCharCode(10>e?jspb.utils.ZERO_CHAR_CODE_+e:jspb.utils.A_CHAR_CODE_-10+e)},jspb.utils.fromHexCharCode_=function(e){return e>=jspb.utils.A_CHAR_CODE_?e-jspb.utils.A_CHAR_CODE_+10:e-jspb.utils.ZERO_CHAR_CODE_},jspb.utils.hash64ToHexString=function(e){var t=Array(18);t[0]="0",t[1]="x";for(var r=0;8>r;r++){var o=e.charCodeAt(7-r);t[2*r+2]=jspb.utils.toHexDigit_(o>>4),t[2*r+3]=jspb.utils.toHexDigit_(15&o)}return t.join("")},jspb.utils.hexStringToHash64=function(e){e=e.toLowerCase(),jspb.asserts.assert(18==e.length),jspb.asserts.assert("0"==e[0]),jspb.asserts.assert("x"==e[1]);for(var t="",r=0;8>r;r++){var o=jspb.utils.fromHexCharCode_(e.charCodeAt(2*r+2)),n=jspb.utils.fromHexCharCode_(e.charCodeAt(2*r+3));t=String.fromCharCode(16*o+n)+t}return t},jspb.utils.hash64ToNumber=function(e,t){jspb.utils.splitHash64(e),e=jspb.utils.split64Low;var r=jspb.utils.split64High;return t?jspb.utils.joinInt64(e,r):jspb.utils.joinUint64(e,r)},jspb.utils.numberToHash64=function(e){return jspb.utils.splitInt64(e),jspb.utils.joinHash64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.utils.countVarints=function(e,t,r){for(var o=0,n=t;n<r;n++)o+=e[n]>>7;return r-t-o},jspb.utils.countVarintFields=function(e,t,r,o){var n=0;if(128>(o=8*o+jspb.BinaryConstants.WireType.VARINT))for(;t<r&&e[t++]==o;)for(n++;;){var i=e[t++];if(!(128&i))break}else for(;t<r;){for(i=o;128<i;){if(e[t]!=(127&i|128))return n;t++,i>>=7}if(e[t++]!=i)break;for(n++;128&(i=e[t++]););}return n},jspb.utils.countFixedFields_=function(e,t,r,o,n){var i=0;if(128>o)for(;t<r&&e[t++]==o;)i++,t+=n;else for(;t<r;){for(var a=o;128<a;){if(e[t++]!=(127&a|128))return i;a>>=7}if(e[t++]!=a)break;i++,t+=n}return i},jspb.utils.countFixed32Fields=function(e,t,r,o){return jspb.utils.countFixedFields_(e,t,r,8*o+jspb.BinaryConstants.WireType.FIXED32,4)},jspb.utils.countFixed64Fields=function(e,t,r,o){return jspb.utils.countFixedFields_(e,t,r,8*o+jspb.BinaryConstants.WireType.FIXED64,8)},jspb.utils.countDelimitedFields=function(e,t,r,o){var n=0;for(o=8*o+jspb.BinaryConstants.WireType.DELIMITED;t<r;){for(var i=o;128<i;){if(e[t++]!=(127&i|128))return n;i>>=7}if(e[t++]!=i)break;n++;for(var a=0,s=1;a+=(127&(i=e[t++]))*s,s*=128,128&i;);t+=a}return n},jspb.utils.debugBytesToTextFormat=function(e){var t='"';if(e){e=jspb.utils.byteSourceToUint8Array(e);for(var r=0;r<e.length;r++)t+="\\x",16>e[r]&&(t+="0"),t+=e[r].toString(16)}return t+'"'},jspb.utils.debugScalarToTextFormat=function(e){return"string"==typeof e?goog.string.quote(e):e.toString()},jspb.utils.stringToByteArray=function(e){for(var t=new Uint8Array(e.length),r=0;r<e.length;r++){var o=e.charCodeAt(r);if(255<o)throw Error("Conversion error: string contains codepoint outside of byte range");t[r]=o}return t},jspb.utils.byteSourceToUint8Array=function(e){return e.constructor===Uint8Array?e:e.constructor===ArrayBuffer||e.constructor===Array?new Uint8Array(e):e.constructor===String?goog.crypt.base64.decodeStringToUint8Array(e):e instanceof Uint8Array?new Uint8Array(e.buffer,e.byteOffset,e.byteLength):(jspb.asserts.fail("Type not convertible to Uint8Array."),new Uint8Array(0))},jspb.BinaryDecoder=function(e,t,r){this.bytes_=null,this.cursor_=this.end_=this.start_=0,this.error_=!1,e&&this.setBlock(e,t,r)},jspb.BinaryDecoder.instanceCache_=[],jspb.BinaryDecoder.alloc=function(e,t,r){if(jspb.BinaryDecoder.instanceCache_.length){var o=jspb.BinaryDecoder.instanceCache_.pop();return e&&o.setBlock(e,t,r),o}return new jspb.BinaryDecoder(e,t,r)},jspb.BinaryDecoder.prototype.free=function(){this.clear(),100>jspb.BinaryDecoder.instanceCache_.length&&jspb.BinaryDecoder.instanceCache_.push(this)},jspb.BinaryDecoder.prototype.clone=function(){return jspb.BinaryDecoder.alloc(this.bytes_,this.start_,this.end_-this.start_)},jspb.BinaryDecoder.prototype.clear=function(){this.bytes_=null,this.cursor_=this.end_=this.start_=0,this.error_=!1},jspb.BinaryDecoder.prototype.getBuffer=function(){return this.bytes_},jspb.BinaryDecoder.prototype.setBlock=function(e,t,r){this.bytes_=jspb.utils.byteSourceToUint8Array(e),this.start_=void 0!==t?t:0,this.end_=void 0!==r?this.start_+r:this.bytes_.length,this.cursor_=this.start_},jspb.BinaryDecoder.prototype.getEnd=function(){return this.end_},jspb.BinaryDecoder.prototype.setEnd=function(e){this.end_=e},jspb.BinaryDecoder.prototype.reset=function(){this.cursor_=this.start_},jspb.BinaryDecoder.prototype.getCursor=function(){return this.cursor_},jspb.BinaryDecoder.prototype.setCursor=function(e){this.cursor_=e},jspb.BinaryDecoder.prototype.advance=function(e){this.cursor_+=e,jspb.asserts.assert(this.cursor_<=this.end_)},jspb.BinaryDecoder.prototype.atEnd=function(){return this.cursor_==this.end_},jspb.BinaryDecoder.prototype.pastEnd=function(){return this.cursor_>this.end_},jspb.BinaryDecoder.prototype.getError=function(){return this.error_||0>this.cursor_||this.cursor_>this.end_},jspb.BinaryDecoder.prototype.readSplitVarint64=function(e){for(var t=128,r=0,o=0,n=0;4>n&&128<=t;n++)r|=(127&(t=this.bytes_[this.cursor_++]))<<7*n;if(128<=t&&(r|=(127&(t=this.bytes_[this.cursor_++]))<<28,o|=(127&t)>>4),128<=t)for(n=0;5>n&&128<=t;n++)o|=(127&(t=this.bytes_[this.cursor_++]))<<7*n+3;if(128>t)return e(r>>>0,o>>>0);jspb.asserts.fail("Failed to read varint, encoding is invalid."),this.error_=!0},jspb.BinaryDecoder.prototype.readSplitZigzagVarint64=function(e){return this.readSplitVarint64(function(t,r){return jspb.utils.fromZigzag64(t,r,e)})},jspb.BinaryDecoder.prototype.readSplitFixed64=function(e){var t=this.bytes_,r=this.cursor_;this.cursor_+=8;for(var o=0,n=0,i=r+7;i>=r;i--)o=o<<8|t[i],n=n<<8|t[i+4];return e(o,n)},jspb.BinaryDecoder.prototype.skipVarint=function(){for(;128&this.bytes_[this.cursor_];)this.cursor_++;this.cursor_++},jspb.BinaryDecoder.prototype.unskipVarint=function(e){for(;128<e;)this.cursor_--,e>>>=7;this.cursor_--},jspb.BinaryDecoder.prototype.readUnsignedVarint32=function(){var e=this.bytes_,t=e[this.cursor_+0],r=127&t;return 128>t?(this.cursor_+=1,jspb.asserts.assert(this.cursor_<=this.end_),r):(r|=(127&(t=e[this.cursor_+1]))<<7,128>t?(this.cursor_+=2,jspb.asserts.assert(this.cursor_<=this.end_),r):(r|=(127&(t=e[this.cursor_+2]))<<14,128>t?(this.cursor_+=3,jspb.asserts.assert(this.cursor_<=this.end_),r):(r|=(127&(t=e[this.cursor_+3]))<<21,128>t?(this.cursor_+=4,jspb.asserts.assert(this.cursor_<=this.end_),r):(r|=(15&(t=e[this.cursor_+4]))<<28,128>t?(this.cursor_+=5,jspb.asserts.assert(this.cursor_<=this.end_),r>>>0):(this.cursor_+=5,128<=e[this.cursor_++]&&128<=e[this.cursor_++]&&128<=e[this.cursor_++]&&128<=e[this.cursor_++]&&128<=e[this.cursor_++]&&jspb.asserts.assert(!1),jspb.asserts.assert(this.cursor_<=this.end_),r)))))},jspb.BinaryDecoder.prototype.readSignedVarint32=function(){return~~this.readUnsignedVarint32()},jspb.BinaryDecoder.prototype.readUnsignedVarint32String=function(){return this.readUnsignedVarint32().toString()},jspb.BinaryDecoder.prototype.readSignedVarint32String=function(){return this.readSignedVarint32().toString()},jspb.BinaryDecoder.prototype.readZigzagVarint32=function(){var e=this.readUnsignedVarint32();return e>>>1^-(1&e)},jspb.BinaryDecoder.prototype.readUnsignedVarint64=function(){return this.readSplitVarint64(jspb.utils.joinUint64)},jspb.BinaryDecoder.prototype.readUnsignedVarint64String=function(){return this.readSplitVarint64(jspb.utils.joinUnsignedDecimalString)},jspb.BinaryDecoder.prototype.readSignedVarint64=function(){return this.readSplitVarint64(jspb.utils.joinInt64)},jspb.BinaryDecoder.prototype.readSignedVarint64String=function(){return this.readSplitVarint64(jspb.utils.joinSignedDecimalString)},jspb.BinaryDecoder.prototype.readZigzagVarint64=function(){return this.readSplitVarint64(jspb.utils.joinZigzag64)},jspb.BinaryDecoder.prototype.readZigzagVarintHash64=function(){return this.readSplitZigzagVarint64(jspb.utils.joinHash64)},jspb.BinaryDecoder.prototype.readZigzagVarint64String=function(){return this.readSplitZigzagVarint64(jspb.utils.joinSignedDecimalString)},jspb.BinaryDecoder.prototype.readUint8=function(){var e=this.bytes_[this.cursor_+0];return this.cursor_+=1,jspb.asserts.assert(this.cursor_<=this.end_),e},jspb.BinaryDecoder.prototype.readUint16=function(){var e=this.bytes_[this.cursor_+0],t=this.bytes_[this.cursor_+1];return this.cursor_+=2,jspb.asserts.assert(this.cursor_<=this.end_),e|t<<8},jspb.BinaryDecoder.prototype.readUint32=function(){var e=this.bytes_[this.cursor_+0],t=this.bytes_[this.cursor_+1],r=this.bytes_[this.cursor_+2],o=this.bytes_[this.cursor_+3];return this.cursor_+=4,jspb.asserts.assert(this.cursor_<=this.end_),(e|t<<8|r<<16|o<<24)>>>0},jspb.BinaryDecoder.prototype.readUint64=function(){var e=this.readUint32(),t=this.readUint32();return jspb.utils.joinUint64(e,t)},jspb.BinaryDecoder.prototype.readUint64String=function(){var e=this.readUint32(),t=this.readUint32();return jspb.utils.joinUnsignedDecimalString(e,t)},jspb.BinaryDecoder.prototype.readInt8=function(){var e=this.bytes_[this.cursor_+0];return this.cursor_+=1,jspb.asserts.assert(this.cursor_<=this.end_),e<<24>>24},jspb.BinaryDecoder.prototype.readInt16=function(){var e=this.bytes_[this.cursor_+0],t=this.bytes_[this.cursor_+1];return this.cursor_+=2,jspb.asserts.assert(this.cursor_<=this.end_),(e|t<<8)<<16>>16},jspb.BinaryDecoder.prototype.readInt32=function(){var e=this.bytes_[this.cursor_+0],t=this.bytes_[this.cursor_+1],r=this.bytes_[this.cursor_+2],o=this.bytes_[this.cursor_+3];return this.cursor_+=4,jspb.asserts.assert(this.cursor_<=this.end_),e|t<<8|r<<16|o<<24},jspb.BinaryDecoder.prototype.readInt64=function(){var e=this.readUint32(),t=this.readUint32();return jspb.utils.joinInt64(e,t)},jspb.BinaryDecoder.prototype.readInt64String=function(){var e=this.readUint32(),t=this.readUint32();return jspb.utils.joinSignedDecimalString(e,t)},jspb.BinaryDecoder.prototype.readFloat=function(){var e=this.readUint32();return jspb.utils.joinFloat32(e,0)},jspb.BinaryDecoder.prototype.readDouble=function(){var e=this.readUint32(),t=this.readUint32();return jspb.utils.joinFloat64(e,t)},jspb.BinaryDecoder.prototype.readBool=function(){return!!this.bytes_[this.cursor_++]},jspb.BinaryDecoder.prototype.readEnum=function(){return this.readSignedVarint32()},jspb.BinaryDecoder.prototype.readString=function(e){var t=this.bytes_,r=this.cursor_;e=r+e;for(var o=[],n="";r<e;){var i=t[r++];if(128>i)o.push(i);else{if(192>i)continue;if(224>i){var a=t[r++];o.push((31&i)<<6|63&a)}else if(240>i){a=t[r++];var s=t[r++];o.push((15&i)<<12|(63&a)<<6|63&s)}else 248>i&&(i=(7&i)<<18|(63&(a=t[r++]))<<12|(63&(s=t[r++]))<<6|63&t[r++],i-=65536,o.push(55296+(i>>10&1023),56320+(1023&i)))}8192<=o.length&&(n+=String.fromCharCode.apply(null,o),o.length=0)}return n+=goog.crypt.byteArrayToString(o),this.cursor_=r,n},jspb.BinaryDecoder.prototype.readStringWithLength=function(){var e=this.readUnsignedVarint32();return this.readString(e)},jspb.BinaryDecoder.prototype.readBytes=function(e){if(0>e||this.cursor_+e>this.bytes_.length)return this.error_=!0,jspb.asserts.fail("Invalid byte length!"),new Uint8Array(0);var t=this.bytes_.subarray(this.cursor_,this.cursor_+e);return this.cursor_+=e,jspb.asserts.assert(this.cursor_<=this.end_),t},jspb.BinaryDecoder.prototype.readVarintHash64=function(){return this.readSplitVarint64(jspb.utils.joinHash64)},jspb.BinaryDecoder.prototype.readFixedHash64=function(){var e=this.bytes_,t=this.cursor_,r=e[t+0],o=e[t+1],n=e[t+2],i=e[t+3],a=e[t+4],s=e[t+5],p=e[t+6];return e=e[t+7],this.cursor_+=8,String.fromCharCode(r,o,n,i,a,s,p,e)},jspb.BinaryReader=function(e,t,r){this.decoder_=jspb.BinaryDecoder.alloc(e,t,r),this.fieldCursor_=this.decoder_.getCursor(),this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER,this.nextWireType_=jspb.BinaryConstants.WireType.INVALID,this.error_=!1,this.readCallbacks_=null},jspb.BinaryReader.instanceCache_=[],jspb.BinaryReader.alloc=function(e,t,r){if(jspb.BinaryReader.instanceCache_.length){var o=jspb.BinaryReader.instanceCache_.pop();return e&&o.decoder_.setBlock(e,t,r),o}return new jspb.BinaryReader(e,t,r)},jspb.BinaryReader.prototype.alloc=jspb.BinaryReader.alloc,jspb.BinaryReader.prototype.free=function(){this.decoder_.clear(),this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER,this.nextWireType_=jspb.BinaryConstants.WireType.INVALID,this.error_=!1,this.readCallbacks_=null,100>jspb.BinaryReader.instanceCache_.length&&jspb.BinaryReader.instanceCache_.push(this)},jspb.BinaryReader.prototype.getFieldCursor=function(){return this.fieldCursor_},jspb.BinaryReader.prototype.getCursor=function(){return this.decoder_.getCursor()},jspb.BinaryReader.prototype.getBuffer=function(){return this.decoder_.getBuffer()},jspb.BinaryReader.prototype.getFieldNumber=function(){return this.nextField_},goog.exportProperty(jspb.BinaryReader.prototype,"getFieldNumber",jspb.BinaryReader.prototype.getFieldNumber),jspb.BinaryReader.prototype.getWireType=function(){return this.nextWireType_},jspb.BinaryReader.prototype.isDelimited=function(){return this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED},goog.exportProperty(jspb.BinaryReader.prototype,"isDelimited",jspb.BinaryReader.prototype.isDelimited),jspb.BinaryReader.prototype.isEndGroup=function(){return this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP},goog.exportProperty(jspb.BinaryReader.prototype,"isEndGroup",jspb.BinaryReader.prototype.isEndGroup),jspb.BinaryReader.prototype.getError=function(){return this.error_||this.decoder_.getError()},jspb.BinaryReader.prototype.setBlock=function(e,t,r){this.decoder_.setBlock(e,t,r),this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER,this.nextWireType_=jspb.BinaryConstants.WireType.INVALID},jspb.BinaryReader.prototype.reset=function(){this.decoder_.reset(),this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER,this.nextWireType_=jspb.BinaryConstants.WireType.INVALID},jspb.BinaryReader.prototype.advance=function(e){this.decoder_.advance(e)},jspb.BinaryReader.prototype.nextField=function(){if(this.decoder_.atEnd())return!1;if(this.getError())return jspb.asserts.fail("Decoder hit an error"),!1;this.fieldCursor_=this.decoder_.getCursor();var e=this.decoder_.readUnsignedVarint32(),t=e>>>3;return(e&=7)!=jspb.BinaryConstants.WireType.VARINT&&e!=jspb.BinaryConstants.WireType.FIXED32&&e!=jspb.BinaryConstants.WireType.FIXED64&&e!=jspb.BinaryConstants.WireType.DELIMITED&&e!=jspb.BinaryConstants.WireType.START_GROUP&&e!=jspb.BinaryConstants.WireType.END_GROUP?(jspb.asserts.fail("Invalid wire type: %s (at position %s)",e,this.fieldCursor_),this.error_=!0,!1):(this.nextField_=t,this.nextWireType_=e,!0)},goog.exportProperty(jspb.BinaryReader.prototype,"nextField",jspb.BinaryReader.prototype.nextField),jspb.BinaryReader.prototype.unskipHeader=function(){this.decoder_.unskipVarint(this.nextField_<<3|this.nextWireType_)},jspb.BinaryReader.prototype.skipMatchingFields=function(){var e=this.nextField_;for(this.unskipHeader();this.nextField()&&this.getFieldNumber()==e;)this.skipField();this.decoder_.atEnd()||this.unskipHeader()},jspb.BinaryReader.prototype.skipVarintField=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.VARINT?(jspb.asserts.fail("Invalid wire type for skipVarintField"),this.skipField()):this.decoder_.skipVarint()},jspb.BinaryReader.prototype.skipDelimitedField=function(){if(this.nextWireType_!=jspb.BinaryConstants.WireType.DELIMITED)jspb.asserts.fail("Invalid wire type for skipDelimitedField"),this.skipField();else{var e=this.decoder_.readUnsignedVarint32();this.decoder_.advance(e)}},jspb.BinaryReader.prototype.skipFixed32Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED32?(jspb.asserts.fail("Invalid wire type for skipFixed32Field"),this.skipField()):this.decoder_.advance(4)},jspb.BinaryReader.prototype.skipFixed64Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED64?(jspb.asserts.fail("Invalid wire type for skipFixed64Field"),this.skipField()):this.decoder_.advance(8)},jspb.BinaryReader.prototype.skipGroup=function(){for(var e=this.nextField_;;){if(!this.nextField()){jspb.asserts.fail("Unmatched start-group tag: stream EOF"),this.error_=!0;break}if(this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP){this.nextField_!=e&&(jspb.asserts.fail("Unmatched end-group tag"),this.error_=!0);break}this.skipField()}},jspb.BinaryReader.prototype.skipField=function(){switch(this.nextWireType_){case jspb.BinaryConstants.WireType.VARINT:this.skipVarintField();break;case jspb.BinaryConstants.WireType.FIXED64:this.skipFixed64Field();break;case jspb.BinaryConstants.WireType.DELIMITED:this.skipDelimitedField();break;case jspb.BinaryConstants.WireType.FIXED32:this.skipFixed32Field();break;case jspb.BinaryConstants.WireType.START_GROUP:this.skipGroup();break;default:jspb.asserts.fail("Invalid wire encoding for field.")}},jspb.BinaryReader.prototype.registerReadCallback=function(e,t){null===this.readCallbacks_&&(this.readCallbacks_={}),jspb.asserts.assert(!this.readCallbacks_[e]),this.readCallbacks_[e]=t},jspb.BinaryReader.prototype.runReadCallback=function(e){return jspb.asserts.assert(null!==this.readCallbacks_),e=this.readCallbacks_[e],jspb.asserts.assert(e),e(this)},jspb.BinaryReader.prototype.readAny=function(e){this.nextWireType_=jspb.BinaryConstants.FieldTypeToWireType(e);var t=jspb.BinaryConstants.FieldType;switch(e){case t.DOUBLE:return this.readDouble();case t.FLOAT:return this.readFloat();case t.INT64:return this.readInt64();case t.UINT64:return this.readUint64();case t.INT32:return this.readInt32();case t.FIXED64:return this.readFixed64();case t.FIXED32:return this.readFixed32();case t.BOOL:return this.readBool();case t.STRING:return this.readString();case t.GROUP:jspb.asserts.fail("Group field type not supported in readAny()");case t.MESSAGE:jspb.asserts.fail("Message field type not supported in readAny()");case t.BYTES:return this.readBytes();case t.UINT32:return this.readUint32();case t.ENUM:return this.readEnum();case t.SFIXED32:return this.readSfixed32();case t.SFIXED64:return this.readSfixed64();case t.SINT32:return this.readSint32();case t.SINT64:return this.readSint64();case t.FHASH64:return this.readFixedHash64();case t.VHASH64:return this.readVarintHash64();default:jspb.asserts.fail("Invalid field type in readAny()")}return 0},jspb.BinaryReader.prototype.readMessage=function(e,t){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var r=this.decoder_.getEnd(),o=this.decoder_.readUnsignedVarint32();o=this.decoder_.getCursor()+o,this.decoder_.setEnd(o),t(e,this),this.decoder_.setCursor(o),this.decoder_.setEnd(r)},goog.exportProperty(jspb.BinaryReader.prototype,"readMessage",jspb.BinaryReader.prototype.readMessage),jspb.BinaryReader.prototype.readGroup=function(e,t,r){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.START_GROUP),jspb.asserts.assert(this.nextField_==e),r(t,this),this.error_||this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP||(jspb.asserts.fail("Group submessage did not end with an END_GROUP tag"),this.error_=!0)},goog.exportProperty(jspb.BinaryReader.prototype,"readGroup",jspb.BinaryReader.prototype.readGroup),jspb.BinaryReader.prototype.getFieldDecoder=function(){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var e=this.decoder_.readUnsignedVarint32(),t=this.decoder_.getCursor(),r=t+e;return e=jspb.BinaryDecoder.alloc(this.decoder_.getBuffer(),t,e),this.decoder_.setCursor(r),e},jspb.BinaryReader.prototype.readInt32=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSignedVarint32()},goog.exportProperty(jspb.BinaryReader.prototype,"readInt32",jspb.BinaryReader.prototype.readInt32),jspb.BinaryReader.prototype.readInt32String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSignedVarint32String()},jspb.BinaryReader.prototype.readInt64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSignedVarint64()},goog.exportProperty(jspb.BinaryReader.prototype,"readInt64",jspb.BinaryReader.prototype.readInt64),jspb.BinaryReader.prototype.readInt64String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSignedVarint64String()},jspb.BinaryReader.prototype.readUint32=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readUnsignedVarint32()},goog.exportProperty(jspb.BinaryReader.prototype,"readUint32",jspb.BinaryReader.prototype.readUint32),jspb.BinaryReader.prototype.readUint32String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readUnsignedVarint32String()},jspb.BinaryReader.prototype.readUint64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readUnsignedVarint64()},goog.exportProperty(jspb.BinaryReader.prototype,"readUint64",jspb.BinaryReader.prototype.readUint64),jspb.BinaryReader.prototype.readUint64String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readUnsignedVarint64String()},jspb.BinaryReader.prototype.readSint32=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readZigzagVarint32()},goog.exportProperty(jspb.BinaryReader.prototype,"readSint32",jspb.BinaryReader.prototype.readSint32),jspb.BinaryReader.prototype.readSint64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readZigzagVarint64()},goog.exportProperty(jspb.BinaryReader.prototype,"readSint64",jspb.BinaryReader.prototype.readSint64),jspb.BinaryReader.prototype.readSint64String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readZigzagVarint64String()},jspb.BinaryReader.prototype.readFixed32=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32),this.decoder_.readUint32()},goog.exportProperty(jspb.BinaryReader.prototype,"readFixed32",jspb.BinaryReader.prototype.readFixed32),jspb.BinaryReader.prototype.readFixed64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readUint64()},goog.exportProperty(jspb.BinaryReader.prototype,"readFixed64",jspb.BinaryReader.prototype.readFixed64),jspb.BinaryReader.prototype.readFixed64String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readUint64String()},jspb.BinaryReader.prototype.readSfixed32=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32),this.decoder_.readInt32()},goog.exportProperty(jspb.BinaryReader.prototype,"readSfixed32",jspb.BinaryReader.prototype.readSfixed32),jspb.BinaryReader.prototype.readSfixed32String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32),this.decoder_.readInt32().toString()},jspb.BinaryReader.prototype.readSfixed64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readInt64()},goog.exportProperty(jspb.BinaryReader.prototype,"readSfixed64",jspb.BinaryReader.prototype.readSfixed64),jspb.BinaryReader.prototype.readSfixed64String=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readInt64String()},jspb.BinaryReader.prototype.readFloat=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32),this.decoder_.readFloat()},goog.exportProperty(jspb.BinaryReader.prototype,"readFloat",jspb.BinaryReader.prototype.readFloat),jspb.BinaryReader.prototype.readDouble=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readDouble()},goog.exportProperty(jspb.BinaryReader.prototype,"readDouble",jspb.BinaryReader.prototype.readDouble),jspb.BinaryReader.prototype.readBool=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),!!this.decoder_.readUnsignedVarint32()},goog.exportProperty(jspb.BinaryReader.prototype,"readBool",jspb.BinaryReader.prototype.readBool),jspb.BinaryReader.prototype.readEnum=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSignedVarint64()},goog.exportProperty(jspb.BinaryReader.prototype,"readEnum",jspb.BinaryReader.prototype.readEnum),jspb.BinaryReader.prototype.readString=function(){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var e=this.decoder_.readUnsignedVarint32();return this.decoder_.readString(e)},goog.exportProperty(jspb.BinaryReader.prototype,"readString",jspb.BinaryReader.prototype.readString),jspb.BinaryReader.prototype.readBytes=function(){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var e=this.decoder_.readUnsignedVarint32();return this.decoder_.readBytes(e)},goog.exportProperty(jspb.BinaryReader.prototype,"readBytes",jspb.BinaryReader.prototype.readBytes),jspb.BinaryReader.prototype.readVarintHash64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readVarintHash64()},jspb.BinaryReader.prototype.readSintHash64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readZigzagVarintHash64()},jspb.BinaryReader.prototype.readSplitVarint64=function(e){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSplitVarint64(e)},jspb.BinaryReader.prototype.readSplitZigzagVarint64=function(e){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT),this.decoder_.readSplitVarint64(function(t,r){return jspb.utils.fromZigzag64(t,r,e)})},jspb.BinaryReader.prototype.readFixedHash64=function(){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readFixedHash64()},jspb.BinaryReader.prototype.readSplitFixed64=function(e){return jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64),this.decoder_.readSplitFixed64(e)},jspb.BinaryReader.prototype.readPackedField_=function(e){jspb.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var t=this.decoder_.readUnsignedVarint32();t=this.decoder_.getCursor()+t;for(var r=[];this.decoder_.getCursor()<t;)r.push(e.call(this.decoder_));return r},jspb.BinaryReader.prototype.readPackedInt32=function(){return this.readPackedField_(this.decoder_.readSignedVarint32)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedInt32",jspb.BinaryReader.prototype.readPackedInt32),jspb.BinaryReader.prototype.readPackedInt32String=function(){return this.readPackedField_(this.decoder_.readSignedVarint32String)},jspb.BinaryReader.prototype.readPackedInt64=function(){return this.readPackedField_(this.decoder_.readSignedVarint64)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedInt64",jspb.BinaryReader.prototype.readPackedInt64),jspb.BinaryReader.prototype.readPackedInt64String=function(){return this.readPackedField_(this.decoder_.readSignedVarint64String)},jspb.BinaryReader.prototype.readPackedUint32=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedUint32",jspb.BinaryReader.prototype.readPackedUint32),jspb.BinaryReader.prototype.readPackedUint32String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32String)},jspb.BinaryReader.prototype.readPackedUint64=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedUint64",jspb.BinaryReader.prototype.readPackedUint64),jspb.BinaryReader.prototype.readPackedUint64String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64String)},jspb.BinaryReader.prototype.readPackedSint32=function(){return this.readPackedField_(this.decoder_.readZigzagVarint32)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedSint32",jspb.BinaryReader.prototype.readPackedSint32),jspb.BinaryReader.prototype.readPackedSint64=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedSint64",jspb.BinaryReader.prototype.readPackedSint64),jspb.BinaryReader.prototype.readPackedSint64String=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64String)},jspb.BinaryReader.prototype.readPackedFixed32=function(){return this.readPackedField_(this.decoder_.readUint32)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedFixed32",jspb.BinaryReader.prototype.readPackedFixed32),jspb.BinaryReader.prototype.readPackedFixed64=function(){return this.readPackedField_(this.decoder_.readUint64)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedFixed64",jspb.BinaryReader.prototype.readPackedFixed64),jspb.BinaryReader.prototype.readPackedFixed64String=function(){return this.readPackedField_(this.decoder_.readUint64String)},jspb.BinaryReader.prototype.readPackedSfixed32=function(){return this.readPackedField_(this.decoder_.readInt32)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedSfixed32",jspb.BinaryReader.prototype.readPackedSfixed32),jspb.BinaryReader.prototype.readPackedSfixed64=function(){return this.readPackedField_(this.decoder_.readInt64)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedSfixed64",jspb.BinaryReader.prototype.readPackedSfixed64),jspb.BinaryReader.prototype.readPackedSfixed64String=function(){return this.readPackedField_(this.decoder_.readInt64String)},jspb.BinaryReader.prototype.readPackedFloat=function(){return this.readPackedField_(this.decoder_.readFloat)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedFloat",jspb.BinaryReader.prototype.readPackedFloat),jspb.BinaryReader.prototype.readPackedDouble=function(){return this.readPackedField_(this.decoder_.readDouble)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedDouble",jspb.BinaryReader.prototype.readPackedDouble),jspb.BinaryReader.prototype.readPackedBool=function(){return this.readPackedField_(this.decoder_.readBool)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedBool",jspb.BinaryReader.prototype.readPackedBool),jspb.BinaryReader.prototype.readPackedEnum=function(){return this.readPackedField_(this.decoder_.readEnum)},goog.exportProperty(jspb.BinaryReader.prototype,"readPackedEnum",jspb.BinaryReader.prototype.readPackedEnum),jspb.BinaryReader.prototype.readPackedVarintHash64=function(){return this.readPackedField_(this.decoder_.readVarintHash64)},jspb.BinaryReader.prototype.readPackedFixedHash64=function(){return this.readPackedField_(this.decoder_.readFixedHash64)},jspb.BinaryEncoder=function(){this.buffer_=[]},jspb.BinaryEncoder.prototype.length=function(){return this.buffer_.length},jspb.BinaryEncoder.prototype.end=function(){var e=this.buffer_;return this.buffer_=[],e},jspb.BinaryEncoder.prototype.writeSplitVarint64=function(e,t){for(jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(t==Math.floor(t)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_32),jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_32);0<t||127<e;)this.buffer_.push(127&e|128),e=(e>>>7|t<<25)>>>0,t>>>=7;this.buffer_.push(e)},jspb.BinaryEncoder.prototype.writeSplitFixed64=function(e,t){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(t==Math.floor(t)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_32),jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_32),this.writeUint32(e),this.writeUint32(t)},jspb.BinaryEncoder.prototype.writeUnsignedVarint32=function(e){for(jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_32);127<e;)this.buffer_.push(127&e|128),e>>>=7;this.buffer_.push(e)},jspb.BinaryEncoder.prototype.writeSignedVarint32=function(e){if(jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_31&&e<jspb.BinaryConstants.TWO_TO_31),0<=e)this.writeUnsignedVarint32(e);else{for(var t=0;9>t;t++)this.buffer_.push(127&e|128),e>>=7;this.buffer_.push(1)}},jspb.BinaryEncoder.prototype.writeUnsignedVarint64=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_64),jspb.utils.splitInt64(e),this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeSignedVarint64=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_63&&e<jspb.BinaryConstants.TWO_TO_63),jspb.utils.splitInt64(e),this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeZigzagVarint32=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_31&&e<jspb.BinaryConstants.TWO_TO_31),this.writeUnsignedVarint32((e<<1^e>>31)>>>0)},jspb.BinaryEncoder.prototype.writeZigzagVarint64=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_63&&e<jspb.BinaryConstants.TWO_TO_63),jspb.utils.splitZigzag64(e),this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeZigzagVarint64String=function(e){this.writeZigzagVarintHash64(jspb.utils.decimalStringToHash64(e))},jspb.BinaryEncoder.prototype.writeZigzagVarintHash64=function(e){var t=this;jspb.utils.splitHash64(e),jspb.utils.toZigzag64(jspb.utils.split64Low,jspb.utils.split64High,function(e,r){t.writeSplitVarint64(e>>>0,r>>>0)})},jspb.BinaryEncoder.prototype.writeUint8=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&256>e),this.buffer_.push(e>>>0&255)},jspb.BinaryEncoder.prototype.writeUint16=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&65536>e),this.buffer_.push(e>>>0&255),this.buffer_.push(e>>>8&255)},jspb.BinaryEncoder.prototype.writeUint32=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_32),this.buffer_.push(e>>>0&255),this.buffer_.push(e>>>8&255),this.buffer_.push(e>>>16&255),this.buffer_.push(e>>>24&255)},jspb.BinaryEncoder.prototype.writeUint64=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(0<=e&&e<jspb.BinaryConstants.TWO_TO_64),jspb.utils.splitUint64(e),this.writeUint32(jspb.utils.split64Low),this.writeUint32(jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeInt8=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(-128<=e&&128>e),this.buffer_.push(e>>>0&255)},jspb.BinaryEncoder.prototype.writeInt16=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(-32768<=e&&32768>e),this.buffer_.push(e>>>0&255),this.buffer_.push(e>>>8&255)},jspb.BinaryEncoder.prototype.writeInt32=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_31&&e<jspb.BinaryConstants.TWO_TO_31),this.buffer_.push(e>>>0&255),this.buffer_.push(e>>>8&255),this.buffer_.push(e>>>16&255),this.buffer_.push(e>>>24&255)},jspb.BinaryEncoder.prototype.writeInt64=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_63&&e<jspb.BinaryConstants.TWO_TO_63),jspb.utils.splitInt64(e),this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeInt64String=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(+e>=-jspb.BinaryConstants.TWO_TO_63&&+e<jspb.BinaryConstants.TWO_TO_63),jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e)),this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeFloat=function(e){jspb.asserts.assert(1/0===e||-1/0===e||isNaN(e)||e>=-jspb.BinaryConstants.FLOAT32_MAX&&e<=jspb.BinaryConstants.FLOAT32_MAX),jspb.utils.splitFloat32(e),this.writeUint32(jspb.utils.split64Low)},jspb.BinaryEncoder.prototype.writeDouble=function(e){jspb.asserts.assert(1/0===e||-1/0===e||isNaN(e)||e>=-jspb.BinaryConstants.FLOAT64_MAX&&e<=jspb.BinaryConstants.FLOAT64_MAX),jspb.utils.splitFloat64(e),this.writeUint32(jspb.utils.split64Low),this.writeUint32(jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeBool=function(e){jspb.asserts.assert("boolean"==typeof e||"number"==typeof e),this.buffer_.push(e?1:0)},jspb.BinaryEncoder.prototype.writeEnum=function(e){jspb.asserts.assert(e==Math.floor(e)),jspb.asserts.assert(e>=-jspb.BinaryConstants.TWO_TO_31&&e<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32(e)},jspb.BinaryEncoder.prototype.writeBytes=function(e){this.buffer_.push.apply(this.buffer_,e)},jspb.BinaryEncoder.prototype.writeVarintHash64=function(e){jspb.utils.splitHash64(e),this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeFixedHash64=function(e){jspb.utils.splitHash64(e),this.writeUint32(jspb.utils.split64Low),this.writeUint32(jspb.utils.split64High)},jspb.BinaryEncoder.prototype.writeString=function(e){var t=this.buffer_.length;jspb.asserts.assertString(e);for(var r=0;r<e.length;r++){var o=e.charCodeAt(r);if(128>o)this.buffer_.push(o);else if(2048>o)this.buffer_.push(o>>6|192),this.buffer_.push(63&o|128);else if(65536>o)if(55296<=o&&56319>=o&&r+1<e.length){var n=e.charCodeAt(r+1);56320<=n&&57343>=n&&(o=1024*(o-55296)+n-56320+65536,this.buffer_.push(o>>18|240),this.buffer_.push(o>>12&63|128),this.buffer_.push(o>>6&63|128),this.buffer_.push(63&o|128),r++)}else this.buffer_.push(o>>12|224),this.buffer_.push(o>>6&63|128),this.buffer_.push(63&o|128)}return this.buffer_.length-t},jspb.arith={},jspb.arith.UInt64=function(e,t){this.lo=e,this.hi=t},jspb.arith.UInt64.prototype.cmp=function(e){return this.hi<e.hi||this.hi==e.hi&&this.lo<e.lo?-1:this.hi==e.hi&&this.lo==e.lo?0:1},jspb.arith.UInt64.prototype.rightShift=function(){return new jspb.arith.UInt64((this.lo>>>1|(1&this.hi)<<31)>>>0,this.hi>>>1>>>0)},jspb.arith.UInt64.prototype.leftShift=function(){return new jspb.arith.UInt64(this.lo<<1>>>0,(this.hi<<1|this.lo>>>31)>>>0)},jspb.arith.UInt64.prototype.msb=function(){return!!(2147483648&this.hi)},jspb.arith.UInt64.prototype.lsb=function(){return!!(1&this.lo)},jspb.arith.UInt64.prototype.zero=function(){return 0==this.lo&&0==this.hi},jspb.arith.UInt64.prototype.add=function(e){return new jspb.arith.UInt64((this.lo+e.lo&4294967295)>>>0>>>0,((this.hi+e.hi&4294967295)>>>0)+(4294967296<=this.lo+e.lo?1:0)>>>0)},jspb.arith.UInt64.prototype.sub=function(e){return new jspb.arith.UInt64((this.lo-e.lo&4294967295)>>>0>>>0,((this.hi-e.hi&4294967295)>>>0)-(0>this.lo-e.lo?1:0)>>>0)},jspb.arith.UInt64.mul32x32=function(e,t){var r=65535&e,o=65535&t,n=t>>>16;for(t=r*o+65536*(r*n&65535)+65536*((e>>>=16)*o&65535),r=e*n+(r*n>>>16)+(e*o>>>16);4294967296<=t;)t-=4294967296,r+=1;return new jspb.arith.UInt64(t>>>0,r>>>0)},jspb.arith.UInt64.prototype.mul=function(e){var t=jspb.arith.UInt64.mul32x32(this.lo,e);return(e=jspb.arith.UInt64.mul32x32(this.hi,e)).hi=e.lo,e.lo=0,t.add(e)},jspb.arith.UInt64.prototype.div=function(e){if(0==e)return[];var t=new jspb.arith.UInt64(0,0),r=new jspb.arith.UInt64(this.lo,this.hi);e=new jspb.arith.UInt64(e,0);for(var o=new jspb.arith.UInt64(1,0);!e.msb();)e=e.leftShift(),o=o.leftShift();for(;!o.zero();)0>=e.cmp(r)&&(t=t.add(o),r=r.sub(e)),e=e.rightShift(),o=o.rightShift();return[t,r]},jspb.arith.UInt64.prototype.toString=function(){for(var e="",t=this;!t.zero();){var r=(t=t.div(10))[0];e=t[1].lo+e,t=r}return""==e&&(e="0"),e},jspb.arith.UInt64.fromString=function(e){for(var t=new jspb.arith.UInt64(0,0),r=new jspb.arith.UInt64(0,0),o=0;o<e.length;o++){if("0">e[o]||"9"<e[o])return null;var n=parseInt(e[o],10);r.lo=n,t=t.mul(10).add(r)}return t},jspb.arith.UInt64.prototype.clone=function(){return new jspb.arith.UInt64(this.lo,this.hi)},jspb.arith.Int64=function(e,t){this.lo=e,this.hi=t},jspb.arith.Int64.prototype.add=function(e){return new jspb.arith.Int64((this.lo+e.lo&4294967295)>>>0>>>0,((this.hi+e.hi&4294967295)>>>0)+(4294967296<=this.lo+e.lo?1:0)>>>0)},jspb.arith.Int64.prototype.sub=function(e){return new jspb.arith.Int64((this.lo-e.lo&4294967295)>>>0>>>0,((this.hi-e.hi&4294967295)>>>0)-(0>this.lo-e.lo?1:0)>>>0)},jspb.arith.Int64.prototype.clone=function(){return new jspb.arith.Int64(this.lo,this.hi)},jspb.arith.Int64.prototype.toString=function(){var e=!!(2147483648&this.hi),t=new jspb.arith.UInt64(this.lo,this.hi);return e&&(t=new jspb.arith.UInt64(0,0).sub(t)),(e?"-":"")+t.toString()},jspb.arith.Int64.fromString=function(e){var t=0<e.length&&"-"==e[0];return t&&(e=e.substring(1)),null===(e=jspb.arith.UInt64.fromString(e))?null:(t&&(e=new jspb.arith.UInt64(0,0).sub(e)),new jspb.arith.Int64(e.lo,e.hi))},jspb.BinaryWriter=function(){this.blocks_=[],this.totalLength_=0,this.encoder_=new jspb.BinaryEncoder,this.bookmarks_=[]},jspb.BinaryWriter.prototype.appendUint8Array_=function(e){var t=this.encoder_.end();this.blocks_.push(t),this.blocks_.push(e),this.totalLength_+=t.length+e.length},jspb.BinaryWriter.prototype.beginDelimited_=function(e){return this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),e=this.encoder_.end(),this.blocks_.push(e),this.totalLength_+=e.length,e.push(this.totalLength_),e},jspb.BinaryWriter.prototype.endDelimited_=function(e){var t=e.pop();for(t=this.totalLength_+this.encoder_.length()-t,jspb.asserts.assert(0<=t);127<t;)e.push(127&t|128),t>>>=7,this.totalLength_++;e.push(t),this.totalLength_++},jspb.BinaryWriter.prototype.writeSerializedMessage=function(e,t,r){this.appendUint8Array_(e.subarray(t,r))},jspb.BinaryWriter.prototype.maybeWriteSerializedMessage=function(e,t,r){null!=e&&null!=t&&null!=r&&this.writeSerializedMessage(e,t,r)},jspb.BinaryWriter.prototype.reset=function(){this.blocks_=[],this.encoder_.end(),this.totalLength_=0,this.bookmarks_=[]},jspb.BinaryWriter.prototype.getResultBuffer=function(){jspb.asserts.assert(0==this.bookmarks_.length);for(var e=new Uint8Array(this.totalLength_+this.encoder_.length()),t=this.blocks_,r=t.length,o=0,n=0;n<r;n++){var i=t[n];e.set(i,o),o+=i.length}return t=this.encoder_.end(),e.set(t,o),o+=t.length,jspb.asserts.assert(o==e.length),this.blocks_=[e],e},goog.exportProperty(jspb.BinaryWriter.prototype,"getResultBuffer",jspb.BinaryWriter.prototype.getResultBuffer),jspb.BinaryWriter.prototype.getResultBase64String=function(e){return goog.crypt.base64.encodeByteArray(this.getResultBuffer(),e)},jspb.BinaryWriter.prototype.beginSubMessage=function(e){this.bookmarks_.push(this.beginDelimited_(e))},jspb.BinaryWriter.prototype.endSubMessage=function(){jspb.asserts.assert(0<=this.bookmarks_.length),this.endDelimited_(this.bookmarks_.pop())},jspb.BinaryWriter.prototype.writeFieldHeader_=function(e,t){jspb.asserts.assert(1<=e&&e==Math.floor(e)),this.encoder_.writeUnsignedVarint32(8*e+t)},jspb.BinaryWriter.prototype.writeAny=function(e,t,r){var o=jspb.BinaryConstants.FieldType;switch(e){case o.DOUBLE:this.writeDouble(t,r);break;case o.FLOAT:this.writeFloat(t,r);break;case o.INT64:this.writeInt64(t,r);break;case o.UINT64:this.writeUint64(t,r);break;case o.INT32:this.writeInt32(t,r);break;case o.FIXED64:this.writeFixed64(t,r);break;case o.FIXED32:this.writeFixed32(t,r);break;case o.BOOL:this.writeBool(t,r);break;case o.STRING:this.writeString(t,r);break;case o.GROUP:jspb.asserts.fail("Group field type not supported in writeAny()");break;case o.MESSAGE:jspb.asserts.fail("Message field type not supported in writeAny()");break;case o.BYTES:this.writeBytes(t,r);break;case o.UINT32:this.writeUint32(t,r);break;case o.ENUM:this.writeEnum(t,r);break;case o.SFIXED32:this.writeSfixed32(t,r);break;case o.SFIXED64:this.writeSfixed64(t,r);break;case o.SINT32:this.writeSint32(t,r);break;case o.SINT64:this.writeSint64(t,r);break;case o.FHASH64:this.writeFixedHash64(t,r);break;case o.VHASH64:this.writeVarintHash64(t,r);break;default:jspb.asserts.fail("Invalid field type in writeAny()")}},jspb.BinaryWriter.prototype.writeUnsignedVarint32_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint32(t))},jspb.BinaryWriter.prototype.writeSignedVarint32_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(t))},jspb.BinaryWriter.prototype.writeUnsignedVarint64_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint64(t))},jspb.BinaryWriter.prototype.writeSignedVarint64_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint64(t))},jspb.BinaryWriter.prototype.writeZigzagVarint32_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint32(t))},jspb.BinaryWriter.prototype.writeZigzagVarint64_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64(t))},jspb.BinaryWriter.prototype.writeZigzagVarint64String_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64String(t))},jspb.BinaryWriter.prototype.writeZigzagVarintHash64_=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarintHash64(t))},jspb.BinaryWriter.prototype.writeInt32=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_31&&t<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeInt32",jspb.BinaryWriter.prototype.writeInt32),jspb.BinaryWriter.prototype.writeInt32String=function(e,t){null!=t&&(t=parseInt(t,10),jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_31&&t<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(e,t))},jspb.BinaryWriter.prototype.writeInt64=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_63&&t<jspb.BinaryConstants.TWO_TO_63),this.writeSignedVarint64_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeInt64",jspb.BinaryWriter.prototype.writeInt64),jspb.BinaryWriter.prototype.writeInt64String=function(e,t){null!=t&&(t=jspb.arith.Int64.fromString(t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(t.lo,t.hi))},jspb.BinaryWriter.prototype.writeUint32=function(e,t){null!=t&&(jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeUint32",jspb.BinaryWriter.prototype.writeUint32),jspb.BinaryWriter.prototype.writeUint32String=function(e,t){null!=t&&(t=parseInt(t,10),jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(e,t))},jspb.BinaryWriter.prototype.writeUint64=function(e,t){null!=t&&(jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_64),this.writeUnsignedVarint64_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeUint64",jspb.BinaryWriter.prototype.writeUint64),jspb.BinaryWriter.prototype.writeUint64String=function(e,t){null!=t&&(t=jspb.arith.UInt64.fromString(t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(t.lo,t.hi))},jspb.BinaryWriter.prototype.writeSint32=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_31&&t<jspb.BinaryConstants.TWO_TO_31),this.writeZigzagVarint32_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeSint32",jspb.BinaryWriter.prototype.writeSint32),jspb.BinaryWriter.prototype.writeSint64=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_63&&t<jspb.BinaryConstants.TWO_TO_63),this.writeZigzagVarint64_(e,t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeSint64",jspb.BinaryWriter.prototype.writeSint64),jspb.BinaryWriter.prototype.writeSintHash64=function(e,t){null!=t&&this.writeZigzagVarintHash64_(e,t)},jspb.BinaryWriter.prototype.writeSint64String=function(e,t){null!=t&&this.writeZigzagVarint64String_(e,t)},jspb.BinaryWriter.prototype.writeFixed32=function(e,t){null!=t&&(jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_32),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeUint32(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeFixed32",jspb.BinaryWriter.prototype.writeFixed32),jspb.BinaryWriter.prototype.writeFixed64=function(e,t){null!=t&&(jspb.asserts.assert(0<=t&&t<jspb.BinaryConstants.TWO_TO_64),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeUint64(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeFixed64",jspb.BinaryWriter.prototype.writeFixed64),jspb.BinaryWriter.prototype.writeFixed64String=function(e,t){null!=t&&(t=jspb.arith.UInt64.fromString(t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(t.lo,t.hi))},jspb.BinaryWriter.prototype.writeSfixed32=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_31&&t<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeInt32(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeSfixed32",jspb.BinaryWriter.prototype.writeSfixed32),jspb.BinaryWriter.prototype.writeSfixed64=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_63&&t<jspb.BinaryConstants.TWO_TO_63),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeInt64(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeSfixed64",jspb.BinaryWriter.prototype.writeSfixed64),jspb.BinaryWriter.prototype.writeSfixed64String=function(e,t){null!=t&&(t=jspb.arith.Int64.fromString(t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(t.lo,t.hi))},jspb.BinaryWriter.prototype.writeFloat=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeFloat(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeFloat",jspb.BinaryWriter.prototype.writeFloat),jspb.BinaryWriter.prototype.writeDouble=function(e,t){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeDouble(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeDouble",jspb.BinaryWriter.prototype.writeDouble),jspb.BinaryWriter.prototype.writeBool=function(e,t){null!=t&&(jspb.asserts.assert("boolean"==typeof t||"number"==typeof t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeBool(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeBool",jspb.BinaryWriter.prototype.writeBool),jspb.BinaryWriter.prototype.writeEnum=function(e,t){null!=t&&(jspb.asserts.assert(t>=-jspb.BinaryConstants.TWO_TO_31&&t<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeEnum",jspb.BinaryWriter.prototype.writeEnum),jspb.BinaryWriter.prototype.writeString=function(e,t){null!=t&&(e=this.beginDelimited_(e),this.encoder_.writeString(t),this.endDelimited_(e))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeString",jspb.BinaryWriter.prototype.writeString),jspb.BinaryWriter.prototype.writeBytes=function(e,t){null!=t&&(t=jspb.utils.byteSourceToUint8Array(t),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(t.length),this.appendUint8Array_(t))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeBytes",jspb.BinaryWriter.prototype.writeBytes),jspb.BinaryWriter.prototype.writeMessage=function(e,t,r){null!=t&&(e=this.beginDelimited_(e),r(t,this),this.endDelimited_(e))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeMessage",jspb.BinaryWriter.prototype.writeMessage),jspb.BinaryWriter.prototype.writeMessageSet=function(e,t,r){null!=t&&(this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.START_GROUP),this.writeFieldHeader_(2,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(e),e=this.beginDelimited_(3),r(t,this),this.endDelimited_(e),this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.END_GROUP))},jspb.BinaryWriter.prototype.writeGroup=function(e,t,r){null!=t&&(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.START_GROUP),r(t,this),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.END_GROUP))},goog.exportProperty(jspb.BinaryWriter.prototype,"writeGroup",jspb.BinaryWriter.prototype.writeGroup),jspb.BinaryWriter.prototype.writeFixedHash64=function(e,t){null!=t&&(jspb.asserts.assert(8==t.length),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeFixedHash64(t))},jspb.BinaryWriter.prototype.writeVarintHash64=function(e,t){null!=t&&(jspb.asserts.assert(8==t.length),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeVarintHash64(t))},jspb.BinaryWriter.prototype.writeSplitFixed64=function(e,t,r){this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(t,r)},jspb.BinaryWriter.prototype.writeSplitVarint64=function(e,t,r){this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(t,r)},jspb.BinaryWriter.prototype.writeSplitZigzagVarint64=function(e,t,r){this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.VARINT);var o=this.encoder_;jspb.utils.toZigzag64(t,r,function(e,t){o.writeSplitVarint64(e>>>0,t>>>0)})},jspb.BinaryWriter.prototype.writeRepeatedInt32=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeSignedVarint32_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedInt32",jspb.BinaryWriter.prototype.writeRepeatedInt32),jspb.BinaryWriter.prototype.writeRepeatedInt32String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeInt32String(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedInt64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeSignedVarint64_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedInt64",jspb.BinaryWriter.prototype.writeRepeatedInt64),jspb.BinaryWriter.prototype.writeRepeatedSplitFixed64=function(e,t,r,o){if(null!=t)for(var n=0;n<t.length;n++)this.writeSplitFixed64(e,r(t[n]),o(t[n]))},jspb.BinaryWriter.prototype.writeRepeatedSplitVarint64=function(e,t,r,o){if(null!=t)for(var n=0;n<t.length;n++)this.writeSplitVarint64(e,r(t[n]),o(t[n]))},jspb.BinaryWriter.prototype.writeRepeatedSplitZigzagVarint64=function(e,t,r,o){if(null!=t)for(var n=0;n<t.length;n++)this.writeSplitZigzagVarint64(e,r(t[n]),o(t[n]))},jspb.BinaryWriter.prototype.writeRepeatedInt64String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeInt64String(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedUint32=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeUnsignedVarint32_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedUint32",jspb.BinaryWriter.prototype.writeRepeatedUint32),jspb.BinaryWriter.prototype.writeRepeatedUint32String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeUint32String(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedUint64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeUnsignedVarint64_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedUint64",jspb.BinaryWriter.prototype.writeRepeatedUint64),jspb.BinaryWriter.prototype.writeRepeatedUint64String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeUint64String(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedSint32=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeZigzagVarint32_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedSint32",jspb.BinaryWriter.prototype.writeRepeatedSint32),jspb.BinaryWriter.prototype.writeRepeatedSint64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeZigzagVarint64_(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedSint64",jspb.BinaryWriter.prototype.writeRepeatedSint64),jspb.BinaryWriter.prototype.writeRepeatedSint64String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeZigzagVarint64String_(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedSintHash64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeZigzagVarintHash64_(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedFixed32=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeFixed32(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedFixed32",jspb.BinaryWriter.prototype.writeRepeatedFixed32),jspb.BinaryWriter.prototype.writeRepeatedFixed64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeFixed64(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedFixed64",jspb.BinaryWriter.prototype.writeRepeatedFixed64),jspb.BinaryWriter.prototype.writeRepeatedFixed64String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeFixed64String(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedFixed64String",jspb.BinaryWriter.prototype.writeRepeatedFixed64String),jspb.BinaryWriter.prototype.writeRepeatedSfixed32=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeSfixed32(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedSfixed32",jspb.BinaryWriter.prototype.writeRepeatedSfixed32),jspb.BinaryWriter.prototype.writeRepeatedSfixed64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeSfixed64(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedSfixed64",jspb.BinaryWriter.prototype.writeRepeatedSfixed64),jspb.BinaryWriter.prototype.writeRepeatedSfixed64String=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeSfixed64String(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedFloat=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeFloat(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedFloat",jspb.BinaryWriter.prototype.writeRepeatedFloat),jspb.BinaryWriter.prototype.writeRepeatedDouble=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeDouble(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedDouble",jspb.BinaryWriter.prototype.writeRepeatedDouble),jspb.BinaryWriter.prototype.writeRepeatedBool=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeBool(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedBool",jspb.BinaryWriter.prototype.writeRepeatedBool),jspb.BinaryWriter.prototype.writeRepeatedEnum=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeEnum(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedEnum",jspb.BinaryWriter.prototype.writeRepeatedEnum),jspb.BinaryWriter.prototype.writeRepeatedString=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeString(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedString",jspb.BinaryWriter.prototype.writeRepeatedString),jspb.BinaryWriter.prototype.writeRepeatedBytes=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeBytes(e,t[r])},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedBytes",jspb.BinaryWriter.prototype.writeRepeatedBytes),jspb.BinaryWriter.prototype.writeRepeatedMessage=function(e,t,r){if(null!=t)for(var o=0;o<t.length;o++){var n=this.beginDelimited_(e);r(t[o],this),this.endDelimited_(n)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedMessage",jspb.BinaryWriter.prototype.writeRepeatedMessage),jspb.BinaryWriter.prototype.writeRepeatedGroup=function(e,t,r){if(null!=t)for(var o=0;o<t.length;o++)this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.START_GROUP),r(t[o],this),this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.END_GROUP)},goog.exportProperty(jspb.BinaryWriter.prototype,"writeRepeatedGroup",jspb.BinaryWriter.prototype.writeRepeatedGroup),jspb.BinaryWriter.prototype.writeRepeatedFixedHash64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeFixedHash64(e,t[r])},jspb.BinaryWriter.prototype.writeRepeatedVarintHash64=function(e,t){if(null!=t)for(var r=0;r<t.length;r++)this.writeVarintHash64(e,t[r])},jspb.BinaryWriter.prototype.writePackedInt32=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeSignedVarint32(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedInt32",jspb.BinaryWriter.prototype.writePackedInt32),jspb.BinaryWriter.prototype.writePackedInt32String=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeSignedVarint32(parseInt(t[r],10));this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedInt64=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeSignedVarint64(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedInt64",jspb.BinaryWriter.prototype.writePackedInt64),jspb.BinaryWriter.prototype.writePackedSplitFixed64=function(e,t,r,o){if(null!=t){e=this.beginDelimited_(e);for(var n=0;n<t.length;n++)this.encoder_.writeSplitFixed64(r(t[n]),o(t[n]));this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedSplitVarint64=function(e,t,r,o){if(null!=t){e=this.beginDelimited_(e);for(var n=0;n<t.length;n++)this.encoder_.writeSplitVarint64(r(t[n]),o(t[n]));this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedSplitZigzagVarint64=function(e,t,r,o){if(null!=t){e=this.beginDelimited_(e);for(var n=this.encoder_,i=0;i<t.length;i++)jspb.utils.toZigzag64(r(t[i]),o(t[i]),function(e,t){n.writeSplitVarint64(e>>>0,t>>>0)});this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedInt64String=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++){var o=jspb.arith.Int64.fromString(t[r]);this.encoder_.writeSplitVarint64(o.lo,o.hi)}this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedUint32=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeUnsignedVarint32(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedUint32",jspb.BinaryWriter.prototype.writePackedUint32),jspb.BinaryWriter.prototype.writePackedUint32String=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeUnsignedVarint32(parseInt(t[r],10));this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedUint64=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeUnsignedVarint64(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedUint64",jspb.BinaryWriter.prototype.writePackedUint64),jspb.BinaryWriter.prototype.writePackedUint64String=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++){var o=jspb.arith.UInt64.fromString(t[r]);this.encoder_.writeSplitVarint64(o.lo,o.hi)}this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedSint32=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeZigzagVarint32(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedSint32",jspb.BinaryWriter.prototype.writePackedSint32),jspb.BinaryWriter.prototype.writePackedSint64=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeZigzagVarint64(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedSint64",jspb.BinaryWriter.prototype.writePackedSint64),jspb.BinaryWriter.prototype.writePackedSint64String=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeZigzagVarintHash64(jspb.utils.decimalStringToHash64(t[r]));this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedSintHash64=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeZigzagVarintHash64(t[r]);this.endDelimited_(e)}},jspb.BinaryWriter.prototype.writePackedFixed32=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*t.length),e=0;e<t.length;e++)this.encoder_.writeUint32(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedFixed32",jspb.BinaryWriter.prototype.writePackedFixed32),jspb.BinaryWriter.prototype.writePackedFixed64=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++)this.encoder_.writeUint64(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedFixed64",jspb.BinaryWriter.prototype.writePackedFixed64),jspb.BinaryWriter.prototype.writePackedFixed64String=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++){var r=jspb.arith.UInt64.fromString(t[e]);this.encoder_.writeSplitFixed64(r.lo,r.hi)}},jspb.BinaryWriter.prototype.writePackedSfixed32=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*t.length),e=0;e<t.length;e++)this.encoder_.writeInt32(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedSfixed32",jspb.BinaryWriter.prototype.writePackedSfixed32),jspb.BinaryWriter.prototype.writePackedSfixed64=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++)this.encoder_.writeInt64(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedSfixed64",jspb.BinaryWriter.prototype.writePackedSfixed64),jspb.BinaryWriter.prototype.writePackedSfixed64String=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++)this.encoder_.writeInt64String(t[e])},jspb.BinaryWriter.prototype.writePackedFloat=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*t.length),e=0;e<t.length;e++)this.encoder_.writeFloat(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedFloat",jspb.BinaryWriter.prototype.writePackedFloat),jspb.BinaryWriter.prototype.writePackedDouble=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++)this.encoder_.writeDouble(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedDouble",jspb.BinaryWriter.prototype.writePackedDouble),jspb.BinaryWriter.prototype.writePackedBool=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(t.length),e=0;e<t.length;e++)this.encoder_.writeBool(t[e])},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedBool",jspb.BinaryWriter.prototype.writePackedBool),jspb.BinaryWriter.prototype.writePackedEnum=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeEnum(t[r]);this.endDelimited_(e)}},goog.exportProperty(jspb.BinaryWriter.prototype,"writePackedEnum",jspb.BinaryWriter.prototype.writePackedEnum),jspb.BinaryWriter.prototype.writePackedFixedHash64=function(e,t){if(null!=t&&t.length)for(this.writeFieldHeader_(e,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*t.length),e=0;e<t.length;e++)this.encoder_.writeFixedHash64(t[e])},jspb.BinaryWriter.prototype.writePackedVarintHash64=function(e,t){if(null!=t&&t.length){e=this.beginDelimited_(e);for(var r=0;r<t.length;r++)this.encoder_.writeVarintHash64(t[r]);this.endDelimited_(e)}},jspb.Map=function(e,t){this.arr_=e,this.valueCtor_=t,this.map_={},this.arrClean=!0,0<this.arr_.length&&this.loadFromArray_()},goog.exportSymbol("jspb.Map",jspb.Map),jspb.Map.prototype.loadFromArray_=function(){for(var e=0;e<this.arr_.length;e++){var t=this.arr_[e],r=t[0];this.map_[r.toString()]=new jspb.Map.Entry_(r,t[1])}this.arrClean=!0},jspb.Map.prototype.toArray=function(){if(this.arrClean){if(this.valueCtor_){var e,t=this.map_;for(e in t)if(Object.prototype.hasOwnProperty.call(t,e)){var r=t[e].valueWrapper;r&&r.toArray()}}}else{for(this.arr_.length=0,(t=this.stringKeys_()).sort(),e=0;e<t.length;e++){var o=this.map_[t[e]];(r=o.valueWrapper)&&r.toArray(),this.arr_.push([o.key,o.value])}this.arrClean=!0}return this.arr_},goog.exportProperty(jspb.Map.prototype,"toArray",jspb.Map.prototype.toArray),jspb.Map.prototype.toObject=function(e,t){for(var r=this.toArray(),o=[],n=0;n<r.length;n++){var i=this.map_[r[n][0].toString()];this.wrapEntry_(i);var a=i.valueWrapper;a?(jspb.asserts.assert(t),o.push([i.key,t(e,a)])):o.push([i.key,i.value])}return o},goog.exportProperty(jspb.Map.prototype,"toObject",jspb.Map.prototype.toObject),jspb.Map.fromObject=function(e,t,r){t=new jspb.Map([],t);for(var o=0;o<e.length;o++){var n=e[o][0],i=r(e[o][1]);t.set(n,i)}return t},goog.exportProperty(jspb.Map,"fromObject",jspb.Map.fromObject),jspb.Map.ArrayIteratorIterable_=function(e){this.idx_=0,this.arr_=e},jspb.Map.ArrayIteratorIterable_.prototype.next=function(){return this.idx_<this.arr_.length?{done:!1,value:this.arr_[this.idx_++]}:{done:!0,value:void 0}},"undefined"!=typeof Symbol&&(jspb.Map.ArrayIteratorIterable_.prototype[Symbol.iterator]=function(){return this}),jspb.Map.prototype.getLength=function(){return this.stringKeys_().length},goog.exportProperty(jspb.Map.prototype,"getLength",jspb.Map.prototype.getLength),jspb.Map.prototype.clear=function(){this.map_={},this.arrClean=!1},goog.exportProperty(jspb.Map.prototype,"clear",jspb.Map.prototype.clear),jspb.Map.prototype.del=function(e){e=e.toString();var t=this.map_.hasOwnProperty(e);return delete this.map_[e],this.arrClean=!1,t},goog.exportProperty(jspb.Map.prototype,"del",jspb.Map.prototype.del),jspb.Map.prototype.getEntryList=function(){var e=[],t=this.stringKeys_();t.sort();for(var r=0;r<t.length;r++){var o=this.map_[t[r]];e.push([o.key,o.value])}return e},goog.exportProperty(jspb.Map.prototype,"getEntryList",jspb.Map.prototype.getEntryList),jspb.Map.prototype.entries=function(){var e=[],t=this.stringKeys_();t.sort();for(var r=0;r<t.length;r++){var o=this.map_[t[r]];e.push([o.key,this.wrapEntry_(o)])}return new jspb.Map.ArrayIteratorIterable_(e)},goog.exportProperty(jspb.Map.prototype,"entries",jspb.Map.prototype.entries),jspb.Map.prototype.keys=function(){var e=[],t=this.stringKeys_();t.sort();for(var r=0;r<t.length;r++)e.push(this.map_[t[r]].key);return new jspb.Map.ArrayIteratorIterable_(e)},goog.exportProperty(jspb.Map.prototype,"keys",jspb.Map.prototype.keys),jspb.Map.prototype.values=function(){var e=[],t=this.stringKeys_();t.sort();for(var r=0;r<t.length;r++)e.push(this.wrapEntry_(this.map_[t[r]]));return new jspb.Map.ArrayIteratorIterable_(e)},goog.exportProperty(jspb.Map.prototype,"values",jspb.Map.prototype.values),jspb.Map.prototype.forEach=function(e,t){var r=this.stringKeys_();r.sort();for(var o=0;o<r.length;o++){var n=this.map_[r[o]];e.call(t,this.wrapEntry_(n),n.key,this)}},goog.exportProperty(jspb.Map.prototype,"forEach",jspb.Map.prototype.forEach),jspb.Map.prototype.set=function(e,t){var r=new jspb.Map.Entry_(e);return this.valueCtor_?(r.valueWrapper=t,r.value=t.toArray()):r.value=t,this.map_[e.toString()]=r,this.arrClean=!1,this},goog.exportProperty(jspb.Map.prototype,"set",jspb.Map.prototype.set),jspb.Map.prototype.wrapEntry_=function(e){return this.valueCtor_?(e.valueWrapper||(e.valueWrapper=new this.valueCtor_(e.value)),e.valueWrapper):e.value},jspb.Map.prototype.get=function(e){if(e=this.map_[e.toString()])return this.wrapEntry_(e)},goog.exportProperty(jspb.Map.prototype,"get",jspb.Map.prototype.get),jspb.Map.prototype.has=function(e){return e.toString()in this.map_},goog.exportProperty(jspb.Map.prototype,"has",jspb.Map.prototype.has),jspb.Map.prototype.serializeBinary=function(e,t,r,o,n){var i=this.stringKeys_();i.sort();for(var a=0;a<i.length;a++){var s=this.map_[i[a]];t.beginSubMessage(e),r.call(t,1,s.key),this.valueCtor_?o.call(t,2,this.wrapEntry_(s),n):o.call(t,2,s.value),t.endSubMessage()}},goog.exportProperty(jspb.Map.prototype,"serializeBinary",jspb.Map.prototype.serializeBinary),jspb.Map.deserializeBinary=function(e,t,r,o,n,i,a){for(;t.nextField()&&!t.isEndGroup();){var s=t.getFieldNumber();1==s?i=r.call(t):2==s&&(e.valueCtor_?(jspb.asserts.assert(n),a||(a=new e.valueCtor_),o.call(t,a,n)):a=o.call(t))}jspb.asserts.assert(null!=i),jspb.asserts.assert(null!=a),e.set(i,a)},goog.exportProperty(jspb.Map,"deserializeBinary",jspb.Map.deserializeBinary),jspb.Map.prototype.stringKeys_=function(){var e,t=this.map_,r=[];for(e in t)Object.prototype.hasOwnProperty.call(t,e)&&r.push(e);return r},jspb.Map.Entry_=function(e,t){this.key=e,this.value=t,this.valueWrapper=void 0},jspb.ExtensionFieldInfo=function(e,t,r,o,n){this.fieldIndex=e,this.fieldName=t,this.ctor=r,this.toObjectFn=o,this.isRepeated=n},goog.exportSymbol("jspb.ExtensionFieldInfo",jspb.ExtensionFieldInfo),jspb.ExtensionFieldBinaryInfo=function(e,t,r,o,n,i){this.fieldInfo=e,this.binaryReaderFn=t,this.binaryWriterFn=r,this.binaryMessageSerializeFn=o,this.binaryMessageDeserializeFn=n,this.isPacked=i},goog.exportSymbol("jspb.ExtensionFieldBinaryInfo",jspb.ExtensionFieldBinaryInfo),jspb.ExtensionFieldInfo.prototype.isMessageType=function(){return!!this.ctor},goog.exportProperty(jspb.ExtensionFieldInfo.prototype,"isMessageType",jspb.ExtensionFieldInfo.prototype.isMessageType),jspb.Message=function(){},goog.exportSymbol("jspb.Message",jspb.Message),jspb.Message.GENERATE_TO_OBJECT=!0,goog.exportProperty(jspb.Message,"GENERATE_TO_OBJECT",jspb.Message.GENERATE_TO_OBJECT),jspb.Message.GENERATE_FROM_OBJECT=!goog.DISALLOW_TEST_ONLY_CODE,goog.exportProperty(jspb.Message,"GENERATE_FROM_OBJECT",jspb.Message.GENERATE_FROM_OBJECT),jspb.Message.GENERATE_TO_STRING=!0,jspb.Message.ASSUME_LOCAL_ARRAYS=!1,jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS=!0,jspb.Message.SUPPORTS_UINT8ARRAY_="function"==typeof Uint8Array,jspb.Message.prototype.getJsPbMessageId=function(){return this.messageId_},goog.exportProperty(jspb.Message.prototype,"getJsPbMessageId",jspb.Message.prototype.getJsPbMessageId),jspb.Message.getIndex_=function(e,t){return t+e.arrayIndexOffset_},jspb.Message.hiddenES6Property_=function(){},jspb.Message.getFieldNumber_=function(e,t){return t-e.arrayIndexOffset_},jspb.Message.initialize=function(e,t,r,o,n,i){if(e.wrappers_=null,t||(t=r?[r]:[]),e.messageId_=r?String(r):void 0,e.arrayIndexOffset_=0===r?-1:0,e.array=t,jspb.Message.initPivotAndExtensionObject_(e,o),e.convertedPrimitiveFields_={},jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS||(e.repeatedFields=n),n)for(t=0;t<n.length;t++)(r=n[t])<e.pivot_?(r=jspb.Message.getIndex_(e,r),e.array[r]=e.array[r]||jspb.Message.EMPTY_LIST_SENTINEL_):(jspb.Message.maybeInitEmptyExtensionObject_(e),e.extensionObject_[r]=e.extensionObject_[r]||jspb.Message.EMPTY_LIST_SENTINEL_);if(i&&i.length)for(t=0;t<i.length;t++)jspb.Message.computeOneofCase(e,i[t])},goog.exportProperty(jspb.Message,"initialize",jspb.Message.initialize),jspb.Message.EMPTY_LIST_SENTINEL_=goog.DEBUG&&Object.freeze?Object.freeze([]):[],jspb.Message.isArray_=function(e){return jspb.Message.ASSUME_LOCAL_ARRAYS?e instanceof Array:Array.isArray(e)},jspb.Message.isExtensionObject_=function(e){return!(null===e||"object"!=typeof e||jspb.Message.isArray_(e)||jspb.Message.SUPPORTS_UINT8ARRAY_&&e instanceof Uint8Array)},jspb.Message.initPivotAndExtensionObject_=function(e,t){var r=e.array.length,o=-1;if(r&&(o=r-1,r=e.array[o],jspb.Message.isExtensionObject_(r)))return e.pivot_=jspb.Message.getFieldNumber_(e,o),void(e.extensionObject_=r);-1<t?(e.pivot_=Math.max(t,jspb.Message.getFieldNumber_(e,o+1)),e.extensionObject_=null):e.pivot_=Number.MAX_VALUE},jspb.Message.maybeInitEmptyExtensionObject_=function(e){var t=jspb.Message.getIndex_(e,e.pivot_);e.array[t]||(e.extensionObject_=e.array[t]={})},jspb.Message.toObjectList=function(e,t,r){for(var o=[],n=0;n<e.length;n++)o[n]=t.call(e[n],r,e[n]);return o},goog.exportProperty(jspb.Message,"toObjectList",jspb.Message.toObjectList),jspb.Message.toObjectExtension=function(e,t,r,o,n){for(var i in r){var a=r[i],s=o.call(e,a);if(null!=s){for(var p in a.fieldName)if(a.fieldName.hasOwnProperty(p))break;t[p]=a.toObjectFn?a.isRepeated?jspb.Message.toObjectList(s,a.toObjectFn,n):a.toObjectFn(n,s):s}}},goog.exportProperty(jspb.Message,"toObjectExtension",jspb.Message.toObjectExtension),jspb.Message.serializeBinaryExtensions=function(e,t,r,o){for(var n in r){var i=r[n],a=i.fieldInfo;if(!i.binaryWriterFn)throw Error("Message extension present that was generated without binary serialization support");var s=o.call(e,a);if(null!=s)if(a.isMessageType()){if(!i.binaryMessageSerializeFn)throw Error("Message extension present holding submessage without binary support enabled, and message is being serialized to binary format");i.binaryWriterFn.call(t,a.fieldIndex,s,i.binaryMessageSerializeFn)}else i.binaryWriterFn.call(t,a.fieldIndex,s)}},goog.exportProperty(jspb.Message,"serializeBinaryExtensions",jspb.Message.serializeBinaryExtensions),jspb.Message.readBinaryExtension=function(e,t,r,o,n){var i=r[t.getFieldNumber()];if(i){if(r=i.fieldInfo,!i.binaryReaderFn)throw Error("Deserializing extension whose generated code does not support binary format");if(r.isMessageType()){var a=new r.ctor;i.binaryReaderFn.call(t,a,i.binaryMessageDeserializeFn)}else a=i.binaryReaderFn.call(t);r.isRepeated&&!i.isPacked?(t=o.call(e,r))?t.push(a):n.call(e,r,[a]):n.call(e,r,a)}else t.skipField()},goog.exportProperty(jspb.Message,"readBinaryExtension",jspb.Message.readBinaryExtension),jspb.Message.getField=function(e,t){if(t<e.pivot_){t=jspb.Message.getIndex_(e,t);var r=e.array[t];return r===jspb.Message.EMPTY_LIST_SENTINEL_?e.array[t]=[]:r}if(e.extensionObject_)return(r=e.extensionObject_[t])===jspb.Message.EMPTY_LIST_SENTINEL_?e.extensionObject_[t]=[]:r},goog.exportProperty(jspb.Message,"getField",jspb.Message.getField),jspb.Message.getRepeatedField=function(e,t){return jspb.Message.getField(e,t)},goog.exportProperty(jspb.Message,"getRepeatedField",jspb.Message.getRepeatedField),jspb.Message.getOptionalFloatingPointField=function(e,t){return null==(e=jspb.Message.getField(e,t))?e:+e},goog.exportProperty(jspb.Message,"getOptionalFloatingPointField",jspb.Message.getOptionalFloatingPointField),jspb.Message.getBooleanField=function(e,t){return null==(e=jspb.Message.getField(e,t))?e:!!e},goog.exportProperty(jspb.Message,"getBooleanField",jspb.Message.getBooleanField),jspb.Message.getRepeatedFloatingPointField=function(e,t){var r=jspb.Message.getRepeatedField(e,t);if(e.convertedPrimitiveFields_||(e.convertedPrimitiveFields_={}),!e.convertedPrimitiveFields_[t]){for(var o=0;o<r.length;o++)r[o]=+r[o];e.convertedPrimitiveFields_[t]=!0}return r},goog.exportProperty(jspb.Message,"getRepeatedFloatingPointField",jspb.Message.getRepeatedFloatingPointField),jspb.Message.getRepeatedBooleanField=function(e,t){var r=jspb.Message.getRepeatedField(e,t);if(e.convertedPrimitiveFields_||(e.convertedPrimitiveFields_={}),!e.convertedPrimitiveFields_[t]){for(var o=0;o<r.length;o++)r[o]=!!r[o];e.convertedPrimitiveFields_[t]=!0}return r},goog.exportProperty(jspb.Message,"getRepeatedBooleanField",jspb.Message.getRepeatedBooleanField),jspb.Message.bytesAsB64=function(e){return null==e||"string"==typeof e?e:jspb.Message.SUPPORTS_UINT8ARRAY_&&e instanceof Uint8Array?goog.crypt.base64.encodeByteArray(e):(jspb.asserts.fail("Cannot coerce to b64 string: "+goog.typeOf(e)),null)},goog.exportProperty(jspb.Message,"bytesAsB64",jspb.Message.bytesAsB64),jspb.Message.bytesAsU8=function(e){return null==e||e instanceof Uint8Array?e:"string"==typeof e?goog.crypt.base64.decodeStringToUint8Array(e):(jspb.asserts.fail("Cannot coerce to Uint8Array: "+goog.typeOf(e)),null)},goog.exportProperty(jspb.Message,"bytesAsU8",jspb.Message.bytesAsU8),jspb.Message.bytesListAsB64=function(e){return jspb.Message.assertConsistentTypes_(e),e.length&&"string"!=typeof e[0]?goog.array.map(e,jspb.Message.bytesAsB64):e},goog.exportProperty(jspb.Message,"bytesListAsB64",jspb.Message.bytesListAsB64),jspb.Message.bytesListAsU8=function(e){return jspb.Message.assertConsistentTypes_(e),!e.length||e[0]instanceof Uint8Array?e:goog.array.map(e,jspb.Message.bytesAsU8)},goog.exportProperty(jspb.Message,"bytesListAsU8",jspb.Message.bytesListAsU8),jspb.Message.assertConsistentTypes_=function(e){if(goog.DEBUG&&e&&1<e.length){var t=goog.typeOf(e[0]);goog.array.forEach(e,function(e){goog.typeOf(e)!=t&&jspb.asserts.fail("Inconsistent type in JSPB repeated field array. Got "+goog.typeOf(e)+" expected "+t)})}},jspb.Message.getFieldWithDefault=function(e,t,r){return null==(e=jspb.Message.getField(e,t))?r:e},goog.exportProperty(jspb.Message,"getFieldWithDefault",jspb.Message.getFieldWithDefault),jspb.Message.getBooleanFieldWithDefault=function(e,t,r){return null==(e=jspb.Message.getBooleanField(e,t))?r:e},goog.exportProperty(jspb.Message,"getBooleanFieldWithDefault",jspb.Message.getBooleanFieldWithDefault),jspb.Message.getFloatingPointFieldWithDefault=function(e,t,r){return null==(e=jspb.Message.getOptionalFloatingPointField(e,t))?r:e},goog.exportProperty(jspb.Message,"getFloatingPointFieldWithDefault",jspb.Message.getFloatingPointFieldWithDefault),jspb.Message.getFieldProto3=jspb.Message.getFieldWithDefault,goog.exportProperty(jspb.Message,"getFieldProto3",jspb.Message.getFieldProto3),jspb.Message.getMapField=function(e,t,r,o){if(e.wrappers_||(e.wrappers_={}),t in e.wrappers_)return e.wrappers_[t];var n=jspb.Message.getField(e,t);if(!n){if(r)return;n=[],jspb.Message.setField(e,t,n)}return e.wrappers_[t]=new jspb.Map(n,o)},goog.exportProperty(jspb.Message,"getMapField",jspb.Message.getMapField),jspb.Message.setField=function(e,t,r){return jspb.asserts.assertInstanceof(e,jspb.Message),t<e.pivot_?e.array[jspb.Message.getIndex_(e,t)]=r:(jspb.Message.maybeInitEmptyExtensionObject_(e),e.extensionObject_[t]=r),e},goog.exportProperty(jspb.Message,"setField",jspb.Message.setField),jspb.Message.setProto3IntField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,0)},goog.exportProperty(jspb.Message,"setProto3IntField",jspb.Message.setProto3IntField),jspb.Message.setProto3FloatField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,0)},goog.exportProperty(jspb.Message,"setProto3FloatField",jspb.Message.setProto3FloatField),jspb.Message.setProto3BooleanField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,!1)},goog.exportProperty(jspb.Message,"setProto3BooleanField",jspb.Message.setProto3BooleanField),jspb.Message.setProto3StringField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,"")},goog.exportProperty(jspb.Message,"setProto3StringField",jspb.Message.setProto3StringField),jspb.Message.setProto3BytesField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,"")},goog.exportProperty(jspb.Message,"setProto3BytesField",jspb.Message.setProto3BytesField),jspb.Message.setProto3EnumField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,0)},goog.exportProperty(jspb.Message,"setProto3EnumField",jspb.Message.setProto3EnumField),jspb.Message.setProto3StringIntField=function(e,t,r){return jspb.Message.setFieldIgnoringDefault_(e,t,r,"0")},goog.exportProperty(jspb.Message,"setProto3StringIntField",jspb.Message.setProto3StringIntField),jspb.Message.setFieldIgnoringDefault_=function(e,t,r,o){return jspb.asserts.assertInstanceof(e,jspb.Message),r!==o?jspb.Message.setField(e,t,r):t<e.pivot_?e.array[jspb.Message.getIndex_(e,t)]=null:(jspb.Message.maybeInitEmptyExtensionObject_(e),delete e.extensionObject_[t]),e},jspb.Message.addToRepeatedField=function(e,t,r,o){return jspb.asserts.assertInstanceof(e,jspb.Message),t=jspb.Message.getRepeatedField(e,t),null!=o?t.splice(o,0,r):t.push(r),e},goog.exportProperty(jspb.Message,"addToRepeatedField",jspb.Message.addToRepeatedField),jspb.Message.setOneofField=function(e,t,r,o){return jspb.asserts.assertInstanceof(e,jspb.Message),(r=jspb.Message.computeOneofCase(e,r))&&r!==t&&void 0!==o&&(e.wrappers_&&r in e.wrappers_&&(e.wrappers_[r]=void 0),jspb.Message.setField(e,r,void 0)),jspb.Message.setField(e,t,o)},goog.exportProperty(jspb.Message,"setOneofField",jspb.Message.setOneofField),jspb.Message.computeOneofCase=function(e,t){for(var r,o,n=0;n<t.length;n++){var i=t[n],a=jspb.Message.getField(e,i);null!=a&&(r=i,o=a,jspb.Message.setField(e,i,void 0))}return r?(jspb.Message.setField(e,r,o),r):0},goog.exportProperty(jspb.Message,"computeOneofCase",jspb.Message.computeOneofCase),jspb.Message.getWrapperField=function(e,t,r,o){if(e.wrappers_||(e.wrappers_={}),!e.wrappers_[r]){var n=jspb.Message.getField(e,r);(o||n)&&(e.wrappers_[r]=new t(n))}return e.wrappers_[r]},goog.exportProperty(jspb.Message,"getWrapperField",jspb.Message.getWrapperField),jspb.Message.getRepeatedWrapperField=function(e,t,r){return jspb.Message.wrapRepeatedField_(e,t,r),(t=e.wrappers_[r])==jspb.Message.EMPTY_LIST_SENTINEL_&&(t=e.wrappers_[r]=[]),t},goog.exportProperty(jspb.Message,"getRepeatedWrapperField",jspb.Message.getRepeatedWrapperField),jspb.Message.wrapRepeatedField_=function(e,t,r){if(e.wrappers_||(e.wrappers_={}),!e.wrappers_[r]){for(var o=jspb.Message.getRepeatedField(e,r),n=[],i=0;i<o.length;i++)n[i]=new t(o[i]);e.wrappers_[r]=n}},jspb.Message.setWrapperField=function(e,t,r){jspb.asserts.assertInstanceof(e,jspb.Message),e.wrappers_||(e.wrappers_={});var o=r?r.toArray():r;return e.wrappers_[t]=r,jspb.Message.setField(e,t,o)},goog.exportProperty(jspb.Message,"setWrapperField",jspb.Message.setWrapperField),jspb.Message.setOneofWrapperField=function(e,t,r,o){jspb.asserts.assertInstanceof(e,jspb.Message),e.wrappers_||(e.wrappers_={});var n=o?o.toArray():o;return e.wrappers_[t]=o,jspb.Message.setOneofField(e,t,r,n)},goog.exportProperty(jspb.Message,"setOneofWrapperField",jspb.Message.setOneofWrapperField),jspb.Message.setRepeatedWrapperField=function(e,t,r){jspb.asserts.assertInstanceof(e,jspb.Message),e.wrappers_||(e.wrappers_={}),r=r||[];for(var o=[],n=0;n<r.length;n++)o[n]=r[n].toArray();return e.wrappers_[t]=r,jspb.Message.setField(e,t,o)},goog.exportProperty(jspb.Message,"setRepeatedWrapperField",jspb.Message.setRepeatedWrapperField),jspb.Message.addToRepeatedWrapperField=function(e,t,r,o,n){jspb.Message.wrapRepeatedField_(e,o,t);var i=e.wrappers_[t];return i||(i=e.wrappers_[t]=[]),r=r||new o,e=jspb.Message.getRepeatedField(e,t),null!=n?(i.splice(n,0,r),e.splice(n,0,r.toArray())):(i.push(r),e.push(r.toArray())),r},goog.exportProperty(jspb.Message,"addToRepeatedWrapperField",jspb.Message.addToRepeatedWrapperField),jspb.Message.toMap=function(e,t,r,o){for(var n={},i=0;i<e.length;i++)n[t.call(e[i])]=r?r.call(e[i],o,e[i]):e[i];return n},goog.exportProperty(jspb.Message,"toMap",jspb.Message.toMap),jspb.Message.prototype.syncMapFields_=function(){if(this.wrappers_)for(var e in this.wrappers_){var t=this.wrappers_[e];if(Array.isArray(t))for(var r=0;r<t.length;r++)t[r]&&t[r].toArray();else t&&t.toArray()}},jspb.Message.prototype.toArray=function(){return this.syncMapFields_(),this.array},goog.exportProperty(jspb.Message.prototype,"toArray",jspb.Message.prototype.toArray),jspb.Message.GENERATE_TO_STRING&&(jspb.Message.prototype.toString=function(){return this.syncMapFields_(),this.array.toString()}),jspb.Message.prototype.getExtension=function(e){if(this.extensionObject_){this.wrappers_||(this.wrappers_={});var t=e.fieldIndex;if(e.isRepeated){if(e.isMessageType())return this.wrappers_[t]||(this.wrappers_[t]=goog.array.map(this.extensionObject_[t]||[],function(t){return new e.ctor(t)})),this.wrappers_[t]}else if(e.isMessageType())return!this.wrappers_[t]&&this.extensionObject_[t]&&(this.wrappers_[t]=new e.ctor(this.extensionObject_[t])),this.wrappers_[t];return this.extensionObject_[t]}},goog.exportProperty(jspb.Message.prototype,"getExtension",jspb.Message.prototype.getExtension),jspb.Message.prototype.setExtension=function(e,t){this.wrappers_||(this.wrappers_={}),jspb.Message.maybeInitEmptyExtensionObject_(this);var r=e.fieldIndex;return e.isRepeated?(t=t||[],e.isMessageType()?(this.wrappers_[r]=t,this.extensionObject_[r]=goog.array.map(t,function(e){return e.toArray()})):this.extensionObject_[r]=t):e.isMessageType()?(this.wrappers_[r]=t,this.extensionObject_[r]=t?t.toArray():t):this.extensionObject_[r]=t,this},goog.exportProperty(jspb.Message.prototype,"setExtension",jspb.Message.prototype.setExtension),jspb.Message.difference=function(e,t){if(!(e instanceof t.constructor))throw Error("Messages have different types.");var r=e.toArray();t=t.toArray();var o=[],n=0,i=r.length>t.length?r.length:t.length;for(e.getJsPbMessageId()&&(o[0]=e.getJsPbMessageId(),n=1);n<i;n++)jspb.Message.compareFields(r[n],t[n])||(o[n]=t[n]);return new e.constructor(o)},goog.exportProperty(jspb.Message,"difference",jspb.Message.difference),jspb.Message.equals=function(e,t){return e==t||!(!e||!t)&&e instanceof t.constructor&&jspb.Message.compareFields(e.toArray(),t.toArray())},goog.exportProperty(jspb.Message,"equals",jspb.Message.equals),jspb.Message.compareExtensions=function(e,t){e=e||{},t=t||{};var r,o={};for(r in e)o[r]=0;for(r in t)o[r]=0;for(r in o)if(!jspb.Message.compareFields(e[r],t[r]))return!1;return!0},goog.exportProperty(jspb.Message,"compareExtensions",jspb.Message.compareExtensions),jspb.Message.compareFields=function(e,t){if(e==t)return!0;if(!goog.isObject(e)||!goog.isObject(t))return!!("number"==typeof e&&isNaN(e)||"number"==typeof t&&isNaN(t))&&String(e)==String(t);if(e.constructor!=t.constructor)return!1;if(jspb.Message.SUPPORTS_UINT8ARRAY_&&e.constructor===Uint8Array){if(e.length!=t.length)return!1;for(var r=0;r<e.length;r++)if(e[r]!=t[r])return!1;return!0}if(e.constructor===Array){var o=void 0,n=void 0,i=Math.max(e.length,t.length);for(r=0;r<i;r++){var a=e[r],s=t[r];if(a&&a.constructor==Object&&(jspb.asserts.assert(void 0===o),jspb.asserts.assert(r===e.length-1),o=a,a=void 0),s&&s.constructor==Object&&(jspb.asserts.assert(void 0===n),jspb.asserts.assert(r===t.length-1),n=s,s=void 0),!jspb.Message.compareFields(a,s))return!1}return!o&&!n||(o=o||{},n=n||{},jspb.Message.compareExtensions(o,n))}if(e.constructor===Object)return jspb.Message.compareExtensions(e,t);throw Error("Invalid type in JSPB array")},goog.exportProperty(jspb.Message,"compareFields",jspb.Message.compareFields),jspb.Message.prototype.cloneMessage=function(){return jspb.Message.cloneMessage(this)},goog.exportProperty(jspb.Message.prototype,"cloneMessage",jspb.Message.prototype.cloneMessage),jspb.Message.prototype.clone=function(){return jspb.Message.cloneMessage(this)},goog.exportProperty(jspb.Message.prototype,"clone",jspb.Message.prototype.clone),jspb.Message.clone=function(e){return jspb.Message.cloneMessage(e)},goog.exportProperty(jspb.Message,"clone",jspb.Message.clone),jspb.Message.cloneMessage=function(e){return new e.constructor(jspb.Message.clone_(e.toArray()))},jspb.Message.copyInto=function(e,t){jspb.asserts.assertInstanceof(e,jspb.Message),jspb.asserts.assertInstanceof(t,jspb.Message),jspb.asserts.assert(e.constructor==t.constructor,"Copy source and target message should have the same type."),e=jspb.Message.clone(e);for(var r=t.toArray(),o=e.toArray(),n=r.length=0;n<o.length;n++)r[n]=o[n];t.wrappers_=e.wrappers_,t.extensionObject_=e.extensionObject_},goog.exportProperty(jspb.Message,"copyInto",jspb.Message.copyInto),jspb.Message.clone_=function(e){if(Array.isArray(e)){for(var t=Array(e.length),r=0;r<e.length;r++){var o=e[r];null!=o&&(t[r]="object"==typeof o?jspb.Message.clone_(jspb.asserts.assert(o)):o)}return t}if(jspb.Message.SUPPORTS_UINT8ARRAY_&&e instanceof Uint8Array)return new Uint8Array(e);for(r in t={},e)null!=(o=e[r])&&(t[r]="object"==typeof o?jspb.Message.clone_(jspb.asserts.assert(o)):o);return t},jspb.Message.registerMessageType=function(e,t){t.messageId=e},goog.exportProperty(jspb.Message,"registerMessageType",jspb.Message.registerMessageType),jspb.Message.messageSetExtensions={},jspb.Message.messageSetExtensionsBinary={},jspb.Export={},exports.Map=jspb.Map,exports.Message=jspb.Message,exports.BinaryReader=jspb.BinaryReader,exports.BinaryWriter=jspb.BinaryWriter,exports.ExtensionFieldInfo=jspb.ExtensionFieldInfo,exports.ExtensionFieldBinaryInfo=jspb.ExtensionFieldBinaryInfo,exports.exportSymbol=goog.exportSymbol,exports.inherits=goog.inherits,exports.object={extend:goog.object.extend},exports.typeOf=goog.typeOf})(googleProtobuf);var calculator_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.CalculatorOptions",null,o),proto.mediapipe.CalculatorOptions=function(e){t.Message.initialize(this,e,0,2,null,null)},r.inherits(proto.mediapipe.CalculatorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.CalculatorOptions.displayName="proto.mediapipe.CalculatorOptions"),proto.mediapipe.CalculatorOptions.extensions={},proto.mediapipe.CalculatorOptions.extensionsBinary={},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.CalculatorOptions.prototype.toObject=function(e){return proto.mediapipe.CalculatorOptions.toObject(e,this)},proto.mediapipe.CalculatorOptions.toObject=function(e,r){var o,n={mergeFields:null==(o=t.Message.getBooleanField(r,1))?void 0:o};return t.Message.toObjectExtension(r,n,proto.mediapipe.CalculatorOptions.extensions,proto.mediapipe.CalculatorOptions.prototype.getExtension,e),e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.CalculatorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.CalculatorOptions;return proto.mediapipe.CalculatorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.CalculatorOptions.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)if(1===r.getFieldNumber()){var o=r.readBool();e.setMergeFields(o)}else t.Message.readBinaryExtension(e,r,proto.mediapipe.CalculatorOptions.extensionsBinary,proto.mediapipe.CalculatorOptions.prototype.getExtension,proto.mediapipe.CalculatorOptions.prototype.setExtension);return e},proto.mediapipe.CalculatorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.CalculatorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.CalculatorOptions.serializeBinaryToWriter=function(e,r){var o;null!=(o=t.Message.getField(e,1))&&r.writeBool(1,o),t.Message.serializeBinaryExtensions(e,r,proto.mediapipe.CalculatorOptions.extensionsBinary,proto.mediapipe.CalculatorOptions.prototype.getExtension)},proto.mediapipe.CalculatorOptions.prototype.getMergeFields=function(){return t.Message.getBooleanFieldWithDefault(this,1,!1)},proto.mediapipe.CalculatorOptions.prototype.setMergeFields=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.CalculatorOptions.prototype.clearMergeFields=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.CalculatorOptions.prototype.hasMergeFields=function(){return null!=t.Message.getField(this,1)},r.object.extend(e,proto.mediapipe)}(calculator_options_pb);var any_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.google.protobuf.Any",null,o),proto.google.protobuf.Any=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.google.protobuf.Any,t.Message),r.DEBUG&&!COMPILED&&(proto.google.protobuf.Any.displayName="proto.google.protobuf.Any"),t.Message.GENERATE_TO_OBJECT&&(proto.google.protobuf.Any.prototype.toObject=function(e){return proto.google.protobuf.Any.toObject(e,this)},proto.google.protobuf.Any.toObject=function(e,r){var o={typeUrl:t.Message.getFieldWithDefault(r,1,""),value:r.getValue_asB64()};return e&&(o.$jspbMessageInstance=r),o}),proto.google.protobuf.Any.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.google.protobuf.Any;return proto.google.protobuf.Any.deserializeBinaryFromReader(o,r)},proto.google.protobuf.Any.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setTypeUrl(r);break;case 2:r=t.readBytes(),e.setValue(r);break;default:t.skipField()}return e},proto.google.protobuf.Any.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.google.protobuf.Any.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.google.protobuf.Any.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getTypeUrl()).length>0&&t.writeString(1,r),(r=e.getValue_asU8()).length>0&&t.writeBytes(2,r)},proto.google.protobuf.Any.prototype.getTypeUrl=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.google.protobuf.Any.prototype.setTypeUrl=function(e){return t.Message.setProto3StringField(this,1,e)},proto.google.protobuf.Any.prototype.getValue=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.google.protobuf.Any.prototype.getValue_asB64=function(){return t.Message.bytesAsB64(this.getValue())},proto.google.protobuf.Any.prototype.getValue_asU8=function(){return t.Message.bytesAsU8(this.getValue())},proto.google.protobuf.Any.prototype.setValue=function(e){return t.Message.setProto3BytesField(this,2,e)},r.object.extend(e,proto.google.protobuf),proto.google.protobuf.Any.prototype.getTypeName=function(){return this.getTypeUrl().split("/").pop()},proto.google.protobuf.Any.prototype.pack=function(e,t,r){r||(r="type.googleapis.com/"),"/"!=r.substr(-1)?this.setTypeUrl(r+"/"+t):this.setTypeUrl(r+t),this.setValue(e)},proto.google.protobuf.Any.prototype.unpack=function(e,t){return this.getTypeName()==t?e(this.getValue_asU8()):null}}(any_pb);var mediapipe_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.MediaPipeOptions",null,o),proto.mediapipe.MediaPipeOptions=function(e){t.Message.initialize(this,e,0,1,null,null)},r.inherits(proto.mediapipe.MediaPipeOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.MediaPipeOptions.displayName="proto.mediapipe.MediaPipeOptions"),proto.mediapipe.MediaPipeOptions.extensions={},proto.mediapipe.MediaPipeOptions.extensionsBinary={},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.MediaPipeOptions.prototype.toObject=function(e){return proto.mediapipe.MediaPipeOptions.toObject(e,this)},proto.mediapipe.MediaPipeOptions.toObject=function(e,r){var o={};return t.Message.toObjectExtension(r,o,proto.mediapipe.MediaPipeOptions.extensions,proto.mediapipe.MediaPipeOptions.prototype.getExtension,e),e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.MediaPipeOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.MediaPipeOptions;return proto.mediapipe.MediaPipeOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.MediaPipeOptions.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)r.getFieldNumber(),t.Message.readBinaryExtension(e,r,proto.mediapipe.MediaPipeOptions.extensionsBinary,proto.mediapipe.MediaPipeOptions.prototype.getExtension,proto.mediapipe.MediaPipeOptions.prototype.setExtension);return e},proto.mediapipe.MediaPipeOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.MediaPipeOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.MediaPipeOptions.serializeBinaryToWriter=function(e,r){t.Message.serializeBinaryExtensions(e,r,proto.mediapipe.MediaPipeOptions.extensionsBinary,proto.mediapipe.MediaPipeOptions.prototype.getExtension)},r.object.extend(e,proto.mediapipe)}(mediapipe_options_pb);var packet_factory_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.PacketFactoryConfig",null,o),r.exportSymbol("proto.mediapipe.PacketFactoryOptions",null,o),r.exportSymbol("proto.mediapipe.PacketManagerConfig",null,o),proto.mediapipe.PacketFactoryOptions=function(e){t.Message.initialize(this,e,0,1,null,null)},r.inherits(proto.mediapipe.PacketFactoryOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.PacketFactoryOptions.displayName="proto.mediapipe.PacketFactoryOptions"),proto.mediapipe.PacketFactoryOptions.extensions={},proto.mediapipe.PacketFactoryOptions.extensionsBinary={},proto.mediapipe.PacketFactoryConfig=function(e){t.Message.initialize(this,e,0,500,null,null)},r.inherits(proto.mediapipe.PacketFactoryConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.PacketFactoryConfig.displayName="proto.mediapipe.PacketFactoryConfig"),proto.mediapipe.PacketManagerConfig=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.PacketManagerConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.PacketManagerConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.PacketManagerConfig.displayName="proto.mediapipe.PacketManagerConfig"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.PacketFactoryOptions.prototype.toObject=function(e){return proto.mediapipe.PacketFactoryOptions.toObject(e,this)},proto.mediapipe.PacketFactoryOptions.toObject=function(e,r){var o={};return t.Message.toObjectExtension(r,o,proto.mediapipe.PacketFactoryOptions.extensions,proto.mediapipe.PacketFactoryOptions.prototype.getExtension,e),e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.PacketFactoryOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.PacketFactoryOptions;return proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)r.getFieldNumber(),t.Message.readBinaryExtension(e,r,proto.mediapipe.PacketFactoryOptions.extensionsBinary,proto.mediapipe.PacketFactoryOptions.prototype.getExtension,proto.mediapipe.PacketFactoryOptions.prototype.setExtension);return e},proto.mediapipe.PacketFactoryOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter=function(e,r){t.Message.serializeBinaryExtensions(e,r,proto.mediapipe.PacketFactoryOptions.extensionsBinary,proto.mediapipe.PacketFactoryOptions.prototype.getExtension)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.PacketFactoryConfig.prototype.toObject=function(e){return proto.mediapipe.PacketFactoryConfig.toObject(e,this)},proto.mediapipe.PacketFactoryConfig.toObject=function(e,r){var o,n={packetFactory:null==(o=t.Message.getField(r,1))?void 0:o,outputSidePacket:null==(o=t.Message.getField(r,2))?void 0:o,externalOutput:null==(o=t.Message.getField(r,1002))?void 0:o,options:(o=r.getOptions())&&proto.mediapipe.PacketFactoryOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.PacketFactoryConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.PacketFactoryConfig;return proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setPacketFactory(r);break;case 2:r=t.readString(),e.setOutputSidePacket(r);break;case 1002:r=t.readString(),e.setExternalOutput(r);break;case 3:r=new proto.mediapipe.PacketFactoryOptions,t.readMessage(r,proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.PacketFactoryConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=t.Message.getField(e,1002))&&r.writeString(1002,o),null!=(o=e.getOptions())&&r.writeMessage(3,o,proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter)},proto.mediapipe.PacketFactoryConfig.prototype.getPacketFactory=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.PacketFactoryConfig.prototype.setPacketFactory=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.PacketFactoryConfig.prototype.clearPacketFactory=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.PacketFactoryConfig.prototype.hasPacketFactory=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.PacketFactoryConfig.prototype.getOutputSidePacket=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.PacketFactoryConfig.prototype.setOutputSidePacket=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.PacketFactoryConfig.prototype.clearOutputSidePacket=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.PacketFactoryConfig.prototype.hasOutputSidePacket=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.PacketFactoryConfig.prototype.getExternalOutput=function(){return t.Message.getFieldWithDefault(this,1002,"")},proto.mediapipe.PacketFactoryConfig.prototype.setExternalOutput=function(e){return t.Message.setField(this,1002,e)},proto.mediapipe.PacketFactoryConfig.prototype.clearExternalOutput=function(){return t.Message.setField(this,1002,void 0)},proto.mediapipe.PacketFactoryConfig.prototype.hasExternalOutput=function(){return null!=t.Message.getField(this,1002)},proto.mediapipe.PacketFactoryConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,proto.mediapipe.PacketFactoryOptions,3)},proto.mediapipe.PacketFactoryConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.PacketFactoryConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.PacketFactoryConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.PacketManagerConfig.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.PacketManagerConfig.prototype.toObject=function(e){return proto.mediapipe.PacketManagerConfig.toObject(e,this)},proto.mediapipe.PacketManagerConfig.toObject=function(e,r){var o={packetList:t.Message.toObjectList(r.getPacketList(),proto.mediapipe.PacketFactoryConfig.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.PacketManagerConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.PacketManagerConfig;return proto.mediapipe.PacketManagerConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.PacketManagerConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.PacketFactoryConfig;t.readMessage(r,proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader),e.addPacket(r)}else t.skipField();return e},proto.mediapipe.PacketManagerConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.PacketManagerConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.PacketManagerConfig.serializeBinaryToWriter=function(e,t){var r;(r=e.getPacketList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter)},proto.mediapipe.PacketManagerConfig.prototype.getPacketList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.PacketFactoryConfig,1)},proto.mediapipe.PacketManagerConfig.prototype.setPacketList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.PacketManagerConfig.prototype.addPacket=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.PacketFactoryConfig,r)},proto.mediapipe.PacketManagerConfig.prototype.clearPacketList=function(){return this.setPacketList([])},r.object.extend(e,proto.mediapipe)}(packet_factory_pb);var packet_generator_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.PacketGeneratorConfig",null,o),r.exportSymbol("proto.mediapipe.PacketGeneratorOptions",null,o),proto.mediapipe.PacketGeneratorOptions=function(e){t.Message.initialize(this,e,0,2,null,null)},r.inherits(proto.mediapipe.PacketGeneratorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.PacketGeneratorOptions.displayName="proto.mediapipe.PacketGeneratorOptions"),proto.mediapipe.PacketGeneratorOptions.extensions={},proto.mediapipe.PacketGeneratorOptions.extensionsBinary={},proto.mediapipe.PacketGeneratorConfig=function(e){t.Message.initialize(this,e,0,500,proto.mediapipe.PacketGeneratorConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.PacketGeneratorConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.PacketGeneratorConfig.displayName="proto.mediapipe.PacketGeneratorConfig"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.PacketGeneratorOptions.prototype.toObject=function(e){return proto.mediapipe.PacketGeneratorOptions.toObject(e,this)},proto.mediapipe.PacketGeneratorOptions.toObject=function(e,r){var o={mergeFields:t.Message.getBooleanFieldWithDefault(r,1,!0)};return t.Message.toObjectExtension(r,o,proto.mediapipe.PacketGeneratorOptions.extensions,proto.mediapipe.PacketGeneratorOptions.prototype.getExtension,e),e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.PacketGeneratorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.PacketGeneratorOptions;return proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)if(1===r.getFieldNumber()){var o=r.readBool();e.setMergeFields(o)}else t.Message.readBinaryExtension(e,r,proto.mediapipe.PacketGeneratorOptions.extensionsBinary,proto.mediapipe.PacketGeneratorOptions.prototype.getExtension,proto.mediapipe.PacketGeneratorOptions.prototype.setExtension);return e},proto.mediapipe.PacketGeneratorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter=function(e,r){var o;null!=(o=t.Message.getField(e,1))&&r.writeBool(1,o),t.Message.serializeBinaryExtensions(e,r,proto.mediapipe.PacketGeneratorOptions.extensionsBinary,proto.mediapipe.PacketGeneratorOptions.prototype.getExtension)},proto.mediapipe.PacketGeneratorOptions.prototype.getMergeFields=function(){return t.Message.getBooleanFieldWithDefault(this,1,!0)},proto.mediapipe.PacketGeneratorOptions.prototype.setMergeFields=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.PacketGeneratorOptions.prototype.clearMergeFields=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.PacketGeneratorOptions.prototype.hasMergeFields=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.PacketGeneratorConfig.repeatedFields_=[2,1002,3,1003],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.PacketGeneratorConfig.prototype.toObject=function(e){return proto.mediapipe.PacketGeneratorConfig.toObject(e,this)},proto.mediapipe.PacketGeneratorConfig.toObject=function(e,r){var o,n={packetGenerator:null==(o=t.Message.getField(r,1))?void 0:o,inputSidePacketList:null==(o=t.Message.getRepeatedField(r,2))?void 0:o,externalInputList:null==(o=t.Message.getRepeatedField(r,1002))?void 0:o,outputSidePacketList:null==(o=t.Message.getRepeatedField(r,3))?void 0:o,externalOutputList:null==(o=t.Message.getRepeatedField(r,1003))?void 0:o,options:(o=r.getOptions())&&proto.mediapipe.PacketGeneratorOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.PacketGeneratorConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.PacketGeneratorConfig;return proto.mediapipe.PacketGeneratorConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.PacketGeneratorConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setPacketGenerator(r);break;case 2:r=t.readString(),e.addInputSidePacket(r);break;case 1002:r=t.readString(),e.addExternalInput(r);break;case 3:r=t.readString(),e.addOutputSidePacket(r);break;case 1003:r=t.readString(),e.addExternalOutput(r);break;case 4:r=new proto.mediapipe.PacketGeneratorOptions,t.readMessage(r,proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.PacketGeneratorConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.PacketGeneratorConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.PacketGeneratorConfig.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),(o=e.getInputSidePacketList()).length>0&&r.writeRepeatedString(2,o),(o=e.getExternalInputList()).length>0&&r.writeRepeatedString(1002,o),(o=e.getOutputSidePacketList()).length>0&&r.writeRepeatedString(3,o),(o=e.getExternalOutputList()).length>0&&r.writeRepeatedString(1003,o),null!=(o=e.getOptions())&&r.writeMessage(4,o,proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter)},proto.mediapipe.PacketGeneratorConfig.prototype.getPacketGenerator=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.PacketGeneratorConfig.prototype.setPacketGenerator=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.PacketGeneratorConfig.prototype.clearPacketGenerator=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.PacketGeneratorConfig.prototype.hasPacketGenerator=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.PacketGeneratorConfig.prototype.getInputSidePacketList=function(){return t.Message.getRepeatedField(this,2)},proto.mediapipe.PacketGeneratorConfig.prototype.setInputSidePacketList=function(e){return t.Message.setField(this,2,e||[])},proto.mediapipe.PacketGeneratorConfig.prototype.addInputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,2,e,r)},proto.mediapipe.PacketGeneratorConfig.prototype.clearInputSidePacketList=function(){return this.setInputSidePacketList([])},proto.mediapipe.PacketGeneratorConfig.prototype.getExternalInputList=function(){return t.Message.getRepeatedField(this,1002)},proto.mediapipe.PacketGeneratorConfig.prototype.setExternalInputList=function(e){return t.Message.setField(this,1002,e||[])},proto.mediapipe.PacketGeneratorConfig.prototype.addExternalInput=function(e,r){return t.Message.addToRepeatedField(this,1002,e,r)},proto.mediapipe.PacketGeneratorConfig.prototype.clearExternalInputList=function(){return this.setExternalInputList([])},proto.mediapipe.PacketGeneratorConfig.prototype.getOutputSidePacketList=function(){return t.Message.getRepeatedField(this,3)},proto.mediapipe.PacketGeneratorConfig.prototype.setOutputSidePacketList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.PacketGeneratorConfig.prototype.addOutputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.PacketGeneratorConfig.prototype.clearOutputSidePacketList=function(){return this.setOutputSidePacketList([])},proto.mediapipe.PacketGeneratorConfig.prototype.getExternalOutputList=function(){return t.Message.getRepeatedField(this,1003)},proto.mediapipe.PacketGeneratorConfig.prototype.setExternalOutputList=function(e){return t.Message.setField(this,1003,e||[])},proto.mediapipe.PacketGeneratorConfig.prototype.addExternalOutput=function(e,r){return t.Message.addToRepeatedField(this,1003,e,r)},proto.mediapipe.PacketGeneratorConfig.prototype.clearExternalOutputList=function(){return this.setExternalOutputList([])},proto.mediapipe.PacketGeneratorConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,proto.mediapipe.PacketGeneratorOptions,4)},proto.mediapipe.PacketGeneratorConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.PacketGeneratorConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.PacketGeneratorConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,4)},r.object.extend(e,proto.mediapipe)}(packet_generator_pb);var status_handler_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=mediapipe_options_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.StatusHandlerConfig",null,o),proto.mediapipe.StatusHandlerConfig=function(e){t.Message.initialize(this,e,0,500,proto.mediapipe.StatusHandlerConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.StatusHandlerConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.StatusHandlerConfig.displayName="proto.mediapipe.StatusHandlerConfig"),proto.mediapipe.StatusHandlerConfig.repeatedFields_=[2,1002],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.StatusHandlerConfig.prototype.toObject=function(e){return proto.mediapipe.StatusHandlerConfig.toObject(e,this)},proto.mediapipe.StatusHandlerConfig.toObject=function(e,r){var o,i={statusHandler:null==(o=t.Message.getField(r,1))?void 0:o,inputSidePacketList:null==(o=t.Message.getRepeatedField(r,2))?void 0:o,externalInputList:null==(o=t.Message.getRepeatedField(r,1002))?void 0:o,options:(o=r.getOptions())&&n.MediaPipeOptions.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.StatusHandlerConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.StatusHandlerConfig;return proto.mediapipe.StatusHandlerConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.StatusHandlerConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setStatusHandler(r);break;case 2:r=t.readString(),e.addInputSidePacket(r);break;case 1002:r=t.readString(),e.addExternalInput(r);break;case 3:r=new n.MediaPipeOptions,t.readMessage(r,n.MediaPipeOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.StatusHandlerConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.StatusHandlerConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.StatusHandlerConfig.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),(o=e.getInputSidePacketList()).length>0&&r.writeRepeatedString(2,o),(o=e.getExternalInputList()).length>0&&r.writeRepeatedString(1002,o),null!=(o=e.getOptions())&&r.writeMessage(3,o,n.MediaPipeOptions.serializeBinaryToWriter)},proto.mediapipe.StatusHandlerConfig.prototype.getStatusHandler=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.StatusHandlerConfig.prototype.setStatusHandler=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.StatusHandlerConfig.prototype.clearStatusHandler=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.StatusHandlerConfig.prototype.hasStatusHandler=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.StatusHandlerConfig.prototype.getInputSidePacketList=function(){return t.Message.getRepeatedField(this,2)},proto.mediapipe.StatusHandlerConfig.prototype.setInputSidePacketList=function(e){return t.Message.setField(this,2,e||[])},proto.mediapipe.StatusHandlerConfig.prototype.addInputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,2,e,r)},proto.mediapipe.StatusHandlerConfig.prototype.clearInputSidePacketList=function(){return this.setInputSidePacketList([])},proto.mediapipe.StatusHandlerConfig.prototype.getExternalInputList=function(){return t.Message.getRepeatedField(this,1002)},proto.mediapipe.StatusHandlerConfig.prototype.setExternalInputList=function(e){return t.Message.setField(this,1002,e||[])},proto.mediapipe.StatusHandlerConfig.prototype.addExternalInput=function(e,r){return t.Message.addToRepeatedField(this,1002,e,r)},proto.mediapipe.StatusHandlerConfig.prototype.clearExternalInputList=function(){return this.setExternalInputList([])},proto.mediapipe.StatusHandlerConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,n.MediaPipeOptions,3)},proto.mediapipe.StatusHandlerConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.StatusHandlerConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.StatusHandlerConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,3)},r.object.extend(e,proto.mediapipe)}(status_handler_pb);var stream_handler_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=mediapipe_options_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.InputStreamHandlerConfig",null,o),r.exportSymbol("proto.mediapipe.OutputStreamHandlerConfig",null,o),proto.mediapipe.InputStreamHandlerConfig=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InputStreamHandlerConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InputStreamHandlerConfig.displayName="proto.mediapipe.InputStreamHandlerConfig"),proto.mediapipe.OutputStreamHandlerConfig=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.OutputStreamHandlerConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.OutputStreamHandlerConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.OutputStreamHandlerConfig.displayName="proto.mediapipe.OutputStreamHandlerConfig"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InputStreamHandlerConfig.prototype.toObject=function(e){return proto.mediapipe.InputStreamHandlerConfig.toObject(e,this)},proto.mediapipe.InputStreamHandlerConfig.toObject=function(e,r){var o,i={inputStreamHandler:t.Message.getFieldWithDefault(r,1,"DefaultInputStreamHandler"),options:(o=r.getOptions())&&n.MediaPipeOptions.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.InputStreamHandlerConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InputStreamHandlerConfig;return proto.mediapipe.InputStreamHandlerConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.InputStreamHandlerConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setInputStreamHandler(r);break;case 3:r=new n.MediaPipeOptions,t.readMessage(r,n.MediaPipeOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.InputStreamHandlerConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InputStreamHandlerConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InputStreamHandlerConfig.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=e.getOptions())&&r.writeMessage(3,o,n.MediaPipeOptions.serializeBinaryToWriter)},proto.mediapipe.InputStreamHandlerConfig.prototype.getInputStreamHandler=function(){return t.Message.getFieldWithDefault(this,1,"DefaultInputStreamHandler")},proto.mediapipe.InputStreamHandlerConfig.prototype.setInputStreamHandler=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.InputStreamHandlerConfig.prototype.clearInputStreamHandler=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.InputStreamHandlerConfig.prototype.hasInputStreamHandler=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InputStreamHandlerConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,n.MediaPipeOptions,3)},proto.mediapipe.InputStreamHandlerConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.InputStreamHandlerConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.InputStreamHandlerConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.OutputStreamHandlerConfig.repeatedFields_=[2],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.OutputStreamHandlerConfig.prototype.toObject=function(e){return proto.mediapipe.OutputStreamHandlerConfig.toObject(e,this)},proto.mediapipe.OutputStreamHandlerConfig.toObject=function(e,r){var o,i={outputStreamHandler:t.Message.getFieldWithDefault(r,1,"InOrderOutputStreamHandler"),inputSidePacketList:null==(o=t.Message.getRepeatedField(r,2))?void 0:o,options:(o=r.getOptions())&&n.MediaPipeOptions.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.OutputStreamHandlerConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.OutputStreamHandlerConfig;return proto.mediapipe.OutputStreamHandlerConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.OutputStreamHandlerConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setOutputStreamHandler(r);break;case 2:r=t.readString(),e.addInputSidePacket(r);break;case 3:r=new n.MediaPipeOptions,t.readMessage(r,n.MediaPipeOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.OutputStreamHandlerConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.OutputStreamHandlerConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.OutputStreamHandlerConfig.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),(o=e.getInputSidePacketList()).length>0&&r.writeRepeatedString(2,o),null!=(o=e.getOptions())&&r.writeMessage(3,o,n.MediaPipeOptions.serializeBinaryToWriter)},proto.mediapipe.OutputStreamHandlerConfig.prototype.getOutputStreamHandler=function(){return t.Message.getFieldWithDefault(this,1,"InOrderOutputStreamHandler")},proto.mediapipe.OutputStreamHandlerConfig.prototype.setOutputStreamHandler=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.OutputStreamHandlerConfig.prototype.clearOutputStreamHandler=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.OutputStreamHandlerConfig.prototype.hasOutputStreamHandler=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.OutputStreamHandlerConfig.prototype.getInputSidePacketList=function(){return t.Message.getRepeatedField(this,2)},proto.mediapipe.OutputStreamHandlerConfig.prototype.setInputSidePacketList=function(e){return t.Message.setField(this,2,e||[])},proto.mediapipe.OutputStreamHandlerConfig.prototype.addInputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,2,e,r)},proto.mediapipe.OutputStreamHandlerConfig.prototype.clearInputSidePacketList=function(){return this.setInputSidePacketList([])},proto.mediapipe.OutputStreamHandlerConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,n.MediaPipeOptions,3)},proto.mediapipe.OutputStreamHandlerConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.OutputStreamHandlerConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.OutputStreamHandlerConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,3)},r.object.extend(e,proto.mediapipe)}(stream_handler_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_options_pb;r.object.extend(proto,n);var i=any_pb;r.object.extend(proto,i);var a=mediapipe_options_pb;r.object.extend(proto,a);var s=packet_factory_pb;r.object.extend(proto,s);var p=packet_generator_pb;r.object.extend(proto,p);var c=status_handler_pb;r.object.extend(proto,c);var l=stream_handler_pb;r.object.extend(proto,l),r.exportSymbol("proto.mediapipe.CalculatorGraphConfig",null,o),r.exportSymbol("proto.mediapipe.CalculatorGraphConfig.Node",null,o),r.exportSymbol("proto.mediapipe.ExecutorConfig",null,o),r.exportSymbol("proto.mediapipe.InputCollection",null,o),r.exportSymbol("proto.mediapipe.InputCollection.InputType",null,o),r.exportSymbol("proto.mediapipe.InputCollectionSet",null,o),r.exportSymbol("proto.mediapipe.InputStreamInfo",null,o),r.exportSymbol("proto.mediapipe.ProfilerConfig",null,o),proto.mediapipe.ExecutorConfig=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.ExecutorConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.ExecutorConfig.displayName="proto.mediapipe.ExecutorConfig"),proto.mediapipe.InputCollection=function(e){t.Message.initialize(this,e,0,500,proto.mediapipe.InputCollection.repeatedFields_,null)},r.inherits(proto.mediapipe.InputCollection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InputCollection.displayName="proto.mediapipe.InputCollection"),proto.mediapipe.InputCollectionSet=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.InputCollectionSet.repeatedFields_,null)},r.inherits(proto.mediapipe.InputCollectionSet,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InputCollectionSet.displayName="proto.mediapipe.InputCollectionSet"),proto.mediapipe.InputStreamInfo=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InputStreamInfo,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InputStreamInfo.displayName="proto.mediapipe.InputStreamInfo"),proto.mediapipe.ProfilerConfig=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.ProfilerConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.ProfilerConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.ProfilerConfig.displayName="proto.mediapipe.ProfilerConfig"),proto.mediapipe.CalculatorGraphConfig=function(e){t.Message.initialize(this,e,0,500,proto.mediapipe.CalculatorGraphConfig.repeatedFields_,null)},r.inherits(proto.mediapipe.CalculatorGraphConfig,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.CalculatorGraphConfig.displayName="proto.mediapipe.CalculatorGraphConfig"),proto.mediapipe.CalculatorGraphConfig.Node=function(e){t.Message.initialize(this,e,0,500,proto.mediapipe.CalculatorGraphConfig.Node.repeatedFields_,null)},r.inherits(proto.mediapipe.CalculatorGraphConfig.Node,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.CalculatorGraphConfig.Node.displayName="proto.mediapipe.CalculatorGraphConfig.Node"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.ExecutorConfig.prototype.toObject=function(e){return proto.mediapipe.ExecutorConfig.toObject(e,this)},proto.mediapipe.ExecutorConfig.toObject=function(e,r){var o,n={name:t.Message.getFieldWithDefault(r,1,""),type:t.Message.getFieldWithDefault(r,2,""),options:(o=r.getOptions())&&a.MediaPipeOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.ExecutorConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.ExecutorConfig;return proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setName(r);break;case 2:r=t.readString(),e.setType(r);break;case 3:r=new a.MediaPipeOptions,t.readMessage(r,a.MediaPipeOptions.deserializeBinaryFromReader),e.setOptions(r);break;default:t.skipField()}return e},proto.mediapipe.ExecutorConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.ExecutorConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.ExecutorConfig.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getName()).length>0&&t.writeString(1,r),(r=e.getType()).length>0&&t.writeString(2,r),null!=(r=e.getOptions())&&t.writeMessage(3,r,a.MediaPipeOptions.serializeBinaryToWriter)},proto.mediapipe.ExecutorConfig.prototype.getName=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.ExecutorConfig.prototype.setName=function(e){return t.Message.setProto3StringField(this,1,e)},proto.mediapipe.ExecutorConfig.prototype.getType=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.ExecutorConfig.prototype.setType=function(e){return t.Message.setProto3StringField(this,2,e)},proto.mediapipe.ExecutorConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,a.MediaPipeOptions,3)},proto.mediapipe.ExecutorConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.ExecutorConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.ExecutorConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.InputCollection.repeatedFields_=[2,1002],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InputCollection.prototype.toObject=function(e){return proto.mediapipe.InputCollection.toObject(e,this)},proto.mediapipe.InputCollection.toObject=function(e,r){var o,n={name:t.Message.getFieldWithDefault(r,1,""),sidePacketNameList:null==(o=t.Message.getRepeatedField(r,2))?void 0:o,externalInputNameList:null==(o=t.Message.getRepeatedField(r,1002))?void 0:o,inputType:t.Message.getFieldWithDefault(r,3,0),fileName:t.Message.getFieldWithDefault(r,4,"")};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.InputCollection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InputCollection;return proto.mediapipe.InputCollection.deserializeBinaryFromReader(o,r)},proto.mediapipe.InputCollection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setName(r);break;case 2:r=t.readString(),e.addSidePacketName(r);break;case 1002:r=t.readString(),e.addExternalInputName(r);break;case 3:r=t.readEnum(),e.setInputType(r);break;case 4:r=t.readString(),e.setFileName(r);break;default:t.skipField()}return e},proto.mediapipe.InputCollection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InputCollection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InputCollection.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getName()).length>0&&t.writeString(1,r),(r=e.getSidePacketNameList()).length>0&&t.writeRepeatedString(2,r),(r=e.getExternalInputNameList()).length>0&&t.writeRepeatedString(1002,r),0!==(r=e.getInputType())&&t.writeEnum(3,r),(r=e.getFileName()).length>0&&t.writeString(4,r)},proto.mediapipe.InputCollection.InputType={UNKNOWN:0,RECORDIO:1,FOREIGN_RECORDIO:2,FOREIGN_CSV_TEXT:3,INVALID_UPPER_BOUND:4},proto.mediapipe.InputCollection.prototype.getName=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.InputCollection.prototype.setName=function(e){return t.Message.setProto3StringField(this,1,e)},proto.mediapipe.InputCollection.prototype.getSidePacketNameList=function(){return t.Message.getRepeatedField(this,2)},proto.mediapipe.InputCollection.prototype.setSidePacketNameList=function(e){return t.Message.setField(this,2,e||[])},proto.mediapipe.InputCollection.prototype.addSidePacketName=function(e,r){return t.Message.addToRepeatedField(this,2,e,r)},proto.mediapipe.InputCollection.prototype.clearSidePacketNameList=function(){return this.setSidePacketNameList([])},proto.mediapipe.InputCollection.prototype.getExternalInputNameList=function(){return t.Message.getRepeatedField(this,1002)},proto.mediapipe.InputCollection.prototype.setExternalInputNameList=function(e){return t.Message.setField(this,1002,e||[])},proto.mediapipe.InputCollection.prototype.addExternalInputName=function(e,r){return t.Message.addToRepeatedField(this,1002,e,r)},proto.mediapipe.InputCollection.prototype.clearExternalInputNameList=function(){return this.setExternalInputNameList([])},proto.mediapipe.InputCollection.prototype.getInputType=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.InputCollection.prototype.setInputType=function(e){return t.Message.setProto3EnumField(this,3,e)},proto.mediapipe.InputCollection.prototype.getFileName=function(){return t.Message.getFieldWithDefault(this,4,"")},proto.mediapipe.InputCollection.prototype.setFileName=function(e){return t.Message.setProto3StringField(this,4,e)},proto.mediapipe.InputCollectionSet.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InputCollectionSet.prototype.toObject=function(e){return proto.mediapipe.InputCollectionSet.toObject(e,this)},proto.mediapipe.InputCollectionSet.toObject=function(e,r){var o={inputCollectionList:t.Message.toObjectList(r.getInputCollectionList(),proto.mediapipe.InputCollection.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.InputCollectionSet.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InputCollectionSet;return proto.mediapipe.InputCollectionSet.deserializeBinaryFromReader(o,r)},proto.mediapipe.InputCollectionSet.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.InputCollection;t.readMessage(r,proto.mediapipe.InputCollection.deserializeBinaryFromReader),e.addInputCollection(r)}else t.skipField();return e},proto.mediapipe.InputCollectionSet.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InputCollectionSet.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InputCollectionSet.serializeBinaryToWriter=function(e,t){var r;(r=e.getInputCollectionList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.InputCollection.serializeBinaryToWriter)},proto.mediapipe.InputCollectionSet.prototype.getInputCollectionList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.InputCollection,1)},proto.mediapipe.InputCollectionSet.prototype.setInputCollectionList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.InputCollectionSet.prototype.addInputCollection=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.InputCollection,r)},proto.mediapipe.InputCollectionSet.prototype.clearInputCollectionList=function(){return this.setInputCollectionList([])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InputStreamInfo.prototype.toObject=function(e){return proto.mediapipe.InputStreamInfo.toObject(e,this)},proto.mediapipe.InputStreamInfo.toObject=function(e,r){var o={tagIndex:t.Message.getFieldWithDefault(r,1,""),backEdge:t.Message.getBooleanFieldWithDefault(r,2,!1)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.InputStreamInfo.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InputStreamInfo;return proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader(o,r)},proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setTagIndex(r);break;case 2:r=t.readBool(),e.setBackEdge(r);break;default:t.skipField()}return e},proto.mediapipe.InputStreamInfo.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InputStreamInfo.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InputStreamInfo.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getTagIndex()).length>0&&t.writeString(1,r),(r=e.getBackEdge())&&t.writeBool(2,r)},proto.mediapipe.InputStreamInfo.prototype.getTagIndex=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.InputStreamInfo.prototype.setTagIndex=function(e){return t.Message.setProto3StringField(this,1,e)},proto.mediapipe.InputStreamInfo.prototype.getBackEdge=function(){return t.Message.getBooleanFieldWithDefault(this,2,!1)},proto.mediapipe.InputStreamInfo.prototype.setBackEdge=function(e){return t.Message.setProto3BooleanField(this,2,e)},proto.mediapipe.ProfilerConfig.repeatedFields_=[8],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.ProfilerConfig.prototype.toObject=function(e){return proto.mediapipe.ProfilerConfig.toObject(e,this)},proto.mediapipe.ProfilerConfig.toObject=function(e,r){var o,n={histogramIntervalSizeUsec:t.Message.getFieldWithDefault(r,1,0),numHistogramIntervals:t.Message.getFieldWithDefault(r,2,0),enableInputOutputLatency:t.Message.getBooleanFieldWithDefault(r,3,!1),enableProfiler:t.Message.getBooleanFieldWithDefault(r,4,!1),enableStreamLatency:t.Message.getBooleanFieldWithDefault(r,5,!1),usePacketTimestampForAddedPacket:t.Message.getBooleanFieldWithDefault(r,6,!1),traceLogCapacity:t.Message.getFieldWithDefault(r,7,0),traceEventTypesDisabledList:null==(o=t.Message.getRepeatedField(r,8))?void 0:o,traceLogPath:t.Message.getFieldWithDefault(r,9,""),traceLogCount:t.Message.getFieldWithDefault(r,10,0),traceLogIntervalUsec:t.Message.getFieldWithDefault(r,11,0),traceLogMarginUsec:t.Message.getFieldWithDefault(r,12,0),traceLogDurationEvents:t.Message.getBooleanFieldWithDefault(r,13,!1),traceLogIntervalCount:t.Message.getFieldWithDefault(r,14,0),traceLogDisabled:t.Message.getBooleanFieldWithDefault(r,15,!1),traceEnabled:t.Message.getBooleanFieldWithDefault(r,16,!1),traceLogInstantEvents:t.Message.getBooleanFieldWithDefault(r,17,!1),calculatorFilter:t.Message.getFieldWithDefault(r,18,"")};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.ProfilerConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.ProfilerConfig;return proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setHistogramIntervalSizeUsec(r);break;case 2:r=t.readInt64(),e.setNumHistogramIntervals(r);break;case 3:r=t.readBool(),e.setEnableInputOutputLatency(r);break;case 4:r=t.readBool(),e.setEnableProfiler(r);break;case 5:r=t.readBool(),e.setEnableStreamLatency(r);break;case 6:r=t.readBool(),e.setUsePacketTimestampForAddedPacket(r);break;case 7:r=t.readInt64(),e.setTraceLogCapacity(r);break;case 8:for(var o=t.isDelimited()?t.readPackedInt32():[t.readInt32()],n=0;n<o.length;n++)e.addTraceEventTypesDisabled(o[n]);break;case 9:r=t.readString(),e.setTraceLogPath(r);break;case 10:r=t.readInt32(),e.setTraceLogCount(r);break;case 11:r=t.readInt64(),e.setTraceLogIntervalUsec(r);break;case 12:r=t.readInt64(),e.setTraceLogMarginUsec(r);break;case 13:r=t.readBool(),e.setTraceLogDurationEvents(r);break;case 14:r=t.readInt32(),e.setTraceLogIntervalCount(r);break;case 15:r=t.readBool(),e.setTraceLogDisabled(r);break;case 16:r=t.readBool(),e.setTraceEnabled(r);break;case 17:r=t.readBool(),e.setTraceLogInstantEvents(r);break;case 18:r=t.readString(),e.setCalculatorFilter(r);break;default:t.skipField()}return e},proto.mediapipe.ProfilerConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.ProfilerConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.ProfilerConfig.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getHistogramIntervalSizeUsec())&&t.writeInt64(1,r),0!==(r=e.getNumHistogramIntervals())&&t.writeInt64(2,r),(r=e.getEnableInputOutputLatency())&&t.writeBool(3,r),(r=e.getEnableProfiler())&&t.writeBool(4,r),(r=e.getEnableStreamLatency())&&t.writeBool(5,r),(r=e.getUsePacketTimestampForAddedPacket())&&t.writeBool(6,r),0!==(r=e.getTraceLogCapacity())&&t.writeInt64(7,r),(r=e.getTraceEventTypesDisabledList()).length>0&&t.writePackedInt32(8,r),(r=e.getTraceLogPath()).length>0&&t.writeString(9,r),0!==(r=e.getTraceLogCount())&&t.writeInt32(10,r),0!==(r=e.getTraceLogIntervalUsec())&&t.writeInt64(11,r),0!==(r=e.getTraceLogMarginUsec())&&t.writeInt64(12,r),(r=e.getTraceLogDurationEvents())&&t.writeBool(13,r),0!==(r=e.getTraceLogIntervalCount())&&t.writeInt32(14,r),(r=e.getTraceLogDisabled())&&t.writeBool(15,r),(r=e.getTraceEnabled())&&t.writeBool(16,r),(r=e.getTraceLogInstantEvents())&&t.writeBool(17,r),(r=e.getCalculatorFilter()).length>0&&t.writeString(18,r)},proto.mediapipe.ProfilerConfig.prototype.getHistogramIntervalSizeUsec=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.ProfilerConfig.prototype.setHistogramIntervalSizeUsec=function(e){return t.Message.setProto3IntField(this,1,e)},proto.mediapipe.ProfilerConfig.prototype.getNumHistogramIntervals=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.ProfilerConfig.prototype.setNumHistogramIntervals=function(e){return t.Message.setProto3IntField(this,2,e)},proto.mediapipe.ProfilerConfig.prototype.getEnableInputOutputLatency=function(){return t.Message.getBooleanFieldWithDefault(this,3,!1)},proto.mediapipe.ProfilerConfig.prototype.setEnableInputOutputLatency=function(e){return t.Message.setProto3BooleanField(this,3,e)},proto.mediapipe.ProfilerConfig.prototype.getEnableProfiler=function(){return t.Message.getBooleanFieldWithDefault(this,4,!1)},proto.mediapipe.ProfilerConfig.prototype.setEnableProfiler=function(e){return t.Message.setProto3BooleanField(this,4,e)},proto.mediapipe.ProfilerConfig.prototype.getEnableStreamLatency=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.ProfilerConfig.prototype.setEnableStreamLatency=function(e){return t.Message.setProto3BooleanField(this,5,e)},proto.mediapipe.ProfilerConfig.prototype.getUsePacketTimestampForAddedPacket=function(){return t.Message.getBooleanFieldWithDefault(this,6,!1)},proto.mediapipe.ProfilerConfig.prototype.setUsePacketTimestampForAddedPacket=function(e){return t.Message.setProto3BooleanField(this,6,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogCapacity=function(){return t.Message.getFieldWithDefault(this,7,0)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogCapacity=function(e){return t.Message.setProto3IntField(this,7,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceEventTypesDisabledList=function(){return t.Message.getRepeatedField(this,8)},proto.mediapipe.ProfilerConfig.prototype.setTraceEventTypesDisabledList=function(e){return t.Message.setField(this,8,e||[])},proto.mediapipe.ProfilerConfig.prototype.addTraceEventTypesDisabled=function(e,r){return t.Message.addToRepeatedField(this,8,e,r)},proto.mediapipe.ProfilerConfig.prototype.clearTraceEventTypesDisabledList=function(){return this.setTraceEventTypesDisabledList([])},proto.mediapipe.ProfilerConfig.prototype.getTraceLogPath=function(){return t.Message.getFieldWithDefault(this,9,"")},proto.mediapipe.ProfilerConfig.prototype.setTraceLogPath=function(e){return t.Message.setProto3StringField(this,9,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogCount=function(){return t.Message.getFieldWithDefault(this,10,0)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogCount=function(e){return t.Message.setProto3IntField(this,10,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogIntervalUsec=function(){return t.Message.getFieldWithDefault(this,11,0)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogIntervalUsec=function(e){return t.Message.setProto3IntField(this,11,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogMarginUsec=function(){return t.Message.getFieldWithDefault(this,12,0)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogMarginUsec=function(e){return t.Message.setProto3IntField(this,12,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogDurationEvents=function(){return t.Message.getBooleanFieldWithDefault(this,13,!1)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogDurationEvents=function(e){return t.Message.setProto3BooleanField(this,13,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogIntervalCount=function(){return t.Message.getFieldWithDefault(this,14,0)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogIntervalCount=function(e){return t.Message.setProto3IntField(this,14,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogDisabled=function(){return t.Message.getBooleanFieldWithDefault(this,15,!1)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogDisabled=function(e){return t.Message.setProto3BooleanField(this,15,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceEnabled=function(){return t.Message.getBooleanFieldWithDefault(this,16,!1)},proto.mediapipe.ProfilerConfig.prototype.setTraceEnabled=function(e){return t.Message.setProto3BooleanField(this,16,e)},proto.mediapipe.ProfilerConfig.prototype.getTraceLogInstantEvents=function(){return t.Message.getBooleanFieldWithDefault(this,17,!1)},proto.mediapipe.ProfilerConfig.prototype.setTraceLogInstantEvents=function(e){return t.Message.setProto3BooleanField(this,17,e)},proto.mediapipe.ProfilerConfig.prototype.getCalculatorFilter=function(){return t.Message.getFieldWithDefault(this,18,"")},proto.mediapipe.ProfilerConfig.prototype.setCalculatorFilter=function(e){return t.Message.setProto3StringField(this,18,e)},proto.mediapipe.CalculatorGraphConfig.repeatedFields_=[1,6,7,9,10,15,16,17,14,1002],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.CalculatorGraphConfig.prototype.toObject=function(e){return proto.mediapipe.CalculatorGraphConfig.toObject(e,this)},proto.mediapipe.CalculatorGraphConfig.toObject=function(e,r){var o,n={nodeList:t.Message.toObjectList(r.getNodeList(),proto.mediapipe.CalculatorGraphConfig.Node.toObject,e),packetFactoryList:t.Message.toObjectList(r.getPacketFactoryList(),s.PacketFactoryConfig.toObject,e),packetGeneratorList:t.Message.toObjectList(r.getPacketGeneratorList(),p.PacketGeneratorConfig.toObject,e),numThreads:t.Message.getFieldWithDefault(r,8,0),statusHandlerList:t.Message.toObjectList(r.getStatusHandlerList(),c.StatusHandlerConfig.toObject,e),inputStreamList:null==(o=t.Message.getRepeatedField(r,10))?void 0:o,outputStreamList:null==(o=t.Message.getRepeatedField(r,15))?void 0:o,inputSidePacketList:null==(o=t.Message.getRepeatedField(r,16))?void 0:o,outputSidePacketList:null==(o=t.Message.getRepeatedField(r,17))?void 0:o,maxQueueSize:t.Message.getFieldWithDefault(r,11,0),reportDeadlock:t.Message.getBooleanFieldWithDefault(r,21,!1),inputStreamHandler:(o=r.getInputStreamHandler())&&l.InputStreamHandlerConfig.toObject(e,o),outputStreamHandler:(o=r.getOutputStreamHandler())&&l.OutputStreamHandlerConfig.toObject(e,o),executorList:t.Message.toObjectList(r.getExecutorList(),proto.mediapipe.ExecutorConfig.toObject,e),profilerConfig:(o=r.getProfilerConfig())&&proto.mediapipe.ProfilerConfig.toObject(e,o),pb_package:t.Message.getFieldWithDefault(r,19,""),type:t.Message.getFieldWithDefault(r,20,""),options:(o=r.getOptions())&&a.MediaPipeOptions.toObject(e,o),graphOptionsList:t.Message.toObjectList(r.getGraphOptionsList(),i.Any.toObject,e)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.CalculatorGraphConfig.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.CalculatorGraphConfig;return proto.mediapipe.CalculatorGraphConfig.deserializeBinaryFromReader(o,r)},proto.mediapipe.CalculatorGraphConfig.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.CalculatorGraphConfig.Node;t.readMessage(r,proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader),e.addNode(r);break;case 6:r=new s.PacketFactoryConfig,t.readMessage(r,s.PacketFactoryConfig.deserializeBinaryFromReader),e.addPacketFactory(r);break;case 7:r=new p.PacketGeneratorConfig,t.readMessage(r,p.PacketGeneratorConfig.deserializeBinaryFromReader),e.addPacketGenerator(r);break;case 8:r=t.readInt32(),e.setNumThreads(r);break;case 9:r=new c.StatusHandlerConfig,t.readMessage(r,c.StatusHandlerConfig.deserializeBinaryFromReader),e.addStatusHandler(r);break;case 10:r=t.readString(),e.addInputStream(r);break;case 15:r=t.readString(),e.addOutputStream(r);break;case 16:r=t.readString(),e.addInputSidePacket(r);break;case 17:r=t.readString(),e.addOutputSidePacket(r);break;case 11:r=t.readInt32(),e.setMaxQueueSize(r);break;case 21:r=t.readBool(),e.setReportDeadlock(r);break;case 12:r=new l.InputStreamHandlerConfig,t.readMessage(r,l.InputStreamHandlerConfig.deserializeBinaryFromReader),e.setInputStreamHandler(r);break;case 13:r=new l.OutputStreamHandlerConfig,t.readMessage(r,l.OutputStreamHandlerConfig.deserializeBinaryFromReader),e.setOutputStreamHandler(r);break;case 14:r=new proto.mediapipe.ExecutorConfig,t.readMessage(r,proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader),e.addExecutor(r);break;case 18:r=new proto.mediapipe.ProfilerConfig,t.readMessage(r,proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader),e.setProfilerConfig(r);break;case 19:r=t.readString(),e.setPackage(r);break;case 20:r=t.readString(),e.setType(r);break;case 1001:r=new a.MediaPipeOptions,t.readMessage(r,a.MediaPipeOptions.deserializeBinaryFromReader),e.setOptions(r);break;case 1002:r=new i.Any,t.readMessage(r,i.Any.deserializeBinaryFromReader),e.addGraphOptions(r);break;default:t.skipField()}return e},proto.mediapipe.CalculatorGraphConfig.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.CalculatorGraphConfig.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.CalculatorGraphConfig.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getNodeList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter),(r=e.getPacketFactoryList()).length>0&&t.writeRepeatedMessage(6,r,s.PacketFactoryConfig.serializeBinaryToWriter),(r=e.getPacketGeneratorList()).length>0&&t.writeRepeatedMessage(7,r,p.PacketGeneratorConfig.serializeBinaryToWriter),0!==(r=e.getNumThreads())&&t.writeInt32(8,r),(r=e.getStatusHandlerList()).length>0&&t.writeRepeatedMessage(9,r,c.StatusHandlerConfig.serializeBinaryToWriter),(r=e.getInputStreamList()).length>0&&t.writeRepeatedString(10,r),(r=e.getOutputStreamList()).length>0&&t.writeRepeatedString(15,r),(r=e.getInputSidePacketList()).length>0&&t.writeRepeatedString(16,r),(r=e.getOutputSidePacketList()).length>0&&t.writeRepeatedString(17,r),0!==(r=e.getMaxQueueSize())&&t.writeInt32(11,r),(r=e.getReportDeadlock())&&t.writeBool(21,r),null!=(r=e.getInputStreamHandler())&&t.writeMessage(12,r,l.InputStreamHandlerConfig.serializeBinaryToWriter),null!=(r=e.getOutputStreamHandler())&&t.writeMessage(13,r,l.OutputStreamHandlerConfig.serializeBinaryToWriter),(r=e.getExecutorList()).length>0&&t.writeRepeatedMessage(14,r,proto.mediapipe.ExecutorConfig.serializeBinaryToWriter),null!=(r=e.getProfilerConfig())&&t.writeMessage(18,r,proto.mediapipe.ProfilerConfig.serializeBinaryToWriter),(r=e.getPackage()).length>0&&t.writeString(19,r),(r=e.getType()).length>0&&t.writeString(20,r),null!=(r=e.getOptions())&&t.writeMessage(1001,r,a.MediaPipeOptions.serializeBinaryToWriter),(r=e.getGraphOptionsList()).length>0&&t.writeRepeatedMessage(1002,r,i.Any.serializeBinaryToWriter)},proto.mediapipe.CalculatorGraphConfig.Node.repeatedFields_=[3,4,5,6,8,13,17,1005],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.CalculatorGraphConfig.Node.prototype.toObject=function(e){return proto.mediapipe.CalculatorGraphConfig.Node.toObject(e,this)},proto.mediapipe.CalculatorGraphConfig.Node.toObject=function(e,r){var o,a={name:t.Message.getFieldWithDefault(r,1,""),calculator:t.Message.getFieldWithDefault(r,2,""),inputStreamList:null==(o=t.Message.getRepeatedField(r,3))?void 0:o,outputStreamList:null==(o=t.Message.getRepeatedField(r,4))?void 0:o,inputSidePacketList:null==(o=t.Message.getRepeatedField(r,5))?void 0:o,outputSidePacketList:null==(o=t.Message.getRepeatedField(r,6))?void 0:o,options:(o=r.getOptions())&&n.CalculatorOptions.toObject(e,o),nodeOptionsList:t.Message.toObjectList(r.getNodeOptionsList(),i.Any.toObject,e),sourceLayer:t.Message.getFieldWithDefault(r,9,0),bufferSizeHint:t.Message.getFieldWithDefault(r,10,0),inputStreamHandler:(o=r.getInputStreamHandler())&&l.InputStreamHandlerConfig.toObject(e,o),outputStreamHandler:(o=r.getOutputStreamHandler())&&l.OutputStreamHandlerConfig.toObject(e,o),inputStreamInfoList:t.Message.toObjectList(r.getInputStreamInfoList(),proto.mediapipe.InputStreamInfo.toObject,e),executor:t.Message.getFieldWithDefault(r,14,""),profilerConfig:(o=r.getProfilerConfig())&&proto.mediapipe.ProfilerConfig.toObject(e,o),maxInFlight:t.Message.getFieldWithDefault(r,16,0),optionValueList:null==(o=t.Message.getRepeatedField(r,17))?void 0:o,externalInputList:null==(o=t.Message.getRepeatedField(r,1005))?void 0:o};return e&&(a.$jspbMessageInstance=r),a}),proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.CalculatorGraphConfig.Node;return proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader(o,r)},proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setName(r);break;case 2:r=t.readString(),e.setCalculator(r);break;case 3:r=t.readString(),e.addInputStream(r);break;case 4:r=t.readString(),e.addOutputStream(r);break;case 5:r=t.readString(),e.addInputSidePacket(r);break;case 6:r=t.readString(),e.addOutputSidePacket(r);break;case 7:r=new n.CalculatorOptions,t.readMessage(r,n.CalculatorOptions.deserializeBinaryFromReader),e.setOptions(r);break;case 8:r=new i.Any,t.readMessage(r,i.Any.deserializeBinaryFromReader),e.addNodeOptions(r);break;case 9:r=t.readInt32(),e.setSourceLayer(r);break;case 10:r=t.readInt32(),e.setBufferSizeHint(r);break;case 11:r=new l.InputStreamHandlerConfig,t.readMessage(r,l.InputStreamHandlerConfig.deserializeBinaryFromReader),e.setInputStreamHandler(r);break;case 12:r=new l.OutputStreamHandlerConfig,t.readMessage(r,l.OutputStreamHandlerConfig.deserializeBinaryFromReader),e.setOutputStreamHandler(r);break;case 13:r=new proto.mediapipe.InputStreamInfo,t.readMessage(r,proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader),e.addInputStreamInfo(r);break;case 14:r=t.readString(),e.setExecutor(r);break;case 15:r=new proto.mediapipe.ProfilerConfig,t.readMessage(r,proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader),e.setProfilerConfig(r);break;case 16:r=t.readInt32(),e.setMaxInFlight(r);break;case 17:r=t.readString(),e.addOptionValue(r);break;case 1005:r=t.readString(),e.addExternalInput(r);break;default:t.skipField()}return e},proto.mediapipe.CalculatorGraphConfig.Node.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getName()).length>0&&t.writeString(1,r),(r=e.getCalculator()).length>0&&t.writeString(2,r),(r=e.getInputStreamList()).length>0&&t.writeRepeatedString(3,r),(r=e.getOutputStreamList()).length>0&&t.writeRepeatedString(4,r),(r=e.getInputSidePacketList()).length>0&&t.writeRepeatedString(5,r),(r=e.getOutputSidePacketList()).length>0&&t.writeRepeatedString(6,r),null!=(r=e.getOptions())&&t.writeMessage(7,r,n.CalculatorOptions.serializeBinaryToWriter),(r=e.getNodeOptionsList()).length>0&&t.writeRepeatedMessage(8,r,i.Any.serializeBinaryToWriter),0!==(r=e.getSourceLayer())&&t.writeInt32(9,r),0!==(r=e.getBufferSizeHint())&&t.writeInt32(10,r),null!=(r=e.getInputStreamHandler())&&t.writeMessage(11,r,l.InputStreamHandlerConfig.serializeBinaryToWriter),null!=(r=e.getOutputStreamHandler())&&t.writeMessage(12,r,l.OutputStreamHandlerConfig.serializeBinaryToWriter),(r=e.getInputStreamInfoList()).length>0&&t.writeRepeatedMessage(13,r,proto.mediapipe.InputStreamInfo.serializeBinaryToWriter),(r=e.getExecutor()).length>0&&t.writeString(14,r),null!=(r=e.getProfilerConfig())&&t.writeMessage(15,r,proto.mediapipe.ProfilerConfig.serializeBinaryToWriter),0!==(r=e.getMaxInFlight())&&t.writeInt32(16,r),(r=e.getOptionValueList()).length>0&&t.writeRepeatedString(17,r),(r=e.getExternalInputList()).length>0&&t.writeRepeatedString(1005,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getName=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setName=function(e){return t.Message.setProto3StringField(this,1,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getCalculator=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setCalculator=function(e){return t.Message.setProto3StringField(this,2,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamList=function(){return t.Message.getRepeatedField(this,3)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputStream=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamList=function(){return this.setInputStreamList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputStreamList=function(){return t.Message.getRepeatedField(this,4)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputStreamList=function(e){return t.Message.setField(this,4,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOutputStream=function(e,r){return t.Message.addToRepeatedField(this,4,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputStreamList=function(){return this.setOutputStreamList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputSidePacketList=function(){return t.Message.getRepeatedField(this,5)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputSidePacketList=function(e){return t.Message.setField(this,5,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,5,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputSidePacketList=function(){return this.setInputSidePacketList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputSidePacketList=function(){return t.Message.getRepeatedField(this,6)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputSidePacketList=function(e){return t.Message.setField(this,6,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOutputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,6,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputSidePacketList=function(){return this.setOutputSidePacketList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOptions=function(){return t.Message.getWrapperField(this,n.CalculatorOptions,7)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOptions=function(e){return t.Message.setWrapperField(this,7,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasOptions=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getNodeOptionsList=function(){return t.Message.getRepeatedWrapperField(this,i.Any,8)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setNodeOptionsList=function(e){return t.Message.setRepeatedWrapperField(this,8,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addNodeOptions=function(e,r){return t.Message.addToRepeatedWrapperField(this,8,e,proto.google.protobuf.Any,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearNodeOptionsList=function(){return this.setNodeOptionsList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getSourceLayer=function(){return t.Message.getFieldWithDefault(this,9,0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setSourceLayer=function(e){return t.Message.setProto3IntField(this,9,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getBufferSizeHint=function(){return t.Message.getFieldWithDefault(this,10,0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setBufferSizeHint=function(e){return t.Message.setProto3IntField(this,10,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamHandler=function(){return t.Message.getWrapperField(this,l.InputStreamHandlerConfig,11)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamHandler=function(e){return t.Message.setWrapperField(this,11,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamHandler=function(){return this.setInputStreamHandler(void 0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasInputStreamHandler=function(){return null!=t.Message.getField(this,11)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputStreamHandler=function(){return t.Message.getWrapperField(this,l.OutputStreamHandlerConfig,12)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputStreamHandler=function(e){return t.Message.setWrapperField(this,12,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputStreamHandler=function(){return this.setOutputStreamHandler(void 0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasOutputStreamHandler=function(){return null!=t.Message.getField(this,12)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamInfoList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.InputStreamInfo,13)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamInfoList=function(e){return t.Message.setRepeatedWrapperField(this,13,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputStreamInfo=function(e,r){return t.Message.addToRepeatedWrapperField(this,13,e,proto.mediapipe.InputStreamInfo,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamInfoList=function(){return this.setInputStreamInfoList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getExecutor=function(){return t.Message.getFieldWithDefault(this,14,"")},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setExecutor=function(e){return t.Message.setProto3StringField(this,14,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getProfilerConfig=function(){return t.Message.getWrapperField(this,proto.mediapipe.ProfilerConfig,15)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setProfilerConfig=function(e){return t.Message.setWrapperField(this,15,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearProfilerConfig=function(){return this.setProfilerConfig(void 0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasProfilerConfig=function(){return null!=t.Message.getField(this,15)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getMaxInFlight=function(){return t.Message.getFieldWithDefault(this,16,0)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setMaxInFlight=function(e){return t.Message.setProto3IntField(this,16,e)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOptionValueList=function(){return t.Message.getRepeatedField(this,17)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOptionValueList=function(e){return t.Message.setField(this,17,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOptionValue=function(e,r){return t.Message.addToRepeatedField(this,17,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOptionValueList=function(){return this.setOptionValueList([])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.getExternalInputList=function(){return t.Message.getRepeatedField(this,1005)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.setExternalInputList=function(e){return t.Message.setField(this,1005,e||[])},proto.mediapipe.CalculatorGraphConfig.Node.prototype.addExternalInput=function(e,r){return t.Message.addToRepeatedField(this,1005,e,r)},proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearExternalInputList=function(){return this.setExternalInputList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getNodeList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.CalculatorGraphConfig.Node,1)},proto.mediapipe.CalculatorGraphConfig.prototype.setNodeList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addNode=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.CalculatorGraphConfig.Node,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearNodeList=function(){return this.setNodeList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getPacketFactoryList=function(){return t.Message.getRepeatedWrapperField(this,s.PacketFactoryConfig,6)},proto.mediapipe.CalculatorGraphConfig.prototype.setPacketFactoryList=function(e){return t.Message.setRepeatedWrapperField(this,6,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addPacketFactory=function(e,r){return t.Message.addToRepeatedWrapperField(this,6,e,proto.mediapipe.PacketFactoryConfig,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearPacketFactoryList=function(){return this.setPacketFactoryList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getPacketGeneratorList=function(){return t.Message.getRepeatedWrapperField(this,p.PacketGeneratorConfig,7)},proto.mediapipe.CalculatorGraphConfig.prototype.setPacketGeneratorList=function(e){return t.Message.setRepeatedWrapperField(this,7,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addPacketGenerator=function(e,r){return t.Message.addToRepeatedWrapperField(this,7,e,proto.mediapipe.PacketGeneratorConfig,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearPacketGeneratorList=function(){return this.setPacketGeneratorList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getNumThreads=function(){return t.Message.getFieldWithDefault(this,8,0)},proto.mediapipe.CalculatorGraphConfig.prototype.setNumThreads=function(e){return t.Message.setProto3IntField(this,8,e)},proto.mediapipe.CalculatorGraphConfig.prototype.getStatusHandlerList=function(){return t.Message.getRepeatedWrapperField(this,c.StatusHandlerConfig,9)},proto.mediapipe.CalculatorGraphConfig.prototype.setStatusHandlerList=function(e){return t.Message.setRepeatedWrapperField(this,9,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addStatusHandler=function(e,r){return t.Message.addToRepeatedWrapperField(this,9,e,proto.mediapipe.StatusHandlerConfig,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearStatusHandlerList=function(){return this.setStatusHandlerList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getInputStreamList=function(){return t.Message.getRepeatedField(this,10)},proto.mediapipe.CalculatorGraphConfig.prototype.setInputStreamList=function(e){return t.Message.setField(this,10,e||[])},proto.mediapipe.CalculatorGraphConfig.prototype.addInputStream=function(e,r){return t.Message.addToRepeatedField(this,10,e,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearInputStreamList=function(){return this.setInputStreamList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getOutputStreamList=function(){return t.Message.getRepeatedField(this,15)},proto.mediapipe.CalculatorGraphConfig.prototype.setOutputStreamList=function(e){return t.Message.setField(this,15,e||[])},proto.mediapipe.CalculatorGraphConfig.prototype.addOutputStream=function(e,r){return t.Message.addToRepeatedField(this,15,e,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputStreamList=function(){return this.setOutputStreamList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getInputSidePacketList=function(){return t.Message.getRepeatedField(this,16)},proto.mediapipe.CalculatorGraphConfig.prototype.setInputSidePacketList=function(e){return t.Message.setField(this,16,e||[])},proto.mediapipe.CalculatorGraphConfig.prototype.addInputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,16,e,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearInputSidePacketList=function(){return this.setInputSidePacketList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getOutputSidePacketList=function(){return t.Message.getRepeatedField(this,17)},proto.mediapipe.CalculatorGraphConfig.prototype.setOutputSidePacketList=function(e){return t.Message.setField(this,17,e||[])},proto.mediapipe.CalculatorGraphConfig.prototype.addOutputSidePacket=function(e,r){return t.Message.addToRepeatedField(this,17,e,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputSidePacketList=function(){return this.setOutputSidePacketList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getMaxQueueSize=function(){return t.Message.getFieldWithDefault(this,11,0)},proto.mediapipe.CalculatorGraphConfig.prototype.setMaxQueueSize=function(e){return t.Message.setProto3IntField(this,11,e)},proto.mediapipe.CalculatorGraphConfig.prototype.getReportDeadlock=function(){return t.Message.getBooleanFieldWithDefault(this,21,!1)},proto.mediapipe.CalculatorGraphConfig.prototype.setReportDeadlock=function(e){return t.Message.setProto3BooleanField(this,21,e)},proto.mediapipe.CalculatorGraphConfig.prototype.getInputStreamHandler=function(){return t.Message.getWrapperField(this,l.InputStreamHandlerConfig,12)},proto.mediapipe.CalculatorGraphConfig.prototype.setInputStreamHandler=function(e){return t.Message.setWrapperField(this,12,e)},proto.mediapipe.CalculatorGraphConfig.prototype.clearInputStreamHandler=function(){return this.setInputStreamHandler(void 0)},proto.mediapipe.CalculatorGraphConfig.prototype.hasInputStreamHandler=function(){return null!=t.Message.getField(this,12)},proto.mediapipe.CalculatorGraphConfig.prototype.getOutputStreamHandler=function(){return t.Message.getWrapperField(this,l.OutputStreamHandlerConfig,13)},proto.mediapipe.CalculatorGraphConfig.prototype.setOutputStreamHandler=function(e){return t.Message.setWrapperField(this,13,e)},proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputStreamHandler=function(){return this.setOutputStreamHandler(void 0)},proto.mediapipe.CalculatorGraphConfig.prototype.hasOutputStreamHandler=function(){return null!=t.Message.getField(this,13)},proto.mediapipe.CalculatorGraphConfig.prototype.getExecutorList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.ExecutorConfig,14)},proto.mediapipe.CalculatorGraphConfig.prototype.setExecutorList=function(e){return t.Message.setRepeatedWrapperField(this,14,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addExecutor=function(e,r){return t.Message.addToRepeatedWrapperField(this,14,e,proto.mediapipe.ExecutorConfig,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearExecutorList=function(){return this.setExecutorList([])},proto.mediapipe.CalculatorGraphConfig.prototype.getProfilerConfig=function(){return t.Message.getWrapperField(this,proto.mediapipe.ProfilerConfig,18)},proto.mediapipe.CalculatorGraphConfig.prototype.setProfilerConfig=function(e){return t.Message.setWrapperField(this,18,e)},proto.mediapipe.CalculatorGraphConfig.prototype.clearProfilerConfig=function(){return this.setProfilerConfig(void 0)},proto.mediapipe.CalculatorGraphConfig.prototype.hasProfilerConfig=function(){return null!=t.Message.getField(this,18)},proto.mediapipe.CalculatorGraphConfig.prototype.getPackage=function(){return t.Message.getFieldWithDefault(this,19,"")},proto.mediapipe.CalculatorGraphConfig.prototype.setPackage=function(e){return t.Message.setProto3StringField(this,19,e)},proto.mediapipe.CalculatorGraphConfig.prototype.getType=function(){return t.Message.getFieldWithDefault(this,20,"")},proto.mediapipe.CalculatorGraphConfig.prototype.setType=function(e){return t.Message.setProto3StringField(this,20,e)},proto.mediapipe.CalculatorGraphConfig.prototype.getOptions=function(){return t.Message.getWrapperField(this,a.MediaPipeOptions,1001)},proto.mediapipe.CalculatorGraphConfig.prototype.setOptions=function(e){return t.Message.setWrapperField(this,1001,e)},proto.mediapipe.CalculatorGraphConfig.prototype.clearOptions=function(){return this.setOptions(void 0)},proto.mediapipe.CalculatorGraphConfig.prototype.hasOptions=function(){return null!=t.Message.getField(this,1001)},proto.mediapipe.CalculatorGraphConfig.prototype.getGraphOptionsList=function(){return t.Message.getRepeatedWrapperField(this,i.Any,1002)},proto.mediapipe.CalculatorGraphConfig.prototype.setGraphOptionsList=function(e){return t.Message.setRepeatedWrapperField(this,1002,e)},proto.mediapipe.CalculatorGraphConfig.prototype.addGraphOptions=function(e,r){return t.Message.addToRepeatedWrapperField(this,1002,e,proto.google.protobuf.Any,r)},proto.mediapipe.CalculatorGraphConfig.prototype.clearGraphOptionsList=function(){return this.setGraphOptionsList([])},r.object.extend(e,proto.mediapipe)}(calculator_pb);var detection_pb={},location_data_pb={},rasterization_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.Rasterization",null,o),r.exportSymbol("proto.mediapipe.Rasterization.Interval",null,o),proto.mediapipe.Rasterization=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.Rasterization.repeatedFields_,null)},r.inherits(proto.mediapipe.Rasterization,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Rasterization.displayName="proto.mediapipe.Rasterization"),proto.mediapipe.Rasterization.Interval=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Rasterization.Interval,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Rasterization.Interval.displayName="proto.mediapipe.Rasterization.Interval"),proto.mediapipe.Rasterization.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Rasterization.prototype.toObject=function(e){return proto.mediapipe.Rasterization.toObject(e,this)},proto.mediapipe.Rasterization.toObject=function(e,r){var o={intervalList:t.Message.toObjectList(r.getIntervalList(),proto.mediapipe.Rasterization.Interval.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.Rasterization.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Rasterization;return proto.mediapipe.Rasterization.deserializeBinaryFromReader(o,r)},proto.mediapipe.Rasterization.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.Rasterization.Interval;t.readMessage(r,proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader),e.addInterval(r)}else t.skipField();return e},proto.mediapipe.Rasterization.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Rasterization.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Rasterization.serializeBinaryToWriter=function(e,t){var r;(r=e.getIntervalList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Rasterization.Interval.prototype.toObject=function(e){return proto.mediapipe.Rasterization.Interval.toObject(e,this)},proto.mediapipe.Rasterization.Interval.toObject=function(e,r){var o,n={y:null==(o=t.Message.getField(r,1))?void 0:o,leftX:null==(o=t.Message.getField(r,2))?void 0:o,rightX:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Rasterization.Interval.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Rasterization.Interval;return proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader(o,r)},proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setY(r);break;case 2:r=t.readInt32(),e.setLeftX(r);break;case 3:r=t.readInt32(),e.setRightX(r);break;default:t.skipField()}return e},proto.mediapipe.Rasterization.Interval.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o)},proto.mediapipe.Rasterization.Interval.prototype.getY=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.Rasterization.Interval.prototype.setY=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Rasterization.Interval.prototype.clearY=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Rasterization.Interval.prototype.hasY=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Rasterization.Interval.prototype.getLeftX=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.Rasterization.Interval.prototype.setLeftX=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Rasterization.Interval.prototype.clearLeftX=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Rasterization.Interval.prototype.hasLeftX=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Rasterization.Interval.prototype.getRightX=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.Rasterization.Interval.prototype.setRightX=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.Rasterization.Interval.prototype.clearRightX=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.Rasterization.Interval.prototype.hasRightX=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.Rasterization.prototype.getIntervalList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.Rasterization.Interval,1)},proto.mediapipe.Rasterization.prototype.setIntervalList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.Rasterization.prototype.addInterval=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.Rasterization.Interval,r)},proto.mediapipe.Rasterization.prototype.clearIntervalList=function(){return this.setIntervalList([])},r.object.extend(e,proto.mediapipe)}(rasterization_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=rasterization_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.LocationData",null,o),r.exportSymbol("proto.mediapipe.LocationData.BinaryMask",null,o),r.exportSymbol("proto.mediapipe.LocationData.BoundingBox",null,o),r.exportSymbol("proto.mediapipe.LocationData.Format",null,o),r.exportSymbol("proto.mediapipe.LocationData.RelativeBoundingBox",null,o),r.exportSymbol("proto.mediapipe.LocationData.RelativeKeypoint",null,o),proto.mediapipe.LocationData=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.LocationData.repeatedFields_,null)},r.inherits(proto.mediapipe.LocationData,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LocationData.displayName="proto.mediapipe.LocationData"),proto.mediapipe.LocationData.BoundingBox=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.LocationData.BoundingBox,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LocationData.BoundingBox.displayName="proto.mediapipe.LocationData.BoundingBox"),proto.mediapipe.LocationData.RelativeBoundingBox=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.LocationData.RelativeBoundingBox,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LocationData.RelativeBoundingBox.displayName="proto.mediapipe.LocationData.RelativeBoundingBox"),proto.mediapipe.LocationData.BinaryMask=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.LocationData.BinaryMask,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LocationData.BinaryMask.displayName="proto.mediapipe.LocationData.BinaryMask"),proto.mediapipe.LocationData.RelativeKeypoint=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.LocationData.RelativeKeypoint,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LocationData.RelativeKeypoint.displayName="proto.mediapipe.LocationData.RelativeKeypoint"),proto.mediapipe.LocationData.repeatedFields_=[5],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LocationData.prototype.toObject=function(e){return proto.mediapipe.LocationData.toObject(e,this)},proto.mediapipe.LocationData.toObject=function(e,r){var o,n={format:null==(o=t.Message.getField(r,1))?void 0:o,boundingBox:(o=r.getBoundingBox())&&proto.mediapipe.LocationData.BoundingBox.toObject(e,o),relativeBoundingBox:(o=r.getRelativeBoundingBox())&&proto.mediapipe.LocationData.RelativeBoundingBox.toObject(e,o),mask:(o=r.getMask())&&proto.mediapipe.LocationData.BinaryMask.toObject(e,o),relativeKeypointsList:t.Message.toObjectList(r.getRelativeKeypointsList(),proto.mediapipe.LocationData.RelativeKeypoint.toObject,e)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.LocationData.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LocationData;return proto.mediapipe.LocationData.deserializeBinaryFromReader(o,r)},proto.mediapipe.LocationData.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readEnum();e.setFormat(r);break;case 2:r=new proto.mediapipe.LocationData.BoundingBox,t.readMessage(r,proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader),e.setBoundingBox(r);break;case 3:r=new proto.mediapipe.LocationData.RelativeBoundingBox,t.readMessage(r,proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader),e.setRelativeBoundingBox(r);break;case 4:r=new proto.mediapipe.LocationData.BinaryMask,t.readMessage(r,proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader),e.setMask(r);break;case 5:r=new proto.mediapipe.LocationData.RelativeKeypoint,t.readMessage(r,proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader),e.addRelativeKeypoints(r);break;default:t.skipField()}return e},proto.mediapipe.LocationData.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LocationData.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LocationData.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeEnum(1,o),null!=(o=e.getBoundingBox())&&r.writeMessage(2,o,proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter),null!=(o=e.getRelativeBoundingBox())&&r.writeMessage(3,o,proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter),null!=(o=e.getMask())&&r.writeMessage(4,o,proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter),(o=e.getRelativeKeypointsList()).length>0&&r.writeRepeatedMessage(5,o,proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter)},proto.mediapipe.LocationData.Format={GLOBAL:0,BOUNDING_BOX:1,RELATIVE_BOUNDING_BOX:2,MASK:3},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LocationData.BoundingBox.prototype.toObject=function(e){return proto.mediapipe.LocationData.BoundingBox.toObject(e,this)},proto.mediapipe.LocationData.BoundingBox.toObject=function(e,r){var o,n={xmin:null==(o=t.Message.getField(r,1))?void 0:o,ymin:null==(o=t.Message.getField(r,2))?void 0:o,width:null==(o=t.Message.getField(r,3))?void 0:o,height:null==(o=t.Message.getField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.LocationData.BoundingBox.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LocationData.BoundingBox;return proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader(o,r)},proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setXmin(r);break;case 2:r=t.readInt32(),e.setYmin(r);break;case 3:r=t.readInt32(),e.setWidth(r);break;case 4:r=t.readInt32(),e.setHeight(r);break;default:t.skipField()}return e},proto.mediapipe.LocationData.BoundingBox.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o),null!=(o=t.Message.getField(e,4))&&r.writeInt32(4,o)},proto.mediapipe.LocationData.BoundingBox.prototype.getXmin=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.LocationData.BoundingBox.prototype.setXmin=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LocationData.BoundingBox.prototype.clearXmin=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LocationData.BoundingBox.prototype.hasXmin=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LocationData.BoundingBox.prototype.getYmin=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.LocationData.BoundingBox.prototype.setYmin=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.LocationData.BoundingBox.prototype.clearYmin=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.LocationData.BoundingBox.prototype.hasYmin=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LocationData.BoundingBox.prototype.getWidth=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.LocationData.BoundingBox.prototype.setWidth=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.LocationData.BoundingBox.prototype.clearWidth=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.LocationData.BoundingBox.prototype.hasWidth=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.LocationData.BoundingBox.prototype.getHeight=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.LocationData.BoundingBox.prototype.setHeight=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.LocationData.BoundingBox.prototype.clearHeight=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.LocationData.BoundingBox.prototype.hasHeight=function(){return null!=t.Message.getField(this,4)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LocationData.RelativeBoundingBox.prototype.toObject=function(e){return proto.mediapipe.LocationData.RelativeBoundingBox.toObject(e,this)},proto.mediapipe.LocationData.RelativeBoundingBox.toObject=function(e,r){var o,n={xmin:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,ymin:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,width:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,height:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LocationData.RelativeBoundingBox;return proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader(o,r)},proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readFloat();e.setXmin(r);break;case 2:r=t.readFloat(),e.setYmin(r);break;case 3:r=t.readFloat(),e.setWidth(r);break;case 4:r=t.readFloat(),e.setHeight(r);break;default:t.skipField()}return e},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeFloat(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getXmin=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setXmin=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearXmin=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasXmin=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getYmin=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setYmin=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearYmin=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasYmin=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getWidth=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setWidth=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearWidth=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasWidth=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getHeight=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setHeight=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearHeight=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasHeight=function(){return null!=t.Message.getField(this,4)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LocationData.BinaryMask.prototype.toObject=function(e){return proto.mediapipe.LocationData.BinaryMask.toObject(e,this)},proto.mediapipe.LocationData.BinaryMask.toObject=function(e,r){var o,i={width:null==(o=t.Message.getField(r,1))?void 0:o,height:null==(o=t.Message.getField(r,2))?void 0:o,rasterization:(o=r.getRasterization())&&n.Rasterization.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.LocationData.BinaryMask.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LocationData.BinaryMask;return proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader(o,r)},proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setWidth(r);break;case 2:r=t.readInt32(),e.setHeight(r);break;case 3:r=new n.Rasterization,t.readMessage(r,n.Rasterization.deserializeBinaryFromReader),e.setRasterization(r);break;default:t.skipField()}return e},proto.mediapipe.LocationData.BinaryMask.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=e.getRasterization())&&r.writeMessage(3,o,n.Rasterization.serializeBinaryToWriter)},proto.mediapipe.LocationData.BinaryMask.prototype.getWidth=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.LocationData.BinaryMask.prototype.setWidth=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LocationData.BinaryMask.prototype.clearWidth=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LocationData.BinaryMask.prototype.hasWidth=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LocationData.BinaryMask.prototype.getHeight=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.LocationData.BinaryMask.prototype.setHeight=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.LocationData.BinaryMask.prototype.clearHeight=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.LocationData.BinaryMask.prototype.hasHeight=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LocationData.BinaryMask.prototype.getRasterization=function(){return t.Message.getWrapperField(this,n.Rasterization,3)},proto.mediapipe.LocationData.BinaryMask.prototype.setRasterization=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.LocationData.BinaryMask.prototype.clearRasterization=function(){return this.setRasterization(void 0)},proto.mediapipe.LocationData.BinaryMask.prototype.hasRasterization=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LocationData.RelativeKeypoint.prototype.toObject=function(e){return proto.mediapipe.LocationData.RelativeKeypoint.toObject(e,this)},proto.mediapipe.LocationData.RelativeKeypoint.toObject=function(e,r){var o,n={x:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,y:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,keypointLabel:null==(o=t.Message.getField(r,3))?void 0:o,score:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LocationData.RelativeKeypoint;return proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader(o,r)},proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readFloat();e.setX(r);break;case 2:r=t.readFloat(),e.setY(r);break;case 3:r=t.readString(),e.setKeypointLabel(r);break;case 4:r=t.readFloat(),e.setScore(r);break;default:t.skipField()}return e},proto.mediapipe.LocationData.RelativeKeypoint.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeFloat(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeString(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.getX=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.setX=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearX=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasX=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.getY=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.setY=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearY=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasY=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.getKeypointLabel=function(){return t.Message.getFieldWithDefault(this,3,"")},proto.mediapipe.LocationData.RelativeKeypoint.prototype.setKeypointLabel=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearKeypointLabel=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasKeypointLabel=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.getScore=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.setScore=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearScore=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasScore=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.LocationData.prototype.getFormat=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.LocationData.prototype.setFormat=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LocationData.prototype.clearFormat=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LocationData.prototype.hasFormat=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LocationData.prototype.getBoundingBox=function(){return t.Message.getWrapperField(this,proto.mediapipe.LocationData.BoundingBox,2)},proto.mediapipe.LocationData.prototype.setBoundingBox=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.LocationData.prototype.clearBoundingBox=function(){return this.setBoundingBox(void 0)},proto.mediapipe.LocationData.prototype.hasBoundingBox=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LocationData.prototype.getRelativeBoundingBox=function(){return t.Message.getWrapperField(this,proto.mediapipe.LocationData.RelativeBoundingBox,3)},proto.mediapipe.LocationData.prototype.setRelativeBoundingBox=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.LocationData.prototype.clearRelativeBoundingBox=function(){return this.setRelativeBoundingBox(void 0)},proto.mediapipe.LocationData.prototype.hasRelativeBoundingBox=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.LocationData.prototype.getMask=function(){return t.Message.getWrapperField(this,proto.mediapipe.LocationData.BinaryMask,4)},proto.mediapipe.LocationData.prototype.setMask=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.LocationData.prototype.clearMask=function(){return this.setMask(void 0)},proto.mediapipe.LocationData.prototype.hasMask=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.LocationData.prototype.getRelativeKeypointsList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.LocationData.RelativeKeypoint,5)},proto.mediapipe.LocationData.prototype.setRelativeKeypointsList=function(e){return t.Message.setRepeatedWrapperField(this,5,e)},proto.mediapipe.LocationData.prototype.addRelativeKeypoints=function(e,r){return t.Message.addToRepeatedWrapperField(this,5,e,proto.mediapipe.LocationData.RelativeKeypoint,r)},proto.mediapipe.LocationData.prototype.clearRelativeKeypointsList=function(){return this.setRelativeKeypointsList([])},r.object.extend(e,proto.mediapipe)}(location_data_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=location_data_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.Detection",null,o),r.exportSymbol("proto.mediapipe.Detection.AssociatedDetection",null,o),r.exportSymbol("proto.mediapipe.DetectionList",null,o),proto.mediapipe.Detection=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.Detection.repeatedFields_,null)},r.inherits(proto.mediapipe.Detection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Detection.displayName="proto.mediapipe.Detection"),proto.mediapipe.Detection.AssociatedDetection=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Detection.AssociatedDetection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Detection.AssociatedDetection.displayName="proto.mediapipe.Detection.AssociatedDetection"),proto.mediapipe.DetectionList=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.DetectionList.repeatedFields_,null)},r.inherits(proto.mediapipe.DetectionList,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.DetectionList.displayName="proto.mediapipe.DetectionList"),proto.mediapipe.Detection.repeatedFields_=[1,2,3,8,9],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Detection.prototype.toObject=function(e){return proto.mediapipe.Detection.toObject(e,this)},proto.mediapipe.Detection.toObject=function(e,r){var o,i={labelList:null==(o=t.Message.getRepeatedField(r,1))?void 0:o,labelIdList:null==(o=t.Message.getRepeatedField(r,2))?void 0:o,scoreList:null==(o=t.Message.getRepeatedFloatingPointField(r,3))?void 0:o,locationData:(o=r.getLocationData())&&n.LocationData.toObject(e,o),featureTag:null==(o=t.Message.getField(r,5))?void 0:o,trackId:null==(o=t.Message.getField(r,6))?void 0:o,detectionId:null==(o=t.Message.getField(r,7))?void 0:o,associatedDetectionsList:t.Message.toObjectList(r.getAssociatedDetectionsList(),proto.mediapipe.Detection.AssociatedDetection.toObject,e),displayNameList:null==(o=t.Message.getRepeatedField(r,9))?void 0:o,timestampUsec:null==(o=t.Message.getField(r,10))?void 0:o};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.Detection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Detection;return proto.mediapipe.Detection.deserializeBinaryFromReader(o,r)},proto.mediapipe.Detection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.addLabel(r);break;case 2:for(var o=t.isDelimited()?t.readPackedInt32():[t.readInt32()],i=0;i<o.length;i++)e.addLabelId(o[i]);break;case 3:for(o=t.isDelimited()?t.readPackedFloat():[t.readFloat()],i=0;i<o.length;i++)e.addScore(o[i]);break;case 4:r=new n.LocationData,t.readMessage(r,n.LocationData.deserializeBinaryFromReader),e.setLocationData(r);break;case 5:r=t.readString(),e.setFeatureTag(r);break;case 6:r=t.readString(),e.setTrackId(r);break;case 7:r=t.readInt64(),e.setDetectionId(r);break;case 8:r=new proto.mediapipe.Detection.AssociatedDetection,t.readMessage(r,proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader),e.addAssociatedDetections(r);break;case 9:r=t.readString(),e.addDisplayName(r);break;case 10:r=t.readInt64(),e.setTimestampUsec(r);break;default:t.skipField()}return e},proto.mediapipe.Detection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Detection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Detection.serializeBinaryToWriter=function(e,r){var o=void 0;(o=e.getLabelList()).length>0&&r.writeRepeatedString(1,o),(o=e.getLabelIdList()).length>0&&r.writePackedInt32(2,o),(o=e.getScoreList()).length>0&&r.writePackedFloat(3,o),null!=(o=e.getLocationData())&&r.writeMessage(4,o,n.LocationData.serializeBinaryToWriter),null!=(o=t.Message.getField(e,5))&&r.writeString(5,o),null!=(o=t.Message.getField(e,6))&&r.writeString(6,o),null!=(o=t.Message.getField(e,7))&&r.writeInt64(7,o),(o=e.getAssociatedDetectionsList()).length>0&&r.writeRepeatedMessage(8,o,proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter),(o=e.getDisplayNameList()).length>0&&r.writeRepeatedString(9,o),null!=(o=t.Message.getField(e,10))&&r.writeInt64(10,o)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Detection.AssociatedDetection.prototype.toObject=function(e){return proto.mediapipe.Detection.AssociatedDetection.toObject(e,this)},proto.mediapipe.Detection.AssociatedDetection.toObject=function(e,r){var o,n={id:null==(o=t.Message.getField(r,1))?void 0:o,confidence:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Detection.AssociatedDetection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Detection.AssociatedDetection;return proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader(o,r)},proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setId(r);break;case 2:r=t.readFloat(),e.setConfidence(r);break;default:t.skipField()}return e},proto.mediapipe.Detection.AssociatedDetection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o)},proto.mediapipe.Detection.AssociatedDetection.prototype.getId=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.Detection.AssociatedDetection.prototype.setId=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Detection.AssociatedDetection.prototype.clearId=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Detection.AssociatedDetection.prototype.hasId=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Detection.AssociatedDetection.prototype.getConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.Detection.AssociatedDetection.prototype.setConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Detection.AssociatedDetection.prototype.clearConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Detection.AssociatedDetection.prototype.hasConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Detection.prototype.getLabelList=function(){return t.Message.getRepeatedField(this,1)},proto.mediapipe.Detection.prototype.setLabelList=function(e){return t.Message.setField(this,1,e||[])},proto.mediapipe.Detection.prototype.addLabel=function(e,r){return t.Message.addToRepeatedField(this,1,e,r)},proto.mediapipe.Detection.prototype.clearLabelList=function(){return this.setLabelList([])},proto.mediapipe.Detection.prototype.getLabelIdList=function(){return t.Message.getRepeatedField(this,2)},proto.mediapipe.Detection.prototype.setLabelIdList=function(e){return t.Message.setField(this,2,e||[])},proto.mediapipe.Detection.prototype.addLabelId=function(e,r){return t.Message.addToRepeatedField(this,2,e,r)},proto.mediapipe.Detection.prototype.clearLabelIdList=function(){return this.setLabelIdList([])},proto.mediapipe.Detection.prototype.getScoreList=function(){return t.Message.getRepeatedFloatingPointField(this,3)},proto.mediapipe.Detection.prototype.setScoreList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.Detection.prototype.addScore=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.Detection.prototype.clearScoreList=function(){return this.setScoreList([])},proto.mediapipe.Detection.prototype.getLocationData=function(){return t.Message.getWrapperField(this,n.LocationData,4)},proto.mediapipe.Detection.prototype.setLocationData=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.Detection.prototype.clearLocationData=function(){return this.setLocationData(void 0)},proto.mediapipe.Detection.prototype.hasLocationData=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.Detection.prototype.getFeatureTag=function(){return t.Message.getFieldWithDefault(this,5,"")},proto.mediapipe.Detection.prototype.setFeatureTag=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.Detection.prototype.clearFeatureTag=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.Detection.prototype.hasFeatureTag=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.Detection.prototype.getTrackId=function(){return t.Message.getFieldWithDefault(this,6,"")},proto.mediapipe.Detection.prototype.setTrackId=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.Detection.prototype.clearTrackId=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.Detection.prototype.hasTrackId=function(){return null!=t.Message.getField(this,6)},proto.mediapipe.Detection.prototype.getDetectionId=function(){return t.Message.getFieldWithDefault(this,7,0)},proto.mediapipe.Detection.prototype.setDetectionId=function(e){return t.Message.setField(this,7,e)},proto.mediapipe.Detection.prototype.clearDetectionId=function(){return t.Message.setField(this,7,void 0)},proto.mediapipe.Detection.prototype.hasDetectionId=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.Detection.prototype.getAssociatedDetectionsList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.Detection.AssociatedDetection,8)},proto.mediapipe.Detection.prototype.setAssociatedDetectionsList=function(e){return t.Message.setRepeatedWrapperField(this,8,e)},proto.mediapipe.Detection.prototype.addAssociatedDetections=function(e,r){return t.Message.addToRepeatedWrapperField(this,8,e,proto.mediapipe.Detection.AssociatedDetection,r)},proto.mediapipe.Detection.prototype.clearAssociatedDetectionsList=function(){return this.setAssociatedDetectionsList([])},proto.mediapipe.Detection.prototype.getDisplayNameList=function(){return t.Message.getRepeatedField(this,9)},proto.mediapipe.Detection.prototype.setDisplayNameList=function(e){return t.Message.setField(this,9,e||[])},proto.mediapipe.Detection.prototype.addDisplayName=function(e,r){return t.Message.addToRepeatedField(this,9,e,r)},proto.mediapipe.Detection.prototype.clearDisplayNameList=function(){return this.setDisplayNameList([])},proto.mediapipe.Detection.prototype.getTimestampUsec=function(){return t.Message.getFieldWithDefault(this,10,0)},proto.mediapipe.Detection.prototype.setTimestampUsec=function(e){return t.Message.setField(this,10,e)},proto.mediapipe.Detection.prototype.clearTimestampUsec=function(){return t.Message.setField(this,10,void 0)},proto.mediapipe.Detection.prototype.hasTimestampUsec=function(){return null!=t.Message.getField(this,10)},proto.mediapipe.DetectionList.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.DetectionList.prototype.toObject=function(e){return proto.mediapipe.DetectionList.toObject(e,this)},proto.mediapipe.DetectionList.toObject=function(e,r){var o={detectionList:t.Message.toObjectList(r.getDetectionList(),proto.mediapipe.Detection.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.DetectionList.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.DetectionList;return proto.mediapipe.DetectionList.deserializeBinaryFromReader(o,r)},proto.mediapipe.DetectionList.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.Detection;t.readMessage(r,proto.mediapipe.Detection.deserializeBinaryFromReader),e.addDetection(r)}else t.skipField();return e},proto.mediapipe.DetectionList.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.DetectionList.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.DetectionList.serializeBinaryToWriter=function(e,t){var r;(r=e.getDetectionList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.Detection.serializeBinaryToWriter)},proto.mediapipe.DetectionList.prototype.getDetectionList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.Detection,1)},proto.mediapipe.DetectionList.prototype.setDetectionList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.DetectionList.prototype.addDetection=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.Detection,r)},proto.mediapipe.DetectionList.prototype.clearDetectionList=function(){return this.setDetectionList([])},r.object.extend(e,proto.mediapipe)}(detection_pb);var base_options_pb={},acceleration_pb={},inference_calculator_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.DelegateCase",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.Api",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.InferenceUsage",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite",null,o),r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack",null,o),proto.mediapipe.InferenceCalculatorOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InferenceCalculatorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.displayName="proto.mediapipe.InferenceCalculatorOptions"),proto.mediapipe.InferenceCalculatorOptions.Delegate=function(e){t.Message.initialize(this,e,0,-1,null,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_)},r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.displayName="proto.mediapipe.InferenceCalculatorOptions.Delegate"),proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.displayName="proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite"),proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.displayName="proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu"),proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.displayName="proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi"),proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.displayName="proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.toObject=function(e,r){var o,n={modelPath:null==(o=t.Message.getField(r,1))?void 0:o,useGpu:t.Message.getBooleanFieldWithDefault(r,2,!1),useNnapi:t.Message.getBooleanFieldWithDefault(r,3,!1),cpuNumThread:t.Message.getFieldWithDefault(r,4,-1),delegate:(o=r.getDelegate())&&proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.InferenceCalculatorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions;return proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setModelPath(r);break;case 2:r=t.readBool(),e.setUseGpu(r);break;case 3:r=t.readBool(),e.setUseNnapi(r);break;case 4:r=t.readInt32(),e.setCpuNumThread(r);break;case 5:r=new proto.mediapipe.InferenceCalculatorOptions.Delegate,t.readMessage(r,proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader),e.setDelegate(r);break;default:t.skipField()}return e},proto.mediapipe.InferenceCalculatorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeBool(2,o),null!=(o=t.Message.getField(e,3))&&r.writeBool(3,o),null!=(o=t.Message.getField(e,4))&&r.writeInt32(4,o),null!=(o=e.getDelegate())&&r.writeMessage(5,o,proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter)},proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_=[[1,2,3,4]],proto.mediapipe.InferenceCalculatorOptions.Delegate.DelegateCase={DELEGATE_NOT_SET:0,TFLITE:1,GPU:2,NNAPI:3,XNNPACK:4},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getDelegateCase=function(){return t.Message.computeOneofCase(this,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject=function(e,t){var r,o={tflite:(r=t.getTflite())&&proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject(e,r),gpu:(r=t.getGpu())&&proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject(e,r),nnapi:(r=t.getNnapi())&&proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e,r),xnnpack:(r=t.getXnnpack())&&proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions.Delegate;return proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite;t.readMessage(r,proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader),e.setTflite(r);break;case 2:r=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu,t.readMessage(r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader),e.setGpu(r);break;case 3:r=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi,t.readMessage(r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader),e.setNnapi(r);break;case 4:r=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack,t.readMessage(r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader),e.setXnnpack(r);break;default:t.skipField()}return e},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getTflite())&&t.writeMessage(1,r,proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter),null!=(r=e.getGpu())&&t.writeMessage(2,r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter),null!=(r=e.getNnapi())&&t.writeMessage(3,r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter),null!=(r=e.getXnnpack())&&t.writeMessage(4,r,proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject=function(e,t){var r={};return e&&(r.$jspbMessageInstance=t),r}),proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite;return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)t.getFieldNumber(),t.skipField();return e},proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter=function(e,t){},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject=function(e,r){var o,n={useAdvancedGpuApi:t.Message.getBooleanFieldWithDefault(r,1,!1),api:t.Message.getFieldWithDefault(r,4,0),allowPrecisionLoss:t.Message.getBooleanFieldWithDefault(r,3,!0),cachedKernelPath:null==(o=t.Message.getField(r,2))?void 0:o,serializedModelDir:null==(o=t.Message.getField(r,7))?void 0:o,modelToken:null==(o=t.Message.getField(r,8))?void 0:o,usage:t.Message.getFieldWithDefault(r,5,2)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBool();e.setUseAdvancedGpuApi(r);break;case 4:r=t.readEnum(),e.setApi(r);break;case 3:r=t.readBool(),e.setAllowPrecisionLoss(r);break;case 2:r=t.readString(),e.setCachedKernelPath(r);break;case 7:r=t.readString(),e.setSerializedModelDir(r);break;case 8:r=t.readString(),e.setModelToken(r);break;case 5:r=t.readEnum(),e.setUsage(r);break;default:t.skipField()}return e},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeBool(1,o),null!=(o=t.Message.getField(e,4))&&r.writeEnum(4,o),null!=(o=t.Message.getField(e,3))&&r.writeBool(3,o),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=t.Message.getField(e,7))&&r.writeString(7,o),null!=(o=t.Message.getField(e,8))&&r.writeString(8,o),null!=(o=t.Message.getField(e,5))&&r.writeEnum(5,o)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.Api={ANY:0,OPENGL:1,OPENCL:2},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.InferenceUsage={UNSPECIFIED:0,FAST_SINGLE_ANSWER:1,SUSTAINED_SPEED:2},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getUseAdvancedGpuApi=function(){return t.Message.getBooleanFieldWithDefault(this,1,!1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setUseAdvancedGpuApi=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearUseAdvancedGpuApi=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasUseAdvancedGpuApi=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getApi=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setApi=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearApi=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasApi=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getAllowPrecisionLoss=function(){return t.Message.getBooleanFieldWithDefault(this,3,!0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setAllowPrecisionLoss=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearAllowPrecisionLoss=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasAllowPrecisionLoss=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getCachedKernelPath=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setCachedKernelPath=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearCachedKernelPath=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasCachedKernelPath=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getSerializedModelDir=function(){return t.Message.getFieldWithDefault(this,7,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setSerializedModelDir=function(e){return t.Message.setField(this,7,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearSerializedModelDir=function(){return t.Message.setField(this,7,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasSerializedModelDir=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getModelToken=function(){return t.Message.getFieldWithDefault(this,8,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setModelToken=function(e){return t.Message.setField(this,8,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearModelToken=function(){return t.Message.setField(this,8,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasModelToken=function(){return null!=t.Message.getField(this,8)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getUsage=function(){return t.Message.getFieldWithDefault(this,5,2)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setUsage=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearUsage=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasUsage=function(){return null!=t.Message.getField(this,5)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject=function(e,r){var o,n={cacheDir:null==(o=t.Message.getField(r,1))?void 0:o,modelToken:null==(o=t.Message.getField(r,2))?void 0:o,acceleratorName:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setCacheDir(r);break;case 2:r=t.readString(),e.setModelToken(r);break;case 3:r=t.readString(),e.setAcceleratorName(r);break;default:t.skipField()}return e},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=t.Message.getField(e,3))&&r.writeString(3,o)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getCacheDir=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setCacheDir=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearCacheDir=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasCacheDir=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getModelToken=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setModelToken=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearModelToken=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasModelToken=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getAcceleratorName=function(){return t.Message.getFieldWithDefault(this,3,"")},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setAcceleratorName=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearAcceleratorName=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasAcceleratorName=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.toObject=function(e){return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e,this)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject=function(e,r){var o={numThreads:t.Message.getFieldWithDefault(r,1,-1)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader(o,r)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readInt32();e.setNumThreads(r)}else t.skipField();return e},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter=function(e,r){var o;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.getNumThreads=function(){return t.Message.getFieldWithDefault(this,1,-1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.setNumThreads=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.clearNumThreads=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.hasNumThreads=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getTflite=function(){return t.Message.getWrapperField(this,proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite,1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setTflite=function(e){return t.Message.setOneofWrapperField(this,1,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0],e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearTflite=function(){return this.setTflite(void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasTflite=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getGpu=function(){return t.Message.getWrapperField(this,proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu,2)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setGpu=function(e){return t.Message.setOneofWrapperField(this,2,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0],e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearGpu=function(){return this.setGpu(void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasGpu=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getNnapi=function(){return t.Message.getWrapperField(this,proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi,3)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setNnapi=function(e){return t.Message.setOneofWrapperField(this,3,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0],e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearNnapi=function(){return this.setNnapi(void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasNnapi=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getXnnpack=function(){return t.Message.getWrapperField(this,proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack,4)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setXnnpack=function(e){return t.Message.setOneofWrapperField(this,4,proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0],e)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearXnnpack=function(){return this.setXnnpack(void 0)},proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasXnnpack=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.InferenceCalculatorOptions.ext=new t.ExtensionFieldInfo(336783863,{ext:0},proto.mediapipe.InferenceCalculatorOptions,proto.mediapipe.InferenceCalculatorOptions.toObject,0),i.CalculatorOptions.extensionsBinary[336783863]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.InferenceCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[336783863]=proto.mediapipe.InferenceCalculatorOptions.ext,proto.mediapipe.InferenceCalculatorOptions.prototype.getModelPath=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.InferenceCalculatorOptions.prototype.setModelPath=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.InferenceCalculatorOptions.prototype.clearModelPath=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.InferenceCalculatorOptions.prototype.hasModelPath=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.InferenceCalculatorOptions.prototype.getUseGpu=function(){return t.Message.getBooleanFieldWithDefault(this,2,!1)},proto.mediapipe.InferenceCalculatorOptions.prototype.setUseGpu=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.InferenceCalculatorOptions.prototype.clearUseGpu=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.InferenceCalculatorOptions.prototype.hasUseGpu=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.InferenceCalculatorOptions.prototype.getUseNnapi=function(){return t.Message.getBooleanFieldWithDefault(this,3,!1)},proto.mediapipe.InferenceCalculatorOptions.prototype.setUseNnapi=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.InferenceCalculatorOptions.prototype.clearUseNnapi=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.InferenceCalculatorOptions.prototype.hasUseNnapi=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.InferenceCalculatorOptions.prototype.getCpuNumThread=function(){return t.Message.getFieldWithDefault(this,4,-1)},proto.mediapipe.InferenceCalculatorOptions.prototype.setCpuNumThread=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.InferenceCalculatorOptions.prototype.clearCpuNumThread=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.InferenceCalculatorOptions.prototype.hasCpuNumThread=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.InferenceCalculatorOptions.prototype.getDelegate=function(){return t.Message.getWrapperField(this,proto.mediapipe.InferenceCalculatorOptions.Delegate,5)},proto.mediapipe.InferenceCalculatorOptions.prototype.setDelegate=function(e){return t.Message.setWrapperField(this,5,e)},proto.mediapipe.InferenceCalculatorOptions.prototype.clearDelegate=function(){return this.setDelegate(void 0)},proto.mediapipe.InferenceCalculatorOptions.prototype.hasDelegate=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.InferenceCalculatorOptions.ext=new t.ExtensionFieldInfo(336783863,{ext:0},proto.mediapipe.InferenceCalculatorOptions,proto.mediapipe.InferenceCalculatorOptions.toObject,0),i.CalculatorOptions.extensionsBinary[336783863]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.InferenceCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[336783863]=proto.mediapipe.InferenceCalculatorOptions.ext,r.object.extend(e,proto.mediapipe)}(inference_calculator_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=inference_calculator_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.tasks.core.proto.Acceleration",null,o),r.exportSymbol("proto.mediapipe.tasks.core.proto.Acceleration.DelegateCase",null,o),proto.mediapipe.tasks.core.proto.Acceleration=function(e){t.Message.initialize(this,e,0,-1,null,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_)},r.inherits(proto.mediapipe.tasks.core.proto.Acceleration,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.core.proto.Acceleration.displayName="proto.mediapipe.tasks.core.proto.Acceleration"),proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_=[[1,2,4,5]],proto.mediapipe.tasks.core.proto.Acceleration.DelegateCase={DELEGATE_NOT_SET:0,XNNPACK:1,GPU:2,TFLITE:4,NNAPI:5},proto.mediapipe.tasks.core.proto.Acceleration.prototype.getDelegateCase=function(){return t.Message.computeOneofCase(this,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.core.proto.Acceleration.prototype.toObject=function(e){return proto.mediapipe.tasks.core.proto.Acceleration.toObject(e,this)},proto.mediapipe.tasks.core.proto.Acceleration.toObject=function(e,t){var r,o={xnnpack:(r=t.getXnnpack())&&n.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e,r),gpu:(r=t.getGpu())&&n.InferenceCalculatorOptions.Delegate.Gpu.toObject(e,r),tflite:(r=t.getTflite())&&n.InferenceCalculatorOptions.Delegate.TfLite.toObject(e,r),nnapi:(r=t.getNnapi())&&n.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.core.proto.Acceleration;return proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new n.InferenceCalculatorOptions.Delegate.Xnnpack;t.readMessage(r,n.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader),e.setXnnpack(r);break;case 2:r=new n.InferenceCalculatorOptions.Delegate.Gpu,t.readMessage(r,n.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader),e.setGpu(r);break;case 4:r=new n.InferenceCalculatorOptions.Delegate.TfLite,t.readMessage(r,n.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader),e.setTflite(r);break;case 5:r=new n.InferenceCalculatorOptions.Delegate.Nnapi,t.readMessage(r,n.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader),e.setNnapi(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.core.proto.Acceleration.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.core.proto.Acceleration.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.core.proto.Acceleration.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getXnnpack())&&t.writeMessage(1,r,n.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter),null!=(r=e.getGpu())&&t.writeMessage(2,r,n.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter),null!=(r=e.getTflite())&&t.writeMessage(4,r,n.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter),null!=(r=e.getNnapi())&&t.writeMessage(5,r,n.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.getXnnpack=function(){return t.Message.getWrapperField(this,n.InferenceCalculatorOptions.Delegate.Xnnpack,1)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.setXnnpack=function(e){return t.Message.setOneofWrapperField(this,1,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0],e)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearXnnpack=function(){return this.setXnnpack(void 0)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasXnnpack=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.getGpu=function(){return t.Message.getWrapperField(this,n.InferenceCalculatorOptions.Delegate.Gpu,2)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.setGpu=function(e){return t.Message.setOneofWrapperField(this,2,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0],e)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearGpu=function(){return this.setGpu(void 0)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasGpu=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.getTflite=function(){return t.Message.getWrapperField(this,n.InferenceCalculatorOptions.Delegate.TfLite,4)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.setTflite=function(e){return t.Message.setOneofWrapperField(this,4,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0],e)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearTflite=function(){return this.setTflite(void 0)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasTflite=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.getNnapi=function(){return t.Message.getWrapperField(this,n.InferenceCalculatorOptions.Delegate.Nnapi,5)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.setNnapi=function(e){return t.Message.setOneofWrapperField(this,5,proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0],e)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearNnapi=function(){return this.setNnapi(void 0)},proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasNnapi=function(){return null!=t.Message.getField(this,5)},r.object.extend(e,proto.mediapipe.tasks.core.proto)}(acceleration_pb);var external_file_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.core.proto.ExternalFile",null,o),r.exportSymbol("proto.mediapipe.tasks.core.proto.FileDescriptorMeta",null,o),r.exportSymbol("proto.mediapipe.tasks.core.proto.FilePointerMeta",null,o),proto.mediapipe.tasks.core.proto.ExternalFile=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.core.proto.ExternalFile,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.core.proto.ExternalFile.displayName="proto.mediapipe.tasks.core.proto.ExternalFile"),proto.mediapipe.tasks.core.proto.FileDescriptorMeta=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.core.proto.FileDescriptorMeta,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.core.proto.FileDescriptorMeta.displayName="proto.mediapipe.tasks.core.proto.FileDescriptorMeta"),proto.mediapipe.tasks.core.proto.FilePointerMeta=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.core.proto.FilePointerMeta,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.core.proto.FilePointerMeta.displayName="proto.mediapipe.tasks.core.proto.FilePointerMeta"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.core.proto.ExternalFile.prototype.toObject=function(e){return proto.mediapipe.tasks.core.proto.ExternalFile.toObject(e,this)},proto.mediapipe.tasks.core.proto.ExternalFile.toObject=function(e,r){var o,n={fileContent:r.getFileContent_asB64(),fileName:null==(o=t.Message.getField(r,2))?void 0:o,fileDescriptorMeta:(o=r.getFileDescriptorMeta())&&proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject(e,o),filePointerMeta:(o=r.getFilePointerMeta())&&proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.core.proto.ExternalFile;return proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setFileContent(r);break;case 2:r=t.readString(),e.setFileName(r);break;case 3:r=new proto.mediapipe.tasks.core.proto.FileDescriptorMeta,t.readMessage(r,proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader),e.setFileDescriptorMeta(r);break;case 4:r=new proto.mediapipe.tasks.core.proto.FilePointerMeta,t.readMessage(r,proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader),e.setFilePointerMeta(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.core.proto.ExternalFile.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.core.proto.ExternalFile.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeBytes(1,o),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=e.getFileDescriptorMeta())&&r.writeMessage(3,o,proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter),null!=(o=e.getFilePointerMeta())&&r.writeMessage(4,o,proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent_asB64=function(){return t.Message.bytesAsB64(this.getFileContent())},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent_asU8=function(){return t.Message.bytesAsU8(this.getFileContent())},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileContent=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileContent=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileContent=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileName=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileName=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileName=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileName=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileDescriptorMeta=function(){return t.Message.getWrapperField(this,proto.mediapipe.tasks.core.proto.FileDescriptorMeta,3)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileDescriptorMeta=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileDescriptorMeta=function(){return this.setFileDescriptorMeta(void 0)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileDescriptorMeta=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFilePointerMeta=function(){return t.Message.getWrapperField(this,proto.mediapipe.tasks.core.proto.FilePointerMeta,4)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFilePointerMeta=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFilePointerMeta=function(){return this.setFilePointerMeta(void 0)},proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFilePointerMeta=function(){return null!=t.Message.getField(this,4)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.toObject=function(e){return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject(e,this)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject=function(e,r){var o,n={fd:null==(o=t.Message.getField(r,1))?void 0:o,length:null==(o=t.Message.getField(r,2))?void 0:o,offset:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.core.proto.FileDescriptorMeta;return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setFd(r);break;case 2:r=t.readInt64(),e.setLength(r);break;case 3:r=t.readInt64(),e.setOffset(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt64(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt64(3,o)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getFd=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setFd=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearFd=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasFd=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getLength=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setLength=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearLength=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasLength=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getOffset=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setOffset=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearOffset=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasOffset=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.toObject=function(e){return proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject(e,this)},proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject=function(e,r){var o,n={pointer:null==(o=t.Message.getField(r,1))?void 0:o,length:null==(o=t.Message.getField(r,2))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.core.proto.FilePointerMeta;return proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readUint64();e.setPointer(r);break;case 2:r=t.readInt64(),e.setLength(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeUint64(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt64(2,o)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.getPointer=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.setPointer=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.clearPointer=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.hasPointer=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.getLength=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.setLength=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.clearLength=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.hasLength=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.core.proto)}(external_file_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=acceleration_pb;r.object.extend(proto,n);var i=external_file_pb;r.object.extend(proto,i),r.exportSymbol("proto.mediapipe.tasks.core.proto.BaseOptions",null,o),proto.mediapipe.tasks.core.proto.BaseOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.core.proto.BaseOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.core.proto.BaseOptions.displayName="proto.mediapipe.tasks.core.proto.BaseOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.core.proto.BaseOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.core.proto.BaseOptions.toObject(e,this)},proto.mediapipe.tasks.core.proto.BaseOptions.toObject=function(e,r){var o,a={modelAsset:(o=r.getModelAsset())&&i.ExternalFile.toObject(e,o),useStreamMode:t.Message.getBooleanFieldWithDefault(r,2,!1),acceleration:(o=r.getAcceleration())&&n.Acceleration.toObject(e,o)};return e&&(a.$jspbMessageInstance=r),a}),proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.core.proto.BaseOptions;return proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new i.ExternalFile;t.readMessage(r,i.ExternalFile.deserializeBinaryFromReader),e.setModelAsset(r);break;case 2:r=t.readBool(),e.setUseStreamMode(r);break;case 3:r=new n.Acceleration,t.readMessage(r,n.Acceleration.deserializeBinaryFromReader),e.setAcceleration(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.core.proto.BaseOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.core.proto.BaseOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getModelAsset())&&r.writeMessage(1,o,i.ExternalFile.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeBool(2,o),null!=(o=e.getAcceleration())&&r.writeMessage(3,o,n.Acceleration.serializeBinaryToWriter)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getModelAsset=function(){return t.Message.getWrapperField(this,i.ExternalFile,1)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setModelAsset=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearModelAsset=function(){return this.setModelAsset(void 0)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasModelAsset=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getUseStreamMode=function(){return t.Message.getBooleanFieldWithDefault(this,2,!1)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setUseStreamMode=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearUseStreamMode=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasUseStreamMode=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getAcceleration=function(){return t.Message.getWrapperField(this,n.Acceleration,3)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setAcceleration=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearAcceleration=function(){return this.setAcceleration(void 0)},proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasAcceleration=function(){return null!=t.Message.getField(this,3)},r.object.extend(e,proto.mediapipe.tasks.core.proto)}(base_options_pb);var face_detector_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5),minSuppressionThreshold:t.Message.getFloatingPointFieldWithDefault(r,3,.5),numFaces:null==(o=t.Message.getField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions;return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;case 3:r=t.readFloat(),e.setMinSuppressionThreshold(r);break;case 4:r=t.readInt32(),e.setNumFaces(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeInt32(4,o)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext=new t.ExtensionFieldInfo(502141897,{ext:0},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[502141897]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[502141897]=proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getMinSuppressionThreshold=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,.5)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setMinSuppressionThreshold=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearMinSuppressionThreshold=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasMinSuppressionThreshold=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getNumFaces=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setNumFaces=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearNumFaces=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasNumFaces=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext=new t.ExtensionFieldInfo(502141897,{ext:0},proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[502141897]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[502141897]=proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_detector.proto)}(face_detector_graph_options_pb);var detection_result={};Object.defineProperty(detection_result,"__esModule",{value:!0}),detection_result.convertFromDetectionProto=void 0;const DEFAULT_CATEGORY_INDEX=-1;function convertFromDetectionProto(e){var t,r,o,n,i,a,s,p,c,l,d,u,g;const f=e.getScoreList(),m=e.getLabelIdList(),h=e.getLabelList(),y=e.getDisplayNameList(),b={categories:[],keypoints:[]};for(let e=0;e<f.length;e++)b.categories.push({score:f[e],index:null!==(t=m[e])&&void 0!==t?t:DEFAULT_CATEGORY_INDEX,categoryName:null!==(r=h[e])&&void 0!==r?r:"",displayName:null!==(o=y[e])&&void 0!==o?o:""});const v=null===(n=e.getLocationData())||void 0===n?void 0:n.getBoundingBox();if(v&&(b.boundingBox={originX:null!==(i=v.getXmin())&&void 0!==i?i:0,originY:null!==(a=v.getYmin())&&void 0!==a?a:0,width:null!==(s=v.getWidth())&&void 0!==s?s:0,height:null!==(p=v.getHeight())&&void 0!==p?p:0,angle:0}),null===(c=e.getLocationData())||void 0===c?void 0:c.getRelativeKeypointsList().length)for(const t of e.getLocationData().getRelativeKeypointsList())b.keypoints.push({x:null!==(l=t.getX())&&void 0!==l?l:0,y:null!==(d=t.getY())&&void 0!==d?d:0,score:null!==(u=t.getScore())&&void 0!==u?u:0,label:null!==(g=t.getKeypointLabel())&&void 0!==g?g:""});return b}detection_result.convertFromDetectionProto=convertFromDetectionProto;var vision_task_runner={},rect_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.NormalizedRect",null,o),r.exportSymbol("proto.mediapipe.Rect",null,o),proto.mediapipe.Rect=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Rect,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Rect.displayName="proto.mediapipe.Rect"),proto.mediapipe.NormalizedRect=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.NormalizedRect,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.NormalizedRect.displayName="proto.mediapipe.NormalizedRect"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Rect.prototype.toObject=function(e){return proto.mediapipe.Rect.toObject(e,this)},proto.mediapipe.Rect.toObject=function(e,r){var o,n={xCenter:null==(o=t.Message.getField(r,1))?void 0:o,yCenter:null==(o=t.Message.getField(r,2))?void 0:o,height:null==(o=t.Message.getField(r,3))?void 0:o,width:null==(o=t.Message.getField(r,4))?void 0:o,rotation:t.Message.getFloatingPointFieldWithDefault(r,5,0),rectId:null==(o=t.Message.getField(r,6))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Rect.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Rect;return proto.mediapipe.Rect.deserializeBinaryFromReader(o,r)},proto.mediapipe.Rect.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setXCenter(r);break;case 2:r=t.readInt32(),e.setYCenter(r);break;case 3:r=t.readInt32(),e.setHeight(r);break;case 4:r=t.readInt32(),e.setWidth(r);break;case 5:r=t.readFloat(),e.setRotation(r);break;case 6:r=t.readInt64(),e.setRectId(r);break;default:t.skipField()}return e},proto.mediapipe.Rect.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Rect.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Rect.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o),null!=(o=t.Message.getField(e,4))&&r.writeInt32(4,o),null!=(o=t.Message.getField(e,5))&&r.writeFloat(5,o),null!=(o=t.Message.getField(e,6))&&r.writeInt64(6,o)},proto.mediapipe.Rect.prototype.getXCenter=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.Rect.prototype.setXCenter=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Rect.prototype.clearXCenter=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Rect.prototype.hasXCenter=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Rect.prototype.getYCenter=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.Rect.prototype.setYCenter=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Rect.prototype.clearYCenter=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Rect.prototype.hasYCenter=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Rect.prototype.getHeight=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.Rect.prototype.setHeight=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.Rect.prototype.clearHeight=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.Rect.prototype.hasHeight=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.Rect.prototype.getWidth=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.Rect.prototype.setWidth=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.Rect.prototype.clearWidth=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.Rect.prototype.hasWidth=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.Rect.prototype.getRotation=function(){return t.Message.getFloatingPointFieldWithDefault(this,5,0)},proto.mediapipe.Rect.prototype.setRotation=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.Rect.prototype.clearRotation=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.Rect.prototype.hasRotation=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.Rect.prototype.getRectId=function(){return t.Message.getFieldWithDefault(this,6,0)},proto.mediapipe.Rect.prototype.setRectId=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.Rect.prototype.clearRectId=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.Rect.prototype.hasRectId=function(){return null!=t.Message.getField(this,6)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.NormalizedRect.prototype.toObject=function(e){return proto.mediapipe.NormalizedRect.toObject(e,this)},proto.mediapipe.NormalizedRect.toObject=function(e,r){var o,n={xCenter:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,yCenter:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,height:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,width:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,rotation:t.Message.getFloatingPointFieldWithDefault(r,5,0),rectId:null==(o=t.Message.getField(r,6))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.NormalizedRect.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.NormalizedRect;return proto.mediapipe.NormalizedRect.deserializeBinaryFromReader(o,r)},proto.mediapipe.NormalizedRect.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readFloat();e.setXCenter(r);break;case 2:r=t.readFloat(),e.setYCenter(r);break;case 3:r=t.readFloat(),e.setHeight(r);break;case 4:r=t.readFloat(),e.setWidth(r);break;case 5:r=t.readFloat(),e.setRotation(r);break;case 6:r=t.readInt64(),e.setRectId(r);break;default:t.skipField()}return e},proto.mediapipe.NormalizedRect.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.NormalizedRect.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.NormalizedRect.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeFloat(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o),null!=(o=t.Message.getField(e,5))&&r.writeFloat(5,o),null!=(o=t.Message.getField(e,6))&&r.writeInt64(6,o)},proto.mediapipe.NormalizedRect.prototype.getXCenter=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.NormalizedRect.prototype.setXCenter=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.NormalizedRect.prototype.clearXCenter=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.NormalizedRect.prototype.hasXCenter=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.NormalizedRect.prototype.getYCenter=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.NormalizedRect.prototype.setYCenter=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.NormalizedRect.prototype.clearYCenter=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.NormalizedRect.prototype.hasYCenter=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.NormalizedRect.prototype.getHeight=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.NormalizedRect.prototype.setHeight=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.NormalizedRect.prototype.clearHeight=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.NormalizedRect.prototype.hasHeight=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.NormalizedRect.prototype.getWidth=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.NormalizedRect.prototype.setWidth=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.NormalizedRect.prototype.clearWidth=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.NormalizedRect.prototype.hasWidth=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.NormalizedRect.prototype.getRotation=function(){return t.Message.getFloatingPointFieldWithDefault(this,5,0)},proto.mediapipe.NormalizedRect.prototype.setRotation=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.NormalizedRect.prototype.clearRotation=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.NormalizedRect.prototype.hasRotation=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.NormalizedRect.prototype.getRectId=function(){return t.Message.getFieldWithDefault(this,6,0)},proto.mediapipe.NormalizedRect.prototype.setRectId=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.NormalizedRect.prototype.clearRectId=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.NormalizedRect.prototype.hasRectId=function(){return null!=t.Message.getField(this,6)},r.object.extend(e,proto.mediapipe)}(rect_pb);var task_runner={},graph_runner={};!function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.createGraphRunner=e.createMediaPipeLib=e.GraphRunner=e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME=void 0;const t=platform_utils;e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME="__graph_config__";class r{constructor(e,r){this.autoResizeCanvas=!0,this.wasmModule=e,this.audioPtr=null,this.audioSize=0,this.hasMultiStreamSupport="function"==typeof this.wasmModule._addIntToInputStream,void 0!==r?this.wasmModule.canvas=r:"undefined"==typeof OffscreenCanvas||(0,t.isWebKit)()?(console.warn("OffscreenCanvas not supported and GraphRunner constructor glCanvas parameter is undefined. Creating backup canvas."),this.wasmModule.canvas=document.createElement("canvas")):this.wasmModule.canvas=new OffscreenCanvas(1,1)}async initializeGraph(e){const t=await fetch(e),r=await t.arrayBuffer(),o=!(e.endsWith(".pbtxt")||e.endsWith(".textproto"));this.setGraph(new Uint8Array(r),o)}setGraphFromString(e){this.setGraph((new TextEncoder).encode(e),!1)}setGraph(e,t){const r=e.length,o=this.wasmModule._malloc(r);this.wasmModule.HEAPU8.set(e,o),t?this.wasmModule._changeBinaryGraph(r,o):this.wasmModule._changeTextGraph(r,o),this.wasmModule._free(o)}configureAudio(e,t,r,o,n){this.wasmModule._configureAudio||console.warn('Attempting to use configureAudio without support for input audio. Is build dep ":gl_graph_runner_audio" missing?'),o=o||"input_audio",this.wrapStringPtr(o,o=>{n=n||"audio_header",this.wrapStringPtr(n,n=>{this.wasmModule._configureAudio(o,n,e,t,r)})})}setAutoResizeCanvas(e){this.autoResizeCanvas=e}setAutoRenderToScreen(e){this.wasmModule._setAutoRenderToScreen(e)}bindTextureToStream(e,t){if(!this.wasmModule.canvas)throw new Error("No OpenGL canvas configured.");t?this.wasmModule._bindTextureToStream(t):console.assert(this.wasmModule._bindTextureToCanvas());const r=this.wasmModule.canvas.getContext("webgl2")||this.wasmModule.canvas.getContext("webgl");if(!r)throw new Error("Failed to obtain WebGL context from the provided canvas. `getContext()` should only be invoked with `webgl` or `webgl2`.");let o,n;return r.texImage2D(r.TEXTURE_2D,0,r.RGBA,r.RGBA,r.UNSIGNED_BYTE,e),e.videoWidth?(o=e.videoWidth,n=e.videoHeight):e.naturalWidth?(o=e.naturalWidth,n=e.naturalHeight):(o=e.width,n=e.height),!this.autoResizeCanvas||o===this.wasmModule.canvas.width&&n===this.wasmModule.canvas.height||(this.wasmModule.canvas.width=o,this.wasmModule.canvas.height=n),[o,n]}processGl(e,t){const[r,o]=this.bindTextureToStream(e),n=this.wasmModule._malloc(16);this.wasmModule.HEAPU32[n/4]=r,this.wasmModule.HEAPU32[n/4+1]=o,this.wasmModule.HEAPF64[n/8+1]=t,this.wasmModule._processGl(n),this.wasmModule._free(n)}wrapStringPtr(e,t){this.hasMultiStreamSupport||console.error("No wasm multistream support detected: ensure dependency inclusion of :gl_graph_runner_internal_multi_input target");const r=this.wasmModule.stringToNewUTF8(e);t(r),this.wasmModule._free(r)}wrapStringPtrPtr(e,t){this.hasMultiStreamSupport||console.error("No wasm multistream support detected: ensure dependency inclusion of :gl_graph_runner_internal_multi_input target");const r=new Uint32Array(e.length);for(let t=0;t<e.length;t++)r[t]=this.wasmModule.stringToNewUTF8(e[t]);const o=this.wasmModule._malloc(4*r.length);this.wasmModule.HEAPU32.set(r,o>>2),t(o);for(const e of r)this.wasmModule._free(e);this.wasmModule._free(o)}getCalculatorGraphConfig(t,r){const o=e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME;this.setListener(o,e=>{t(e)}),this.wrapStringPtr(o,e=>{this.wasmModule._getGraphConfig(e,r)}),delete this.wasmModule.simpleListeners[o]}setListener(e,t){this.wasmModule.simpleListeners=this.wasmModule.simpleListeners||{},this.wasmModule.simpleListeners[e]=t}setVectorListener(e,t){let r=[];this.wasmModule.simpleListeners=this.wasmModule.simpleListeners||{},this.wasmModule.simpleListeners[e]=(e,o,n)=>{o?(t(r,n),r=[]):r.push(e)}}attachErrorListener(e){this.wasmModule.errorListener=e}attachEmptyPacketListener(e,t){this.wasmModule.emptyPacketListeners=this.wasmModule.emptyPacketListeners||{},this.wasmModule.emptyPacketListeners[e]=t}addAudioToStream(e,t,r){this.addAudioToStreamWithShape(e,0,0,t,r)}addAudioToStreamWithShape(e,t,r,o,n){const i=4*e.length;this.audioSize!==i&&(this.audioPtr&&this.wasmModule._free(this.audioPtr),this.audioPtr=this.wasmModule._malloc(i),this.audioSize=i),this.wasmModule.HEAPF32.set(e,this.audioPtr/4),this.wrapStringPtr(o,e=>{this.wasmModule._addAudioToInputStream(this.audioPtr,t,r,e,n)})}addGpuBufferToStream(e,t,r){this.wrapStringPtr(t,t=>{const[o,n]=this.bindTextureToStream(e,t);this.wasmModule._addBoundTextureToStream(t,o,n,r)})}addBoolToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wasmModule._addBoolToInputStream(e,t,r)})}addDoubleToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wasmModule._addDoubleToInputStream(e,t,r)})}addFloatToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wasmModule._addFloatToInputStream(e,t,r)})}addIntToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wasmModule._addIntToInputStream(e,t,r)})}addStringToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wrapStringPtr(e,e=>{this.wasmModule._addStringToInputStream(e,t,r)})})}addStringRecordToStream(e,t,r){this.wrapStringPtr(t,t=>{this.wrapStringPtrPtr(Object.keys(e),o=>{this.wrapStringPtrPtr(Object.values(e),n=>{this.wasmModule._addFlatHashMapToInputStream(o,n,Object.keys(e).length,t,r)})})})}addProtoToStream(e,t,r,o){this.wrapStringPtr(r,r=>{this.wrapStringPtr(t,t=>{const n=this.wasmModule._malloc(e.length);this.wasmModule.HEAPU8.set(e,n),this.wasmModule._addProtoToInputStream(n,e.length,t,r,o),this.wasmModule._free(n)})})}addEmptyPacketToStream(e,t){this.wrapStringPtr(e,e=>{this.wasmModule._addEmptyPacketToInputStream(e,t)})}addBoolToInputSidePacket(e,t){this.wrapStringPtr(t,t=>{this.wasmModule._addBoolToInputSidePacket(e,t)})}addDoubleToInputSidePacket(e,t){this.wrapStringPtr(t,t=>{this.wasmModule._addDoubleToInputSidePacket(e,t)})}addFloatToInputSidePacket(e,t){this.wrapStringPtr(t,t=>{this.wasmModule._addFloatToInputSidePacket(e,t)})}addIntToInputSidePacket(e,t){this.wrapStringPtr(t,t=>{this.wasmModule._addIntToInputSidePacket(e,t)})}addStringToInputSidePacket(e,t){this.wrapStringPtr(t,t=>{this.wrapStringPtr(e,e=>{this.wasmModule._addStringToInputSidePacket(e,t)})})}addProtoToInputSidePacket(e,t,r){this.wrapStringPtr(r,r=>{this.wrapStringPtr(t,t=>{const o=this.wasmModule._malloc(e.length);this.wasmModule.HEAPU8.set(e,o),this.wasmModule._addProtoToInputSidePacket(o,e.length,t,r),this.wasmModule._free(o)})})}attachBoolListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachBoolListener(e)})}attachBoolVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachBoolVectorListener(e)})}attachIntListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachIntListener(e)})}attachIntVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachIntVectorListener(e)})}attachDoubleListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachDoubleListener(e)})}attachDoubleVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachDoubleVectorListener(e)})}attachFloatListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachFloatListener(e)})}attachFloatVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachFloatVectorListener(e)})}attachStringListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachStringListener(e)})}attachStringVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachStringVectorListener(e)})}attachProtoListener(e,t,r){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachProtoListener(e,r||!1)})}attachProtoVectorListener(e,t,r){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmModule._attachProtoVectorListener(e,r||!1)})}attachAudioListener(e,t,r){this.wasmModule._attachAudioListener||console.warn('Attempting to use attachAudioListener without support for output audio. Is build dep ":gl_graph_runner_audio_out" missing?'),this.setListener(e,(e,r)=>{const o=new Float32Array(e.buffer,e.byteOffset,e.length/4);t(o,r)}),this.wrapStringPtr(e,e=>{this.wasmModule._attachAudioListener(e,r||!1)})}finishProcessing(){this.wasmModule._waitUntilIdle()}closeGraph(){this.wasmModule._closeGraph(),this.wasmModule.simpleListeners=void 0,this.wasmModule.emptyPacketListeners=void 0}}async function o(e){if("function"!=typeof importScripts){const t=document.createElement("script");return t.setAttribute("src",e),t.setAttribute("crossorigin","anonymous"),new Promise(e=>{t.addEventListener("load",()=>{e()},!1),t.addEventListener("error",()=>{e()},!1),document.body.appendChild(t)})}importScripts(e.toString())}async function n(e,t,r,n,i){const a=[];if(t&&a.push(t),r&&a.push(r),a.length&&await Promise.all(a.map(o)),!self.ModuleFactory)throw new Error("ModuleFactory not set.");if(self.Module&&i){const e=self.Module;e.locateFile=i.locateFile,i.mainScriptUrlOrBlob&&(e.mainScriptUrlOrBlob=i.mainScriptUrlOrBlob)}const s=await self.ModuleFactory(self.Module||i);return self.ModuleFactory=self.Module=void 0,new e(s,n)}e.GraphRunner=r,e.createMediaPipeLib=n,e.createGraphRunner=async function(e,t,o,i){return n(r,e,t,o,i)}}(graph_runner);var register_model_resources_graph_service={};function SupportModelResourcesGraphService(e){return class extends e{registerModelResourcesGraphService(){this.wasmModule._registerModelResourcesGraphService()}}}Object.defineProperty(register_model_resources_graph_service,"__esModule",{value:!0}),register_model_resources_graph_service.SupportModelResourcesGraphService=void 0,register_model_resources_graph_service.SupportModelResourcesGraphService=SupportModelResourcesGraphService,Object.defineProperty(task_runner,"__esModule",{value:!0}),task_runner.TaskRunner=task_runner.createTaskRunner=task_runner.CachedGraphRunner=void 0;const inference_calculator_pb_1=inference_calculator_pb,calculator_pb_1=calculator_pb,acceleration_pb_1=acceleration_pb,external_file_pb_1=external_file_pb,graph_runner_1$1=graph_runner,register_model_resources_graph_service_1$1=register_model_resources_graph_service,FREE_MEMORY_STREAM="free_memory",UNUSED_STREAM_SUFFIX="_unused_out",CachedGraphRunnerType=(0,register_model_resources_graph_service_1$1.SupportModelResourcesGraphService)(graph_runner_1$1.GraphRunner);class CachedGraphRunner extends CachedGraphRunnerType{}async function createTaskRunner(e,t,r,o){const n={locateFile:()=>r.wasmBinaryPath.toString()},i=await(0,graph_runner_1$1.createMediaPipeLib)(e,r.wasmLoaderPath,r.assetLoaderPath,t,n);return await i.setOptions(o),i}task_runner.CachedGraphRunner=CachedGraphRunner,task_runner.createTaskRunner=createTaskRunner;class TaskRunner{static async createInstance(e,t,r,o){return createTaskRunner(e,t,r,o)}constructor(e){this.graphRunner=e,this.processingErrors=[],this.latestOutputTimestamp=0,this.graphRunner.setAutoRenderToScreen(!1)}applyOptions(e,t=!0){var r,o,n,i,a,s;if(t){const t=e.baseOptions||{};if((null===(r=e.baseOptions)||void 0===r?void 0:r.modelAssetBuffer)&&(null===(o=e.baseOptions)||void 0===o?void 0:o.modelAssetPath))throw new Error("Cannot set both baseOptions.modelAssetPath and baseOptions.modelAssetBuffer");if(!((null===(n=this.baseOptions.getModelAsset())||void 0===n?void 0:n.hasFileContent())||(null===(i=this.baseOptions.getModelAsset())||void 0===i?void 0:i.hasFileName())||(null===(a=e.baseOptions)||void 0===a?void 0:a.modelAssetBuffer)||(null===(s=e.baseOptions)||void 0===s?void 0:s.modelAssetPath)))throw new Error("Either baseOptions.modelAssetPath or baseOptions.modelAssetBuffer must be set");if(this.setAcceleration(t),t.modelAssetPath)return fetch(t.modelAssetPath.toString()).then(e=>{if(e.ok)return e.arrayBuffer();throw new Error(`Failed to fetch model: ${t.modelAssetPath} (${e.status})`)}).then(e=>{try{this.graphRunner.wasmModule.FS_unlink("/model.dat")}catch(e){}this.graphRunner.wasmModule.FS_createDataFile("/","model.dat",new Uint8Array(e),!0,!1,!1),this.setExternalFile("/model.dat"),this.refreshGraph(),this.onGraphRefreshed()});this.setExternalFile(t.modelAssetBuffer)}return this.refreshGraph(),this.onGraphRefreshed(),Promise.resolve()}onGraphRefreshed(){}getCalculatorGraphConfig(){let e;if(this.graphRunner.getCalculatorGraphConfig(t=>{e=calculator_pb_1.CalculatorGraphConfig.deserializeBinary(t)}),!e)throw new Error("Failed to retrieve CalculatorGraphConfig");return e}setGraph(e,t){this.graphRunner.attachErrorListener((e,t)=>{this.processingErrors.push(new Error(t))}),this.graphRunner.registerModelResourcesGraphService(),this.graphRunner.setGraph(e,t),this.keepaliveNode=void 0,this.handleErrors()}finishProcessing(){this.graphRunner.finishProcessing(),this.handleErrors()}setLatestOutputTimestamp(e){this.latestOutputTimestamp=Math.max(this.latestOutputTimestamp,e)}getSynctheticTimestamp(){return this.latestOutputTimestamp+1}handleErrors(){try{const e=this.processingErrors.length;if(1===e)throw new Error(this.processingErrors[0].message);if(e>1)throw new Error("Encountered multiple errors: "+this.processingErrors.map(e=>e.message).join(", "))}finally{this.processingErrors=[]}}setExternalFile(e){const t=this.baseOptions.getModelAsset()||new external_file_pb_1.ExternalFile;"string"==typeof e?(t.setFileName(e),t.clearFileContent()):e instanceof Uint8Array&&(t.setFileContent(e),t.clearFileName()),this.baseOptions.setModelAsset(t)}setAcceleration(e){let t=this.baseOptions.getAcceleration();t||(t=new acceleration_pb_1.Acceleration,t.setTflite(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.TfLite)),"delegate"in e&&("GPU"===e.delegate?t.setGpu(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.Gpu):t.setTflite(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.TfLite)),this.baseOptions.setAcceleration(t)}addKeepaliveNode(e){this.keepaliveNode=new calculator_pb_1.CalculatorGraphConfig.Node,this.keepaliveNode.setCalculator("PassThroughCalculator"),this.keepaliveNode.addInputStream(FREE_MEMORY_STREAM),this.keepaliveNode.addOutputStream(FREE_MEMORY_STREAM+UNUSED_STREAM_SUFFIX),e.addInputStream(FREE_MEMORY_STREAM),e.addNode(this.keepaliveNode)}keepStreamAlive(e){this.keepaliveNode.addInputStream(e),this.keepaliveNode.addOutputStream(e+UNUSED_STREAM_SUFFIX)}freeKeepaliveStreams(){this.graphRunner.addBoolToStream(!0,FREE_MEMORY_STREAM,this.latestOutputTimestamp)}close(){this.keepaliveNode=void 0,this.graphRunner.closeGraph()}}task_runner.TaskRunner=TaskRunner;var graph_runner_image_lib={};function SupportImage(e){return class extends e{get wasmImageModule(){return this.wasmModule}addGpuBufferAsImageToStream(e,t,r){this.wrapStringPtr(t,t=>{const[o,n]=this.bindTextureToStream(e,t);this.wasmImageModule._addBoundTextureAsImageToStream(t,o,n,r)})}attachImageListener(e,t){this.setListener(e,t),this.wrapStringPtr(e,e=>{this.wasmImageModule._attachImageListener(e)})}attachImageVectorListener(e,t){this.setVectorListener(e,t),this.wrapStringPtr(e,e=>{this.wasmImageModule._attachImageVectorListener(e)})}}}Object.defineProperty(graph_runner_image_lib,"__esModule",{value:!0}),graph_runner_image_lib.SupportImage=void 0,graph_runner_image_lib.SupportImage=SupportImage,Object.defineProperty(vision_task_runner,"__esModule",{value:!0}),vision_task_runner.VisionTaskRunner=vision_task_runner.VisionGraphRunner=void 0;const rect_pb_1=rect_pb,task_runner_1=task_runner,image_1$1=image,image_shader_context_1=image_shader_context,mask_1$1=mask,graph_runner_1=graph_runner,graph_runner_image_lib_1=graph_runner_image_lib,platform_utils_1=platform_utils,register_model_resources_graph_service_1=register_model_resources_graph_service,GraphRunnerVisionType=(0,register_model_resources_graph_service_1.SupportModelResourcesGraphService)((0,graph_runner_image_lib_1.SupportImage)(graph_runner_1.GraphRunner));class VisionGraphRunner extends GraphRunnerVisionType{}function createCanvas(){return"undefined"==typeof OffscreenCanvas||(0,platform_utils_1.isWebKit)()?document.createElement("canvas"):void 0}vision_task_runner.VisionGraphRunner=VisionGraphRunner;class VisionTaskRunner extends task_runner_1.TaskRunner{static async createVisionInstance(e,t,r){var o;const n=null!==(o=r.canvas)&&void 0!==o?o:createCanvas();return task_runner_1.TaskRunner.createInstance(e,n,t,r)}constructor(e,t,r,o){super(e),this.graphRunner=e,this.imageStreamName=t,this.normRectStreamName=r,this.roiAllowed=o,this.shaderContext=new image_shader_context_1.MPImageShaderContext}applyOptions(e,t=!0){if("runningMode"in e){const t=!!e.runningMode&&"IMAGE"!==e.runningMode;this.baseOptions.setUseStreamMode(t)}if(void 0!==e.canvas&&this.graphRunner.wasmModule.canvas!==e.canvas)throw new Error("You must create a new task to reset the canvas.");return super.applyOptions(e,t)}processImageData(e,t){var r;if(null===(r=this.baseOptions)||void 0===r?void 0:r.getUseStreamMode())throw new Error("Task is not initialized with image mode. 'runningMode' must be set to 'IMAGE'.");this.process(e,t,this.getSynctheticTimestamp())}processVideoData(e,t,r){var o;if(!(null===(o=this.baseOptions)||void 0===o?void 0:o.getUseStreamMode()))throw new Error("Task is not initialized with video mode. 'runningMode' must be set to 'VIDEO'.");this.process(e,t,r)}getImageSourceSize(e){return void 0!==e.videoWidth?[e.videoWidth,e.videoHeight]:void 0!==e.naturalWidth?[e.naturalWidth,e.naturalHeight]:[e.width,e.height]}convertToNormalizedRect(e,t){const r=new rect_pb_1.NormalizedRect;if(null==t?void 0:t.regionOfInterest){if(!this.roiAllowed)throw new Error("This task doesn't support region-of-interest.");const e=t.regionOfInterest;if(e.left>=e.right||e.top>=e.bottom)throw new Error("Expected RectF with left < right and top < bottom.");if(e.left<0||e.top<0||e.right>1||e.bottom>1)throw new Error("Expected RectF values to be in [0,1].");r.setXCenter((e.left+e.right)/2),r.setYCenter((e.top+e.bottom)/2),r.setWidth(e.right-e.left),r.setHeight(e.bottom-e.top)}else r.setXCenter(.5),r.setYCenter(.5),r.setWidth(1),r.setHeight(1);if(null==t?void 0:t.rotationDegrees){if((null==t?void 0:t.rotationDegrees)%90!=0)throw new Error("Expected rotation to be a multiple of 90°.");if(r.setRotation(-Math.PI*t.rotationDegrees/180),(null==t?void 0:t.rotationDegrees)%180!=0){const[t,o]=this.getImageSourceSize(e),n=r.getHeight()*o/t,i=r.getWidth()*t/o;r.setWidth(n),r.setHeight(i)}}return r}process(e,t,r){if(this.normRectStreamName){const o=this.convertToNormalizedRect(e,t);this.graphRunner.addProtoToStream(o.serializeBinary(),"mediapipe.NormalizedRect",this.normRectStreamName,r)}this.graphRunner.addGpuBufferAsImageToStream(e,this.imageStreamName,null!=r?r:performance.now()),this.finishProcessing()}convertToMPImage(e,t){const{data:r,width:o,height:n}=e,i=o*n;let a;if(r instanceof Uint8Array)if(r.length===3*i){const e=new Uint8ClampedArray(4*i);for(let t=0;t<i;++t)e[4*t]=r[3*t],e[4*t+1]=r[3*t+1],e[4*t+2]=r[3*t+2],e[4*t+3]=255;a=new ImageData(e,o,n)}else{if(r.length!==4*i)throw new Error("Unsupported channel count: "+r.length/i);a=new ImageData(new Uint8ClampedArray(r.buffer,r.byteOffset,r.length),o,n)}else{if(!(r instanceof WebGLTexture))throw new Error(`Unsupported format: ${r.constructor.name}`);a=r}const s=new image_1$1.MPImage([a],!1,!1,this.graphRunner.wasmModule.canvas,this.shaderContext,o,n);return t?s.clone():s}convertToMPMask(e,t){const{data:r,width:o,height:n}=e,i=o*n;let a;if(r instanceof Uint8Array||r instanceof Float32Array){if(r.length!==i)throw new Error("Unsupported channel count: "+r.length/i);a=r}else a=r;const s=new mask_1$1.MPMask([a],!1,this.graphRunner.wasmModule.canvas,this.shaderContext,o,n);return t?s.clone():s}close(){this.shaderContext.close(),super.close()}}vision_task_runner.VisionTaskRunner=VisionTaskRunner;var face_detector_options={};Object.defineProperty(face_detector_options,"__esModule",{value:!0});var face_detector_result={};Object.defineProperty(face_detector_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.FaceDetector=void 0;const o=calculator_pb,n=calculator_options_pb,i=detection_pb,a=base_options_pb,s=face_detector_graph_options_pb,p=detection_result,c=vision_task_runner,l="image_in",d="norm_rect_in",u="detections";r(face_detector_options,e),r(face_detector_result,e);class g extends c.VisionTaskRunner{static createFromOptions(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,t)}static createFromModelBuffer(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,{baseOptions:{modelAssetBuffer:t}})}static async createFromModelPath(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new c.VisionGraphRunner(e,t),l,d,!1),this.result={detections:[]},this.options=new s.FaceDetectorGraphOptions,this.options.setBaseOptions(new a.BaseOptions),this.options.setMinDetectionConfidence(.5),this.options.setMinSuppressionThreshold(.3)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r;return"minDetectionConfidence"in e&&this.options.setMinDetectionConfidence(null!==(t=e.minDetectionConfidence)&&void 0!==t?t:.5),"minSuppressionThreshold"in e&&this.options.setMinSuppressionThreshold(null!==(r=e.minSuppressionThreshold)&&void 0!==r?r:.3),this.applyOptions(e)}detect(e,t){return this.result={detections:[]},this.processImageData(e,t),this.result}detectForVideo(e,t,r){return this.result={detections:[]},this.processVideoData(e,r,t),this.result}addJsFaceDetections(e){for(const t of e){const e=i.Detection.deserializeBinary(t);this.result.detections.push((0,p.convertFromDetectionProto)(e))}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(l),e.addInputStream(d),e.addOutputStream(u);const t=new n.CalculatorOptions;t.setExtension(s.FaceDetectorGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.face_detector.FaceDetectorGraph"),r.addInputStream("IMAGE:"+l),r.addInputStream("NORM_RECT:"+d),r.addOutputStream("DETECTIONS:"+u),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoVectorListener(u,(e,t)=>{this.addJsFaceDetections(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(u,e=>{this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.FaceDetector=g}(face_detector);var face_landmarker={},classification_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.Classification",null,o),r.exportSymbol("proto.mediapipe.ClassificationList",null,o),r.exportSymbol("proto.mediapipe.ClassificationListCollection",null,o),proto.mediapipe.Classification=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Classification,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Classification.displayName="proto.mediapipe.Classification"),proto.mediapipe.ClassificationList=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.ClassificationList.repeatedFields_,null)},r.inherits(proto.mediapipe.ClassificationList,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.ClassificationList.displayName="proto.mediapipe.ClassificationList"),proto.mediapipe.ClassificationListCollection=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.ClassificationListCollection.repeatedFields_,null)},r.inherits(proto.mediapipe.ClassificationListCollection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.ClassificationListCollection.displayName="proto.mediapipe.ClassificationListCollection"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Classification.prototype.toObject=function(e){return proto.mediapipe.Classification.toObject(e,this)},proto.mediapipe.Classification.toObject=function(e,r){var o,n={index:null==(o=t.Message.getField(r,1))?void 0:o,score:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,label:null==(o=t.Message.getField(r,3))?void 0:o,displayName:null==(o=t.Message.getField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Classification.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Classification;return proto.mediapipe.Classification.deserializeBinaryFromReader(o,r)},proto.mediapipe.Classification.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setIndex(r);break;case 2:r=t.readFloat(),e.setScore(r);break;case 3:r=t.readString(),e.setLabel(r);break;case 4:r=t.readString(),e.setDisplayName(r);break;default:t.skipField()}return e},proto.mediapipe.Classification.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Classification.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Classification.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeString(3,o),null!=(o=t.Message.getField(e,4))&&r.writeString(4,o)},proto.mediapipe.Classification.prototype.getIndex=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.Classification.prototype.setIndex=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Classification.prototype.clearIndex=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Classification.prototype.hasIndex=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Classification.prototype.getScore=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.Classification.prototype.setScore=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Classification.prototype.clearScore=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Classification.prototype.hasScore=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Classification.prototype.getLabel=function(){return t.Message.getFieldWithDefault(this,3,"")},proto.mediapipe.Classification.prototype.setLabel=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.Classification.prototype.clearLabel=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.Classification.prototype.hasLabel=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.Classification.prototype.getDisplayName=function(){return t.Message.getFieldWithDefault(this,4,"")},proto.mediapipe.Classification.prototype.setDisplayName=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.Classification.prototype.clearDisplayName=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.Classification.prototype.hasDisplayName=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.ClassificationList.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.ClassificationList.prototype.toObject=function(e){return proto.mediapipe.ClassificationList.toObject(e,this)},proto.mediapipe.ClassificationList.toObject=function(e,r){var o={classificationList:t.Message.toObjectList(r.getClassificationList(),proto.mediapipe.Classification.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.ClassificationList.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.ClassificationList;return proto.mediapipe.ClassificationList.deserializeBinaryFromReader(o,r)},proto.mediapipe.ClassificationList.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.Classification;t.readMessage(r,proto.mediapipe.Classification.deserializeBinaryFromReader),e.addClassification(r)}else t.skipField();return e},proto.mediapipe.ClassificationList.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.ClassificationList.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.ClassificationList.serializeBinaryToWriter=function(e,t){var r;(r=e.getClassificationList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.Classification.serializeBinaryToWriter)},proto.mediapipe.ClassificationList.prototype.getClassificationList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.Classification,1)},proto.mediapipe.ClassificationList.prototype.setClassificationList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.ClassificationList.prototype.addClassification=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.Classification,r)},proto.mediapipe.ClassificationList.prototype.clearClassificationList=function(){return this.setClassificationList([])},proto.mediapipe.ClassificationListCollection.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.ClassificationListCollection.prototype.toObject=function(e){return proto.mediapipe.ClassificationListCollection.toObject(e,this)},proto.mediapipe.ClassificationListCollection.toObject=function(e,r){var o={classificationListList:t.Message.toObjectList(r.getClassificationListList(),proto.mediapipe.ClassificationList.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.ClassificationListCollection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.ClassificationListCollection;return proto.mediapipe.ClassificationListCollection.deserializeBinaryFromReader(o,r)},proto.mediapipe.ClassificationListCollection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.ClassificationList;t.readMessage(r,proto.mediapipe.ClassificationList.deserializeBinaryFromReader),e.addClassificationList(r)}else t.skipField();return e},proto.mediapipe.ClassificationListCollection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.ClassificationListCollection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.ClassificationListCollection.serializeBinaryToWriter=function(e,t){var r;(r=e.getClassificationListList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.ClassificationList.serializeBinaryToWriter)},proto.mediapipe.ClassificationListCollection.prototype.getClassificationListList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.ClassificationList,1)},proto.mediapipe.ClassificationListCollection.prototype.setClassificationListList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.ClassificationListCollection.prototype.addClassificationList=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.ClassificationList,r)},proto.mediapipe.ClassificationListCollection.prototype.clearClassificationListList=function(){return this.setClassificationListList([])},r.object.extend(e,proto.mediapipe)}(classification_pb);var landmark_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.Landmark",null,o),r.exportSymbol("proto.mediapipe.LandmarkList",null,o),r.exportSymbol("proto.mediapipe.LandmarkListCollection",null,o),r.exportSymbol("proto.mediapipe.NormalizedLandmark",null,o),r.exportSymbol("proto.mediapipe.NormalizedLandmarkList",null,o),r.exportSymbol("proto.mediapipe.NormalizedLandmarkListCollection",null,o),proto.mediapipe.Landmark=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Landmark,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Landmark.displayName="proto.mediapipe.Landmark"),proto.mediapipe.LandmarkList=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.LandmarkList.repeatedFields_,null)},r.inherits(proto.mediapipe.LandmarkList,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LandmarkList.displayName="proto.mediapipe.LandmarkList"),proto.mediapipe.LandmarkListCollection=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.LandmarkListCollection.repeatedFields_,null)},r.inherits(proto.mediapipe.LandmarkListCollection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LandmarkListCollection.displayName="proto.mediapipe.LandmarkListCollection"),proto.mediapipe.NormalizedLandmark=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.NormalizedLandmark,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.NormalizedLandmark.displayName="proto.mediapipe.NormalizedLandmark"),proto.mediapipe.NormalizedLandmarkList=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.NormalizedLandmarkList.repeatedFields_,null)},r.inherits(proto.mediapipe.NormalizedLandmarkList,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.NormalizedLandmarkList.displayName="proto.mediapipe.NormalizedLandmarkList"),proto.mediapipe.NormalizedLandmarkListCollection=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.NormalizedLandmarkListCollection.repeatedFields_,null)},r.inherits(proto.mediapipe.NormalizedLandmarkListCollection,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.NormalizedLandmarkListCollection.displayName="proto.mediapipe.NormalizedLandmarkListCollection"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Landmark.prototype.toObject=function(e){return proto.mediapipe.Landmark.toObject(e,this)},proto.mediapipe.Landmark.toObject=function(e,r){var o,n={x:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,y:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,z:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,visibility:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,presence:null==(o=t.Message.getOptionalFloatingPointField(r,5))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Landmark.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Landmark;return proto.mediapipe.Landmark.deserializeBinaryFromReader(o,r)},proto.mediapipe.Landmark.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readFloat();e.setX(r);break;case 2:r=t.readFloat(),e.setY(r);break;case 3:r=t.readFloat(),e.setZ(r);break;case 4:r=t.readFloat(),e.setVisibility(r);break;case 5:r=t.readFloat(),e.setPresence(r);break;default:t.skipField()}return e},proto.mediapipe.Landmark.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Landmark.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Landmark.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeFloat(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o),null!=(o=t.Message.getField(e,5))&&r.writeFloat(5,o)},proto.mediapipe.Landmark.prototype.getX=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.Landmark.prototype.setX=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Landmark.prototype.clearX=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Landmark.prototype.hasX=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Landmark.prototype.getY=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.Landmark.prototype.setY=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Landmark.prototype.clearY=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Landmark.prototype.hasY=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Landmark.prototype.getZ=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.Landmark.prototype.setZ=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.Landmark.prototype.clearZ=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.Landmark.prototype.hasZ=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.Landmark.prototype.getVisibility=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.Landmark.prototype.setVisibility=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.Landmark.prototype.clearVisibility=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.Landmark.prototype.hasVisibility=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.Landmark.prototype.getPresence=function(){return t.Message.getFloatingPointFieldWithDefault(this,5,0)},proto.mediapipe.Landmark.prototype.setPresence=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.Landmark.prototype.clearPresence=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.Landmark.prototype.hasPresence=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.LandmarkList.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LandmarkList.prototype.toObject=function(e){return proto.mediapipe.LandmarkList.toObject(e,this)},proto.mediapipe.LandmarkList.toObject=function(e,r){var o={landmarkList:t.Message.toObjectList(r.getLandmarkList(),proto.mediapipe.Landmark.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.LandmarkList.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LandmarkList;return proto.mediapipe.LandmarkList.deserializeBinaryFromReader(o,r)},proto.mediapipe.LandmarkList.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.Landmark;t.readMessage(r,proto.mediapipe.Landmark.deserializeBinaryFromReader),e.addLandmark(r)}else t.skipField();return e},proto.mediapipe.LandmarkList.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LandmarkList.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LandmarkList.serializeBinaryToWriter=function(e,t){var r;(r=e.getLandmarkList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.Landmark.serializeBinaryToWriter)},proto.mediapipe.LandmarkList.prototype.getLandmarkList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.Landmark,1)},proto.mediapipe.LandmarkList.prototype.setLandmarkList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.LandmarkList.prototype.addLandmark=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.Landmark,r)},proto.mediapipe.LandmarkList.prototype.clearLandmarkList=function(){return this.setLandmarkList([])},proto.mediapipe.LandmarkListCollection.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LandmarkListCollection.prototype.toObject=function(e){return proto.mediapipe.LandmarkListCollection.toObject(e,this)},proto.mediapipe.LandmarkListCollection.toObject=function(e,r){var o={landmarkListList:t.Message.toObjectList(r.getLandmarkListList(),proto.mediapipe.LandmarkList.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.LandmarkListCollection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LandmarkListCollection;return proto.mediapipe.LandmarkListCollection.deserializeBinaryFromReader(o,r)},proto.mediapipe.LandmarkListCollection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.LandmarkList;t.readMessage(r,proto.mediapipe.LandmarkList.deserializeBinaryFromReader),e.addLandmarkList(r)}else t.skipField();return e},proto.mediapipe.LandmarkListCollection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LandmarkListCollection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LandmarkListCollection.serializeBinaryToWriter=function(e,t){var r;(r=e.getLandmarkListList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.LandmarkList.serializeBinaryToWriter)},proto.mediapipe.LandmarkListCollection.prototype.getLandmarkListList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.LandmarkList,1)},proto.mediapipe.LandmarkListCollection.prototype.setLandmarkListList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.LandmarkListCollection.prototype.addLandmarkList=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.LandmarkList,r)},proto.mediapipe.LandmarkListCollection.prototype.clearLandmarkListList=function(){return this.setLandmarkListList([])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.NormalizedLandmark.prototype.toObject=function(e){return proto.mediapipe.NormalizedLandmark.toObject(e,this)},proto.mediapipe.NormalizedLandmark.toObject=function(e,r){var o,n={x:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,y:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,z:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,visibility:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,presence:null==(o=t.Message.getOptionalFloatingPointField(r,5))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.NormalizedLandmark.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.NormalizedLandmark;return proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader(o,r)},proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readFloat();e.setX(r);break;case 2:r=t.readFloat(),e.setY(r);break;case 3:r=t.readFloat(),e.setZ(r);break;case 4:r=t.readFloat(),e.setVisibility(r);break;case 5:r=t.readFloat(),e.setPresence(r);break;default:t.skipField()}return e},proto.mediapipe.NormalizedLandmark.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeFloat(1,o),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o),null!=(o=t.Message.getField(e,5))&&r.writeFloat(5,o)},proto.mediapipe.NormalizedLandmark.prototype.getX=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.NormalizedLandmark.prototype.setX=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.NormalizedLandmark.prototype.clearX=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.NormalizedLandmark.prototype.hasX=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.NormalizedLandmark.prototype.getY=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.NormalizedLandmark.prototype.setY=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.NormalizedLandmark.prototype.clearY=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.NormalizedLandmark.prototype.hasY=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.NormalizedLandmark.prototype.getZ=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.NormalizedLandmark.prototype.setZ=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.NormalizedLandmark.prototype.clearZ=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.NormalizedLandmark.prototype.hasZ=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.NormalizedLandmark.prototype.getVisibility=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.NormalizedLandmark.prototype.setVisibility=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.NormalizedLandmark.prototype.clearVisibility=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.NormalizedLandmark.prototype.hasVisibility=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.NormalizedLandmark.prototype.getPresence=function(){return t.Message.getFloatingPointFieldWithDefault(this,5,0)},proto.mediapipe.NormalizedLandmark.prototype.setPresence=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.NormalizedLandmark.prototype.clearPresence=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.NormalizedLandmark.prototype.hasPresence=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.NormalizedLandmarkList.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.NormalizedLandmarkList.prototype.toObject=function(e){return proto.mediapipe.NormalizedLandmarkList.toObject(e,this)},proto.mediapipe.NormalizedLandmarkList.toObject=function(e,r){var o={landmarkList:t.Message.toObjectList(r.getLandmarkList(),proto.mediapipe.NormalizedLandmark.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.NormalizedLandmarkList.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.NormalizedLandmarkList;return proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader(o,r)},proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.NormalizedLandmark;t.readMessage(r,proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader),e.addLandmark(r)}else t.skipField();return e},proto.mediapipe.NormalizedLandmarkList.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter=function(e,t){var r;(r=e.getLandmarkList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter)},proto.mediapipe.NormalizedLandmarkList.prototype.getLandmarkList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.NormalizedLandmark,1)},proto.mediapipe.NormalizedLandmarkList.prototype.setLandmarkList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.NormalizedLandmarkList.prototype.addLandmark=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.NormalizedLandmark,r)},proto.mediapipe.NormalizedLandmarkList.prototype.clearLandmarkList=function(){return this.setLandmarkList([])},proto.mediapipe.NormalizedLandmarkListCollection.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.NormalizedLandmarkListCollection.prototype.toObject=function(e){return proto.mediapipe.NormalizedLandmarkListCollection.toObject(e,this)},proto.mediapipe.NormalizedLandmarkListCollection.toObject=function(e,r){var o={landmarkListList:t.Message.toObjectList(r.getLandmarkListList(),proto.mediapipe.NormalizedLandmarkList.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.NormalizedLandmarkListCollection;return proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinaryFromReader(o,r)},proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.NormalizedLandmarkList;t.readMessage(r,proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader),e.addLandmarkList(r)}else t.skipField();return e},proto.mediapipe.NormalizedLandmarkListCollection.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.NormalizedLandmarkListCollection.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.NormalizedLandmarkListCollection.serializeBinaryToWriter=function(e,t){var r;(r=e.getLandmarkListList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter)},proto.mediapipe.NormalizedLandmarkListCollection.prototype.getLandmarkListList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.NormalizedLandmarkList,1)},proto.mediapipe.NormalizedLandmarkListCollection.prototype.setLandmarkListList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.NormalizedLandmarkListCollection.prototype.addLandmarkList=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.NormalizedLandmarkList,r)},proto.mediapipe.NormalizedLandmarkListCollection.prototype.clearLandmarkListList=function(){return this.setLandmarkListList([])},r.object.extend(e,proto.mediapipe)}(landmark_pb);var face_geometry_pb={},matrix_data_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.MatrixData",null,o),r.exportSymbol("proto.mediapipe.MatrixData.Layout",null,o),proto.mediapipe.MatrixData=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.MatrixData.repeatedFields_,null)},r.inherits(proto.mediapipe.MatrixData,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.MatrixData.displayName="proto.mediapipe.MatrixData"),proto.mediapipe.MatrixData.repeatedFields_=[3],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.MatrixData.prototype.toObject=function(e){return proto.mediapipe.MatrixData.toObject(e,this)},proto.mediapipe.MatrixData.toObject=function(e,r){var o,n={rows:null==(o=t.Message.getField(r,1))?void 0:o,cols:null==(o=t.Message.getField(r,2))?void 0:o,packedDataList:null==(o=t.Message.getRepeatedFloatingPointField(r,3))?void 0:o,layout:t.Message.getFieldWithDefault(r,4,0)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.MatrixData.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.MatrixData;return proto.mediapipe.MatrixData.deserializeBinaryFromReader(o,r)},proto.mediapipe.MatrixData.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setRows(r);break;case 2:r=t.readInt32(),e.setCols(r);break;case 3:for(var o=t.isDelimited()?t.readPackedFloat():[t.readFloat()],n=0;n<o.length;n++)e.addPackedData(o[n]);break;case 4:r=t.readEnum(),e.setLayout(r);break;default:t.skipField()}return e},proto.mediapipe.MatrixData.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.MatrixData.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.MatrixData.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),(o=e.getPackedDataList()).length>0&&r.writePackedFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeEnum(4,o)},proto.mediapipe.MatrixData.Layout={COLUMN_MAJOR:0,ROW_MAJOR:1},proto.mediapipe.MatrixData.prototype.getRows=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.MatrixData.prototype.setRows=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.MatrixData.prototype.clearRows=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.MatrixData.prototype.hasRows=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.MatrixData.prototype.getCols=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.MatrixData.prototype.setCols=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.MatrixData.prototype.clearCols=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.MatrixData.prototype.hasCols=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.MatrixData.prototype.getPackedDataList=function(){return t.Message.getRepeatedFloatingPointField(this,3)},proto.mediapipe.MatrixData.prototype.setPackedDataList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.MatrixData.prototype.addPackedData=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.MatrixData.prototype.clearPackedDataList=function(){return this.setPackedDataList([])},proto.mediapipe.MatrixData.prototype.getLayout=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.MatrixData.prototype.setLayout=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.MatrixData.prototype.clearLayout=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.MatrixData.prototype.hasLayout=function(){return null!=t.Message.getField(this,4)},r.object.extend(e,proto.mediapipe)}(matrix_data_pb);var mesh_3d_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d",null,o),r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.PrimitiveType",null,o),r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.VertexType",null,o),proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.displayName="proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d"),proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.repeatedFields_=[3,4],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.toObject(e,this)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.toObject=function(e,r){var o,n={vertexType:null==(o=t.Message.getField(r,1))?void 0:o,primitiveType:null==(o=t.Message.getField(r,2))?void 0:o,vertexBufferList:null==(o=t.Message.getRepeatedFloatingPointField(r,3))?void 0:o,indexBufferList:null==(o=t.Message.getRepeatedField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d;return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readEnum();e.setVertexType(r);break;case 2:r=t.readEnum(),e.setPrimitiveType(r);break;case 3:for(var o=t.isDelimited()?t.readPackedFloat():[t.readFloat()],n=0;n<o.length;n++)e.addVertexBuffer(o[n]);break;case 4:for(o=t.isDelimited()?t.readPackedUint32():[t.readUint32()],n=0;n<o.length;n++)e.addIndexBuffer(o[n]);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeEnum(1,o),null!=(o=t.Message.getField(e,2))&&r.writeEnum(2,o),(o=e.getVertexBufferList()).length>0&&r.writeRepeatedFloat(3,o),(o=e.getIndexBufferList()).length>0&&r.writeRepeatedUint32(4,o)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.VertexType={VERTEX_PT:0},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.PrimitiveType={TRIANGLE:0},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getVertexType=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setVertexType=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearVertexType=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.hasVertexType=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getPrimitiveType=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setPrimitiveType=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearPrimitiveType=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.hasPrimitiveType=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getVertexBufferList=function(){return t.Message.getRepeatedFloatingPointField(this,3)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setVertexBufferList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.addVertexBuffer=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearVertexBufferList=function(){return this.setVertexBufferList([])},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getIndexBufferList=function(){return t.Message.getRepeatedField(this,4)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setIndexBufferList=function(e){return t.Message.setField(this,4,e||[])},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.addIndexBuffer=function(e,r){return t.Message.addToRepeatedField(this,4,e,r)},proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearIndexBufferList=function(){return this.setIndexBufferList([])},r.object.extend(e,proto.mediapipe.tasks.vision.face_geometry.proto)}(mesh_3d_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=matrix_data_pb;r.object.extend(proto,n);var i=mesh_3d_pb;r.object.extend(proto,i),r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry",null,o),proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.displayName="proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.toObject(e,this)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.toObject=function(e,t){var r,o={mesh:(r=t.getMesh())&&i.Mesh3d.toObject(e,r),poseTransformMatrix:(r=t.getPoseTransformMatrix())&&n.MatrixData.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry;return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new i.Mesh3d;t.readMessage(r,i.Mesh3d.deserializeBinaryFromReader),e.setMesh(r);break;case 2:r=new n.MatrixData,t.readMessage(r,n.MatrixData.deserializeBinaryFromReader),e.setPoseTransformMatrix(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getMesh())&&t.writeMessage(1,r,i.Mesh3d.serializeBinaryToWriter),null!=(r=e.getPoseTransformMatrix())&&t.writeMessage(2,r,n.MatrixData.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.getMesh=function(){return t.Message.getWrapperField(this,i.Mesh3d,1)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.setMesh=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.clearMesh=function(){return this.setMesh(void 0)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.hasMesh=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.getPoseTransformMatrix=function(){return t.Message.getWrapperField(this,n.MatrixData,2)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.setPoseTransformMatrix=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.clearPoseTransformMatrix=function(){return this.setPoseTransformMatrix(void 0)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.hasPoseTransformMatrix=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.vision.face_geometry.proto)}(face_geometry_pb);var face_landmarker_graph_options_pb={},face_geometry_graph_options_pb={},geometry_pipeline_calculator_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_options_pb;r.object.extend(proto,n);var i=external_file_pb;r.object.extend(proto,i),r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions",null,o),proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.displayName="proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject=function(e,t){var r,o={metadataFile:(r=t.getMetadataFile())&&i.ExternalFile.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions;return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new i.ExternalFile;t.readMessage(r,i.ExternalFile.deserializeBinaryFromReader),e.setMetadataFile(r)}else t.skipField();return e},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter=function(e,t){var r;null!=(r=e.getMetadataFile())&&t.writeMessage(1,r,i.ExternalFile.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext=new t.ExtensionFieldInfo(512499200,{ext:0},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject,0),n.CalculatorOptions.extensionsBinary[512499200]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[512499200]=proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.getMetadataFile=function(){return t.Message.getWrapperField(this,i.ExternalFile,1)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.setMetadataFile=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.clearMetadataFile=function(){return this.setMetadataFile(void 0)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.hasMetadataFile=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext=new t.ExtensionFieldInfo(512499200,{ext:0},proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject,0),n.CalculatorOptions.extensionsBinary[512499200]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[512499200]=proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_geometry)}(geometry_pipeline_calculator_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_options_pb;r.object.extend(proto,n);var i=geometry_pipeline_calculator_pb;r.object.extend(proto,i),r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions",null,o),proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.displayName="proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject=function(e,t){var r,o={geometryPipelineOptions:(r=t.getGeometryPipelineOptions())&&i.FaceGeometryPipelineCalculatorOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions;return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new i.FaceGeometryPipelineCalculatorOptions;t.readMessage(r,i.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader),e.setGeometryPipelineOptions(r)}else t.skipField();return e},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter=function(e,t){var r;null!=(r=e.getGeometryPipelineOptions())&&t.writeMessage(1,r,i.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext=new t.ExtensionFieldInfo(515723506,{ext:0},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject,0),n.CalculatorOptions.extensionsBinary[515723506]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[515723506]=proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.getGeometryPipelineOptions=function(){return t.Message.getWrapperField(this,i.FaceGeometryPipelineCalculatorOptions,1)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.setGeometryPipelineOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.clearGeometryPipelineOptions=function(){return this.setGeometryPipelineOptions(void 0)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.hasGeometryPipelineOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext=new t.ExtensionFieldInfo(515723506,{ext:0},proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject,0),n.CalculatorOptions.extensionsBinary[515723506]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[515723506]=proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_geometry.proto)}(face_geometry_graph_options_pb);var face_landmarks_detector_graph_options_pb={},face_blendshapes_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions",null,o),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.displayName="proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&a.BaseOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r)}else t.skipField();return e},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter=function(e,t){var r;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,a.BaseOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext=new t.ExtensionFieldInfo(508981768,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508981768]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508981768]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext=new t.ExtensionFieldInfo(508981768,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508981768]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508981768]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_landmarker.proto)}(face_blendshapes_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=face_blendshapes_graph_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5),smoothLandmarks:null==(o=t.Message.getBooleanField(r,4))?void 0:o,faceBlendshapesGraphOptions:(o=r.getFaceBlendshapesGraphOptions())&&s.FaceBlendshapesGraphOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;case 4:r=t.readBool(),e.setSmoothLandmarks(r);break;case 3:r=new s.FaceBlendshapesGraphOptions,t.readMessage(r,s.FaceBlendshapesGraphOptions.deserializeBinaryFromReader),e.setFaceBlendshapesGraphOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,4))&&r.writeBool(4,o),null!=(o=e.getFaceBlendshapesGraphOptions())&&r.writeMessage(3,o,s.FaceBlendshapesGraphOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(508968149,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508968149]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508968149]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getSmoothLandmarks=function(){return t.Message.getBooleanFieldWithDefault(this,4,!1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setSmoothLandmarks=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearSmoothLandmarks=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasSmoothLandmarks=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getFaceBlendshapesGraphOptions=function(){return t.Message.getWrapperField(this,s.FaceBlendshapesGraphOptions,3)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setFaceBlendshapesGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearFaceBlendshapesGraphOptions=function(){return this.setFaceBlendshapesGraphOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasFaceBlendshapesGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(508968149,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508968149]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508968149]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_landmarker.proto)}(face_landmarks_detector_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=face_detector_graph_options_pb;r.object.extend(proto,s);var p=face_geometry_graph_options_pb;r.object.extend(proto,p);var c=face_landmarks_detector_graph_options_pb;r.object.extend(proto,c),r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions",null,o),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.displayName="proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),faceDetectorGraphOptions:(o=r.getFaceDetectorGraphOptions())&&s.FaceDetectorGraphOptions.toObject(e,o),faceLandmarksDetectorGraphOptions:(o=r.getFaceLandmarksDetectorGraphOptions())&&c.FaceLandmarksDetectorGraphOptions.toObject(e,o),minTrackingConfidence:t.Message.getFloatingPointFieldWithDefault(r,4,.5),faceGeometryGraphOptions:(o=r.getFaceGeometryGraphOptions())&&p.FaceGeometryGraphOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new s.FaceDetectorGraphOptions,t.readMessage(r,s.FaceDetectorGraphOptions.deserializeBinaryFromReader),e.setFaceDetectorGraphOptions(r);break;case 3:r=new c.FaceLandmarksDetectorGraphOptions,t.readMessage(r,c.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader),e.setFaceLandmarksDetectorGraphOptions(r);break;case 4:r=t.readFloat(),e.setMinTrackingConfidence(r);break;case 5:r=new p.FaceGeometryGraphOptions,t.readMessage(r,p.FaceGeometryGraphOptions.deserializeBinaryFromReader),e.setFaceGeometryGraphOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=e.getFaceDetectorGraphOptions())&&r.writeMessage(2,o,s.FaceDetectorGraphOptions.serializeBinaryToWriter),null!=(o=e.getFaceLandmarksDetectorGraphOptions())&&r.writeMessage(3,o,c.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o),null!=(o=e.getFaceGeometryGraphOptions())&&r.writeMessage(5,o,p.FaceGeometryGraphOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(508968150,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508968150]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508968150]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceDetectorGraphOptions=function(){return t.Message.getWrapperField(this,s.FaceDetectorGraphOptions,2)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceDetectorGraphOptions=function(){return this.setFaceDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceDetectorGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceLandmarksDetectorGraphOptions=function(){return t.Message.getWrapperField(this,c.FaceLandmarksDetectorGraphOptions,3)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceLandmarksDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceLandmarksDetectorGraphOptions=function(){return this.setFaceLandmarksDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceLandmarksDetectorGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getMinTrackingConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,.5)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setMinTrackingConfidence=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearMinTrackingConfidence=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasMinTrackingConfidence=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceGeometryGraphOptions=function(){return t.Message.getWrapperField(this,p.FaceGeometryGraphOptions,5)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceGeometryGraphOptions=function(e){return t.Message.setWrapperField(this,5,e)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceGeometryGraphOptions=function(){return this.setFaceGeometryGraphOptions(void 0)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceGeometryGraphOptions=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(508968150,{ext:0},proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[508968150]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[508968150]=proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_landmarker.proto)}(face_landmarker_graph_options_pb);var classifier_result={};Object.defineProperty(classifier_result,"__esModule",{value:!0}),classifier_result.convertFromClassificationResultProto=classifier_result.convertFromClassifications=void 0;const DEFAULT_INDEX$1=-1,DEFAULT_SCORE=0;function convertFromClassifications(e,t=DEFAULT_INDEX$1,r=""){return{categories:e.map(e=>{var t,r,o,n;return{index:null!==(t=e.getIndex())&&void 0!==t?t:DEFAULT_INDEX$1,score:null!==(r=e.getScore())&&void 0!==r?r:DEFAULT_SCORE,categoryName:null!==(o=e.getLabel())&&void 0!==o?o:"",displayName:null!==(n=e.getDisplayName())&&void 0!==n?n:""}}),headIndex:t,headName:r}}function convertFromClassificationsProto(e){var t,r;return convertFromClassifications(null!==(r=null===(t=e.getClassificationList())||void 0===t?void 0:t.getClassificationList())&&void 0!==r?r:[],e.getHeadIndex(),e.getHeadName())}function convertFromClassificationResultProto(e){const t={classifications:e.getClassificationsList().map(e=>convertFromClassificationsProto(e))};return e.hasTimestampMs()&&(t.timestampMs=e.getTimestampMs()),t}classifier_result.convertFromClassifications=convertFromClassifications,classifier_result.convertFromClassificationResultProto=convertFromClassificationResultProto;var landmark_result={};function convertToLandmarks(e){var t,r,o;const n=[];for(const i of e.getLandmarkList())n.push({x:null!==(t=i.getX())&&void 0!==t?t:0,y:null!==(r=i.getY())&&void 0!==r?r:0,z:null!==(o=i.getZ())&&void 0!==o?o:0});return n}function convertToWorldLandmarks(e){var t,r,o;const n=[];for(const i of e.getLandmarkList())n.push({x:null!==(t=i.getX())&&void 0!==t?t:0,y:null!==(r=i.getY())&&void 0!==r?r:0,z:null!==(o=i.getZ())&&void 0!==o?o:0});return n}Object.defineProperty(landmark_result,"__esModule",{value:!0}),landmark_result.convertToWorldLandmarks=landmark_result.convertToLandmarks=void 0,landmark_result.convertToLandmarks=convertToLandmarks,landmark_result.convertToWorldLandmarks=convertToWorldLandmarks;var face_landmarks_connections={},exports;exports=face_landmarks_connections,Object.defineProperty(exports,"__esModule",{value:!0}),exports.FACE_LANDMARKS_TESSELATION=exports.FACE_LANDMARKS_CONTOURS=exports.FACE_LANDMARKS_FACE_OVAL=exports.FACE_LANDMARKS_RIGHT_IRIS=exports.FACE_LANDMARKS_RIGHT_EYEBROW=exports.FACE_LANDMARKS_RIGHT_EYE=exports.FACE_LANDMARKS_LEFT_IRIS=exports.FACE_LANDMARKS_LEFT_EYEBROW=exports.FACE_LANDMARKS_LEFT_EYE=exports.FACE_LANDMARKS_LIPS=void 0,exports.FACE_LANDMARKS_LIPS=[{start:61,end:146},{start:146,end:91},{start:91,end:181},{start:181,end:84},{start:84,end:17},{start:17,end:314},{start:314,end:405},{start:405,end:321},{start:321,end:375},{start:375,end:291},{start:61,end:185},{start:185,end:40},{start:40,end:39},{start:39,end:37},{start:37,end:0},{start:0,end:267},{start:267,end:269},{start:269,end:270},{start:270,end:409},{start:409,end:291},{start:78,end:95},{start:95,end:88},{start:88,end:178},{start:178,end:87},{start:87,end:14},{start:14,end:317},{start:317,end:402},{start:402,end:318},{start:318,end:324},{start:324,end:308},{start:78,end:191},{start:191,end:80},{start:80,end:81},{start:81,end:82},{start:82,end:13},{start:13,end:312},{start:312,end:311},{start:311,end:310},{start:310,end:415},{start:415,end:308}],exports.FACE_LANDMARKS_LEFT_EYE=[{start:263,end:249},{start:249,end:390},{start:390,end:373},{start:373,end:374},{start:374,end:380},{start:380,end:381},{start:381,end:382},{start:382,end:362},{start:263,end:466},{start:466,end:388},{start:388,end:387},{start:387,end:386},{start:386,end:385},{start:385,end:384},{start:384,end:398},{start:398,end:362}],exports.FACE_LANDMARKS_LEFT_EYEBROW=[{start:276,end:283},{start:283,end:282},{start:282,end:295},{start:295,end:285},{start:300,end:293},{start:293,end:334},{start:334,end:296},{start:296,end:336}],exports.FACE_LANDMARKS_LEFT_IRIS=[{start:474,end:475},{start:475,end:476},{start:476,end:477},{start:477,end:474}],exports.FACE_LANDMARKS_RIGHT_EYE=[{start:33,end:7},{start:7,end:163},{start:163,end:144},{start:144,end:145},{start:145,end:153},{start:153,end:154},{start:154,end:155},{start:155,end:133},{start:33,end:246},{start:246,end:161},{start:161,end:160},{start:160,end:159},{start:159,end:158},{start:158,end:157},{start:157,end:173},{start:173,end:133}],exports.FACE_LANDMARKS_RIGHT_EYEBROW=[{start:46,end:53},{start:53,end:52},{start:52,end:65},{start:65,end:55},{start:70,end:63},{start:63,end:105},{start:105,end:66},{start:66,end:107}],exports.FACE_LANDMARKS_RIGHT_IRIS=[{start:469,end:470},{start:470,end:471},{start:471,end:472},{start:472,end:469}],exports.FACE_LANDMARKS_FACE_OVAL=[{start:10,end:338},{start:338,end:297},{start:297,end:332},{start:332,end:284},{start:284,end:251},{start:251,end:389},{start:389,end:356},{start:356,end:454},{start:454,end:323},{start:323,end:361},{start:361,end:288},{start:288,end:397},{start:397,end:365},{start:365,end:379},{start:379,end:378},{start:378,end:400},{start:400,end:377},{start:377,end:152},{start:152,end:148},{start:148,end:176},{start:176,end:149},{start:149,end:150},{start:150,end:136},{start:136,end:172},{start:172,end:58},{start:58,end:132},{start:132,end:93},{start:93,end:234},{start:234,end:127},{start:127,end:162},{start:162,end:21},{start:21,end:54},{start:54,end:103},{start:103,end:67},{start:67,end:109},{start:109,end:10}],exports.FACE_LANDMARKS_CONTOURS=[...exports.FACE_LANDMARKS_LIPS,...exports.FACE_LANDMARKS_LEFT_EYE,...exports.FACE_LANDMARKS_LEFT_EYEBROW,...exports.FACE_LANDMARKS_RIGHT_EYE,...exports.FACE_LANDMARKS_RIGHT_EYEBROW,...exports.FACE_LANDMARKS_FACE_OVAL],exports.FACE_LANDMARKS_TESSELATION=[{start:127,end:34},{start:34,end:139},{start:139,end:127},{start:11,end:0},{start:0,end:37},{start:37,end:11},{start:232,end:231},{start:231,end:120},{start:120,end:232},{start:72,end:37},{start:37,end:39},{start:39,end:72},{start:128,end:121},{start:121,end:47},{start:47,end:128},{start:232,end:121},{start:121,end:128},{start:128,end:232},{start:104,end:69},{start:69,end:67},{start:67,end:104},{start:175,end:171},{start:171,end:148},{start:148,end:175},{start:118,end:50},{start:50,end:101},{start:101,end:118},{start:73,end:39},{start:39,end:40},{start:40,end:73},{start:9,end:151},{start:151,end:108},{start:108,end:9},{start:48,end:115},{start:115,end:131},{start:131,end:48},{start:194,end:204},{start:204,end:211},{start:211,end:194},{start:74,end:40},{start:40,end:185},{start:185,end:74},{start:80,end:42},{start:42,end:183},{start:183,end:80},{start:40,end:92},{start:92,end:186},{start:186,end:40},{start:230,end:229},{start:229,end:118},{start:118,end:230},{start:202,end:212},{start:212,end:214},{start:214,end:202},{start:83,end:18},{start:18,end:17},{start:17,end:83},{start:76,end:61},{start:61,end:146},{start:146,end:76},{start:160,end:29},{start:29,end:30},{start:30,end:160},{start:56,end:157},{start:157,end:173},{start:173,end:56},{start:106,end:204},{start:204,end:194},{start:194,end:106},{start:135,end:214},{start:214,end:192},{start:192,end:135},{start:203,end:165},{start:165,end:98},{start:98,end:203},{start:21,end:71},{start:71,end:68},{start:68,end:21},{start:51,end:45},{start:45,end:4},{start:4,end:51},{start:144,end:24},{start:24,end:23},{start:23,end:144},{start:77,end:146},{start:146,end:91},{start:91,end:77},{start:205,end:50},{start:50,end:187},{start:187,end:205},{start:201,end:200},{start:200,end:18},{start:18,end:201},{start:91,end:106},{start:106,end:182},{start:182,end:91},{start:90,end:91},{start:91,end:181},{start:181,end:90},{start:85,end:84},{start:84,end:17},{start:17,end:85},{start:206,end:203},{start:203,end:36},{start:36,end:206},{start:148,end:171},{start:171,end:140},{start:140,end:148},{start:92,end:40},{start:40,end:39},{start:39,end:92},{start:193,end:189},{start:189,end:244},{start:244,end:193},{start:159,end:158},{start:158,end:28},{start:28,end:159},{start:247,end:246},{start:246,end:161},{start:161,end:247},{start:236,end:3},{start:3,end:196},{start:196,end:236},{start:54,end:68},{start:68,end:104},{start:104,end:54},{start:193,end:168},{start:168,end:8},{start:8,end:193},{start:117,end:228},{start:228,end:31},{start:31,end:117},{start:189,end:193},{start:193,end:55},{start:55,end:189},{start:98,end:97},{start:97,end:99},{start:99,end:98},{start:126,end:47},{start:47,end:100},{start:100,end:126},{start:166,end:79},{start:79,end:218},{start:218,end:166},{start:155,end:154},{start:154,end:26},{start:26,end:155},{start:209,end:49},{start:49,end:131},{start:131,end:209},{start:135,end:136},{start:136,end:150},{start:150,end:135},{start:47,end:126},{start:126,end:217},{start:217,end:47},{start:223,end:52},{start:52,end:53},{start:53,end:223},{start:45,end:51},{start:51,end:134},{start:134,end:45},{start:211,end:170},{start:170,end:140},{start:140,end:211},{start:67,end:69},{start:69,end:108},{start:108,end:67},{start:43,end:106},{start:106,end:91},{start:91,end:43},{start:230,end:119},{start:119,end:120},{start:120,end:230},{start:226,end:130},{start:130,end:247},{start:247,end:226},{start:63,end:53},{start:53,end:52},{start:52,end:63},{start:238,end:20},{start:20,end:242},{start:242,end:238},{start:46,end:70},{start:70,end:156},{start:156,end:46},{start:78,end:62},{start:62,end:96},{start:96,end:78},{start:46,end:53},{start:53,end:63},{start:63,end:46},{start:143,end:34},{start:34,end:227},{start:227,end:143},{start:123,end:117},{start:117,end:111},{start:111,end:123},{start:44,end:125},{start:125,end:19},{start:19,end:44},{start:236,end:134},{start:134,end:51},{start:51,end:236},{start:216,end:206},{start:206,end:205},{start:205,end:216},{start:154,end:153},{start:153,end:22},{start:22,end:154},{start:39,end:37},{start:37,end:167},{start:167,end:39},{start:200,end:201},{start:201,end:208},{start:208,end:200},{start:36,end:142},{start:142,end:100},{start:100,end:36},{start:57,end:212},{start:212,end:202},{start:202,end:57},{start:20,end:60},{start:60,end:99},{start:99,end:20},{start:28,end:158},{start:158,end:157},{start:157,end:28},{start:35,end:226},{start:226,end:113},{start:113,end:35},{start:160,end:159},{start:159,end:27},{start:27,end:160},{start:204,end:202},{start:202,end:210},{start:210,end:204},{start:113,end:225},{start:225,end:46},{start:46,end:113},{start:43,end:202},{start:202,end:204},{start:204,end:43},{start:62,end:76},{start:76,end:77},{start:77,end:62},{start:137,end:123},{start:123,end:116},{start:116,end:137},{start:41,end:38},{start:38,end:72},{start:72,end:41},{start:203,end:129},{start:129,end:142},{start:142,end:203},{start:64,end:98},{start:98,end:240},{start:240,end:64},{start:49,end:102},{start:102,end:64},{start:64,end:49},{start:41,end:73},{start:73,end:74},{start:74,end:41},{start:212,end:216},{start:216,end:207},{start:207,end:212},{start:42,end:74},{start:74,end:184},{start:184,end:42},{start:169,end:170},{start:170,end:211},{start:211,end:169},{start:170,end:149},{start:149,end:176},{start:176,end:170},{start:105,end:66},{start:66,end:69},{start:69,end:105},{start:122,end:6},{start:6,end:168},{start:168,end:122},{start:123,end:147},{start:147,end:187},{start:187,end:123},{start:96,end:77},{start:77,end:90},{start:90,end:96},{start:65,end:55},{start:55,end:107},{start:107,end:65},{start:89,end:90},{start:90,end:180},{start:180,end:89},{start:101,end:100},{start:100,end:120},{start:120,end:101},{start:63,end:105},{start:105,end:104},{start:104,end:63},{start:93,end:137},{start:137,end:227},{start:227,end:93},{start:15,end:86},{start:86,end:85},{start:85,end:15},{start:129,end:102},{start:102,end:49},{start:49,end:129},{start:14,end:87},{start:87,end:86},{start:86,end:14},{start:55,end:8},{start:8,end:9},{start:9,end:55},{start:100,end:47},{start:47,end:121},{start:121,end:100},{start:145,end:23},{start:23,end:22},{start:22,end:145},{start:88,end:89},{start:89,end:179},{start:179,end:88},{start:6,end:122},{start:122,end:196},{start:196,end:6},{start:88,end:95},{start:95,end:96},{start:96,end:88},{start:138,end:172},{start:172,end:136},{start:136,end:138},{start:215,end:58},{start:58,end:172},{start:172,end:215},{start:115,end:48},{start:48,end:219},{start:219,end:115},{start:42,end:80},{start:80,end:81},{start:81,end:42},{start:195,end:3},{start:3,end:51},{start:51,end:195},{start:43,end:146},{start:146,end:61},{start:61,end:43},{start:171,end:175},{start:175,end:199},{start:199,end:171},{start:81,end:82},{start:82,end:38},{start:38,end:81},{start:53,end:46},{start:46,end:225},{start:225,end:53},{start:144,end:163},{start:163,end:110},{start:110,end:144},{start:52,end:65},{start:65,end:66},{start:66,end:52},{start:229,end:228},{start:228,end:117},{start:117,end:229},{start:34,end:127},{start:127,end:234},{start:234,end:34},{start:107,end:108},{start:108,end:69},{start:69,end:107},{start:109,end:108},{start:108,end:151},{start:151,end:109},{start:48,end:64},{start:64,end:235},{start:235,end:48},{start:62,end:78},{start:78,end:191},{start:191,end:62},{start:129,end:209},{start:209,end:126},{start:126,end:129},{start:111,end:35},{start:35,end:143},{start:143,end:111},{start:117,end:123},{start:123,end:50},{start:50,end:117},{start:222,end:65},{start:65,end:52},{start:52,end:222},{start:19,end:125},{start:125,end:141},{start:141,end:19},{start:221,end:55},{start:55,end:65},{start:65,end:221},{start:3,end:195},{start:195,end:197},{start:197,end:3},{start:25,end:7},{start:7,end:33},{start:33,end:25},{start:220,end:237},{start:237,end:44},{start:44,end:220},{start:70,end:71},{start:71,end:139},{start:139,end:70},{start:122,end:193},{start:193,end:245},{start:245,end:122},{start:247,end:130},{start:130,end:33},{start:33,end:247},{start:71,end:21},{start:21,end:162},{start:162,end:71},{start:170,end:169},{start:169,end:150},{start:150,end:170},{start:188,end:174},{start:174,end:196},{start:196,end:188},{start:216,end:186},{start:186,end:92},{start:92,end:216},{start:2,end:97},{start:97,end:167},{start:167,end:2},{start:141,end:125},{start:125,end:241},{start:241,end:141},{start:164,end:167},{start:167,end:37},{start:37,end:164},{start:72,end:38},{start:38,end:12},{start:12,end:72},{start:38,end:82},{start:82,end:13},{start:13,end:38},{start:63,end:68},{start:68,end:71},{start:71,end:63},{start:226,end:35},{start:35,end:111},{start:111,end:226},{start:101,end:50},{start:50,end:205},{start:205,end:101},{start:206,end:92},{start:92,end:165},{start:165,end:206},{start:209,end:198},{start:198,end:217},{start:217,end:209},{start:165,end:167},{start:167,end:97},{start:97,end:165},{start:220,end:115},{start:115,end:218},{start:218,end:220},{start:133,end:112},{start:112,end:243},{start:243,end:133},{start:239,end:238},{start:238,end:241},{start:241,end:239},{start:214,end:135},{start:135,end:169},{start:169,end:214},{start:190,end:173},{start:173,end:133},{start:133,end:190},{start:171,end:208},{start:208,end:32},{start:32,end:171},{start:125,end:44},{start:44,end:237},{start:237,end:125},{start:86,end:87},{start:87,end:178},{start:178,end:86},{start:85,end:86},{start:86,end:179},{start:179,end:85},{start:84,end:85},{start:85,end:180},{start:180,end:84},{start:83,end:84},{start:84,end:181},{start:181,end:83},{start:201,end:83},{start:83,end:182},{start:182,end:201},{start:137,end:93},{start:93,end:132},{start:132,end:137},{start:76,end:62},{start:62,end:183},{start:183,end:76},{start:61,end:76},{start:76,end:184},{start:184,end:61},{start:57,end:61},{start:61,end:185},{start:185,end:57},{start:212,end:57},{start:57,end:186},{start:186,end:212},{start:214,end:207},{start:207,end:187},{start:187,end:214},{start:34,end:143},{start:143,end:156},{start:156,end:34},{start:79,end:239},{start:239,end:237},{start:237,end:79},{start:123,end:137},{start:137,end:177},{start:177,end:123},{start:44,end:1},{start:1,end:4},{start:4,end:44},{start:201,end:194},{start:194,end:32},{start:32,end:201},{start:64,end:102},{start:102,end:129},{start:129,end:64},{start:213,end:215},{start:215,end:138},{start:138,end:213},{start:59,end:166},{start:166,end:219},{start:219,end:59},{start:242,end:99},{start:99,end:97},{start:97,end:242},{start:2,end:94},{start:94,end:141},{start:141,end:2},{start:75,end:59},{start:59,end:235},{start:235,end:75},{start:24,end:110},{start:110,end:228},{start:228,end:24},{start:25,end:130},{start:130,end:226},{start:226,end:25},{start:23,end:24},{start:24,end:229},{start:229,end:23},{start:22,end:23},{start:23,end:230},{start:230,end:22},{start:26,end:22},{start:22,end:231},{start:231,end:26},{start:112,end:26},{start:26,end:232},{start:232,end:112},{start:189,end:190},{start:190,end:243},{start:243,end:189},{start:221,end:56},{start:56,end:190},{start:190,end:221},{start:28,end:56},{start:56,end:221},{start:221,end:28},{start:27,end:28},{start:28,end:222},{start:222,end:27},{start:29,end:27},{start:27,end:223},{start:223,end:29},{start:30,end:29},{start:29,end:224},{start:224,end:30},{start:247,end:30},{start:30,end:225},{start:225,end:247},{start:238,end:79},{start:79,end:20},{start:20,end:238},{start:166,end:59},{start:59,end:75},{start:75,end:166},{start:60,end:75},{start:75,end:240},{start:240,end:60},{start:147,end:177},{start:177,end:215},{start:215,end:147},{start:20,end:79},{start:79,end:166},{start:166,end:20},{start:187,end:147},{start:147,end:213},{start:213,end:187},{start:112,end:233},{start:233,end:244},{start:244,end:112},{start:233,end:128},{start:128,end:245},{start:245,end:233},{start:128,end:114},{start:114,end:188},{start:188,end:128},{start:114,end:217},{start:217,end:174},{start:174,end:114},{start:131,end:115},{start:115,end:220},{start:220,end:131},{start:217,end:198},{start:198,end:236},{start:236,end:217},{start:198,end:131},{start:131,end:134},{start:134,end:198},{start:177,end:132},{start:132,end:58},{start:58,end:177},{start:143,end:35},{start:35,end:124},{start:124,end:143},{start:110,end:163},{start:163,end:7},{start:7,end:110},{start:228,end:110},{start:110,end:25},{start:25,end:228},{start:356,end:389},{start:389,end:368},{start:368,end:356},{start:11,end:302},{start:302,end:267},{start:267,end:11},{start:452,end:350},{start:350,end:349},{start:349,end:452},{start:302,end:303},{start:303,end:269},{start:269,end:302},{start:357,end:343},{start:343,end:277},{start:277,end:357},{start:452,end:453},{start:453,end:357},{start:357,end:452},{start:333,end:332},{start:332,end:297},{start:297,end:333},{start:175,end:152},{start:152,end:377},{start:377,end:175},{start:347,end:348},{start:348,end:330},{start:330,end:347},{start:303,end:304},{start:304,end:270},{start:270,end:303},{start:9,end:336},{start:336,end:337},{start:337,end:9},{start:278,end:279},{start:279,end:360},{start:360,end:278},{start:418,end:262},{start:262,end:431},{start:431,end:418},{start:304,end:408},{start:408,end:409},{start:409,end:304},{start:310,end:415},{start:415,end:407},{start:407,end:310},{start:270,end:409},{start:409,end:410},{start:410,end:270},{start:450,end:348},{start:348,end:347},{start:347,end:450},{start:422,end:430},{start:430,end:434},{start:434,end:422},{start:313,end:314},{start:314,end:17},{start:17,end:313},{start:306,end:307},{start:307,end:375},{start:375,end:306},{start:387,end:388},{start:388,end:260},{start:260,end:387},{start:286,end:414},{start:414,end:398},{start:398,end:286},{start:335,end:406},{start:406,end:418},{start:418,end:335},{start:364,end:367},{start:367,end:416},{start:416,end:364},{start:423,end:358},{start:358,end:327},{start:327,end:423},{start:251,end:284},{start:284,end:298},{start:298,end:251},{start:281,end:5},{start:5,end:4},{start:4,end:281},{start:373,end:374},{start:374,end:253},{start:253,end:373},{start:307,end:320},{start:320,end:321},{start:321,end:307},{start:425,end:427},{start:427,end:411},{start:411,end:425},{start:421,end:313},{start:313,end:18},{start:18,end:421},{start:321,end:405},{start:405,end:406},{start:406,end:321},{start:320,end:404},{start:404,end:405},{start:405,end:320},{start:315,end:16},{start:16,end:17},{start:17,end:315},{start:426,end:425},{start:425,end:266},{start:266,end:426},{start:377,end:400},{start:400,end:369},{start:369,end:377},{start:322,end:391},{start:391,end:269},{start:269,end:322},{start:417,end:465},{start:465,end:464},{start:464,end:417},{start:386,end:257},{start:257,end:258},{start:258,end:386},{start:466,end:260},{start:260,end:388},{start:388,end:466},{start:456,end:399},{start:399,end:419},{start:419,end:456},{start:284,end:332},{start:332,end:333},{start:333,end:284},{start:417,end:285},{start:285,end:8},{start:8,end:417},{start:346,end:340},{start:340,end:261},{start:261,end:346},{start:413,end:441},{start:441,end:285},{start:285,end:413},{start:327,end:460},{start:460,end:328},{start:328,end:327},{start:355,end:371},{start:371,end:329},{start:329,end:355},{start:392,end:439},{start:439,end:438},{start:438,end:392},{start:382,end:341},{start:341,end:256},{start:256,end:382},{start:429,end:420},{start:420,end:360},{start:360,end:429},{start:364,end:394},{start:394,end:379},{start:379,end:364},{start:277,end:343},{start:343,end:437},{start:437,end:277},{start:443,end:444},{start:444,end:283},{start:283,end:443},{start:275,end:440},{start:440,end:363},{start:363,end:275},{start:431,end:262},{start:262,end:369},{start:369,end:431},{start:297,end:338},{start:338,end:337},{start:337,end:297},{start:273,end:375},{start:375,end:321},{start:321,end:273},{start:450,end:451},{start:451,end:349},{start:349,end:450},{start:446,end:342},{start:342,end:467},{start:467,end:446},{start:293,end:334},{start:334,end:282},{start:282,end:293},{start:458,end:461},{start:461,end:462},{start:462,end:458},{start:276,end:353},{start:353,end:383},{start:383,end:276},{start:308,end:324},{start:324,end:325},{start:325,end:308},{start:276,end:300},{start:300,end:293},{start:293,end:276},{start:372,end:345},{start:345,end:447},{start:447,end:372},{start:352,end:345},{start:345,end:340},{start:340,end:352},{start:274,end:1},{start:1,end:19},{start:19,end:274},{start:456,end:248},{start:248,end:281},{start:281,end:456},{start:436,end:427},{start:427,end:425},{start:425,end:436},{start:381,end:256},{start:256,end:252},{start:252,end:381},{start:269,end:391},{start:391,end:393},{start:393,end:269},{start:200,end:199},{start:199,end:428},{start:428,end:200},{start:266,end:330},{start:330,end:329},{start:329,end:266},{start:287,end:273},{start:273,end:422},{start:422,end:287},{start:250,end:462},{start:462,end:328},{start:328,end:250},{start:258,end:286},{start:286,end:384},{start:384,end:258},{start:265,end:353},{start:353,end:342},{start:342,end:265},{start:387,end:259},{start:259,end:257},{start:257,end:387},{start:424,end:431},{start:431,end:430},{start:430,end:424},{start:342,end:353},{start:353,end:276},{start:276,end:342},{start:273,end:335},{start:335,end:424},{start:424,end:273},{start:292,end:325},{start:325,end:307},{start:307,end:292},{start:366,end:447},{start:447,end:345},{start:345,end:366},{start:271,end:303},{start:303,end:302},{start:302,end:271},{start:423,end:266},{start:266,end:371},{start:371,end:423},{start:294,end:455},{start:455,end:460},{start:460,end:294},{start:279,end:278},{start:278,end:294},{start:294,end:279},{start:271,end:272},{start:272,end:304},{start:304,end:271},{start:432,end:434},{start:434,end:427},{start:427,end:432},{start:272,end:407},{start:407,end:408},{start:408,end:272},{start:394,end:430},{start:430,end:431},{start:431,end:394},{start:395,end:369},{start:369,end:400},{start:400,end:395},{start:334,end:333},{start:333,end:299},{start:299,end:334},{start:351,end:417},{start:417,end:168},{start:168,end:351},{start:352,end:280},{start:280,end:411},{start:411,end:352},{start:325,end:319},{start:319,end:320},{start:320,end:325},{start:295,end:296},{start:296,end:336},{start:336,end:295},{start:319,end:403},{start:403,end:404},{start:404,end:319},{start:330,end:348},{start:348,end:349},{start:349,end:330},{start:293,end:298},{start:298,end:333},{start:333,end:293},{start:323,end:454},{start:454,end:447},{start:447,end:323},{start:15,end:16},{start:16,end:315},{start:315,end:15},{start:358,end:429},{start:429,end:279},{start:279,end:358},{start:14,end:15},{start:15,end:316},{start:316,end:14},{start:285,end:336},{start:336,end:9},{start:9,end:285},{start:329,end:349},{start:349,end:350},{start:350,end:329},{start:374,end:380},{start:380,end:252},{start:252,end:374},{start:318,end:402},{start:402,end:403},{start:403,end:318},{start:6,end:197},{start:197,end:419},{start:419,end:6},{start:318,end:319},{start:319,end:325},{start:325,end:318},{start:367,end:364},{start:364,end:365},{start:365,end:367},{start:435,end:367},{start:367,end:397},{start:397,end:435},{start:344,end:438},{start:438,end:439},{start:439,end:344},{start:272,end:271},{start:271,end:311},{start:311,end:272},{start:195,end:5},{start:5,end:281},{start:281,end:195},{start:273,end:287},{start:287,end:291},{start:291,end:273},{start:396,end:428},{start:428,end:199},{start:199,end:396},{start:311,end:271},{start:271,end:268},{start:268,end:311},{start:283,end:444},{start:444,end:445},{start:445,end:283},{start:373,end:254},{start:254,end:339},{start:339,end:373},{start:282,end:334},{start:334,end:296},{start:296,end:282},{start:449,end:347},{start:347,end:346},{start:346,end:449},{start:264,end:447},{start:447,end:454},{start:454,end:264},{start:336,end:296},{start:296,end:299},{start:299,end:336},{start:338,end:10},{start:10,end:151},{start:151,end:338},{start:278,end:439},{start:439,end:455},{start:455,end:278},{start:292,end:407},{start:407,end:415},{start:415,end:292},{start:358,end:371},{start:371,end:355},{start:355,end:358},{start:340,end:345},{start:345,end:372},{start:372,end:340},{start:346,end:347},{start:347,end:280},{start:280,end:346},{start:442,end:443},{start:443,end:282},{start:282,end:442},{start:19,end:94},{start:94,end:370},{start:370,end:19},{start:441,end:442},{start:442,end:295},{start:295,end:441},{start:248,end:419},{start:419,end:197},{start:197,end:248},{start:263,end:255},{start:255,end:359},{start:359,end:263},{start:440,end:275},{start:275,end:274},{start:274,end:440},{start:300,end:383},{start:383,end:368},{start:368,end:300},{start:351,end:412},{start:412,end:465},{start:465,end:351},{start:263,end:467},{start:467,end:466},{start:466,end:263},{start:301,end:368},{start:368,end:389},{start:389,end:301},{start:395,end:378},{start:378,end:379},{start:379,end:395},{start:412,end:351},{start:351,end:419},{start:419,end:412},{start:436,end:426},{start:426,end:322},{start:322,end:436},{start:2,end:164},{start:164,end:393},{start:393,end:2},{start:370,end:462},{start:462,end:461},{start:461,end:370},{start:164,end:0},{start:0,end:267},{start:267,end:164},{start:302,end:11},{start:11,end:12},{start:12,end:302},{start:268,end:12},{start:12,end:13},{start:13,end:268},{start:293,end:300},{start:300,end:301},{start:301,end:293},{start:446,end:261},{start:261,end:340},{start:340,end:446},{start:330,end:266},{start:266,end:425},{start:425,end:330},{start:426,end:423},{start:423,end:391},{start:391,end:426},{start:429,end:355},{start:355,end:437},{start:437,end:429},{start:391,end:327},{start:327,end:326},{start:326,end:391},{start:440,end:457},{start:457,end:438},{start:438,end:440},{start:341,end:382},{start:382,end:362},{start:362,end:341},{start:459,end:457},{start:457,end:461},{start:461,end:459},{start:434,end:430},{start:430,end:394},{start:394,end:434},{start:414,end:463},{start:463,end:362},{start:362,end:414},{start:396,end:369},{start:369,end:262},{start:262,end:396},{start:354,end:461},{start:461,end:457},{start:457,end:354},{start:316,end:403},{start:403,end:402},{start:402,end:316},{start:315,end:404},{start:404,end:403},{start:403,end:315},{start:314,end:405},{start:405,end:404},{start:404,end:314},{start:313,end:406},{start:406,end:405},{start:405,end:313},{start:421,end:418},{start:418,end:406},{start:406,end:421},{start:366,end:401},{start:401,end:361},{start:361,end:366},{start:306,end:408},{start:408,end:407},{start:407,end:306},{start:291,end:409},{start:409,end:408},{start:408,end:291},{start:287,end:410},{start:410,end:409},{start:409,end:287},{start:432,end:436},{start:436,end:410},{start:410,end:432},{start:434,end:416},{start:416,end:411},{start:411,end:434},{start:264,end:368},{start:368,end:383},{start:383,end:264},{start:309,end:438},{start:438,end:457},{start:457,end:309},{start:352,end:376},{start:376,end:401},{start:401,end:352},{start:274,end:275},{start:275,end:4},{start:4,end:274},{start:421,end:428},{start:428,end:262},{start:262,end:421},{start:294,end:327},{start:327,end:358},{start:358,end:294},{start:433,end:416},{start:416,end:367},{start:367,end:433},{start:289,end:455},{start:455,end:439},{start:439,end:289},{start:462,end:370},{start:370,end:326},{start:326,end:462},{start:2,end:326},{start:326,end:370},{start:370,end:2},{start:305,end:460},{start:460,end:455},{start:455,end:305},{start:254,end:449},{start:449,end:448},{start:448,end:254},{start:255,end:261},{start:261,end:446},{start:446,end:255},{start:253,end:450},{start:450,end:449},{start:449,end:253},{start:252,end:451},{start:451,end:450},{start:450,end:252},{start:256,end:452},{start:452,end:451},{start:451,end:256},{start:341,end:453},{start:453,end:452},{start:452,end:341},{start:413,end:464},{start:464,end:463},{start:463,end:413},{start:441,end:413},{start:413,end:414},{start:414,end:441},{start:258,end:442},{start:442,end:441},{start:441,end:258},{start:257,end:443},{start:443,end:442},{start:442,end:257},{start:259,end:444},{start:444,end:443},{start:443,end:259},{start:260,end:445},{start:445,end:444},{start:444,end:260},{start:467,end:342},{start:342,end:445},{start:445,end:467},{start:459,end:458},{start:458,end:250},{start:250,end:459},{start:289,end:392},{start:392,end:290},{start:290,end:289},{start:290,end:328},{start:328,end:460},{start:460,end:290},{start:376,end:433},{start:433,end:435},{start:435,end:376},{start:250,end:290},{start:290,end:392},{start:392,end:250},{start:411,end:416},{start:416,end:433},{start:433,end:411},{start:341,end:463},{start:463,end:464},{start:464,end:341},{start:453,end:464},{start:464,end:465},{start:465,end:453},{start:357,end:465},{start:465,end:412},{start:412,end:357},{start:343,end:412},{start:412,end:399},{start:399,end:343},{start:360,end:363},{start:363,end:440},{start:440,end:360},{start:437,end:399},{start:399,end:456},{start:456,end:437},{start:420,end:456},{start:456,end:363},{start:363,end:420},{start:401,end:435},{start:435,end:288},{start:288,end:401},{start:372,end:383},{start:383,end:353},{start:353,end:372},{start:339,end:255},{start:255,end:249},{start:249,end:339},{start:448,end:261},{start:261,end:255},{start:255,end:448},{start:133,end:243},{start:243,end:190},{start:190,end:133},{start:133,end:155},{start:155,end:112},{start:112,end:133},{start:33,end:246},{start:246,end:247},{start:247,end:33},{start:33,end:130},{start:130,end:25},{start:25,end:33},{start:398,end:384},{start:384,end:286},{start:286,end:398},{start:362,end:398},{start:398,end:414},{start:414,end:362},{start:362,end:463},{start:463,end:341},{start:341,end:362},{start:263,end:359},{start:359,end:467},{start:467,end:263},{start:263,end:249},{start:249,end:255},{start:255,end:263},{start:466,end:467},{start:467,end:260},{start:260,end:466},{start:75,end:60},{start:60,end:166},{start:166,end:75},{start:238,end:239},{start:239,end:79},{start:79,end:238},{start:162,end:127},{start:127,end:139},{start:139,end:162},{start:72,end:11},{start:11,end:37},{start:37,end:72},{start:121,end:232},{start:232,end:120},{start:120,end:121},{start:73,end:72},{start:72,end:39},{start:39,end:73},{start:114,end:128},{start:128,end:47},{start:47,end:114},{start:233,end:232},{start:232,end:128},{start:128,end:233},{start:103,end:104},{start:104,end:67},{start:67,end:103},{start:152,end:175},{start:175,end:148},{start:148,end:152},{start:119,end:118},{start:118,end:101},{start:101,end:119},{start:74,end:73},{start:73,end:40},{start:40,end:74},{start:107,end:9},{start:9,end:108},{start:108,end:107},{start:49,end:48},{start:48,end:131},{start:131,end:49},{start:32,end:194},{start:194,end:211},{start:211,end:32},{start:184,end:74},{start:74,end:185},{start:185,end:184},{start:191,end:80},{start:80,end:183},{start:183,end:191},{start:185,end:40},{start:40,end:186},{start:186,end:185},{start:119,end:230},{start:230,end:118},{start:118,end:119},{start:210,end:202},{start:202,end:214},{start:214,end:210},{start:84,end:83},{start:83,end:17},{start:17,end:84},{start:77,end:76},{start:76,end:146},{start:146,end:77},{start:161,end:160},{start:160,end:30},{start:30,end:161},{start:190,end:56},{start:56,end:173},{start:173,end:190},{start:182,end:106},{start:106,end:194},{start:194,end:182},{start:138,end:135},{start:135,end:192},{start:192,end:138},{start:129,end:203},{start:203,end:98},{start:98,end:129},{start:54,end:21},{start:21,end:68},{start:68,end:54},{start:5,end:51},{start:51,end:4},{start:4,end:5},{start:145,end:144},{start:144,end:23},{start:23,end:145},{start:90,end:77},{start:77,end:91},{start:91,end:90},{start:207,end:205},{start:205,end:187},{start:187,end:207},{start:83,end:201},{start:201,end:18},{start:18,end:83},{start:181,end:91},{start:91,end:182},{start:182,end:181},{start:180,end:90},{start:90,end:181},{start:181,end:180},{start:16,end:85},{start:85,end:17},{start:17,end:16},{start:205,end:206},{start:206,end:36},{start:36,end:205},{start:176,end:148},{start:148,end:140},{start:140,end:176},{start:165,end:92},{start:92,end:39},{start:39,end:165},{start:245,end:193},{start:193,end:244},{start:244,end:245},{start:27,end:159},{start:159,end:28},{start:28,end:27},{start:30,end:247},{start:247,end:161},{start:161,end:30},{start:174,end:236},{start:236,end:196},{start:196,end:174},{start:103,end:54},{start:54,end:104},{start:104,end:103},{start:55,end:193},{start:193,end:8},{start:8,end:55},{start:111,end:117},{start:117,end:31},{start:31,end:111},{start:221,end:189},{start:189,end:55},{start:55,end:221},{start:240,end:98},{start:98,end:99},{start:99,end:240},{start:142,end:126},{start:126,end:100},{start:100,end:142},{start:219,end:166},{start:166,end:218},{start:218,end:219},{start:112,end:155},{start:155,end:26},{start:26,end:112},{start:198,end:209},{start:209,end:131},{start:131,end:198},{start:169,end:135},{start:135,end:150},{start:150,end:169},{start:114,end:47},{start:47,end:217},{start:217,end:114},{start:224,end:223},{start:223,end:53},{start:53,end:224},{start:220,end:45},{start:45,end:134},{start:134,end:220},{start:32,end:211},{start:211,end:140},{start:140,end:32},{start:109,end:67},{start:67,end:108},{start:108,end:109},{start:146,end:43},{start:43,end:91},{start:91,end:146},{start:231,end:230},{start:230,end:120},{start:120,end:231},{start:113,end:226},{start:226,end:247},{start:247,end:113},{start:105,end:63},{start:63,end:52},{start:52,end:105},{start:241,end:238},{start:238,end:242},{start:242,end:241},{start:124,end:46},{start:46,end:156},{start:156,end:124},{start:95,end:78},{start:78,end:96},{start:96,end:95},{start:70,end:46},{start:46,end:63},{start:63,end:70},{start:116,end:143},{start:143,end:227},{start:227,end:116},{start:116,end:123},{start:123,end:111},{start:111,end:116},{start:1,end:44},{start:44,end:19},{start:19,end:1},{start:3,end:236},{start:236,end:51},{start:51,end:3},{start:207,end:216},{start:216,end:205},{start:205,end:207},{start:26,end:154},{start:154,end:22},{start:22,end:26},{start:165,end:39},{start:39,end:167},{start:167,end:165},{start:199,end:200},{start:200,end:208},{start:208,end:199},{start:101,end:36},{start:36,end:100},{start:100,end:101},{start:43,end:57},{start:57,end:202},{start:202,end:43},{start:242,end:20},{start:20,end:99},{start:99,end:242},{start:56,end:28},{start:28,end:157},{start:157,end:56},{start:124,end:35},{start:35,end:113},{start:113,end:124},{start:29,end:160},{start:160,end:27},{start:27,end:29},{start:211,end:204},{start:204,end:210},{start:210,end:211},{start:124,end:113},{start:113,end:46},{start:46,end:124},{start:106,end:43},{start:43,end:204},{start:204,end:106},{start:96,end:62},{start:62,end:77},{start:77,end:96},{start:227,end:137},{start:137,end:116},{start:116,end:227},{start:73,end:41},{start:41,end:72},{start:72,end:73},{start:36,end:203},{start:203,end:142},{start:142,end:36},{start:235,end:64},{start:64,end:240},{start:240,end:235},{start:48,end:49},{start:49,end:64},{start:64,end:48},{start:42,end:41},{start:41,end:74},{start:74,end:42},{start:214,end:212},{start:212,end:207},{start:207,end:214},{start:183,end:42},{start:42,end:184},{start:184,end:183},{start:210,end:169},{start:169,end:211},{start:211,end:210},{start:140,end:170},{start:170,end:176},{start:176,end:140},{start:104,end:105},{start:105,end:69},{start:69,end:104},{start:193,end:122},{start:122,end:168},{start:168,end:193},{start:50,end:123},{start:123,end:187},{start:187,end:50},{start:89,end:96},{start:96,end:90},{start:90,end:89},{start:66,end:65},{start:65,end:107},{start:107,end:66},{start:179,end:89},{start:89,end:180},{start:180,end:179},{start:119,end:101},{start:101,end:120},{start:120,end:119},{start:68,end:63},{start:63,end:104},{start:104,end:68},{start:234,end:93},{start:93,end:227},{start:227,end:234},{start:16,end:15},{start:15,end:85},{start:85,end:16},{start:209,end:129},{start:129,end:49},{start:49,end:209},{start:15,end:14},{start:14,end:86},{start:86,end:15},{start:107,end:55},{start:55,end:9},{start:9,end:107},{start:120,end:100},{start:100,end:121},{start:121,end:120},{start:153,end:145},{start:145,end:22},{start:22,end:153},{start:178,end:88},{start:88,end:179},{start:179,end:178},{start:197,end:6},{start:6,end:196},{start:196,end:197},{start:89,end:88},{start:88,end:96},{start:96,end:89},{start:135,end:138},{start:138,end:136},{start:136,end:135},{start:138,end:215},{start:215,end:172},{start:172,end:138},{start:218,end:115},{start:115,end:219},{start:219,end:218},{start:41,end:42},{start:42,end:81},{start:81,end:41},{start:5,end:195},{start:195,end:51},{start:51,end:5},{start:57,end:43},{start:43,end:61},{start:61,end:57},{start:208,end:171},{start:171,end:199},{start:199,end:208},{start:41,end:81},{start:81,end:38},{start:38,end:41},{start:224,end:53},{start:53,end:225},{start:225,end:224},{start:24,end:144},{start:144,end:110},{start:110,end:24},{start:105,end:52},{start:52,end:66},{start:66,end:105},{start:118,end:229},{start:229,end:117},{start:117,end:118},{start:227,end:34},{start:34,end:234},{start:234,end:227},{start:66,end:107},{start:107,end:69},{start:69,end:66},{start:10,end:109},{start:109,end:151},{start:151,end:10},{start:219,end:48},{start:48,end:235},{start:235,end:219},{start:183,end:62},{start:62,end:191},{start:191,end:183},{start:142,end:129},{start:129,end:126},{start:126,end:142},{start:116,end:111},{start:111,end:143},{start:143,end:116},{start:118,end:117},{start:117,end:50},{start:50,end:118},{start:223,end:222},{start:222,end:52},{start:52,end:223},{start:94,end:19},{start:19,end:141},{start:141,end:94},{start:222,end:221},{start:221,end:65},{start:65,end:222},{start:196,end:3},{start:3,end:197},{start:197,end:196},{start:45,end:220},{start:220,end:44},{start:44,end:45},{start:156,end:70},{start:70,end:139},{start:139,end:156},{start:188,end:122},{start:122,end:245},{start:245,end:188},{start:139,end:71},{start:71,end:162},{start:162,end:139},{start:149,end:170},{start:170,end:150},{start:150,end:149},{start:122,end:188},{start:188,end:196},{start:196,end:122},{start:206,end:216},{start:216,end:92},{start:92,end:206},{start:164,end:2},{start:2,end:167},{start:167,end:164},{start:242,end:141},{start:141,end:241},{start:241,end:242},{start:0,end:164},{start:164,end:37},{start:37,end:0},{start:11,end:72},{start:72,end:12},{start:12,end:11},{start:12,end:38},{start:38,end:13},{start:13,end:12},{start:70,end:63},{start:63,end:71},{start:71,end:70},{start:31,end:226},{start:226,end:111},{start:111,end:31},{start:36,end:101},{start:101,end:205},{start:205,end:36},{start:203,end:206},{start:206,end:165},{start:165,end:203},{start:126,end:209},{start:209,end:217},{start:217,end:126},{start:98,end:165},{start:165,end:97},{start:97,end:98},{start:237,end:220},{start:220,end:218},{start:218,end:237},{start:237,end:239},{start:239,end:241},{start:241,end:237},{start:210,end:214},{start:214,end:169},{start:169,end:210},{start:140,end:171},{start:171,end:32},{start:32,end:140},{start:241,end:125},{start:125,end:237},{start:237,end:241},{start:179,end:86},{start:86,end:178},{start:178,end:179},{start:180,end:85},{start:85,end:179},{start:179,end:180},{start:181,end:84},{start:84,end:180},{start:180,end:181},{start:182,end:83},{start:83,end:181},{start:181,end:182},{start:194,end:201},{start:201,end:182},{start:182,end:194},{start:177,end:137},{start:137,end:132},{start:132,end:177},{start:184,end:76},{start:76,end:183},{start:183,end:184},{start:185,end:61},{start:61,end:184},{start:184,end:185},{start:186,end:57},{start:57,end:185},{start:185,end:186},{start:216,end:212},{start:212,end:186},{start:186,end:216},{start:192,end:214},{start:214,end:187},{start:187,end:192},{start:139,end:34},{start:34,end:156},{start:156,end:139},{start:218,end:79},{start:79,end:237},{start:237,end:218},{start:147,end:123},{start:123,end:177},{start:177,end:147},{start:45,end:44},{start:44,end:4},{start:4,end:45},{start:208,end:201},{start:201,end:32},{start:32,end:208},{start:98,end:64},{start:64,end:129},{start:129,end:98},{start:192,end:213},{start:213,end:138},{start:138,end:192},{start:235,end:59},{start:59,end:219},{start:219,end:235},{start:141,end:242},{start:242,end:97},{start:97,end:141},{start:97,end:2},{start:2,end:141},{start:141,end:97},{start:240,end:75},{start:75,end:235},{start:235,end:240},{start:229,end:24},{start:24,end:228},{start:228,end:229},{start:31,end:25},{start:25,end:226},{start:226,end:31},{start:230,end:23},{start:23,end:229},{start:229,end:230},{start:231,end:22},{start:22,end:230},{start:230,end:231},{start:232,end:26},{start:26,end:231},{start:231,end:232},{start:233,end:112},{start:112,end:232},{start:232,end:233},{start:244,end:189},{start:189,end:243},{start:243,end:244},{start:189,end:221},{start:221,end:190},{start:190,end:189},{start:222,end:28},{start:28,end:221},{start:221,end:222},{start:223,end:27},{start:27,end:222},{start:222,end:223},{start:224,end:29},{start:29,end:223},{start:223,end:224},{start:225,end:30},{start:30,end:224},{start:224,end:225},{start:113,end:247},{start:247,end:225},{start:225,end:113},{start:99,end:60},{start:60,end:240},{start:240,end:99},{start:213,end:147},{start:147,end:215},{start:215,end:213},{start:60,end:20},{start:20,end:166},{start:166,end:60},{start:192,end:187},{start:187,end:213},{start:213,end:192},{start:243,end:112},{start:112,end:244},{start:244,end:243},{start:244,end:233},{start:233,end:245},{start:245,end:244},{start:245,end:128},{start:128,end:188},{start:188,end:245},{start:188,end:114},{start:114,end:174},{start:174,end:188},{start:134,end:131},{start:131,end:220},{start:220,end:134},{start:174,end:217},{start:217,end:236},{start:236,end:174},{start:236,end:198},{start:198,end:134},{start:134,end:236},{start:215,end:177},{start:177,end:58},{start:58,end:215},{start:156,end:143},{start:143,end:124},{start:124,end:156},{start:25,end:110},{start:110,end:7},{start:7,end:25},{start:31,end:228},{start:228,end:25},{start:25,end:31},{start:264,end:356},{start:356,end:368},{start:368,end:264},{start:0,end:11},{start:11,end:267},{start:267,end:0},{start:451,end:452},{start:452,end:349},{start:349,end:451},{start:267,end:302},{start:302,end:269},{start:269,end:267},{start:350,end:357},{start:357,end:277},{start:277,end:350},{start:350,end:452},{start:452,end:357},{start:357,end:350},{start:299,end:333},{start:333,end:297},{start:297,end:299},{start:396,end:175},{start:175,end:377},{start:377,end:396},{start:280,end:347},{start:347,end:330},{start:330,end:280},{start:269,end:303},{start:303,end:270},{start:270,end:269},{start:151,end:9},{start:9,end:337},{start:337,end:151},{start:344,end:278},{start:278,end:360},{start:360,end:344},{start:424,end:418},{start:418,end:431},{start:431,end:424},{start:270,end:304},{start:304,end:409},{start:409,end:270},{start:272,end:310},{start:310,end:407},{start:407,end:272},{start:322,end:270},{start:270,end:410},{start:410,end:322},{start:449,end:450},{start:450,end:347},{start:347,end:449},{start:432,end:422},{start:422,end:434},{start:434,end:432},{start:18,end:313},{start:313,end:17},{start:17,end:18},{start:291,end:306},{start:306,end:375},{start:375,end:291},{start:259,end:387},{start:387,end:260},{start:260,end:259},{start:424,end:335},{start:335,end:418},{start:418,end:424},{start:434,end:364},{start:364,end:416},{start:416,end:434},{start:391,end:423},{start:423,end:327},{start:327,end:391},{start:301,end:251},{start:251,end:298},{start:298,end:301},{start:275,end:281},{start:281,end:4},{start:4,end:275},{start:254,end:373},{start:373,end:253},{start:253,end:254},{start:375,end:307},{start:307,end:321},{start:321,end:375},{start:280,end:425},{start:425,end:411},{start:411,end:280},{start:200,end:421},{start:421,end:18},{start:18,end:200},{start:335,end:321},{start:321,end:406},{start:406,end:335},{start:321,end:320},{start:320,end:405},{start:405,end:321},{start:314,end:315},{start:315,end:17},{start:17,end:314},{start:423,end:426},{start:426,end:266},{start:266,end:423},{start:396,end:377},{start:377,end:369},{start:369,end:396},{start:270,end:322},{start:322,end:269},{start:269,end:270},{start:413,end:417},{start:417,end:464},{start:464,end:413},{start:385,end:386},{start:386,end:258},{start:258,end:385},{start:248,end:456},{start:456,end:419},{start:419,end:248},{start:298,end:284},{start:284,end:333},{start:333,end:298},{start:168,end:417},{start:417,end:8},{start:8,end:168},{start:448,end:346},{start:346,end:261},{start:261,end:448},{start:417,end:413},{start:413,end:285},{start:285,end:417},{start:326,end:327},{start:327,end:328},{start:328,end:326},{start:277,end:355},{start:355,end:329},{start:329,end:277},{start:309,end:392},{start:392,end:438},{start:438,end:309},{start:381,end:382},{start:382,end:256},{start:256,end:381},{start:279,end:429},{start:429,end:360},{start:360,end:279},{start:365,end:364},{start:364,end:379},{start:379,end:365},{start:355,end:277},{start:277,end:437},{start:437,end:355},{start:282,end:443},{start:443,end:283},{start:283,end:282},{start:281,end:275},{start:275,end:363},{start:363,end:281},{start:395,end:431},{start:431,end:369},{start:369,end:395},{start:299,end:297},{start:297,end:337},{start:337,end:299},{start:335,end:273},{start:273,end:321},{start:321,end:335},{start:348,end:450},{start:450,end:349},{start:349,end:348},{start:359,end:446},{start:446,end:467},{start:467,end:359},{start:283,end:293},{start:293,end:282},{start:282,end:283},{start:250,end:458},{start:458,end:462},{start:462,end:250},{start:300,end:276},{start:276,end:383},{start:383,end:300},{start:292,end:308},{start:308,end:325},{start:325,end:292},{start:283,end:276},{start:276,end:293},{start:293,end:283},{start:264,end:372},{start:372,end:447},{start:447,end:264},{start:346,end:352},{start:352,end:340},{start:340,end:346},{start:354,end:274},{start:274,end:19},{start:19,end:354},{start:363,end:456},{start:456,end:281},{start:281,end:363},{start:426,end:436},{start:436,end:425},{start:425,end:426},{start:380,end:381},{start:381,end:252},{start:252,end:380},{start:267,end:269},{start:269,end:393},{start:393,end:267},{start:421,end:200},{start:200,end:428},{start:428,end:421},{start:371,end:266},{start:266,end:329},{start:329,end:371},{start:432,end:287},{start:287,end:422},{start:422,end:432},{start:290,end:250},{start:250,end:328},{start:328,end:290},{start:385,end:258},{start:258,end:384},{start:384,end:385},{start:446,end:265},{start:265,end:342},{start:342,end:446},{start:386,end:387},{start:387,end:257},{start:257,end:386},{start:422,end:424},{start:424,end:430},{start:430,end:422},{start:445,end:342},{start:342,end:276},{start:276,end:445},{start:422,end:273},{start:273,end:424},{start:424,end:422},{start:306,end:292},{start:292,end:307},{start:307,end:306},{start:352,end:366},{start:366,end:345},{start:345,end:352},{start:268,end:271},{start:271,end:302},{start:302,end:268},{start:358,end:423},{start:423,end:371},{start:371,end:358},{start:327,end:294},{start:294,end:460},{start:460,end:327},{start:331,end:279},{start:279,end:294},{start:294,end:331},{start:303,end:271},{start:271,end:304},{start:304,end:303},{start:436,end:432},{start:432,end:427},{start:427,end:436},{start:304,end:272},{start:272,end:408},{start:408,end:304},{start:395,end:394},{start:394,end:431},{start:431,end:395},{start:378,end:395},{start:395,end:400},{start:400,end:378},{start:296,end:334},{start:334,end:299},{start:299,end:296},{start:6,end:351},{start:351,end:168},{start:168,end:6},{start:376,end:352},{start:352,end:411},{start:411,end:376},{start:307,end:325},{start:325,end:320},{start:320,end:307},{start:285,end:295},{start:295,end:336},{start:336,end:285},{start:320,end:319},{start:319,end:404},{start:404,end:320},{start:329,end:330},{start:330,end:349},{start:349,end:329},{start:334,end:293},{start:293,end:333},{start:333,end:334},{start:366,end:323},{start:323,end:447},{start:447,end:366},{start:316,end:15},{start:15,end:315},{start:315,end:316},{start:331,end:358},{start:358,end:279},{start:279,end:331},{start:317,end:14},{start:14,end:316},{start:316,end:317},{start:8,end:285},{start:285,end:9},{start:9,end:8},{start:277,end:329},{start:329,end:350},{start:350,end:277},{start:253,end:374},{start:374,end:252},{start:252,end:253},{start:319,end:318},{start:318,end:403},{start:403,end:319},{start:351,end:6},{start:6,end:419},{start:419,end:351},{start:324,end:318},{start:318,end:325},{start:325,end:324},{start:397,end:367},{start:367,end:365},{start:365,end:397},{start:288,end:435},{start:435,end:397},{start:397,end:288},{start:278,end:344},{start:344,end:439},{start:439,end:278},{start:310,end:272},{start:272,end:311},{start:311,end:310},{start:248,end:195},{start:195,end:281},{start:281,end:248},{start:375,end:273},{start:273,end:291},{start:291,end:375},{start:175,end:396},{start:396,end:199},{start:199,end:175},{start:312,end:311},{start:311,end:268},{start:268,end:312},{start:276,end:283},{start:283,end:445},{start:445,end:276},{start:390,end:373},{start:373,end:339},{start:339,end:390},{start:295,end:282},{start:282,end:296},{start:296,end:295},{start:448,end:449},{start:449,end:346},{start:346,end:448},{start:356,end:264},{start:264,end:454},{start:454,end:356},{start:337,end:336},{start:336,end:299},{start:299,end:337},{start:337,end:338},{start:338,end:151},{start:151,end:337},{start:294,end:278},{start:278,end:455},{start:455,end:294},{start:308,end:292},{start:292,end:415},{start:415,end:308},{start:429,end:358},{start:358,end:355},{start:355,end:429},{start:265,end:340},{start:340,end:372},{start:372,end:265},{start:352,end:346},{start:346,end:280},{start:280,end:352},{start:295,end:442},{start:442,end:282},{start:282,end:295},{start:354,end:19},{start:19,end:370},{start:370,end:354},{start:285,end:441},{start:441,end:295},{start:295,end:285},{start:195,end:248},{start:248,end:197},{start:197,end:195},{start:457,end:440},{start:440,end:274},{start:274,end:457},{start:301,end:300},{start:300,end:368},{start:368,end:301},{start:417,end:351},{start:351,end:465},{start:465,end:417},{start:251,end:301},{start:301,end:389},{start:389,end:251},{start:394,end:395},{start:395,end:379},{start:379,end:394},{start:399,end:412},{start:412,end:419},{start:419,end:399},{start:410,end:436},{start:436,end:322},{start:322,end:410},{start:326,end:2},{start:2,end:393},{start:393,end:326},{start:354,end:370},{start:370,end:461},{start:461,end:354},{start:393,end:164},{start:164,end:267},{start:267,end:393},{start:268,end:302},{start:302,end:12},{start:12,end:268},{start:312,end:268},{start:268,end:13},{start:13,end:312},{start:298,end:293},{start:293,end:301},{start:301,end:298},{start:265,end:446},{start:446,end:340},{start:340,end:265},{start:280,end:330},{start:330,end:425},{start:425,end:280},{start:322,end:426},{start:426,end:391},{start:391,end:322},{start:420,end:429},{start:429,end:437},{start:437,end:420},{start:393,end:391},{start:391,end:326},{start:326,end:393},{start:344,end:440},{start:440,end:438},{start:438,end:344},{start:458,end:459},{start:459,end:461},{start:461,end:458},{start:364,end:434},{start:434,end:394},{start:394,end:364},{start:428,end:396},{start:396,end:262},{start:262,end:428},{start:274,end:354},{start:354,end:457},{start:457,end:274},{start:317,end:316},{start:316,end:402},{start:402,end:317},{start:316,end:315},{start:315,end:403},{start:403,end:316},{start:315,end:314},{start:314,end:404},{start:404,end:315},{start:314,end:313},{start:313,end:405},{start:405,end:314},{start:313,end:421},{start:421,end:406},{start:406,end:313},{start:323,end:366},{start:366,end:361},{start:361,end:323},{start:292,end:306},{start:306,end:407},{start:407,end:292},{start:306,end:291},{start:291,end:408},{start:408,end:306},{start:291,end:287},{start:287,end:409},{start:409,end:291},{start:287,end:432},{start:432,end:410},{start:410,end:287},{start:427,end:434},{start:434,end:411},{start:411,end:427},{start:372,end:264},{start:264,end:383},{start:383,end:372},{start:459,end:309},{start:309,end:457},{start:457,end:459},{start:366,end:352},{start:352,end:401},{start:401,end:366},{start:1,end:274},{start:274,end:4},{start:4,end:1},{start:418,end:421},{start:421,end:262},{start:262,end:418},{start:331,end:294},{start:294,end:358},{start:358,end:331},{start:435,end:433},{start:433,end:367},{start:367,end:435},{start:392,end:289},{start:289,end:439},{start:439,end:392},{start:328,end:462},{start:462,end:326},{start:326,end:328},{start:94,end:2},{start:2,end:370},{start:370,end:94},{start:289,end:305},{start:305,end:455},{start:455,end:289},{start:339,end:254},{start:254,end:448},{start:448,end:339},{start:359,end:255},{start:255,end:446},{start:446,end:359},{start:254,end:253},{start:253,end:449},{start:449,end:254},{start:253,end:252},{start:252,end:450},{start:450,end:253},{start:252,end:256},{start:256,end:451},{start:451,end:252},{start:256,end:341},{start:341,end:452},{start:452,end:256},{start:414,end:413},{start:413,end:463},{start:463,end:414},{start:286,end:441},{start:441,end:414},{start:414,end:286},{start:286,end:258},{start:258,end:441},{start:441,end:286},{start:258,end:257},{start:257,end:442},{start:442,end:258},{start:257,end:259},{start:259,end:443},{start:443,end:257},{start:259,end:260},{start:260,end:444},{start:444,end:259},{start:260,end:467},{start:467,end:445},{start:445,end:260},{start:309,end:459},{start:459,end:250},{start:250,end:309},{start:305,end:289},{start:289,end:290},{start:290,end:305},{start:305,end:290},{start:290,end:460},{start:460,end:305},{start:401,end:376},{start:376,end:435},{start:435,end:401},{start:309,end:250},{start:250,end:392},{start:392,end:309},{start:376,end:411},{start:411,end:433},{start:433,end:376},{start:453,end:341},{start:341,end:464},{start:464,end:453},{start:357,end:453},{start:453,end:465},{start:465,end:357},{start:343,end:357},{start:357,end:412},{start:412,end:343},{start:437,end:343},{start:343,end:399},{start:399,end:437},{start:344,end:360},{start:360,end:440},{start:440,end:344},{start:420,end:437},{start:437,end:456},{start:456,end:420},{start:360,end:420},{start:420,end:363},{start:363,end:360},{start:361,end:401},{start:401,end:288},{start:288,end:361},{start:265,end:372},{start:372,end:353},{start:353,end:265},{start:390,end:339},{start:339,end:249},{start:249,end:390},{start:339,end:448},{start:448,end:255},{start:255,end:339}];var face_landmarker_options={};Object.defineProperty(face_landmarker_options,"__esModule",{value:!0});var face_landmarker_result={};Object.defineProperty(face_landmarker_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.FaceLandmarker=void 0;const o=calculator_pb,n=calculator_options_pb,i=classification_pb,a=landmark_pb,s=base_options_pb,p=face_detector_graph_options_pb,c=face_geometry_pb,l=face_landmarker_graph_options_pb,d=face_landmarks_detector_graph_options_pb,u=classifier_result,g=landmark_result,f=vision_task_runner,m=face_landmarks_connections;r(face_landmarker_options,e),r(face_landmarker_result,e);const h="image_in",y="norm_rect",b="face_landmarks",v="blendshapes",_="face_geometry",O=.5;class w extends f.VisionTaskRunner{static createFromOptions(e,t){return f.VisionTaskRunner.createVisionInstance(w,e,t)}static createFromModelBuffer(e,t){return f.VisionTaskRunner.createVisionInstance(w,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return f.VisionTaskRunner.createVisionInstance(w,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new f.VisionGraphRunner(e,t),h,y,!1),this.result={faceLandmarks:[],faceBlendshapes:[],facialTransformationMatrixes:[]},this.outputFaceBlendshapes=!1,this.outputFacialTransformationMatrixes=!1,this.options=new l.FaceLandmarkerGraphOptions,this.options.setBaseOptions(new s.BaseOptions),this.faceLandmarksDetectorGraphOptions=new d.FaceLandmarksDetectorGraphOptions,this.options.setFaceLandmarksDetectorGraphOptions(this.faceLandmarksDetectorGraphOptions),this.faceDetectorGraphOptions=new p.FaceDetectorGraphOptions,this.options.setFaceDetectorGraphOptions(this.faceDetectorGraphOptions),this.initDefaults()}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r,o,n;return"numFaces"in e&&this.faceDetectorGraphOptions.setNumFaces(null!==(t=e.numFaces)&&void 0!==t?t:1),"minFaceDetectionConfidence"in e&&this.faceDetectorGraphOptions.setMinDetectionConfidence(null!==(r=e.minFaceDetectionConfidence)&&void 0!==r?r:O),"minTrackingConfidence"in e&&this.options.setMinTrackingConfidence(null!==(o=e.minTrackingConfidence)&&void 0!==o?o:O),"minFacePresenceConfidence"in e&&this.faceLandmarksDetectorGraphOptions.setMinDetectionConfidence(null!==(n=e.minFacePresenceConfidence)&&void 0!==n?n:O),"outputFaceBlendshapes"in e&&(this.outputFaceBlendshapes=!!e.outputFaceBlendshapes),"outputFacialTransformationMatrixes"in e&&(this.outputFacialTransformationMatrixes=!!e.outputFacialTransformationMatrixes),this.applyOptions(e)}detect(e,t){return this.resetResults(),this.processImageData(e,t),this.result}detectForVideo(e,t,r){return this.resetResults(),this.processVideoData(e,r,t),this.result}resetResults(){this.result={faceLandmarks:[],faceBlendshapes:[],facialTransformationMatrixes:[]}}initDefaults(){this.faceDetectorGraphOptions.setNumFaces(1),this.faceDetectorGraphOptions.setMinDetectionConfidence(O),this.faceLandmarksDetectorGraphOptions.setMinDetectionConfidence(O),this.options.setMinTrackingConfidence(O)}addJsLandmarks(e){for(const t of e){const e=a.NormalizedLandmarkList.deserializeBinary(t);this.result.faceLandmarks.push((0,g.convertToLandmarks)(e))}}addBlenshape(e){var t;if(this.outputFaceBlendshapes)for(const r of e){const e=i.ClassificationList.deserializeBinary(r);this.result.faceBlendshapes.push((0,u.convertFromClassifications)(null!==(t=e.getClassificationList())&&void 0!==t?t:[]))}}addFacialTransformationMatrixes(e){var t,r,o;if(this.outputFacialTransformationMatrixes)for(const n of e){const e=c.FaceGeometry.deserializeBinary(n).getPoseTransformMatrix();e&&this.result.facialTransformationMatrixes.push({rows:null!==(t=e.getRows())&&void 0!==t?t:0,columns:null!==(r=e.getCols())&&void 0!==r?r:0,data:null!==(o=e.getPackedDataList())&&void 0!==o?o:[]})}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(h),e.addInputStream(y),e.addOutputStream(b);const t=new n.CalculatorOptions;t.setExtension(l.FaceLandmarkerGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.face_landmarker.FaceLandmarkerGraph"),r.addInputStream("IMAGE:"+h),r.addInputStream("NORM_RECT:"+y),r.addOutputStream("NORM_LANDMARKS:"+b),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoVectorListener(b,(e,t)=>{this.addJsLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(b,e=>{this.setLatestOutputTimestamp(e)}),this.outputFaceBlendshapes&&(e.addOutputStream(v),r.addOutputStream("BLENDSHAPES:"+v),this.graphRunner.attachProtoVectorListener(v,(e,t)=>{this.addBlenshape(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(v,e=>{this.setLatestOutputTimestamp(e)})),this.outputFacialTransformationMatrixes&&(e.addOutputStream(_),r.addOutputStream("FACE_GEOMETRY:"+_),this.graphRunner.attachProtoVectorListener(_,(e,t)=>{this.addFacialTransformationMatrixes(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(_,e=>{this.setLatestOutputTimestamp(e)}));const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.FaceLandmarker=w,w.FACE_LANDMARKS_LIPS=m.FACE_LANDMARKS_LIPS,w.FACE_LANDMARKS_LEFT_EYE=m.FACE_LANDMARKS_LEFT_EYE,w.FACE_LANDMARKS_LEFT_EYEBROW=m.FACE_LANDMARKS_LEFT_EYEBROW,w.FACE_LANDMARKS_LEFT_IRIS=m.FACE_LANDMARKS_LEFT_IRIS,w.FACE_LANDMARKS_RIGHT_EYE=m.FACE_LANDMARKS_RIGHT_EYE,w.FACE_LANDMARKS_RIGHT_EYEBROW=m.FACE_LANDMARKS_RIGHT_EYEBROW,w.FACE_LANDMARKS_RIGHT_IRIS=m.FACE_LANDMARKS_RIGHT_IRIS,w.FACE_LANDMARKS_FACE_OVAL=m.FACE_LANDMARKS_FACE_OVAL,w.FACE_LANDMARKS_CONTOURS=m.FACE_LANDMARKS_CONTOURS,w.FACE_LANDMARKS_TESSELATION=m.FACE_LANDMARKS_TESSELATION}(face_landmarker);var face_stylizer={},face_stylizer_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=face_landmarker_graph_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions",null,o),proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.displayName="proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),faceLandmarkerGraphOptions:(o=r.getFaceLandmarkerGraphOptions())&&s.FaceLandmarkerGraphOptions.toObject(e,o),faceAlignmentSize:t.Message.getFieldWithDefault(r,3,256)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions;return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new s.FaceLandmarkerGraphOptions,t.readMessage(r,s.FaceLandmarkerGraphOptions.deserializeBinaryFromReader),e.setFaceLandmarkerGraphOptions(r);break;case 3:r=t.readInt32(),e.setFaceAlignmentSize(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=e.getFaceLandmarkerGraphOptions())&&r.writeMessage(2,o,s.FaceLandmarkerGraphOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext=new t.ExtensionFieldInfo(513916220,{ext:0},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[513916220]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[513916220]=proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getFaceLandmarkerGraphOptions=function(){return t.Message.getWrapperField(this,s.FaceLandmarkerGraphOptions,2)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setFaceLandmarkerGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearFaceLandmarkerGraphOptions=function(){return this.setFaceLandmarkerGraphOptions(void 0)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasFaceLandmarkerGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getFaceAlignmentSize=function(){return t.Message.getFieldWithDefault(this,3,256)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setFaceAlignmentSize=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearFaceAlignmentSize=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasFaceAlignmentSize=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext=new t.ExtensionFieldInfo(513916220,{ext:0},proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[513916220]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[513916220]=proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.face_stylizer.proto)}(face_stylizer_graph_options_pb);var face_stylizer_options={};Object.defineProperty(face_stylizer_options,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.FaceStylizer=void 0;const o=calculator_pb,n=calculator_options_pb,i=base_options_pb,a=face_stylizer_graph_options_pb,s=vision_task_runner;r(face_stylizer_options,e);const p="image_in",c="norm_rect",l="stylized_image";class d extends s.VisionTaskRunner{static createFromOptions(e,t){return s.VisionTaskRunner.createVisionInstance(d,e,t)}static createFromModelBuffer(e,t){return s.VisionTaskRunner.createVisionInstance(d,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return s.VisionTaskRunner.createVisionInstance(d,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new s.VisionGraphRunner(e,t),p,c,!0),this.options=new a.FaceStylizerGraphOptions,this.options.setBaseOptions(new i.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){return super.applyOptions(e)}stylize(e,t,r){const o="function"!=typeof t?t:{};if(this.userCallback="function"==typeof t?t:r,this.processImageData(e,null!=o?o:{}),!this.userCallback)return this.result}stylizeForVideo(e,t,r,o){const n="function"!=typeof r?r:{};if(this.userCallback="function"==typeof r?r:o,this.processVideoData(e,n,t),this.userCallback=void 0,!this.userCallback)return this.result}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(p),e.addInputStream(c),e.addOutputStream(l);const t=new n.CalculatorOptions;t.setExtension(a.FaceStylizerGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.face_stylizer.FaceStylizerGraph"),r.addInputStream("IMAGE:"+p),r.addInputStream("NORM_RECT:"+c),r.addOutputStream("STYLIZED_IMAGE:"+l),r.setOptions(t),e.addNode(r),this.graphRunner.attachImageListener(l,(e,t)=>{const r=this.convertToMPImage(e,!this.userCallback);this.result=r,this.userCallback&&this.userCallback(r),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(l,e=>{this.result=null,this.userCallback&&this.userCallback(null),this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.FaceStylizer=d}(face_stylizer);var gesture_recognizer={},gesture_classifier_graph_options_pb={},classifier_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.components.processors.proto.ClassifierOptions",null,o),proto.mediapipe.tasks.components.processors.proto.ClassifierOptions=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.components.processors.proto.ClassifierOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.displayName="proto.mediapipe.tasks.components.processors.proto.ClassifierOptions"),proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.repeatedFields_=[4,5],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.toObject(e,this)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.toObject=function(e,r){var o,n={displayNamesLocale:t.Message.getFieldWithDefault(r,1,"en"),maxResults:t.Message.getFieldWithDefault(r,2,-1),scoreThreshold:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,categoryAllowlistList:null==(o=t.Message.getRepeatedField(r,4))?void 0:o,categoryDenylistList:null==(o=t.Message.getRepeatedField(r,5))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.processors.proto.ClassifierOptions;return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setDisplayNamesLocale(r);break;case 2:r=t.readInt32(),e.setMaxResults(r);break;case 3:r=t.readFloat(),e.setScoreThreshold(r);break;case 4:r=t.readString(),e.addCategoryAllowlist(r);break;case 5:r=t.readString(),e.addCategoryDenylist(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),(o=e.getCategoryAllowlistList()).length>0&&r.writeRepeatedString(4,o),(o=e.getCategoryDenylistList()).length>0&&r.writeRepeatedString(5,o)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getDisplayNamesLocale=function(){return t.Message.getFieldWithDefault(this,1,"en")},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setDisplayNamesLocale=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearDisplayNamesLocale=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasDisplayNamesLocale=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getMaxResults=function(){return t.Message.getFieldWithDefault(this,2,-1)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setMaxResults=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearMaxResults=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasMaxResults=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getScoreThreshold=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setScoreThreshold=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearScoreThreshold=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasScoreThreshold=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getCategoryAllowlistList=function(){return t.Message.getRepeatedField(this,4)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setCategoryAllowlistList=function(e){return t.Message.setField(this,4,e||[])},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.addCategoryAllowlist=function(e,r){return t.Message.addToRepeatedField(this,4,e,r)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearCategoryAllowlistList=function(){return this.setCategoryAllowlistList([])},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getCategoryDenylistList=function(){return t.Message.getRepeatedField(this,5)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setCategoryDenylistList=function(e){return t.Message.setField(this,5,e||[])},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.addCategoryDenylist=function(e,r){return t.Message.addToRepeatedField(this,5,e,r)},proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearCategoryDenylistList=function(){return this.setCategoryDenylistList([])},r.object.extend(e,proto.mediapipe.tasks.components.processors.proto)}(classifier_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=classifier_options_pb;r.object.extend(proto,a);var s=base_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions",null,o),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.displayName="proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&s.BaseOptions.toObject(e,r),classifierOptions:(r=t.getClassifierOptions())&&a.ClassifierOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new s.BaseOptions;t.readMessage(r,s.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new a.ClassifierOptions,t.readMessage(r,a.ClassifierOptions.deserializeBinaryFromReader),e.setClassifierOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,s.BaseOptions.serializeBinaryToWriter),null!=(r=e.getClassifierOptions())&&t.writeMessage(2,r,a.ClassifierOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext=new t.ExtensionFieldInfo(478825465,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[478825465]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[478825465]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,s.BaseOptions,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.getClassifierOptions=function(){return t.Message.getWrapperField(this,a.ClassifierOptions,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.setClassifierOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.clearClassifierOptions=function(){return this.setClassifierOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.hasClassifierOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext=new t.ExtensionFieldInfo(478825465,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[478825465]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[478825465]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.gesture_recognizer.proto)}(gesture_classifier_graph_options_pb);var gesture_recognizer_graph_options_pb={},hand_gesture_recognizer_graph_options_pb={},gesture_embedder_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions",null,o),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.displayName="proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&a.BaseOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r)}else t.skipField();return e},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter=function(e,t){var r;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,a.BaseOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext=new t.ExtensionFieldInfo(478825422,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[478825422]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[478825422]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext=new t.ExtensionFieldInfo(478825422,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[478825422]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[478825422]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.gesture_recognizer.proto)}(gesture_embedder_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=gesture_classifier_graph_options_pb;r.object.extend(proto,s);var p=gesture_embedder_graph_options_pb;r.object.extend(proto,p),r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions",null,o),proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.displayName="proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&a.BaseOptions.toObject(e,r),gestureEmbedderGraphOptions:(r=t.getGestureEmbedderGraphOptions())&&p.GestureEmbedderGraphOptions.toObject(e,r),cannedGestureClassifierGraphOptions:(r=t.getCannedGestureClassifierGraphOptions())&&s.GestureClassifierGraphOptions.toObject(e,r),customGestureClassifierGraphOptions:(r=t.getCustomGestureClassifierGraphOptions())&&s.GestureClassifierGraphOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new p.GestureEmbedderGraphOptions,t.readMessage(r,p.GestureEmbedderGraphOptions.deserializeBinaryFromReader),e.setGestureEmbedderGraphOptions(r);break;case 3:r=new s.GestureClassifierGraphOptions,t.readMessage(r,s.GestureClassifierGraphOptions.deserializeBinaryFromReader),e.setCannedGestureClassifierGraphOptions(r);break;case 4:r=new s.GestureClassifierGraphOptions,t.readMessage(r,s.GestureClassifierGraphOptions.deserializeBinaryFromReader),e.setCustomGestureClassifierGraphOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,a.BaseOptions.serializeBinaryToWriter),null!=(r=e.getGestureEmbedderGraphOptions())&&t.writeMessage(2,r,p.GestureEmbedderGraphOptions.serializeBinaryToWriter),null!=(r=e.getCannedGestureClassifierGraphOptions())&&t.writeMessage(3,r,s.GestureClassifierGraphOptions.serializeBinaryToWriter),null!=(r=e.getCustomGestureClassifierGraphOptions())&&t.writeMessage(4,r,s.GestureClassifierGraphOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext=new t.ExtensionFieldInfo(463370452,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[463370452]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[463370452]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getGestureEmbedderGraphOptions=function(){return t.Message.getWrapperField(this,p.GestureEmbedderGraphOptions,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setGestureEmbedderGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearGestureEmbedderGraphOptions=function(){return this.setGestureEmbedderGraphOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasGestureEmbedderGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getCannedGestureClassifierGraphOptions=function(){return t.Message.getWrapperField(this,s.GestureClassifierGraphOptions,3)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setCannedGestureClassifierGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearCannedGestureClassifierGraphOptions=function(){return this.setCannedGestureClassifierGraphOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasCannedGestureClassifierGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getCustomGestureClassifierGraphOptions=function(){return t.Message.getWrapperField(this,s.GestureClassifierGraphOptions,4)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setCustomGestureClassifierGraphOptions=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearCustomGestureClassifierGraphOptions=function(){return this.setCustomGestureClassifierGraphOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasCustomGestureClassifierGraphOptions=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext=new t.ExtensionFieldInfo(463370452,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[463370452]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[463370452]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.gesture_recognizer.proto)}(hand_gesture_recognizer_graph_options_pb);var hand_landmarker_graph_options_pb={},hand_detector_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5),numHands:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions;return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;case 3:r=t.readInt32(),e.setNumHands(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext=new t.ExtensionFieldInfo(464864288,{ext:0},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[464864288]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[464864288]=proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getNumHands=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setNumHands=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearNumHands=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasNumHands=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext=new t.ExtensionFieldInfo(464864288,{ext:0},proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[464864288]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[464864288]=proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.hand_detector.proto)}(hand_detector_graph_options_pb);var hand_landmarks_detector_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions;return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(474472470,{ext:0},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[474472470]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[474472470]=proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(474472470,{ext:0},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[474472470]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[474472470]=proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.hand_landmarker.proto)}(hand_landmarks_detector_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=hand_detector_graph_options_pb;r.object.extend(proto,s);var p=hand_landmarks_detector_graph_options_pb;r.object.extend(proto,p),r.exportSymbol("proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions",null,o),proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.displayName="proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),handDetectorGraphOptions:(o=r.getHandDetectorGraphOptions())&&s.HandDetectorGraphOptions.toObject(e,o),handLandmarksDetectorGraphOptions:(o=r.getHandLandmarksDetectorGraphOptions())&&p.HandLandmarksDetectorGraphOptions.toObject(e,o),minTrackingConfidence:t.Message.getFloatingPointFieldWithDefault(r,4,.5)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions;return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new s.HandDetectorGraphOptions,t.readMessage(r,s.HandDetectorGraphOptions.deserializeBinaryFromReader),e.setHandDetectorGraphOptions(r);break;case 3:r=new p.HandLandmarksDetectorGraphOptions,t.readMessage(r,p.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader),e.setHandLandmarksDetectorGraphOptions(r);break;case 4:r=t.readFloat(),e.setMinTrackingConfidence(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=e.getHandDetectorGraphOptions())&&r.writeMessage(2,o,s.HandDetectorGraphOptions.serializeBinaryToWriter),null!=(o=e.getHandLandmarksDetectorGraphOptions())&&r.writeMessage(3,o,p.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(462713202,{ext:0},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[462713202]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[462713202]=proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getHandDetectorGraphOptions=function(){return t.Message.getWrapperField(this,s.HandDetectorGraphOptions,2)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setHandDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearHandDetectorGraphOptions=function(){return this.setHandDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasHandDetectorGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getHandLandmarksDetectorGraphOptions=function(){return t.Message.getWrapperField(this,p.HandLandmarksDetectorGraphOptions,3)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setHandLandmarksDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearHandLandmarksDetectorGraphOptions=function(){return this.setHandLandmarksDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasHandLandmarksDetectorGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getMinTrackingConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,.5)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setMinTrackingConfidence=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearMinTrackingConfidence=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasMinTrackingConfidence=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(462713202,{ext:0},proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[462713202]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[462713202]=proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.hand_landmarker.proto)}(hand_landmarker_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=hand_gesture_recognizer_graph_options_pb;r.object.extend(proto,s);var p=hand_landmarker_graph_options_pb;r.object.extend(proto,p),r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions",null,o),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.displayName="proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&a.BaseOptions.toObject(e,r),handLandmarkerGraphOptions:(r=t.getHandLandmarkerGraphOptions())&&p.HandLandmarkerGraphOptions.toObject(e,r),handGestureRecognizerGraphOptions:(r=t.getHandGestureRecognizerGraphOptions())&&s.HandGestureRecognizerGraphOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new p.HandLandmarkerGraphOptions,t.readMessage(r,p.HandLandmarkerGraphOptions.deserializeBinaryFromReader),e.setHandLandmarkerGraphOptions(r);break;case 3:r=new s.HandGestureRecognizerGraphOptions,t.readMessage(r,s.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader),e.setHandGestureRecognizerGraphOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,a.BaseOptions.serializeBinaryToWriter),null!=(r=e.getHandLandmarkerGraphOptions())&&t.writeMessage(2,r,p.HandLandmarkerGraphOptions.serializeBinaryToWriter),null!=(r=e.getHandGestureRecognizerGraphOptions())&&t.writeMessage(3,r,s.HandGestureRecognizerGraphOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext=new t.ExtensionFieldInfo(479097054,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[479097054]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[479097054]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getHandLandmarkerGraphOptions=function(){return t.Message.getWrapperField(this,p.HandLandmarkerGraphOptions,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setHandLandmarkerGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearHandLandmarkerGraphOptions=function(){return this.setHandLandmarkerGraphOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasHandLandmarkerGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getHandGestureRecognizerGraphOptions=function(){return t.Message.getWrapperField(this,s.HandGestureRecognizerGraphOptions,3)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setHandGestureRecognizerGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearHandGestureRecognizerGraphOptions=function(){return this.setHandGestureRecognizerGraphOptions(void 0)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasHandGestureRecognizerGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext=new t.ExtensionFieldInfo(479097054,{ext:0},proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[479097054]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[479097054]=proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.gesture_recognizer.proto)}(gesture_recognizer_graph_options_pb);var classifier_options={};Object.defineProperty(classifier_options,"__esModule",{value:!0}),classifier_options.convertClassifierOptionsToProto=void 0;const classifier_options_pb_1=classifier_options_pb;function convertClassifierOptionsToProto(e,t){const r=t?t.clone():new classifier_options_pb_1.ClassifierOptions;return void 0!==e.displayNamesLocale?r.setDisplayNamesLocale(e.displayNamesLocale):void 0===e.displayNamesLocale&&r.clearDisplayNamesLocale(),void 0!==e.maxResults?r.setMaxResults(e.maxResults):"maxResults"in e&&r.clearMaxResults(),void 0!==e.scoreThreshold?r.setScoreThreshold(e.scoreThreshold):"scoreThreshold"in e&&r.clearScoreThreshold(),void 0!==e.categoryAllowlist?r.setCategoryAllowlistList(e.categoryAllowlist):"categoryAllowlist"in e&&r.clearCategoryAllowlistList(),void 0!==e.categoryDenylist?r.setCategoryDenylistList(e.categoryDenylist):"categoryDenylist"in e&&r.clearCategoryDenylistList(),r}classifier_options.convertClassifierOptionsToProto=convertClassifierOptionsToProto;var hand_landmarks_connections={};Object.defineProperty(hand_landmarks_connections,"__esModule",{value:!0}),hand_landmarks_connections.HAND_CONNECTIONS=void 0,hand_landmarks_connections.HAND_CONNECTIONS=[{start:0,end:1},{start:1,end:2},{start:2,end:3},{start:3,end:4},{start:0,end:5},{start:5,end:6},{start:6,end:7},{start:7,end:8},{start:5,end:9},{start:9,end:10},{start:10,end:11},{start:11,end:12},{start:9,end:13},{start:13,end:14},{start:14,end:15},{start:15,end:16},{start:13,end:17},{start:0,end:17},{start:17,end:18},{start:18,end:19},{start:19,end:20}];var gesture_recognizer_options={};Object.defineProperty(gesture_recognizer_options,"__esModule",{value:!0});var gesture_recognizer_result={};Object.defineProperty(gesture_recognizer_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.GestureRecognizer=void 0;const o=calculator_pb,n=calculator_options_pb,i=classification_pb,a=landmark_pb,s=base_options_pb,p=gesture_classifier_graph_options_pb,c=gesture_recognizer_graph_options_pb,l=hand_gesture_recognizer_graph_options_pb,d=hand_detector_graph_options_pb,u=hand_landmarker_graph_options_pb,g=hand_landmarks_detector_graph_options_pb,f=classifier_options,m=vision_task_runner,h=hand_landmarks_connections;r(gesture_recognizer_options,e),r(gesture_recognizer_result,e);const y="image_in",b="norm_rect",v="hand_gestures",_="hand_landmarks",O="world_hand_landmarks",w="handedness",S=.5;class E extends m.VisionTaskRunner{static createFromOptions(e,t){return m.VisionTaskRunner.createVisionInstance(E,e,t)}static createFromModelBuffer(e,t){return m.VisionTaskRunner.createVisionInstance(E,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return m.VisionTaskRunner.createVisionInstance(E,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new m.VisionGraphRunner(e,t),y,b,!1),this.gestures=[],this.landmarks=[],this.worldLandmarks=[],this.handednesses=[],this.options=new c.GestureRecognizerGraphOptions,this.options.setBaseOptions(new s.BaseOptions),this.handLandmarkerGraphOptions=new u.HandLandmarkerGraphOptions,this.options.setHandLandmarkerGraphOptions(this.handLandmarkerGraphOptions),this.handLandmarksDetectorGraphOptions=new g.HandLandmarksDetectorGraphOptions,this.handLandmarkerGraphOptions.setHandLandmarksDetectorGraphOptions(this.handLandmarksDetectorGraphOptions),this.handDetectorGraphOptions=new d.HandDetectorGraphOptions,this.handLandmarkerGraphOptions.setHandDetectorGraphOptions(this.handDetectorGraphOptions),this.handGestureRecognizerGraphOptions=new l.HandGestureRecognizerGraphOptions,this.options.setHandGestureRecognizerGraphOptions(this.handGestureRecognizerGraphOptions),this.handDetectorGraphOptions.setMinDetectionConfidence(S),this.handLandmarkerGraphOptions.setMinTrackingConfidence(S),this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(S)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r,o,n,i,a,s,c;if(this.handDetectorGraphOptions.setNumHands(null!==(t=e.numHands)&&void 0!==t?t:1),"minHandDetectionConfidence"in e&&this.handDetectorGraphOptions.setMinDetectionConfidence(null!==(r=e.minHandDetectionConfidence)&&void 0!==r?r:S),"minTrackingConfidence"in e&&this.handLandmarkerGraphOptions.setMinTrackingConfidence(null!==(o=e.minTrackingConfidence)&&void 0!==o?o:S),"minHandPresenceConfidence"in e&&this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(null!==(n=e.minHandPresenceConfidence)&&void 0!==n?n:S),e.cannedGesturesClassifierOptions){const t=new p.GestureClassifierGraphOptions;t.setClassifierOptions((0,f.convertClassifierOptionsToProto)(e.cannedGesturesClassifierOptions,null===(i=this.handGestureRecognizerGraphOptions.getCannedGestureClassifierGraphOptions())||void 0===i?void 0:i.getClassifierOptions())),this.handGestureRecognizerGraphOptions.setCannedGestureClassifierGraphOptions(t)}else void 0===e.cannedGesturesClassifierOptions&&(null===(a=this.handGestureRecognizerGraphOptions.getCannedGestureClassifierGraphOptions())||void 0===a||a.clearClassifierOptions());if(e.customGesturesClassifierOptions){const t=new p.GestureClassifierGraphOptions;t.setClassifierOptions((0,f.convertClassifierOptionsToProto)(e.customGesturesClassifierOptions,null===(s=this.handGestureRecognizerGraphOptions.getCustomGestureClassifierGraphOptions())||void 0===s?void 0:s.getClassifierOptions())),this.handGestureRecognizerGraphOptions.setCustomGestureClassifierGraphOptions(t)}else void 0===e.customGesturesClassifierOptions&&(null===(c=this.handGestureRecognizerGraphOptions.getCustomGestureClassifierGraphOptions())||void 0===c||c.clearClassifierOptions());return this.applyOptions(e)}recognize(e,t){return this.resetResults(),this.processImageData(e,t),this.processResults()}recognizeForVideo(e,t,r){return this.resetResults(),this.processVideoData(e,r,t),this.processResults()}resetResults(){this.gestures=[],this.landmarks=[],this.worldLandmarks=[],this.handednesses=[]}processResults(){return 0===this.gestures.length?{gestures:[],landmarks:[],worldLandmarks:[],handednesses:[]}:{gestures:this.gestures,landmarks:this.landmarks,worldLandmarks:this.worldLandmarks,handednesses:this.handednesses}}toJsCategories(e,t=!0){var r,o,n;const a=[];for(const s of e){const e=i.ClassificationList.deserializeBinary(s),p=[];for(const i of e.getClassificationList()){const e=t&&i.hasIndex()?i.getIndex():-1;p.push({score:null!==(r=i.getScore())&&void 0!==r?r:0,index:e,categoryName:null!==(o=i.getLabel())&&void 0!==o?o:"",displayName:null!==(n=i.getDisplayName())&&void 0!==n?n:""})}a.push(p)}return a}addJsLandmarks(e){var t,r,o;for(const n of e){const e=a.NormalizedLandmarkList.deserializeBinary(n),i=[];for(const n of e.getLandmarkList())i.push({x:null!==(t=n.getX())&&void 0!==t?t:0,y:null!==(r=n.getY())&&void 0!==r?r:0,z:null!==(o=n.getZ())&&void 0!==o?o:0});this.landmarks.push(i)}}adddJsWorldLandmarks(e){var t,r,o;for(const n of e){const e=a.LandmarkList.deserializeBinary(n),i=[];for(const n of e.getLandmarkList())i.push({x:null!==(t=n.getX())&&void 0!==t?t:0,y:null!==(r=n.getY())&&void 0!==r?r:0,z:null!==(o=n.getZ())&&void 0!==o?o:0});this.worldLandmarks.push(i)}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(y),e.addInputStream(b),e.addOutputStream(v),e.addOutputStream(_),e.addOutputStream(O),e.addOutputStream(w);const t=new n.CalculatorOptions;t.setExtension(c.GestureRecognizerGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.gesture_recognizer.GestureRecognizerGraph"),r.addInputStream("IMAGE:"+y),r.addInputStream("NORM_RECT:"+b),r.addOutputStream("HAND_GESTURES:"+v),r.addOutputStream("LANDMARKS:"+_),r.addOutputStream("WORLD_LANDMARKS:"+O),r.addOutputStream("HANDEDNESS:"+w),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoVectorListener(_,(e,t)=>{this.addJsLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(_,e=>{this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(O,(e,t)=>{this.adddJsWorldLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(O,e=>{this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(v,(e,t)=>{this.gestures.push(...this.toJsCategories(e,!1)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(v,e=>{this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(w,(e,t)=>{this.handednesses.push(...this.toJsCategories(e)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(w,e=>{this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.GestureRecognizer=E,E.HAND_CONNECTIONS=h.HAND_CONNECTIONS}(gesture_recognizer);var hand_landmarker={},hand_landmarker_options={};Object.defineProperty(hand_landmarker_options,"__esModule",{value:!0});var hand_landmarker_result={};Object.defineProperty(hand_landmarker_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.HandLandmarker=void 0;const o=calculator_pb,n=calculator_options_pb,i=classification_pb,a=landmark_pb,s=base_options_pb,p=hand_detector_graph_options_pb,c=hand_landmarker_graph_options_pb,l=hand_landmarks_detector_graph_options_pb,d=landmark_result,u=vision_task_runner,g=hand_landmarks_connections;r(hand_landmarker_options,e),r(hand_landmarker_result,e);const f="image_in",m="norm_rect",h="hand_landmarks",y="world_hand_landmarks",b="handedness",v=.5;class _ extends u.VisionTaskRunner{static createFromOptions(e,t){return u.VisionTaskRunner.createVisionInstance(_,e,t)}static createFromModelBuffer(e,t){return u.VisionTaskRunner.createVisionInstance(_,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return u.VisionTaskRunner.createVisionInstance(_,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new u.VisionGraphRunner(e,t),f,m,!1),this.landmarks=[],this.worldLandmarks=[],this.handednesses=[],this.options=new c.HandLandmarkerGraphOptions,this.options.setBaseOptions(new s.BaseOptions),this.handLandmarksDetectorGraphOptions=new l.HandLandmarksDetectorGraphOptions,this.options.setHandLandmarksDetectorGraphOptions(this.handLandmarksDetectorGraphOptions),this.handDetectorGraphOptions=new p.HandDetectorGraphOptions,this.options.setHandDetectorGraphOptions(this.handDetectorGraphOptions),this.initDefaults()}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r,o,n;return"numHands"in e&&this.handDetectorGraphOptions.setNumHands(null!==(t=e.numHands)&&void 0!==t?t:1),"minHandDetectionConfidence"in e&&this.handDetectorGraphOptions.setMinDetectionConfidence(null!==(r=e.minHandDetectionConfidence)&&void 0!==r?r:v),"minTrackingConfidence"in e&&this.options.setMinTrackingConfidence(null!==(o=e.minTrackingConfidence)&&void 0!==o?o:v),"minHandPresenceConfidence"in e&&this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(null!==(n=e.minHandPresenceConfidence)&&void 0!==n?n:v),this.applyOptions(e)}detect(e,t){return this.resetResults(),this.processImageData(e,t),this.processResults()}detectForVideo(e,t,r){return this.resetResults(),this.processVideoData(e,r,t),this.processResults()}resetResults(){this.landmarks=[],this.worldLandmarks=[],this.handednesses=[]}processResults(){return{landmarks:this.landmarks,worldLandmarks:this.worldLandmarks,handednesses:this.handednesses}}initDefaults(){this.handDetectorGraphOptions.setNumHands(1),this.handDetectorGraphOptions.setMinDetectionConfidence(v),this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(v),this.options.setMinTrackingConfidence(v)}toJsCategories(e){var t,r,o,n;const a=[];for(const s of e){const e=i.ClassificationList.deserializeBinary(s),p=[];for(const i of e.getClassificationList())p.push({score:null!==(t=i.getScore())&&void 0!==t?t:0,index:null!==(r=i.getIndex())&&void 0!==r?r:-1,categoryName:null!==(o=i.getLabel())&&void 0!==o?o:"",displayName:null!==(n=i.getDisplayName())&&void 0!==n?n:""});a.push(p)}return a}addJsLandmarks(e){for(const t of e){const e=a.NormalizedLandmarkList.deserializeBinary(t);this.landmarks.push((0,d.convertToLandmarks)(e))}}adddJsWorldLandmarks(e){for(const t of e){const e=a.LandmarkList.deserializeBinary(t);this.worldLandmarks.push((0,d.convertToWorldLandmarks)(e))}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(f),e.addInputStream(m),e.addOutputStream(h),e.addOutputStream(y),e.addOutputStream(b);const t=new n.CalculatorOptions;t.setExtension(c.HandLandmarkerGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.hand_landmarker.HandLandmarkerGraph"),r.addInputStream("IMAGE:"+f),r.addInputStream("NORM_RECT:"+m),r.addOutputStream("LANDMARKS:"+h),r.addOutputStream("WORLD_LANDMARKS:"+y),r.addOutputStream("HANDEDNESS:"+b),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoVectorListener(h,(e,t)=>{this.addJsLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(h,e=>{this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(y,(e,t)=>{this.adddJsWorldLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(y,e=>{this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(b,(e,t)=>{this.handednesses.push(...this.toJsCategories(e)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(b,e=>{this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.HandLandmarker=_,_.HAND_CONNECTIONS=g.HAND_CONNECTIONS}(hand_landmarker);var image_classifier={},classifications_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=classification_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.ClassificationResult",null,o),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Classifications",null,o),proto.mediapipe.tasks.components.containers.proto.Classifications=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.components.containers.proto.Classifications,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.Classifications.displayName="proto.mediapipe.tasks.components.containers.proto.Classifications"),proto.mediapipe.tasks.components.containers.proto.ClassificationResult=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.components.containers.proto.ClassificationResult.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.components.containers.proto.ClassificationResult,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.ClassificationResult.displayName="proto.mediapipe.tasks.components.containers.proto.ClassificationResult"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.Classifications.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.Classifications.toObject=function(e,r){var o,i={classificationList:(o=r.getClassificationList())&&n.ClassificationList.toObject(e,o),headIndex:null==(o=t.Message.getField(r,2))?void 0:o,headName:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.Classifications;return proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 4:var r=new n.ClassificationList;t.readMessage(r,n.ClassificationList.deserializeBinaryFromReader),e.setClassificationList(r);break;case 2:r=t.readInt32(),e.setHeadIndex(r);break;case 3:r=t.readString(),e.setHeadName(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getClassificationList())&&r.writeMessage(4,o,n.ClassificationList.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeString(3,o)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getClassificationList=function(){return t.Message.getWrapperField(this,n.ClassificationList,4)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setClassificationList=function(e){return t.Message.setWrapperField(this,4,e)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearClassificationList=function(){return this.setClassificationList(void 0)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasClassificationList=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getHeadIndex=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setHeadIndex=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearHeadIndex=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasHeadIndex=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getHeadName=function(){return t.Message.getFieldWithDefault(this,3,"")},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setHeadName=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearHeadName=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasHeadName=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.toObject=function(e,r){var o,n={classificationsList:t.Message.toObjectList(r.getClassificationsList(),proto.mediapipe.tasks.components.containers.proto.Classifications.toObject,e),timestampMs:null==(o=t.Message.getField(r,2))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.ClassificationResult;return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.tasks.components.containers.proto.Classifications;t.readMessage(r,proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader),e.addClassifications(r);break;case 2:r=t.readInt64(),e.setTimestampMs(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.serializeBinaryToWriter=function(e,r){var o=void 0;(o=e.getClassificationsList()).length>0&&r.writeRepeatedMessage(1,o,proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeInt64(2,o)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.getClassificationsList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.tasks.components.containers.proto.Classifications,1)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.setClassificationsList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.addClassifications=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.tasks.components.containers.proto.Classifications,r)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.clearClassificationsList=function(){return this.setClassificationsList([])},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.getTimestampMs=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.setTimestampMs=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.clearTimestampMs=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.hasTimestampMs=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.components.containers.proto)}(classifications_pb);var image_classifier_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=classifier_options_pb;r.object.extend(proto,a);var s=base_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions",null,o),proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.displayName="proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&s.BaseOptions.toObject(e,r),classifierOptions:(r=t.getClassifierOptions())&&a.ClassifierOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions;return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new s.BaseOptions;t.readMessage(r,s.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new a.ClassifierOptions,t.readMessage(r,a.ClassifierOptions.deserializeBinaryFromReader),e.setClassifierOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,s.BaseOptions.serializeBinaryToWriter),null!=(r=e.getClassifierOptions())&&t.writeMessage(2,r,a.ClassifierOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext=new t.ExtensionFieldInfo(456383383,{ext:0},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[456383383]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[456383383]=proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,s.BaseOptions,1)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.getClassifierOptions=function(){return t.Message.getWrapperField(this,a.ClassifierOptions,2)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.setClassifierOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.clearClassifierOptions=function(){return this.setClassifierOptions(void 0)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.hasClassifierOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext=new t.ExtensionFieldInfo(456383383,{ext:0},proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[456383383]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[456383383]=proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.image_classifier.proto)}(image_classifier_graph_options_pb);var image_classifier_options={};Object.defineProperty(image_classifier_options,"__esModule",{value:!0});var image_classifier_result={};Object.defineProperty(image_classifier_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.ImageClassifier=void 0;const o=calculator_pb,n=calculator_options_pb,i=classifications_pb,a=base_options_pb,s=image_classifier_graph_options_pb,p=classifier_options,c=classifier_result,l=vision_task_runner,d="input_image",u="norm_rect",g="classifications";r(image_classifier_options,e),r(image_classifier_result,e);class f extends l.VisionTaskRunner{static createFromOptions(e,t){return l.VisionTaskRunner.createVisionInstance(f,e,t)}static createFromModelBuffer(e,t){return l.VisionTaskRunner.createVisionInstance(f,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return l.VisionTaskRunner.createVisionInstance(f,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new l.VisionGraphRunner(e,t),d,u,!0),this.classificationResult={classifications:[]},this.options=new s.ImageClassifierGraphOptions,this.options.setBaseOptions(new a.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){return this.options.setClassifierOptions((0,p.convertClassifierOptionsToProto)(e,this.options.getClassifierOptions())),this.applyOptions(e)}classify(e,t){return this.classificationResult={classifications:[]},this.processImageData(e,t),this.classificationResult}classifyForVideo(e,t,r){return this.classificationResult={classifications:[]},this.processVideoData(e,r,t),this.classificationResult}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(d),e.addInputStream(u),e.addOutputStream(g);const t=new n.CalculatorOptions;t.setExtension(s.ImageClassifierGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.image_classifier.ImageClassifierGraph"),r.addInputStream("IMAGE:"+d),r.addInputStream("NORM_RECT:"+u),r.addOutputStream("CLASSIFICATIONS:"+g),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoListener(g,(e,t)=>{this.classificationResult=(0,c.convertFromClassificationResultProto)(i.ClassificationResult.deserializeBinary(e)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(g,e=>{this.setLatestOutputTimestamp(e)});const a=e.serializeBinary();this.setGraph(new Uint8Array(a),!0)}}e.ImageClassifier=f}(image_classifier);var image_embedder={},embeddings_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Embedding",null,o),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Embedding.EmbeddingCase",null,o),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.EmbeddingResult",null,o),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.FloatEmbedding",null,o),r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding",null,o),proto.mediapipe.tasks.components.containers.proto.FloatEmbedding=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.components.containers.proto.FloatEmbedding,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.displayName="proto.mediapipe.tasks.components.containers.proto.FloatEmbedding"),proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.displayName="proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding"),proto.mediapipe.tasks.components.containers.proto.Embedding=function(e){t.Message.initialize(this,e,0,-1,null,proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_)},r.inherits(proto.mediapipe.tasks.components.containers.proto.Embedding,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.Embedding.displayName="proto.mediapipe.tasks.components.containers.proto.Embedding"),proto.mediapipe.tasks.components.containers.proto.EmbeddingResult=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.components.containers.proto.EmbeddingResult,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.displayName="proto.mediapipe.tasks.components.containers.proto.EmbeddingResult"),proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject=function(e,r){var o,n={valuesList:null==(o=t.Message.getRepeatedFloatingPointField(r,1))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.FloatEmbedding;return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber())for(var r=t.isDelimited()?t.readPackedFloat():[t.readFloat()],o=0;o<r.length;o++)e.addValues(r[o]);else t.skipField();return e},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter=function(e,t){var r;(r=e.getValuesList()).length>0&&t.writePackedFloat(1,r)},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.getValuesList=function(){return t.Message.getRepeatedFloatingPointField(this,1)},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.setValuesList=function(e){return t.Message.setField(this,1,e||[])},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.addValues=function(e,r){return t.Message.addToRepeatedField(this,1,e,r)},proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.clearValuesList=function(){return this.setValuesList([])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject=function(e,t){var r={values:t.getValues_asB64()};return e&&(r.$jspbMessageInstance=t),r}),proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding;return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setValues(r)}else t.skipField();return e},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter=function(e,r){var o;null!=(o=t.Message.getField(e,1))&&r.writeBytes(1,o)},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues_asB64=function(){return t.Message.bytesAsB64(this.getValues())},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues_asU8=function(){return t.Message.bytesAsU8(this.getValues())},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.setValues=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.clearValues=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.hasValues=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_=[[1,2]],proto.mediapipe.tasks.components.containers.proto.Embedding.EmbeddingCase={EMBEDDING_NOT_SET:0,FLOAT_EMBEDDING:1,QUANTIZED_EMBEDDING:2},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getEmbeddingCase=function(){return t.Message.computeOneofCase(this,proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.Embedding.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.Embedding.toObject=function(e,r){var o,n={floatEmbedding:(o=r.getFloatEmbedding())&&proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject(e,o),quantizedEmbedding:(o=r.getQuantizedEmbedding())&&proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject(e,o),headIndex:null==(o=t.Message.getField(r,3))?void 0:o,headName:null==(o=t.Message.getField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.Embedding;return proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.tasks.components.containers.proto.FloatEmbedding;t.readMessage(r,proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader),e.setFloatEmbedding(r);break;case 2:r=new proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding,t.readMessage(r,proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader),e.setQuantizedEmbedding(r);break;case 3:r=t.readInt32(),e.setHeadIndex(r);break;case 4:r=t.readString(),e.setHeadName(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getFloatEmbedding())&&r.writeMessage(1,o,proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter),null!=(o=e.getQuantizedEmbedding())&&r.writeMessage(2,o,proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o),null!=(o=t.Message.getField(e,4))&&r.writeString(4,o)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getFloatEmbedding=function(){return t.Message.getWrapperField(this,proto.mediapipe.tasks.components.containers.proto.FloatEmbedding,1)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setFloatEmbedding=function(e){return t.Message.setOneofWrapperField(this,1,proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0],e)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearFloatEmbedding=function(){return this.setFloatEmbedding(void 0)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasFloatEmbedding=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getQuantizedEmbedding=function(){return t.Message.getWrapperField(this,proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding,2)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setQuantizedEmbedding=function(e){return t.Message.setOneofWrapperField(this,2,proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0],e)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearQuantizedEmbedding=function(){return this.setQuantizedEmbedding(void 0)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasQuantizedEmbedding=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getHeadIndex=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setHeadIndex=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearHeadIndex=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasHeadIndex=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getHeadName=function(){return t.Message.getFieldWithDefault(this,4,"")},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setHeadName=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearHeadName=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasHeadName=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.toObject=function(e){return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.toObject(e,this)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.toObject=function(e,r){var o,n={embeddingsList:t.Message.toObjectList(r.getEmbeddingsList(),proto.mediapipe.tasks.components.containers.proto.Embedding.toObject,e),timestampMs:null==(o=t.Message.getField(r,2))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.containers.proto.EmbeddingResult;return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.tasks.components.containers.proto.Embedding;t.readMessage(r,proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader),e.addEmbeddings(r);break;case 2:r=t.readInt64(),e.setTimestampMs(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.serializeBinaryToWriter=function(e,r){var o=void 0;(o=e.getEmbeddingsList()).length>0&&r.writeRepeatedMessage(1,o,proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeInt64(2,o)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.getEmbeddingsList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.tasks.components.containers.proto.Embedding,1)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.setEmbeddingsList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.addEmbeddings=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.tasks.components.containers.proto.Embedding,r)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.clearEmbeddingsList=function(){return this.setEmbeddingsList([])},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.getTimestampMs=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.setTimestampMs=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.clearTimestampMs=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.hasTimestampMs=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.components.containers.proto)}(embeddings_pb);var image_embedder_graph_options_pb={},embedder_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.components.processors.proto.EmbedderOptions",null,o),proto.mediapipe.tasks.components.processors.proto.EmbedderOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.components.processors.proto.EmbedderOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.displayName="proto.mediapipe.tasks.components.processors.proto.EmbedderOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.toObject(e,this)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.toObject=function(e,r){var o,n={l2Normalize:null==(o=t.Message.getBooleanField(r,1))?void 0:o,quantize:null==(o=t.Message.getBooleanField(r,2))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.components.processors.proto.EmbedderOptions;return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBool();e.setL2Normalize(r);break;case 2:r=t.readBool(),e.setQuantize(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeBool(1,o),null!=(o=t.Message.getField(e,2))&&r.writeBool(2,o)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.getL2Normalize=function(){return t.Message.getBooleanFieldWithDefault(this,1,!1)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.setL2Normalize=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.clearL2Normalize=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.hasL2Normalize=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.getQuantize=function(){return t.Message.getBooleanFieldWithDefault(this,2,!1)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.setQuantize=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.clearQuantize=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.hasQuantize=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.components.processors.proto)}(embedder_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=embedder_options_pb;r.object.extend(proto,a);var s=base_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions",null,o),proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.displayName="proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject=function(e,t){var r,o={baseOptions:(r=t.getBaseOptions())&&s.BaseOptions.toObject(e,r),embedderOptions:(r=t.getEmbedderOptions())&&a.EmbedderOptions.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions;return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new s.BaseOptions;t.readMessage(r,s.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new a.EmbedderOptions,t.readMessage(r,a.EmbedderOptions.deserializeBinaryFromReader),e.setEmbedderOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBaseOptions())&&t.writeMessage(1,r,s.BaseOptions.serializeBinaryToWriter),null!=(r=e.getEmbedderOptions())&&t.writeMessage(2,r,a.EmbedderOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext=new t.ExtensionFieldInfo(476348187,{ext:0},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[476348187]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[476348187]=proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,s.BaseOptions,1)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.getEmbedderOptions=function(){return t.Message.getWrapperField(this,a.EmbedderOptions,2)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.setEmbedderOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.clearEmbedderOptions=function(){return this.setEmbedderOptions(void 0)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.hasEmbedderOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext=new t.ExtensionFieldInfo(476348187,{ext:0},proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[476348187]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[476348187]=proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.image_embedder.proto)}(image_embedder_graph_options_pb);var embedder_options={};Object.defineProperty(embedder_options,"__esModule",{value:!0}),embedder_options.convertEmbedderOptionsToProto=void 0;const embedder_options_pb_1=embedder_options_pb;function convertEmbedderOptionsToProto(e,t){const r=t?t.clone():new embedder_options_pb_1.EmbedderOptions;return void 0!==e.l2Normalize?r.setL2Normalize(e.l2Normalize):"l2Normalize"in e&&r.clearL2Normalize(),void 0!==e.quantize?r.setQuantize(e.quantize):"quantize"in e&&r.clearQuantize(),r}embedder_options.convertEmbedderOptionsToProto=convertEmbedderOptionsToProto;var embedder_result={};Object.defineProperty(embedder_result,"__esModule",{value:!0}),embedder_result.convertFromEmbeddingResultProto=void 0;const DEFAULT_INDEX=-1;function convertFromEmbeddingsProto(e){var t,r,o,n;const i={headIndex:null!==(t=e.getHeadIndex())&&void 0!==t?t:DEFAULT_INDEX,headName:null!==(r=e.getHeadName())&&void 0!==r?r:""};if(e.hasFloatEmbedding())i.floatEmbedding=e.getFloatEmbedding().getValuesList();else{const t=null!==(n=null===(o=e.getQuantizedEmbedding())||void 0===o?void 0:o.getValues())&&void 0!==n?n:"";i.quantizedEmbedding="string"==typeof t?Uint8Array.from(atob(t),e=>e.charCodeAt(0)):t}return i}function convertFromEmbeddingResultProto(e){return{embeddings:e.getEmbeddingsList().map(e=>convertFromEmbeddingsProto(e)),timestampMs:e.getTimestampMs()}}embedder_result.convertFromEmbeddingResultProto=convertFromEmbeddingResultProto;var cosine_similarity={};function computeCosineSimilarity(e,t){if(e.floatEmbedding&&t.floatEmbedding)return compute(e.floatEmbedding,t.floatEmbedding);if(e.quantizedEmbedding&&t.quantizedEmbedding)return compute(convertToBytes(e.quantizedEmbedding),convertToBytes(t.quantizedEmbedding));throw new Error("Cannot compute cosine similarity between quantized and float embeddings.")}function convertToBytes(e){return Array.from(e,e=>e>127?e-256:e)}function compute(e,t){if(e.length!==t.length)throw new Error(`Cannot compute cosine similarity between embeddings of different sizes (${e.length} vs. ${t.length}).`);let r=0,o=0,n=0;for(let i=0;i<e.length;i++)r+=e[i]*t[i],o+=e[i]*e[i],n+=t[i]*t[i];if(o<=0||n<=0)throw new Error("Cannot compute cosine similarity on embedding with 0 norm.");return r/Math.sqrt(o*n)}Object.defineProperty(cosine_similarity,"__esModule",{value:!0}),cosine_similarity.computeCosineSimilarity=void 0,cosine_similarity.computeCosineSimilarity=computeCosineSimilarity;var image_embedder_options={};Object.defineProperty(image_embedder_options,"__esModule",{value:!0});var image_embedder_result={};Object.defineProperty(image_embedder_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.ImageEmbedder=void 0;const o=calculator_pb,n=calculator_options_pb,i=embeddings_pb,a=base_options_pb,s=image_embedder_graph_options_pb,p=embedder_options,c=embedder_result,l=cosine_similarity,d=vision_task_runner,u="image_in",g="norm_rect",f="embeddings_out";r(image_embedder_options,e),r(image_embedder_result,e);class m extends d.VisionTaskRunner{static createFromOptions(e,t){return d.VisionTaskRunner.createVisionInstance(m,e,t)}static createFromModelBuffer(e,t){return d.VisionTaskRunner.createVisionInstance(m,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return d.VisionTaskRunner.createVisionInstance(m,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new d.VisionGraphRunner(e,t),u,g,!0),this.options=new s.ImageEmbedderGraphOptions,this.embeddings={embeddings:[]},this.options.setBaseOptions(new a.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){return this.options.setEmbedderOptions((0,p.convertEmbedderOptionsToProto)(e,this.options.getEmbedderOptions())),this.applyOptions(e)}embed(e,t){return this.processImageData(e,t),this.embeddings}embedForVideo(e,t,r){return this.processVideoData(e,r,t),this.embeddings}static cosineSimilarity(e,t){return(0,l.computeCosineSimilarity)(e,t)}addJsImageEmdedding(e){const t=i.EmbeddingResult.deserializeBinary(e);this.embeddings=(0,c.convertFromEmbeddingResultProto)(t)}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(u),e.addInputStream(g),e.addOutputStream(f);const t=new n.CalculatorOptions;t.setExtension(s.ImageEmbedderGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.image_embedder.ImageEmbedderGraph"),r.addInputStream("IMAGE:"+u),r.addInputStream("NORM_RECT:"+g),r.addOutputStream("EMBEDDINGS:"+f),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoListener(f,(e,t)=>{this.addJsImageEmdedding(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(f,e=>{this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.ImageEmbedder=m}(image_embedder);var image_segmenter={},tensors_to_segmentation_calculator_pb={},segmenter_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions",null,o),r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.Activation",null,o),r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.OutputType",null,o),proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.displayName="proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.toObject(e,this)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.toObject=function(e,r){var o,n={outputType:null==(o=t.Message.getField(r,1))?void 0:o,activation:t.Message.getFieldWithDefault(r,2,0)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions;return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readEnum();e.setOutputType(r);break;case 2:r=t.readEnum(),e.setActivation(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeEnum(1,o),null!=(o=t.Message.getField(e,2))&&r.writeEnum(2,o)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.OutputType={UNSPECIFIED:0,CATEGORY_MASK:1,CONFIDENCE_MASK:2},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.Activation={NONE:0,SIGMOID:1,SOFTMAX:2},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.getOutputType=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.setOutputType=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.clearOutputType=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.hasOutputType=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.getActivation=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.setActivation=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.clearActivation=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.hasActivation=function(){return null!=t.Message.getField(this,2)},r.object.extend(e,proto.mediapipe.tasks.vision.image_segmenter.proto)}(segmenter_options_pb);var label_map_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.LabelMapItem",null,o),proto.mediapipe.LabelMapItem=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.LabelMapItem.repeatedFields_,null)},r.inherits(proto.mediapipe.LabelMapItem,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.LabelMapItem.displayName="proto.mediapipe.LabelMapItem"),proto.mediapipe.LabelMapItem.repeatedFields_=[3],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.LabelMapItem.prototype.toObject=function(e){return proto.mediapipe.LabelMapItem.toObject(e,this)},proto.mediapipe.LabelMapItem.toObject=function(e,r){var o,n={name:null==(o=t.Message.getField(r,1))?void 0:o,displayName:null==(o=t.Message.getField(r,2))?void 0:o,childNameList:null==(o=t.Message.getRepeatedField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.LabelMapItem.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.LabelMapItem;return proto.mediapipe.LabelMapItem.deserializeBinaryFromReader(o,r)},proto.mediapipe.LabelMapItem.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setName(r);break;case 2:r=t.readString(),e.setDisplayName(r);break;case 3:r=t.readString(),e.addChildName(r);break;default:t.skipField()}return e},proto.mediapipe.LabelMapItem.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.LabelMapItem.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.LabelMapItem.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),(o=e.getChildNameList()).length>0&&r.writeRepeatedString(3,o)},proto.mediapipe.LabelMapItem.prototype.getName=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.LabelMapItem.prototype.setName=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.LabelMapItem.prototype.clearName=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.LabelMapItem.prototype.hasName=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.LabelMapItem.prototype.getDisplayName=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.LabelMapItem.prototype.setDisplayName=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.LabelMapItem.prototype.clearDisplayName=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.LabelMapItem.prototype.hasDisplayName=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.LabelMapItem.prototype.getChildNameList=function(){return t.Message.getRepeatedField(this,3)},proto.mediapipe.LabelMapItem.prototype.setChildNameList=function(e){return t.Message.setField(this,3,e||[])},proto.mediapipe.LabelMapItem.prototype.addChildName=function(e,r){return t.Message.addToRepeatedField(this,3,e,r)},proto.mediapipe.LabelMapItem.prototype.clearChildNameList=function(){return this.setChildNameList([])},r.object.extend(e,proto.mediapipe)}(label_map_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_options_pb;r.object.extend(proto,n);var i=segmenter_options_pb;r.object.extend(proto,i);var a=label_map_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions",null,o),proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.displayName="proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject(e,this)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject=function(e,t){var r,o={segmenterOptions:(r=t.getSegmenterOptions())&&i.SegmenterOptions.toObject(e,r),labelItemsMap:(r=t.getLabelItemsMap())?r.toObject(e,proto.mediapipe.LabelMapItem.toObject):[]};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions;return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)switch(r.getFieldNumber()){case 1:var o=new i.SegmenterOptions;r.readMessage(o,i.SegmenterOptions.deserializeBinaryFromReader),e.setSegmenterOptions(o);break;case 2:o=e.getLabelItemsMap(),r.readMessage(o,function(e,r){t.Map.deserializeBinary(e,r,t.BinaryReader.prototype.readInt64,t.BinaryReader.prototype.readMessage,proto.mediapipe.LabelMapItem.deserializeBinaryFromReader,0,new proto.mediapipe.LabelMapItem)});break;default:r.skipField()}return e},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getSegmenterOptions())&&r.writeMessage(1,o,i.SegmenterOptions.serializeBinaryToWriter),(o=e.getLabelItemsMap(!0))&&o.getLength()>0&&o.serializeBinary(2,r,t.BinaryWriter.prototype.writeInt64,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.LabelMapItem.serializeBinaryToWriter)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext=new t.ExtensionFieldInfo(458105876,{ext:0},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject,0),n.CalculatorOptions.extensionsBinary[458105876]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[458105876]=proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.getSegmenterOptions=function(){return t.Message.getWrapperField(this,i.SegmenterOptions,1)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.setSegmenterOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.clearSegmenterOptions=function(){return this.setSegmenterOptions(void 0)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.hasSegmenterOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.getLabelItemsMap=function(e){return t.Message.getMapField(this,2,e,proto.mediapipe.LabelMapItem)},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.clearLabelItemsMap=function(){return this.getLabelItemsMap().clear(),this},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext=new t.ExtensionFieldInfo(458105876,{ext:0},proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject,0),n.CalculatorOptions.extensionsBinary[458105876]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader,!1),n.CalculatorOptions.extensions[458105876]=proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext,r.object.extend(e,proto.mediapipe.tasks)}(tensors_to_segmentation_calculator_pb);var image_segmenter_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=segmenter_options_pb;r.object.extend(proto,s),r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions",null,o),proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.displayName="proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),displayNamesLocale:t.Message.getFieldWithDefault(r,2,"en"),segmenterOptions:(o=r.getSegmenterOptions())&&s.SegmenterOptions.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions;return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readString(),e.setDisplayNamesLocale(r);break;case 3:r=new s.SegmenterOptions,t.readMessage(r,s.SegmenterOptions.deserializeBinaryFromReader),e.setSegmenterOptions(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=e.getSegmenterOptions())&&r.writeMessage(3,o,s.SegmenterOptions.serializeBinaryToWriter)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext=new t.ExtensionFieldInfo(458105758,{ext:0},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[458105758]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[458105758]=proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getDisplayNamesLocale=function(){return t.Message.getFieldWithDefault(this,2,"en")},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setDisplayNamesLocale=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearDisplayNamesLocale=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasDisplayNamesLocale=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getSegmenterOptions=function(){return t.Message.getWrapperField(this,s.SegmenterOptions,3)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setSegmenterOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearSegmenterOptions=function(){return this.setSegmenterOptions(void 0)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasSegmenterOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext=new t.ExtensionFieldInfo(458105758,{ext:0},proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[458105758]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[458105758]=proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.image_segmenter.proto)}(image_segmenter_graph_options_pb);var image_segmenter_result={};Object.defineProperty(image_segmenter_result,"__esModule",{value:!0}),image_segmenter_result.ImageSegmenterResult=void 0;class ImageSegmenterResult{constructor(e,t,r){this.confidenceMasks=e,this.categoryMask=t,this.qualityScores=r}close(){var e,t;null===(e=this.confidenceMasks)||void 0===e||e.forEach(e=>{e.close()}),null===(t=this.categoryMask)||void 0===t||t.close()}}image_segmenter_result.ImageSegmenterResult=ImageSegmenterResult;var image_segmenter_options={};Object.defineProperty(image_segmenter_options,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.ImageSegmenter=void 0;const o=calculator_pb,n=calculator_options_pb,i=base_options_pb,a=tensors_to_segmentation_calculator_pb,s=image_segmenter_graph_options_pb,p=segmenter_options_pb,c=vision_task_runner,l=image_segmenter_result;r(image_segmenter_options,e),r(image_segmenter_result,e);const d="image_in",u="norm_rect",g="confidence_masks",f="category_mask",m="quality_scores",h="mediapipe.tasks.TensorsToSegmentationCalculator";class y extends c.VisionTaskRunner{static createFromOptions(e,t){return c.VisionTaskRunner.createVisionInstance(y,e,t)}static createFromModelBuffer(e,t){return c.VisionTaskRunner.createVisionInstance(y,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return c.VisionTaskRunner.createVisionInstance(y,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new c.VisionGraphRunner(e,t),d,u,!1),this.labels=[],this.outputCategoryMask=!1,this.outputConfidenceMasks=!0,this.options=new s.ImageSegmenterGraphOptions,this.segmenterOptions=new p.SegmenterOptions,this.options.setSegmenterOptions(this.segmenterOptions),this.options.setBaseOptions(new i.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r;return void 0!==e.displayNamesLocale?this.options.setDisplayNamesLocale(e.displayNamesLocale):"displayNamesLocale"in e&&this.options.clearDisplayNamesLocale(),"outputCategoryMask"in e&&(this.outputCategoryMask=null!==(t=e.outputCategoryMask)&&void 0!==t&&t),"outputConfidenceMasks"in e&&(this.outputConfidenceMasks=null===(r=e.outputConfidenceMasks)||void 0===r||r),super.applyOptions(e)}onGraphRefreshed(){this.populateLabels()}populateLabels(){var e,t,r;const o=this.getCalculatorGraphConfig().getNodeList().filter(e=>e.getName().includes(h));if(this.labels=[],o.length>1)throw new Error(`The graph has more than one ${h}.`);1===o.length&&(null!==(r=null===(t=null===(e=o[0].getOptions())||void 0===e?void 0:e.getExtension(a.TensorsToSegmentationCalculatorOptions.ext))||void 0===t?void 0:t.getLabelItemsMap())&&void 0!==r?r:new Map).forEach((e,t)=>{this.labels[Number(t)]=e.getName()})}segment(e,t,r){const o="function"!=typeof t?t:{};return this.userCallback="function"==typeof t?t:r,this.reset(),this.processImageData(e,o),this.processResults()}segmentForVideo(e,t,r,o){const n="function"!=typeof r?r:{};return this.userCallback="function"==typeof r?r:o,this.reset(),this.processVideoData(e,n,t),this.processResults()}getLabels(){return this.labels}reset(){this.categoryMask=void 0,this.confidenceMasks=void 0,this.qualityScores=void 0}processResults(){try{const e=new l.ImageSegmenterResult(this.confidenceMasks,this.categoryMask,this.qualityScores);if(!this.userCallback)return e;this.userCallback(e)}finally{this.freeKeepaliveStreams()}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(d),e.addInputStream(u);const t=new n.CalculatorOptions;t.setExtension(s.ImageSegmenterGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.image_segmenter.ImageSegmenterGraph"),r.addInputStream("IMAGE:"+d),r.addInputStream("NORM_RECT:"+u),r.setOptions(t),e.addNode(r),this.addKeepaliveNode(e),this.outputConfidenceMasks&&(e.addOutputStream(g),r.addOutputStream("CONFIDENCE_MASKS:"+g),this.keepStreamAlive(g),this.graphRunner.attachImageVectorListener(g,(e,t)=>{this.confidenceMasks=e.map(e=>this.convertToMPMask(e,!this.userCallback)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(g,e=>{this.confidenceMasks=[],this.setLatestOutputTimestamp(e)})),this.outputCategoryMask&&(e.addOutputStream(f),r.addOutputStream("CATEGORY_MASK:"+f),this.keepStreamAlive(f),this.graphRunner.attachImageListener(f,(e,t)=>{this.categoryMask=this.convertToMPMask(e,!this.userCallback),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(f,e=>{this.categoryMask=void 0,this.setLatestOutputTimestamp(e)})),e.addOutputStream(m),r.addOutputStream("QUALITY_SCORES:"+m),this.graphRunner.attachFloatVectorListener(m,(e,t)=>{this.qualityScores=e,this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(m,e=>{this.categoryMask=void 0,this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.ImageSegmenter=y}(image_segmenter);var interactive_segmenter={},color_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();r.exportSymbol("proto.mediapipe.Color",null,o),r.exportSymbol("proto.mediapipe.ColorMap",null,o),proto.mediapipe.Color=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.Color,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.Color.displayName="proto.mediapipe.Color"),proto.mediapipe.ColorMap=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.ColorMap,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.ColorMap.displayName="proto.mediapipe.ColorMap"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.Color.prototype.toObject=function(e){return proto.mediapipe.Color.toObject(e,this)},proto.mediapipe.Color.toObject=function(e,r){var o,n={r:null==(o=t.Message.getField(r,1))?void 0:o,g:null==(o=t.Message.getField(r,2))?void 0:o,b:null==(o=t.Message.getField(r,3))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.Color.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.Color;return proto.mediapipe.Color.deserializeBinaryFromReader(o,r)},proto.mediapipe.Color.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt32();e.setR(r);break;case 2:r=t.readInt32(),e.setG(r);break;case 3:r=t.readInt32(),e.setB(r);break;default:t.skipField()}return e},proto.mediapipe.Color.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.Color.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.Color.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeInt32(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o)},proto.mediapipe.Color.prototype.getR=function(){return t.Message.getFieldWithDefault(this,1,0)},proto.mediapipe.Color.prototype.setR=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.Color.prototype.clearR=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.Color.prototype.hasR=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.Color.prototype.getG=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.Color.prototype.setG=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.Color.prototype.clearG=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.Color.prototype.hasG=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.Color.prototype.getB=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.Color.prototype.setB=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.Color.prototype.clearB=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.Color.prototype.hasB=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.ColorMap.prototype.toObject=function(e){return proto.mediapipe.ColorMap.toObject(e,this)},proto.mediapipe.ColorMap.toObject=function(e,t){var r,o={labelToColorMap:(r=t.getLabelToColorMap())?r.toObject(e,proto.mediapipe.Color.toObject):[]};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.ColorMap.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.ColorMap;return proto.mediapipe.ColorMap.deserializeBinaryFromReader(o,r)},proto.mediapipe.ColorMap.deserializeBinaryFromReader=function(e,r){for(;r.nextField()&&!r.isEndGroup();)if(1===r.getFieldNumber()){var o=e.getLabelToColorMap();r.readMessage(o,function(e,r){t.Map.deserializeBinary(e,r,t.BinaryReader.prototype.readString,t.BinaryReader.prototype.readMessage,proto.mediapipe.Color.deserializeBinaryFromReader,"",new proto.mediapipe.Color)})}else r.skipField();return e},proto.mediapipe.ColorMap.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.ColorMap.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.ColorMap.serializeBinaryToWriter=function(e,r){var o=void 0;(o=e.getLabelToColorMap(!0))&&o.getLength()>0&&o.serializeBinary(1,r,t.BinaryWriter.prototype.writeString,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.Color.serializeBinaryToWriter)},proto.mediapipe.ColorMap.prototype.getLabelToColorMap=function(e){return t.Message.getMapField(this,1,e,proto.mediapipe.Color)},proto.mediapipe.ColorMap.prototype.clearLabelToColorMap=function(){return this.getLabelToColorMap().clear(),this},r.object.extend(e,proto.mediapipe)}(color_pb);var render_data_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=color_pb;r.object.extend(proto,n),r.exportSymbol("proto.mediapipe.RenderAnnotation",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Arrow",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.DataCase",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledOval",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledRectangle",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledRoundedRectangle",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.GradientLine",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Line",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Line.LineType",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Oval",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Point",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Rectangle",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.RoundedRectangle",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Scribble",null,o),r.exportSymbol("proto.mediapipe.RenderAnnotation.Text",null,o),r.exportSymbol("proto.mediapipe.RenderData",null,o),r.exportSymbol("proto.mediapipe.RenderViewport",null,o),proto.mediapipe.RenderData=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.RenderData.repeatedFields_,null)},r.inherits(proto.mediapipe.RenderData,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderData.displayName="proto.mediapipe.RenderData"),proto.mediapipe.RenderAnnotation=function(e){t.Message.initialize(this,e,0,-1,null,proto.mediapipe.RenderAnnotation.oneofGroups_)},r.inherits(proto.mediapipe.RenderAnnotation,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.displayName="proto.mediapipe.RenderAnnotation"),proto.mediapipe.RenderAnnotation.Rectangle=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Rectangle,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Rectangle.displayName="proto.mediapipe.RenderAnnotation.Rectangle"),proto.mediapipe.RenderAnnotation.FilledRectangle=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.FilledRectangle,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.FilledRectangle.displayName="proto.mediapipe.RenderAnnotation.FilledRectangle"),proto.mediapipe.RenderAnnotation.RoundedRectangle=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.RoundedRectangle,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.RoundedRectangle.displayName="proto.mediapipe.RenderAnnotation.RoundedRectangle"),proto.mediapipe.RenderAnnotation.FilledRoundedRectangle=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.FilledRoundedRectangle,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.displayName="proto.mediapipe.RenderAnnotation.FilledRoundedRectangle"),proto.mediapipe.RenderAnnotation.Oval=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Oval,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Oval.displayName="proto.mediapipe.RenderAnnotation.Oval"),proto.mediapipe.RenderAnnotation.FilledOval=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.FilledOval,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.FilledOval.displayName="proto.mediapipe.RenderAnnotation.FilledOval"),proto.mediapipe.RenderAnnotation.Point=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Point,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Point.displayName="proto.mediapipe.RenderAnnotation.Point"),proto.mediapipe.RenderAnnotation.Line=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Line,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Line.displayName="proto.mediapipe.RenderAnnotation.Line"),proto.mediapipe.RenderAnnotation.GradientLine=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.GradientLine,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.GradientLine.displayName="proto.mediapipe.RenderAnnotation.GradientLine"),proto.mediapipe.RenderAnnotation.Scribble=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.RenderAnnotation.Scribble.repeatedFields_,null)},r.inherits(proto.mediapipe.RenderAnnotation.Scribble,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Scribble.displayName="proto.mediapipe.RenderAnnotation.Scribble"),proto.mediapipe.RenderAnnotation.Arrow=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Arrow,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Arrow.displayName="proto.mediapipe.RenderAnnotation.Arrow"),proto.mediapipe.RenderAnnotation.Text=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderAnnotation.Text,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderAnnotation.Text.displayName="proto.mediapipe.RenderAnnotation.Text"),proto.mediapipe.RenderViewport=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.RenderViewport,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.RenderViewport.displayName="proto.mediapipe.RenderViewport"),proto.mediapipe.RenderData.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderData.prototype.toObject=function(e){return proto.mediapipe.RenderData.toObject(e,this)},proto.mediapipe.RenderData.toObject=function(e,r){var o,n={renderAnnotationsList:t.Message.toObjectList(r.getRenderAnnotationsList(),proto.mediapipe.RenderAnnotation.toObject,e),sceneClass:null==(o=t.Message.getField(r,2))?void 0:o,sceneViewport:(o=r.getSceneViewport())&&proto.mediapipe.RenderViewport.toObject(e,o)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderData.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderData;return proto.mediapipe.RenderData.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderData.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation;t.readMessage(r,proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader),e.addRenderAnnotations(r);break;case 2:r=t.readString(),e.setSceneClass(r);break;case 3:r=new proto.mediapipe.RenderViewport,t.readMessage(r,proto.mediapipe.RenderViewport.deserializeBinaryFromReader),e.setSceneViewport(r);break;default:t.skipField()}return e},proto.mediapipe.RenderData.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderData.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderData.serializeBinaryToWriter=function(e,r){var o=void 0;(o=e.getRenderAnnotationsList()).length>0&&r.writeRepeatedMessage(1,o,proto.mediapipe.RenderAnnotation.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=e.getSceneViewport())&&r.writeMessage(3,o,proto.mediapipe.RenderViewport.serializeBinaryToWriter)},proto.mediapipe.RenderData.prototype.getRenderAnnotationsList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.RenderAnnotation,1)},proto.mediapipe.RenderData.prototype.setRenderAnnotationsList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.RenderData.prototype.addRenderAnnotations=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.RenderAnnotation,r)},proto.mediapipe.RenderData.prototype.clearRenderAnnotationsList=function(){return this.setRenderAnnotationsList([])},proto.mediapipe.RenderData.prototype.getSceneClass=function(){return t.Message.getFieldWithDefault(this,2,"")},proto.mediapipe.RenderData.prototype.setSceneClass=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderData.prototype.clearSceneClass=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderData.prototype.hasSceneClass=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderData.prototype.getSceneViewport=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderViewport,3)},proto.mediapipe.RenderData.prototype.setSceneViewport=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.RenderData.prototype.clearSceneViewport=function(){return this.setSceneViewport(void 0)},proto.mediapipe.RenderData.prototype.hasSceneViewport=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.oneofGroups_=[[1,2,3,4,5,6,7,8,9,10,14,15]],proto.mediapipe.RenderAnnotation.DataCase={DATA_NOT_SET:0,RECTANGLE:1,FILLED_RECTANGLE:2,OVAL:3,FILLED_OVAL:4,POINT:5,LINE:6,ARROW:7,TEXT:8,ROUNDED_RECTANGLE:9,FILLED_ROUNDED_RECTANGLE:10,GRADIENT_LINE:14,SCRIBBLE:15},proto.mediapipe.RenderAnnotation.prototype.getDataCase=function(){return t.Message.computeOneofCase(this,proto.mediapipe.RenderAnnotation.oneofGroups_[0])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.toObject(e,this)},proto.mediapipe.RenderAnnotation.toObject=function(e,r){var o,i={rectangle:(o=r.getRectangle())&&proto.mediapipe.RenderAnnotation.Rectangle.toObject(e,o),filledRectangle:(o=r.getFilledRectangle())&&proto.mediapipe.RenderAnnotation.FilledRectangle.toObject(e,o),oval:(o=r.getOval())&&proto.mediapipe.RenderAnnotation.Oval.toObject(e,o),filledOval:(o=r.getFilledOval())&&proto.mediapipe.RenderAnnotation.FilledOval.toObject(e,o),point:(o=r.getPoint())&&proto.mediapipe.RenderAnnotation.Point.toObject(e,o),line:(o=r.getLine())&&proto.mediapipe.RenderAnnotation.Line.toObject(e,o),arrow:(o=r.getArrow())&&proto.mediapipe.RenderAnnotation.Arrow.toObject(e,o),text:(o=r.getText())&&proto.mediapipe.RenderAnnotation.Text.toObject(e,o),roundedRectangle:(o=r.getRoundedRectangle())&&proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e,o),filledRoundedRectangle:(o=r.getFilledRoundedRectangle())&&proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject(e,o),gradientLine:(o=r.getGradientLine())&&proto.mediapipe.RenderAnnotation.GradientLine.toObject(e,o),scribble:(o=r.getScribble())&&proto.mediapipe.RenderAnnotation.Scribble.toObject(e,o),thickness:t.Message.getFloatingPointFieldWithDefault(r,11,1),color:(o=r.getColor())&&n.Color.toObject(e,o),sceneTag:null==(o=t.Message.getField(r,13))?void 0:o};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.RenderAnnotation.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation;return proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation.Rectangle;t.readMessage(r,proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader),e.setRectangle(r);break;case 2:r=new proto.mediapipe.RenderAnnotation.FilledRectangle,t.readMessage(r,proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader),e.setFilledRectangle(r);break;case 3:r=new proto.mediapipe.RenderAnnotation.Oval,t.readMessage(r,proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader),e.setOval(r);break;case 4:r=new proto.mediapipe.RenderAnnotation.FilledOval,t.readMessage(r,proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader),e.setFilledOval(r);break;case 5:r=new proto.mediapipe.RenderAnnotation.Point,t.readMessage(r,proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader),e.setPoint(r);break;case 6:r=new proto.mediapipe.RenderAnnotation.Line,t.readMessage(r,proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader),e.setLine(r);break;case 7:r=new proto.mediapipe.RenderAnnotation.Arrow,t.readMessage(r,proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader),e.setArrow(r);break;case 8:r=new proto.mediapipe.RenderAnnotation.Text,t.readMessage(r,proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader),e.setText(r);break;case 9:r=new proto.mediapipe.RenderAnnotation.RoundedRectangle,t.readMessage(r,proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader),e.setRoundedRectangle(r);break;case 10:r=new proto.mediapipe.RenderAnnotation.FilledRoundedRectangle,t.readMessage(r,proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader),e.setFilledRoundedRectangle(r);break;case 14:r=new proto.mediapipe.RenderAnnotation.GradientLine,t.readMessage(r,proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader),e.setGradientLine(r);break;case 15:r=new proto.mediapipe.RenderAnnotation.Scribble,t.readMessage(r,proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader),e.setScribble(r);break;case 11:r=t.readDouble(),e.setThickness(r);break;case 12:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setColor(r);break;case 13:r=t.readString(),e.setSceneTag(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getRectangle())&&r.writeMessage(1,o,proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter),null!=(o=e.getFilledRectangle())&&r.writeMessage(2,o,proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter),null!=(o=e.getOval())&&r.writeMessage(3,o,proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter),null!=(o=e.getFilledOval())&&r.writeMessage(4,o,proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter),null!=(o=e.getPoint())&&r.writeMessage(5,o,proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter),null!=(o=e.getLine())&&r.writeMessage(6,o,proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter),null!=(o=e.getArrow())&&r.writeMessage(7,o,proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter),null!=(o=e.getText())&&r.writeMessage(8,o,proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter),null!=(o=e.getRoundedRectangle())&&r.writeMessage(9,o,proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter),null!=(o=e.getFilledRoundedRectangle())&&r.writeMessage(10,o,proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter),null!=(o=e.getGradientLine())&&r.writeMessage(14,o,proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter),null!=(o=e.getScribble())&&r.writeMessage(15,o,proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter),null!=(o=t.Message.getField(e,11))&&r.writeDouble(11,o),null!=(o=e.getColor())&&r.writeMessage(12,o,n.Color.serializeBinaryToWriter),null!=(o=t.Message.getField(e,13))&&r.writeString(13,o)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Rectangle.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Rectangle.toObject(e,this)},proto.mediapipe.RenderAnnotation.Rectangle.toObject=function(e,r){var o,n={left:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,top:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,right:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,bottom:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,normalized:t.Message.getBooleanFieldWithDefault(r,5,!1),rotation:null==(o=t.Message.getOptionalFloatingPointField(r,6))?void 0:o,topLeftThickness:null==(o=t.Message.getOptionalFloatingPointField(r,7))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Rectangle;return proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readDouble();e.setLeft(r);break;case 2:r=t.readDouble(),e.setTop(r);break;case 3:r=t.readDouble(),e.setRight(r);break;case 4:r=t.readDouble(),e.setBottom(r);break;case 5:r=t.readBool(),e.setNormalized(r);break;case 6:r=t.readDouble(),e.setRotation(r);break;case 7:r=t.readDouble(),e.setTopLeftThickness(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.Rectangle.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeDouble(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeDouble(3,o),null!=(o=t.Message.getField(e,4))&&r.writeDouble(4,o),null!=(o=t.Message.getField(e,5))&&r.writeBool(5,o),null!=(o=t.Message.getField(e,6))&&r.writeDouble(6,o),null!=(o=t.Message.getField(e,7))&&r.writeDouble(7,o)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getLeft=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setLeft=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearLeft=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasLeft=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getTop=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setTop=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearTop=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasTop=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getRight=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setRight=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearRight=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasRight=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getBottom=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setBottom=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearBottom=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasBottom=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setNormalized=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearNormalized=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasNormalized=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getRotation=function(){return t.Message.getFloatingPointFieldWithDefault(this,6,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setRotation=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearRotation=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasRotation=function(){return null!=t.Message.getField(this,6)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.getTopLeftThickness=function(){return t.Message.getFloatingPointFieldWithDefault(this,7,0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.setTopLeftThickness=function(e){return t.Message.setField(this,7,e)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearTopLeftThickness=function(){return t.Message.setField(this,7,void 0)},proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasTopLeftThickness=function(){return null!=t.Message.getField(this,7)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.FilledRectangle.toObject(e,this)},proto.mediapipe.RenderAnnotation.FilledRectangle.toObject=function(e,t){var r,o={rectangle:(r=t.getRectangle())&&proto.mediapipe.RenderAnnotation.Rectangle.toObject(e,r),fillColor:(r=t.getFillColor())&&n.Color.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.FilledRectangle;return proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation.Rectangle;t.readMessage(r,proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader),e.setRectangle(r);break;case 2:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setFillColor(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getRectangle())&&t.writeMessage(1,r,proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter),null!=(r=e.getFillColor())&&t.writeMessage(2,r,n.Color.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.getRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Rectangle,1)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.setRectangle=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.clearRectangle=function(){return this.setRectangle(void 0)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.hasRectangle=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.getFillColor=function(){return t.Message.getWrapperField(this,n.Color,2)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.setFillColor=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.clearFillColor=function(){return this.setFillColor(void 0)},proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.hasFillColor=function(){return null!=t.Message.getField(this,2)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e,this)},proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject=function(e,r){var o,n={rectangle:(o=r.getRectangle())&&proto.mediapipe.RenderAnnotation.Rectangle.toObject(e,o),cornerRadius:t.Message.getFieldWithDefault(r,2,0),lineType:t.Message.getFieldWithDefault(r,3,4)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.RoundedRectangle;return proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation.Rectangle;t.readMessage(r,proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader),e.setRectangle(r);break;case 2:r=t.readInt32(),e.setCornerRadius(r);break;case 3:r=t.readInt32(),e.setLineType(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getRectangle())&&r.writeMessage(1,o,proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Rectangle,1)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setRectangle=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearRectangle=function(){return this.setRectangle(void 0)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasRectangle=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getCornerRadius=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setCornerRadius=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearCornerRadius=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasCornerRadius=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getLineType=function(){return t.Message.getFieldWithDefault(this,3,4)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setLineType=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearLineType=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasLineType=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject(e,this)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject=function(e,t){var r,o={roundedRectangle:(r=t.getRoundedRectangle())&&proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e,r),fillColor:(r=t.getFillColor())&&n.Color.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.FilledRoundedRectangle;return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation.RoundedRectangle;t.readMessage(r,proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader),e.setRoundedRectangle(r);break;case 2:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setFillColor(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getRoundedRectangle())&&t.writeMessage(1,r,proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter),null!=(r=e.getFillColor())&&t.writeMessage(2,r,n.Color.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.getRoundedRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.RoundedRectangle,1)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.setRoundedRectangle=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.clearRoundedRectangle=function(){return this.setRoundedRectangle(void 0)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.hasRoundedRectangle=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.getFillColor=function(){return t.Message.getWrapperField(this,n.Color,2)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.setFillColor=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.clearFillColor=function(){return this.setFillColor(void 0)},proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.hasFillColor=function(){return null!=t.Message.getField(this,2)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Oval.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Oval.toObject(e,this)},proto.mediapipe.RenderAnnotation.Oval.toObject=function(e,t){var r,o={rectangle:(r=t.getRectangle())&&proto.mediapipe.RenderAnnotation.Rectangle.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.RenderAnnotation.Oval.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Oval;return proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.RenderAnnotation.Rectangle;t.readMessage(r,proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader),e.setRectangle(r)}else t.skipField();return e},proto.mediapipe.RenderAnnotation.Oval.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter=function(e,t){var r;null!=(r=e.getRectangle())&&t.writeMessage(1,r,proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.Oval.prototype.getRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Rectangle,1)},proto.mediapipe.RenderAnnotation.Oval.prototype.setRectangle=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.Oval.prototype.clearRectangle=function(){return this.setRectangle(void 0)},proto.mediapipe.RenderAnnotation.Oval.prototype.hasRectangle=function(){return null!=t.Message.getField(this,1)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.FilledOval.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.FilledOval.toObject(e,this)},proto.mediapipe.RenderAnnotation.FilledOval.toObject=function(e,t){var r,o={oval:(r=t.getOval())&&proto.mediapipe.RenderAnnotation.Oval.toObject(e,r),fillColor:(r=t.getFillColor())&&n.Color.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.FilledOval;return proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new proto.mediapipe.RenderAnnotation.Oval;t.readMessage(r,proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader),e.setOval(r);break;case 2:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setFillColor(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.FilledOval.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getOval())&&t.writeMessage(1,r,proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter),null!=(r=e.getFillColor())&&t.writeMessage(2,r,n.Color.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.getOval=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Oval,1)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.setOval=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.clearOval=function(){return this.setOval(void 0)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.hasOval=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.getFillColor=function(){return t.Message.getWrapperField(this,n.Color,2)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.setFillColor=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.clearFillColor=function(){return this.setFillColor(void 0)},proto.mediapipe.RenderAnnotation.FilledOval.prototype.hasFillColor=function(){return null!=t.Message.getField(this,2)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Point.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Point.toObject(e,this)},proto.mediapipe.RenderAnnotation.Point.toObject=function(e,r){var o,n={x:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,y:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,normalized:t.Message.getBooleanFieldWithDefault(r,3,!1)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderAnnotation.Point.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Point;return proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readDouble();e.setX(r);break;case 2:r=t.readDouble(),e.setY(r);break;case 3:r=t.readBool(),e.setNormalized(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.Point.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeDouble(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeBool(3,o)},proto.mediapipe.RenderAnnotation.Point.prototype.getX=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.RenderAnnotation.Point.prototype.setX=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.Point.prototype.clearX=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.Point.prototype.hasX=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.Point.prototype.getY=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.Point.prototype.setY=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.Point.prototype.clearY=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.Point.prototype.hasY=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.Point.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,3,!1)},proto.mediapipe.RenderAnnotation.Point.prototype.setNormalized=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.Point.prototype.clearNormalized=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.Point.prototype.hasNormalized=function(){return null!=t.Message.getField(this,3)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Line.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Line.toObject(e,this)},proto.mediapipe.RenderAnnotation.Line.toObject=function(e,r){var o,n={xStart:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,yStart:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,xEnd:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,yEnd:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,normalized:t.Message.getBooleanFieldWithDefault(r,5,!1),lineType:t.Message.getFieldWithDefault(r,6,1)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderAnnotation.Line.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Line;return proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readDouble();e.setXStart(r);break;case 2:r=t.readDouble(),e.setYStart(r);break;case 3:r=t.readDouble(),e.setXEnd(r);break;case 4:r=t.readDouble(),e.setYEnd(r);break;case 5:r=t.readBool(),e.setNormalized(r);break;case 6:r=t.readEnum(),e.setLineType(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.Line.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeDouble(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeDouble(3,o),null!=(o=t.Message.getField(e,4))&&r.writeDouble(4,o),null!=(o=t.Message.getField(e,5))&&r.writeBool(5,o),null!=(o=t.Message.getField(e,6))&&r.writeEnum(6,o)},proto.mediapipe.RenderAnnotation.Line.LineType={UNKNOWN:0,SOLID:1,DASHED:2},proto.mediapipe.RenderAnnotation.Line.prototype.getXStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.RenderAnnotation.Line.prototype.setXStart=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearXStart=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasXStart=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.Line.prototype.getYStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.Line.prototype.setYStart=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearYStart=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasYStart=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.Line.prototype.getXEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.RenderAnnotation.Line.prototype.setXEnd=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearXEnd=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasXEnd=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.Line.prototype.getYEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.RenderAnnotation.Line.prototype.setYEnd=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearYEnd=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasYEnd=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.Line.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.RenderAnnotation.Line.prototype.setNormalized=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearNormalized=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasNormalized=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.RenderAnnotation.Line.prototype.getLineType=function(){return t.Message.getFieldWithDefault(this,6,1)},proto.mediapipe.RenderAnnotation.Line.prototype.setLineType=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.RenderAnnotation.Line.prototype.clearLineType=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.RenderAnnotation.Line.prototype.hasLineType=function(){return null!=t.Message.getField(this,6)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.GradientLine.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.GradientLine.toObject(e,this)},proto.mediapipe.RenderAnnotation.GradientLine.toObject=function(e,r){var o,i={xStart:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,yStart:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,xEnd:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,yEnd:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,normalized:t.Message.getBooleanFieldWithDefault(r,5,!1),color1:(o=r.getColor1())&&n.Color.toObject(e,o),color2:(o=r.getColor2())&&n.Color.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.GradientLine;return proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readDouble();e.setXStart(r);break;case 2:r=t.readDouble(),e.setYStart(r);break;case 3:r=t.readDouble(),e.setXEnd(r);break;case 4:r=t.readDouble(),e.setYEnd(r);break;case 5:r=t.readBool(),e.setNormalized(r);break;case 6:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setColor1(r);break;case 7:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setColor2(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.GradientLine.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeDouble(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeDouble(3,o),null!=(o=t.Message.getField(e,4))&&r.writeDouble(4,o),null!=(o=t.Message.getField(e,5))&&r.writeBool(5,o),null!=(o=e.getColor1())&&r.writeMessage(6,o,n.Color.serializeBinaryToWriter),null!=(o=e.getColor2())&&r.writeMessage(7,o,n.Color.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getXStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setXStart=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearXStart=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasXStart=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getYStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setYStart=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearYStart=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasYStart=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getXEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setXEnd=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearXEnd=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasXEnd=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getYEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setYEnd=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearYEnd=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasYEnd=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setNormalized=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearNormalized=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasNormalized=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getColor1=function(){return t.Message.getWrapperField(this,n.Color,6)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setColor1=function(e){return t.Message.setWrapperField(this,6,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearColor1=function(){return this.setColor1(void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasColor1=function(){return null!=t.Message.getField(this,6)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.getColor2=function(){return t.Message.getWrapperField(this,n.Color,7)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.setColor2=function(e){return t.Message.setWrapperField(this,7,e)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearColor2=function(){return this.setColor2(void 0)},proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasColor2=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.RenderAnnotation.Scribble.repeatedFields_=[1],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Scribble.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Scribble.toObject(e,this)},proto.mediapipe.RenderAnnotation.Scribble.toObject=function(e,r){var o={pointList:t.Message.toObjectList(r.getPointList(),proto.mediapipe.RenderAnnotation.Point.toObject,e)};return e&&(o.$jspbMessageInstance=r),o}),proto.mediapipe.RenderAnnotation.Scribble.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Scribble;return proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new proto.mediapipe.RenderAnnotation.Point;t.readMessage(r,proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader),e.addPoint(r)}else t.skipField();return e},proto.mediapipe.RenderAnnotation.Scribble.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter=function(e,t){var r;(r=e.getPointList()).length>0&&t.writeRepeatedMessage(1,r,proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.Scribble.prototype.getPointList=function(){return t.Message.getRepeatedWrapperField(this,proto.mediapipe.RenderAnnotation.Point,1)},proto.mediapipe.RenderAnnotation.Scribble.prototype.setPointList=function(e){return t.Message.setRepeatedWrapperField(this,1,e)},proto.mediapipe.RenderAnnotation.Scribble.prototype.addPoint=function(e,r){return t.Message.addToRepeatedWrapperField(this,1,e,proto.mediapipe.RenderAnnotation.Point,r)},proto.mediapipe.RenderAnnotation.Scribble.prototype.clearPointList=function(){return this.setPointList([])},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Arrow.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Arrow.toObject(e,this)},proto.mediapipe.RenderAnnotation.Arrow.toObject=function(e,r){var o,n={xStart:null==(o=t.Message.getOptionalFloatingPointField(r,1))?void 0:o,yStart:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,xEnd:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,yEnd:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,normalized:t.Message.getBooleanFieldWithDefault(r,5,!1)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderAnnotation.Arrow.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Arrow;return proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readDouble();e.setXStart(r);break;case 2:r=t.readDouble(),e.setYStart(r);break;case 3:r=t.readDouble(),e.setXEnd(r);break;case 4:r=t.readDouble(),e.setYEnd(r);break;case 5:r=t.readBool(),e.setNormalized(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.Arrow.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeDouble(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeDouble(3,o),null!=(o=t.Message.getField(e,4))&&r.writeDouble(4,o),null!=(o=t.Message.getField(e,5))&&r.writeBool(5,o)},proto.mediapipe.RenderAnnotation.Arrow.prototype.getXStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,1,0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.setXStart=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.Arrow.prototype.clearXStart=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.hasXStart=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.Arrow.prototype.getYStart=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.setYStart=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.Arrow.prototype.clearYStart=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.hasYStart=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.Arrow.prototype.getXEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.setXEnd=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.Arrow.prototype.clearXEnd=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.hasXEnd=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.Arrow.prototype.getYEnd=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.setYEnd=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderAnnotation.Arrow.prototype.clearYEnd=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.hasYEnd=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.Arrow.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.RenderAnnotation.Arrow.prototype.setNormalized=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.RenderAnnotation.Arrow.prototype.clearNormalized=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.RenderAnnotation.Arrow.prototype.hasNormalized=function(){return null!=t.Message.getField(this,5)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderAnnotation.Text.prototype.toObject=function(e){return proto.mediapipe.RenderAnnotation.Text.toObject(e,this)},proto.mediapipe.RenderAnnotation.Text.toObject=function(e,r){var o,i={displayText:null==(o=t.Message.getField(r,1))?void 0:o,left:null==(o=t.Message.getOptionalFloatingPointField(r,2))?void 0:o,baseline:null==(o=t.Message.getOptionalFloatingPointField(r,3))?void 0:o,fontHeight:t.Message.getFloatingPointFieldWithDefault(r,4,8),normalized:t.Message.getBooleanFieldWithDefault(r,5,!1),fontFace:t.Message.getFieldWithDefault(r,6,0),centerHorizontally:t.Message.getBooleanFieldWithDefault(r,7,!1),centerVertically:t.Message.getBooleanFieldWithDefault(r,8,!1),outlineThickness:t.Message.getFloatingPointFieldWithDefault(r,11,0),outlineColor:(o=r.getOutlineColor())&&n.Color.toObject(e,o)};return e&&(i.$jspbMessageInstance=r),i}),proto.mediapipe.RenderAnnotation.Text.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderAnnotation.Text;return proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setDisplayText(r);break;case 2:r=t.readDouble(),e.setLeft(r);break;case 3:r=t.readDouble(),e.setBaseline(r);break;case 4:r=t.readDouble(),e.setFontHeight(r);break;case 5:r=t.readBool(),e.setNormalized(r);break;case 6:r=t.readInt32(),e.setFontFace(r);break;case 7:r=t.readBool(),e.setCenterHorizontally(r);break;case 8:r=t.readBool(),e.setCenterVertically(r);break;case 11:r=t.readDouble(),e.setOutlineThickness(r);break;case 12:r=new n.Color,t.readMessage(r,n.Color.deserializeBinaryFromReader),e.setOutlineColor(r);break;default:t.skipField()}return e},proto.mediapipe.RenderAnnotation.Text.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeDouble(2,o),null!=(o=t.Message.getField(e,3))&&r.writeDouble(3,o),null!=(o=t.Message.getField(e,4))&&r.writeDouble(4,o),null!=(o=t.Message.getField(e,5))&&r.writeBool(5,o),null!=(o=t.Message.getField(e,6))&&r.writeInt32(6,o),null!=(o=t.Message.getField(e,7))&&r.writeBool(7,o),null!=(o=t.Message.getField(e,8))&&r.writeBool(8,o),null!=(o=t.Message.getField(e,11))&&r.writeDouble(11,o),null!=(o=e.getOutlineColor())&&r.writeMessage(12,o,n.Color.serializeBinaryToWriter)},proto.mediapipe.RenderAnnotation.Text.prototype.getDisplayText=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.RenderAnnotation.Text.prototype.setDisplayText=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearDisplayText=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasDisplayText=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.Text.prototype.getLeft=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,0)},proto.mediapipe.RenderAnnotation.Text.prototype.setLeft=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearLeft=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasLeft=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.Text.prototype.getBaseline=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,0)},proto.mediapipe.RenderAnnotation.Text.prototype.setBaseline=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearBaseline=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasBaseline=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.Text.prototype.getFontHeight=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,8)},proto.mediapipe.RenderAnnotation.Text.prototype.setFontHeight=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearFontHeight=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasFontHeight=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.Text.prototype.getNormalized=function(){return t.Message.getBooleanFieldWithDefault(this,5,!1)},proto.mediapipe.RenderAnnotation.Text.prototype.setNormalized=function(e){return t.Message.setField(this,5,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearNormalized=function(){return t.Message.setField(this,5,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasNormalized=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.RenderAnnotation.Text.prototype.getFontFace=function(){return t.Message.getFieldWithDefault(this,6,0)},proto.mediapipe.RenderAnnotation.Text.prototype.setFontFace=function(e){return t.Message.setField(this,6,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearFontFace=function(){return t.Message.setField(this,6,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasFontFace=function(){return null!=t.Message.getField(this,6)},proto.mediapipe.RenderAnnotation.Text.prototype.getCenterHorizontally=function(){return t.Message.getBooleanFieldWithDefault(this,7,!1)},proto.mediapipe.RenderAnnotation.Text.prototype.setCenterHorizontally=function(e){return t.Message.setField(this,7,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearCenterHorizontally=function(){return t.Message.setField(this,7,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasCenterHorizontally=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.RenderAnnotation.Text.prototype.getCenterVertically=function(){return t.Message.getBooleanFieldWithDefault(this,8,!1)},proto.mediapipe.RenderAnnotation.Text.prototype.setCenterVertically=function(e){return t.Message.setField(this,8,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearCenterVertically=function(){return t.Message.setField(this,8,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasCenterVertically=function(){return null!=t.Message.getField(this,8)},proto.mediapipe.RenderAnnotation.Text.prototype.getOutlineThickness=function(){return t.Message.getFloatingPointFieldWithDefault(this,11,0)},proto.mediapipe.RenderAnnotation.Text.prototype.setOutlineThickness=function(e){return t.Message.setField(this,11,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearOutlineThickness=function(){return t.Message.setField(this,11,void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasOutlineThickness=function(){return null!=t.Message.getField(this,11)},proto.mediapipe.RenderAnnotation.Text.prototype.getOutlineColor=function(){return t.Message.getWrapperField(this,n.Color,12)},proto.mediapipe.RenderAnnotation.Text.prototype.setOutlineColor=function(e){return t.Message.setWrapperField(this,12,e)},proto.mediapipe.RenderAnnotation.Text.prototype.clearOutlineColor=function(){return this.setOutlineColor(void 0)},proto.mediapipe.RenderAnnotation.Text.prototype.hasOutlineColor=function(){return null!=t.Message.getField(this,12)},proto.mediapipe.RenderAnnotation.prototype.getRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Rectangle,1)},proto.mediapipe.RenderAnnotation.prototype.setRectangle=function(e){return t.Message.setOneofWrapperField(this,1,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearRectangle=function(){return this.setRectangle(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasRectangle=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderAnnotation.prototype.getFilledRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.FilledRectangle,2)},proto.mediapipe.RenderAnnotation.prototype.setFilledRectangle=function(e){return t.Message.setOneofWrapperField(this,2,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearFilledRectangle=function(){return this.setFilledRectangle(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasFilledRectangle=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderAnnotation.prototype.getOval=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Oval,3)},proto.mediapipe.RenderAnnotation.prototype.setOval=function(e){return t.Message.setOneofWrapperField(this,3,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearOval=function(){return this.setOval(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasOval=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderAnnotation.prototype.getFilledOval=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.FilledOval,4)},proto.mediapipe.RenderAnnotation.prototype.setFilledOval=function(e){return t.Message.setOneofWrapperField(this,4,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearFilledOval=function(){return this.setFilledOval(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasFilledOval=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.RenderAnnotation.prototype.getPoint=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Point,5)},proto.mediapipe.RenderAnnotation.prototype.setPoint=function(e){return t.Message.setOneofWrapperField(this,5,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearPoint=function(){return this.setPoint(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasPoint=function(){return null!=t.Message.getField(this,5)},proto.mediapipe.RenderAnnotation.prototype.getLine=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Line,6)},proto.mediapipe.RenderAnnotation.prototype.setLine=function(e){return t.Message.setOneofWrapperField(this,6,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearLine=function(){return this.setLine(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasLine=function(){return null!=t.Message.getField(this,6)},proto.mediapipe.RenderAnnotation.prototype.getArrow=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Arrow,7)},proto.mediapipe.RenderAnnotation.prototype.setArrow=function(e){return t.Message.setOneofWrapperField(this,7,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearArrow=function(){return this.setArrow(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasArrow=function(){return null!=t.Message.getField(this,7)},proto.mediapipe.RenderAnnotation.prototype.getText=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Text,8)},proto.mediapipe.RenderAnnotation.prototype.setText=function(e){return t.Message.setOneofWrapperField(this,8,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearText=function(){return this.setText(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasText=function(){return null!=t.Message.getField(this,8)},proto.mediapipe.RenderAnnotation.prototype.getRoundedRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.RoundedRectangle,9)},proto.mediapipe.RenderAnnotation.prototype.setRoundedRectangle=function(e){return t.Message.setOneofWrapperField(this,9,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearRoundedRectangle=function(){return this.setRoundedRectangle(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasRoundedRectangle=function(){return null!=t.Message.getField(this,9)},proto.mediapipe.RenderAnnotation.prototype.getFilledRoundedRectangle=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.FilledRoundedRectangle,10)},proto.mediapipe.RenderAnnotation.prototype.setFilledRoundedRectangle=function(e){return t.Message.setOneofWrapperField(this,10,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearFilledRoundedRectangle=function(){return this.setFilledRoundedRectangle(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasFilledRoundedRectangle=function(){return null!=t.Message.getField(this,10)},proto.mediapipe.RenderAnnotation.prototype.getGradientLine=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.GradientLine,14)},proto.mediapipe.RenderAnnotation.prototype.setGradientLine=function(e){return t.Message.setOneofWrapperField(this,14,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearGradientLine=function(){return this.setGradientLine(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasGradientLine=function(){return null!=t.Message.getField(this,14)},proto.mediapipe.RenderAnnotation.prototype.getScribble=function(){return t.Message.getWrapperField(this,proto.mediapipe.RenderAnnotation.Scribble,15)},proto.mediapipe.RenderAnnotation.prototype.setScribble=function(e){return t.Message.setOneofWrapperField(this,15,proto.mediapipe.RenderAnnotation.oneofGroups_[0],e)},proto.mediapipe.RenderAnnotation.prototype.clearScribble=function(){return this.setScribble(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasScribble=function(){return null!=t.Message.getField(this,15)},proto.mediapipe.RenderAnnotation.prototype.getThickness=function(){return t.Message.getFloatingPointFieldWithDefault(this,11,1)},proto.mediapipe.RenderAnnotation.prototype.setThickness=function(e){return t.Message.setField(this,11,e)},proto.mediapipe.RenderAnnotation.prototype.clearThickness=function(){return t.Message.setField(this,11,void 0)},proto.mediapipe.RenderAnnotation.prototype.hasThickness=function(){return null!=t.Message.getField(this,11)},proto.mediapipe.RenderAnnotation.prototype.getColor=function(){return t.Message.getWrapperField(this,n.Color,12)},proto.mediapipe.RenderAnnotation.prototype.setColor=function(e){return t.Message.setWrapperField(this,12,e)},proto.mediapipe.RenderAnnotation.prototype.clearColor=function(){return this.setColor(void 0)},proto.mediapipe.RenderAnnotation.prototype.hasColor=function(){return null!=t.Message.getField(this,12)},proto.mediapipe.RenderAnnotation.prototype.getSceneTag=function(){return t.Message.getFieldWithDefault(this,13,"")},proto.mediapipe.RenderAnnotation.prototype.setSceneTag=function(e){return t.Message.setField(this,13,e)},proto.mediapipe.RenderAnnotation.prototype.clearSceneTag=function(){return t.Message.setField(this,13,void 0)},proto.mediapipe.RenderAnnotation.prototype.hasSceneTag=function(){return null!=t.Message.getField(this,13)},t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.RenderViewport.prototype.toObject=function(e){return proto.mediapipe.RenderViewport.toObject(e,this)},proto.mediapipe.RenderViewport.toObject=function(e,r){var o,n={id:null==(o=t.Message.getField(r,1))?void 0:o,widthPx:null==(o=t.Message.getField(r,2))?void 0:o,heightPx:null==(o=t.Message.getField(r,3))?void 0:o,composeOnVideo:null==(o=t.Message.getBooleanField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.RenderViewport.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.RenderViewport;return proto.mediapipe.RenderViewport.deserializeBinaryFromReader(o,r)},proto.mediapipe.RenderViewport.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readString();e.setId(r);break;case 2:r=t.readInt32(),e.setWidthPx(r);break;case 3:r=t.readInt32(),e.setHeightPx(r);break;case 4:r=t.readBool(),e.setComposeOnVideo(r);break;default:t.skipField()}return e},proto.mediapipe.RenderViewport.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.RenderViewport.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.RenderViewport.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=t.Message.getField(e,1))&&r.writeString(1,o),null!=(o=t.Message.getField(e,2))&&r.writeInt32(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o),null!=(o=t.Message.getField(e,4))&&r.writeBool(4,o)},proto.mediapipe.RenderViewport.prototype.getId=function(){return t.Message.getFieldWithDefault(this,1,"")},proto.mediapipe.RenderViewport.prototype.setId=function(e){return t.Message.setField(this,1,e)},proto.mediapipe.RenderViewport.prototype.clearId=function(){return t.Message.setField(this,1,void 0)},proto.mediapipe.RenderViewport.prototype.hasId=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.RenderViewport.prototype.getWidthPx=function(){return t.Message.getFieldWithDefault(this,2,0)},proto.mediapipe.RenderViewport.prototype.setWidthPx=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.RenderViewport.prototype.clearWidthPx=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.RenderViewport.prototype.hasWidthPx=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.RenderViewport.prototype.getHeightPx=function(){return t.Message.getFieldWithDefault(this,3,0)},proto.mediapipe.RenderViewport.prototype.setHeightPx=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.RenderViewport.prototype.clearHeightPx=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.RenderViewport.prototype.hasHeightPx=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.RenderViewport.prototype.getComposeOnVideo=function(){return t.Message.getBooleanFieldWithDefault(this,4,!1)},proto.mediapipe.RenderViewport.prototype.setComposeOnVideo=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.RenderViewport.prototype.clearComposeOnVideo=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.RenderViewport.prototype.hasComposeOnVideo=function(){return null!=t.Message.getField(this,4)},r.object.extend(e,proto.mediapipe)}(render_data_pb);var interactive_segmenter_result={};Object.defineProperty(interactive_segmenter_result,"__esModule",{value:!0}),interactive_segmenter_result.InteractiveSegmenterResult=void 0;class InteractiveSegmenterResult{constructor(e,t,r){this.confidenceMasks=e,this.categoryMask=t,this.qualityScores=r}close(){var e,t;null===(e=this.confidenceMasks)||void 0===e||e.forEach(e=>{e.close()}),null===(t=this.categoryMask)||void 0===t||t.close()}}interactive_segmenter_result.InteractiveSegmenterResult=InteractiveSegmenterResult;var interactive_segmenter_options={};Object.defineProperty(interactive_segmenter_options,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.InteractiveSegmenter=void 0;const o=calculator_pb,n=calculator_options_pb,i=base_options_pb,a=image_segmenter_graph_options_pb,s=segmenter_options_pb,p=vision_task_runner,c=color_pb,l=render_data_pb,d=interactive_segmenter_result;r(interactive_segmenter_options,e),r(interactive_segmenter_result,e);const u="image_in",g="norm_rect_in",f="roi_in",m="confidence_masks",h="category_mask",y="quality_scores";class b extends p.VisionTaskRunner{static createFromOptions(e,t){return p.VisionTaskRunner.createVisionInstance(b,e,t)}static createFromModelBuffer(e,t){return p.VisionTaskRunner.createVisionInstance(b,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return p.VisionTaskRunner.createVisionInstance(b,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new p.VisionGraphRunner(e,t),u,g,!1),this.outputCategoryMask=!1,this.outputConfidenceMasks=!0,this.options=new a.ImageSegmenterGraphOptions,this.segmenterOptions=new s.SegmenterOptions,this.options.setSegmenterOptions(this.segmenterOptions),this.options.setBaseOptions(new i.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r;return"outputCategoryMask"in e&&(this.outputCategoryMask=null!==(t=e.outputCategoryMask)&&void 0!==t&&t),"outputConfidenceMasks"in e&&(this.outputConfidenceMasks=null===(r=e.outputConfidenceMasks)||void 0===r||r),super.applyOptions(e)}segment(e,t,r,o){const n="function"!=typeof r?r:{};return this.userCallback="function"==typeof r?r:o,this.reset(),this.processRenderData(t,this.getSynctheticTimestamp()),this.processImageData(e,n),this.processResults()}reset(){this.confidenceMasks=void 0,this.categoryMask=void 0,this.qualityScores=void 0}processResults(){try{const e=new d.InteractiveSegmenterResult(this.confidenceMasks,this.categoryMask,this.qualityScores);if(!this.userCallback)return e;this.userCallback(e)}finally{this.freeKeepaliveStreams()}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(u),e.addInputStream(f),e.addInputStream(g);const t=new n.CalculatorOptions;t.setExtension(a.ImageSegmenterGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.interactive_segmenter.InteractiveSegmenterGraph"),r.addInputStream("IMAGE:"+u),r.addInputStream("ROI:"+f),r.addInputStream("NORM_RECT:"+g),r.setOptions(t),e.addNode(r),this.addKeepaliveNode(e),this.outputConfidenceMasks&&(e.addOutputStream(m),r.addOutputStream("CONFIDENCE_MASKS:"+m),this.keepStreamAlive(m),this.graphRunner.attachImageVectorListener(m,(e,t)=>{this.confidenceMasks=e.map(e=>this.convertToMPMask(e,!this.userCallback)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(m,e=>{this.confidenceMasks=[],this.setLatestOutputTimestamp(e)})),this.outputCategoryMask&&(e.addOutputStream(h),r.addOutputStream("CATEGORY_MASK:"+h),this.keepStreamAlive(h),this.graphRunner.attachImageListener(h,(e,t)=>{this.categoryMask=this.convertToMPMask(e,!this.userCallback),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(h,e=>{this.categoryMask=void 0,this.setLatestOutputTimestamp(e)})),e.addOutputStream(y),r.addOutputStream("QUALITY_SCORES:"+y),this.graphRunner.attachFloatVectorListener(y,(e,t)=>{this.qualityScores=e,this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(y,e=>{this.categoryMask=void 0,this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}processRenderData(e,t){const r=new l.RenderData,o=new l.RenderAnnotation,n=new c.Color;if(n.setR(255),o.setColor(n),e.keypoint&&e.scribble)throw new Error("Cannot provide both keypoint and scribble.");if(e.keypoint){const t=new l.RenderAnnotation.Point;t.setNormalized(!0),t.setX(e.keypoint.x),t.setY(e.keypoint.y),o.setPoint(t)}else{if(!e.scribble)throw new Error("Must provide either a keypoint or a scribble.");{const t=new l.RenderAnnotation.Scribble;for(const r of e.scribble){const e=new l.RenderAnnotation.Point;e.setNormalized(!0),e.setX(r.x),e.setY(r.y),t.addPoint(e)}o.setScribble(t)}}r.addRenderAnnotations(o),this.graphRunner.addProtoToStream(r.serializeBinary(),"mediapipe.RenderData",f,t)}}e.InteractiveSegmenter=b}(interactive_segmenter);var object_detector={},object_detector_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions",null,o),proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions=function(e){t.Message.initialize(this,e,0,-1,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.repeatedFields_,null)},r.inherits(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.displayName="proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions"),proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.repeatedFields_=[5,6],t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject(e,this)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),displayNamesLocale:t.Message.getFieldWithDefault(r,2,"en"),maxResults:t.Message.getFieldWithDefault(r,3,-1),scoreThreshold:null==(o=t.Message.getOptionalFloatingPointField(r,4))?void 0:o,categoryAllowlistList:null==(o=t.Message.getRepeatedField(r,5))?void 0:o,categoryDenylistList:null==(o=t.Message.getRepeatedField(r,6))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions;return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readString(),e.setDisplayNamesLocale(r);break;case 3:r=t.readInt32(),e.setMaxResults(r);break;case 4:r=t.readFloat(),e.setScoreThreshold(r);break;case 5:r=t.readString(),e.addCategoryAllowlist(r);break;case 6:r=t.readString(),e.addCategoryDenylist(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeString(2,o),null!=(o=t.Message.getField(e,3))&&r.writeInt32(3,o),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o),(o=e.getCategoryAllowlistList()).length>0&&r.writeRepeatedString(5,o),(o=e.getCategoryDenylistList()).length>0&&r.writeRepeatedString(6,o)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext=new t.ExtensionFieldInfo(443442058,{ext:0},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject,0),i.CalculatorOptions.extensionsBinary[443442058]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[443442058]=proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getDisplayNamesLocale=function(){return t.Message.getFieldWithDefault(this,2,"en")},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setDisplayNamesLocale=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearDisplayNamesLocale=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasDisplayNamesLocale=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getMaxResults=function(){return t.Message.getFieldWithDefault(this,3,-1)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setMaxResults=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearMaxResults=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasMaxResults=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getScoreThreshold=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,0)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setScoreThreshold=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearScoreThreshold=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasScoreThreshold=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getCategoryAllowlistList=function(){return t.Message.getRepeatedField(this,5)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setCategoryAllowlistList=function(e){return t.Message.setField(this,5,e||[])},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.addCategoryAllowlist=function(e,r){return t.Message.addToRepeatedField(this,5,e,r)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearCategoryAllowlistList=function(){return this.setCategoryAllowlistList([])},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getCategoryDenylistList=function(){return t.Message.getRepeatedField(this,6)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setCategoryDenylistList=function(e){return t.Message.setField(this,6,e||[])},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.addCategoryDenylist=function(e,r){return t.Message.addToRepeatedField(this,6,e,r)},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearCategoryDenylistList=function(){return this.setCategoryDenylistList([])},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext=new t.ExtensionFieldInfo(443442058,{ext:0},proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject,0),i.CalculatorOptions.extensionsBinary[443442058]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[443442058]=proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.object_detector.proto)}(object_detector_options_pb);var object_detector_options={};Object.defineProperty(object_detector_options,"__esModule",{value:!0});var object_detector_result={};Object.defineProperty(object_detector_result,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.ObjectDetector=void 0;const o=calculator_pb,n=calculator_options_pb,i=detection_pb,a=base_options_pb,s=object_detector_options_pb,p=detection_result,c=vision_task_runner,l="input_frame_gpu",d="norm_rect",u="detections";r(object_detector_options,e),r(object_detector_result,e);class g extends c.VisionTaskRunner{static createFromOptions(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,t)}static createFromModelBuffer(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,{baseOptions:{modelAssetBuffer:t}})}static async createFromModelPath(e,t){return c.VisionTaskRunner.createVisionInstance(g,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new c.VisionGraphRunner(e,t),l,d,!1),this.result={detections:[]},this.options=new s.ObjectDetectorOptions,this.options.setBaseOptions(new a.BaseOptions)}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){return void 0!==e.displayNamesLocale?this.options.setDisplayNamesLocale(e.displayNamesLocale):"displayNamesLocale"in e&&this.options.clearDisplayNamesLocale(),void 0!==e.maxResults?this.options.setMaxResults(e.maxResults):"maxResults"in e&&this.options.clearMaxResults(),void 0!==e.scoreThreshold?this.options.setScoreThreshold(e.scoreThreshold):"scoreThreshold"in e&&this.options.clearScoreThreshold(),void 0!==e.categoryAllowlist?this.options.setCategoryAllowlistList(e.categoryAllowlist):"categoryAllowlist"in e&&this.options.clearCategoryAllowlistList(),void 0!==e.categoryDenylist?this.options.setCategoryDenylistList(e.categoryDenylist):"categoryDenylist"in e&&this.options.clearCategoryDenylistList(),this.applyOptions(e)}detect(e,t){return this.result={detections:[]},this.processImageData(e,t),this.result}detectForVideo(e,t,r){return this.result={detections:[]},this.processVideoData(e,r,t),this.result}addJsObjectDetections(e){for(const t of e){const e=i.Detection.deserializeBinary(t);this.result.detections.push((0,p.convertFromDetectionProto)(e))}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(l),e.addInputStream(d),e.addOutputStream(u);const t=new n.CalculatorOptions;t.setExtension(s.ObjectDetectorOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.ObjectDetectorGraph"),r.addInputStream("IMAGE:"+l),r.addInputStream("NORM_RECT:"+d),r.addOutputStream("DETECTIONS:"+u),r.setOptions(t),e.addNode(r),this.graphRunner.attachProtoVectorListener(u,(e,t)=>{this.addJsObjectDetections(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(u,e=>{this.setLatestOutputTimestamp(e)});const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.ObjectDetector=g}(object_detector);var pose_landmarker={},pose_detector_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5),minSuppressionThreshold:t.Message.getFloatingPointFieldWithDefault(r,3,.5),numPoses:null==(o=t.Message.getField(r,4))?void 0:o};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions;return proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;case 3:r=t.readFloat(),e.setMinSuppressionThreshold(r);break;case 4:r=t.readInt32(),e.setNumPoses(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o),null!=(o=t.Message.getField(e,3))&&r.writeFloat(3,o),null!=(o=t.Message.getField(e,4))&&r.writeInt32(4,o)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext=new t.ExtensionFieldInfo(514774813,{ext:0},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[514774813]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[514774813]=proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.getMinSuppressionThreshold=function(){return t.Message.getFloatingPointFieldWithDefault(this,3,.5)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.setMinSuppressionThreshold=function(e){return t.Message.setField(this,3,e)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.clearMinSuppressionThreshold=function(){return t.Message.setField(this,3,void 0)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.hasMinSuppressionThreshold=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.getNumPoses=function(){return t.Message.getFieldWithDefault(this,4,0)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.setNumPoses=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.clearNumPoses=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.prototype.hasNumPoses=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext=new t.ExtensionFieldInfo(514774813,{ext:0},proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[514774813]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[514774813]=proto.mediapipe.tasks.vision.pose_detector.proto.PoseDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.pose_detector.proto)}(pose_detector_graph_options_pb);var pose_landmarker_graph_options_pb={},pose_landmarks_detector_graph_options_pb={};!function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a),r.exportSymbol("proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions",null,o),proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.displayName="proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),minDetectionConfidence:t.Message.getFloatingPointFieldWithDefault(r,2,.5)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions;return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=t.readFloat(),e.setMinDetectionConfidence(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,2))&&r.writeFloat(2,o)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(518928384,{ext:0},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[518928384]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[518928384]=proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.getMinDetectionConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,2,.5)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.setMinDetectionConfidence=function(e){return t.Message.setField(this,2,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.clearMinDetectionConfidence=function(){return t.Message.setField(this,2,void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.prototype.hasMinDetectionConfidence=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext=new t.ExtensionFieldInfo(518928384,{ext:0},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[518928384]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[518928384]=proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarksDetectorGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.pose_landmarker.proto)}(pose_landmarks_detector_graph_options_pb),function(e){var t=googleProtobuf,r=t,o="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==o&&o||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),n=calculator_pb;r.object.extend(proto,n);var i=calculator_options_pb;r.object.extend(proto,i);var a=base_options_pb;r.object.extend(proto,a);var s=pose_detector_graph_options_pb;r.object.extend(proto,s);var p=pose_landmarks_detector_graph_options_pb;r.object.extend(proto,p),r.exportSymbol("proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions",null,o),proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions=function(e){t.Message.initialize(this,e,0,-1,null,null)},r.inherits(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions,t.Message),r.DEBUG&&!COMPILED&&(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.displayName="proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions"),t.Message.GENERATE_TO_OBJECT&&(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.toObject=function(e){return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.toObject(e,this)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.toObject=function(e,r){var o,n={baseOptions:(o=r.getBaseOptions())&&a.BaseOptions.toObject(e,o),poseDetectorGraphOptions:(o=r.getPoseDetectorGraphOptions())&&s.PoseDetectorGraphOptions.toObject(e,o),poseLandmarksDetectorGraphOptions:(o=r.getPoseLandmarksDetectorGraphOptions())&&p.PoseLandmarksDetectorGraphOptions.toObject(e,o),minTrackingConfidence:t.Message.getFloatingPointFieldWithDefault(r,4,.5)};return e&&(n.$jspbMessageInstance=r),n}),proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.deserializeBinary=function(e){var r=new t.BinaryReader(e),o=new proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions;return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.deserializeBinaryFromReader(o,r)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new a.BaseOptions;t.readMessage(r,a.BaseOptions.deserializeBinaryFromReader),e.setBaseOptions(r);break;case 2:r=new s.PoseDetectorGraphOptions,t.readMessage(r,s.PoseDetectorGraphOptions.deserializeBinaryFromReader),e.setPoseDetectorGraphOptions(r);break;case 3:r=new p.PoseLandmarksDetectorGraphOptions,t.readMessage(r,p.PoseLandmarksDetectorGraphOptions.deserializeBinaryFromReader),e.setPoseLandmarksDetectorGraphOptions(r);break;case 4:r=t.readFloat(),e.setMinTrackingConfidence(r);break;default:t.skipField()}return e},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.serializeBinary=function(){var e=new t.BinaryWriter;return proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.serializeBinaryToWriter(this,e),e.getResultBuffer()},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.serializeBinaryToWriter=function(e,r){var o=void 0;null!=(o=e.getBaseOptions())&&r.writeMessage(1,o,a.BaseOptions.serializeBinaryToWriter),null!=(o=e.getPoseDetectorGraphOptions())&&r.writeMessage(2,o,s.PoseDetectorGraphOptions.serializeBinaryToWriter),null!=(o=e.getPoseLandmarksDetectorGraphOptions())&&r.writeMessage(3,o,p.PoseLandmarksDetectorGraphOptions.serializeBinaryToWriter),null!=(o=t.Message.getField(e,4))&&r.writeFloat(4,o)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(516587230,{ext:0},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[516587230]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[516587230]=proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.getBaseOptions=function(){return t.Message.getWrapperField(this,a.BaseOptions,1)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.setBaseOptions=function(e){return t.Message.setWrapperField(this,1,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.clearBaseOptions=function(){return this.setBaseOptions(void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.hasBaseOptions=function(){return null!=t.Message.getField(this,1)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.getPoseDetectorGraphOptions=function(){return t.Message.getWrapperField(this,s.PoseDetectorGraphOptions,2)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.setPoseDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,2,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.clearPoseDetectorGraphOptions=function(){return this.setPoseDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.hasPoseDetectorGraphOptions=function(){return null!=t.Message.getField(this,2)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.getPoseLandmarksDetectorGraphOptions=function(){return t.Message.getWrapperField(this,p.PoseLandmarksDetectorGraphOptions,3)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.setPoseLandmarksDetectorGraphOptions=function(e){return t.Message.setWrapperField(this,3,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.clearPoseLandmarksDetectorGraphOptions=function(){return this.setPoseLandmarksDetectorGraphOptions(void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.hasPoseLandmarksDetectorGraphOptions=function(){return null!=t.Message.getField(this,3)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.getMinTrackingConfidence=function(){return t.Message.getFloatingPointFieldWithDefault(this,4,.5)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.setMinTrackingConfidence=function(e){return t.Message.setField(this,4,e)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.clearMinTrackingConfidence=function(){return t.Message.setField(this,4,void 0)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.prototype.hasMinTrackingConfidence=function(){return null!=t.Message.getField(this,4)},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext=new t.ExtensionFieldInfo(516587230,{ext:0},proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.toObject,0),i.CalculatorOptions.extensionsBinary[516587230]=new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext,t.BinaryReader.prototype.readMessage,t.BinaryWriter.prototype.writeMessage,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.serializeBinaryToWriter,proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.deserializeBinaryFromReader,!1),i.CalculatorOptions.extensions[516587230]=proto.mediapipe.tasks.vision.pose_landmarker.proto.PoseLandmarkerGraphOptions.ext,r.object.extend(e,proto.mediapipe.tasks.vision.pose_landmarker.proto)}(pose_landmarker_graph_options_pb);var pose_landmarker_result={};Object.defineProperty(pose_landmarker_result,"__esModule",{value:!0}),pose_landmarker_result.PoseLandmarkerResult=void 0;class PoseLandmarkerResult{constructor(e,t,r){this.landmarks=e,this.worldLandmarks=t,this.segmentationMasks=r}close(){var e;null===(e=this.segmentationMasks)||void 0===e||e.forEach(e=>{e.close()})}}pose_landmarker_result.PoseLandmarkerResult=PoseLandmarkerResult;var pose_landmarker_options={};Object.defineProperty(pose_landmarker_options,"__esModule",{value:!0}),function(e){var t=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r),e[o]=t[r]}),r=commonjsGlobal&&commonjsGlobal.__exportStar||function(e,r){for(var o in e)"default"===o||Object.prototype.hasOwnProperty.call(r,o)||t(r,e,o)};Object.defineProperty(e,"__esModule",{value:!0}),e.PoseLandmarker=void 0;const o=calculator_pb,n=calculator_options_pb,i=landmark_pb,a=base_options_pb,s=pose_detector_graph_options_pb,p=pose_landmarker_graph_options_pb,c=pose_landmarks_detector_graph_options_pb,l=landmark_result,d=vision_task_runner,u=pose_landmarker_result;r(pose_landmarker_options,e),r(pose_landmarker_result,e);const g="image_in",f="norm_rect",m="normalized_landmarks",h="world_landmarks",y="segmentation_masks",b=.5;class v extends d.VisionTaskRunner{static createFromOptions(e,t){return d.VisionTaskRunner.createVisionInstance(v,e,t)}static createFromModelBuffer(e,t){return d.VisionTaskRunner.createVisionInstance(v,e,{baseOptions:{modelAssetBuffer:t}})}static createFromModelPath(e,t){return d.VisionTaskRunner.createVisionInstance(v,e,{baseOptions:{modelAssetPath:t}})}constructor(e,t){super(new d.VisionGraphRunner(e,t),g,f,!1),this.landmarks=[],this.worldLandmarks=[],this.outputSegmentationMasks=!1,this.options=new p.PoseLandmarkerGraphOptions,this.options.setBaseOptions(new a.BaseOptions),this.poseLandmarksDetectorGraphOptions=new c.PoseLandmarksDetectorGraphOptions,this.options.setPoseLandmarksDetectorGraphOptions(this.poseLandmarksDetectorGraphOptions),this.poseDetectorGraphOptions=new s.PoseDetectorGraphOptions,this.options.setPoseDetectorGraphOptions(this.poseDetectorGraphOptions),this.initDefaults()}get baseOptions(){return this.options.getBaseOptions()}set baseOptions(e){this.options.setBaseOptions(e)}setOptions(e){var t,r,o,n,i;return"numPoses"in e&&this.poseDetectorGraphOptions.setNumPoses(null!==(t=e.numPoses)&&void 0!==t?t:1),"minPoseDetectionConfidence"in e&&this.poseDetectorGraphOptions.setMinDetectionConfidence(null!==(r=e.minPoseDetectionConfidence)&&void 0!==r?r:b),"minTrackingConfidence"in e&&this.options.setMinTrackingConfidence(null!==(o=e.minTrackingConfidence)&&void 0!==o?o:b),"minPosePresenceConfidence"in e&&this.poseLandmarksDetectorGraphOptions.setMinDetectionConfidence(null!==(n=e.minPosePresenceConfidence)&&void 0!==n?n:b),"outputSegmentationMasks"in e&&(this.outputSegmentationMasks=null!==(i=e.outputSegmentationMasks)&&void 0!==i&&i),this.applyOptions(e)}detect(e,t,r){const o="function"!=typeof t?t:{};return this.userCallback="function"==typeof t?t:r,this.resetResults(),this.processImageData(e,o),this.processResults()}detectForVideo(e,t,r,o){const n="function"!=typeof r?r:{};return this.userCallback="function"==typeof r?r:o,this.resetResults(),this.processVideoData(e,n,t),this.processResults()}resetResults(){this.landmarks=[],this.worldLandmarks=[],this.segmentationMasks=void 0}processResults(){try{const e=new u.PoseLandmarkerResult(this.landmarks,this.worldLandmarks,this.segmentationMasks);if(!this.userCallback)return e;this.userCallback(e)}finally{this.freeKeepaliveStreams()}}initDefaults(){this.poseDetectorGraphOptions.setNumPoses(1),this.poseDetectorGraphOptions.setMinDetectionConfidence(b),this.poseLandmarksDetectorGraphOptions.setMinDetectionConfidence(b),this.options.setMinTrackingConfidence(b)}addJsLandmarks(e){this.landmarks=[];for(const t of e){const e=i.NormalizedLandmarkList.deserializeBinary(t);this.landmarks.push((0,l.convertToLandmarks)(e))}}adddJsWorldLandmarks(e){this.worldLandmarks=[];for(const t of e){const e=i.LandmarkList.deserializeBinary(t);this.worldLandmarks.push((0,l.convertToWorldLandmarks)(e))}}refreshGraph(){const e=new o.CalculatorGraphConfig;e.addInputStream(g),e.addInputStream(f),e.addOutputStream(m),e.addOutputStream(h),e.addOutputStream(y);const t=new n.CalculatorOptions;t.setExtension(p.PoseLandmarkerGraphOptions.ext,this.options);const r=new o.CalculatorGraphConfig.Node;r.setCalculator("mediapipe.tasks.vision.pose_landmarker.PoseLandmarkerGraph"),r.addInputStream("IMAGE:"+g),r.addInputStream("NORM_RECT:"+f),r.addOutputStream("NORM_LANDMARKS:"+m),r.addOutputStream("WORLD_LANDMARKS:"+h),r.setOptions(t),e.addNode(r),this.addKeepaliveNode(e),this.graphRunner.attachProtoVectorListener(m,(e,t)=>{this.addJsLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(m,e=>{this.landmarks=[],this.setLatestOutputTimestamp(e)}),this.graphRunner.attachProtoVectorListener(h,(e,t)=>{this.adddJsWorldLandmarks(e),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(h,e=>{this.worldLandmarks=[],this.setLatestOutputTimestamp(e)}),this.outputSegmentationMasks&&(r.addOutputStream("SEGMENTATION_MASK:"+y),this.keepStreamAlive(y),this.graphRunner.attachImageVectorListener(y,(e,t)=>{this.segmentationMasks=e.map(e=>this.convertToMPMask(e,!this.userCallback)),this.setLatestOutputTimestamp(t)}),this.graphRunner.attachEmptyPacketListener(y,e=>{this.segmentationMasks=[],this.setLatestOutputTimestamp(e)}));const i=e.serializeBinary();this.setGraph(new Uint8Array(i),!0)}}e.PoseLandmarker=v,v.POSE_CONNECTIONS=[{start:0,end:1},{start:1,end:2},{start:2,end:3},{start:3,end:7},{start:0,end:4},{start:4,end:5},{start:5,end:6},{start:6,end:8},{start:9,end:10},{start:11,end:12},{start:11,end:13},{start:13,end:15},{start:15,end:17},{start:15,end:19},{start:15,end:21},{start:17,end:19},{start:12,end:14},{start:14,end:16},{start:16,end:18},{start:16,end:20},{start:16,end:22},{start:18,end:20},{start:11,end:23},{start:12,end:24},{start:23,end:24},{start:23,end:25},{start:24,end:26},{start:25,end:27},{start:26,end:28},{start:27,end:29},{start:28,end:30},{start:29,end:31},{start:30,end:32},{start:27,end:31},{start:28,end:32}]}(pose_landmarker),Object.defineProperty(vision,"__esModule",{value:!0});var PoseLandmarker_1=vision.PoseLandmarker=ObjectDetector_1=vision.ObjectDetector=InteractiveSegmenter_1=vision.InteractiveSegmenter=ImageSegmenter_1=vision.ImageSegmenter=ImageEmbedder_1=vision.ImageEmbedder=ImageClassifier_1=vision.ImageClassifier=HandLandmarker_1=vision.HandLandmarker=GestureRecognizer_1=vision.GestureRecognizer=FaceStylizer_1=vision.FaceStylizer=FaceLandmarker_1=vision.FaceLandmarker=FaceDetector_1=vision.FaceDetector=MPMask_1=vision.MPMask=MPImage_1=vision.MPImage=FilesetResolver_1=vision.FilesetResolver=DrawingUtils_1=vision.DrawingUtils=void 0;const fileset_resolver_1=fileset_resolver,drawing_utils_1=drawing_utils,image_1=image,mask_1=mask,face_detector_1=face_detector,face_landmarker_1=face_landmarker,face_stylizer_1=face_stylizer,gesture_recognizer_1=gesture_recognizer,hand_landmarker_1=hand_landmarker,image_classifier_1=image_classifier,image_embedder_1=image_embedder,image_segmenter_1=image_segmenter,interactive_segmenter_1=interactive_segmenter,object_detector_1=object_detector,pose_landmarker_1=pose_landmarker,DrawingUtils=drawing_utils_1.DrawingUtils;var DrawingUtils_1=vision.DrawingUtils=DrawingUtils;const FilesetResolver=fileset_resolver_1.FilesetResolver;var FilesetResolver_1=vision.FilesetResolver=FilesetResolver;const MPImage=image_1.MPImage;var MPImage_1=vision.MPImage=MPImage;const MPMask=mask_1.MPMask;var MPMask_1=vision.MPMask=MPMask;const FaceDetector=face_detector_1.FaceDetector;var FaceDetector_1=vision.FaceDetector=FaceDetector;const FaceLandmarker=face_landmarker_1.FaceLandmarker;var FaceLandmarker_1=vision.FaceLandmarker=FaceLandmarker;const FaceStylizer=face_stylizer_1.FaceStylizer;var FaceStylizer_1=vision.FaceStylizer=FaceStylizer;const GestureRecognizer=gesture_recognizer_1.GestureRecognizer;var GestureRecognizer_1=vision.GestureRecognizer=GestureRecognizer;const HandLandmarker=hand_landmarker_1.HandLandmarker;var HandLandmarker_1=vision.HandLandmarker=HandLandmarker;const ImageClassifier=image_classifier_1.ImageClassifier;var ImageClassifier_1=vision.ImageClassifier=ImageClassifier;const ImageEmbedder=image_embedder_1.ImageEmbedder;var ImageEmbedder_1=vision.ImageEmbedder=ImageEmbedder;const ImageSegmenter=image_segmenter_1.ImageSegmenter;var ImageSegmenter_1=vision.ImageSegmenter=ImageSegmenter;const InteractiveSegmenter=interactive_segmenter_1.InteractiveSegmenter;var InteractiveSegmenter_1=vision.InteractiveSegmenter=InteractiveSegmenter;const ObjectDetector=object_detector_1.ObjectDetector;var ObjectDetector_1=vision.ObjectDetector=ObjectDetector;const PoseLandmarker=pose_landmarker_1.PoseLandmarker;PoseLandmarker_1=vision.PoseLandmarker=PoseLandmarker},280:function(e,t,r){"use strict";var o=this&&this.__awaiter||function(e,t,r,o){return new(r||(r=Promise))(function(n,i){function a(e){try{p(o.next(e))}catch(e){i(e)}}function s(e){try{p(o.throw(e))}catch(e){i(e)}}function p(e){var t;e.done?n(e.value):(t=e.value,t instanceof r?t:new r(function(e){e(t)})).then(a,s)}p((o=o.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.Fernet=void 0;const n=r(733),i=r(918),a=r(406),s=r(929),p=r(894),c=r(567);class l{constructor(e,t){this.signingKey=e,this.encryptionKey=t}static getInstance(e){return o(this,void 0,void 0,function*(){const{signingKey:t,encryptionKey:r}=yield l.importKeys(e);return new l(t,r)})}static initializeKeys(e){return o(this,void 0,void 0,function*(){const t=e.slice(0,16),r=e.slice(16),[o,a]=yield Promise.all([(0,c.importKey)(t,{name:n.Algorithms.HMAC,hash:i.HashAlgorithm.SHA256},["verify","sign"]),(0,c.importKey)(r,{name:n.Algorithms.AES_CBC},["encrypt","decrypt"])]);return{signingKey:o,encryptionKey:a}})}static importKeys(e){return o(this,void 0,void 0,function*(){let t=new Uint8Array;try{t=(0,c.fromBase64Url)(e)}catch(e){throw new s.InvalidSecretError("Invalid secret key encoding.")}if(32!==t.length)throw new s.InvalidSecretError("Invalid secret key length.");return l.initializeKeys(t)})}static getTimestampBuffer(){const e=new ArrayBuffer(8),t=new DataView(e),r=Date.now(),o=Math.round(r/1e3);return t.setBigUint64(0,BigInt(o),!1),new Uint8Array(e)}encrypt(e){return o(this,void 0,void 0,function*(){const t=(0,c.getRandomBytes)(16),r=yield(0,c.aesCbcEncrypt)(e,t,this.encryptionKey),o=new Uint8Array([128]),n=l.getTimestampBuffer(),i=new Uint8Array([...o,...n,...t,...r]),a=yield(0,c.generateHMAC)(i,this.signingKey),s=new Uint8Array([...i,...a]);return(0,c.toBase64Url)(s)})}decrypt(e){return o(this,void 0,void 0,function*(){let t=new Uint8Array;try{t=(0,c.fromBase64Url)(e)}catch(e){throw new p.InvalidTokenError("Fernet token has invalid encoding.")}if(t.length<73||(t.length-57)%16!=0)throw new p.InvalidTokenError("Fernet token has invalid length.");t.slice(0,1),t.slice(1,9);const r=t.slice(9,25),o=t.slice(25,-32),n=t.slice(-32);let i="";try{i=yield(0,c.aesCbcDecrypt)(o,r,this.encryptionKey)}catch(e){throw new a.FailedDecryptionError("Failed to decrypt the ciphertext.")}const s=t.slice(0,-32);if(!(yield(0,c.verifyHMAC)(s,this.signingKey,n)))throw new p.InvalidTokenError("Fernet token has invalid signature.");return i})}static generateSecret(){return(0,c.toBase64Url)((0,c.getRandomBytes)(32))}}t.Fernet=l},326:(e,t,r)=>{"use strict";t.P=void 0;var o=r(280);Object.defineProperty(t,"P",{enumerable:!0,get:function(){return o.Fernet}})},406:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.FailedDecryptionError=void 0;class r extends Error{constructor(e){super(e)}}t.FailedDecryptionError=r},508:function(e,t,r){var o,n,i;function a(){const e=["random","toArray","Generator is already running","value","isFunction","toISOString","classes","merge","Circular reference detected in ","paramsSerializer","Content-Length","default","Generator","end","%21","tdvc","mergeConfig","statusText"," has been deprecated since v","catchLoc","isSpecCompliantForm","clear","Content-Type"," of ms exceeded","option ","done","protocols","eject","Accept","__await","displayName","VIDEO_RECORDER_HEADERS","SyntaxError","timeout","assertOptions","asyncIterator","formToJSON","transformRequest","include","protocol","illegal catch attempt","_sent","getLRSEndeavor","put","method","charAt","head","concat","retry-after","toJSON","mark","/lrs/allocated/lr_result/","afterLoc","addEventListener","exec","set","_listeners","getLRSCredentials","endsWith","return","freezeMethods","liveness_reflection_video.mp4","Request","internals","formData","ERR_BAD_RESPONSE","password","isHeaders","ERR_NETWORK","undefined","__proto__","application/json, text/plain, */*","lineNumber","VERSION","isNode","port","fileName","entries","importScripts","blob","utf-8","forEach","synchronous","isResponse","VIDEO_RECORDER","prev","bind","Request failed with status code ","values","ms exceeded","shift","signal","formSerializer","responseURL","GeneratorFunction","as no adapter specified","domain=","isBuffer","transitional","getUri","liveness_active_frame.jpeg","HttpStatusCode","application/json"," has been removed","timeout exceeded","lengthComputable","/publicapi/api/v2/component/Applicants?&textFilter=","removeEventListener","ERR_BAD_REQUEST","promise","postMessage","setRequestHeader","hasStandardBrowserWebWorkerEnv","handlers","normalize","apply","match","arg","abrupt","Module","X-XSRF-TOKEN","key","href","boolean","__esModule","toFormData","isCancel","create","data","Basic ","inherits","indexOf","ERR_DEPRECATED","%27","age","type","isDate","2133156JelQhe","charCodeAt","Blob","nextLoc","patch","isAxiosError","rval","liveness_reflection_frame.jpeg","continue","hasOwnProp","Form","@@toStringTag","ref_image","some","%7E","isReadableStream","transformResponse","matchAll","_invoke","arrayBuffer","image/jpeg","%29","tryLoc","SECRET_HEADERS","function","aborted","CancelToken","onabort","ERR_FR_TOO_MANY_REDIRECTS","headers","if-modified-since","subscribe","progress","hostname"," is not iterable","/lrs/allocated/la_result/","parser must be boolean|regexp|function","constructor","interceptors","ALPHA_DIGIT","floor","stream","slice","getPrototypeOf","dispatchException","enumerable"," in ","completion","isGeneratorFunction","Unknown adapter '","Cannot call a class as a function","createAttempt","AxiosError","name","number","post","finallyLoc","hash","request","super","video/mp4","xhr","delete","55300ishCLA","isHTMLForm","Network Error","Authorization","getAllResponseHeaders","withCredentials","getAdapter","object","data must be an object","ECONNABORTED","complete","encode","/lrs/endeavor","unsubscribe","ERR_CANCELED","substring","defineProperty","asap","get","description","File","ReactNative","isBlob","iterator result is not an object","suspendedYield","upload","integrationId","code","Axios","getContentLength","response","body","username","configurable","getOwnPropertyNames","NativeScript","toUpperCase","since :\n","3pYZeuq","accessor","etag","getOwnPropertyDescriptor","Response","ERR_INVALID_URL","setContentType","onerror","32247XeYHxw","isURLSearchParams","reject","stack","%28"," API, but the token for the ","TypeError","/publicapi/api/v2/component/Validation","responseType","tryEntries","rejected","isArrayBuffer","AsyncIterator","if-unmodified-since","stringify","_pairs","isFileList","isPlainObject","indexes","AsyncFunction","throwIfRequested","json","baseURL","' method","resultName","serialize","FormData","pipe","visitor must be a function","defaultVisitor","[Axios v1.7.4] Transitional option '","isArrayBufferView","pop","product","status","next","throw","assign","cancelToken","createElement","fetch","getLRSOffer","referer","prototype","same-origin","defineProperties","buffer","getOwnPropertyDescriptors","[object Generator]","params","timeout of ","AxiosHeaders","enqueue","url","setPrototypeOf","isUndefined","normal","stop","try statement without catch or finally","test","writable","expires","accountId","checkTokens","isStream","resolve","isObject","videoRecorderToken","userAgent","HTMLFormElement","adapter","filter","host","iterator","getOwnPropertySymbols","clarifyTimeoutError"," must be ","accessors","executor must be a function.","byteLength","authorization","exports","wrap","content-type","replace","isFormData","suspendedStart","map","completed","Can not rewrite read-only method '","toGMTString","4733015tosXBF","CanceledError","break","/lrs/get_credentials","cause","loaded","platformToken","isArray","getApplicantByFilter","location","application/x-www-form-urlencoded","open","half","captureStackTrace","symbol","_request","delegate","columnNumber","last-modified","from","now","expires=","https","isRegExp","TOKENS_VARIANT","onreadystatechange","string","then","axios@","ETIMEDOUT","toFiniteNumber","application/x-www-form-urlencoded;charset=utf-8","1.7.4","ReadableStream","close","target must be an object","reverse","toPrimitive","/publicapi/api/v2/component/Applicants/","toString","spread","ERR_BAD_OPTION","runWhen","toObjectSet","2890MkGYhI","findKey","fulfilled","timeoutErrorMessage","length","abort","unshift","async","isFile","getContentType","config","reduceDescriptors","There is no suitable adapter to dispatch the request ","24Dtouit","baseUrl","toStringTag","ERR_BAD_OPTION_VALUE","append","adapterName","reset","warn","reason","catch","path=","isFinite","file","438vXOiZy","silentJSONParsing","Accept-Encoding","HEADER_VARIANTS","base64","env","message","size","proxy-authorization","validateStatus","nextTick","push","BAF","keys","adapter ","Response type '","awrap","hasOwnProperty","root","join","http://localhost","createApplicant","write","@@asyncIterator","abcdefghijklmnopqrstuvwxyz","sdp","getRNDActionPatter","trim","Blob is not supported. Use a Buffer instead.","__CANCEL__","5702281JHafLw","RegExp","ERR_NOT_SUPPORT","isString","forcedJSONParsing","extend","canceled","hasStandardBrowserEnv","ontimeout","614oXfujk","POST","call","has","toLowerCase","parse","is not available in the build","text","split","8xKCgqy","/lrs/allocated/rnd_action_pattern","origin","Unsupported protocol "," API was not passed in the configuration.","formdata","defaults","onloadend","motion_info","multipart/form-data","isView","cookie","dots","/lrs/offer","6175653wQasgi","omit","validators","common","pathname","toFlatObject","toJSONObject","2305XiuHxy","header name must be a non-empty string","search"];return(a=function(){return e})()}function s(e,t){const r=a();return(s=function(e,t){return r[e-=204]})(e,t)}e=r.nmd(e),function(e){const t=s,r=e();for(;;)try{if(652523==parseInt(t(435))/1*(parseInt(t(405))/2)+parseInt(t(676))/3*(parseInt(t(575))/4)+-parseInt(t(638))/5*(-parseInt(t(366))/6)+parseInt(t(296))/7*(-parseInt(t(414))/8)+-parseInt(t(205))/9*(parseInt(t(340))/10)+-parseInt(t(428))/11+parseInt(t(353))/12*(parseInt(t(396))/13))break;r.push(r.shift())}catch(e){r.push(r.shift())}}(a),function(a,p){const c=s;c(645)==typeof t&&"object"==c(645)?e[c(286)]=p():"function"==c(599)&&r.amdO?(n=[],void 0===(i="function"==typeof(o=p)?o.apply(t,n):o)||(e.exports=i)):c(645)==typeof t?t[c(453)]=p():a[c(453)]=p()}("undefined"==typeof self?this:self,()=>(()=>{"use strict";const e=s;var t={d:(e,r)=>{const o=s;for(var n in r)t.o(r,n)&&!t.o(e,n)&&Object[o(654)](e,n,{enumerable:!0,get:r[n]})},o:(t,r)=>Object.prototype.hasOwnProperty[e(407)](t,r),r:t=>{const r=e;"undefined"!=typeof Symbol&&Symbol[r(355)]&&Object[r(654)](t,Symbol[r(355)],{value:r(557)}),Object[r(654)](t,r(562),{value:!0})}},o={};t.d(o,{default:()=>At});var n={};function i(e,t){return function(){return e.apply(t,arguments)}}t.r(n),t.d(n,{hasBrowserEnv:()=>me,hasStandardBrowserEnv:()=>he,hasStandardBrowserWebWorkerEnv:()=>be,origin:()=>ve});const{toString:a}=Object[e(248)],{getPrototypeOf:p}=Object,c=(l=Object.create(null),t=>{const r=e,o=a.call(t);return l[o]||(l[o]=o[r(617)](8,-1).toLowerCase())});var l;const d=e=>(e=e.toLowerCase(),t=>c(t)===e),u=e=>t=>typeof t===e,{isArray:g}=Array,f=u(e(507)),m=d("ArrayBuffer"),h=u(e(322)),y=u("function"),b=u(e(629)),v=t=>null!==t&&e(645)==typeof t,_=t=>{const r=e;if(r(645)!==c(t))return!1;const o=p(t);return!(null!==o&&o!==Object[r(248)]&&null!==Object[r(618)](o)||Symbol[r(355)]in t||Symbol[r(278)]in t)},O=d("Date"),w=d(e(658)),S=d(e(577)),E=d("FileList"),k=d("URLSearchParams"),[F,M,R,T]=[e(329),e(500),e(680),"Headers"][e(292)](d);function C(t,r,{allOwnKeys:o=!1}={}){const n=e;if(null==t)return;let i,a;if(n(645)!=typeof t&&(t=[t]),g(t))for(i=0,a=t.length;i<a;i++)r[n(407)](null,t[i],i,t);else{const e=o?Object[n(672)](t):Object[n(379)](t),a=e[n(344)];let s;for(i=0;i<a;i++)s=e[i],r[n(407)](null,t[s],s,t)}}function A(t,r){r=r[e(409)]();const o=Object.keys(t);let n,i=o.length;for(;i-- >0;)if(n=o[i],r===n.toLowerCase())return n;return null}const B=e(507)!=typeof globalThis?globalThis:e(507)!=typeof self?self:e(507)!=typeof window?window:r.g,P=e=>!f(e)&&e!==B,j=(L=e(507)!=typeof Uint8Array&&p(Uint8Array),e=>L&&e instanceof L);var L;const I=d(e(274)),D=(({hasOwnProperty:t})=>(r,o)=>t[e(407)](r,o))(Object.prototype),x=d(e(397)),G=(t,r)=>{const o=e,n=Object[o(252)](t),i={};C(n,(e,o)=>{let n;!1!==(n=r(e,o,t))&&(i[o]=n||e)}),Object[o(250)](t,i)},N=e(390),z="0123456789",W={DIGIT:z,ALPHA:N,ALPHA_DIGIT:N+N[e(674)]()+z},U=d(e(224)),H=(V=e(599)==typeof setImmediate,K=y(B.postMessage),V?setImmediate:K?(X=e(324)+Math.random(),$=[],B.addEventListener(e(372),({source:t,data:r})=>{const o=e;t===B&&r===X&&$[o(344)]&&$[o(528)]()()},!1),t=>{const r=e;$.push(t),B[r(548)](X,"*")}):e=>setTimeout(e));var V,K,X,$;const Y=e(507)!=typeof queueMicrotask?queueMicrotask[e(524)](B):e(507)!=typeof process&&process[e(376)]||H,q={isArray:g,isArrayBuffer:m,isBuffer:function(t){const r=e;return null!==t&&!f(t)&&null!==t[r(612)]&&!f(t[r(612)])&&y(t[r(612)][r(535)])&&t[r(612)][r(535)](t)},isFormData:t=>{const r=e;let o;return t&&("function"==typeof FormData&&t instanceof FormData||y(t[r(357)])&&(r(419)===(o=c(t))||r(645)===o&&y(t.toString)&&"[object FormData]"===t[r(335)]()))},isArrayBufferView:function(t){const r=e;let o;return o=r(507)!=typeof ArrayBuffer&&ArrayBuffer.isView?ArrayBuffer[r(424)](t):t&&t.buffer&&m(t[r(251)]),o},isString:h,isNumber:b,isBoolean:e=>!0===e||!1===e,isObject:v,isPlainObject:_,isReadableStream:F,isRequest:M,isResponse:R,isHeaders:T,isUndefined:f,isDate:O,isFile:w,isBlob:S,isRegExp:x,isFunction:y,isStream:t=>v(t)&&y(t[e(232)]),isURLSearchParams:k,isTypedArray:j,isFileList:E,forEach:C,merge:function t(){const r=e,{caseless:o}=P(this)&&this||{},n={},i=(e,r)=>{const i=s,a=o&&A(n,r)||r;_(n[a])&&_(e)?n[a]=t(n[a],e):_(e)?n[a]=t({},e):g(e)?n[a]=e[i(617)]():n[a]=e};for(let e=0,t=arguments[r(344)];e<t;e++)arguments[e]&&C(arguments[e],i);return n},extend:(e,t,r,{allOwnKeys:o}={})=>(C(t,(t,o)=>{r&&y(t)?e[o]=i(t,r):e[o]=t},{allOwnKeys:o}),e),trim:t=>t[e(393)]?t[e(393)]():t[e(289)](/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,""),stripBOM:t=>(65279===t[e(576)](0)&&(t=t.slice(1)),t),inherits:(t,r,o,n)=>{const i=e;t[i(248)]=Object[i(565)](r[i(248)],n),t[i(248)][i(612)]=t,Object[i(654)](t,i(634),{value:r.prototype}),o&&Object[i(242)](t.prototype,o)},toFlatObject:(t,r,o,n)=>{const i=e;let a,s,c;const l={};if(r=r||{},null==t)return r;do{for(a=Object[i(672)](t),s=a[i(344)];s-- >0;)c=a[s],n&&!n(c,t,r)||l[c]||(r[c]=t[c],l[c]=!0);t=!1!==o&&p(t)}while(t&&(!o||o(t,r))&&t!==Object[i(248)]);return r},kindOf:c,kindOfTest:d,endsWith:(t,r,o)=>{const n=e;t=String(t),(void 0===o||o>t[n(344)])&&(o=t[n(344)]),o-=r.length;const i=t.indexOf(r,o);return-1!==i&&i===o},toArray:t=>{const r=e;if(!t)return null;if(g(t))return t;let o=t[r(344)];if(!b(o))return null;const n=new Array(o);for(;o-- >0;)n[o]=t[o];return n},forEachEntry:(t,r)=>{const o=e,n=(t&&t[Symbol[o(278)]]).call(t);let i;for(;(i=n[o(240)]())&&!i[o(463)];){const e=i.value;r[o(407)](t,e[0],e[1])}},matchAll:(t,r)=>{const o=e;let n;const i=[];for(;null!==(n=t[o(492)](r));)i[o(377)](n);return i},isHTMLForm:I,hasOwnProperty:D,hasOwnProp:D,reduceDescriptors:G,freezeMethods:e=>{G(e,(t,r)=>{const o=s;if(y(e)&&-1!==["arguments","caller","callee"].indexOf(r))return!1;const n=e[r];y(n)&&(t[o(620)]=!1,o(265)in t?t[o(265)]=!1:t[o(493)]||(t[o(493)]=()=>{throw Error(o(294)+r+"'")}))})},toObjectSet:(e,t)=>{const r={},o=e=>{e[s(519)](e=>{r[e]=!0})};return g(e)?o(e):o(String(e).split(t)),r},toCamelCase:t=>t[e(409)]()[e(289)](/[-_\s]([a-z\d])(\w*)/g,function(t,r,o){return r[e(674)]()+o}),noop:()=>{},toFiniteNumber:(t,r)=>null!=t&&Number[e(364)](t=+t)?t:r,findKey:A,global:B,isContextDefined:P,ALPHABET:W,generateString:(t=16,r=W[e(614)])=>{const o=e;let n="";const{length:i}=r;for(;t--;)n+=r[Math[o(438)]()*i|0];return n},isSpecCompliantForm:function(t){const r=e;return!!(t&&y(t[r(357)])&&"FormData"===t[Symbol[r(355)]]&&t[Symbol[r(278)]])},toJSONObject:e=>{const t=new Array(10),r=(e,o)=>{const n=s;if(v(e)){if(t[n(569)](e)>=0)return;if(!(n(487)in e)){t[o]=e;const n=g(e)?[]:{};return C(e,(e,t)=>{const i=r(e,o+1);!f(i)&&(n[t]=i)}),t[o]=void 0,n}}return e};return r(e,0)},isAsyncFn:U,isThenable:t=>t&&(v(t)||y(t))&&y(t[e(323)])&&y(t[e(362)]),setImmediate:H,asap:Y};function J(t,r,o,n,i){const a=e;Error.call(this),Error[a(309)]?Error[a(309)](this,this[a(612)]):this[a(208)]=(new Error)[a(208)],this.message=t,this[a(628)]=a(627),r&&(this.code=r),o&&(this[a(350)]=o),n&&(this.request=n),i&&(this[a(668)]=i)}q.inherits(J,Error,{toJSON:function(){const t=e;return{message:this[t(372)],name:this.name,description:this[t(657)],number:this[t(629)],fileName:this[t(514)],lineNumber:this[t(510)],columnNumber:this[t(313)],stack:this.stack,config:q[t(434)](this[t(350)]),code:this[t(665)],status:this[t(668)]&&this[t(668)].status?this[t(668)].status:null}}});const Z=J[e(248)],Q={};[e(356),e(337),e(647),e(325),e(506),e(603),e(570),"ERR_BAD_RESPONSE",e(546),e(652),e(398),e(681)][e(519)](e=>{Q[e]={value:e}}),Object[e(250)](J,Q),Object.defineProperty(Z,e(580),{value:!0}),J.from=(t,r,o,n,i,a)=>{const s=e,p=Object[s(565)](Z);return q[s(433)](t,p,function(e){return e!==Error.prototype},e=>s(580)!==e),J[s(407)](p,t[s(372)],r,o,n,i),p[s(300)]=t,p[s(628)]=t[s(628)],a&&Object[s(242)](p,a),p};const ee=J;function te(t){return q[e(222)](t)||q.isArray(t)}function re(t){const r=e;return q.endsWith(t,"[]")?t[r(617)](0,-2):t}function oe(t,r,o){const n=e;return t?t.concat(r)[n(292)](function(e,t){return e=re(e),!o&&t?"["+e+"]":e})[n(385)](o?".":""):r}const ne=q[e(433)](q,{},null,function(t){return/^is[A-Z]/[e(264)](t)}),ie=function(t,r,o){const n=e;if(!q[n(271)](t))throw new TypeError(n(331));r=r||new FormData;const i=(o=q[n(433)](o,{metaTokens:!0,dots:!1,indexes:!1},!1,function(e,t){return!q[n(260)](t[e])})).metaTokens,a=o.visitor||d,s=o[n(426)],p=o[n(223)],c=(o.Blob||n(507)!=typeof Blob&&Blob)&&q[n(458)](r);if(!q[n(442)](a))throw new TypeError(n(233));function l(e){const t=n;if(null===e)return"";if(q[t(574)](e))return e[t(443)]();if(!c&&q[t(660)](e))throw new ee(t(394));return q[t(216)](e)||q.isTypedArray(e)?c&&t(599)==typeof Blob?new Blob([e]):Buffer[t(315)](e):e}function d(e,t,o){const a=n;let c=e;if(e&&!o&&a(645)==typeof e)if(q[a(496)](t,"{}"))t=i?t:t[a(617)](0,-2),e=JSON.stringify(e);else if(q[a(303)](e)&&function(e){const t=a;return q[t(303)](e)&&!e[t(588)](te)}(e)||(q[a(221)](e)||q[a(496)](t,"[]"))&&(c=q[a(439)](e)))return t=re(t),c.forEach(function(e,o){!q[a(260)](e)&&null!==e&&r.append(!0===p?oe([t],o,s):null===p?t:t+"[]",l(e))}),!1;return!!te(e)||(r.append(oe(o,t,s),l(e)),!1)}const u=[],g=Object[n(242)](ne,{defaultVisitor:d,convertValue:l,isVisitable:te});if(!q[n(271)](t))throw new TypeError(n(646));return function e(t,o){const i=n;if(!q[i(260)](t)){if(-1!==u.indexOf(t))throw Error(i(446)+o.join("."));u[i(377)](t),q.forEach(t,function(t,n){const s=i;!0===(!(q[s(260)](t)||null===t)&&a[s(407)](r,t,q[s(399)](n)?n[s(393)]():n,o,g))&&e(t,o?o[s(485)](n):[n])}),u[i(237)]()}}(t),r};function ae(t){const r=e,o={"!":r(452),"'":r(571),"(":r(209),")":r(596),"~":r(589),"%20":"+","%00":"\0"};return encodeURIComponent(t)[r(289)](/[!'()~]|%20|%00/g,function(e){return o[e]})}function se(t,r){this[e(220)]=[],t&&ie(t,this,r)}const pe=se[e(248)];pe[e(357)]=function(t,r){const o=e;this[o(220)][o(377)]([t,r])},pe[e(335)]=function(t){const r=e,o=t?function(e){return t[s(407)](this,e,ae)}:ae;return this[r(220)].map(function(e){return o(e[0])+"="+o(e[1])},"")[r(385)]("&")};const ce=se;function le(t){const r=e;return encodeURIComponent(t)[r(289)](/%3A/gi,":")[r(289)](/%24/g,"$")[r(289)](/%2C/gi,",")[r(289)](/%20/g,"+")[r(289)](/%5B/gi,"[")[r(289)](/%5D/gi,"]")}function de(t,r,o){const n=e;if(!r)return t;const i=o&&o[n(649)]||le,a=o&&o[n(230)];let s;if(s=a?a(r,o):q[n(206)](r)?r[n(335)]():new ce(r,o)[n(335)](i),s){const e=t[n(569)]("#");-1!==e&&(t=t[n(617)](0,e)),t+=(-1===t[n(569)]("?")?"?":"&")+s}return t}const ue=class{constructor(){this[e(551)]=[]}use(t,r,o){const n=e;return this[n(551)][n(377)]({fulfilled:t,rejected:r,synchronous:!!o&&o[n(520)],runWhen:o?o[n(338)]:null}),this.handlers[n(344)]-1}[e(465)](t){const r=e;this[r(551)][t]&&(this[r(551)][t]=null)}[e(459)](){const t=e;this[t(551)]&&(this[t(551)]=[])}[e(519)](t){q[e(519)](this.handlers,function(e){null!==e&&t(e)})}},ge={silentJSONParsing:!0,forcedJSONParsing:!0,clarifyTimeoutError:!1},fe={isBrowser:!0,classes:{URLSearchParams:e(507)!=typeof URLSearchParams?URLSearchParams:ce,FormData:"undefined"!=typeof FormData?FormData:null,Blob:"undefined"!=typeof Blob?Blob:null},protocols:["http",e(318),e(365),e(517),e(258),"data"]},me="undefined"!=typeof window&&"undefined"!=typeof document,he=(ye=e(507)!=typeof navigator&&navigator[e(238)],me&&[e(659),e(673),"NS"].indexOf(ye)<0);var ye;const be=e(507)!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope&&e(599)==typeof self[e(516)],ve=me&&window.location[e(560)]||e(386),_e={...n,...fe},Oe=function(t){const r=e;function o(e,t,r,n){const i=s;let a=e[n++];if(i(508)===a)return!0;const p=Number[i(364)](+a),c=n>=e[i(344)];return a=!a&&q[i(303)](r)?r[i(344)]:a,c?(q[i(584)](r,a)?r[a]=[r[a],t]:r[a]=t,!p):(r[a]&&q[i(271)](r[a])||(r[a]=[]),o(e,t,r[a],n)&&q.isArray(r[a])&&(r[a]=function(e){const t=i,r={},o=Object[t(379)](e);let n;const a=o[t(344)];let s;for(n=0;n<a;n++)s=o[n],r[s]=e[s];return r}(r[a])),!p)}if(q[r(290)](t)&&q[r(442)](t[r(515)])){const e={};return q.forEachEntry(t,(t,r)=>{o(function(e){const t=s;return q[t(592)](/\w+|\[(\w*)]/g,e)[t(292)](e=>"[]"===e[0]?"":e[1]||e[0])}(t),r,e,0)}),e}return null},we={transitional:ge,adapter:[e(636),"http",e(245)],transformRequest:[function(t,r){const o=e,n=r.getContentType()||"",i=n[o(569)](o(540))>-1,a=q[o(271)](t);if(a&&q[o(639)](t)&&(t=new FormData(t)),q.isFormData(t))return i?JSON.stringify(Oe(t)):t;if(q[o(216)](t)||q.isBuffer(t)||q[o(269)](t)||q[o(348)](t)||q[o(660)](t)||q.isReadableStream(t))return t;if(q[o(236)](t))return t[o(251)];if(q.isURLSearchParams(t))return r[o(682)](o(327),!1),t[o(335)]();let s;if(a){if(n[o(569)](o(306))>-1)return function(e,t){const r=o;return ie(e,new _e.classes.URLSearchParams,Object[r(242)]({visitor:function(e,t,o,n){const i=r;return _e[i(512)]&&q[i(535)](e)?(this.append(t,e[i(335)](i(370))),!1):n[i(234)].apply(this,arguments)}},t))}(t,this[o(530)])[o(335)]();if((s=q[o(221)](t))||n[o(569)](o(423))>-1){const e=this[o(371)]&&this[o(371)].FormData;return ie(s?{"files[]":t}:t,e&&new e,this.formSerializer)}}return a||i?(r.setContentType(o(540),!1),function(e){const t=o;if(q.isString(e))try{return(0,JSON[t(410)])(e),q[t(393)](e)}catch(e){if(t(470)!==e.name)throw e}return(0,JSON[t(219)])(e)}(t)):t}],transformResponse:[function(t){const r=e,o=this.transitional||we[r(536)],n=o&&o[r(400)],i=r(226)===this[r(213)];if(q[r(521)](t)||q[r(590)](t))return t;if(t&&q[r(399)](t)&&(n&&!this[r(213)]||i)){const e=!(o&&o[r(367)])&&i;try{return JSON[r(410)](t)}catch(t){if(e){if(r(470)===t[r(628)])throw ee[r(315)](t,ee[r(503)],this,null,this[r(668)]);throw t}}}return t}],timeout:0,xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:e(558),maxContentLength:-1,maxBodyLength:-1,env:{FormData:_e.classes[e(231)],Blob:_e[e(444)][e(577)]},validateStatus:function(e){return e>=200&&e<300},headers:{common:{Accept:e(509),"Content-Type":void 0}}};q[e(519)]([e(637),e(656),"head","post",e(481),e(579)],e=>{we.headers[e]={}});const Se=we,Ee=q[e(339)]([e(572),e(285),"content-length",e(288),e(678),e(266),e(315),e(277),e(605),e(218),e(314),e(305),"max-forwards",e(374),e(247),e(486),"user-agent"]),ke=Symbol(e(501));function Fe(t){const r=e;return t&&String(t)[r(393)]()[r(409)]()}function Me(e){return!1===e||null==e?e:q.isArray(e)?e.map(Me):String(e)}function Re(t,r,o,n,i){const a=e;return q[a(442)](n)?n[a(407)](this,r,o):(i&&(r=o),q[a(399)](r)?q[a(399)](n)?-1!==r.indexOf(n):q[a(319)](n)?n[a(264)](r):void 0:void 0)}class Te{constructor(e){e&&this.set(e)}[e(493)](t,r,o){const n=e,i=this;function a(e,t,r){const o=s,n=Fe(t);if(!n)throw new Error(o(436));const a=q.findKey(i,n);(!a||void 0===i[a]||!0===r||void 0===r&&!1!==i[a])&&(i[a||t]=Me(e))}const p=(e,t)=>q[n(519)](e,(e,r)=>a(e,r,t));if(q.isPlainObject(t)||t instanceof this[n(612)])p(t,r);else if(q[n(399)](t)&&(t=t.trim())&&!/^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(t[n(393)]()))p((e=>{const t={};let r,o,n;return e&&e.split("\n").forEach(function(e){const i=s;n=e[i(569)](":"),r=e.substring(0,n).trim()[i(409)](),o=e[i(653)](n+1)[i(393)](),!r||t[r]&&Ee[r]||("set-cookie"===r?t[r]?t[r].push(o):t[r]=[o]:t[r]=t[r]?t[r]+", "+o:o)}),t})(t),r);else if(q[n(505)](t))for(const[e,r]of t[n(515)]())a(r,e,o);else null!=t&&a(r,t,o);return this}get(t,r){const o=e;if(t=Fe(t)){const e=q[o(341)](this,t);if(e){const t=this[e];if(!r)return t;if(!0===r)return function(e){const t=o,r=Object.create(null),n=/([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;let i;for(;i=n[t(492)](e);)r[i[1]]=i[2];return r}(t);if(q[o(442)](r))return r.call(this,t,e);if(q[o(319)](r))return r.exec(t);throw new TypeError(o(611))}}}[e(408)](t,r){const o=e;if(t=Fe(t)){const e=q[o(341)](this,t);return!(!e||void 0===this[e]||r&&!Re(0,this[e],e,r))}return!1}[e(637)](t,r){const o=e,n=this;let i=!1;function a(e){const t=s;if(e=Fe(e)){const o=q[t(341)](n,e);!o||r&&!Re(0,n[o],o,r)||(delete n[o],i=!0)}}return q[o(303)](t)?t[o(519)](a):a(t),i}clear(t){const r=e,o=Object[r(379)](this);let n=o[r(344)],i=!1;for(;n--;){const e=o[n];t&&!Re(0,this[e],e,t,!0)||(delete this[e],i=!0)}return i}[e(552)](t){const r=this,o={};return q[e(519)](this,(e,n)=>{const i=q.findKey(o,n);if(i)return r[i]=Me(e),void delete r[n];const a=t?function(e){const t=s;return e[t(393)]()[t(409)]()[t(289)](/([a-z\d])(\w*)/g,(e,r,o)=>r[t(674)]()+o)}(n):String(n).trim();a!==n&&delete r[n],r[a]=Me(e),o[a]=!0}),this}concat(...t){const r=e;return this.constructor[r(485)](this,...t)}[e(487)](e){const t=Object.create(null);return q.forEach(this,(r,o)=>{const n=s;null!=r&&!1!==r&&(t[o]=e&&q[n(303)](r)?r.join(", "):r)}),t}[Symbol[e(278)]](){const t=e;return Object[t(515)](this[t(487)]())[Symbol.iterator]()}[e(335)](){const t=e;return Object[t(515)](this[t(487)]())[t(292)](([e,t])=>e+": "+t)[t(385)]("\n")}get[Symbol.toStringTag](){return e(256)}static from(e){return e instanceof this?e:new this(e)}static concat(t,...r){const o=e,n=new this(t);return r[o(519)](e=>n[o(493)](e)),n}static[e(677)](t){const r=e,o=(this[ke]=this[ke]={accessors:{}})[r(282)],n=this[r(248)];function i(e){const t=Fe(e);o[t]||(function(e,t){const r=s,o=q.toCamelCase(" "+t);[r(656),r(493),r(408)][r(519)](n=>{const i=r;Object[i(654)](e,n+o,{value:function(e,r,o){const a=i;return this[n][a(407)](this,t,e,r,o)},configurable:!0})})}(n,e),o[t]=!0)}return q[r(303)](t)?t[r(519)](i):i(t),this}}Te.accessor([e(460),e(448),e(466),e(368),"User-Agent",e(641)]),q[e(351)](Te.prototype,({value:t},r)=>{const o=e;let n=r[0][o(674)]()+r[o(617)](1);return{get:()=>t,set(e){this[n]=e}}}),q[e(498)](Te);const Ce=Te;function Ae(t,r){const o=e,n=this||Se,i=r||n,a=Ce.from(i.headers);let s=i[o(566)];return q[o(519)](t,function(e){const t=o;s=e[t(407)](n,s,a[t(552)](),r?r[t(239)]:void 0)}),a.normalize(),s}function Be(t){return!(!t||!t[e(395)])}function Pe(t,r,o){const n=e;ee[n(407)](this,null==t?n(402):t,ee.ERR_CANCELED,r,o),this[n(628)]="CanceledError"}q[e(568)](Pe,ee,{__CANCEL__:!0});const je=Pe;function Le(t,r,o){const n=e,i=o[n(350)][n(375)];o.status&&i&&!i(o[n(239)])?r(new ee(n(525)+o.status,[ee[n(546)],ee.ERR_BAD_RESPONSE][Math[n(615)](o[n(239)]/100)-4],o[n(350)],o.request,o)):t(o)}const Ie=(e,t,r=3)=>{let o=0;const n=function(e,t){e=e||10;const r=new Array(e),o=new Array(e);let n,i=0,a=0;return t=void 0!==t?t:1e3,function(p){const c=Date[s(316)](),l=o[a];n||(n=c),r[i]=p,o[i]=c;let d=a,u=0;for(;d!==i;)u+=r[d++],d%=e;if(i=(i+1)%e,i===a&&(a=(a+1)%e),c-n<t)return;const g=l&&c-l;return g?Math.round(1e3*u/g):void 0}}(50,250);return function(e,t){const r=s;let o,n,i=0,a=1e3/t;const p=(t,a=Date[r(316)]())=>{const s=r;i=a,o=null,n&&(clearTimeout(n),n=null),e[s(553)](null,t)};return[(...e)=>{const t=Date[r(316)](),s=t-i;s>=a?p(e,t):(o=e,n||(n=setTimeout(()=>{n=null,p(o)},a-s)))},()=>o&&p(o)]}(r=>{const i=s,a=r[i(301)],p=r[i(543)]?r.total:void 0,c=a-o,l=n(c);o=a,e({loaded:a,total:p,progress:p?a/p:void 0,bytes:c,rate:l||void 0,estimated:l&&p&&a<=p?(p-a)/l:void 0,event:r,lengthComputable:null!=p,[t?"download":i(663)]:!0})},r)},De=(e,t)=>{const r=null!=e;return[o=>t[0]({lengthComputable:r,total:e,loaded:o}),t[1]]},xe=t=>(...r)=>q[e(655)](()=>t(...r)),Ge=_e[e(403)]?function(){const t=e,r=/(msie|trident)/i.test(navigator[t(273)]),o=document[t(244)]("a");let n;function i(e){const n=t;let i=e;return r&&(o.setAttribute("href",i),i=o[n(560)]),o.setAttribute("href",i),{href:o.href,protocol:o.protocol?o[n(477)].replace(/:$/,""):"",host:o[n(277)],search:o[n(437)]?o[n(437)][n(289)](/^\?/,""):"",hash:o[n(632)]?o[n(632)].replace(/^#/,""):"",hostname:o[n(608)],port:o[n(513)],pathname:"/"===o[n(432)][n(483)](0)?o[n(432)]:"/"+o.pathname}}return n=i(window[t(305)][t(560)]),function(e){const r=t,o=q[r(399)](e)?i(e):e;return o.protocol===n[r(477)]&&o[r(277)]===n[r(277)]}}():function(){return!0},Ne=_e[e(403)]?{write(t,r,o,n,i,a){const s=e,p=[t+"="+encodeURIComponent(r)];q.isNumber(o)&&p[s(377)](s(317)+new Date(o)[s(295)]()),q[s(399)](n)&&p[s(377)](s(363)+n),q[s(399)](i)&&p.push(s(534)+i),!0===a&&p[s(377)]("secure"),document[s(425)]=p[s(385)]("; ")},read(t){const r=e,o=document[r(425)][r(554)](new RegExp("(^|;\\s*)("+t+")=([^;]*)"));return o?decodeURIComponent(o[3]):null},remove(t){const r=e;this[r(388)](t,"",Date[r(316)]()-864e5)}}:{write(){},read:()=>null,remove(){}};function ze(t,r){const o=e;return t&&!/^([a-z][a-z\d+\-.]*:)?\/\//i[o(264)](r)?function(e,t){const r=o;return t?e[r(289)](/\/?\/$/,"")+"/"+t[r(289)](/^\/+/,""):e}(t,r):r}const We=e=>e instanceof Ce?{...e}:e;function Ue(t,r){const o=e;r=r||{};const n={};function i(e,t,r){const o=s;return q[o(222)](e)&&q[o(222)](t)?q.merge.call({caseless:r},e,t):q.isPlainObject(t)?q[o(445)]({},t):q[o(303)](t)?t.slice():t}function a(e,t,r){const o=s;return q.isUndefined(t)?q[o(260)](e)?void 0:i(void 0,e,r):i(e,t,r)}function p(e,t){if(!q[s(260)](t))return i(void 0,t)}function c(e,t){const r=s;return q[r(260)](t)?q[r(260)](e)?void 0:i(void 0,e):i(void 0,t)}function l(e,o,n){return n in r?i(e,o):n in t?i(void 0,e):void 0}const d={url:p,method:p,data:p,baseURL:c,transformRequest:c,transformResponse:c,paramsSerializer:c,timeout:c,timeoutMessage:c,withCredentials:c,withXSRFToken:c,adapter:c,responseType:c,xsrfCookieName:c,xsrfHeaderName:c,onUploadProgress:c,onDownloadProgress:c,decompress:c,maxContentLength:c,maxBodyLength:c,beforeRedirect:c,transport:c,httpAgent:c,httpsAgent:c,cancelToken:c,socketPath:c,responseEncoding:c,validateStatus:l,headers:(e,t)=>a(We(e),We(t),!0)};return q.forEach(Object[o(379)](Object[o(242)]({},t,r)),function(e){const i=o,s=d[e]||a,p=s(t[e],r[e],e);q[i(260)](p)&&s!==l||(n[e]=p)}),n}const He=t=>{const r=e,o=Ue({},t);let n,{data:i,withXSRFToken:a,xsrfHeaderName:s,xsrfCookieName:p,headers:c,auth:l}=o;if(o[r(604)]=c=Ce.from(c),o[r(258)]=de(ze(o.baseURL,o.url),t[r(254)],t[r(447)]),l&&c.set("Authorization",r(567)+btoa((l[r(670)]||"")+":"+(l[r(504)]?unescape(encodeURIComponent(l.password)):""))),q[r(290)](i))if(_e[r(403)]||_e[r(550)])c[r(682)](void 0);else if(!1!==(n=c[r(349)]())){const[e,...t]=n?n[r(413)](";")[r(292)](e=>e[r(393)]())[r(276)](Boolean):[];c.setContentType([e||r(423),...t][r(385)]("; "))}if(_e[r(403)]&&(a&&q.isFunction(a)&&(a=a(o)),a||!1!==a&&Ge(o[r(258)]))){const e=s&&p&&Ne.read(p);e&&c[r(493)](s,e)}return o},Ve=e(507)!=typeof XMLHttpRequest&&function(e){return new Promise(function(t,r){const o=s,n=He(e);let i=n[o(566)];const a=Ce[o(315)](n.headers)[o(552)]();let p,c,l,d,u,{responseType:g,onUploadProgress:f,onDownloadProgress:m}=n;function h(){const e=o;d&&d(),u&&u(),n[e(243)]&&n[e(243)].unsubscribe(p),n.signal&&n[e(529)][e(545)](e(345),p)}let y=new XMLHttpRequest;function b(){const n=o;if(!y)return;const i=Ce[n(315)](n(642)in y&&y[n(642)]());Le(function(e){t(e),h()},function(e){r(e),h()},{data:g&&n(412)!==g&&n(226)!==g?y.response:y.responseText,status:y.status,statusText:y[n(455)],headers:i,config:e,request:y}),y=null}y[o(307)](n[o(482)][o(674)](),n[o(258)],!0),y.timeout=n[o(471)],o(421)in y?y[o(421)]=b:y[o(321)]=function(){const e=o;y&&4===y.readyState&&(0!==y[e(239)]||y[e(531)]&&0===y[e(531)].indexOf("file:"))&&setTimeout(b)},y[o(602)]=function(){y&&(r(new ee("Request aborted",ee[o(647)],e,y)),y=null)},y[o(204)]=function(){const t=o;r(new ee(t(640),ee[t(506)],e,y)),y=null},y[o(404)]=function(){const t=o;let i=n.timeout?t(255)+n[t(471)]+t(527):t(542);const a=n[t(536)]||ge;n[t(343)]&&(i=n[t(343)]),r(new ee(i,a[t(280)]?ee[t(325)]:ee.ECONNABORTED,e,y)),y=null},void 0===i&&a[o(682)](null),o(549)in y&&q[o(519)](a[o(487)](),function(e,t){y.setRequestHeader(t,e)}),q[o(260)](n[o(643)])||(y[o(643)]=!!n[o(643)]),g&&o(226)!==g&&(y[o(213)]=n[o(213)]),m&&([l,u]=Ie(m,!0),y[o(491)]("progress",l)),f&&y[o(663)]&&([c,d]=Ie(f),y[o(663)].addEventListener(o(607),c),y[o(663)].addEventListener("loadend",d)),(n[o(243)]||n[o(529)])&&(p=t=>{const n=o;y&&(r(!t||t[n(573)]?new je(null,e,y):t),y[n(345)](),y=null)},n[o(243)]&&n[o(243)][o(606)](p),n[o(529)]&&(n[o(529)][o(600)]?p():n[o(529)].addEventListener(o(345),p)));const v=function(e){const t=/^([-+\w]{1,25})(:?\/\/|:)/.exec(e);return t&&t[1]||""}(n.url);v&&-1===_e[o(464)][o(569)](v)?r(new ee(o(417)+v+":",ee[o(546)],e)):y.send(i||null)})},Ke=(t,r)=>{const o=e;let n,i=new AbortController;const a=function(e){const t=s;if(!n){n=!0,c();const r=e instanceof Error?e:this.reason;i[t(345)](r instanceof ee?r:new je(r instanceof Error?r[t(372)]:r))}};let p=r&&setTimeout(()=>{a(new ee("timeout "+r+s(461),ee.ETIMEDOUT))},r);const c=()=>{const e=s;t&&(p&&clearTimeout(p),p=null,t[e(519)](t=>{const r=e;t&&(t[r(545)]?t.removeEventListener(r(345),a):t.unsubscribe(a))}),t=null)};t.forEach(e=>e&&e[o(491)]&&e.addEventListener(o(345),a));const{signal:l}=i;return l.unsubscribe=c,[l,()=>{p&&clearTimeout(p),p=null}]},Xe=function*(t,r){const o=e;let n=t[o(284)];if(!r||n<r)return void(yield t);let i,a=0;for(;a<n;)i=a+r,yield t[o(617)](a,i),a=i},$e=(t,r,o,n,i)=>{const a=e,p=async function*(e,t,r){const o=s;for await(const n of e)yield*Xe(ArrayBuffer[o(424)](n)?n:await r(String(n)),t)}(t,r,i);let c,l=0,d=e=>{c||(c=!0,n&&n(e))};return new ReadableStream({async pull(e){const t=s;try{const{done:r,value:n}=await p[t(240)]();if(r)return d(),void e[t(330)]();let i=n[t(284)];if(o){let e=l+=i;o(e)}e[t(257)](new Uint8Array(n))}catch(e){throw d(e),e}},cancel:e=>(d(e),p[a(497)]())},{highWaterMark:2})},Ye="function"==typeof fetch&&e(599)==typeof Request&&e(599)==typeof Response,qe=Ye&&e(599)==typeof ReadableStream,Je=Ye&&(e(599)==typeof TextEncoder?(Ze=new TextEncoder,t=>Ze[e(649)](t)):async e=>new Uint8Array(await new Response(e).arrayBuffer()));var Ze;const Qe=(e,...t)=>{try{return!!e(...t)}catch(e){return!1}},et=qe&&Qe(()=>{const t=e;let r=!1;const o=new Request(_e[t(416)],{body:new ReadableStream,method:t(406),get duplex(){return r=!0,t(308)}})[t(604)].has(t(460));return r&&!o}),tt=qe&&Qe(()=>q[e(590)](new Response("")[e(669)])),rt={stream:tt&&(t=>t[e(669)])};var ot;Ye&&(ot=new Response,[e(412),e(594),e(517),e(502),e(616)][e(519)](t=>{const r=e;!rt[t]&&(rt[t]=q[r(442)](ot[t])?e=>e[t]():(e,o)=>{const n=r;throw new ee(n(381)+t+"' is not supported",ee[n(398)],o)})}));const nt={http:null,xhr:Ve,fetch:Ye&&(async t=>{const r=e;let{url:o,method:n,data:i,signal:a,cancelToken:p,timeout:c,onDownloadProgress:l,onUploadProgress:d,responseType:u,headers:g,withCredentials:f=r(249),fetchOptions:m}=He(t);u=u?(u+"")[r(409)]():"text";let h,y,[b,v]=a||p||c?Ke([a,p],c):[];const _=()=>{!h&&setTimeout(()=>{b&&b[s(651)]()}),h=!0};let O;try{if(d&&et&&"get"!==n&&"head"!==n&&0!==(O=await(async(e,t)=>{const o=r,n=q[o(326)](e[o(667)]());return null==n?(async e=>null==e?0:q[o(660)](e)?e[o(373)]:q.isSpecCompliantForm(e)?(await new Request(e)[o(594)]())[o(284)]:q[o(236)](e)||q.isArrayBuffer(e)?e[o(284)]:(q[o(206)](e)&&(e+=""),q[o(399)](e)?(await Je(e))[o(284)]:void 0))(t):n})(g,i))){let e,t=new Request(o,{method:r(406),body:i,duplex:"half"});if(q[r(290)](i)&&(e=t[r(604)][r(656)](r(288)))&&g.setContentType(e),t[r(669)]){const[e,o]=De(O,Ie(xe(d)));i=$e(t[r(669)],65536,e,o,Je)}}q.isString(f)||(f=r(f?476:429)),y=new Request(o,{...m,signal:b,method:n[r(674)](),headers:g[r(552)]().toJSON(),body:i,duplex:r(308),credentials:f});let e=await fetch(y);const a=tt&&(r(616)===u||r(668)===u);if(tt&&(l||a)){const t={};["status",r(455),r(604)][r(519)](r=>{t[r]=e[r]});const o=q.toFiniteNumber(e.headers.get("content-length")),[n,i]=l&&De(o,Ie(xe(l),!0))||[];e=new Response($e(e[r(669)],65536,n,()=>{i&&i(),a&&_()},Je),t)}u=u||r(412);let s=await rt[q[r(341)](rt,u)||r(412)](e,t);return!a&&_(),v&&v(),await new Promise((o,n)=>{const i=r;Le(o,n,{data:s,headers:Ce.from(e[i(604)]),status:e[i(239)],statusText:e[i(455)],config:t,request:y})})}catch(e){if(_(),e&&r(211)===e[r(628)]&&/fetch/i[r(264)](e.message))throw Object.assign(new ee(r(640),ee[r(506)],t,y),{cause:e[r(300)]||e});throw ee[r(315)](e,e&&e[r(665)],t,y)}})};q[e(519)](nt,(t,r)=>{const o=e;if(t){try{Object[o(654)](t,o(628),{value:r})}catch(e){}Object.defineProperty(t,o(358),{value:r})}});const it=e=>"- "+e,at=t=>q[e(442)](t)||null===t||!1===t,st=t=>{const r=e;t=q[r(303)](t)?t:[t];const{length:o}=t;let n,i;const a={};for(let e=0;e<o;e++){let o;if(n=t[e],i=n,!at(n)&&(i=nt[(o=String(n)).toLowerCase()],void 0===i))throw new ee(r(624)+o+"'");if(i)break;a[o||"#"+e]=i}if(!i){const e=Object[r(515)](a)[r(292)](([e,t])=>r(380)+e+" "+(!1===t?"is not supported by the environment":r(411)));let t=o?e.length>1?r(675)+e.map(it)[r(385)]("\n"):" "+it(e[0]):r(533);throw new ee(r(352)+t,r(398))}return i};function pt(t){const r=e;if(t[r(243)]&&t[r(243)][r(225)](),t[r(529)]&&t[r(529)].aborted)throw new je(null,t)}function ct(t){const r=e;return pt(t),t[r(604)]=Ce[r(315)](t.headers),t[r(566)]=Ae[r(407)](t,t[r(475)]),-1!==["post",r(481),"patch"][r(569)](t[r(482)])&&t[r(604)][r(682)](r(306),!1),st(t.adapter||Se[r(275)])(t)[r(323)](function(e){const o=r;return pt(t),e[o(566)]=Ae[o(407)](t,t[o(591)],e),e[o(604)]=Ce[o(315)](e.headers),e},function(e){const o=r;return Be(e)||(pt(t),e&&e.response&&(e[o(668)][o(566)]=Ae[o(407)](t,t[o(591)],e[o(668)]),e[o(668)][o(604)]=Ce[o(315)](e[o(668)].headers))),Promise[o(207)](e)})}const lt={};[e(645),e(561),e(629),e(599),e(322),e(310)].forEach((e,t)=>{lt[e]=function(r){return typeof r===e||"a"+(t<1?"n ":" ")+e}});const dt={};lt[e(536)]=function(e,t,r){function o(e,t){return s(235)+e+"'"+t+(r?". "+r:"")}return(r,n,i)=>{const a=s;if(!1===e)throw new ee(o(n,a(541)+(t?a(621)+t:"")),ee[a(570)]);return t&&!dt[n]&&(dt[n]=!0,console[a(360)](o(n,a(456)+t+" and will be removed in the near future"))),!e||e(r,n,i)}};const ut={assertOptions:function(t,r,o){const n=e;if(n(645)!=typeof t)throw new ee("options must be an object",ee[n(356)]);const i=Object[n(379)](t);let a=i[n(344)];for(;a-- >0;){const e=i[a],s=r[e];if(s){const r=t[e],o=void 0===r||s(r,e,t);if(!0!==o)throw new ee(n(462)+e+n(281)+o,ee[n(356)])}else if(!0!==o)throw new ee("Unknown option "+e,ee[n(337)])}},validators:lt},gt=ut[e(430)];class ft{constructor(t){const r=e;this[r(420)]=t,this[r(613)]={request:new ue,response:new ue}}async[e(633)](t,r){const o=e;try{return await this[o(311)](t,r)}catch(e){if(e instanceof Error){let t;Error[o(309)]?Error[o(309)](t={}):t=new Error;const r=t.stack?t[o(208)][o(289)](/^.+\n/,""):"";try{e[o(208)]?r&&!String(e[o(208)])[o(496)](r.replace(/^.+\n.+\n/,""))&&(e.stack+="\n"+r):e[o(208)]=r}catch(e){}}throw e}}_request(t,r){const o=e;"string"==typeof t?(r=r||{}).url=t:r=t||{},r=Ue(this[o(420)],r);const{transitional:n,paramsSerializer:i,headers:a}=r;void 0!==n&&ut[o(472)](n,{silentJSONParsing:gt.transitional(gt[o(561)]),forcedJSONParsing:gt[o(536)](gt[o(561)]),clarifyTimeoutError:gt.transitional(gt.boolean)},!1),null!=i&&(q.isFunction(i)?r[o(447)]={serialize:i}:ut[o(472)](i,{encode:gt[o(599)],serialize:gt.function},!0)),r.method=(r[o(482)]||this[o(420)][o(482)]||o(656)).toLowerCase();let s=a&&q[o(445)](a[o(431)],a[r[o(482)]]);a&&q[o(519)]([o(637),"get",o(484),o(630),"put",o(579),o(431)],e=>{delete a[e]}),r[o(604)]=Ce[o(485)](s,a);const p=[];let c=!0;this[o(613)][o(633)][o(519)](function(e){const t=o;"function"==typeof e.runWhen&&!1===e[t(338)](r)||(c=c&&e.synchronous,p.unshift(e.fulfilled,e.rejected))});const l=[];let d;this[o(613)][o(668)][o(519)](function(e){const t=o;l.push(e[t(342)],e[t(215)])});let u,g=0;if(!c){const e=[ct[o(524)](this),void 0];for(e[o(346)][o(553)](e,p),e.push.apply(e,l),u=e[o(344)],d=Promise[o(270)](r);g<u;)d=d[o(323)](e[g++],e[g++]);return d}u=p.length;let f=r;for(g=0;g<u;){const e=p[g++],t=p[g++];try{f=e(f)}catch(e){t[o(407)](this,e);break}}try{d=ct.call(this,f)}catch(e){return Promise.reject(e)}for(g=0,u=l[o(344)];g<u;)d=d[o(323)](l[g++],l[g++]);return d}[e(537)](t){const r=e;return de(ze((t=Ue(this[r(420)],t))[r(227)],t[r(258)]),t[r(254)],t[r(447)])}}q[e(519)]([e(637),"get",e(484),"options"],function(t){const r=e;ft[r(248)][t]=function(e,o){const n=r;return this[n(633)](Ue(o||{},{method:t,url:e,data:(o||{})[n(566)]}))}}),q[e(519)]([e(630),e(481),"patch"],function(t){const r=e;function o(e){return function(r,o,n){const i=s;return this.request(Ue(n||{},{method:t,headers:e?{"Content-Type":i(423)}:{},url:r,data:o}))}}ft[r(248)][t]=o(),ft[r(248)][t+r(585)]=o(!0)});const mt=ft;class ht{constructor(t){const r=e;if("function"!=typeof t)throw new TypeError(r(283));let o;this[r(547)]=new Promise(function(e){o=e});const n=this;this[r(547)][r(323)](e=>{const t=r;if(!n._listeners)return;let o=n._listeners[t(344)];for(;o-- >0;)n[t(494)][o](e);n[t(494)]=null}),this[r(547)][r(323)]=e=>{let t;const r=new Promise(e=>{n.subscribe(e),t=e}).then(e);return r.cancel=function(){n.unsubscribe(t)},r},t(function(e,t,i){const a=r;n[a(361)]||(n[a(361)]=new je(e,t,i),o(n[a(361)]))})}throwIfRequested(){const t=e;if(this[t(361)])throw this[t(361)]}[e(606)](t){const r=e;this[r(361)]?t(this[r(361)]):this._listeners?this._listeners[r(377)](t):this._listeners=[t]}[e(651)](t){const r=e;if(!this._listeners)return;const o=this[r(494)].indexOf(t);-1!==o&&this[r(494)].splice(o,1)}static source(){let e;return{token:new ht(function(t){e=t}),cancel:e}}}const yt=ht,bt={Continue:100,SwitchingProtocols:101,Processing:102,EarlyHints:103,Ok:200,Created:201,Accepted:202,NonAuthoritativeInformation:203,NoContent:204,ResetContent:205,PartialContent:206,MultiStatus:207,AlreadyReported:208,ImUsed:226,MultipleChoices:300,MovedPermanently:301,Found:302,SeeOther:303,NotModified:304,UseProxy:305,Unused:306,TemporaryRedirect:307,PermanentRedirect:308,BadRequest:400,Unauthorized:401,PaymentRequired:402,Forbidden:403,NotFound:404,MethodNotAllowed:405,NotAcceptable:406,ProxyAuthenticationRequired:407,RequestTimeout:408,Conflict:409,Gone:410,LengthRequired:411,PreconditionFailed:412,PayloadTooLarge:413,UriTooLong:414,UnsupportedMediaType:415,RangeNotSatisfiable:416,ExpectationFailed:417,ImATeapot:418,MisdirectedRequest:421,UnprocessableEntity:422,Locked:423,FailedDependency:424,TooEarly:425,UpgradeRequired:426,PreconditionRequired:428,TooManyRequests:429,RequestHeaderFieldsTooLarge:431,UnavailableForLegalReasons:451,InternalServerError:500,NotImplemented:501,BadGateway:502,ServiceUnavailable:503,GatewayTimeout:504,HttpVersionNotSupported:505,VariantAlsoNegotiates:506,InsufficientStorage:507,LoopDetected:508,NotExtended:510,NetworkAuthenticationRequired:511};Object[e(515)](bt).forEach(([e,t])=>{bt[t]=e});const vt=bt,_t=function t(r){const o=e,n=new mt(r),a=i(mt[o(248)][o(633)],n);return q[o(401)](a,mt.prototype,n,{allOwnKeys:!0}),q[o(401)](a,n,null,{allOwnKeys:!0}),a.create=function(e){return t(Ue(r,e))},a}(Se);_t[e(666)]=mt,_t[e(297)]=je,_t[e(601)]=yt,_t[e(564)]=Be,_t[e(511)]=e(328),_t[e(563)]=ie,_t.AxiosError=ee,_t.Cancel=_t[e(297)],_t.all=function(e){return Promise.all(e)},_t[e(336)]=function(e){return function(t){return e[s(553)](null,t)}},_t[e(580)]=function(e){return q.isObject(e)&&!0===e.isAxiosError},_t[e(454)]=Ue,_t[e(256)]=Ce,_t[e(474)]=e=>Oe(q.isHTMLForm(e)?new FormData(e):e),_t[e(644)]=st,_t[e(539)]=vt,_t[e(449)]=_t;const Ot=_t;function wt(t){const r=e;return(wt=r(599)==typeof Symbol&&r(310)==typeof Symbol[r(278)]?function(e){return typeof e}:function(e){const t=r;return e&&"function"==typeof Symbol&&e[t(612)]===Symbol&&e!==Symbol[t(248)]?t(310):typeof e})(t)}function St(){const t=e;St=function(){return o};var r,o={},n=Object.prototype,i=n[t(383)],a=Object.defineProperty||function(e,t,r){e[t]=r.value},p="function"==typeof Symbol?Symbol:{},c=p[t(278)]||"@@iterator",l=p[t(473)]||t(389),d=p[t(355)]||t(586);function u(e,r,o){return Object[t(654)](e,r,{value:o,enumerable:!0,configurable:!0,writable:!0}),e[r]}try{u({},"")}catch(e){u=function(e,t,r){return e[t]=r}}function g(e,o,n,i){const p=t;var c,l,d,u,g=o&&o[p(248)]instanceof _?o:_,O=Object.create(g.prototype),w=new B(i||[]);return a(O,p(593),{value:(c=e,l=n,d=w,u=m,function(e,t){const o=s;if(u===y)throw Error(o(440));if(u===b){if(o(241)===e)throw t;return{value:r,done:!0}}for(d[o(482)]=e,d[o(555)]=t;;){var n=d[o(312)];if(n){var i=T(n,d);if(i){if(i===v)continue;return i}}if("next"===d[o(482)])d.sent=d[o(479)]=d[o(555)];else if("throw"===d.method){if(u===m)throw u=b,d.arg;d[o(619)](d[o(555)])}else"return"===d[o(482)]&&d[o(556)]("return",d[o(555)]);u=y;var a=f(c,l,d);if(o(261)===a[o(573)]){if(u=d.done?b:h,a[o(555)]===v)continue;return{value:a[o(555)],done:d[o(463)]}}o(241)===a[o(573)]&&(u=b,d[o(482)]="throw",d[o(555)]=a[o(555)])}})}),O}function f(e,r,o){const n=t;try{return{type:n(261),arg:e[n(407)](r,o)}}catch(e){return{type:n(241),arg:e}}}o.wrap=g;var m=t(291),h=t(662),y="executing",b=t(293),v={};function _(){}function O(){}function w(){}var S={};u(S,c,function(){return this});var E=Object[t(618)],k=E&&E(E(P([])));k&&k!==n&&i[t(407)](k,c)&&(S=k);var F=w[t(248)]=_.prototype=Object[t(565)](S);function M(e){const r=t;[r(240),r(241),r(497)][r(519)](function(t){u(e,t,function(e){return this._invoke(t,e)})})}function R(e,r){const o=t;function n(t,o,a,p){const c=s;var l=f(e[t],e,o);if(c(241)!==l[c(573)]){var d=l[c(555)],u=d[c(441)];return u&&"object"==wt(u)&&i.call(u,"__await")?r[c(270)](u[c(467)])[c(323)](function(e){n("next",e,a,p)},function(e){n("throw",e,a,p)}):r[c(270)](u)[c(323)](function(e){d[c(441)]=e,a(d)},function(e){return n(c(241),e,a,p)})}p(l[c(555)])}var p;a(this,o(593),{value:function(e,t){function i(){return new r(function(r,o){n(e,t,r,o)})}return p=p?p[o(323)](i,i):i()}})}function T(e,o){const n=t;var i=o[n(482)],a=e[n(278)][i];if(a===r)return o[n(312)]=null,n(241)===i&&e.iterator.return&&(o[n(482)]=n(497),o[n(555)]=r,T(e,o),"throw"===o[n(482)])||n(497)!==i&&(o[n(482)]=n(241),o.arg=new TypeError("The iterator does not provide a '"+i+n(228))),v;var s=f(a,e.iterator,o[n(555)]);if(n(241)===s[n(573)])return o[n(482)]=n(241),o[n(555)]=s[n(555)],o[n(312)]=null,v;var p=s[n(555)];return p?p[n(463)]?(o[e[n(229)]]=p[n(441)],o.next=e[n(578)],"return"!==o[n(482)]&&(o[n(482)]=n(240),o[n(555)]=r),o.delegate=null,v):p:(o.method=n(241),o[n(555)]=new TypeError(n(661)),o[n(312)]=null,v)}function C(e){const r=t;var o={tryLoc:e[0]};1 in e&&(o[r(457)]=e[1]),2 in e&&(o[r(631)]=e[2],o[r(490)]=e[3]),this.tryEntries[r(377)](o)}function A(e){const r=t;var o=e[r(622)]||{};o[r(573)]=r(261),delete o[r(555)],e[r(622)]=o}function B(e){const r=t;this[r(214)]=[{tryLoc:r(384)}],e[r(519)](C,this),this[r(359)](!0)}function P(e){const o=t;if(e||""===e){var n=e[c];if(n)return n[o(407)](e);if(o(599)==typeof e[o(240)])return e;if(!isNaN(e[o(344)])){var a=-1,s=function t(){const n=o;for(;++a<e.length;)if(i.call(e,a))return t[n(441)]=e[a],t[n(463)]=!1,t;return t[n(441)]=r,t[n(463)]=!0,t};return s.next=s}}throw new TypeError(wt(e)+o(609))}return O[t(248)]=w,a(F,t(612),{value:w,configurable:!0}),a(w,t(612),{value:O,configurable:!0}),O[t(468)]=u(w,d,"GeneratorFunction"),o[t(623)]=function(e){const r=t;var o=r(599)==typeof e&&e.constructor;return!!o&&(o===O||r(532)===(o[r(468)]||o[r(628)]))},o[t(488)]=function(e){const r=t;return Object[r(259)]?Object[r(259)](e,w):(e[r(508)]=w,u(e,d,r(532))),e[r(248)]=Object[r(565)](F),e},o[t(382)]=function(e){return{__await:e}},M(R[t(248)]),u(R[t(248)],l,function(){return this}),o[t(217)]=R,o[t(347)]=function(e,r,n,i,a){const s=t;void 0===a&&(a=Promise);var p=new R(g(e,r,n,i),a);return o[s(623)](r)?p:p.next()[s(323)](function(e){const t=s;return e[t(463)]?e[t(441)]:p.next()})},M(F),u(F,d,t(450)),u(F,c,function(){return this}),u(F,t(335),function(){return t(253)}),o[t(379)]=function(e){const r=t;var o=Object(e),n=[];for(var i in o)n[r(377)](i);return n[r(332)](),function e(){const t=r;for(;n.length;){var i=n[t(237)]();if(i in o)return e[t(441)]=i,e[t(463)]=!1,e}return e[t(463)]=!0,e}},o[t(526)]=P,B[t(248)]={constructor:B,reset:function(e){const o=t;if(this.prev=0,this[o(240)]=0,this.sent=this[o(479)]=r,this[o(463)]=!1,this[o(312)]=null,this[o(482)]=o(240),this[o(555)]=r,this[o(214)][o(519)](A),!e)for(var n in this)"t"===n[o(483)](0)&&i[o(407)](this,n)&&!isNaN(+n.slice(1))&&(this[n]=r)},stop:function(){const e=t;this[e(463)]=!0;var r=this.tryEntries[0].completion;if(e(241)===r[e(573)])throw r[e(555)];return this[e(581)]},dispatchException:function(e){const o=t;if(this.done)throw e;var n=this;function a(t,o){const i=s;return l[i(573)]=i(241),l.arg=e,n[i(240)]=t,o&&(n[i(482)]=i(240),n[i(555)]=r),!!o}for(var p=this[o(214)].length-1;p>=0;--p){var c=this[o(214)][p],l=c[o(622)];if(o(384)===c[o(597)])return a(o(451));if(c[o(597)]<=this[o(523)]){var d=i[o(407)](c,o(457)),u=i.call(c,o(631));if(d&&u){if(this.prev<c[o(457)])return a(c[o(457)],!0);if(this[o(523)]<c[o(631)])return a(c.finallyLoc)}else if(d){if(this[o(523)]<c[o(457)])return a(c.catchLoc,!0)}else{if(!u)throw Error(o(263));if(this.prev<c[o(631)])return a(c[o(631)])}}}},abrupt:function(e,r){const o=t;for(var n=this[o(214)].length-1;n>=0;--n){var a=this[o(214)][n];if(a.tryLoc<=this.prev&&i[o(407)](a,"finallyLoc")&&this.prev<a[o(631)]){var s=a;break}}s&&("break"===e||o(583)===e)&&s[o(597)]<=r&&r<=s[o(631)]&&(s=null);var p=s?s.completion:{};return p[o(573)]=e,p[o(555)]=r,s?(this[o(482)]="next",this[o(240)]=s[o(631)],v):this[o(648)](p)},complete:function(e,r){const o=t;if(o(241)===e[o(573)])throw e.arg;return o(298)===e[o(573)]||"continue"===e[o(573)]?this.next=e.arg:o(497)===e.type?(this[o(581)]=this[o(555)]=e[o(555)],this[o(482)]="return",this.next=o(451)):o(261)===e[o(573)]&&r&&(this[o(240)]=r),v},finish:function(e){const r=t;for(var o=this.tryEntries[r(344)]-1;o>=0;--o){var n=this[r(214)][o];if(n.finallyLoc===e)return this[r(648)](n[r(622)],n[r(490)]),A(n),v}},catch:function(e){const r=t;for(var o=this[r(214)][r(344)]-1;o>=0;--o){var n=this[r(214)][o];if(n[r(597)]===e){var i=n[r(622)];if("throw"===i.type){var a=i.arg;A(n)}return a}}throw Error(r(478))},delegateYield:function(e,o,n){const i=t;return this.delegate={iterator:P(e),resultName:o,nextLoc:n},i(240)===this[i(482)]&&(this[i(555)]=r),v}},o}function Et(t,r,o,n,i,a,s){const p=e;try{var c=t[a](s),l=c.value}catch(e){return void o(e)}c[p(463)]?r(l):Promise.resolve(l)[p(323)](n,i)}function kt(e){return function(){var t=this,r=arguments;return new Promise(function(o,n){const i=s;var a=e[i(553)](t,r);function p(e){Et(a,o,n,p,c,i(240),e)}function c(e){Et(a,o,n,p,c,"throw",e)}p(void 0)})}}function Ft(t,r){const o=e;var n=Object[o(379)](t);if(Object[o(279)]){var i=Object[o(279)](t);r&&(i=i[o(276)](function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),n[o(377)].apply(n,i)}return n}function Mt(t){const r=e;for(var o=1;o<arguments[r(344)];o++){var n=null!=arguments[o]?arguments[o]:{};o%2?Ft(Object(n),!0)[r(519)](function(e){Rt(t,e,n[e])}):Object[r(252)]?Object[r(250)](t,Object.getOwnPropertyDescriptors(n)):Ft(Object(n)).forEach(function(e){const o=r;Object[o(654)](t,e,Object[o(679)](n,e))})}return t}function Rt(t,r,o){const n=e;return(r=Tt(r))in t?Object[n(654)](t,r,{value:o,enumerable:!0,configurable:!0,writable:!0}):t[r]=o,t}function Tt(t){const r=e;var o=function(e){const t=s;if("object"!=wt(e)||!e)return e;var r=e[Symbol[t(333)]];if(void 0!==r){var o=r.call(e,t(322));if(t(645)!=wt(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(t);return r(310)==wt(o)?o:o+""}var Ct=function(){const t=e;return r=function e(t){const r=s;!function(e,t){if(!(e instanceof t))throw new TypeError(s(625))}(this,e),Rt(this,r(354),void 0),Rt(this,r(598),void 0),Rt(this,"HEADER_VARIANTS",void 0),Rt(this,r(320),void 0),Rt(this,r(469),void 0),this.baseUrl=t.baseUrl,this.SECRET_HEADERS={Integration:t[r(664)],"aggregate-entity-id":t[r(267)],"Content-Type":r(540),"Content-Encoding":r(518)},this[r(469)]={"Content-Type":"application/json","aggregate-entity-id":t[r(267)],token:t[r(272)]},this.HEADER_VARIANTS={BAF:this.SECRET_HEADERS,VIDEO_RECORDER:this[r(469)]},this[r(320)]={PLATFORM:t[r(302)],BAF:t[r(664)],VIDEO_RECORDER:t[r(272)]}},o=[{key:t(630),value:function(e,r,o,n){const i=t;return Ot[i(630)](e,r instanceof FormData?r:JSON[i(219)](r),Mt(Mt({},n),{},{headers:Mt(Mt({},this[i(369)][o]),null==n?void 0:n[i(604)])}))}},{key:t(656),value:function(e,r,o){const n=t;return Ot[n(656)](e,Mt({headers:this[n(369)][r]},o))}},{key:t(268),value:function(e){const r=t;if(void 0===this[r(320)][e])throw new Error("Config error! You are trying to use the ".concat(e,r(210)).concat(e,r(418)))}},{key:"getServerConfig",value:(l=kt(St().mark(function e(){const r=t;return St()[r(287)](function(e){const t=r;for(;;)switch(e[t(523)]=e.next){case 0:return e[t(556)](t(497),new Promise(function(e){e({maxHeight:2e3,maxWidth:2e3,maxSize:8388608,minWidth:400,minHeight:600,minFacePercentage:30})}));case 1:case t(451):return e.stop()}},e)})),function(){return l[t(553)](this,arguments)})},{key:t(304),value:(c=kt(St()[t(488)](function e(r){const o=t;return St()[o(287)](function(e){const t=o;for(;;)switch(e[t(523)]=e.next){case 0:return this[t(268)](t(378)),e[t(556)](t(497),this[t(656)](""[t(485)](this[t(354)],t(544))[t(485)](r),"BAF"));case 2:case t(451):return e[t(262)]()}},e,this)})),function(e){return c[t(553)](this,arguments)})},{key:"getApplicantByID",value:(p=kt(St()[t(488)](function e(t){return St().wrap(function(e){const r=s;for(;;)switch(e.prev=e[r(240)]){case 0:return this[r(268)](r(378)),e.abrupt(r(497),this[r(656)](""[r(485)](this[r(354)],r(334))[r(485)](t),r(378)));case 2:case"end":return e[r(262)]()}},e,this)})),function(e){return p[t(553)](this,arguments)})},{key:t(387),value:(a=kt(St().mark(function e(r){const o=t;var n;return St()[o(287)](function(e){const t=o;for(;;)switch(e[t(523)]=e[t(240)]){case 0:return this.checkTokens(t(378)),n={sendSms:!1,status:0,documentType:10},r[t(519)](function(e){var t=e[0],r=e[1];n[t]=r}),e.abrupt(t(497),this.post(""[t(485)](this[t(354)],"/publicapi/api/v2/component/Applicants"),n,"BAF"));case 4:case t(451):return e.stop()}},e,this)})),function(e){return a.apply(this,arguments)})},{key:t(626),value:(i=kt(St()[t(488)](function e(r,o,n){const i=t;var a;return St()[i(287)](function(e){const t=i;for(;;)switch(e[t(523)]=e[t(240)]){case 0:return this[t(268)]("BAF"),a={endeavorId:o,documentType:10,fingerprint:n},e[t(556)](t(497),this[t(630)](""[t(485)](this[t(354)],t(334))[t(485)](r,"/Attempt"),a,"BAF"));case 3:case t(451):return e[t(262)]()}},e,this)})),function(e,t,r){return i.apply(this,arguments)})},{key:"validateApplicant",value:(n=kt(St()[t(488)](function e(r,o,n){const i=t;var a;return St()[i(287)](function(e){const t=i;for(;;)switch(e.prev=e[t(240)]){case 0:return this[t(268)](t(378)),a={customSettings:n,applicantId:r,attemptId:o},e[t(556)](t(497),this[t(630)](""[t(485)](this[t(354)],t(212)),a,t(378)));case 3:case"end":return e[t(262)]()}},e,this)})),function(e,r,o){return n[t(553)](this,arguments)})},{key:t(246),value:function(e,r,o){const n=t;var i;return this[n(268)](n(522)),this[n(630)]("".concat(this[n(354)],n(427)),{sdp:null!==(i=null==e?void 0:e[n(391)])&&void 0!==i?i:"",type:null==e?void 0:e[n(573)],endeavor_id:null!=r?r:"",aggregate_entity_id:this[n(469)]["aggregate-entity-id"]},"VIDEO_RECORDER",{signal:o})}},{key:t(480),value:function(e){const r=t;return this.checkTokens(r(522)),this[r(630)](""[r(485)](this[r(354)],r(650)),{external_link:e},r(522))}},{key:t(495),value:function(){const e=t;return this[e(268)]("VIDEO_RECORDER"),this[e(656)](""[e(485)](this[e(354)],e(299)),e(522))}},{key:t(392),value:function(){const e=t;return this.checkTokens("VIDEO_RECORDER"),this.get("".concat(this[e(354)],e(415)),e(522))}},{key:"saveLivenessReflectionResult",value:function(e,r,o){const n=t;this[n(268)]("VIDEO_RECORDER");var i=new FormData;return i[n(357)](n(587),new File([o],n(582),{type:n(595)})),i[n(357)]("video",new File([r],n(499),{type:n(635)})),this[n(630)](""[n(485)](this[n(354)],n(489))[n(485)](e),i,n(522),{headers:{"Content-Type":"multipart/form-data"}})}},{key:"saveLivenessActiveResult",value:function(e,r,o,n){const i=t;this[i(268)]("VIDEO_RECORDER");var a=new FormData;return a[i(357)](i(587),new File([o],i(538),{type:i(595)})),a.append("video",new File([r],"liveness_active_video.mp4",{type:i(635)})),a[i(357)](i(422),n),this[i(630)](""[i(485)](this[i(354)],i(610))[i(485)](e),a,"VIDEO_RECORDER",{headers:{"Content-Type":i(423)}})}}],o&&function(t,r){const o=e;for(var n=0;n<r[o(344)];n++){var i=r[n];i[o(620)]=i[o(620)]||!1,i[o(671)]=!0,o(441)in i&&(i[o(265)]=!0),Object[o(654)](t,Tt(i[o(559)]),i)}}(r[t(248)],o),Object[t(654)](r,"prototype",{writable:!1}),r;var r,o,n,i,a,p,c,l}();document[e(669)];const At=Ct;return o[e(449)]})())},567:function(e,t){"use strict";var r=this&&this.__awaiter||function(e,t,r,o){return new(r||(r=Promise))(function(n,i){function a(e){try{p(o.next(e))}catch(e){i(e)}}function s(e){try{p(o.throw(e))}catch(e){i(e)}}function p(e){var t;e.done?n(e.value):(t=e.value,t instanceof r?t:new r(function(e){e(t)})).then(a,s)}p((o=o.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.aesCbcDecrypt=t.aesCbcEncrypt=t.verifyHMAC=t.generateHMAC=t.importKey=t.getRandomBytes=t.toBase64Url=t.fromBase64Url=void 0,t.fromBase64Url=function(e){return Uint8Array.from(window.atob(e.replace(/_/g,"/").replace(/-/g,"+")),e=>e.charCodeAt(0))},t.toBase64Url=function(e){let t=[];return e.forEach(e=>{t.push(String.fromCharCode(e))}),window.btoa(t.join("")).replace(/\+/g,"-").replace(/\//g,"_")},t.getRandomBytes=function(e){const t=new Uint8Array(e);return window.crypto.getRandomValues(t),t},t.importKey=function(e,t,o){return r(this,void 0,void 0,function*(){return crypto.subtle.importKey("raw",e,t,!1,o)})},t.generateHMAC=function(e,t){return r(this,void 0,void 0,function*(){const r=yield window.crypto.subtle.sign("HMAC",t,e);return new Uint8Array(r)})},t.verifyHMAC=function(e,t,o){return r(this,void 0,void 0,function*(){return yield window.crypto.subtle.verify("HMAC",t,o,e)})},t.aesCbcEncrypt=function(e,t,o){return r(this,void 0,void 0,function*(){const r=(new TextEncoder).encode(e),n=yield crypto.subtle.encrypt({name:"AES-CBC",iv:t},o,r);return new Uint8Array(n)})},t.aesCbcDecrypt=function(e,t,o){return r(this,void 0,void 0,function*(){const r=yield crypto.subtle.decrypt({name:"AES-CBC",iv:t},o,e);return(new TextDecoder).decode(r)})}},668:e=>{"use strict";function t(e){this._maxSize=e,this.clear()}t.prototype.clear=function(){this._size=0,this._values=Object.create(null)},t.prototype.get=function(e){return this._values[e]},t.prototype.set=function(e,t){return this._size>=this._maxSize&&this.clear(),e in this._values||this._size++,this._values[e]=t};var r=/[^.^\]^[]+|(?=\[\]|\.\.)/g,o=/^\d+$/,n=/^\d/,i=/[~`!#$%\^&*+=\-\[\]\\';,/{}|\\":<>\?]/g,a=/^\s*(['"]?)(.*?)(\1)\s*$/,s=new t(512),p=new t(512),c=new t(512);function l(e){return s.get(e)||s.set(e,d(e).map(function(e){return e.replace(a,"$2")}))}function d(e){return e.match(r)||[""]}function u(e){return"string"==typeof e&&e&&-1!==["'",'"'].indexOf(e.charAt(0))}function g(e){return!u(e)&&(function(e){return e.match(n)&&!e.match(o)}(e)||function(e){return i.test(e)}(e))}e.exports={Cache:t,split:d,normalizePath:l,setter:function(e){var t=l(e);return p.get(e)||p.set(e,function(e,r){for(var o=0,n=t.length,i=e;o<n-1;){var a=t[o];if("__proto__"===a||"constructor"===a||"prototype"===a)return e;i=i[t[o++]]}i[t[o]]=r})},getter:function(e,t){var r=l(e);return c.get(e)||c.set(e,function(e){for(var o=0,n=r.length;o<n;){if(null==e&&t)return;e=e[r[o++]]}return e})},join:function(e){return e.reduce(function(e,t){return e+(u(t)||o.test(t)?"["+t+"]":(e?".":"")+t)},"")},forEach:function(e,t,r){!function(e,t,r){var o,n,i,a,s=e.length;for(n=0;n<s;n++)(o=e[n])&&(g(o)&&(o='"'+o+'"'),i=!(a=u(o))&&/^\d+$/.test(o),t.call(r,o,a,i,n,e))}(Array.isArray(e)?e:d(e),t,r)}}},714:e=>{const t=/[A-Z\xc0-\xd6\xd8-\xde]?[a-z\xdf-\xf6\xf8-\xff]+(?:['’](?:d|ll|m|re|s|t|ve))?(?=[\xac\xb1\xd7\xf7\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xbf\u2000-\u206f \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]|[A-Z\xc0-\xd6\xd8-\xde]|$)|(?:[A-Z\xc0-\xd6\xd8-\xde]|[^\ud800-\udfff\xac\xb1\xd7\xf7\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xbf\u2000-\u206f \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\d+\u2700-\u27bfa-z\xdf-\xf6\xf8-\xffA-Z\xc0-\xd6\xd8-\xde])+(?:['’](?:D|LL|M|RE|S|T|VE))?(?=[\xac\xb1\xd7\xf7\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xbf\u2000-\u206f \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]|[A-Z\xc0-\xd6\xd8-\xde](?:[a-z\xdf-\xf6\xf8-\xff]|[^\ud800-\udfff\xac\xb1\xd7\xf7\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xbf\u2000-\u206f \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\d+\u2700-\u27bfa-z\xdf-\xf6\xf8-\xffA-Z\xc0-\xd6\xd8-\xde])|$)|[A-Z\xc0-\xd6\xd8-\xde]?(?:[a-z\xdf-\xf6\xf8-\xff]|[^\ud800-\udfff\xac\xb1\xd7\xf7\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xbf\u2000-\u206f \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\d+\u2700-\u27bfa-z\xdf-\xf6\xf8-\xffA-Z\xc0-\xd6\xd8-\xde])+(?:['’](?:d|ll|m|re|s|t|ve))?|[A-Z\xc0-\xd6\xd8-\xde]+(?:['’](?:D|LL|M|RE|S|T|VE))?|\d*(?:1ST|2ND|3RD|(?![123])\dTH)(?=\b|[a-z_])|\d*(?:1st|2nd|3rd|(?![123])\dth)(?=\b|[A-Z_])|\d+|(?:[\u2700-\u27bf]|(?:\ud83c[\udde6-\uddff]){2}|[\ud800-\udbff][\udc00-\udfff])[\ufe0e\ufe0f]?(?:[\u0300-\u036f\ufe20-\ufe2f\u20d0-\u20ff]|\ud83c[\udffb-\udfff])?(?:\u200d(?:[^\ud800-\udfff]|(?:\ud83c[\udde6-\uddff]){2}|[\ud800-\udbff][\udc00-\udfff])[\ufe0e\ufe0f]?(?:[\u0300-\u036f\ufe20-\ufe2f\u20d0-\u20ff]|\ud83c[\udffb-\udfff])?)*/g,r=e=>e.match(t)||[],o=e=>e[0].toUpperCase()+e.slice(1),n=(e,t)=>r(e).join(t).toLowerCase(),i=e=>r(e).reduce((e,t)=>`${e}${e?t[0].toUpperCase()+t.slice(1).toLowerCase():t.toLowerCase()}`,"");e.exports={words:r,upperFirst:o,camelCase:i,pascalCase:e=>o(i(e)),snakeCase:e=>n(e,"_"),kebabCase:e=>n(e,"-"),sentenceCase:e=>o(n(e," ")),titleCase:e=>r(e).map(o).join(" ")}},733:(e,t)=>{"use strict";var r;Object.defineProperty(t,"__esModule",{value:!0}),t.Algorithms=void 0,(r=t.Algorithms||(t.Algorithms={})).AES_CBC="AES-CBC",r.HMAC="HMAC"},894:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.InvalidTokenError=void 0;class r extends Error{constructor(e){super(e)}}t.InvalidTokenError=r},918:(e,t)=>{"use strict";var r;Object.defineProperty(t,"__esModule",{value:!0}),t.HashAlgorithm=void 0,(r=t.HashAlgorithm||(t.HashAlgorithm={})).SHA1="SHA-1",r.SHA256="SHA-256",r.SHA384="SHA-384",r.SHA512="SHA-512"},929:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.InvalidSecretError=void 0;class r extends Error{constructor(e){super(e)}}t.InvalidSecretError=r},981:e=>{function t(e,t){var r=e.length,o=new Array(r),n={},i=r,a=function(e){for(var t=new Map,r=0,o=e.length;r<o;r++){var n=e[r];t.has(n[0])||t.set(n[0],new Set),t.has(n[1])||t.set(n[1],new Set),t.get(n[0]).add(n[1])}return t}(t),s=function(e){for(var t=new Map,r=0,o=e.length;r<o;r++)t.set(e[r],r);return t}(e);for(t.forEach(function(e){if(!s.has(e[0])||!s.has(e[1]))throw new Error("Unknown node. There is an unknown node in the supplied edges.")});i--;)n[i]||p(e[i],i,new Set);return o;function p(e,t,i){if(i.has(e)){var c;try{c=", node was:"+JSON.stringify(e)}catch(e){c=""}throw new Error("Cyclic dependency"+c)}if(!s.has(e))throw new Error("Found unknown node. Make sure to provided all involved nodes. Unknown node: "+JSON.stringify(e));if(!n[t]){n[t]=!0;var l=a.get(e)||new Set;if(t=(l=Array.from(l)).length){i.add(e);do{var d=l[--t];p(d,s.get(d),i)}while(t);i.delete(e)}o[--r]=e}}}e.exports=function(e){return t(function(e){for(var t=new Set,r=0,o=e.length;r<o;r++){var n=e[r];t.add(n[0]),t.add(n[1])}return Array.from(t)}(e),e)},e.exports.array=t}},__webpack_module_cache__={};function __webpack_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var r=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.loaded=!0,r.exports}__webpack_require__.m=__webpack_modules__,__webpack_require__.amdO={},__webpack_require__.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=(e,t)=>{for(var r in t)__webpack_require__.o(t,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.b="undefined"!=typeof document&&document.baseURI||self.location.href;var __webpack_exports__={};return(()=>{"use strict";__webpack_require__.d(__webpack_exports__,{default:()=>iO});var e={};__webpack_require__.r(e),__webpack_require__.d(e,{hasBrowserEnv:()=>Ct,hasStandardBrowserEnv:()=>Bt,hasStandardBrowserWebWorkerEnv:()=>Pt,navigator:()=>At,origin:()=>jt});var t=__webpack_require__(260);function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function o(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,c(o.key),o)}}function n(e){var t="function"==typeof Map?new Map:void 0;return n=function(e){if(null===e||!function(e){try{return-1!==Function.toString.call(e).indexOf("[native code]")}catch(t){return"function"==typeof e}}(e))return e;if("function"!=typeof e)throw new TypeError("Super expression must either be null or a function");if(void 0!==t){if(t.has(e))return t.get(e);t.set(e,r)}function r(){return function(e,t,r){if(i())return Reflect.construct.apply(null,arguments);var o=[null];o.push.apply(o,t);var n=new(e.bind.apply(e,o));return r&&a(n,r.prototype),n}(e,arguments,s(this).constructor)}return r.prototype=Object.create(e.prototype,{constructor:{value:r,enumerable:!1,writable:!0,configurable:!0}}),a(r,e)},n(e)}function i(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}))}catch(e){}return(i=function(){return!!e})()}function a(e,t){return a=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},a(e,t)}function s(e){return s=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},s(e)}function p(e,t,r){return(t=c(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function c(e){var t=function(e){if("object"!=r(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var o=t.call(e,"string");if("object"!=r(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==r(t)?t:t+""}var l=function(e){function t(){var e,o=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=o.message,a=o.code;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),p(e=function(e,t,o){return t=s(t),function(e,t){if(t&&("object"==r(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(e,i()?Reflect.construct(t,o||[],s(e).constructor):t.apply(e,o))}(this,t,[n]),"code","120014"),a&&(e.code=a),Error.captureStackTrace&&Error.captureStackTrace(e,e.constructor),e}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&a(e,t)}(t,e),n=t,l=[{key:"typeof",value:function(e,t){return e instanceof Error&&e.name===t}}],(c=[{key:"name",get:function(){return this.constructor.ERROR_NAME}},{key:"dispatch",value:function(){var e=new CustomEvent("tdvc-web-component-error-event",{detail:this});window.dispatchEvent(e)}}])&&o(n.prototype,c),l&&o(n,l),Object.defineProperty(n,"prototype",{writable:!1}),n;var n,c,l}(n(Error));function d(e){return d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},d(e)}function u(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,O(o.key),o)}}function g(e,t,r){return t&&u(e.prototype,t),r&&u(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e}function f(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function m(e,t,r){return t=y(t),function(e,t){if(t&&("object"==d(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(e,h()?Reflect.construct(t,r||[],y(e).constructor):t.apply(e,r))}function h(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}))}catch(e){}return(h=function(){return!!e})()}function y(e){return y=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},y(e)}function b(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&v(e,t)}function v(e,t){return v=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},v(e,t)}function _(e,t,r){return(t=O(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function O(e){var t=function(e){if("object"!=d(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=d(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==d(t)?t:t+""}p(l,"ERROR_NAME","WebComponentError");var w=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"The waiting time for a response from the server has been exceeded"}]),"code","1400023"),r}return b(t,e),g(t)}(l);_(w,"ERROR_NAME","TransmissionTimeoutError");var S=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Invalid faces amount on frame"}]),"code","120060"),r}return b(t,e),g(t)}(l);_(S,"ERROR_NAME","InvalidFacesAmountOnFrameError");var E=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Wrong message format"}]),"code","1120001"),r}return b(t,e),g(t)}(l);_(E,"ERROR_NAME","InvalidMessageFormatError");var k=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"API is not supported in this environment"}]),"code","1400007"),r}return b(t,e),g(t)}(l);_(k,"ERROR_NAME","NotSupportedApiError");var F=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Camera FPS is not defined"}]),"code","1400022"),r}return b(t,e),g(t)}(l);_(F,"ERROR_NAME","CameraFpsNotDefinedError");var M=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Camera resolution is not defined"}]),"code","14000025"),r}return b(t,e),g(t)}(l);_(M,"ERROR_NAME","CameraResolutionNotDefinedError");var R=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Video stream resolution is undefined"}]),"code","1400012"),r}return b(t,e),g(t)}(l);_(R,"ERROR_NAME","VideoStreamResolutionIsUndefinedError");var T=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"The resolution of the video stream contains invalid values, the width or height of the video stream cannot be equal to 0"}]),"code","1400013"),r}return b(t,e),g(t)}(l);_(T,"ERROR_NAME","InvalidVideoStreamResolutionValueError");var C=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"The resolution of the video preview contains invalid values, the width or height of the video preview cannot be equal to 0"}]),"code","1400013"),r}return b(t,e),g(t)}(l);_(C,"ERROR_NAME","InvalidVideoPreviewResolutionValueError");var A=function(e){function t(e){var r;return f(this,t),_(r=m(this,t,[{message:null!=e?e:"Applicant is blocked"}]),"code","1150005"),r}return b(t,e),g(t)}(l);function B(e){return B="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},B(e)}function P(e,t){return"data"in e&&"object"===B(e.data)&&null!==e.data?e.data[t]:void 0}_(A,"ERROR_NAME","ApplicantBlockedError");var j=["fill","contain","cover","none","scale-down"];function L(e){var t=getComputedStyle(e).objectFit;return j.includes(t)?t:"cover"}function I(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:33;return e()?Promise.resolve():new Promise(function(r){var o=setInterval(function(){e()&&(clearInterval(o),r())},t)})}function D(e,t,r){var o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:33;if(e())return Promise.resolve();var n=Date.now();return new Promise(function(i,a){var s=setInterval(function(){try{if(e())return clearInterval(s),void i();Date.now()-n>r&&(clearInterval(s),t(),a(new Error("Timeout")))}catch(e){clearInterval(s),a(e)}},o)})}function x(e){return new Promise(function(t){setTimeout(t,e)})}function G(e){return G="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},G(e)}function N(e){var t="function"==typeof Map?new Map:void 0;return N=function(e){if(null===e||!function(e){try{return-1!==Function.toString.call(e).indexOf("[native code]")}catch(t){return"function"==typeof e}}(e))return e;if("function"!=typeof e)throw new TypeError("Super expression must either be null or a function");if(void 0!==t){if(t.has(e))return t.get(e);t.set(e,r)}function r(){return function(e,t,r){if(V())return Reflect.construct.apply(null,arguments);var o=[null];o.push.apply(o,t);var n=new(e.bind.apply(e,o));return r&&$(n,r.prototype),n}(e,arguments,K(this).constructor)}return r.prototype=Object.create(e.prototype,{constructor:{value:r,enumerable:!1,writable:!0,configurable:!0}}),$(r,e)},N(e)}function z(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,Y(o.key),o)}}function W(e,t,r){return t&&z(e.prototype,t),r&&z(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e}function U(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function H(e,t,r){return t=K(t),function(e,t){if(t&&("object"==G(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(e,V()?Reflect.construct(t,r||[],K(e).constructor):t.apply(e,r))}function V(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}))}catch(e){}return(V=function(){return!!e})()}function K(e){return K=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},K(e)}function X(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&$(e,t)}function $(e,t){return $=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},$(e,t)}function Y(e){var t=function(e){if("object"!=G(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=G(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==G(t)?t:t+""}var q,J,Z,Q=function(e){function t(e){return U(this,t),H(this,t,[{message:null!=e?e:"The identifier of the element not specified"}])}return X(t,e),W(t)}(l);q=Q,Z="UndefinedElementIdError",(J=Y(J="ERROR_NAME"))in q?Object.defineProperty(q,J,{value:Z,enumerable:!0,configurable:!0,writable:!0}):q[J]=Z;var ee=function(e){function t(){return U(this,t),H(this,t,["The identifier of the element cannot be an empty string"])}return X(t,e),W(t)}(N(Error)),te=function(e){function t(){return U(this,t),H(this,t,["Eement not found in HTML document by specified identifier"])}return X(t,e),W(t)}(N(Error));function re(e){return re="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},re(e)}function oe(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,ne(o.key),o)}}function ne(e){var t=function(e){if("object"!=re(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=re(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==re(t)?t:t+""}var ie=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}return function(e,t,r){return r&&oe(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e}(e,0,[{key:"getElementById",value:function(t){return e._validateElementId(t),e._serchElementById(t)}},{key:"_validateElementId",value:function(t){if(e._isElementIdUndefined(t))throw new Q;if(e._isElementIdEmptyString(t))throw new ee}},{key:"_isElementIdUndefined",value:function(e){return void 0===e||null}},{key:"_isElementIdEmptyString",value:function(e){return""===e}},{key:"_serchElementById",value:function(e){var t=document.getElementById(e);if(!t)throw new te;return t}}])}();function ae(e){return ae="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},ae(e)}function se(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,ce(o.key),o)}}function pe(e,t,r){return(t=ce(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function ce(e){var t=function(e){if("object"!=ae(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=ae(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==ae(t)?t:t+""}var le=function(){return function(e,t){return t&&se(e.prototype,t),Object.defineProperty(e,"prototype",{writable:!1}),e}(function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),pe(this,"integrationId",null),pe(this,"applicantId",null),pe(this,"attemptId",null),pe(this,"endeavorId",null),pe(this,"deviceId",null),pe(this,"_logs",[])},[{key:"clear",value:function(){this.integrationId=null,this.applicantId=null,this.attemptId=null,this.endeavorId=null,this.deviceId=null,this._logs=[]}},{key:"destroy",value:function(){this.clear()}},{key:"createLog",value:function(e,t){return{date:(new Date).toISOString(),message:e,level:t}}}])}();function de(e){return de="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},de(e)}function ue(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,ge(o.key),o)}}function ge(e){var t=function(e){if("object"!=de(e)||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=de(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==de(t)?t:t+""}function fe(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}))}catch(e){}return(fe=function(){return!!e})()}function me(e,t,r,o){var n=he(ye(1&o?e.prototype:e),t,r);return 2&o&&"function"==typeof n?function(e){return n.apply(r,e)}:n}function he(){return he="undefined"!=typeof Reflect&&Reflect.get?Reflect.get.bind():function(e,t,r){var o=function(e,t){for(;!{}.hasOwnProperty.call(e,t)&&null!==(e=ye(e)););return e}(e,t);if(o){var n=Object.getOwnPropertyDescriptor(o,t);return n.get?n.get.call(arguments.length<3?e:r):n.value}},he.apply(null,arguments)}function ye(e){return ye=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},ye(e)}function be(e,t){return be=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},be(e,t)}var ve=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t,r){return t=ye(t),function(e,t){if(t&&("object"==de(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e)}(e,fe()?Reflect.construct(t,r||[],ye(e).constructor):t.apply(e,r))}(this,t,arguments)}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&be(e,t)}(t,e),function(e,t){return t&&ue(e.prototype,t),Object.defineProperty(e,"prototype",{writable:!1}),e}(t,[{key:"addDebugLog",value:function(e){var r=me(t,"createLog",this,3)([e,"debug"]);this._printLogInConsole(r)}},{key:"addInfoLog",value:function(e){var r=me(t,"createLog",this,3)([e,"info"]);this._printLogInConsole(r)}},{key:"addWarningLog",value:function(e){var r=me(t,"createLog",this,3)([e,"warning"]);this._printLogInConsole(r)}},{key:"addErrorLog",value:function(e){var r=me(t,"createLog",this,3)([e,"error"]);this._printLogInConsole(r)}},{key:"addCriticalErrorLog",value:function(e){var r=me(t,"createLog",this,3)([e,"critical"]);this._printLogInConsole(r)}},{key:"_printLogInConsole",value:function(e){var t=this._formatLogToString(e);console.log("%c".concat(t),"font-size: 14px; color: ".concat({error:"red",critical:"red",debug:"black",info:"black",warning:"darkorange"}[e.level],";"))}},{key:"_formatLogToString",value:function(e){var t=e.date,r=e.level,o=e.message;return"[".concat(t,"] [").concat(r,"] ").concat(o)}},{key:"flush",value:function(){}},{key:"destroy",value:function(){}}])}(le),_e=Symbol("logging_service");function Oe(e,t){return function(){return e.apply(t,arguments)}}const{toString:we}=Object.prototype,{getPrototypeOf:Se}=Object,{iterator:Ee,toStringTag:ke}=Symbol,Fe=(Me=Object.create(null),e=>{const t=we.call(e);return Me[t]||(Me[t]=t.slice(8,-1).toLowerCase())});var Me;const Re=e=>(e=e.toLowerCase(),t=>Fe(t)===e),Te=e=>t=>typeof t===e,{isArray:Ce}=Array,Ae=Te("undefined");function Be(e){return null!==e&&!Ae(e)&&null!==e.constructor&&!Ae(e.constructor)&&Le(e.constructor.isBuffer)&&e.constructor.isBuffer(e)}const Pe=Re("ArrayBuffer"),je=Te("string"),Le=Te("function"),Ie=Te("number"),De=e=>null!==e&&"object"==typeof e,xe=e=>{if("object"!==Fe(e))return!1;const t=Se(e);return!(null!==t&&t!==Object.prototype&&null!==Object.getPrototypeOf(t)||ke in e||Ee in e)},Ge=Re("Date"),Ne=Re("File"),ze=Re("Blob"),We=Re("FileList"),Ue=Re("URLSearchParams"),[He,Ve,Ke,Xe]=["ReadableStream","Request","Response","Headers"].map(Re);function $e(e,t,{allOwnKeys:r=!1}={}){if(null==e)return;let o,n;if("object"!=typeof e&&(e=[e]),Ce(e))for(o=0,n=e.length;o<n;o++)t.call(null,e[o],o,e);else{if(Be(e))return;const n=r?Object.getOwnPropertyNames(e):Object.keys(e),i=n.length;let a;for(o=0;o<i;o++)a=n[o],t.call(null,e[a],a,e)}}function Ye(e,t){if(Be(e))return null;t=t.toLowerCase();const r=Object.keys(e);let o,n=r.length;for(;n-- >0;)if(o=r[n],t===o.toLowerCase())return o;return null}const qe="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:"undefined"!=typeof window?window:__webpack_require__.g,Je=e=>!Ae(e)&&e!==qe,Ze=(Qe="undefined"!=typeof Uint8Array&&Se(Uint8Array),e=>Qe&&e instanceof Qe);var Qe;const et=Re("HTMLFormElement"),tt=(({hasOwnProperty:e})=>(t,r)=>e.call(t,r))(Object.prototype),rt=Re("RegExp"),ot=(e,t)=>{const r=Object.getOwnPropertyDescriptors(e),o={};$e(r,(r,n)=>{let i;!1!==(i=t(r,n,e))&&(o[n]=i||r)}),Object.defineProperties(e,o)},nt=Re("AsyncFunction"),it=(at="function"==typeof setImmediate,st=Le(qe.postMessage),at?setImmediate:st?(pt=`axios@${Math.random()}`,ct=[],qe.addEventListener("message",({source:e,data:t})=>{e===qe&&t===pt&&ct.length&&ct.shift()()},!1),e=>{ct.push(e),qe.postMessage(pt,"*")}):e=>setTimeout(e));var at,st,pt,ct;const lt="undefined"!=typeof queueMicrotask?queueMicrotask.bind(qe):"undefined"!=typeof process&&process.nextTick||it,dt={isArray:Ce,isArrayBuffer:Pe,isBuffer:Be,isFormData:e=>{let t;return e&&("function"==typeof FormData&&e instanceof FormData||Le(e.append)&&("formdata"===(t=Fe(e))||"object"===t&&Le(e.toString)&&"[object FormData]"===e.toString()))},isArrayBufferView:function(e){let t;return t="undefined"!=typeof ArrayBuffer&&ArrayBuffer.isView?ArrayBuffer.isView(e):e&&e.buffer&&Pe(e.buffer),t},isString:je,isNumber:Ie,isBoolean:e=>!0===e||!1===e,isObject:De,isPlainObject:xe,isEmptyObject:e=>{if(!De(e)||Be(e))return!1;try{return 0===Object.keys(e).length&&Object.getPrototypeOf(e)===Object.prototype}catch(e){return!1}},isReadableStream:He,isRequest:Ve,isResponse:Ke,isHeaders:Xe,isUndefined:Ae,isDate:Ge,isFile:Ne,isBlob:ze,isRegExp:rt,isFunction:Le,isStream:e=>De(e)&&Le(e.pipe),isURLSearchParams:Ue,isTypedArray:Ze,isFileList:We,forEach:$e,merge:function e(){const{caseless:t,skipUndefined:r}=Je(this)&&this||{},o={},n=(n,i)=>{const a=t&&Ye(o,i)||i;xe(o[a])&&xe(n)?o[a]=e(o[a],n):xe(n)?o[a]=e({},n):Ce(n)?o[a]=n.slice():r&&Ae(n)||(o[a]=n)};for(let e=0,t=arguments.length;e<t;e++)arguments[e]&&$e(arguments[e],n);return o},extend:(e,t,r,{allOwnKeys:o}={})=>($e(t,(t,o)=>{r&&Le(t)?e[o]=Oe(t,r):e[o]=t},{allOwnKeys:o}),e),trim:e=>e.trim?e.trim():e.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,""),stripBOM:e=>(65279===e.charCodeAt(0)&&(e=e.slice(1)),e),inherits:(e,t,r,o)=>{e.prototype=Object.create(t.prototype,o),e.prototype.constructor=e,Object.defineProperty(e,"super",{value:t.prototype}),r&&Object.assign(e.prototype,r)},toFlatObject:(e,t,r,o)=>{let n,i,a;const s={};if(t=t||{},null==e)return t;do{for(n=Object.getOwnPropertyNames(e),i=n.length;i-- >0;)a=n[i],o&&!o(a,e,t)||s[a]||(t[a]=e[a],s[a]=!0);e=!1!==r&&Se(e)}while(e&&(!r||r(e,t))&&e!==Object.prototype);return t},kindOf:Fe,kindOfTest:Re,endsWith:(e,t,r)=>{e=String(e),(void 0===r||r>e.length)&&(r=e.length),r-=t.length;const o=e.indexOf(t,r);return-1!==o&&o===r},toArray:e=>{if(!e)return null;if(Ce(e))return e;let t=e.length;if(!Ie(t))return null;const r=new Array(t);for(;t-- >0;)r[t]=e[t];return r},forEachEntry:(e,t)=>{const r=(e&&e[Ee]).call(e);let o;for(;(o=r.next())&&!o.done;){const r=o.value;t.call(e,r[0],r[1])}},matchAll:(e,t)=>{let r;const o=[];for(;null!==(r=e.exec(t));)o.push(r);return o},isHTMLForm:et,hasOwnProperty:tt,hasOwnProp:tt,reduceDescriptors:ot,freezeMethods:e=>{ot(e,(t,r)=>{if(Le(e)&&-1!==["arguments","caller","callee"].indexOf(r))return!1;const o=e[r];Le(o)&&(t.enumerable=!1,"writable"in t?t.writable=!1:t.set||(t.set=()=>{throw Error("Can not rewrite read-only method '"+r+"'")}))})},toObjectSet:(e,t)=>{const r={},o=e=>{e.forEach(e=>{r[e]=!0})};return Ce(e)?o(e):o(String(e).split(t)),r},toCamelCase:e=>e.toLowerCase().replace(/[-_\s]([a-z\d])(\w*)/g,function(e,t,r){return t.toUpperCase()+r}),noop:()=>{},toFiniteNumber:(e,t)=>null!=e&&Number.isFinite(e=+e)?e:t,findKey:Ye,global:qe,isContextDefined:Je,isSpecCompliantForm:function(e){return!!(e&&Le(e.append)&&"FormData"===e[ke]&&e[Ee])},toJSONObject:e=>{const t=new Array(10),r=(e,o)=>{if(De(e)){if(t.indexOf(e)>=0)return;if(Be(e))return e;if(!("toJSON"in e)){t[o]=e;const n=Ce(e)?[]:{};return $e(e,(e,t)=>{const i=r(e,o+1);!Ae(i)&&(n[t]=i)}),t[o]=void 0,n}}return e};return r(e,0)},isAsyncFn:nt,isThenable:e=>e&&(De(e)||Le(e))&&Le(e.then)&&Le(e.catch),setImmediate:it,asap:lt,isIterable:e=>null!=e&&Le(e[Ee])};function ut(e,t,r,o,n){Error.call(this),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack,this.message=e,this.name="AxiosError",t&&(this.code=t),r&&(this.config=r),o&&(this.request=o),n&&(this.response=n,this.status=n.status?n.status:null)}dt.inherits(ut,Error,{toJSON:function(){return{message:this.message,name:this.name,description:this.description,number:this.number,fileName:this.fileName,lineNumber:this.lineNumber,columnNumber:this.columnNumber,stack:this.stack,config:dt.toJSONObject(this.config),code:this.code,status:this.status}}});const gt=ut.prototype,ft={};["ERR_BAD_OPTION_VALUE","ERR_BAD_OPTION","ECONNABORTED","ETIMEDOUT","ERR_NETWORK","ERR_FR_TOO_MANY_REDIRECTS","ERR_DEPRECATED","ERR_BAD_RESPONSE","ERR_BAD_REQUEST","ERR_CANCELED","ERR_NOT_SUPPORT","ERR_INVALID_URL"].forEach(e=>{ft[e]={value:e}}),Object.defineProperties(ut,ft),Object.defineProperty(gt,"isAxiosError",{value:!0}),ut.from=(e,t,r,o,n,i)=>{const a=Object.create(gt);dt.toFlatObject(e,a,function(e){return e!==Error.prototype},e=>"isAxiosError"!==e);const s=e&&e.message?e.message:"Error",p=null==t&&e?e.code:t;return ut.call(a,s,p,r,o,n),e&&null==a.cause&&Object.defineProperty(a,"cause",{value:e,configurable:!0}),a.name=e&&e.name||"Error",i&&Object.assign(a,i),a};const mt=ut;function ht(e){return dt.isPlainObject(e)||dt.isArray(e)}function yt(e){return dt.endsWith(e,"[]")?e.slice(0,-2):e}function bt(e,t,r){return e?e.concat(t).map(function(e,t){return e=yt(e),!r&&t?"["+e+"]":e}).join(r?".":""):t}const vt=dt.toFlatObject(dt,{},null,function(e){return/^is[A-Z]/.test(e)}),_t=function(e,t,r){if(!dt.isObject(e))throw new TypeError("target must be an object");t=t||new FormData;const o=(r=dt.toFlatObject(r,{metaTokens:!0,dots:!1,indexes:!1},!1,function(e,t){return!dt.isUndefined(t[e])})).metaTokens,n=r.visitor||c,i=r.dots,a=r.indexes,s=(r.Blob||"undefined"!=typeof Blob&&Blob)&&dt.isSpecCompliantForm(t);if(!dt.isFunction(n))throw new TypeError("visitor must be a function");function p(e){if(null===e)return"";if(dt.isDate(e))return e.toISOString();if(dt.isBoolean(e))return e.toString();if(!s&&dt.isBlob(e))throw new mt("Blob is not supported. Use a Buffer instead.");return dt.isArrayBuffer(e)||dt.isTypedArray(e)?s&&"function"==typeof Blob?new Blob([e]):Buffer.from(e):e}function c(e,r,n){let s=e;if(e&&!n&&"object"==typeof e)if(dt.endsWith(r,"{}"))r=o?r:r.slice(0,-2),e=JSON.stringify(e);else if(dt.isArray(e)&&function(e){return dt.isArray(e)&&!e.some(ht)}(e)||(dt.isFileList(e)||dt.endsWith(r,"[]"))&&(s=dt.toArray(e)))return r=yt(r),s.forEach(function(e,o){!dt.isUndefined(e)&&null!==e&&t.append(!0===a?bt([r],o,i):null===a?r:r+"[]",p(e))}),!1;return!!ht(e)||(t.append(bt(n,r,i),p(e)),!1)}const l=[],d=Object.assign(vt,{defaultVisitor:c,convertValue:p,isVisitable:ht});if(!dt.isObject(e))throw new TypeError("data must be an object");return function e(r,o){if(!dt.isUndefined(r)){if(-1!==l.indexOf(r))throw Error("Circular reference detected in "+o.join("."));l.push(r),dt.forEach(r,function(r,i){!0===(!(dt.isUndefined(r)||null===r)&&n.call(t,r,dt.isString(i)?i.trim():i,o,d))&&e(r,o?o.concat(i):[i])}),l.pop()}}(e),t};function Ot(e){const t={"!":"%21","'":"%27","(":"%28",")":"%29","~":"%7E","%20":"+","%00":"\0"};return encodeURIComponent(e).replace(/[!'()~]|%20|%00/g,function(e){return t[e]})}function wt(e,t){this._pairs=[],e&&_t(e,this,t)}const St=wt.prototype;St.append=function(e,t){this._pairs.push([e,t])},St.toString=function(e){const t=e?function(t){return e.call(this,t,Ot)}:Ot;return this._pairs.map(function(e){return t(e[0])+"="+t(e[1])},"").join("&")};const Et=wt;function kt(e){return encodeURIComponent(e).replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%20/g,"+")}function Ft(e,t,r){if(!t)return e;const o=r&&r.encode||kt;dt.isFunction(r)&&(r={serialize:r});const n=r&&r.serialize;let i;if(i=n?n(t,r):dt.isURLSearchParams(t)?t.toString():new Et(t,r).toString(o),i){const t=e.indexOf("#");-1!==t&&(e=e.slice(0,t)),e+=(-1===e.indexOf("?")?"?":"&")+i}return e}const Mt=class{constructor(){this.handlers=[]}use(e,t,r){return this.handlers.push({fulfilled:e,rejected:t,synchronous:!!r&&r.synchronous,runWhen:r?r.runWhen:null}),this.handlers.length-1}eject(e){this.handlers[e]&&(this.handlers[e]=null)}clear(){this.handlers&&(this.handlers=[])}forEach(e){dt.forEach(this.handlers,function(t){null!==t&&e(t)})}},Rt={silentJSONParsing:!0,forcedJSONParsing:!0,clarifyTimeoutError:!1},Tt={isBrowser:!0,classes:{URLSearchParams:"undefined"!=typeof URLSearchParams?URLSearchParams:Et,FormData:"undefined"!=typeof FormData?FormData:null,Blob:"undefined"!=typeof Blob?Blob:null},protocols:["http","https","file","blob","url","data"]},Ct="undefined"!=typeof window&&"undefined"!=typeof document,At="object"==typeof navigator&&navigator||void 0,Bt=Ct&&(!At||["ReactNative","NativeScript","NS"].indexOf(At.product)<0),Pt="undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope&&"function"==typeof self.importScripts,jt=Ct&&window.location.href||"http://localhost",Lt={...e,...Tt},It=function(e){function t(e,r,o,n){let i=e[n++];if("__proto__"===i)return!0;const a=Number.isFinite(+i),s=n>=e.length;return i=!i&&dt.isArray(o)?o.length:i,s?(dt.hasOwnProp(o,i)?o[i]=[o[i],r]:o[i]=r,!a):(o[i]&&dt.isObject(o[i])||(o[i]=[]),t(e,r,o[i],n)&&dt.isArray(o[i])&&(o[i]=function(e){const t={},r=Object.keys(e);let o;const n=r.length;let i;for(o=0;o<n;o++)i=r[o],t[i]=e[i];return t}(o[i])),!a)}if(dt.isFormData(e)&&dt.isFunction(e.entries)){const r={};return dt.forEachEntry(e,(e,o)=>{t(function(e){return dt.matchAll(/\w+|\[(\w*)]/g,e).map(e=>"[]"===e[0]?"":e[1]||e[0])}(e),o,r,0)}),r}return null},Dt={transitional:Rt,adapter:["xhr","http","fetch"],transformRequest:[function(e,t){const r=t.getContentType()||"",o=r.indexOf("application/json")>-1,n=dt.isObject(e);if(n&&dt.isHTMLForm(e)&&(e=new FormData(e)),dt.isFormData(e))return o?JSON.stringify(It(e)):e;if(dt.isArrayBuffer(e)||dt.isBuffer(e)||dt.isStream(e)||dt.isFile(e)||dt.isBlob(e)||dt.isReadableStream(e))return e;if(dt.isArrayBufferView(e))return e.buffer;if(dt.isURLSearchParams(e))return t.setContentType("application/x-www-form-urlencoded;charset=utf-8",!1),e.toString();let i;if(n){if(r.indexOf("application/x-www-form-urlencoded")>-1)return function(e,t){return _t(e,new Lt.classes.URLSearchParams,{visitor:function(e,t,r,o){return Lt.isNode&&dt.isBuffer(e)?(this.append(t,e.toString("base64")),!1):o.defaultVisitor.apply(this,arguments)},...t})}(e,this.formSerializer).toString();if((i=dt.isFileList(e))||r.indexOf("multipart/form-data")>-1){const t=this.env&&this.env.FormData;return _t(i?{"files[]":e}:e,t&&new t,this.formSerializer)}}return n||o?(t.setContentType("application/json",!1),function(e){if(dt.isString(e))try{return(0,JSON.parse)(e),dt.trim(e)}catch(e){if("SyntaxError"!==e.name)throw e}return(0,JSON.stringify)(e)}(e)):e}],transformResponse:[function(e){const t=this.transitional||Dt.transitional,r=t&&t.forcedJSONParsing,o="json"===this.responseType;if(dt.isResponse(e)||dt.isReadableStream(e))return e;if(e&&dt.isString(e)&&(r&&!this.responseType||o)){const r=!(t&&t.silentJSONParsing)&&o;try{return JSON.parse(e,this.parseReviver)}catch(e){if(r){if("SyntaxError"===e.name)throw mt.from(e,mt.ERR_BAD_RESPONSE,this,null,this.response);throw e}}}return e}],timeout:0,xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN",maxContentLength:-1,maxBodyLength:-1,env:{FormData:Lt.classes.FormData,Blob:Lt.classes.Blob},validateStatus:function(e){return e>=200&&e<300},headers:{common:{Accept:"application/json, text/plain, */*","Content-Type":void 0}}};dt.forEach(["delete","get","head","post","put","patch"],e=>{Dt.headers[e]={}});const xt=Dt,Gt=dt.toObjectSet(["age","authorization","content-length","content-type","etag","expires","from","host","if-modified-since","if-unmodified-since","last-modified","location","max-forwards","proxy-authorization","referer","retry-after","user-agent"]),Nt=Symbol("internals");function zt(e){return e&&String(e).trim().toLowerCase()}function Wt(e){return!1===e||null==e?e:dt.isArray(e)?e.map(Wt):String(e)}function Ut(e,t,r,o,n){return dt.isFunction(o)?o.call(this,t,r):(n&&(t=r),dt.isString(t)?dt.isString(o)?-1!==t.indexOf(o):dt.isRegExp(o)?o.test(t):void 0:void 0)}class Ht{constructor(e){e&&this.set(e)}set(e,t,r){const o=this;function n(e,t,r){const n=zt(t);if(!n)throw new Error("header name must be a non-empty string");const i=dt.findKey(o,n);(!i||void 0===o[i]||!0===r||void 0===r&&!1!==o[i])&&(o[i||t]=Wt(e))}const i=(e,t)=>dt.forEach(e,(e,r)=>n(e,r,t));if(dt.isPlainObject(e)||e instanceof this.constructor)i(e,t);else if(dt.isString(e)&&(e=e.trim())&&!/^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(e.trim()))i((e=>{const t={};let r,o,n;return e&&e.split("\n").forEach(function(e){n=e.indexOf(":"),r=e.substring(0,n).trim().toLowerCase(),o=e.substring(n+1).trim(),!r||t[r]&&Gt[r]||("set-cookie"===r?t[r]?t[r].push(o):t[r]=[o]:t[r]=t[r]?t[r]+", "+o:o)}),t})(e),t);else if(dt.isObject(e)&&dt.isIterable(e)){let r,o,n={};for(const t of e){if(!dt.isArray(t))throw TypeError("Object iterator must return a key-value pair");n[o=t[0]]=(r=n[o])?dt.isArray(r)?[...r,t[1]]:[r,t[1]]:t[1]}i(n,t)}else null!=e&&n(t,e,r);return this}get(e,t){if(e=zt(e)){const r=dt.findKey(this,e);if(r){const e=this[r];if(!t)return e;if(!0===t)return function(e){const t=Object.create(null),r=/([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;let o;for(;o=r.exec(e);)t[o[1]]=o[2];return t}(e);if(dt.isFunction(t))return t.call(this,e,r);if(dt.isRegExp(t))return t.exec(e);throw new TypeError("parser must be boolean|regexp|function")}}}has(e,t){if(e=zt(e)){const r=dt.findKey(this,e);return!(!r||void 0===this[r]||t&&!Ut(0,this[r],r,t))}return!1}delete(e,t){const r=this;let o=!1;function n(e){if(e=zt(e)){const n=dt.findKey(r,e);!n||t&&!Ut(0,r[n],n,t)||(delete r[n],o=!0)}}return dt.isArray(e)?e.forEach(n):n(e),o}clear(e){const t=Object.keys(this);let r=t.length,o=!1;for(;r--;){const n=t[r];e&&!Ut(0,this[n],n,e,!0)||(delete this[n],o=!0)}return o}normalize(e){const t=this,r={};return dt.forEach(this,(o,n)=>{const i=dt.findKey(r,n);if(i)return t[i]=Wt(o),void delete t[n];const a=e?function(e){return e.trim().toLowerCase().replace(/([a-z\d])(\w*)/g,(e,t,r)=>t.toUpperCase()+r)}(n):String(n).trim();a!==n&&delete t[n],t[a]=Wt(o),r[a]=!0}),this}concat(...e){return this.constructor.concat(this,...e)}toJSON(e){const t=Object.create(null);return dt.forEach(this,(r,o)=>{null!=r&&!1!==r&&(t[o]=e&&dt.isArray(r)?r.join(", "):r)}),t}[Symbol.iterator](){return Object.entries(this.toJSON())[Symbol.iterator]()}toString(){return Object.entries(this.toJSON()).map(([e,t])=>e+": "+t).join("\n")}getSetCookie(){return this.get("set-cookie")||[]}get[Symbol.toStringTag](){return"AxiosHeaders"}static from(e){return e instanceof this?e:new this(e)}static concat(e,...t){const r=new this(e);return t.forEach(e=>r.set(e)),r}static accessor(e){const t=(this[Nt]=this[Nt]={accessors:{}}).accessors,r=this.prototype;function o(e){const o=zt(e);t[o]||(function(e,t){const r=dt.toCamelCase(" "+t);["get","set","has"].forEach(o=>{Object.defineProperty(e,o+r,{value:function(e,r,n){return this[o].call(this,t,e,r,n)},configurable:!0})})}(r,e),t[o]=!0)}return dt.isArray(e)?e.forEach(o):o(e),this}}Ht.accessor(["Content-Type","Content-Length","Accept","Accept-Encoding","User-Agent","Authorization"]),dt.reduceDescriptors(Ht.prototype,({value:e},t)=>{let r=t[0].toUpperCase()+t.slice(1);return{get:()=>e,set(e){this[r]=e}}}),dt.freezeMethods(Ht);const Vt=Ht;function Kt(e,t){const r=this||xt,o=t||r,n=Vt.from(o.headers);let i=o.data;return dt.forEach(e,function(e){i=e.call(r,i,n.normalize(),t?t.status:void 0)}),n.normalize(),i}function Xt(e){return!(!e||!e.__CANCEL__)}function $t(e,t,r){mt.call(this,null==e?"canceled":e,mt.ERR_CANCELED,t,r),this.name="CanceledError"}dt.inherits($t,mt,{__CANCEL__:!0});const Yt=$t;function qt(e,t,r){const o=r.config.validateStatus;r.status&&o&&!o(r.status)?t(new mt("Request failed with status code "+r.status,[mt.ERR_BAD_REQUEST,mt.ERR_BAD_RESPONSE][Math.floor(r.status/100)-4],r.config,r.request,r)):e(r)}const Jt=(e,t,r=3)=>{let o=0;const n=function(e,t){e=e||10;const r=new Array(e),o=new Array(e);let n,i=0,a=0;return t=void 0!==t?t:1e3,function(s){const p=Date.now(),c=o[a];n||(n=p),r[i]=s,o[i]=p;let l=a,d=0;for(;l!==i;)d+=r[l++],l%=e;if(i=(i+1)%e,i===a&&(a=(a+1)%e),p-n<t)return;const u=c&&p-c;return u?Math.round(1e3*d/u):void 0}}(50,250);return function(e,t){let r,o,n=0,i=1e3/t;const a=(t,i=Date.now())=>{n=i,r=null,o&&(clearTimeout(o),o=null),e(...t)};return[(...e)=>{const t=Date.now(),s=t-n;s>=i?a(e,t):(r=e,o||(o=setTimeout(()=>{o=null,a(r)},i-s)))},()=>r&&a(r)]}(r=>{const i=r.loaded,a=r.lengthComputable?r.total:void 0,s=i-o,p=n(s);o=i,e({loaded:i,total:a,progress:a?i/a:void 0,bytes:s,rate:p||void 0,estimated:p&&a&&i<=a?(a-i)/p:void 0,event:r,lengthComputable:null!=a,[t?"download":"upload"]:!0})},r)},Zt=(e,t)=>{const r=null!=e;return[o=>t[0]({lengthComputable:r,total:e,loaded:o}),t[1]]},Qt=e=>(...t)=>dt.asap(()=>e(...t)),er=Lt.hasStandardBrowserEnv?((e,t)=>r=>(r=new URL(r,Lt.origin),e.protocol===r.protocol&&e.host===r.host&&(t||e.port===r.port)))(new URL(Lt.origin),Lt.navigator&&/(msie|trident)/i.test(Lt.navigator.userAgent)):()=>!0,tr=Lt.hasStandardBrowserEnv?{write(e,t,r,o,n,i,a){if("undefined"==typeof document)return;const s=[`${e}=${encodeURIComponent(t)}`];dt.isNumber(r)&&s.push(`expires=${new Date(r).toUTCString()}`),dt.isString(o)&&s.push(`path=${o}`),dt.isString(n)&&s.push(`domain=${n}`),!0===i&&s.push("secure"),dt.isString(a)&&s.push(`SameSite=${a}`),document.cookie=s.join("; ")},read(e){if("undefined"==typeof document)return null;const t=document.cookie.match(new RegExp("(?:^|; )"+e+"=([^;]*)"));return t?decodeURIComponent(t[1]):null},remove(e){this.write(e,"",Date.now()-864e5,"/")}}:{write(){},read:()=>null,remove(){}};function rr(e,t,r){let o=!/^([a-z][a-z\d+\-.]*:)?\/\//i.test(t);return e&&(o||0==r)?function(e,t){return t?e.replace(/\/?\/$/,"")+"/"+t.replace(/^\/+/,""):e}(e,t):t}const or=e=>e instanceof Vt?{...e}:e;function nr(e,t){t=t||{};const r={};function o(e,t,r,o){return dt.isPlainObject(e)&&dt.isPlainObject(t)?dt.merge.call({caseless:o},e,t):dt.isPlainObject(t)?dt.merge({},t):dt.isArray(t)?t.slice():t}function n(e,t,r,n){return dt.isUndefined(t)?dt.isUndefined(e)?void 0:o(void 0,e,0,n):o(e,t,0,n)}function i(e,t){if(!dt.isUndefined(t))return o(void 0,t)}function a(e,t){return dt.isUndefined(t)?dt.isUndefined(e)?void 0:o(void 0,e):o(void 0,t)}function s(r,n,i){return i in t?o(r,n):i in e?o(void 0,r):void 0}const p={url:i,method:i,data:i,baseURL:a,transformRequest:a,transformResponse:a,paramsSerializer:a,timeout:a,timeoutMessage:a,withCredentials:a,withXSRFToken:a,adapter:a,responseType:a,xsrfCookieName:a,xsrfHeaderName:a,onUploadProgress:a,onDownloadProgress:a,decompress:a,maxContentLength:a,maxBodyLength:a,beforeRedirect:a,transport:a,httpAgent:a,httpsAgent:a,cancelToken:a,socketPath:a,responseEncoding:a,validateStatus:s,headers:(e,t,r)=>n(or(e),or(t),0,!0)};return dt.forEach(Object.keys({...e,...t}),function(o){const i=p[o]||n,a=i(e[o],t[o],o);dt.isUndefined(a)&&i!==s||(r[o]=a)}),r}const ir=e=>{const t=nr({},e);let{data:r,withXSRFToken:o,xsrfHeaderName:n,xsrfCookieName:i,headers:a,auth:s}=t;if(t.headers=a=Vt.from(a),t.url=Ft(rr(t.baseURL,t.url,t.allowAbsoluteUrls),e.params,e.paramsSerializer),s&&a.set("Authorization","Basic "+btoa((s.username||"")+":"+(s.password?unescape(encodeURIComponent(s.password)):""))),dt.isFormData(r))if(Lt.hasStandardBrowserEnv||Lt.hasStandardBrowserWebWorkerEnv)a.setContentType(void 0);else if(dt.isFunction(r.getHeaders)){const e=r.getHeaders(),t=["content-type","content-length"];Object.entries(e).forEach(([e,r])=>{t.includes(e.toLowerCase())&&a.set(e,r)})}if(Lt.hasStandardBrowserEnv&&(o&&dt.isFunction(o)&&(o=o(t)),o||!1!==o&&er(t.url))){const e=n&&i&&tr.read(i);e&&a.set(n,e)}return t},ar="undefined"!=typeof XMLHttpRequest&&function(e){return new Promise(function(t,r){const o=ir(e);let n=o.data;const i=Vt.from(o.headers).normalize();let a,s,p,c,l,{responseType:d,onUploadProgress:u,onDownloadProgress:g}=o;function f(){c&&c(),l&&l(),o.cancelToken&&o.cancelToken.unsubscribe(a),o.signal&&o.signal.removeEventListener("abort",a)}let m=new XMLHttpRequest;function h(){if(!m)return;const o=Vt.from("getAllResponseHeaders"in m&&m.getAllResponseHeaders());qt(function(e){t(e),f()},function(e){r(e),f()},{data:d&&"text"!==d&&"json"!==d?m.response:m.responseText,status:m.status,statusText:m.statusText,headers:o,config:e,request:m}),m=null}m.open(o.method.toUpperCase(),o.url,!0),m.timeout=o.timeout,"onloadend"in m?m.onloadend=h:m.onreadystatechange=function(){m&&4===m.readyState&&(0!==m.status||m.responseURL&&0===m.responseURL.indexOf("file:"))&&setTimeout(h)},m.onabort=function(){m&&(r(new mt("Request aborted",mt.ECONNABORTED,e,m)),m=null)},m.onerror=function(t){const o=t&&t.message?t.message:"Network Error",n=new mt(o,mt.ERR_NETWORK,e,m);n.event=t||null,r(n),m=null},m.ontimeout=function(){let t=o.timeout?"timeout of "+o.timeout+"ms exceeded":"timeout exceeded";const n=o.transitional||Rt;o.timeoutErrorMessage&&(t=o.timeoutErrorMessage),r(new mt(t,n.clarifyTimeoutError?mt.ETIMEDOUT:mt.ECONNABORTED,e,m)),m=null},void 0===n&&i.setContentType(null),"setRequestHeader"in m&&dt.forEach(i.toJSON(),function(e,t){m.setRequestHeader(t,e)}),dt.isUndefined(o.withCredentials)||(m.withCredentials=!!o.withCredentials),d&&"json"!==d&&(m.responseType=o.responseType),g&&([p,l]=Jt(g,!0),m.addEventListener("progress",p)),u&&m.upload&&([s,c]=Jt(u),m.upload.addEventListener("progress",s),m.upload.addEventListener("loadend",c)),(o.cancelToken||o.signal)&&(a=t=>{m&&(r(!t||t.type?new Yt(null,e,m):t),m.abort(),m=null)},o.cancelToken&&o.cancelToken.subscribe(a),o.signal&&(o.signal.aborted?a():o.signal.addEventListener("abort",a)));const y=function(e){const t=/^([-+\w]{1,25})(:?\/\/|:)/.exec(e);return t&&t[1]||""}(o.url);y&&-1===Lt.protocols.indexOf(y)?r(new mt("Unsupported protocol "+y+":",mt.ERR_BAD_REQUEST,e)):m.send(n||null)})},sr=(e,t)=>{const{length:r}=e=e?e.filter(Boolean):[];if(t||r){let r,o=new AbortController;const n=function(e){if(!r){r=!0,a();const t=e instanceof Error?e:this.reason;o.abort(t instanceof mt?t:new Yt(t instanceof Error?t.message:t))}};let i=t&&setTimeout(()=>{i=null,n(new mt(`timeout ${t} of ms exceeded`,mt.ETIMEDOUT))},t);const a=()=>{e&&(i&&clearTimeout(i),i=null,e.forEach(e=>{e.unsubscribe?e.unsubscribe(n):e.removeEventListener("abort",n)}),e=null)};e.forEach(e=>e.addEventListener("abort",n));const{signal:s}=o;return s.unsubscribe=()=>dt.asap(a),s}},pr=function*(e,t){let r=e.byteLength;if(!t||r<t)return void(yield e);let o,n=0;for(;n<r;)o=n+t,yield e.slice(n,o),n=o},cr=(e,t,r,o)=>{const n=async function*(e,t){for await(const r of async function*(e){if(e[Symbol.asyncIterator])return void(yield*e);const t=e.getReader();try{for(;;){const{done:e,value:r}=await t.read();if(e)break;yield r}}finally{await t.cancel()}}(e))yield*pr(r,t)}(e,t);let i,a=0,s=e=>{i||(i=!0,o&&o(e))};return new ReadableStream({async pull(e){try{const{done:t,value:o}=await n.next();if(t)return s(),void e.close();let i=o.byteLength;if(r){let e=a+=i;r(e)}e.enqueue(new Uint8Array(o))}catch(e){throw s(e),e}},cancel:e=>(s(e),n.return())},{highWaterMark:2})},{isFunction:lr}=dt,dr=(({Request:e,Response:t})=>({Request:e,Response:t}))(dt.global),{ReadableStream:ur,TextEncoder:gr}=dt.global,fr=(e,...t)=>{try{return!!e(...t)}catch(e){return!1}},mr=e=>{e=dt.merge.call({skipUndefined:!0},dr,e);const{fetch:t,Request:r,Response:o}=e,n=t?lr(t):"function"==typeof fetch,i=lr(r),a=lr(o);if(!n)return!1;const s=n&&lr(ur),p=n&&("function"==typeof gr?(c=new gr,e=>c.encode(e)):async e=>new Uint8Array(await new r(e).arrayBuffer()));var c;const l=i&&s&&fr(()=>{let e=!1;const t=new r(Lt.origin,{body:new ur,method:"POST",get duplex(){return e=!0,"half"}}).headers.has("Content-Type");return e&&!t}),d=a&&s&&fr(()=>dt.isReadableStream(new o("").body)),u={stream:d&&(e=>e.body)};n&&["text","arrayBuffer","blob","formData","stream"].forEach(e=>{!u[e]&&(u[e]=(t,r)=>{let o=t&&t[e];if(o)return o.call(t);throw new mt(`Response type '${e}' is not supported`,mt.ERR_NOT_SUPPORT,r)})});return async e=>{let{url:n,method:a,data:s,signal:c,cancelToken:g,timeout:f,onDownloadProgress:m,onUploadProgress:h,responseType:y,headers:b,withCredentials:v="same-origin",fetchOptions:_}=ir(e),O=t||fetch;y=y?(y+"").toLowerCase():"text";let w=sr([c,g&&g.toAbortSignal()],f),S=null;const E=w&&w.unsubscribe&&(()=>{w.unsubscribe()});let k;try{if(h&&l&&"get"!==a&&"head"!==a&&0!==(k=await(async(e,t)=>{const o=dt.toFiniteNumber(e.getContentLength());return null==o?(async e=>{if(null==e)return 0;if(dt.isBlob(e))return e.size;if(dt.isSpecCompliantForm(e)){const t=new r(Lt.origin,{method:"POST",body:e});return(await t.arrayBuffer()).byteLength}return dt.isArrayBufferView(e)||dt.isArrayBuffer(e)?e.byteLength:(dt.isURLSearchParams(e)&&(e+=""),dt.isString(e)?(await p(e)).byteLength:void 0)})(t):o})(b,s))){let e,t=new r(n,{method:"POST",body:s,duplex:"half"});if(dt.isFormData(s)&&(e=t.headers.get("content-type"))&&b.setContentType(e),t.body){const[e,r]=Zt(k,Jt(Qt(h)));s=cr(t.body,65536,e,r)}}dt.isString(v)||(v=v?"include":"omit");const t=i&&"credentials"in r.prototype,c={..._,signal:w,method:a.toUpperCase(),headers:b.normalize().toJSON(),body:s,duplex:"half",credentials:t?v:void 0};S=i&&new r(n,c);let g=await(i?O(S,_):O(n,c));const f=d&&("stream"===y||"response"===y);if(d&&(m||f&&E)){const e={};["status","statusText","headers"].forEach(t=>{e[t]=g[t]});const t=dt.toFiniteNumber(g.headers.get("content-length")),[r,n]=m&&Zt(t,Jt(Qt(m),!0))||[];g=new o(cr(g.body,65536,r,()=>{n&&n(),E&&E()}),e)}y=y||"text";let F=await u[dt.findKey(u,y)||"text"](g,e);return!f&&E&&E(),await new Promise((t,r)=>{qt(t,r,{data:F,headers:Vt.from(g.headers),status:g.status,statusText:g.statusText,config:e,request:S})})}catch(t){if(E&&E(),t&&"TypeError"===t.name&&/Load failed|fetch/i.test(t.message))throw Object.assign(new mt("Network Error",mt.ERR_NETWORK,e,S),{cause:t.cause||t});throw mt.from(t,t&&t.code,e,S)}}},hr=new Map,yr=e=>{let t=e&&e.env||{};const{fetch:r,Request:o,Response:n}=t,i=[o,n,r];let a,s,p=i.length,c=hr;for(;p--;)a=i[p],s=c.get(a),void 0===s&&c.set(a,s=p?new Map:mr(t)),c=s;return s},br=(yr(),{http:null,xhr:ar,fetch:{get:yr}});dt.forEach(br,(e,t)=>{if(e){try{Object.defineProperty(e,"name",{value:t})}catch(e){}Object.defineProperty(e,"adapterName",{value:t})}});const vr=e=>`- ${e}`,_r=e=>dt.isFunction(e)||null===e||!1===e,Or=function(e,t){e=dt.isArray(e)?e:[e];const{length:r}=e;let o,n;const i={};for(let a=0;a<r;a++){let r;if(o=e[a],n=o,!_r(o)&&(n=br[(r=String(o)).toLowerCase()],void 0===n))throw new mt(`Unknown adapter '${r}'`);if(n&&(dt.isFunction(n)||(n=n.get(t))))break;i[r||"#"+a]=n}if(!n){const e=Object.entries(i).map(([e,t])=>`adapter ${e} `+(!1===t?"is not supported by the environment":"is not available in the build"));let t=r?e.length>1?"since :\n"+e.map(vr).join("\n"):" "+vr(e[0]):"as no adapter specified";throw new mt("There is no suitable adapter to dispatch the request "+t,"ERR_NOT_SUPPORT")}return n};function wr(e){if(e.cancelToken&&e.cancelToken.throwIfRequested(),e.signal&&e.signal.aborted)throw new Yt(null,e)}function Sr(e){return wr(e),e.headers=Vt.from(e.headers),e.data=Kt.call(e,e.transformRequest),-1!==["post","put","patch"].indexOf(e.method)&&e.headers.setContentType("application/x-www-form-urlencoded",!1),Or(e.adapter||xt.adapter,e)(e).then(function(t){return wr(e),t.data=Kt.call(e,e.transformResponse,t),t.headers=Vt.from(t.headers),t},function(t){return Xt(t)||(wr(e),t&&t.response&&(t.response.data=Kt.call(e,e.transformResponse,t.response),t.response.headers=Vt.from(t.response.headers))),Promise.reject(t)})}const Er="1.13.2",kr={};["object","boolean","number","function","string","symbol"].forEach((e,t)=>{kr[e]=function(r){return typeof r===e||"a"+(t<1?"n ":" ")+e}});const Fr={};kr.transitional=function(e,t,r){function o(e,t){return"[Axios v"+Er+"] Transitional option '"+e+"'"+t+(r?". "+r:"")}return(r,n,i)=>{if(!1===e)throw new mt(o(n," has been removed"+(t?" in "+t:"")),mt.ERR_DEPRECATED);return t&&!Fr[n]&&(Fr[n]=!0,console.warn(o(n," has been deprecated since v"+t+" and will be removed in the near future"))),!e||e(r,n,i)}},kr.spelling=function(e){return(t,r)=>(console.warn(`${r} is likely a misspelling of ${e}`),!0)};const Mr={assertOptions:function(e,t,r){if("object"!=typeof e)throw new mt("options must be an object",mt.ERR_BAD_OPTION_VALUE);const o=Object.keys(e);let n=o.length;for(;n-- >0;){const i=o[n],a=t[i];if(a){const t=e[i],r=void 0===t||a(t,i,e);if(!0!==r)throw new mt("option "+i+" must be "+r,mt.ERR_BAD_OPTION_VALUE);continue}if(!0!==r)throw new mt("Unknown option "+i,mt.ERR_BAD_OPTION)}},validators:kr},Rr=Mr.validators;class Tr{constructor(e){this.defaults=e||{},this.interceptors={request:new Mt,response:new Mt}}async request(e,t){try{return await this._request(e,t)}catch(e){if(e instanceof Error){let t={};Error.captureStackTrace?Error.captureStackTrace(t):t=new Error;const r=t.stack?t.stack.replace(/^.+\n/,""):"";try{e.stack?r&&!String(e.stack).endsWith(r.replace(/^.+\n.+\n/,""))&&(e.stack+="\n"+r):e.stack=r}catch(e){}}throw e}}_request(e,t){"string"==typeof e?(t=t||{}).url=e:t=e||{},t=nr(this.defaults,t);const{transitional:r,paramsSerializer:o,headers:n}=t;void 0!==r&&Mr.assertOptions(r,{silentJSONParsing:Rr.transitional(Rr.boolean),forcedJSONParsing:Rr.transitional(Rr.boolean),clarifyTimeoutError:Rr.transitional(Rr.boolean)},!1),null!=o&&(dt.isFunction(o)?t.paramsSerializer={serialize:o}:Mr.assertOptions(o,{encode:Rr.function,serialize:Rr.function},!0)),void 0!==t.allowAbsoluteUrls||(void 0!==this.defaults.allowAbsoluteUrls?t.allowAbsoluteUrls=this.defaults.allowAbsoluteUrls:t.allowAbsoluteUrls=!0),Mr.assertOptions(t,{baseUrl:Rr.spelling("baseURL"),withXsrfToken:Rr.spelling("withXSRFToken")},!0),t.method=(t.method||this.defaults.method||"get").toLowerCase();let i=n&&dt.merge(n.common,n[t.method]);n&&dt.forEach(["delete","get","head","post","put","patch","common"],e=>{delete n[e]}),t.headers=Vt.concat(i,n);const a=[];let s=!0;this.interceptors.request.forEach(function(e){"function"==typeof e.runWhen&&!1===e.runWhen(t)||(s=s&&e.synchronous,a.unshift(e.fulfilled,e.rejected))});const p=[];let c;this.interceptors.response.forEach(function(e){p.push(e.fulfilled,e.rejected)});let l,d=0;if(!s){const e=[Sr.bind(this),void 0];for(e.unshift(...a),e.push(...p),l=e.length,c=Promise.resolve(t);d<l;)c=c.then(e[d++],e[d++]);return c}l=a.length;let u=t;for(;d<l;){const e=a[d++],t=a[d++];try{u=e(u)}catch(e){t.call(this,e);break}}try{c=Sr.call(this,u)}catch(e){return Promise.reject(e)}for(d=0,l=p.length;d<l;)c=c.then(p[d++],p[d++]);return c}getUri(e){return Ft(rr((e=nr(this.defaults,e)).baseURL,e.url,e.allowAbsoluteUrls),e.params,e.paramsSerializer)}}dt.forEach(["delete","get","head","options"],function(e){Tr.prototype[e]=function(t,r){return this.request(nr(r||{},{method:e,url:t,data:(r||{}).data}))}}),dt.forEach(["post","put","patch"],function(e){function t(t){return function(r,o,n){return this.request(nr(n||{},{method:e,headers:t?{"Content-Type":"multipart/form-data"}:{},url:r,data:o}))}}Tr.prototype[e]=t(),Tr.prototype[e+"Form"]=t(!0)});const Cr=Tr;class Ar{constructor(e){if("function"!=typeof e)throw new TypeError("executor must be a function.");let t;this.promise=new Promise(function(e){t=e});const r=this;this.promise.then(e=>{if(!r._listeners)return;let t=r._listeners.length;for(;t-- >0;)r._listeners[t](e);r._listeners=null}),this.promise.then=e=>{let t;const o=new Promise(e=>{r.subscribe(e),t=e}).then(e);return o.cancel=function(){r.unsubscribe(t)},o},e(function(e,o,n){r.reason||(r.reason=new Yt(e,o,n),t(r.reason))})}throwIfRequested(){if(this.reason)throw this.reason}subscribe(e){this.reason?e(this.reason):this._listeners?this._listeners.push(e):this._listeners=[e]}unsubscribe(e){if(!this._listeners)return;const t=this._listeners.indexOf(e);-1!==t&&this._listeners.splice(t,1)}toAbortSignal(){const e=new AbortController,t=t=>{e.abort(t)};return this.subscribe(t),e.signal.unsubscribe=()=>this.unsubscribe(t),e.signal}static source(){let e;return{token:new Ar(function(t){e=t}),cancel:e}}}const Br=Ar,Pr={Continue:100,SwitchingProtocols:101,Processing:102,EarlyHints:103,Ok:200,Created:201,Accepted:202,NonAuthoritativeInformation:203,NoContent:204,ResetContent:205,PartialContent:206,MultiStatus:207,AlreadyReported:208,ImUsed:226,MultipleChoices:300,MovedPermanently:301,Found:302,SeeOther:303,NotModified:304,UseProxy:305,Unused:306,TemporaryRedirect:307,PermanentRedirect:308,BadRequest:400,Unauthorized:401,PaymentRequired:402,Forbidden:403,NotFound:404,MethodNotAllowed:405,NotAcceptable:406,ProxyAuthenticationRequired:407,RequestTimeout:408,Conflict:409,Gone:410,LengthRequired:411,PreconditionFailed:412,PayloadTooLarge:413,UriTooLong:414,UnsupportedMediaType:415,RangeNotSatisfiable:416,ExpectationFailed:417,ImATeapot:418,MisdirectedRequest:421,UnprocessableEntity:422,Locked:423,FailedDependency:424,TooEarly:425,UpgradeRequired:426,PreconditionRequired:428,TooManyRequests:429,RequestHeaderFieldsTooLarge:431