import { TBoundingBox } from '../face_detection/types';
import { FaceRotationInfo } from '../face_rotation_serivce';
export type FaceBestshots = {
    frame: ImageBitmap;
    index: number;
    bbox: TBoundingBox;
    videoId: string;
    angles: {
        yaw: number;
        pitch: number;
    };
};
export declare class BestshotsCollector {
    private _initialFaceAngleRotation;
    private _keyframes;
    private _handleEvent;
    get keyframes(): FaceBestshots[];
    awaitRequiredCount(): Promise<void>;
    startCollectingWithoutDetector(): void;
    stopCollectingWithoutDetector(): void;
    startCollecting(initialFaceAngleRotation: FaceRotationInfo): void;
    stopCollecting(): void;
    private _handleRawFrame;
    private _getDataFromEvent;
    private _handleDetectedResult;
    private _getDetectedResultFromEvent;
    private _isCenterAngles;
    private _sortKeyframes;
    private _getAngleDeviation;
    clear(): void;
    private _calculateVerticalNormalizationAngle;
    destroy(): void;
}
