import { ApplicantField, ApplicantFields, CameraSettings, FaceBestshotSettings, FaceBorderAutodetectedModeSettings, FaceDetectorSettings, LivenessTransport, MotionControlSettings, VideoRecordingApi } from './types';
export declare const CONFIGURATOR_SERVICE_SYMBOL: unique symbol;
export declare const APPLICATIONS_FIELDS: ApplicantField[];
export declare const DEFAULT_NETWORK_PATH: string;
export declare const DEFAULT_SHOW_NETWORK_METRICS: boolean;
export declare const DEFAULT_OBTAIN_REFERENCE_FRAME: boolean;
export declare const DEFAULT_FINGERPRINT_WAIT_TIME: number;
export declare const DEFAULT_CHECK_ICE_CANDIDATE_TIMEOUT: number;
export declare const DEFAULT_LIVENESS_TRANSPORT = LivenessTransport.WEB_SOCKET;
export declare const DEFAULT_CLIENT_SERVER_CONNECTION_SETTINGS: {
    videoRecordingApi: VideoRecordingApi;
    videoBitrate: number;
    idealVideoKeyFrameCountPerSecond: number;
    requiredReferenceFrameCount: number;
    referenceFrameQuality: number;
    switchToMediaRecoderApiAsFallback: boolean;
    transmissionWaitTimeout: number;
};
export declare const DEFAULT_TRANSPORT_SETTINGS: {
    iceCandidates: never[];
    clientServerConnectionSettings: {
        videoRecordingApi: VideoRecordingApi;
        videoBitrate: number;
        idealVideoKeyFrameCountPerSecond: number;
        requiredReferenceFrameCount: number;
        referenceFrameQuality: number;
        switchToMediaRecoderApiAsFallback: boolean;
        transmissionWaitTimeout: number;
    };
    showMetrics: boolean;
};
export declare const DISABLED_APPLICANT_FIELDS: ApplicantFields;
export declare const DEFAULT_APPLICANT_FIELDS: ApplicantFields;
export declare const DEFAULT_FACE_DETECTOR_SETTINGS: FaceDetectorSettings;
export declare const DEFAULT_CAMERA_SETTINGS: CameraSettings;
export declare const DEFAULT_FACE_BORDDER_AUTO_DETECTED: FaceBorderAutodetectedModeSettings;
export declare const DEFAULT_FACE_BESTSHOT_SETTINGS: FaceBestshotSettings;
export declare const DEFAULT_MOTION_CONTROL_SETTINGS: MotionControlSettings;
