import { Point3D } from '../../shared';
export type TTensolflowManagerConfig = {
    networksPath: string;
    isDisable: boolean;
};
export type DetectionResult = {
    frame: ImageBitmap;
    frameIndex: number | undefined;
    face: TBoundingBox | undefined;
    keypoints: Point3D[] | undefined;
    normalizedKeypoints: Point3D[] | undefined;
    videoId: string;
};
export type TBoundingBox = {
    xMin: number;
    yMin: number;
    xMax: number;
    yMax: number;
    width: number;
    height: number;
};
