import { Resolution } from '../../configurator';
import { TBoundingBox } from '../../face_detection/types';
import { FaceBorderAllowableAccuracyError, FacePositionCircleData } from './face_position.types';
export declare abstract class FacePosition {
    protected _cameraResolution: Resolution;
    protected _previewResolution: Resolution;
    private _videoModeType;
    protected _scalingCoefficient: number;
    protected _normalizationCoefficients: {
        x: number;
        y: number;
    };
    protected _offset: {
        x: number;
        y: number;
    };
    protected _result: FacePositionCircleData | undefined;
    protected _calculatingDataForLastResult: {
        cameraResolution: Resolution;
        previewResolution: Resolution;
        scalingCoefficient: number;
    } | undefined;
    abstract calculateFaceBorder(): void;
    constructor({ scalingCoefficient, cameraResolution, previewResolution, videoModeType, }?: {
        scalingCoefficient?: number;
        cameraResolution?: Resolution;
        previewResolution?: Resolution;
        videoModeType?: 'cover' | 'contain' | 'auto';
    });
    getNormalizationCoefficients(): {
        x: number;
        y: number;
    };
    getCameraResolution(): Resolution;
    getPreviewResolution(): Resolution;
    getOffset(): {
        x: number;
        y: number;
    };
    getFaceBorderData(): FacePositionCircleData;
    updateCameraResolution(cameraResolution: Resolution): void;
    updatePreviewResolution(previewResolution: Resolution): void;
    updateScalingCoefficient(scalingCoefficient: number): void;
    protected checkThatStreamResolutionExist(): void;
    protected checkThatCalculationDataIsOutOfDate(): true | undefined;
    protected calculateNormalizationCofficients(): void;
    checkThatFaceInCenterOfRegion(bbox: TBoundingBox, allowableAccuracyError: FaceBorderAllowableAccuracyError): {
        isValid: boolean;
        message: string | undefined;
    };
    checkIsFaceSizeCorrect(bbox: TBoundingBox, allowableAccuracyError: FaceBorderAllowableAccuracyError): {
        isValid: boolean;
        message: string;
        score?: undefined;
    } | {
        isValid: boolean;
        message: string | undefined;
        score: number;
    };
    destroy(): void;
}
