import { Point3D } from '../../shared';
import { AngleСalculationSettings } from '../configurator';
export type FaceRotationInfo = {
    currentHorizontalRotation: undefined | 'left' | 'right' | 'center';
    currentVerticalRotation: undefined | 'up' | 'down' | 'center';
    angles: {
        pitch: undefined | number;
        yaw: undefined | number;
        roll: undefined | number;
    };
};
export default class FaceRotationService {
    private _setting;
    constructor(setting: AngleСalculationSettings);
    defineRotationAnglesBy3dKeypoints(keypoints: Point3D[], verticalNormalizationAngle?: number): FaceRotationInfo;
    caclulateAngles(keypoints: {
        x: number;
        y: number;
        z: number;
    }[], verticalNormalizationAngle?: number): {
        yaw: number;
        pitch: number;
        roll: number;
    };
}
