import { FaceBorderSettings } from '../configurator';
import { DetectionResult } from '../face_detection/types';
import { FacePosition } from '../face_position';
import { FaceRotationInfo } from '../face_rotation_serivce';
export type InitialFacePositionIdentificationProps = {
    configuration: FaceBorderSettings;
    facePosition?: FacePosition;
};
export declare class InitialFacePositionIdentification {
    private _initialFace;
    private _initialFaceRotation;
    private _faceKeypoints;
    private _streamSettings;
    private _isHandleDetection;
    private _configuration;
    private _facePosition?;
    private _frameCounter;
    constructor(props: InitialFacePositionIdentificationProps);
    get initialFacePosition(): DetectionResult | undefined;
    get initialFaceRotationAngles(): FaceRotationInfo | undefined;
    destroy(): void;
    setStreamSettings(value: MediaTrackSettings): void;
    identifyFacePosition(): Promise<void>;
    private _handleFacePosition;
    private _getDetectedResultFromEvent;
    private _resetData;
    private _calculateProgress;
    private _haskKeypointsDeviationForNewDetectedFace;
    private _calculateDistanceBetweenTwoPoints;
    private _isNoDetectedFace;
    private _isDetectedFaceTooSmall;
    private _isDetectedFaceTooBig;
    private _isDetectedFaceoffscreen;
    private _isDetectedFaceOutsideFaceBorder;
    private _createCurrentProgressEvent;
}
