import { WebComponentError } from '../../shared';
import { Camera } from '../camera';
import { ComponentConfiguration } from '../configurator';
import { Inspection, VideoCodec, VideoContainer } from './const';
export type InspectionsTransportProps = {
    configuration: ComponentConfiguration;
    endeavorId: string;
    camera: Camera;
};
export declare abstract class InspectionsTransport {
    protected _configuration: ComponentConfiguration;
    protected _endeavorId: string;
    protected _lastAnswer?: string;
    protected _error?: WebComponentError;
    _history: Array<string>;
    protected _camera: Camera;
    get error(): WebComponentError | undefined;
    get lastAnswer(): string | undefined;
    constructor(props: InspectionsTransportProps);
    abstract openConnection(): Promise<void>;
    abstract isOpenConnection(): boolean;
    abstract sendStartRecordSignal(data: {
        videoId: string;
        type: Inspection;
        container: VideoContainer;
        codec: VideoCodec;
        fps?: number;
        bitrate?: number;
        pixel_format?: string;
        resoulution?: {
            width: number;
            height: number;
        };
    }): void;
    abstract sendStartBestshotsTransmissionSignal(videoId?: string): void;
    abstract sendSaveRecordSignal(): void;
    abstract sendStopRecordSignal(): void;
    abstract sendResetRecordSignal(): void;
    abstract checkThatConnectionIsOpen(): void;
    abstract closeConnection(): void;
    abstract sendMessage(data: string | ArrayBuffer | Uint8Array): void;
    abstract getNetworkMetrics(): unknown;
    abstract sendTypeOfSupply(type: string): unknown;
    saveMotionControlResult(motionControlResult: object): void;
    awaitResponse(): Promise<void>;
}
