import { Inspection, VideoCodec, VideoContainer } from '../const';
import { InspectionsTransport, InspectionsTransportProps } from '../inspections_transport';
export default class InspectionWebRtcTransport extends InspectionsTransport {
    private pc?;
    private dc?;
    private credentials?;
    private _isSendingBestshot;
    constructor(props: InspectionsTransportProps);
    openConnection(): Promise<void>;
    private createPeerConnection;
    private getCredentials;
    private getConfigsForRTCPeerConnection;
    private filterPeerConnections;
    private checkThatIceCandidateIsAcitive;
    attachStream(peerCoonection: RTCPeerConnection): Promise<void>;
    sendTypeOfSupply(type: string): void;
    sendStartRecordSignal({ videoId, type, container, codec, }: {
        videoId: string;
        type: Inspection;
        container: VideoContainer;
        codec: VideoCodec;
    }): void;
    sendSaveRecordSignal(): void;
    sendStopRecordSignal(): void;
    sendResetRecordSignal(): void;
    sendMessage(data: string | ArrayBuffer | Uint8Array): void;
    getNetworkMetrics(): Promise<{
        bitrate: number;
        frameRate: number;
    }>;
    closeConnection(): Promise<void>;
    private checkThatRTCPeerConnectionExist;
    private checkThatRTCDataChannelExist;
    checkThatConnectionIsOpen(): void;
    isOpenConnection(): boolean;
    sendStartBestshotsTransmissionSignal(videoId?: string): void;
}
