import { Inspection, VideoCodec, VideoContainer } from '../const';
import { InspectionsTransport, InspectionsTransportProps } from '../inspections_transport';
export default class InspectionsWebSocketTransport extends InspectionsTransport {
    private _websocket;
    private _isConnected;
    constructor(props: InspectionsTransportProps);
    openConnection(): Promise<void>;
    private sendToken;
    sendTypeOfSupply(type: 'chunks' | 'packets'): void;
    sendStartRecordSignal({ videoId, type, container, codec, fps, bitrate, pixel_format, resoulution, }: {
        videoId: string;
        type: Inspection;
        container: VideoContainer;
        codec: VideoCodec;
        fps: number;
        bitrate: number;
        pixel_format: string;
        resoulution: {
            width: number;
            height: number;
        };
    }): void;
    sendStartBestshotsTransmissionSignal(videoId?: string): void;
    sendSaveRecordSignal(): void;
    sendStopRecordSignal(): void;
    sendResetRecordSignal(): void;
    sendMessage(data: string | Uint8Array): void;
    checkThatConnectionIsOpen(): void;
    isOpenConnection(): boolean;
    closeConnection(): void;
    getNetworkMetrics(): undefined;
}
