import { Log, LogLevel } from './types';
export default abstract class LoggingService {
    integrationId: string | null;
    applicantId: string | null;
    attemptId: string | null;
    endeavorId: string | null;
    deviceId: string | null;
    protected _logs: Log[];
    abstract addDebugLog(message: string): void;
    abstract addInfoLog(message: string): void;
    abstract addWarningLog(message: string): void;
    abstract addErrorLog(message: string): void;
    abstract addCriticalErrorLog(message: string): void;
    abstract flush(): void;
    clear(): void;
    destroy(): void;
    protected createLog(message: string, level: LogLevel): {
        date: string;
        message: string;
        level: LogLevel;
    };
}
