export type Log = {
    date: string;
    message: string;
    level: LogLevel;
};
export type LogLevel = 'critical' | 'error' | 'warning' | 'info' | 'debug';
export declare enum LoggingServiceTypes {
    SERVER_WEBSCOKET = 0,
    SERVER_HTTP = 1,
    BROWSER_CONSOLE = 2
}
export type Logs = {
    deviceId?: string;
    integrationId: string;
    applicantId?: string;
    endeavorId?: string;
    attemptId?: string;
    logs: Log[];
};
export type LoggerMetadataKeys = keyof Omit<Logs, 'logs'>;
export type LoggerDataTypes = keyof Logs;
