import { ComponentConfiguration, MotionControlActions } from '../configurator';
import { FacePosition } from '../face_position';
import { FaceRotationInfo } from '../face_rotation_serivce';
type MotionControlFacePositionValidatorProps = {
    configuration: ComponentConfiguration;
    initialFaceAngleRotation: FaceRotationInfo;
    facePosition: FacePosition;
};
export declare class MotionControlFacePositionValidator {
    private _configuration;
    private _initialFaceAngleRotation;
    private _facePosition;
    private _timeoutId;
    private _isRunning;
    private _currentFace;
    private _handleDetectedFaceEvent;
    constructor(props: MotionControlFacePositionValidatorProps);
    validateFacePositionForCommand(command: MotionControlActions | 'return', throwError?: boolean): Promise<boolean | undefined>;
    private _handleDetectedFace;
    private _getDetectedResultFromEvent;
    private _calculateVerticalNormalizationAngle;
    private _runFaceValidationForCommand;
    private _runCycleOfCheckingFacePositionForCommand;
    private _getValidatorFunctionForCommand;
    private _generateValidationEvent;
    private _checkAngleTurningHeadToRight;
    private _checkAngleTurningHeadToLeft;
    private _checkAngleTurningHeadToUp;
    private _checkThatFaceHasRequiredSizeAndNoRotated;
    private _isValidFacePosition;
    private _isValidFaceSize;
    private _hasDetectedFace;
    private _stopRunningCycleByTimeout;
    private _stopCycle;
}
export {};
