import { WebComponentError } from './web_component_error';
export declare class TransmissionTimeoutError extends WebComponentError {
    static readonly ERROR_NAME = "TransmissionTimeoutError";
    readonly code = "1400023";
    constructor(message?: string);
}
export declare class InvalidFacesAmountOnFrameError extends WebComponentError {
    static readonly ERROR_NAME = "InvalidFacesAmountOnFrameError";
    readonly code = "120060";
    constructor(message?: string);
}
export declare class InvalidMessageFormatError extends WebComponentError {
    static readonly ERROR_NAME = "InvalidMessageFormatError";
    readonly code = "1120001";
    constructor(message?: string);
}
export declare class NotSupportedApiError extends WebComponentError {
    static readonly ERROR_NAME = "NotSupportedApiError";
    readonly code = "1400007";
    constructor(message?: string);
}
export declare class CameraFpsNotDefinedError extends WebComponentError {
    static readonly ERROR_NAME = "CameraFpsNotDefinedError";
    readonly code = "1400022";
    constructor(message?: string);
}
export declare class CameraResolutionNotDefinedError extends WebComponentError {
    static readonly ERROR_NAME = "CameraResolutionNotDefinedError";
    readonly code = "14000025";
    constructor(message?: string);
}
export declare class VideoStreamResolutionIsUndefinedError extends WebComponentError {
    static readonly ERROR_NAME = "VideoStreamResolutionIsUndefinedError";
    readonly code = "1400012";
    constructor(message?: string);
}
export declare class InvalidVideoStreamResolutionValueError extends WebComponentError {
    static readonly ERROR_NAME = "InvalidVideoStreamResolutionValueError";
    readonly code = "1400013";
    constructor(message?: string);
}
export declare class InvalidVideoPreviewResolutionValueError extends WebComponentError {
    static readonly ERROR_NAME = "InvalidVideoPreviewResolutionValueError";
    readonly code = "1400013";
    constructor(message?: string);
}
export declare class ApplicantBlockedError extends WebComponentError {
    static readonly ERROR_NAME = "ApplicantBlockedError";
    readonly code = "1150005";
    constructor(message?: string);
}
