import { CameraPreview, ContentLayout, FaceKeypointsMask, FacePositionCircle, Preloader, RelativeContainer, TextHints } from '../../../ui';
import BaseView from '../../../web_component.view';
import { MotionControlImagesHints } from './ui';
import MotionControlArrows from './ui/motion_control_arrows/class';
export default class View {
    readonly baseView: BaseView;
    readonly contentLayout: ContentLayout;
    readonly cameraPreview: CameraPreview;
    readonly textHints: TextHints;
    readonly preloader: Preloader;
    readonly faceKeypointMask: FaceKeypointsMask;
    readonly facePositionCircle: FacePositionCircle;
    readonly relativeContainer: RelativeContainer;
    readonly directionArrowHint: MotionControlArrows;
    readonly directionGifHint: MotionControlImagesHints;
    constructor(baseView: BaseView);
    renderCameraPreview(): void;
    renderFacePositionCircle(): void;
    renderFaceKeypointMask(): void;
    setSourceForCameraPreview(source: MediaStream): Promise<void>;
    renderPreloader(): void;
    removePreloader(): void;
    stopPreview(): void;
    renderTextHint(): void;
    removeTextHint(): void;
    destroy(): void;
}
