import { FacePositionCircleData } from '../../../../../services/face_position';
import { MotionControlPattern } from '../../../types';
import './style.css';
export default class MotionControlArrows {
    private _currentAction;
    readonly leftArrows: HTMLDivElement;
    readonly rightArrows: HTMLDivElement;
    readonly upArrows: HTMLDivElement;
    readonly downArrows: HTMLDivElement;
    private _facePositionCircleData;
    private _offset;
    constructor({ facePosition, offset, }?: {
        facePosition?: FacePositionCircleData;
        offset?: {
            x: number;
            y: number;
        };
    });
    setCommand(command: MotionControlPattern | 'return'): void;
    setFacePosition(facePosition: FacePositionCircleData): void;
    setOffset(offset: {
        x: number;
        y: number;
    }): void;
    renderCommandArrows(): void;
    renderScore(score: number): void;
    resetScore(): void;
    private inactiveArrow;
    private fillArrows;
    private renderArrowsToLeftOfFacePositionBorder;
    private renderArrowsToRightOfFacePositionBorder;
    private renderArrowsToUpOfFacePositionBorder;
    private renderArrowsToDownOfFacePositionBorder;
    removeArrows(): void;
    destroy(): void;
}
