import { Button, CameraPreview, ContentLayout, Preloader, RelativeContainer, TextHints } from '../../../ui';
import BaseView from '../../../web_component.view';
import { CameraSelector } from './camera_selector';
import { OptionsProps } from './camera_selector/class';
export default class View {
    readonly baseView: BaseView;
    readonly contentLayout: ContentLayout;
    readonly cameraSelector: CameraSelector;
    readonly cameraPreview: CameraPreview;
    readonly textHints: TextHints;
    readonly continueButton: Button;
    readonly backButton: Button;
    readonly preloader: Preloader;
    readonly relativeContainer: RelativeContainer;
    constructor(baseView: BaseView);
    renderCameraPreview(): void;
    setSourceForCameraPreview(source: MediaStream): Promise<void>;
    renderPreloader(): void;
    removePreloader(): void;
    stopPreview(): void;
    renderSelector(): void;
    addSelectorOptions(optionsData: OptionsProps[]): void;
    onChangeCamera(fn: (event: Event) => void): void;
    removeOptions(): void;
    renderContinueButton(): void;
    onClickContinueButton(fn: () => void): void;
    renderBackButton(): void;
    onClickBackButton(fn: () => void): void;
    renderTextHint(): void;
    removeTextHint(): void;
    destroy(): void;
}
