import { ApplicantField, ApplicantFields } from '../../../services/configurator';
import { FlowMode } from '../../../shared';
export default class ValidateApplicantStatusModel {
    private _applicantId;
    private _applicantStatus;
    private _primaryKey;
    private _fieldsData;
    private _enabledFields;
    constructor(fields: ApplicantFields, applicantId?: string);
    private _findEnabledPrimaryField;
    private _initValueForEnabledFields;
    private _getEnabledFieldsKeys;
    setFieldValue(fieldName: ApplicantField, value: string): void;
    getFieldValue(fieldName: ApplicantField): string | undefined;
    get primaryKey(): ApplicantField;
    get applicantId(): Readonly<string>;
    get applicantStatus(): number;
    get enabledFields(): ReadonlyArray<ApplicantField>;
    validateField(fieldName: ApplicantField): Promise<{
        valid: boolean;
        error?: string;
    }>;
    identifyApplicantByPrimaryField(mode: FlowMode): Promise<void>;
    identifyApplicantById(mode: FlowMode): Promise<void>;
    validateApplicantStatus(mode: FlowMode): void;
    private _generateErrorByApplicantStatusForAuthorizationMode;
    private _generateErrorByApplicantStatusForRegistrationMode;
    createApplicant(): Promise<import("axios").AxiosResponse<import("tdvc").TCreateApplicantResult, any, {}>> | undefined;
}
