import './style.css';
export type FormFieldProps = {
    id: string;
    labelText: string;
    type: string;
    value: string;
};
export default class FormField {
    readonly root: HTMLDivElement;
    readonly label: HTMLLabelElement;
    readonly inputWrapper: HTMLDivElement;
    readonly input: HTMLInputElement;
    readonly icon: HTMLDivElement;
    readonly errorMessage: HTMLParagraphElement;
    readonly fieldId: string;
    constructor(props: FormFieldProps);
    private _createContainer;
    private _createLabel;
    private _createInputWrapper;
    private _createIcon;
    onInput(fn: (event: Event) => void): void;
    onBlur(fn: (event: Event) => void): void;
    private _createInput;
    private _createErrorMessage;
    setError(errorKey: string): void;
    removeError(): void;
    destroy(): void;
}
