import { Resolution } from '../../../services/configurator';
import { Point3D } from '../../../shared';
import './style.css';
export default class FaceKeypointsMask {
    readonly root: HTMLCanvasElement;
    private _keypoints;
    private _isRendering;
    private _normalizationCoefficients;
    private _handleTdvFaceDetected;
    private _offset;
    constructor();
    setPointOffset(offset: {
        x: number;
        y: number;
    }): void;
    setKeypoints(points: Point3D[][]): void;
    setNormalizationCoefficients(normalizationCoefficients: {
        x: number;
        y: number;
    }): void;
    startHandleDetection(): void;
    stopHandleDetection(): void;
    clear(): void;
    destroy(): void;
    private _drawMask;
    private _renderMask;
    private _getDetectedResultFromEvent;
    private _clearCanvas;
    updateCanvasResolution({ width, height }: Resolution): void;
    private _checkThatCanvasExist;
    private _getCanvas2DContext;
}
