import { Camera } from './services/camera';
import { InspectionsTransport } from './services/inspections_transport';
import { FlowMode } from './shared';
export default class Model {
    private _mode;
    private _applicantId;
    private _fingerprint;
    private _endeavorId;
    private _attemptId;
    private _transport;
    constructor(flow: FlowMode);
    get mode(): FlowMode;
    get endeavorId(): string | undefined;
    get attemptId(): number | undefined;
    set applicantId(value: string);
    get applicantId(): string;
    createEndeavorId(): Promise<void>;
    createAttempt(): Promise<void>;
    createFingerprint(cameraService: Camera): Promise<void>;
    createDeviceId(): void;
    private _generateDeviceIdIfNotExistInLocaleStorage;
    private _logDeviceUUID;
    createInspectionTransport(): void;
    openConnection(): Promise<void>;
    closeConnection(): void;
    get transport(): InspectionsTransport;
}
