import { TAPIComponentConfig, TApplicant, TCreateApplicantResult, TEndeavor, TGetApplicantsList, TValidateApplicantResult } from '../types';
type TAPIConfig = {
    baseUrl: string;
    integrationId: string;
    platformToken?: string;
    videoRecorderToken?: string;
    accountId: string;
};
export default class API {
    private baseUrl;
    private SECRET_HEADERS;
    private HEADER_VARIANTS;
    private TOKENS_VARIANT;
    private VIDEO_RECORDER_HEADERS;
    constructor(config: TAPIConfig);
    private post;
    private get;
    private checkTokens;
    getServerConfig(): Promise<TAPIComponentConfig>;
    getApplicantByFilter(value: string): Promise<import("axios").AxiosResponse<TGetApplicantsList, any>>;
    getApplicantByID(applicantId: string): Promise<import("axios").AxiosResponse<TApplicant, any>>;
    createApplicant(data: [string, FormDataEntryValue][]): Promise<import("axios").AxiosResponse<TCreateApplicantResult, any>>;
    createAttempt(applicantId: string, endeavorId: string, fingerprint: object): Promise<import("axios").AxiosResponse<{
        attemptId: number;
    }, any>>;
    validateApplicant(applicantId: string, attemptId?: string, customSettings?: unknown): Promise<import("axios").AxiosResponse<TValidateApplicantResult, any>>;
    getLRSOffer(offer: RTCSessionDescription | undefined | null, endeavorId: string, signal?: AbortSignal): Promise<import("axios").AxiosResponse<RTCSessionDescriptionInit, any>>;
    getLRSEndeavor(applicantId: string): Promise<import("axios").AxiosResponse<TEndeavor, any>>;
    getLRSCredentials(): Promise<import("axios").AxiosResponse<string, any>>;
    getRNDActionPatter(): Promise<import("axios").AxiosResponse<{
        ptr: ("up" | "left" | "right" | "closer" | "farther")[];
    }, any>>;
    saveLivenessReflectionResult(endeavorId: string, video: Blob, image: Blob): Promise<import("axios").AxiosResponse<string, any>>;
    saveLivenessActiveResult(endeavorId: string, video: Blob, image: Blob, motionInfo: string): Promise<import("axios").AxiosResponse<string, any>>;
}
export {};
