type TQAA = {
    pitch: number;
    roll: number;
    yaw: number;
    backgroundUniformityScore: number;
    dynamicRangeScore: number;
    eyesDistance: number;
    hasWatermark: boolean;
    illuminationScore: number;
    isBackgroundUniform: boolean;
    isDynamicRangeAcceptable: boolean;
    isEvenlyIlluminated: boolean;
    isEyesDistanceAcceptable: boolean;
    isLeftEyeOpened: boolean;
    isMarginsAcceptable: boolean;
    isNeutralEmotion: boolean;
    isNotNoisy: boolean;
    isRightEyeOpened: boolean;
    isRotationAcceptable: boolean;
    isSharp: boolean;
    leftEyeOpennessScore: number;
    marginInnerDeviation: number;
    marginOuterDeviation: number;
    maxRotationDeviation: number;
    neutralEmotionScore: number;
    noFlare: boolean;
    noiseScore: boolean;
    notMasked: boolean;
    notMaskedScore: number;
    rightEyeOpennessScore: number;
    sharpnessScore: number;
    totalScore: number;
    watermarkScore: number;
};
type TObject = {
    bbox: number[];
    quality: TQAA;
    age: number;
    confidence: number;
    class: string;
    gender: string;
    emotions: {
        confidence: number;
        emotion: string;
    };
    has_medical_mask: {
        confidence: number;
        value: boolean;
    };
    liveness: {
        confidence: number;
        message: string;
        value: string;
    };
    pose: {
        pitch: number;
        roll: number;
        yaw: number;
    };
    template: {
        _face_template_extractor_1000_12: {
            format: string;
            blob: string;
            dtype: string;
            shape: number[];
        };
    };
    keypoints: object;
};
type TGraphQLError = {
    message: string;
};
export type TProcessImageFields = ('age' | 'bbox' | 'class' | 'confidence' | 'emotions' | 'gender' | 'has_medical_mask' | 'keypoints' | 'liveness' | 'pose' | 'template' | 'quality')[];
export type TProcessImageResult = {
    data: {
        processImage: {
            objects: TObject[];
        };
    };
    errors?: TGraphQLError[];
};
export {};
