export type TValidateApplicantResult = AttemptValidation & {
    applicantId: string;
    attemptId: number;
    documentType: number;
    document: null;
    attemptsCount: number;
    attemptsLeft: number;
    status: number;
    validationStatus: TValidationStatus;
    invalidDataErrors: InvalidDataError[];
    faceSuccess: boolean;
    documentSuccess: null;
    documentHasNotExpired: null;
    documentValidationTests: [];
    callBackUrl: string | null;
    hasRiskEvents: boolean;
};
export type InvalidDataError = {
    code: string | null;
    message: string | null;
    description: string | null;
};
export type TValidationStatus = {
    expired: null;
    documentIsValid: null;
    faceIsValid?: boolean;
    antiSpoofingIsValid?: boolean;
    profileAlreadyExists?: boolean;
    qualityIsValid: boolean;
    livenessReflectionIsValid: boolean;
    lrCrossMatchIsValid?: boolean;
    mcCrossMatchIsValid?: boolean;
    hasBeenBlackListed: boolean;
};
export type AttemptValidation = {
    validations: {
        liveness: AttemptLiveness;
        quality: AttemptQuality;
        matching: AttemptMatching;
        motionControl: AttemptMotionControl;
    };
};
export type AttemptLiveness = {
    verdict: boolean;
    details: null | LivenessDetail[];
};
export type LivenessDetail = AttemptValidationDetail & {
    name: LivenessDetailNames;
};
export type LivenessDetailNames = 'FaceLiveness' | 'DeepFake';
export type AttemptQuality = {
    verdict: boolean;
    details: null | QualityDetail[];
};
export type QualityDetail = AttemptValidationDetail & {
    name: QualityDetailNames;
};
export type QualityDetailNames = 'FaceQuality';
export type AttemptMatching = {
    verdict: boolean;
    details: null | MatchingDetail[];
};
export type MatchingDetail = AttemptValidationDetail & {
    name: MatchingDetailNames;
};
export type MatchingDetailNames = 'FaceMatching';
export type AttemptMotionControl = {
    verdict: boolean | null;
    motionControlInfo: null | MotionControlDetail[];
};
export type MotionControlDetail = {
    result: boolean;
    pattern: MotionControlPattern;
};
export type MotionControlPattern = 'left' | 'right' | 'up' | 'closer' | 'farther';
export type AttemptValidationDetail = {
    name: string;
    verdict: boolean | null | undefined;
    score: number | null | undefined;
};
